#include "ti86asm.inc"
#include "data.inc"	;Symbol table

TEXT_MEM3 = _plotSScreen
TEXT_MEM32 = _plotSScreen+200

TempLine = TEXT_MEM3+1
PicCoor = TEXT_MEM3+20
offset = TEXT_MEM3+22
NASR_Status = TEXT_MEM3+23
KURAICOUNTER = TEXT_MEM3+24
ENEMYCOUNTER1 = TEXT_MEM3+25
OK = TEXT_MEM3+27
BKX = TEXT_MEM3+61
BKY = TEXT_MEM3+62
WHICHENEMY = TEXT_MEM3+30
NUMBEROFENEMIES = TEXT_MEM3+31
ENEMYHP1 = TEXT_MEM3+32
ENEMYHP2 = TEXT_MEM3+34
ENEMYHP3 = TEXT_MEM3+36
ENEMYST1 = TEXT_MEM3+38
ENEMYST2 = TEXT_MEM3+40
ENEMYST3 = TEXT_MEM3+42
ENEMYSPEED1 = TEXT_MEM3+44
ENEMYSPEED2 = TEXT_MEM3+46
ENEMYSPEED3 = TEXT_MEM3+48
ENEMYCOUNTER2 = TEXT_MEM3+49
DUMMY1 = TEXT_MEM3+51
DUMMY2 = TEXT_MEM3+52
ENEMYBACK1 = TEXT_MEM3+55
ENEMYBACK2 = TEXT_MEM3+57
ENEMYBACK3 = TEXT_MEM3+59
Save = TEXT_MEM3+63
COUNTER = TEXT_MEM3+65
MAXDEFENSE = TEXT_MEM3+66
REGENCHECK = TEXT_MEM3
XPGAINED = TEXT_MEM32+70
ENEMYDFD1 = TEXT_MEM32+64
ENEMYDFD2 = TEXT_MEM32+66
ENEMYDFD3 = TEXT_MEM32+68	

MAPVAR = TEXT_MEM32+60
STRENGTHMAX = TEXT_MEM32+78
BUILDUP = TEXT_MEM32+74
RELIFE = TEXT_MEM32+75
DEFENSEMAX = TEXT_MEM32+76
LEADERCHECK = TEXT_MEM32+80

;;Save VARS

TOLEVEL = TEXT_MEM32+82
HP = TEXT_MEM32+84 
MP = TEXT_MEM32+86
XP = TEXT_MEM32+88
GOLD = TEXT_MEM32+90
MAXHP = TEXT_MEM32+92
STRENGTH = TEXT_MEM32+94
KURAILEVEL = TEXT_MEM32+96
MAXMP = TEXT_MEM32+98
SPEED = TEXT_MEM32+100
INTELLIGENCE = TEXT_MEM32+102
WEAPON = TEXT_MEM32+104
DEFENSE = TEXT_MEM32+106
DUNGEONCHECK = TEXT_MEM32+108

SCENARIO = TEXT_MEM3+108
ENEMYCOUNTER3 = TEXT_MEM3+109
DOUBLE = TEXT_MEM32+110

BMPLOC = TEXT_MEM3+68 
MAPINDEX = TEXT_MEM3+70 
MAPSTART = TEXT_MEM3+72 
VIDINDEX = TEXT_MEM3+74 
WHEREAT = TEXT_MEM3+76 
STANDING = TEXT_MEM3+78 
COUNT = TEXT_MEM3+90
X = TEXT_MEM3+91 
Y = TEXT_MEM3+92 
OLDX = TEXT_MEM3+84 
OLDWHERE = TEXT_MEM3+86

data = TEXT_MEM3+120

.org _asm_exec_ram

	bit 2,(iy+31)
	jp z,$416c

ProgStart:

;---------Battle Engine------------;
;
;INITBATTLE:
;	ld a,(DUNGEONCHECK)
;	cp -1
;	jr z,RESTARTBATTLE
;	cp 8
;	jp nc,KEYLOOP

	ld a,(_asm_reg_a)
	or a
	jr z,RESTARTBATTLE
	cp 1
	jp z,LEADER1
	cp 2
	jp z,LEADER2
	cp 3
	jp z,LEADER3
	cp 4
	jp z,LEADER4
	cp 5
	jp z,LEADER5
	cp 6
	jp z,LEADER6
	cp 7
	jp z,LEADER7
	cp 8
	jp z,GIMPMAN
	cp 9
	jp z,LEADER1TOWN
	cp 10
	jp nz,RESTARTBATTLE
	ld hl,172
	jp LEVELUP

RESTARTBATTLE:
	ld b,3
INITLOOP:
	push bc
	call INVERTSCREEN
	call DELAY2
	pop bc
	djnz INITLOOP
INITBATTLELOOP:
  ld a,r
  srl a
  and 3          ; between 0-3
  ld (NUMBEROFENEMIES),a
  or a
  jr z,INITBATTLELOOP
	push af	
	call DRAWWALLS        	
FROMLEADER:
	ld hl,0
	ld (ENEMYSPEED2),hl
	ld (ENEMYSPEED3),hl
	ld (XPGAINED),hl
	ld a,(LEADERCHECK)
	or a
	jr nz,ITSALEADER
;-----------------------------------skip this if it's a leader;
FROMRIGGED2:
	call PUTENEMY
  	pop af
	ld (NUMBEROFENEMIES),a
;-------------------------------------------------------------;
ITSALEADER:
	ld hl,(STRENGTH)
	ld (STRENGTHMAX),hl
	ld hl,(DEFENSE)
	ld (DEFENSEMAX),hl
	ld hl,(SPEED)
	ld de,200
	and a
	sbc hl,de
	jr c,NODOUBLE
DOUBLESPEED:
	ld a,66
	ld (DOUBLE),a
NODOUBLE:
	xor a
	ld (RELIFE),a
	ld (BUILDUP),a
	ld (REGENCHECK),a
	ld (COUNTER),a
	ld (OK),a
	ld (ENEMYCOUNTER1),a
	ld (ENEMYCOUNTER2),a
	ld (ENEMYCOUNTER3),a
	ld a,66
	ld (KURAICOUNTER),a
	call KURAI
	call BATTLEMENU
	jr SPEEDLOOP
IRIGHT:
	ld a,(BKX)
	cp 84
	jr z,SPEEDLOOP
	ld hl,ICONRING
	call drawit
	ld a,(BKX)
	add a,9
	ld (BKX),a
	ld hl,ICONRING
	call drawit
	call DELAY2
	jr SPEEDLOOP
ILEFT:
	ld a,(BKX)
	cp 66
	jr z,SPEEDLOOP
	ld hl,ICONRING
	call drawit
	ld a,(BKX)
	sub 9
	ld (BKX),a
	ld hl,ICONRING
	call drawit
	call DELAY2
SPEEDLOOP:
 	ld a,$3E
 	out (1),a
 	in a,(1)
	bit 5,a ; 2ND
 	jp z,IPRESS
	bit 3,a
 	jp z,IUP
 	bit 0,a
 	jp z,IDOWN
        	bit 1,a
        	jr z,ILEFT
        	bit 2,a
        	jr z,IRIGHT

	ld a,(OK)
	or a
	jr nz,SPEEDLOOP

	  ;; Now check ENEMYS' COUNTERS
	  ;; when ENEMYCOUNTER == ENEMYSPEED th
	  ;; attack...hence,lower value=faster attack

	ld a,(ENEMYSPEED1)
	or a
	jr z,NEXTENEMY
	ld c,a
	ld a,(ENEMYCOUNTER1)
	inc a
	ld (ENEMYCOUNTER1),a
	cp c
	jp z,ENEMYATTK1
NEXTENEMY:	
	ld a,(ENEMYSPEED2)
	or a
	jr z,NEXTENEMY2
	ld c,a
	ld a,(ENEMYCOUNTER2)
	inc a
	ld (ENEMYCOUNTER2),a
	cp c
	jp z,ENEMYATTK2
NEXTENEMY2:	
	ld a,(ENEMYSPEED3)
	or a
	jr z,COUNTERKURAI
	ld c,a
	ld a,(ENEMYCOUNTER3)
	inc a
	ld (ENEMYCOUNTER3),a
	cp c
	jp z,ENEMYATTK3
COUNTERKURAI:
	;; Draw Kurai's COUNTER
	ld a,(KURAICOUNTER)
	ld b,a
	ld c,25
	call PutPixel
	ld a,(KURAICOUNTER)
	ld b,a
	ld c,24
	call PutPixel	

	;;CHECK KURAI'S COUNTER
	ld a,(KURAICOUNTER)
	inc a
	push af
	ld a,(DOUBLE)
	cp 66
	jr z,DOUBLEIT
	pop af		
	ld (KURAICOUNTER),a
	cp 92
	jp nz, SPEEDLOOP  ;; KEEP GOING TILL 92
ITSOK2:
	ld a,1
	ld (OK),a
	jp SPEEDLOOP
DOUBLEIT:
	pop af
	inc a
	ld (KURAICOUNTER),a
	cp 92	
	jp nz, SPEEDLOOP  ;; KEEP GOING TILL 92
	jr ITSOK2
IUP:
	ld hl,ICONRING
	call drawit
	ld a,43
	ld (BKY),a
	ld hl,ICONRING
	call drawit
	call DELAY
	jp SPEEDLOOP
IDOWN:
	ld hl,ICONRING
	call drawit
	ld a,52
	ld (BKY),a
	ld hl,ICONRING
	call drawit
	call DELAY
	jp SPEEDLOOP
IPRESS:
	ld a,(OK)
	or a
	jp z,SPEEDLOOP
	ld a,(BKX)
	cp 66
	jr z,ATTACKORSPELL
	cp 75
	jr z,ITEMORSKILL
	jp FLEE
ITEMORSKILL:	
	ld a,(BKY)
	cp 43
	jp z,KURAIITEM
	jp KURAISKILL	
ATTACKORSPELL:
	ld a,(BKY)
	cp 43
	jp z,KURAIATTACK
	jp KURAIMAGIC
ENEMYATTK1:
	xor a
	ld (ENEMYCOUNTER1),a
	ld de,(ENEMYST1)
	ld bc,1
	jr ENEMYATTACK
ENEMYATTK2:
	xor a
	ld (ENEMYCOUNTER2),a
	ld de,(ENEMYST2)
	ld bc,2
	jr ENEMYATTACK
ENEMYATTK3:
	xor a
	ld (ENEMYCOUNTER3),a
	ld de,(ENEMYST3)
	ld bc,3
ENEMYATTACK:
	ld hl,(BKX)
	push hl
	push de
	ld (DUMMY1),bc
	ld hl,(DUMMY1)
	call DISPHL2	
      ld hl,EnemyAttacks
	ld de, $163F                    ;Y=2C,X=1A
	call DISPSTRING
BEGINDODGE:
	ld a,r
	srl a
	and 15   
	cp 11
	jr z,YOUDODGE	
	ld hl,(SPEED)
	ld de,40
	and a
	sbc hl,de
	jr nc,TRYAGAIN
	jr NODODGE
TRYAGAIN:
	ld a,r
	srl a
	and 15   
	cp 8
	jr nz,NODODGE
YOUDODGE:
	call ERASETEXT2
             ld hl,YouDodge
	ld de, $163B                    ;Y=2C,X=1A
	call DISPSTRING
	ld bc,$141F
	ld (DUMMY1),bc
	ld b,4
DODGELOOP:
	push bc
	ld bc,(DUMMY1)
	ld a,b
	dec a
	ld b,a		
	ld (DUMMY1),bc 
	ld hl,Kurai
        	call NASRWARP
	call DELAY
	pop bc
	djnz DODGELOOP
	pop hl
	pop de
        	ld bc,$0F29
        	ld hl,KuraiBlank
        	call NASRWARP
	call ERASETEXT
	call KURAI
	jp NEXTENEMY
NODODGE:
	call BLANK1429
	ld bc,$0F20
        	ld hl,KuraiDefend
        	call NASRWARP
	ld a,r
  	srl a
  	and 7   
	cp 5
	jr z,EDIFFATTK
	or a
	jr nz,ENOTDIFFATTK
EDIFFATTK:
	ld a,14
	ld (BKX),a
	ld b,9
EATTACKLOOP2:
	push bc
	ld a,(BKX)
	add a,2
	ld (BKX),a
	ld a,39
	ld (BKY),a
	ld hl,ERASUREX
	call drawit
	ld a,46
	ld (BKY),a
	ld hl,ERASUREX
	call drawit
	ld a,50
	ld (BKY),a
	ld hl,ERASUREX
	call drawit
	pop bc
	djnz EATTACKLOOP2
	jr DONEEATTACK
ENOTDIFFATTK:
	ld bc,$2811
	ld hl,ENEMYHIT1
	call drawit2
	ld bc,$321B
	ld hl,ENEMYHIT1
	call drawit2
	ld bc,$231C
	ld hl,ENEMYHIT1
	call drawit2
DONEEATTACK:
	call ERASETEXT
        	ld bc,$0F29
        	ld hl,KuraiBlank
        	call NASRWARP
	call KURAI
	ld de, $1E4A
             ld hl,BlankText
	call DISPSTRING
	pop de
	call RANDOM7
	ld de,(DEFENSE)
	and a
	sbc hl,de
	jr c,LESSTHANZERO	
	ex de,hl
	jr CONTINUEATTACK
LESSTHANZERO:
	ld de,1
CONTINUEATTACK:
	ld hl,(HP)	
	and a
	sbc hl, de
	ld (HP),hl
	jr c,GAMEOVER
	jr z,GAMEOVER
	ld de,$1E4C
	call DISPHL
	pop hl
	ld (BKX),hl
	jp NEXTENEMY
GAMEOVER:
	call EFFECT
	pop bc	       		
	ld a,(RELIFE)
	or a
	jr nz,BACKTOLIFE
	ld hl,GameOVER
	ld de, $1B14
	jp DISPSTRING3

BACKTOLIFE:
	xor a
	ld (RELIFE),a
	ld hl,(MAXHP)
	srl h
	rr l
	ld (HP),hl
	call HEALLOOPER
	jp MAGIDONE
FLEE:
	ld a,(LEADERCHECK)
	or a
	jp nz,SPEEDLOOP
	ld a,r
  	srl a
  	and 127 
	ld e,a
	ld d,0
	ld hl,(SPEED)
	and a
	sbc hl,de	
	jr nc,YOUFLEE
NOFLEE:
	ld hl,Failed
	ld de, $1640
	call DISPSTRING
	call ERASETEXT2	
	call REFILL
	ld a,66
	ld (KURAICOUNTER),a
	xor a
	ld (OK),a
	jp ENEMYATTK1
YOUFLEE:
	ld hl,Escape
	ld de, $1818
	call DISPSTRING
	call EFFECT
	jp FROMBATTLE
KURAIATTACK:	        
	ld de,(BKX)
	push de
	
	ld a,(NUMBEROFENEMIES)
	cp 1
	jr z,ONLYONEALIVE
	jr CURSORLOOP
ONLYONEALIVE:
	ld a,(ENEMYSPEED1)
	or a
	jr z,ONEISDEAD
	ld a,(ENEMYSPEED2)
	or a
	jr z,TWOISDEAD
	jr THREEISDEAD

ONEISDEAD:
	ld a,(ENEMYSPEED2)
	or a
	jr z,ATTACK3
	jr ATTACK2
TWOISDEAD:
	ld a,(ENEMYSPEED1)
	or a
	jr z,ATTACK3
	jr ATTACK1
CURSDESELECT:
	ld hl,CURSORATTK
	call drawit
	pop de
	ld (BKX),de
	jp SPEEDLOOP
THREEISDEAD:
	ld a,(ENEMYSPEED1)
	or a
	jr z,ATTACK2
ATTACK1:
	ld a,1
	ld (WHICHENEMY),a
	jp CURSPRESS2
ATTACK2:
	
	ld a,2
	ld (WHICHENEMY),a
	jp CURSPRESS2
ATTACK3:
	ld a,3
	ld (WHICHENEMY),a
	jp CURSPRESS2
CURSORLOOP:
	ld a,(ENEMYSPEED1)
	or a
	jr nz,CONTINUE
	ld a,2
	ld (WHICHENEMY),a
	ld bc,$172A	
	jr SOONEWASDEAD
CONTINUE:
	ld a,1
	ld (WHICHENEMY),a
	ld bc,$1714
SOONEWASDEAD:
	ld hl,CURSORATTK
	call drawit2
	call DELAY2
	call DELAY
CURSLOOP:	
	ld a,$3E
 	out (1),a
 	in a,(1)
 	bit 7,a
 	jr z,CURSDESELECT
 	bit 5,a
 	jr z,CURSPRESS
	bit 2,a
        	jr z,CURSRIGHT
	bit 1,a
        	jr nz,CURSLOOP
CURSLEFT:
	ld a,(BKX)
	cp 20
	jr z,CURSLOOP
	ld hl,CURSORATTK
	call drawit
	ld a,(BKX)
	sub 22
	ld (BKX),a
	ld hl,CURSORATTK
	call drawit
	ld a,(WHICHENEMY)
	dec a
	ld (WHICHENEMY),a
	call DELAY2
	jr z,CURSLOOP
CURSRIGHT:
	ld a,(BKX)
	cp 64
	jr z,CURSLOOP
	ld hl,CURSORATTK
	call drawit
	ld a,(BKX)
	add a,22
	ld (BKX),a
	ld hl,CURSORATTK
	call drawit
	ld a,(WHICHENEMY)
	inc a
	ld (WHICHENEMY),a
	call DELAY2
	jr z,CURSLOOP
CURSPRESS:
	ld hl,CURSORATTK
	call drawit
CURSPRESS2:
	call SWORDSWING
	ld a,r
  	srl a
  	and 7   
	cp 5
	jr z,DIFFATTK
	or a
	jr nz,NOTDIFFATTK
DIFFATTK:
	ld hl,97
	ld (DUMMY2),hl
NOTDIFFATTK:
	ld b,2
STARTSLASH:	
	push bc
	xor a
	ld (OK),a
	ld a,(LEADERCHECK)
	cp 1
	jr z,LEADERSLASH
	ld a,(WHICHENEMY)
	cp 2
	jr z,SLASHRIGHT1
	cp 3
	jr z,SLASHRIGHT2
	ld a,15
	jr DONEDUMMY
LEADERSLASH:
	ld a,$2B
	jr DONEDUMMY
SLASHRIGHT1:
	ld a,35
	jr DONEDUMMY
SLASHRIGHT2:
	ld a,55
DONEDUMMY:
	ld (DUMMY1),a
	ld a,(DUMMY2)
	cp 97
	jr z,DIFFERENTATTK
	ld a,5
	ld (DUMMY2),a
SLASHLOOP:
	ld a,(DUMMY1)
	ld b,a
	ld a,(OK)
	add a,b
	ld (BKX),a
	ld a,(DUMMY2)
	inc a
	ld (DUMMY2),a
	ld (BKY),a
	ld hl,SWORDSLASH1
	call drawit
	ld a,(OK)
	inc a
	ld (OK),a
	cp 10
	jr nz,SLASHLOOP
	pop bc
	djnz STARTSLASH
	jr DONEWITHATTK
DIFFERENTATTK:
	pop bc
	call ATTACKNUM2
	call ATTACKNUM2
DONEWITHATTK:	
	ld de,(STRENGTH)
	call RANDOM7
	ld de,(WEAPON)
	add hl,de
	ld a,(BUILDUP)
	or a
	jr z,BUILDUPOFF
BUILDUPON:
	xor a
	ld (BUILDUP),a
	add hl,hl
BUILDUPOFF:	
	ld a,(WHICHENEMY)
	cp 2
	jr z,DFDENEMY2
	cp 3
	jr z,DFDENEMY3
DFDENEMY1:
	ld de,(ENEMYDFD1)
	jr donedfd
DFDENEMY2:
	ld de,(ENEMYDFD2)
	jr donedfd
DFDENEMY3:
	ld de,(ENEMYDFD3)
donedfd:	
	and a
	sbc hl,de
	jr c,ENEMYDFDS
	jr MORETHANZERO	
ENEMYDFDS:
	ld hl,1
MORETHANZERO
	call DUMMY1DISP
             ld hl,damage
	ld de, $1647                   ;Y=2C,X=1A
	call DISPSTRING
	call ERASETEXT2
	pop de
	ld (BKX),de

	ld a,(WHICHENEMY)
	cp 2
	jr z,TOENEMY2
	cp 3
	jr z,TOENEMY3
TOENEMY1:
	ld hl,(ENEMYHP1)		;; Displays Kurai's HP
	ld de,(DUMMY1)
	and a
	sbc hl, de
	ld (ENEMYHP1),hl
	jr ATTKEND
TOENEMY2:
	ld hl,(ENEMYHP2)
	ld de,(DUMMY1)
	and a
	sbc hl, de
	ld (ENEMYHP2),hl
	jr ATTKEND
TOENEMY3:
	ld hl,(ENEMYHP3)
	ld de,(DUMMY1)
	and a
	sbc hl, de
	ld (ENEMYHP3),hl
ATTKEND:
	call c,ENEMYDEAD
	cp 199
	jp z,FROMBATTLE	
	ld a,(REGENCHECK)
	or a
	call nz,REGENEFFECT
        	jp KURAIDONE2
FROMBATTLE:
	ld a,(LEADERCHECK)
	or a
	call nz,LEADEREND
	cp $4E			;-177
	jr z,LASTFADE
	call ERASESCREEN
	ld a,1
	ret								;jp DRAWMAP

LASTFADE:
	call DRAWWALLS
	ld bc,$231D
	ld hl,Logo
	call NASRWARP	
	ld de,$1009
	ld hl,cruelplace
	call DISPSTRING	
	ld de,$1604
	ld hl,cruelplace2
	jp DISPSTRING3
ENDSNAKE:
	call DRAWWALLS
	ld hl,YouFind
	ld de,$1820
	call DISPSTRING
	ld hl,faitharmor
	ld de,$1E20
	call DISPSTRING3
	call CHESTPLACER
	ld (hl),0
	ld hl,260
	ld (DEFENSE),hl
	ret
LEADEREND:
	xor a
	ld (LEADERCHECK),a
	ld a,(DUNGEONCHECK)
	cp -2
	jr z,ENDSNAKE
	ld a,(SCENARIO)
	cp 2
	jr z,ENDLEAD2
	cp 7
	jr z,ENDLEAD3
	cp 9
	jr z,ENDLEAD4
	cp 13
	jr z,YOUWINGAME
	ret
ENDLEAD2:
	call TALK3
	jp TALK4
ENDLEAD3:
	ld a,8
	ld (SCENARIO),a
	jp TALK11
ENDLEAD4:
	call DRAWWALLS
	ld de,$1C10
	ld hl,YouFind
	call DISPSTRING	
	call FAITHSWORD
	ld hl,180
	ld (WEAPON),hl
	jp TALK12
YOUWINGAME:
	call DRAWWALLS
	ld de,$1005
	ld hl,choicetext1
	call DISPSTRING	
	ld de,$1605
	ld hl,choicetext2
	call DISPSTRING
	ld de,$1C05
	ld hl,choicetext3
	call DISPSTRING3	
	ld de,$2205
	ld hl,choicetext4
	call DISPSTRING3	
	call DRAWWALLS
	call YESNO
	ld de,$1114
	ld hl,healher
	call DISPSTRING	
HEALHERLOOP:
	call _getky
             cp K_1
             jp z,BADEND
             cp K_2
	jr nz,HEALHERLOOP ; good end
	call DRAWWALLS
	ld bc,$2639	
	ld hl,endpic
	call NASRWARP	
	ld de,$0303
	ld hl,endgame1
	call DISPSTRING	
	ld de,$0903
	ld hl,endgame2
	call DISPSTRING
	ld de,$0F03
	ld hl,endgame3
	call DISPSTRING	
	ld de,$1503
	ld hl,endgame4
	call DISPSTRING	
	ld de,$1B03
	ld hl,endgame5
	call DISPSTRING
	ld de,$2103
	ld hl,endgame6
	call DISPSTRING
	ld de,$2703
	ld hl,endgame7
	call DISPSTRING
	ld de,$2D03
	ld hl,endgame8
	call DISPSTRING3
	ld a,$4E			;-177
	ret
BADEND:
	call DRAWWALLS
	ld de,$1005
	ld hl,badend1
	call DISPSTRING	
	ld de,$1605
	ld hl,badend2
	call DISPSTRING
	ld de,$1C05
	ld hl,badend3
	call DISPSTRING3	
	ld de,$2205
	ld hl,badend4
	call DISPSTRING3	
	ld a,$4E			;-177
	ret
		
KURAIMAGIC2:
	pop hl
KURAIMAGIC:
	;; first erases menu so the spell menu can come up...same with skill/item
	call ERASEMENU	
	call DISPMP
	xor a
	ld (DUMMY1),a
	ld hl,WhichSpells
	ld a,(hl)
	or a	
	jr z,NEXT1
	push hl
             ld hl,Heal
	ld de, $1F49                    ;Y=2C,X=1A
	call DISPSTRING
	pop hl
NEXT1:
	inc hl
	ld a,(hl)
	or a
	jr z,NEXT2
	push hl
             ld hl,Burn
	ld de, $2649                    ;Y=2C,X=1A
	call DISPSTRING
	pop hl
NEXT2:
	inc hl
	ld a,(hl)
	or a
	jr z,NEXT3
	push hl
             ld hl,Star
	ld de, $2D49                    ;Y=2C,X=1A
	call DISPSTRING	
	pop hl
NEXT3:
	inc hl
	ld a,(hl)
	or a
	jr z,SPELLSTART
	push hl
             ld hl,Rage
	ld de, $3449                    ;Y=2C,X=1A
	call DISPSTRING	
	pop hl
SPELLSTART:
	ld bc,$1F3F
	ld hl,CURSORMAGIC
	call drawit2
	call DELAY2
RETFROM:
	ld hl,WhichSpells
MAGICLOOP2:
	push hl
MAGICLOOP:
	ld a,$3E
 	out (1),a
 	in a,(1)
	bit 3,a
        	jr z,MAGICUP
 	bit 7,a  ; del
 	jp z,GOBACK
	bit 1,a
	jr z,MAGICLEFT
	bit 2,a
	jr z,MAGICRIGHT
 	bit 5,a
 	jr z,MAGICPRESS
	bit 0,a
	jr nz,MAGICLOOP
MAGICDOWN:
	ld a,(BKY)
	cp $34
	jr z,MAGICLOOP
	pop hl
	inc hl
	push hl
	ld hl,CURSORMAGIC
	call drawit
	ld a,(BKY)
	add a,7
	ld (BKY),a
	ld hl,CURSORMAGIC
	call drawit
	call DELAY2
	jr MAGICLOOP
MAGICUP:
	ld a,(BKY)
	cp $1F
	jr z,MAGICLOOP
	pop hl
	dec hl
	push hl
	ld hl,CURSORMAGIC
	call drawit
	ld a,(BKY)
	sub 7
	ld (BKY),a
	ld hl,CURSORMAGIC
	call drawit
	call DELAY2
	jr MAGICLOOP
MAGICLEFT:
	ld a,(DUMMY1)		
	or a
	jr z,MAGICLOOP
	dec a
	ld (DUMMY1),a
	jp REDISP
MAGICRIGHT:
	ld a,(DUMMY1)		
	cp 1
	jr z,MAGICLOOP
	inc a
	ld (DUMMY1),a
	jp REDISP
MAGICPRESS:
	pop hl
	ld a,(hl)
	or a	
	jp z,MAGICLOOP2
	ld (Save),hl
	cp 1
	jr z,HEALSPELL
	cp 2
	jr z,BURNSPELL
	cp 3
	jp z,STAR_SPELL
	cp 4
	jp z,RAGESPELL
	cp 5
	jp z,SIRESPELL
	cp 6
	jp z,ROCKSPELL
	cp 7
	jp z,HASTESPELL
	cp 8
	jp z,DOOMSPELL
HEALSPELL:
	ld hl,(MP)
	ld de,5
	and a
	sbc hl,de
	jp c,NEEDMP
	call SPELLCAST
FROMITEM:
	call HEALLOOPER
	ld a,(OK)
	cp 234
	jp z,MAGIDONE	
	ld de,90
	call OVERMAXHP
	jp MAGIDONE
BURNSPELL:
	ld hl,(MP)
	ld de,6
	and a
	sbc hl,de
	jp c,NEEDMP
	call SPELLCAST
	ld b,99
BURNLOOP:
	push bc
	ld a,r
	srl a
	and 50	   
	add a,15
	ld (BKX),a
	ld a,r
	srl a
	and 10   
	add a,4
	ld (BKY),a
	ld hl,ENEMYHIT1
	call drawit
	pop bc 
	djnz BURNLOOP  
	ld de,37
	jp  MAGIDAMAGE
STAR_SPELL:
	ld hl,(MP)
	ld de,20
	and a
	sbc hl,de
	jp c,NEEDMP
	call SPELLCAST
	call INVERTSCREEN
	call SLASH_ALL
	call INVERTSCREEN
	ld de,110
	jp  MAGIDAMAGE
RAGESPELL:
	ld hl,(MP)
	ld de,24
	and a
	sbc hl,de
	jp c,NEEDMP
	call SPELLCAST
	ld b,20
FLASHSCREEN:	
	push bc
	call INVERTSCREEN
	pop bc
	djnz FLASHSCREEN
	ld a,(KURAILEVEL)
	ld b,a
	ld hl,0
LEVEL_LOOP:
	ld de,10
	add hl,de
	djnz LEVEL_LOOP
	ld de,(STRENGTHMAX)	
	add hl,de
	ld (STRENGTH),hl
	jp MAGIDONE	
SIRESPELL:
	ld hl,(MP)
	ld de,32
	and a
	sbc hl,de
	jp c,NEEDMP
	call SPELLCAST
	ld b,6
SIRELOOP:
	push bc
	ld bc,$2B26
        	ld hl,SireSpell1
        	call NASRWARP
	call DELAY
	ld bc,$2B26
        	ld hl,SireSpell2
        	call NASRWARP
	call DELAY
	ld bc,$2B26
        	ld hl,SireSpell3
        	call NASRWARP
	call DELAY
	pop bc
	djnz SIRELOOP
	ld de,190
	jp MAGIDAMAGE
ROCKSPELL:
	ld hl,(MP)
	ld de,24
	and a
	sbc hl,de
	jp c,NEEDMP
	call SPELLCAST
	ld hl,$AFAF			;load battle screen
	ld	de,$fc02
	ld	bc,1024
	ldir
	call CR_GRBCopy 		; Copy graphbuf to LCD
	ld b,10
FLASHSCREEN2:	
	push bc
	call INVERTSCREEN
	call DELAY
	pop bc
	djnz FLASHSCREEN2
	ld a,(KURAILEVEL)
	ld b,a
	ld hl,0
LEVEL_LOOP2:
	ld de,10
	add hl,de
	djnz LEVEL_LOOP2
	ld de,(DEFENSEMAX)	
	add hl,de
	ld (DEFENSE),hl
	jp MAGIDONE	
HASTESPELL:
	ld hl,(MP)
	ld de,75
	and a
	sbc hl,de
	jp c,NEEDMP
	call SPELLCAST
	ld bc,$141F
	ld (DUMMY1),bc
	ld b,4
HASTELOOP:
	push bc
	ld bc,(DUMMY1)
	ld a,b
	dec a
	ld b,a		
	ld (DUMMY1),bc 
	ld hl,Kurai
        	call NASRWARP
	call INVERTSCREEN
	call DELAY
	pop bc
	djnz HASTELOOP
	ld a,66
	ld (DOUBLE),a
	jp MAGIDONE
DOOMSPELL:
	ld hl,(MP)
	ld de,55
	and a
	sbc hl,de
	jp c,NEEDMP
	call SPELLCAST	
	ld b,60
DOOMLOOP:
	push bc
GETRANDOM2:
	call RAND
	cp 90
	jr nc,GETRANDOM2
	ld b,a
GETRANDOM:
	call RAND
	cp 46
	jr nc,GETRANDOM
	add a,16
	ld c,a
	ld hl,DoomSpell
	call NASRWARP
	pop bc 
	djnz DOOMLOOP
	ld hl,1
	ld (HP),hl
	ld de,500	
	jp MAGIDAMAGE
MAGIDAMAGE:
	call RANDOM7
	call DUMMY1DISP
             ld hl,damage
	ld de, $1647     
	call DISPSTRING
	call ERASETEXT2
	ld a,(ENEMYSPEED1)
	or a
	jr z,NEXTDAMAGE1
	ld a,1
	ld (WHICHENEMY),a
	ld hl,(ENEMYHP1)
	ld de,(DUMMY1)
	and a
	sbc hl, de
	ld (ENEMYHP1),hl
	call c,ENEMYDEAD
	cp 199
	jp z,FROMBATTLE	
NEXTDAMAGE1:
	ld a,(ENEMYSPEED2)
	or a
	jr z,NEXTDAMAGE2
	ld a,2
	ld (WHICHENEMY),a
	ld hl,(ENEMYHP2)
	ld de,(DUMMY1)
	and a
	sbc hl, de
	ld (ENEMYHP2),hl
	call c,ENEMYDEAD
	cp 199
	jp z,FROMBATTLE	
NEXTDAMAGE2:
	ld a,(ENEMYSPEED3)
	or a
	jr z,MAGIDONE
	ld a,3
	ld (WHICHENEMY),a
	ld hl,(ENEMYHP3)
	ld de,(DUMMY1)
	and a
	sbc hl, de
	ld (ENEMYHP3),hl
	call c,ENEMYDEAD
	cp 199
	jp z,FROMBATTLE	
MAGIDONE:
	call DRAWWALLS
	ld a,(LEADERCHECK)
	cp 1
	jr z,DISPLEADERBACK
	ld a,(ENEMYSPEED1)
	or a
	jr z,ENEMY1DEAD
	ld hl,(ENEMYBACK1)
	ld bc,$0F39
	call NASRWARP
ENEMY1DEAD:	
	ld a,(ENEMYSPEED2)
	or a
	jr z,ENEMY2DEAD
	ld hl,(ENEMYBACK2)
	ld bc,$2539
	call NASRWARP
ENEMY2DEAD:
	ld a,(ENEMYSPEED3)
	or a
	jr z,ENEMY3DEAD
	ld hl,(ENEMYBACK3)
	ld bc,$3B39
	call NASRWARP
ENEMY3DEAD:		
	jr KURAIDONE3
DISPLEADERBACK:
	ld hl,(ENEMYBACK1) ; WHICHLEADER
	ld bc,(ENEMYBACK2) ; COORDS
	call NASRWARP
	jr KURAIDONE3
KURAIDONE2:
	call REFILL
KURAIDONE3:
	call BATTLEMENU
	call KURAI
	ld a,66
	ld (KURAICOUNTER),a
	xor a
	ld (OK),a
	jp SPEEDLOOP


KURAIITEM:	        
	;; first erases menu so the spell menu can come up...same with skill/item
	call ERASEMENU	

	ld hl,WhichItems
	ld a,(hl)
	or a	
	jr z,NEXT1I
	push hl
             ld hl,MedKit
	ld de, $1F49                    ;Y=2C,X=1A
	call DISPSTRING
	pop hl
NEXT1I:
	inc hl
	ld a,(hl)
	or a
	jr z,NEXT2I
	push hl
             ld hl,MagKit
	ld de, $2649                    ;Y=2C,X=1A
	call DISPSTRING
	pop hl
NEXT2I:
	inc hl
	ld a,(hl)
	or a
	jr z,ITEMSTART
	push hl
             ld hl,ArcBolt
	ld de, $2D49                    ;Y=2C,X=1A
	call DISPSTRING	
	pop hl
ITEMSTART:
	ld bc,$1F3F
	ld hl,CURSORMAGIC
	call drawit2
	call DELAY2

	ld hl,WhichItems
ITEMLOOP2:
	push hl
ITEMLOOP:
	ld a,$3E
 	out (1),a
 	in a,(1)
 	bit 5,a
 	jr z,ITEMPRESS
	bit 3,a
        	jr z,ITEMUP
 	bit 7,a  ; del
 	jp z,GOBACK
	bit 0,a
        	jr nz,ITEMLOOP
ITEMDOWN:
	ld a,(BKY)
	cp $34
	jr z,ITEMLOOP
	pop hl
	inc hl
	push hl
	ld hl,CURSORMAGIC
	call drawit
	ld a,(BKY)
	add a,7
	ld (BKY),a
	ld hl,CURSORMAGIC
	call drawit
	call DELAY2
	jr ITEMLOOP
ITEMUP:
	ld a,(BKY)
	cp $1F
	jr z,ITEMLOOP

	pop hl
	dec hl
	push hl
	ld hl,CURSORMAGIC
	call drawit
	ld a,(BKY)
	sub 7
	ld (BKY),a
	ld hl,CURSORMAGIC
	call drawit
	call DELAY2
	jr ITEMLOOP
ITEMPRESS:
	pop hl
	ld a,(hl)
	or a	
	jp z,ITEMLOOP2
	dec a
	ld (hl),a
	call BLANK1429
	call KURAIMAGIC1	
	ld a,(BKY)
	cp $1F
	jr z,HPkit
	cp $2D
	jr z,BOMB
MPkit:
	ld de,40
	call OVERMAXMP
	ld bc,$2B26
        	ld hl,MagicKit
        	call NASRWARP
	ld a,234
	ld (OK),a
HPkit:
	jp  FROMITEM
BOMB:
	call INVERTSCREEN
	ld b,99
BOMBLOOP:
	push bc
	ld a,r
	srl a
	and 50	   
	add a,15
	ld b,a
	ld a,r
	srl a
	and 10   
	add a,50
	ld c,a
	ld hl,EnemyDead
	call NASRWARP
	pop bc 
	djnz BOMBLOOP  
	call INVERTSCREEN
	ld de,50
	jp  MAGIDAMAGE
KURAISKILL2:
	pop hl
KURAISKILL:
	;; first erases menu so the spell menu can come up...same with skill/item
	call ERASEMENU	
	call DISPMP
	xor a
	ld (DUMMY1),a
	ld hl,WhichSkills
	ld a,(hl)
	or a	
	jr z,NEXT1S
	push hl
             ld hl,SlashAll
	ld de, $1F49                    ;Y=2C,X=1A
	call DISPSTRING
	pop hl
NEXT1S:
	inc hl
	ld a,(hl)
	or a
	jr z,NEXT2S
	push hl
             ld hl,Regeneration
	ld de, $2649                    ;Y=2C,X=1A
	call DISPSTRING
	pop hl
NEXT2S:
	inc hl
	ld a,(hl)
	or a
	jr z,NEXT3S
	push hl
             ld hl,HPMP
	ld de, $2D49                    ;Y=2C,X=1A
	call DISPSTRING	
	pop hl
NEXT3S:
	inc hl
	ld a,(hl)
	or a
	jr z,SKILLSTART
	push hl
             ld hl,Smoke
	ld de, $3449                    ;Y=2C,X=1A
	call DISPSTRING	
	pop hl

SKILLSTART:
	ld bc,$1F3F
	ld hl,CURSORMAGIC
	call drawit2
	call DELAY2

	ld hl,WhichSkills
SKILLLOOP2:
	push hl
SKILLLOOP:
	ld a,$3E
 	out (1),a
 	in a,(1)
 	bit 5,a
 	jr z,SKILLPRESS
	bit 3,a
        	jr z,SKILLUP
 	bit 7,a  ; del
 	jp z,GOBACK
	bit 1,a
	jr z,SKILLLFT
	bit 2,a
	jr z,SKILLRT
	bit 0,a
        	jr nz,SKILLLOOP
SKILLDOWN:
	ld a,(BKY)
	cp $34
	jr z,SKILLLOOP
	pop hl
	inc hl
	push hl
	ld hl,CURSORMAGIC
	call drawit
	ld a,(BKY)
	add a,7
	ld (BKY),a
	ld hl,CURSORMAGIC
	call drawit
	call DELAY2
	jr SKILLLOOP
SKILLUP:
	ld a,(BKY)
	cp $1F
	jr z,SKILLLOOP
	pop hl
	dec hl
	push hl
	ld hl,CURSORMAGIC
	call drawit
	ld a,(BKY)
	sub 7
	ld (BKY),a
	ld hl,CURSORMAGIC
	call drawit
	call DELAY2
	jr SKILLLOOP
SKILLLFT:
	ld a,(DUMMY1)		
	or a
	jp z,SKILLLOOP
	dec a
	ld (DUMMY1),a
	jp REDISP2
SKILLRT:
	ld a,(DUMMY1)		
	cp 1
	jp z,SKILLLOOP
	inc a
	ld (DUMMY1),a
	jp REDISP2
SKILLPRESS:
	pop hl
	ld a,(hl)
	or a	
	jp z,SKILLLOOP2
	ld (Save),hl
	ld hl,(MP)
	ld a,(DUMMY1)
	or a
	jr nz,SKILLPRESS2
	ld a,(BKY)
	cp $26
	jr z,REGENSKILL
	cp $34
	jr z,SMOKESKILL
	cp $2D
	jp z,HPMPSKILL
	jr SLASHSKILL
SKILLPRESS2:
	ld a,(BKY)
	cp $26
	jp z,BUILDSKILL
	cp $34
	jp z,STEALSKILL
	cp $2D
	jp z,XFRMSKILL
	jp RELIFESKILL
SLASHSKILL:
	ld de,12
	and a
	sbc hl,de
	jp c,NEEDMP2
	ld (MP),hl
	call SWORDSWING
	call SLASH_ALL
	ld hl,(STRENGTH)
	ld de,(ENEMYDFD1)
	and a
	sbc hl,de
	jr c,ENEMYDFDSALL
	ex de,hl
	jr GOHERE
ENEMYDFDSALL:
	ld de,1
GOHERE:
	jp  MAGIDAMAGE
REGENSKILL:
	ld de,25
	and a
	sbc hl,de
	jp c,NEEDMP2
	call REGENLOOPER
	ld a,1
	ld (REGENCHECK),a
	jp  MAGIDONE
SMOKESKILL:
	ld a,(LEADERCHECK)
	or a
	jp nz,SKILLLOOP2
	ld de,8
	and a
	sbc hl,de
	jp c,NEEDMP2
	ld (MP),hl
	jp  YOUFLEE
HPMPSKILL:
	ld hl,HPMP
	ld de, $181E
	call DISPSTRING
	call BLANK1429
	call KURAIMAGIC1
	call INVERTSCREEN
	ld hl,$181C
	ld (BKX),hl
	ld b,24
HPMPLOOP:
	push bc
	ld hl,(BKX)
	ld a,l
	inc a
	ld l,a
	ld (BKX),hl
	ld hl,MPHPSWITCH
	call drawit
	call DELAY
	pop bc
	djnz HPMPLOOP	
	ld hl,(MP)
	ld de,(HP)
	ld (HP),hl
	ld (MP),de
	call OVERMAXMP	
	jp  MAGIDONE
REGENEFFECT:
	ld a,(KURAILEVEL)
	ld b,a
	ld hl,0
LEVEL_LOOP3:
	ld de,10
	add hl,de
	djnz LEVEL_LOOP3
	call OVERMAXHP
	ld hl,(HP)		;; Displays Kurai's HP
	ld de,$1E4C
	jp DISPHL
RELIFESKILL:
	ld de,50
	and a
	sbc hl,de
	jp c,NEEDMP2
	ld (MP),hl
	ld a,1
	ld (RELIFE),a
	jp MAGIDONE
BUILDSKILL:
	ld de,10
	and a
	sbc hl,de
	jp c,NEEDMP2
	call REGENLOOPER
	ld a,1
	ld (BUILDUP),a
	jp MAGIDONE
XFRMSKILL:
	ld a,(LEADERCHECK)
	or a
	jp nz,SKILLLOOP2
	jp RESTARTBATTLE	
STEALSKILL:
	ld de,13
	and a
	sbc hl,de
	jp c,NEEDMP2
	ld (MP),hl
	call BLANK1429
        	ld bc,$111D
	ld (DUMMY1),bc
	ld b,12
STEALLOOP:
	push bc
	ld bc,(DUMMY1)
	ld a,c
	inc a
	ld c,a		
	ld (DUMMY1),bc 
        	ld hl,KuraiMagic1
        	call NASRWARP
	ld bc,(DUMMY1)
	pop bc
	djnz STEALLOOP
	ld bc,$1129
	ld (DUMMY1),bc
	ld b,12
STEALLOOP2:
	push bc
	ld bc,(DUMMY1)
	ld a,c
	dec a
	ld c,a		
	ld (DUMMY1),bc 
        	ld hl,KuraiMagic1
        	call NASRWARP
	ld bc,(DUMMY1)
	pop bc
	djnz STEALLOOP2
	ld a,r
	srl a
	and 7   
	or a
	jr z,STEALSOMETHING
	cp 3
	jr z,STEALSOMETHING
	ld hl,Failed
	jr STEALDONE
STEALSOMETHING:
	ld a,r
	srl a
	and 7   
	or a
	jr z,STOLEMAG
STOLEMED:
	ld hl,WhichItems
	ld a,(hl)
	inc a
	ld (hl),a
	ld hl,MedKit
	jr STEALDONE
STOLEMAG:	
	ld hl,WhichItems
	inc hl
	ld a,(hl)
	inc a
	ld (hl),a
	ld hl,MagKit
STEALDONE:
	ld de, $1632
	call DISPSTRING
	call DELAY3
	jp MAGIDONE
ENEMYDEAD:
	ld hl,0
	ld a,(WHICHENEMY)
	cp 2	
	jr z,KILL2
	cp 3
	jr z,KILL3
	ld (ENEMYSPEED1),hl
	ld bc,$0F39
	jr CONTKILL
KILL2:
	ld (ENEMYSPEED2),hl
	ld bc,$2539
	jr CONTKILL
KILL3:
	ld (ENEMYSPEED3),hl
	ld bc,$3B39
CONTKILL:	
	push bc
	ld hl,EnemyDead
	call NASRWARP
	call DELAY2
	pop bc
	ld hl,BlankEnemy
	call NASRWARP	
	ld hl,(ENEMYST1)
	srl h
	rr l
	ld de,(XPGAINED)
	add hl,de
	ld (XPGAINED),hl
	ld a,(NUMBEROFENEMIES)
	dec a
	ld (NUMBEROFENEMIES),a
	or a
	ret NZ

YOUWIN:
	call DRAWWALLS
	call KURAI
	call BATTLEMENU
	ld hl,(STRENGTHMAX)
	ld (STRENGTH),hl
	ld hl,(DEFENSEMAX)
	ld (DEFENSE),hl

	ld hl,Victory
	ld de, $0404
	call DISPSTRING
	ld hl,xp
	ld de, $0B1D
	call DISPSTRING
	ld hl,gold
	ld de, $1215
	call DISPSTRING
	ld hl,(XP)
	ld de,(XPGAINED)
	add hl,de
	ld (XP),hl
	ld de,(XPGAINED)
	call RANDOM7
	ld (NUMBEROFENEMIES),hl
	ld hl,(GOLD)
	ld de,(NUMBEROFENEMIES)
	add hl,de
	ld (GOLD),hl
	ld hl,0
	ld (DUMMY1),hl
LOOPOFGOLDXP:
	ld hl,(DUMMY1)
	inc hl
	inc hl
	ld (DUMMY1),hl
	ld de,(XPGAINED)
	and a
	sbc hl,de
	jr z,DONEXP
	jr nc,DONEXP
	ld hl,(DUMMY1)
	ld de,$0B28
	call DISPHL	
	ld hl,(DUMMY1)
	ld de,$1228
	call DISPHL
	jr LOOPOFGOLDXP
DONEXP:
	ld hl,(NUMBEROFENEMIES)
	ld de,$1228
	call DISPHL
	ld hl,ToNextLevel
	ld de,$1909
	call DISPSTRING
	ld hl,(TOLEVEL)
	ld de,(XP)
	and a
	sbc hl,de
	ld de,$1928
	call DISPHL
LEVELCHECK:
	ld hl,(XP)
	ld de,(TOLEVEL)
	and a
	sbc hl,de 
	jr nc, UPLEVEL
	call WaitKey 

DONECHECK:
	ld a,199
	ret
UPLEVEL:
	ld a,(KURAILEVEL)
	inc a
	ld (KURAILEVEL),a
	ld hl,32
	call LEVELUP2
	jr DONECHECK

LEADERALLOCATE2:
	ld (ENEMYBACK1),hl
	ld (ENEMYBACK2),bc
	call NASRWARP
	call DRAWWALLS2
	ld a,1
	ld (NUMBEROFENEMIES),a
	ld (LEADERCHECK),a
	ret
LEADER5:
	ld a,9
	ld (SCENARIO),a
	call DRAWWALLS
	ld de,$1610
	ld hl,BanditsText4
	call DISPSTRING	
	ld de,$1C10
	ld hl,BanditsText5
	call DISPSTRING	
	call FAITHSWORD
	call ERASESCREEN
	ld hl,Leader5
	ld bc,$1C3C
	call LEADERALLOCATE2
	ld bc,170
	ld de,2500
	ld ix,37
	ld hl,90
	jr LEADERALLOCATE

LEADER1:
	call TALK2
	ld a,2
	ld (SCENARIO),a
LEADER1TOWN:
	ld hl,Leader1
	ld bc,$283C
	call LEADERALLOCATE2
	ld bc,25
	ld de,250
	ld ix,34
	ld hl,13
LEADERALLOCATE:
	ld (ENEMYST1),bc	
	ld (ENEMYHP1),de
	ld (ENEMYSPEED1),ix
	ld (ENEMYDFD1),hl
	jp FROMLEADER
LEADER2:
	call ERASESCREEN
	ld hl,Leader2
	ld bc,$283C
	call LEADERALLOCATE2
	ld bc,40
	ld de,400
	ld ix,55
	ld hl,40
	jr LEADERALLOCATE
LEADER3:
	call TALK5
	ld hl,Leader3
	ld bc,$093C
	call LEADERALLOCATE2
	ld bc,60
	ld de,1000
	ld ix,45
	ld hl,20
	ld a,5
	ld (SCENARIO),a
TOLEADER:
	jr LEADERALLOCATE
LEADER6:
	call DRAWWALLS
	ld de,$1010
	ld hl,Serpent1
	call DISPSTRING	
	ld de,$1C10
	ld hl,faitharmor
	call DISPSTRING	
	ld de,$1610
	ld hl,Serpent2
	call DISPSTRING3	
	call ERASESCREEN
	ld hl,Leader6
	ld bc,$093C
	call LEADERALLOCATE2
	ld bc,330
	ld de,10000
	ld ix,50
	ld hl,900
	jr TOLEADER
LEADER7:
	call DRAWWALLS
	ld de,$1003
	ld hl,lasttext1
	call DISPSTRING	
	ld de,$1603
	ld hl,lasttext2
	call DISPSTRING3	
	call DRAWWALLS
	ld de,$1005
	ld hl,lasttext3
	call DISPSTRING3	
	ld de,$1605
	ld hl,lasttext4
	call DISPSTRING3	
	call DRAWWALLS
	ld de,$1005
	ld hl,lasttext5
	call DISPSTRING	
	ld de,$1605
	ld hl,lasttext6
	call DISPSTRING
	ld de,$1C05
	ld hl,lasttext7
	call DISPSTRING3
	ld b,70
FLASHSCREEN3:	
	push bc
	call INVERTSCREEN
	pop bc
	djnz FLASHSCREEN3
	ld de,$2205
	ld hl,lasttext8
	call DISPSTRING3
	call DRAWWALLS
	ld de,$1005
	ld hl,lasttext9
	call DISPSTRING	
	ld de,$1605
	ld hl,lasttext10
	call DISPSTRING3	
	call ERASESCREEN
	ld hl,Leader7
	ld bc,$093C
	call LEADERALLOCATE2
	ld bc,360
	ld de,10000
	ld ix,30
	ld hl,200
	ld a,13 ; end of game
	ld (SCENARIO),a
	jp LEADERALLOCATE
LEADER4:
	call DRAWWALLS
	ld de,$1614
	ld hl,BanditsText1 ;; The Faith sword!!
	call DISPSTRING	
	call TALK10
	call DRAWWALLS
	ld de,$1610
	ld hl,BanditsText2
	call DISPSTRING	
	ld de,$1C10
	ld hl,BanditsText3
	call DISPSTRING	
	call FAITHSWORD
	call DRAWWALLS
	ld a,7
	ld (SCENARIO),a
	ld (LEADERCHECK),a
	ld a,3
	ld (NUMBEROFENEMIES),a
	push af
	jp FROMRIGGED2
RIGGEDENEMY:
	xor a
	jr FROMRIGGED
PUTENEMY:
	ld a,(SCENARIO)
	cp 7
	jr z,RIGGEDENEMY
  ld a,r
  srl a
  and 6   
  ld (WHICHENEMY),a
FROMRIGGED:
	push af
	ld a,(DUNGEONCHECK)
	cp 1 ;; CASTLE DUNGEON
	jp z,DUNGEON1
	cp 3 ;; WEST CAVE TO KIATA
	jp z,DUNGEON3
	cp 4 ;; FAITH CAVE
	jp z,DUNGEON6
	cp 7 ;; BANDIT CASTLE
	jp z,DUNGEON7
	cp -1 ;; LAST CAVE
	jp z,DUNGEON8
	cp 5 ;; OTHER SIDE OF OVERWORLD MAP
	jp z,DUNGEON5
	pop af ;; AND THIS WOULD BE THE OVERWORLD MAP, PART 1
	or a
	jr z,Enemy1
	cp 2
	jr z,Enemy2
	cp 4
	jr z,Enemy3

Enemy4:		;; bc == strength de == life
	ld bc,15	;; ix == speed
	ld de,35
	ld ix,45
	ld hl,22
	ld (DUMMY1),hl
       	ld hl,ENEMY4
	jr STARTPUT1
Enemy3:
	ld bc,20
	ld de,40
	ld ix,50
	ld hl,22
	ld (DUMMY1),hl
       	ld hl,ENEMY3
	jr STARTPUT1
Enemy2:
	ld bc,10
	ld de,40
	ld ix,30
	ld hl,10
	ld (DUMMY1),hl
       	ld hl,ENEMY2
	jr STARTPUT1
Enemy1:
	ld bc,30
	ld de,66
	ld ix,66
	ld hl,30
	ld (DUMMY1),hl
       	ld hl,ENEMY1
	jr STARTPUT1
DUNGEON1:
	ld hl,8
	ld (DUMMY1),hl
	pop af
	or a
	jr z,Enemy5
	cp 2
	jr z,Enemy6
	cp 4
	jr z,Enemy7

Enemy8:		;; bc == strength de == life
	ld bc,15	;; ix == speed
	ld de,20
	ld ix,45
       	ld hl,ENEMY8
	jr STARTPUT1
Enemy7:
	ld bc,10
	ld de,30
	ld ix,50
	ld hl,24
	ld (DUMMY1),hl
       	ld hl,ENEMY7
STARTPUT1:
	jr STARTPUT2
Enemy6:
	ld bc,08
	ld de,18
	ld ix,27
       	ld hl,ENEMY6
	jr STARTPUT2
Enemy5:
	ld bc,20
	ld de,43
	ld ix,60
       	ld hl,ENEMY5
	jr STARTPUT2
DUNGEON3:
	ld hl,32
	ld (DUMMY1),hl
	pop af
	or a
	jr z,Enemy9
	cp 2
	jr z,Enemy10
	cp 4
	jr z,Enemy11
Enemy12:		;; bc == strength de == life
		;; ix == speed
	ld bc,24
	ld de,120
	ld ix,18
	ld (DUMMY1),ix
       	ld hl,ENEMYGIMP ;; weak guy you fight in town
	jr STARTPUT
Enemy11:
	ld bc,35
	ld de,90
	ld ix,50
       	ld hl,ENEMY11
	jr STARTPUT
Enemy10:
	ld bc,40
	ld de,100
	ld ix,27
       	ld hl,ENEMY10
	jr STARTPUT
Enemy9:
	ld bc,60
	ld de,150
	ld ix,60
       	ld hl,ENEMY9
STARTPUT2:
	jr STARTPUT

DUNGEON5: ;;overhead map #2
	ld hl,45
	ld (DUMMY1),hl
	pop af
	or a
	jr z,Enemy9
	cp 2
	jr z,Enemy13
	cp 4
	jr z,Enemy14
Enemy15:
	ld bc,65
	ld de,140
	ld ix,45
       	ld hl,ENEMY15
	jr STARTPUT
Enemy14:
	ld bc,80
	ld de,150
	ld ix,50
       	ld hl,ENEMY14
	jr STARTPUT
Enemy13:
	ld bc,60
	ld de,160
	ld ix,40
       	ld hl,ENEMY13
	jr STARTPUT

STARTPUT:
	ld a,(KURAICOUNTER)
	cp 199
	jr z,PUT2
	cp 201
	jr z,PUT3
PUT1:
	ld (ENEMYST1),bc	
	ld (ENEMYHP1),de
	ld (ENEMYSPEED1),ix
	ld (ENEMYBACK1),hl
	ld bc,$0F39
	call NASRWARP
	ld hl,(DUMMY1)
	ld (ENEMYDFD1),hl
	ld a,(NUMBEROFENEMIES)
	dec a
	or a
	ret Z
	ld (NUMBEROFENEMIES),a
	ld a,199
	ld (KURAICOUNTER),a
	jr PUTENEMY2
PUT2:
	ld (ENEMYST2),bc	
	ld (ENEMYHP2),de
	ld (ENEMYSPEED2),ix
	ld (ENEMYBACK2),hl
	ld bc,$2539
	call NASRWARP
	ld hl,(DUMMY1)
	ld (ENEMYDFD2),hl
	ld a,(NUMBEROFENEMIES)
	dec a
	or a
	ret Z
	ld (NUMBEROFENEMIES),a
	ld a,201
	ld (KURAICOUNTER),a
PUTENEMY2:
	jp PUTENEMY
PUT3:
	ld (ENEMYST3),bc	
	ld (ENEMYHP3),de
	ld (ENEMYSPEED3),ix
	ld (ENEMYBACK3),hl
	ld bc,$3B39
	call NASRWARP
	ld hl,(DUMMY1)
	ld (ENEMYDFD3),hl
	ret
DUNGEON6:
	ld hl,45
	ld (DUMMY1),hl
	pop af
	or a
	jr z,Enemy18
	cp 2
	jr z,Enemy17
	cp 4
	jr z,Enemy19
Enemy16:		;; bc == strength de == life
		;; ix == speed
	ld bc,90
	ld de,80
	ld ix,18
	ld (DUMMY1),ix
       	ld hl,ENEMY16
STARTPUT3:
	jp STARTPUT
Enemy18:
	ld bc,110
	ld de,210
	ld ix,50
       	ld hl,ENEMY18
	jr STARTPUT3
Enemy17:
	ld bc,70
	ld de,130
	ld ix,34
       	ld hl,ENEMY17
	jr STARTPUT3
Enemy19:
	ld bc,78
	ld de,150
	ld ix,30
       	ld hl,ENEMY19
	jr STARTPUT3

DUNGEON7:
	ld hl,60
	ld (DUMMY1),hl
	pop af
	or a
	jr z,Enemy20
	cp 2
	jr z,Enemy21
	cp 4
	jr z,Enemy18
Enemy22:
	ld bc,100
	ld de,300
	ld ix,50
       	ld hl,ENEMY22
	jr STARTPUT3
Enemy21:
	ld bc,140
	ld de,150
	ld ix,34
       	ld hl,ENEMY21
	jr STARTPUT3
Enemy20:
	ld hl,190
	ld (DUMMY1),hl

	ld bc,100
	ld de,200
	ld ix,40
       	ld hl,ENEMY20
	jr STARTPUT3
DUNGEON8:
	ld hl,100
	ld (DUMMY1),hl
	pop af
	or a
	jr z,Enemy21
	cp 2
	jr z,Enemy23
	cp 4
	jr z,Enemy24
Enemy25:
	ld bc,300
	ld de,300
	ld ix,50
       	ld hl,ENEMY25
STARTPUT4:
	jp STARTPUT
Enemy23:
	ld bc,440
	ld de,200
	ld ix,34
       	ld hl,ENEMY23
	jr STARTPUT4
Enemy24:
	ld bc,200
	ld de,200
	ld ix,40
       	ld hl,ENEMY24
	jr STARTPUT4
GIMPMAN:
	call DRAWWALLS        	
	call Enemy12
	ld a,1
	ld (NUMBEROFENEMIES),a
	dec a
	ld (ENEMYSPEED2),a
	ld (ENEMYSPEED3),a
	jp ITSALEADER


KURAI:
        	ld bc,$141F
        	ld hl,Kurai
        	jp NASRWARP







BATTLEMENU:
	ld bc,$3F22
        	ld hl,BattleMenu	;; Displays the Menu
        	call NASRWARP
	ld hl,(HP)		;; Displays Kurai's HP
	ld de,$1E4C
	call DISPHL
	ld bc,$2B42
	ld hl,ICONRING
	jp drawit2

BLANK1429:
        	ld bc,$1429
        	ld hl,KuraiBlank
	jp NASRWARP


RANDOM7:
  ld a,r
  srl a
  and 7   
  ld l,a
  ld h,0
  add hl,de
  ret

EFFECT:
	LD B,1
EFFECT1:
           	LD HL,$fc02+32
           	LD DE,8
      	push bc
SIDELINELOOP2:
           	LD A,$C0
             LD (HL),0
           	ADD HL,DE
             LD (HL),0
           	INC HL
           	DJNZ SIDELINELOOP2
	call CR_GRBCopy
	pop bc
	inc b
	ld a,b
	cp 105
	jr nz,EFFECT1
	ret



HEALLOOPER:
	ld b,55
HEALLOOP:
	push bc
	ld a,r
	srl a
	and 15
	add a,15
	ld (BKX),a
	ld a,r
	srl a
	and 18   
	add a,35
	ld (BKY),a
	ld hl,HEALSPRITE
	call drawit
	ld a,(BKX)
	add a,8
	ld (BKX),a
	ld a,r
	srl a
	and 10   
	add a,40
	ld (BKY),a
	ld hl,HEALSPRITE
	call drawit
	pop bc 
	djnz HEALLOOP 
	ret

REFILL:
	ld bc,(BKX)
	push bc	
	ld bc,$2042
	ld hl,ERASURE
	call drawit2
	ld a,74
	ld (BKX),a
	ld hl,ERASURE
	call drawit
	ld a,82
	ld (BKX),a
	ld hl,ERASURE
	call drawit
	ld a,84
	ld (BKX),a
	ld hl,ERASURE2
	call drawit
	pop bc
	ld (BKX),bc
	ret

SWORDSWING:
	call BLANK1429
       	ld bc,$0B29
        	ld hl,Kurai4
        	call NASRWARP
        	call DELAY
        	ld bc,$0B29
        	ld hl,KuraiBlank
        	call NASRWARP
        	ld bc,$0B1C
        	ld hl,Kurai3
        	call NASRWARP
        	call DELAY
        	ld bc,$0B29
        	ld hl,KuraiBlank
        	call NASRWARP
        	ld bc,$031A
        	ld hl,Kurai5
        	call NASRWARP
	call DELAY
        	ld bc,$0329
        	ld hl,KuraiBlank
        	call NASRWARP
	jp KURAI	


ATTACKNUM2:
	ld a,(DUMMY1)
	dec a
	ld (BKX),a
	ld b,6
ATTACKLOOP2:
	push bc
	ld a,(BKX)
	inc a
	inc a
	ld (BKX),a
	ld a,7
	ld (BKY),a
	ld hl,ERASUREX
	call drawit
	ld a,12
	ld (BKY),a
	ld hl,ERASUREX
	call drawit
	pop bc
	djnz ATTACKLOOP2
	ret

DUMMY1DISP:
	ld (DUMMY1),hl
	ld de,100
	and a
	sbc hl,de
	jr nc,over100disp
	ld hl,(DUMMY1)
	ld de,$163E
	jp DISPHL	
over100disp:
	ld hl,(DUMMY1)
	jp DISPHL2
REDISP:
	ld a,(DUMMY1)
	or a
	jp z,KURAIMAGIC2
	pop hl
	call ERASEMENU	
	call DISPMP
	ld hl,WhichSpells
	inc hl
	inc hl
	inc hl
	inc hl
	ld a,(hl)
	or a	
	jr z,NEXT4
	push hl
             ld hl,Sire
	ld de, $1F49                    ;Y=2C,X=1A
	call DISPSTRING
	pop hl
NEXT4:
	inc hl
	ld a,(hl)
	or a
	jr z,NEXT5
	push hl
             ld hl,Rock
	ld de,$2649                    ;Y=2C,X=1A
	call DISPSTRING
	pop hl
NEXT5:
	inc hl
	ld a,(hl)
	or a
	jr z,NEXT6
	push hl
             ld hl,Haste
	ld de,$2D49                    ;Y=2C,X=1A
	call DISPSTRING	
	pop hl
NEXT6:
	inc hl
	ld a,(hl)
	or a
	jr z,DONEWITHM2
	push hl
             ld hl,Doom
	ld de,$3449                    ;Y=2C,X=1A
	call DISPSTRING	
	pop hl
DONEWITHM2:
	ld bc,$1F3F
	ld hl,CURSORMAGIC
	call drawit2
	ld hl,WhichSpells
	inc hl
	inc hl
	inc hl
	inc hl
	jp MAGICLOOP2



TALK2:
	ld bc,KuraiText8
	ld de,KuraiText7
	jp KURAITALKSWO3

TALK3:
	ld de,KuraiText9
	ld bc,KuraiText10
	ld hl,KuraiText11
	jp KURAITALKS

TALK4:
	ld bc,KuraiText13
	ld de,KuraiText12
	jp KURAITALKSWO3

TALK5:
	ld bc,KuraiText15
	ld de,KuraiText14
	jp KURAITALKSWO3

TALK10:
	ld bc,KuraiText26
	ld de,KuraiText25
	jp KURAITALKSWO32	

TALK11:
	ld de,KuraiText27
	ld bc,KuraiText28
	ld hl,KuraiText29
	jp KURAITALKS

TALK12:
	ld de,KuraiText30
	ld bc,KuraiText31
	jp KURAITALKSWO3


FAITHSWORD:
	ld de,$2210
	ld hl,BanditsText1
	jp DISPSTRING3

ERASEMENU:
	ld bc,$4020
        	ld hl,KuraiBlank	;; Displays the Menu
        	call NASRWARP
	call DRAWWALLS2

	ld bc,$1658
	ld hl,LINE
	jp drawit2

DISPMP:

	ld hl,YourMP
	ld de, $164A                   ;Y=2C,X=1A
	call DISPSTRING
	ld hl,(MP)
	ld de,$1652
	jp DISPHL

GOBACK:
	pop hl
	call ERASETEXT
	call BATTLEMENU
	call REFILL
	call KURAI
	ld a,1
	ld (OK),a
	jp  SPEEDLOOP

NEEDMP:
	ld hl,needmp
	ld de, $163E
	call DISPSTRING
	call ERASETEXT2
	call DISPMP
	ld hl,(Save)
	jp  MAGICLOOP2
NEEDMP2:
	ld hl,needmp
	ld de, $163E
	call DISPSTRING
	call ERASETEXT2
	call DISPMP
	ld hl,(Save)
	jp  SKILLLOOP2

SPELLCAST:
	ld (MP),hl
	;; Done BEFORE spell is cast..snazzy. :)
	call BLANK1429
	call KURAIMAGIC1
	ld bc,$1025
        	ld hl,KuraiOrb1
        	call NASRWARP
        	ld bc,$2225
        	ld hl,KuraiOrb1
        	call NASRWARP
        	call DELAY
	ld bc,$1025
        	ld hl,KuraiOrb2
        	call NASRWARP
	ld bc,$2225
        	ld hl,KuraiOrb2
        	call NASRWARP
	call DELAY
	ld bc,$1025
        	ld hl,KuraiOrb3
        	call NASRWARP
	ld bc,$2225
        	ld hl,KuraiOrb3
        	call NASRWARP
	call DELAY
	ld bc,$1025
        	ld hl,KuraiOrb4
        	call NASRWARP
	ld bc,$2225
        	ld hl,KuraiOrb4
        	call NASRWARP
	call DELAY
	
	ld b,3
FIRELOOP:
	push bc
	ld bc,$111D
        	ld hl,KuraiMagic2
        	call NASRWARP
	call DELAY
	call KURAIMAGIC1
	call DELAY
	pop bc
	djnz FIRELOOP
	ret

SLASH_ALL:	;; star spell and slash-all gfx
	ld b,2
STARTSTAR:	
	push bc
	xor a
	ld (OK),a
	ld a,15
	ld (DUMMY1),a
	ld a,5
	ld (DUMMY2),a
STARLOOP:
	ld a,(DUMMY1)
	ld b,a
	ld a,(OK)
	add a,b
	ld (BKX),a
	ld a,(DUMMY2)
	ld (BKY),a
	ld hl,SWORDSLASH1
	call drawit
	ld a,(DUMMY1)
	add a,20
	ld b,a
	ld a,(OK)
	add a,b
	ld (BKX),a
	ld a,(DUMMY2)
	ld (BKY),a
	ld hl,SWORDSLASH1
	call drawit
	ld a,(DUMMY1)
	add a,40
	ld b,a
	ld a,(OK)
	add a,b
	ld (BKX),a
	ld a,(DUMMY2)
	ld (BKY),a
	inc a
	ld (DUMMY2),a
	ld hl,SWORDSLASH1
	call drawit
	ld a,(OK)
	inc a
	ld (OK),a
	cp 10
	jr nz,STARLOOP
	pop bc
	djnz STARTSTAR
	ret


PutPixel:		;puts the pixel at b, c
	call FindPixel
	ld de,$0002
	add hl, de
	or (hl)
	ld (hl),a
     CALL _GRBUFCPY_V
	ret




;---------= Random number generator =---------
; input b=upper bound
; ouput a=answer 0<=a<b
; all registers are preserved except: af and bc
RAND:
      ld b,255 
	push	hl
	push	de
	ld	hl,(data)
	ld	a,r
	ld	d,a
	ld	e,(hl)
	add	hl,de
	add	a,l
	xor	h
	ld	(data),hl
	ld	hl,0
	ld	e,a
	ld	d,h
randl:	add	hl,de
	djnz	randl
	ld	a,h
	pop	de
	pop	hl
nomore:	ret


KURAIMAGIC1:
        	ld bc,$111D
        	ld hl,KuraiMagic1
	jp NASRWARP


REDISP2:
	ld a,(DUMMY1)
	or a
	jp z,KURAISKILL2
	pop hl
	call ERASEMENU	
	call DISPMP
	ld hl,WhichSkills
	inc hl
	inc hl
	inc hl
	inc hl
	ld a,(hl)
	or a	
	jr z,NEXT4S
	push hl
             ld hl,ReLife
	ld de, $1F49                    ;Y=2C,X=1A
	call DISPSTRING
	pop hl
NEXT4S:
	inc hl
	ld a,(hl)
	or a
	jr z,NEXT5S
	push hl
             ld hl,Build
	ld de, $2649                    ;Y=2C,X=1A
	call DISPSTRING
	pop hl
NEXT5S:
	inc hl
	ld a,(hl)
	or a
	jr z,NEXT6S
	push hl
             ld hl,Xfrm
	ld de, $2D49                    ;Y=2C,X=1A
	call DISPSTRING	
	pop hl
NEXT6S:
	inc hl
	ld a,(hl)
	or a
	jr z,DONEWITHS2
	push hl
             ld hl,Bribe
	ld de, $3449                    ;Y=2C,X=1A
	call DISPSTRING	
	pop hl
DONEWITHS2:
	ld bc,$1F3F
	ld hl,CURSORMAGIC
	call drawit2
	ld hl,WhichSkills
	inc hl
	inc hl
	inc hl
	inc hl
	jp SKILLLOOP2

REGENLOOPER:
	ld (MP),hl
	ld b,4
REGENLOOP:
	push bc
	ld bc,$2322
	ld hl,RegenEffect
	call NASRWARP
	call DELAY3
	ld bc,$2822
	ld hl,BlankEnemy
	call NASRWARP
	call KURAI
	pop bc
	djnz REGENLOOP	
	ret


LEVELUP2:
	push hl
	call DRAWWALLS
	ld hl,LevelUp
	ld bc,$3E3B
	call NASRWARP	
	pop hl
LEVELUP:
	push hl
	ld hl,KuraiPortrait
	ld bc,$3C26
	call NASRWARP	
	pop hl
	ld (DUMMY1),hl
	ld bc,$130B
	ld hl,ALLOCATER
	call drawit2

gggg
	ld hl,Allocate
	ld de,$080A
	call DISPSTRING
	call DISPLAYSTATS	

FROMADD:
	ld hl,BlankText
	ld de,$082A
	call DISPSTRING
	ld hl,(DUMMY1)
	dec hl
	dec hl

	ld de,$082A
	call DISPHL
	call DRAWSTATS
ALLOCLOOP:	
	call _getky
      cp K_RIGHT
	jp z,ADDPOINT
	cp K_DOWN
	jr z,ALLOCDOWN
      cp K_UP
	jr nz,ALLOCLOOP	
ALLOCUP:
	ld a,(BKY)
	cp $13
	jr z,ALLOCLOOP	
	ld hl,ALLOCATER
	call drawit
	ld a,(BKY)
	sub 6
	ld (BKY),a
	ld hl,ALLOCATER
	call drawit
	jr gggg ;ALLOCLOOP	
ALLOCDOWN:
	ld a,(BKY)
	cp $2B
	jr z,ALLOCLOOP	
	ld hl,ALLOCATER
	call drawit
	ld a,(BKY)
	add a,6
	ld (BKY),a
	ld hl,ALLOCATER
	call drawit
	jr gggg ;ALLOCLOOP	

ADDPOINT:
	ld hl,(DUMMY1)
	dec hl
	dec hl
	ld de,0
	and a
	sbc hl,de
	jr z,DONEALLOCATE
	ld (DUMMY1),hl
	ld a,(BKY)
	cp $13
	call z,ADDHP
	cp $19
	call z,ADDMP
	cp $1F
	call z,ADDST
	cp $25
	call z,ADDINT
	cp $2B
	call z,ADDSPEED
	jp  FROMADD
ADDHP:
	ld hl,(MAXHP)
	inc hl
	inc hl
	ld (MAXHP),hl
	ret
ADDMP:
	ld hl,(MAXMP)
	inc hl
	inc hl
	ld (MAXMP),hl
	ret
ADDST:
	ld hl,(STRENGTH)
	inc hl
	inc hl
	ld (STRENGTH),hl
	ret
ADDINT:
	ld hl,(INTELLIGENCE)
	inc hl
	inc hl
	ld (INTELLIGENCE),hl
	ret	
ADDSPEED:	
	ld hl,(SPEED)
	inc hl
	inc hl
	ld (SPEED),hl
	ret
DONEALLOCATE:
	ld hl,(MAXMP)
	ld de,(MAXHP)
	ld (MP),hl
	ld (HP),de
	ld hl,(STRENGTH)
	ld (STRENGTHMAX),hl
	ld hl,(DEFENSE)
	ld (DEFENSEMAX),hl
	ld a,(KURAILEVEL)
	cp 8
	jr nc,NOW160
	ld de,80
	jr REGULARCONT
NOW160:
	ld de,160
REGULARCONT:
	ld b,a
	ld hl,0	
LVLADD:	
	add hl,de
	djnz LVLADD
	ld de,50
	add hl,de
	ld de,(TOLEVEL)
	add hl,de
	ld (TOLEVEL),hl
SKILLSPELLS:
	call EFFECT
	call DRAWWALLS
	call DELEXIT
	ld hl,ChooseSpells
	ld de,$0630
	call DISPSTRING
	ld bc,$060B
	ld hl,ALLOCATER
	call drawit2
	ld a,1
	ld (DUMMY1),a

	ld hl,Heal
	ld de,$0515
	call DISPSTRING
	ld a,$06
	ld (DUMMY2),a
	ld hl,(INTELLIGENCE)
	ld de,12
	and a
	sbc hl,de
	jp c,STARTADD2
	ld hl,Burn
	ld de,$0B15
	call DISPSTRING
	ld a,$0C
	ld (DUMMY2),a
	ld hl,(INTELLIGENCE)
	ld de,25
	and a
	sbc hl,de
	jp c,STARTADD2
	ld hl,Star
	ld de,$1115
	call DISPSTRING
	ld a,$12
	ld (DUMMY2),a
	ld hl,(INTELLIGENCE)
	ld de,34
	and a
	sbc hl,de
	jr c,STARTADD2	
	ld hl,Rage
	ld de,$1715
	call DISPSTRING
	ld a,$18
	ld (DUMMY2),a
	ld hl,(INTELLIGENCE)
	ld de,56
	and a
	sbc hl,de
	jr c,STARTADD2	
	ld hl,Sire
	ld de,$1D15
	call DISPSTRING
	ld a,$1E
	ld (DUMMY2),a
	ld hl,(INTELLIGENCE)
	ld de,70
	and a
	sbc hl,de
	jr c,STARTADD2	
	ld hl,Rock
	ld de,$2315
	call DISPSTRING
	ld a,$24
	ld (DUMMY2),a
	ld hl,(INTELLIGENCE)
	ld de,90
	and a
	sbc hl,de
	jr c,STARTADD2	
	ld hl,Haste
	ld de,$2915
	call DISPSTRING
	ld a,$2A
	ld (DUMMY2),a
	ld hl,(INTELLIGENCE)
	ld de,99
	and a
	sbc hl,de
	jr c,STARTADD2	
	ld hl,Doom
	ld de,$2F15
	call DISPSTRING
	ld a,$30
	ld (DUMMY2),a
STARTADD2:
	ld hl,WhichSpells
STARTLOOP2:
	push hl
STARTLOOP:
	call _getky
        	cp K_RIGHT
	jr z,STARTADD
	cp K_DOWN
	jr z,STARTDOWN
	cp K_MORE
	jp z,BEGINSKILL
        	cp K_UP
	jr nz,STARTLOOP	
STARTUP:
	ld a,(BKY)
	cp $06
	jr z,STARTLOOP
	ld hl,ALLOCATER
	call drawit
	pop hl
	dec hl
	push hl
	ld a,(DUMMY1)
	dec a
	ld (DUMMY1),a
	ld a,(BKY)
	sub 6
	ld (BKY),a
	ld hl,ALLOCATER
	call drawit
	jr STARTLOOP	
STARTDOWN:
	ld a,(DUMMY2)
	ld b,a
	ld a,(BKY)
	cp b
	jr z,STARTLOOP	
	ld hl,ALLOCATER
	call drawit
	pop hl
	inc hl
	push hl
	ld a,(DUMMY1)
	inc a
	ld (DUMMY1),a
	ld a,(BKY)
	add a,6
	ld (BKY),a
	ld hl,ALLOCATER
	call drawit
	jr STARTLOOP	
STARTADD:
	pop hl
	ld a,(DUMMY1)
	ld b,a
	ld a,(hl)
	cp b
	jp z,ALREADYKNOW
	ld a,(DUMMY1)
	ld (hl),a		
	jr BEGIN2
BEGINSKILL:
	pop hl
;; begin adding skill
BEGIN2:
	call DRAWWALLS
	call DELEXIT
	ld hl,ChooseSkills
	ld de,$0630
	call DISPSTRING
	ld bc,$060B
	ld hl,ALLOCATER
	call drawit2

	ld hl,SlashAll
	ld de,$0515
	call DISPSTRING
	ld hl,Regeneration
	ld de,$0B15
	call DISPSTRING
	ld hl,HPMP
	ld de,$1115
	call DISPSTRING
	ld hl,Smoke
	ld de,$1715
	call DISPSTRING
	ld hl,ReLife
	ld de,$1D15
	call DISPSTRING
	ld hl,Build
	ld de,$2315
	call DISPSTRING
	ld hl,Xfrm
	ld de,$2915
	call DISPSTRING
	ld hl,Bribe
	ld de,$2F15
	call DISPSTRING

ADDSKILL2:
	ld hl,WhichSkills
STARTADD3:
	push hl
ADDLOOP:
	call _getky
        	cp K_RIGHT
	jr z,SKILLADD
	cp K_DOWN
	jr z,ADDDOWN
	cp K_MORE
	jr z,NOSKILL
        	cp K_UP
	jr nz,ADDLOOP	
ADDUP:
	ld a,(BKY)
	cp $06
	jr z,ADDLOOP
	ld hl,ALLOCATER
	call drawit
	pop hl
	dec hl
	push hl
	ld a,(BKY)
	sub 6
	ld (BKY),a
	ld hl,ALLOCATER
	call drawit
	jr ADDLOOP	
ADDDOWN:
	ld a,(BKY)
	cp $30
	jr z,ADDLOOP	
	ld hl,ALLOCATER
	call drawit
	pop hl
	inc hl
	push hl
	ld a,(BKY)
	add a,6
	ld (BKY),a
	ld hl,ALLOCATER
	call drawit
	jr ADDLOOP	
SKILLADD:
	pop hl
	ld a,(hl)
	cp 1
	jr z,ALREADYKNOW2
	ld (hl),1		
	push hl
NOSKILL:
	pop hl
	ret
ALREADYKNOW:
	push hl
	ld hl,Youknowit
	call DISPSTRING2
	call ERASETEXT2
	pop hl
	jp  STARTLOOP2	
ALREADYKNOW2:
	push hl
	ld hl,Youknowit
	call DISPSTRING2
	call ERASETEXT2
	pop hl
	jp  STARTADD3





.end
