#include "ti86asm.inc"

.org _asm_exec_ram

 call _clrScrn
 call _runindicoff

 ld hl,vopcdata
 ld de,vopc
 ld bc,14
 ldir

game:

;===draw the thing you control
 ld a,(vopc+1)
 ld hl,$fc01
 call drawc
 or a
 jp nz,exit
 ld a,(hl)
 or %10000000
 ld (hl),a

 ld a,(vopc+2)
 call drawc
 or a
 jp nz,exit
 ld a,(hl)
 or %10000000
 ld (hl),a

 ld de,16
d_wall:
 add hl,de
 xor a
 cp h
 jr nz,d_wall

;===score & level
 ld a,(vopc+10)
 inc a
 cp 10
 jr nz,no_point

 ld de,vopc+11
 call copyt
 inc hl
 dec de
 call copyf

 ld a,(vopc+13)
 inc a
 cp 100
 jr nz,no_nextlevel
 ld a,(vopc+2)
 dec a
 ld (vopc+2),a
 xor a
no_nextlevel:
 ld (vopc+13),a 

 xor a
no_point:
 ld (vopc+10),a

;===change line angle
 ld de,vopc+6
 call copyt

 inc hl
 ld a,$25
 cp h
 call z,newround

 ld de,vopc+6
 call copyf

 ld a,(vopc+9)
 ld b,a
 ld a,(hl)
rotate:
 rrca
 djnz rotate

 and %111
 cp 6
 jr c,no_cway
 jr z,up_cway

down_cway:
 xor a
 ld (vopc+8),a
 jr no_cway

up_cway:
 ld a,1
 ld (vopc+8),a

no_cway:
 ld de,vopc+3
 call copyt

 ld de,16
 ld a,(vopc+8)
 or a
 jr z,downer

upper:
 ld a,(vopc+5)
 dec a
 cp 5
 jr z,down_cway
 ld (vopc+5),a
 sbc hl,de
 jr cont

downer:
 ld a,(vopc+5)
 inc a
 cp 57
 jr z,up_cway
 ld (vopc+5),a
 add hl,de

cont:
 ld de,vopc+3
 call copyf

 ld a,(hl)
 or 1
 ld (hl),a
 ld de,16
 add hl,de
 ld a,(hl)
 or 1
 ld (hl),a

;===scroll
 ld c,64
 ld hl,0
scroll:
 ld b,16
 or a
scroll2: 
 dec hl 
 rl (hl) 
 djnz scroll2 
 dec c 
 jr nz,scroll 

;===halt
 halt			;If you want to make the game faster,
 halt			;remove a halt from here. To slow it 
 halt			;down, add one.
 halt
 
;===read keys
 ld a,%11111110
 out (1),a
 in a,(1)
 bit 3,a
 jr z,go_up
 bit 0,a
 jr z,go_down
 call _getky
 cp K_EXIT
 jr z,exit
 jp game
 
;===
exit:
 call _clrScrn
 call _homeup
 ld hl,sco
 call _puts
 ld de,vopc+11
 call copyt
 xor a
 call _dispAHL
 jp _pause


;===
drawc:
 ld b,a 
 ld de,16
edge:
 add hl,de
 djnz edge
 ld a,(hl)
 and %10000000
 ret

;===
go_down:
 ld a,(vopc+2)
 ld b,a
 ld a,(vopc+1)
 add a,b
 cp 63
 jr z,cont2
 ld a,(vopc+1)
 inc a
 ld (vopc+1),a
 jr cont2

go_up:
 ld a,(vopc+1)
 cp 1
 jr z,cont2
 dec a
 ld (vopc+1),a

cont2:
 jp game

;### calls
copyt:
 ld a,(de)
 ld h,a
 inc de
 ld a,(de)
 ld l,a
 ret

copyf:
 ld a,h
 ld (de),a
 inc de
 ld a,l
 ld (de),a
 ret

newround:
 ld a,(vopc+9)
 inc a
 ld (vopc+9),a
 ld hl,0
 ret

;### vars

vopcdata:
.db 0,20,22,$fd,$8f,25,0,0,0,1,0,0,0,0

sco:
.db "score:"
vopc:
.end



;;;;;;;;;;;;;;;;;;;
addr = vopc
size = vopc+2
lineaddr = vopc+3
linepos = vopc+5
romaddr = vopc+6
way = vopc+8
round = vopc+9
scorec = vopc+10
score = vopc+11
