/* Connect 4 project by olcay cirit */
#name "Connect4"

#include <ti.h>
#include <sprite_t.c>
#include <sprite_x.c>
#include <line.c>

char board[42]; /* stores board data */
char top[7];    /* stores number of pieces in column */

/* Simple macros for accessing board */
#define setboard(x,y,v) board[(y*6)+x] = v  
#define getboard(x,y)   board[(y*6)+x]

char turn;
char choice;
char k;
char px;
char win;

/* sprite references */
extern char blackchk[7];  /* black checker */
extern char whitechk[7];  /* white checker */
extern char arrow[5];     /* selector arrow */

main() {

	char x,y;

	indicatoroff; /* Turn off indicator, clear screen, etc */
	clrlcd;

	setxy(0,0);
	puts("\n\
    Connect 4 \n\
\n\
  By: Olcay Cirit");

	getkey();

	clrscrn;

	initboard();
	drawboard();

	do {
		k=0;
		pickslot();
		if (k != kExit) {
			if (top[choice] > 0) {
				move(choice, turn);
				checkwin();
				if (win==1) {
					setxy(0,7);
					if (turn==1) 
						puts("Player 1 Wins!");	
					else
						puts("Player 2 Wins!");
					getkey();
					k = kExit;
				}

				if (turn==1) 
					turn=2;
				else
					turn=1;
			}
		}
	}
	while(k != kExit);

	clrscrn;
	clrlcd;
}

pickslot ()
/* Allows user to pick slot */
{

	sprite_tran(arrow,px,48,7,5);

	do {
	k=getkey();
	sprite_xor(arrow,px,48,7,5);
	
	if ((k==kLeft) && (choice!=0)) 
		choice--;
	else if((k==kRight) && (choice!=6))
		choice++;

	px = choice * 8;
	sprite_tran(arrow,px,48,7,5);

	}while(k!=kExit && k!=kEnter);

	sprite_xor(arrow,px,48,7,5);
}


move(x,player) char x; char player;
/* move in column x, for player c */
{
	char y;

	y = --top[x];

	setboard(x,y,player);

	if (player==1)
		sprite_trans(whitechk, x*8, y*8, 7, 7);
	else
		sprite_trans(blackchk, x*8, y*8, 7, 7);	

}

checkwin() {

	char x,y,x2,y2;

	win = 0;

	for (x=0;x<7;x++) {
	for (y=0;y<6;y++) {
	if (getboard(x,y)==turn) {

	/* horizontal connect four */
	if (x < 4) {
		x2 = x+1;
		while(((x2-x)<4) && (getboard(x2,y)==turn)) x2++;
		if ((x2-x)==4) win=1;
	}

	/* Vertical connect four */
	if (y < 3) {           
		y2 = y+1;
		while(((y2-y)<4) && (getboard(x,y2)==turn)) y2++;
		if ((y2-y)==4) win=1;
	}

	/* Southeast connect four */
	if ((x < 4) && (y < 3))  {
		x2 = x+1;
		y2 = y+1;
		while(((x2-x) < 4) && (getboard(x2,y2)==turn)) {
			x2++; y2++; 
		}
		if ((x2-x)==4) win=1;
	}

	/* Northeast connect four */
	if ((x < 4) && (y > 2))  {
		x2 = x+1;
		y2 = y-1;
		while(((x2-x) < 4) && (getboard(x2,y2)==turn)) {
			x2++; y2--;
		}
		if ((x2-x)==4) win=1;
	}

	}
	}
	}
		
}

initboard () {
/* Clears board variables in memory */
	char n;

	turn = 1;
	choice = 0;
	px = 0;

	for (n=0;n<42;n++)
		board[n]=0;
	for (n=0;n<7;n++)
		top[n]=6;

}


drawboard () {
/* Draws the lines for the connect-four board */

	char n;

	for (n=7;n<55;n+=8)
		line(n,0,n,46,PT_ON);

	for (n=7;n<47;n+=8)
		line(0,n,54,n,PT_ON);

}

/* Sprites */

#asm

blackchk:
	.db 00111000b
	.db 01111100b
	.db 11111110b
	.db 11111110b
	.db 11111110b
	.db 01111100b
	.db 00111000b

whitechk:
	.db 00111000b
	.db 01000100b
	.db 10000010b
	.db 10000010b
	.db 10000010b
	.db 01000100b
	.db 00111000b


arrow:
	.db 00010000b
	.db 00111000b
	.db 01111100b
	.db 11111110b
	.db 00000000b

#endasm
