;  Welcome to Columns v3.0, (c) Mel Tsai!
;  Ti-82 Port: Dines Christy Justeen
;  Ti-83 Port: Ahmed R. El-Helw [http://asm8x.home.ml.org]
;  Ti-83 Slow Down: Joe Wingerbermuhle [http://www.usmo.com/~joewing/]
;  Ti-83/+ Port: Joel Seligstein and Jonathan Tobe
;
;
;  To play this game, select the difficulty level using the left and right
;  buttons.  After this, you must turn the calculator on its side, and use
;  the arrow keys to move and the "2nd" key to flip the block (I've found
;  that it is easiest to play with the left hand holding the calculator and 
;  the right index and middle fingers controlling the arrow keys, with the 
;  thumb pressing 2nd).

;  The "more" key pauses and the "exit" key exits.  To "warp out" and save 
;  your game in the current position, simply press "enter".  The next time  
;  you start columns, press "more" to set the blocks back in motion.

;  Simply match 3 or more blocks in a row (horizontally, vertically, or 
;  diagnally) to increase your score!  Every 255 blocks, your level will
;  be increased (to a maximum of level 9).

;  Since the calculator screen is small, I wanted to utilize more screen 
;  space for this game so it would be easier to see.  This is why everything
;  is turned on its side.  


;  This is the assembly source to the original Columns game.  Please don't
;  modify this source unless you don't plan to distribute it.  Also, don't 
;  "cut and paste" from this unless I'm given appropriate credit in your
;  program.  However, you can take ideas from this and use them, as long as
;  you aren't merely copying!  That's the reason why I'm releasing this.

;      If you have any improvement ideas for this game, mail me at 
;      tsaimelv@pilot.msu.edu and I may just do it, and I'll give you credit.
;      I have, however, pretty much stopped all development in this game.

;  Thanks to Magnus Hagander's TEXAN.ASM for helping me with figuring out
;  some of the zshell programming techniques!

;  This is my first program, it is in no way optimized, it's not well 
;  documented, and it may be difficult to understand some parts.  
;  Again, send any comments/questions/bug reports/game ideas/etc. to 
;  tsaimelv@pilot.msu.edu.

;  Changes from Columns v2.0:

;  1.  Fixed the "infinite blocks" bug.

;  2.  Added a "super block" in which whatever block type it lands on,
;  all of those blocks on the screen will disappear.  The block will come
;  down approximately 2% of the time, more or less.

;  3.  Added 2 new levels of difficulty, "Very Hard" and "Impossible."
;  Very Hard has 7 different blocks and Impossible has 8 (the original
;  "easy" level has 4, "medium" has 5 and "hard" has 6).

;  4.  Added an Instruction page so people won't get confused...

;  5.  Added 2 speed levels for a maximum speed level of 9 (instead of
;  the original 7).

;  6.  Made it so that your level will increase every 127 blocks instead
;  of 256.  Hopefully this will get rid of those 1 hour games...

;  7.  I tried to optimize the game to make it smaller, but it's not much
;  of an improvement.  The new features just add so much space that the
;  improvements are hidden...

;*Translated for Ash by Dines Justesen (after Mel Tsai had aproved)
;*TI82 related comments are marked with a *
;**Ti-83 related comments are marked with a **
;**Ported to the Ti-83 by Ahmed El-Helw (after Dines had approved)
.nolist
#include "ion.inc"
#include "keys.inc"
.list
#ifdef TI83P
        .org    progstart-2
        .db     $BB,$6D
#else
        .org    progstart
#endif
        ret
        jr      nc,start
Title: .db "Columns v3.0", 0


DEFINITIONS:                            

; Block memory structure: I organized it so that the bottom left block (1,1)
; type is stored at $80DF, the top left block (16,1) at $80EE, the bottom
; right block (1,7) at $813F and the top right block (16,7) at $814E.
; This way each column takes up 16 bytes, i.e. block (1,2) is stored at
; $80EF, which is 1 plus block (16,1).
;*This data has been moved to the APD buffer. This is done by adding Offset
;*All the placed where the adrs are used. Remember to write zeros to it !
;**Moved to $8265 for the 83
.nolist
#define Offset saferam1+100-$80DF
.list
; vars start at $814F, after block mem. 
;*These have been moved to text since that it is not used for other purposes
;*anymore.
;**This is 83 equivelent of TEXT_SHADOW

BlocksTotal = TEXT_MEM                  ; (2 bytes) 16 bit score.
BlocksTotalTemp = TEXT_MEM+2            ; (2 bytes) used for comparison. 

Score1 = TEXT_MEM+$4                    ; 5 bytes unpacked from BlocksTotal,
Score2 = TEXT_MEM+$5                    ; displayed on screen as current score.
Score3 = TEXT_MEM+$6 
Score4 = TEXT_MEM+$7 
Score5 = TEXT_MEM+$8 

TopType = TEXT_MEM+$9                   ; used for holding 3 current block 
MidType = TEXT_MEM+$A                   ; types.
BottomType = TEXT_MEM+$B

LevelCurrent = TEXT_MEM+$C              ; stores level, 1 through 7.
LevelString = TEXT_MEM+$D               ; ASCII string of Level_Current.

Ypos = TEXT_MEM+$E                      ; Y position of current bottom block.
Xpos = TEXT_MEM+$F                      ; X position of current bottom block.

Blocknum = TEXT_MEM+$10                 ; game difficulty, equals 4,5,6,7,or 8

SuperTemp = TEXT_MEM+$11                ; signifies super block

SaveAF = TEXT_MEM+$12                   ; This is used for KEYLOOP_B
SaveAF2 = TEXT_MEM+$13

DelayTemp = TEXT_MEM+$14                ; Saves delay variable
DelayTemp2 = TEXT_MEM+$15

TopTemp = TEXT_MEM+$16
MidTemp = TEXT_MEM+$17
BottomTemp = TEXT_MEM+$18

Initial1 = TEXT_MEM+$19                 ; three stored initials.
Initial2 = TEXT_MEM+$1A
Initial3 = TEXT_MEM+$1B
                                        ; Temporary Storage.
Temp1 = TEXT_MEM+$1C                    ; These are mostly used as 2 byte
Temp2 = Temp1+1                         ; variables, spilling over to the next
Temp3 = Temp2+1                         ; byte.
Temp4 = Temp3+1
Temp5 = Temp4+1
Temp6 = Temp5+1
Temp7 = Temp6+1
Temp8 = Temp7+1
Temp9 = Temp8+1
Temp10 = Temp9+1
Temp11 = Temp10+1
Temp12 = Temp11+1
Temp13 = Temp12+1
Temp14 = Temp13+1
Temp15 = Temp14+1
Temp16 = Temp15+1


Start:
        ld hl,saferam1
        ld de,saferam1+1
        xor a
        ld (hl),a
        ld bc,700
        ldir
    
;    res 1, (IY+05)                  ; print 6 rows of menu style.
;    res 3, (IY+05)                  ; write over current screen.    
;    res 1, (IY+0D)                  ; don't alter text memory.
    
;        ld hl, $8C40                    ; tell zshell to recalc checksum
;        set 0, (hl)                     ; upon exit.
;*Not needed in Ash

    ; first thing to do, see if we have a saved level
    
    ld hl,GameSaved
    ld a, (hl)
    or a
    jp nz,REPLACE_GAME

    ; second thing to do, draw title strings in menu style
    
        ld hl, $0200                    
    ld (currow), hl
    ld hl, Title_1
    bcall(_puts)              ; display "Columns  v3.0"

        ld hl, $0001                    
    ld (currow), hl
    ld hl, Title_2
    bcall(_puts)

        ld hl,16*256+8                    
        ld (pencol), hl
    ld hl, Title_3
    bcall(_vputs)

    ld hl,26*256+5
    ld (pencol),hl
    ld hl,Title_11
    bcall(_vputs)

    ld hl,33*256+18
    ld (pencol),hl
    ld hl,Title_12
    bcall(_vputs)

        ld hl, 40*256+0                    
        ld (pencol), hl
    ld hl, Title_4
    bcall(_vputs)

        ld hl, $3820-$10                    ; y=54 x=32 
        ld (pencol), hl
    ld hl, Title_10
    bcall(_vputs)
    
    ld a, 4                         ; set initial difficulty to "Easy".
    ld (Blocknum), a                ; Easy=4, Medium=5, Hard=6, etc.
                      
    ld a, 1                         ; set initial block types used for 
    ld (TopTemp), a                 ; RANDINC.
    ld (MidTemp), a
    ld (BottomTemp), a
    
    jp TITLEBLOCKS_4            

KEYLOOP_A:
    bcall(_getcsc)            ;** Note that this is $4014 on the 83
    ld (Temp1), a
    call RANDINC                   ; this becomes the random seed generator.
    ld a, (Temp1)
    or a
    jr z, KEYLOOP_A                 ; go back if no key pressed (F register 
                    ; saved in RANDINC.
    cp skclear                         ; Exit pressed?
    ret z                           ; yes, exit to zshell.
    cp skright                          ; Right pressed?
    jp z,PLUS_PRESSED               ; yes.
    cp skleft                          ; Left pressed?
    jp z,MINUS_PRESSED              ; yes.
    cp sk2nd                          ; 2nd key pressed?
        jp z,INSTRUCTIONS               ; yes.
    jr KEYLOOP_A                    ; invalid key, go back.

PLUS_PRESSED:
    ld a, (Blocknum)
    inc a
    cp 9                            ; Blocknum too big?
    jr z, PLUS_B                    ; yes.
    ld (Blocknum), a                
    jp DRAWTITLEBLOCKS
PLUS_B:
    ld a, 4
    ld (Blocknum), a
    jp DRAWTITLEBLOCKS

MINUS_PRESSED:
    ld a, (Blocknum)
    dec a
    cp 3                            ; Blocknum too small?
    jr z, MINUS_B                   ; yes.
    ld (Blocknum), a                
    jp DRAWTITLEBLOCKS    
MINUS_B:
    ld a, 8
    ld (Blocknum), a
    jp DRAWTITLEBLOCKS
    
DRAWTITLEBLOCKS:
    ld a, (Blocknum)
    cp 4
    jp z,TITLEBLOCKS_4
    cp 5
    jp z,TITLEBLOCKS_5
    cp 6
    jp z,TITLEBLOCKS_6
    cp 7
    jp z,TITLEBLOCKS_7
    cp 8
    jp z,TITLEBLOCKS_8
    
TITLEBLOCKS_4:
    ; now print "Easy  "
        ld hl, $2F2D-$10                    
        ld (pencol), hl
    ld hl, Title_5
    bcall(_vputs)
    jp KEYLOOP_A

TITLEBLOCKS_5:
    ; now print "Medium"
        ld hl, $2F2D-$10                    
        ld (pencol), hl
    ld hl, Title_6
    bcall(_vputs)
    jp KEYLOOP_A

TITLEBLOCKS_6:
    ; now print "Hard"
        ld hl, $2F2D-$10                    ; y=44, x=80
        ld (pencol), hl
    ld hl, Title_7
    bcall(_vputs)
    jp KEYLOOP_A

TITLEBLOCKS_7:
    ; now print "Very Hard"
        ld hl, $2F2D-$10                   ; y=44, x=80
        ld (pencol), hl
    ld hl, Title_8
    bcall(_vputs)
    jp KEYLOOP_A  

TITLEBLOCKS_8:
    ; now print "Impossible"
        ld hl, $2F2D-$10                    ; y=44, x=80
        ld (pencol), hl
    ld hl, Title_9
    bcall(_vputs)
    jp KEYLOOP_A  

INSTRUCTIONS:
    bcall(_clrLCDFull)
    ld hl,TeacherStr
        ld de, $0000
        ld (pencol), de
    bcall(_vputs)
    
        ld de, $0700
        ld (pencol), de
    bcall(_vputs)
    
        ld de, $0E00
        ld (pencol), de
    bcall(_vputs) 
    
        ld de, $1500
        ld (pencol), de
    bcall(_vputs) 
    
        ld de, $1C00
        ld (pencol), de
    bcall(_vputs) 
    
        ld de, $2300
        ld (pencol), de
    bcall(_vputs) 
    
        ld de, $2A00
        ld (pencol), de
    bcall(_vputs)
    
        ld de, $3100
        ld (pencol), de
    bcall(_vputs)
    
        ld de, $3800
        ld (pencol), de
    bcall(_vputs)

        ld hl, $3810                     
        ld (pencol), hl
    ld hl, Title_10
    bcall(_vputs)

PAUSE_2:
    bcall(_getcsc); GET_KEY
    or a
    jr z, PAUSE_2
    cp $36
    jp z,DRAWSCREEN                 ; 2nd pressed, Start Game
    cp skclear                          ; exit pressed
    ret z
        jr PAUSE_2                      ; invalid key

DRAWSCREEN:                             ; draws initial playfield
    bcall(_clrLCDFull)
    ld hl, $3A01                    ; y=58 x=01
        ld (pencol), hl
    ld hl, Screen_1
    bcall(_vputs)
    
    ld hl, $3A40                    ; y=58 x=64
        ld (pencol), hl
    ld hl, Screen_2
    bcall(_vputs)

    xor a
    ld (SuperTemp), a
    ld hl, $0000
    ld (BlocksTotal), hl            ; initialize BlocksTotal.
    ld a,1
    ld (LevelCurrent), a            ; initialize LevelCurrent.
    call UPDATE_SCORE
    call UPDATE_LEVEL             ; print level and score on screen
    jp MAIN

RANDINC:                                ; random function subroutine.
    ld a, (Blocknum)                ; this works on the fact 
    inc a                           ; that the computer is so fast
    ld b, a                         ; that by the time you press a key
    ld a, (TopTemp)                 ; to move, it can increment 3 variables
    inc a                           ; hundreds of times.  These 3 variables
    cp b                            ; become the random blocks generated!
    jr z, RANDINC_1                
    ld (TopTemp), a
    ret
RANDINC_1:
    ld a, 1
    ld (TopTemp), a
    ld a, (MidTemp)
    inc a
    cp b
    jr z, RANDINC_2
    ld (MidTemp), a
    ret
RANDINC_2:
    ld a, 1
    ld (MidTemp), a
    ld a, (BottomTemp)
    inc a
    cp b
    jr z, RANDINC_3
    ld (BottomTemp), a
    ret
RANDINC_3:
    ld a, 1
    ld (BottomTemp), a
    ret

UPDATE_SCORE:
    ld hl, (BlocksTotal)
    ld de, Score1+4
    ld b, 5
SCORELOOP:
    bcall(_divhlby10) ;call $4008      ;** 83 equivelent of UNPACK_HL
    add a, '0'                      
    ld (de), a                      
    dec de
    djnz SCORELOOP
    
    ld hl, $3A1E
        ld (pencol), hl
    ld hl, Score1
    ld b, 5
    bcall(_vputsn)
    ret

UPDATE_LEVEL:
    ld a, (LevelCurrent)
    ld hl, $0000
    ld l, a
    ld de, LevelString
    bcall(_divhlby10) ;call $4008      ;** 83 equivelent of UNPACK_HL
    add a, '0'
    ld (de), a
    
    ld hl, $3A5A                    ; y=58, x=90
        ld (pencol), hl
    ld hl, LevelString
    ld b, 1                         ; 1 character string...
    bcall(_vputsn)
    ret

;  Now start to play the game!

MAIN:                                   ; This is called after blocks are placed
        ld hl, $811C+Offset-4           ; Address of block (14,4)
    ld a, (hl)
    or a
        jp nz,LOSEGAME               ; we can't have a block there!
    call UPDATE_SCORE
    call UPDATE_LEVEL
    call CALCDELAY
    ld (DelayTemp), de
    
    ld a, r
    cp 10
    jp z,SUPERBLOCK
    cp 80
    jp z,SUPERBLOCK
    cp 130
    jp z,SUPERBLOCK
    cp 190
    jp z,SUPERBLOCK
    cp 240
    jp z,SUPERBLOCK

    ld a, (TopTemp)                 ; load mem with initial block
    ld (TopType), a
    ld a, (MidTemp)
    ld (MidType), a
    ld a, (BottomTemp)
    ld (BottomType), a
    
MAIN_2:
        ld hl, $0A04;$0E04                    ; x=14, y=4
    ld (Ypos), hl                   ; load initial block position
    call REDRAW_CURRENT
    jp KEYLOOP_B

SUPERBLOCK:
    ld a, 9
    ld (TopType), a
    ld (MidType), a
    ld (BottomType), a
    ld a, 1
    ld (SuperTemp), a
    jp MAIN_2

; redraws the current 3 blocks on the screen
REDRAW_CURRENT:                         ; hl must equal bottom block position
    ld a, (BottomType)
    call DRAWBLOCK
    ld a, (MidType)
    inc h
    call DRAWBLOCK
    ld a, (TopType)
    inc h
    call DRAWBLOCK
    ret

KEYLOOP_B:
    bcall(_getcsc) ; GET_KEY
    ld (Temp1), a
    ld de, (DelayTemp)
    dec de
    ld (DelayTemp), de
    ld hl, $0000
    bcall(_CPHlDE)
    jp z,MOVEDOWN
    call RANDINC
    ld a, (Temp1)
    or a
    jp z,KEYLOOP_B

    cp $02                       ; down key pressed (actually left key!)
    jp z,MOVEDOWN 
    cp $04
    jp z,MOVELEFT
    cp $01
    jp z,MOVERIGHT
    cp $36
    jp z,FLIPBLOCK               ; 2nd key pressed
    cp skmode
    jp z,PAUSE                   ; More key pressed
    cp skclear
    ret z                        ; Exit key pressed, go to zshell
    cp skdel
    jp z,SAVEGAME
    jp KEYLOOP_B

PAUSE:
    bcall(_getcsc) ; GET_KEY
    or a
    jr z, PAUSE
    cp skmode
    jp z,KEYLOOP_B                  ; more pressed, return
    jr PAUSE                        ; invalid key

CALCDELAY:                              ; loads de with a delay value, depending
                    ; on current level.
    ld a, (LevelCurrent)
    ld hl, DelayString
CALCLOOP:
    dec a
    inc hl
    inc hl
    or a
    jr z, PUT_DELAY
    jr CALCLOOP

PUT_DELAY:
    ld e, (hl)
    inc hl
    ld d, (hl)                      ; remember, there is no --ld de, (hl)--
    ret

MOVEDOWN:
    ld hl, (Ypos)
    dec h
    ld a, h
    or a                          ; are we at the bottom?
    jp z,PLACE_BLOCKS)            ; yes

    ld (Temp5), hl
    call GET_TYPE                 ; returns block type in a at current hl
    ld hl, (Temp5)
    or a                          ; block already there?
    jp nz,PLACE_BLOCKS            ; yes
    
    ld (Ypos), hl
    xor a
    inc h
    inc h
    inc h
    call DRAWBLOCK                  ; we can move down, so delete top block.
    
    ld hl, (Ypos)                   ; replace original coordinates.
    call REDRAW_CURRENT
    call CALCDELAY                  ; reset delay
    ld (DelayTemp), de
    jp z,KEYLOOP_B                  ; all done!

MOVELEFT:
    ld hl, (Ypos)
    dec l
    ld a, l
    or a                            ; are we too far left?
    jp z,KEYLOOP_B)                 ; yes

    ld (Temp5), hl
    call GET_TYPE                   ; returns block type in a at current hl
    ld hl, (Temp5)
    or a                            ; block already there?
    jp nz,KEYLOOP_B                 ; yes

    ld (Ypos), hl                   ; delete blocks on screen and move left!
    xor a
    inc l
    call DRAWBLOCK
    inc h
    call DRAWBLOCK
    inc h
    call DRAWBLOCK
    ld hl, (Ypos)
    call REDRAW_CURRENT
    jp z,KEYLOOP_B

MOVERIGHT:
    ld hl, (Ypos)
    inc l
    ld a, l
    cp 8                            ; are we too far right?
    jp z,KEYLOOP_B                  ; yes

    ld (Temp5), hl
    call GET_TYPE                   ; returns block type in a at current hl
    ld hl, (Temp5)
    or a                            ; block already there?
    jp nz,KEYLOOP_B                 ; yes

    ld (Ypos), hl                   ; delete blocks on screen and move right!
        xor a
    dec l
    call DRAWBLOCK
    inc h
    call DRAWBLOCK
    inc h
    call DRAWBLOCK
    ld hl, (Ypos)
    call REDRAW_CURRENT
    jp KEYLOOP_B

FLIPBLOCK:
    ld a, (BottomType)              ; Flip around blocks
    ld d, a
    ld a, (MidType) 
    ld (BottomType), a
    ld a, (TopType)
    ld (MidType), a
    ld a, d
    ld (TopType), a
        LD HL,(Ypos)
    call REDRAW_CURRENT
    jp KEYLOOP_B

;  given a block address in hl (such as "(14,4)"), this returns the type and
;  actual address of the block in a and hl, respectively.
GET_TYPE:
    ld (Temp1), hl
    ld a, l
        ld hl, $80CE+Offset             ; start of variables minus 17
    ld bc, $0010                    ; bc = 16
GET_TYPE_LOOP:
    add hl, bc                      ; first find the column address
    dec a
    or a
    jr nz, GET_TYPE_LOOP

    ld (Temp3), hl                  ; now find column + row
    ld hl, (Temp1)
    ld b, 0
    ld c, h
    ld hl, (Temp3)
    add hl, bc
    ld a, (hl)                      ; hl=block address, a=block type
    ret

;  After a block hits the bottom or hits another block, this routine
;  loads it into the block memory for use in BLOCKCHECK.
PLACE_BLOCKS:
    ld a, (SuperTemp)
    cp 1
    jp z,SUPERBLOCK_2            ; do we have a superblock?
    
    ld hl, (Ypos)
    call GET_TYPE
    ld a, (BottomType)
    ld (hl), a
    inc hl
    ld a, (MidType)
    ld (hl), a
    inc hl
    ld a, (TopType)
    ld (hl), a
    jp SHOWBLOCKS

SUPERBLOCK_2:
    xor a
    ld (SuperTemp), a
    
    ld hl, (Ypos)
    dec h
    jp z,SUPERBLOCK_5
    call GET_TYPE
    ld b, 112                       ; 112 blocks in memory
        ld hl, $80DF+Offset

SUPERBLOCK_3:        
    ld c, (hl)
    cp c
    jr z, SUPERBLOCK_4
    inc hl
    djnz SUPERBLOCK_3
    jp SHOWDELETED

SUPERBLOCK_4:
    set 7, c
    ld (hl), c
    inc hl
    djnz SUPERBLOCK_3
    jp SHOWDELETED

SUPERBLOCK_5:
    inc h
    xor a
    call DRAWBLOCK
    inc h
    call DRAWBLOCK
    inc h
    call DRAWBLOCK
    jp MAIN

SUPERBLOCK_6:

; NOTICE:  For some reason, I mixed up references to "east" and "west" in 
; the next routine.  So when it says, checking "northeast", it's really 
; checking "northwest."  However, the algorhythm works fine, and you don't 
; have to change it.


; this routine checks to see if we have 3 blocks in a row anywhere.
BLOCKCHECK:
    ld de, $0101                    ; de is the x,y block pointer
        ld hl, $80DF+Offset             ; hl points to the (first) block mem address
CHECKLOOP:
    ld a, (hl)
    
    ld (Temp1), de                  ; re-initialize de and hl with
    ld (Temp3), hl                  ; new block positions
    
    ld b, a                         ; no block in address, go to 
    or a                            ; next column
    jp z,NEXTCOL

    res 7, b                        ; get b ready for comparison


N:                                      ; check for match in northern direction
    ld c, 1                         ; initialize counter
    inc hl
    inc d
    ld a, 17
    cp d                            ; too high?
    jp z,W                          ; yes.

    ld a, (hl)                      ; begin check
    res 7, a
    cp b                            ; are the blocks the same?
    jr z, N_2                       ; yes.
    jp W                            ; no.
N_2:
    inc c
    inc hl
    inc d
    ld a, 17
    cp d                            ; too high?
    jr z, N_3                       ; yes.
    ld a, (hl)
    res 7, a
    cp b                            ; are the blocks the same?
    jr z, N_2                       ; yes, check next block
N_3:
    ld a, 2
    cp c                            ; did we have 3 blocks in a row?
    jp z,W                          ; no.
N_4:
    dec hl
    set 7, (hl)                     ; tag all of the matching blocks
    dec c
    jr nz, (N_4)
    

W:                                      ; check west
    ld c, 1                         ; initialize counter
    
    ld de, (Temp1)                  ; reset coordinates
    ld hl, (Temp3)
    
    push de
    ld de, $0010
    add hl, de
    pop de
    inc e
    ld a, 8
    cp e
    jp z,NE                         ; jump if too far west

    ld a, (hl)                      ; begin check
    res 7, a
    cp b                            ; are the blocks the same?
    jr z, W_2                       ; yes.
    jp NE                           ; no.
W_2:
    inc c
    push de
    ld de, $0010
    add hl, de
    pop de
    inc e
    ld a, 8
    cp e
    jr z, W_3                       ; jump if too far west
    ld a, (hl)
    res 7, a
    cp b                            ; are the blocks the same?
    jr z, W_2                       ; yes, check next block
W_3:
    ld a, 2
    cp c                            ; did we have 3 blocks in a row?
    jp z,NE                         ; no.

    scf
    ccf
    ld de, $0010
W_4:
    sbc hl, de
    set 7, (hl)                     ; tag all of the matching blocks
    dec c
    jr nz, (W_4)
    

NE:                                     ; check northeast
    ld c, 1                         ; initialize counter
    
    ld de, (Temp1)                  ; reset coordinates
    ld hl, (Temp3)
    
    push de
    ld de, $000F
    scf
    ccf
    sbc hl, de
    pop de
    inc d
    ld a, 17
    cp d
    jp z,NW                         ; jump if too high
    dec e
    jp z,NW                         ; jump if too far east

    ld a, (hl)                      ; begin check
    res 7, a
    cp b                            ; are the blocks the same?
    jr z, NE_2                      ; yes.
    jp NW                           ; no.
NE_2:
    inc c
    push de
    ld de, $000F
    scf
    ccf
    sbc hl, de
    pop de
    inc d
    ld a, 17
    cp d
    jr z, NE_3                      ; jump if too high
    dec e
    jr z, NE_3                      ; jump if too far east

    ld a, (hl)                      ; begin check
    res 7, a
    cp b                            ; are the blocks the same?
    jr z, NE_2                      ; yes.
NE_3:
    ld a, 2
    cp c                            ; did we have 3 blocks in a row?
    jp z,NW                         ; no.

    ld de, $000F
NE_4:
    add hl, de
    set 7, (hl)                     ; tag all of the matching blocks
    dec c
    jr nz, (NE_4)
    

NW:                                     ; check northwest
    ld c, 1                         ; initialize counter
    
    ld de, (Temp1)                  ; reset coordinates
    ld hl, (Temp3)
    
    push de
    ld de, $0011
    add hl, de
    pop de
    inc d
    ld a, 17
    cp d
    jp z,NEXTBLOCK                 ; jump if too high
    inc e
    ld a, 8
    cp e
    jp z,NEXTBLOCK                  ; jump if too far west

    ld a, (hl)                      ; begin check
    res 7, a
    cp b                            ; are the blocks the same?
    jr z, NW_2                      ; yes.
    jp NEXTBLOCK                    ; no.
NW_2:
    inc c
    push de
    ld de, $0011
    add hl, de
    pop de
    inc d
    ld a, 17
    cp d
    jr z, NW_3                      ; jump if too high
    inc e
    ld a, 8
    cp e
    jr z, NW_3                      ; jump if too far west

    ld a, (hl)                      ; begin check
    res 7, a
    cp b                            ; are the blocks the same?
    jr z, NW_2                      ; yes.
NW_3:
    ld a, 2
    cp c                            ; did we have 3 blocks in a row?
    jp z,NEXTBLOCK                  ; no.

    scf
    ccf
    ld de, $0011
NW_4:
    sbc hl, de
    set 7, (hl)                     ; tag all of the matching blocks
    dec c
    jr nz, (NW_4)
    

NEXTBLOCK:
    ld de, (Temp1)                  ; reset coordinates and start checking
    ld hl, (Temp3)                  ; again!
    inc hl
    inc d
    ld a, 17
    cp d
    jp z,NEXTCOL
    jp CHECKLOOP
NEXTCOL:
    ld d, 1
    inc e
    ld (Temp1), de
    ld a, 8
    cp e
    jp z,SHOWDELETED              ; all done checking!
    ld h, d
    ld l, e
    call GET_TYPE                 ; finds hl address of next column
    ld de, (Temp1)
    jp CHECKLOOP                  ; go back and start over.


; This function deletes matching blocks on the screen, after a delay.
; This gives the effect of them "disappearing", and then being pushed 
; back down in DROPBLOCKS.
SHOWDELETED:
    ld hl, (BlocksTotal)
    ld (BlocksTotalTemp), hl        ; save BlocksTotal for later comparison
    
    ; now let's delay a while...
    ld b, $FF
    ld a, $FF
SHOW_1:
    dec b
    jr nz, SHOW_1
    dec a
    jr nz, SHOW_1
    ; all done delaying

        ld hl, $80DF+Offset
    ld de, $0101                    ; load hl and de with starting coordinates
SHOW_2:
    ld a, (hl)
    bit 7, a
    jr nz, SHOW_3
    inc hl
    inc d
    ld a, 17
    cp d
    jp z,SHOW_4
    jr SHOW_2
SHOW_3:
    xor a
    ld (Temp1), hl
    ld h, d
    ld l, e
    call DRAWBLOCK)
    ld hl, (BlocksTotal)
    inc hl
    ld (BlocksTotal), hl            ; increment and save score
    ld (Temp3), de
    call LEVELINC)                 ; increment level if needed.
    ld hl, (Temp1)
    ld de, (Temp3)
    inc hl
    inc d
    ld a, 17
    cp d                            ; too high?
    jr z, SHOW_4                    ; yep, increment column
    jp SHOW_2
SHOW_4:
    ld d, 1
    inc e
    ld a, 8
    cp e                            ; are we all done?
    jp z,DROPBLOCKS                 ; yes.
    jp SHOW_2                       ; no.

LEVELINC:                               ; subroutine increments level
    ld hl, (BlocksTotal)
    ld a, l                         
    res 7, a
    cp 127                          
    ret nz                          
    
    ld a, (LevelCurrent)
    inc a
    ld b, a
    ld a, 10                        
    cp b                            ; are we already at level 9?
    ret z                           ; yes.
    ld a, b                         ; no.
    ld (LevelCurrent), a
    ret

;  moves blocks down after matching blocks were erased.
DROPBLOCKS:
    ld hl, (BlocksTotal)
    ld de, (BlocksTotalTemp)
    bcall(_CPHLDE)                   ; were there any matching blocks?
    jp z,MAIN                       ; nope!  Start all over!

    ; now let's delay a while...
    ld b, $FF
    ld a, $FF
DROPBLOCKS_1:
    dec b
    jr nz, DROPBLOCKS_1
    dec a
    jr nz, DROPBLOCKS_1
    ; all done delaying

        ld hl, $80DF+Offset
    ld (Temp1), hl
    ld de, $0101
    ld (Temp3), de                  ; initialize coordinates in de and hl
DROPBLOCKS_2:
    ld hl, (Temp1)
    ld de, (Temp3)                  ; reset back to original coordinates
    
    ld a, (hl)
    bit 7, a                        ; does this block need to be deleted?
    jr nz, DROPBLOCKS_3             ; yes.
    inc hl                          ; no, go to next byte
    ld (Temp1), hl
    inc d
    ld (Temp3), de
    ld a, 17
    cp d
    jp z,DROPBLOCKS_4
    jr DROPBLOCKS_2
DROPBLOCKS_3:                           ; this routine moves all the blocks down
    inc hl                                 
    inc d
    ld a, 17
    cp d                            ; are we too high?
    jp z,DROPBLOCKS_5               ; yep.
    ld a, (hl)                      ; now drop each block down, one at a time
    dec hl
    ld (hl), a
    inc hl                          
    jr DROPBLOCKS_3                 ; go to next block to drop
DROPBLOCKS_4:   
    ld d, 1
    inc e                           ; go to next column
    ld (Temp3), de                  ; reset x,y position
    ld a, 8
    cp e                            ; are we already in column 7?
    jp z,SHOWBLOCKS                 ; yes
    jp DROPBLOCKS_2                 ; no
DROPBLOCKS_5:
    dec hl
    xor a
    ld (hl), a                      ; were at the top, so put a 0 in block 16,y
    jp DROPBLOCKS_2                 ; now start over

;  This routine completely redraws the blocks in memory.
SHOWBLOCKS:
        ld hl, $80DF+Offset                    ; starting block minus 1
    ld de, $0101
SHOWBLOCKS_1: 
    ld a, (hl)                      ; load block type into a
    push hl
    ld h, d                         ; load de into hl (for DRAWBLOCK)
    ld l, e                         
    call DRAWBLOCK
    pop hl
    inc hl
    inc d
    ld a, 17
    cp d
    jr z, SHOWBLOCKS_2
    jr SHOWBLOCKS_1
SHOWBLOCKS_2:
    ld d, 1
    inc e
    ld a, 8
    cp e                            ; are we already in column 7?
    jp z,BLOCKCHECK                 ; YES!!  Start over and recheck for 
                    ; new block matches.
    jp SHOWBLOCKS_1


;  This vital subroutine draws a block depending on its type and position.
DRAWBLOCK:                               
    ld (Temp7), hl                  ; a must contain block type, hl 
    ld (Temp9), de                  ; contains position
    ld (Temp11), bc
    ld (Temp13), a
    ; first find row...
        ld a,5      ;*Use AIL
        bcall(_lcdbusy)
        out ($10),a       
;        ld de, $FBFF                    ; Video mem minus 1
;        ld l, h
;        ld h, 0
;        add hl, de
;        ld b, h
;        ld c, l
        ld a,h    ;*make it a controller command
        dec a
        or $20
        ld b,a

    ; then find column...
;        ld hl, (Temp7)
;        ld a, l
;        ld de, 128
;        ld h, b
;        ld l, c
;DRAWBLOCK_A:
;        dec a
;        jr z, DRAWBLOCK_B
;        add hl, de
;        jr DRAWBLOCK_A
        ld a,l
        dec a
        sla a
        sla a
        sla a
        or $80    ;make it a controller command
        ld c,a
        LD A,B \ bcall(_lcdbusy) \ OUT ($10),A \ LD A,C \ bcall(_lcdbusy) \ OUT ($10),A
        ;*Set the controllers cursor to the correct position

DRAWBLOCK_B:                            ; hl now contains first pixel address
    ld a, (Temp13)
    or a
    jp z,DRAW_0
    cp 1
    jp z,DRAW_1
    cp 2
    jp z,DRAW_2
    cp 3
    jp z,DRAW_3
    cp 4
    jp z,DRAW_4
    cp 5
    jp z,DRAW_5
    cp 6
    jp z,DRAW_6
    cp 7
    jp z,DRAW_7
    cp 8
    jp z,DRAW_8
    cp 9
    jp z,DRAW_9
DRAW_0:                                 
        bcall(_lcdbusy)
    ld a,00000000b
        OUT ($11),A
        bcall(_lcdbusy)
        OUT ($11),A
        bcall(_lcdbusy)
        OUT ($11),A
        bcall(_lcdbusy)
        OUT ($11),A
        bcall(_lcdbusy)
        OUT ($11),A
        bcall(_lcdbusy)
        OUT ($11),A
        bcall(_lcdbusy)
        OUT ($11),A
        bcall(_lcdbusy)
        OUT ($11),A
    jp DRAWEND                  
DRAW_1:                               
        bcall(_lcdbusy)
       ld a,00000000b
        OUT ($11),A
                                      ;  I could have done this using
        bcall(_lcdbusy)                     ;  some sort of array in which you
    ld a,01111111b                 ;  increment hl to find the next
        OUT ($11),A                   ;  block line (depending on its type),
        bcall(_lcdbusy)                     ;  but (a) when I tried it it didn't
    ld a,01000001b                 ;  work and (b) this is faster.
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,01000001b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,01000001b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,01000001b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,01000001b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,01111111b
        OUT ($11),A
    jp DRAWEND
DRAW_2:
        bcall(_lcdbusy)
    ld a,00000000b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,01111111b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,01111111b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,01111111b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,01111111b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,01111111b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,01111111b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,01111111b
        OUT ($11),A
    jp DRAWEND
DRAW_3:
        bcall(_lcdbusy)
    ld a,00000000b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,00001000b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,00011100b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,00111110b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,01111111b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,00111110b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,00011100b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,00001000b
        OUT ($11),A
    jp DRAWEND
DRAW_4:
        bcall(_lcdbusy)
    ld a,00000000b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,01100011b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,01100011b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,00010100b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,00001000b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,00010100b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,01100011b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,01100011b
        OUT ($11),A
    jp DRAWEND

DRAW_5:
        bcall(_lcdbusy)
    ld a,00000000b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,01010101b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,00101010b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,01010101b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,00101010b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,01010101b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,00101010b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,01010101b
        OUT ($11),A
    jp DRAWEND
DRAW_6:
        bcall(_lcdbusy)
    ld a,00000000b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,01111111b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,01001001b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,01001001b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,01111111b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,01001001b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,01001001b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,01111111b
        OUT ($11),A
    jp DRAWEND

DRAW_7:
        bcall(_lcdbusy)
    ld a,00000000b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,00001000b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,00010100b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,00100010b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,01000001b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,00100010b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,00010100b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,00001000b
        OUT ($11),A
    jp DRAWEND

DRAW_8:
        bcall(_lcdbusy)
    ld a,00000000b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,01111111b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,00111110b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,00011100b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,00001000b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,00011100b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,00111110b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,01111111b
        OUT ($11),A
    jp DRAWEND

DRAW_9:
        bcall(_lcdbusy)
    ld a,00000000b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,01000001b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,01100001b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,01010001b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,01001001b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,01000101b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,01000011b
        OUT ($11),A
        bcall(_lcdbusy)
    ld a,01000001b
        OUT ($11),A
    jp DRAWEND

DRAWEND:
    ld hl, (Temp7)
    ld de, (Temp9)
    ld bc, (Temp11)
    ld a, (Temp13)
    ret

LOSEGAME:
    bcall(_clrLCDFull)
    ld a, (Blocknum)
    cp 4
    jp z,LOSEEASY
    cp 5
    jp z,LOSEMED
    cp 6
    jp z,LOSEHARD
    cp 7
    jp z,LOSEVHARD
    jp LOSEIMP
LOSEEASY:
    ld hl, EasyScore+3
    bcall(_ldhlind) ;call LD_HL_MHL
    ld de, (BlocksTotal)
    scf
    ccf
    sbc hl, de
    jp c,LOSEEASY_2
    jp GAMEOVER
LOSEEASY_2:
    call INPUT_INITIALS
    ld bc, 3
    ld hl, EasyScore
    ld d, h
    ld e, l
    ld hl, Initial1 
    ldir
    
    ld hl, EasyScore+3
    ld de, (BlocksTotal)
    ld (hl), e
    inc hl
    ld (hl), d

    ld a, (Blocknum)
    inc hl
        ld (hl),a
    jp GAMEOVER

LOSEMED:
    ld hl, MedScore+3
    bcall(_ldhlind) ;call LD_HL_MHL
    ld de, (BlocksTotal)
    scf
    ccf
    sbc hl, de
    jp c,LOSEMED_2
    jp GAMEOVER
LOSEMED_2:
    call INPUT_INITIALS
    ld bc, 3
    ld hl, MedScore
    ld d, h
    ld e, l
    ld hl, Initial1 
    ldir
    
    ld hl, MedScore+3
    ld de, (BlocksTotal)
    ld (hl), e
    inc hl
    ld (hl), d

    ld a, (Blocknum)
    inc hl
        ld (hl),a
    jp GAMEOVER

LOSEHARD:
    ld hl, HardScore+3
    bcall(_ldhlind) ;call LD_HL_MHL
    ld de, (BlocksTotal)
    scf
    ccf
    sbc hl, de
    jp c,LOSEHARD_2
    jp GAMEOVER
LOSEHARD_2:
    call INPUT_INITIALS
    ld bc, 3
    ld hl, HardScore
    ld d, h
    ld e, l
    ld hl, Initial1 
    ldir
    
    ld hl, HardScore+3
    ld de, (BlocksTotal)
    ld (hl), e
    inc hl
    ld (hl), d

    ld a, (Blocknum)
    inc hl
        ld (hl),a
    jp GAMEOVER

LOSEVHARD:
    ld hl, VHardScore+3
    bcall(_ldhlind) ;call LD_HL_MHL
    ld de, (BlocksTotal)
    scf
    ccf
    sbc hl, de
    jp c,LOSEVHARD_2
    jp GAMEOVER
LOSEVHARD_2:
    call INPUT_INITIALS
    ld bc, 3
    ld hl, VHardScore
    ld d, h
    ld e, l
    ld hl, Initial1 
    ldir
    
    ld hl, VHardScore+3
    ld de, (BlocksTotal)
    ld (hl), e
    inc hl
    ld (hl), d

    ld a, (Blocknum)
    inc hl
        ld (hl),a
    jp GAMEOVER

LOSEIMP:
    ld hl, ImpScore+3
    bcall(_ldhlind) ;call LD_HL_MHL
    ld de, (BlocksTotal)
    scf
    ccf
    sbc hl, de
    jp c,LOSEIMP_2
    jp GAMEOVER
LOSEIMP_2:
    call INPUT_INITIALS
    ld bc, 3
    ld hl, ImpScore
    ld d, h
    ld e, l
    ld hl, Initial1 
    ldir
    
    ld hl, ImpScore+3
    ld de, (BlocksTotal)
    ld (hl), e
    inc hl
    ld (hl), d

    ld a, (Blocknum)
    inc hl
        ld (hl),a
    jp GAMEOVER

GAMEOVER:
    bcall(_clrLCDFull)
        ld hl, $0028-$10                    
        ld (pencol), hl
    ld hl, GameOver_1
    bcall(_vputs)

        ld hl, $080F-$F
        ld (pencol), hl
    ld hl, GameOver_2S
    bcall(_vputs)

    ld hl, (BlocksTotal)
    ld de, Score1+4
    ld b, 5
GAMEOVER_2:
    bcall(_divhlby10) ;call $4008          ;** Unpack_HL equivelent on 83
    add a, '0'                      
    ld (de), a                      
    dec de
    djnz GAMEOVER_2
    
        ld hl, $083F-$15
        ld (pencol), hl
    ld hl, Score1
    ld b, 5
    bcall(_vputsn)
    ld a, (Blocknum)
    cp 4
    jp z,PRINTEASY
    cp 5
    jp z,PRINTMED
    cp 6
    jp z,PRINTHARD
    cp 7
    jp z,PRINTVHARD
    jp PRINTIMP

PRINTEASY:
        ld hl, (pencol)
    inc hl
    inc hl
    inc hl
        ld (pencol), hl
    ld hl, Title_5
    bcall(_vputs)
    jp GAMEOVER_3
PRINTMED:
        ld hl, (pencol)
    inc hl
    inc hl
    inc hl
        ld (pencol), hl
    ld hl, Title_6
    bcall(_vputs)
    jp GAMEOVER_3
PRINTHARD:
        ld hl, (pencol)
    inc hl
    inc hl
    inc hl
        ld (pencol), hl
    ld hl, Title_7
    add hl, de
    bcall(_vputs)
    jp GAMEOVER_3
PRINTVHARD:
        ld hl, (pencol)
    inc hl
    inc hl
    inc hl
        ld (pencol), hl
    ld hl, Title_8
    bcall(_vputs)
    jp GAMEOVER_3
PRINTIMP:
        ld hl, (pencol)
    inc hl
    inc hl
    inc hl
        ld (pencol), hl
    ld hl, Title_9
    bcall(_vputs)
    jp GAMEOVER_3

GAMEOVER_3:
        ld hl, $1028-$15
        ld (pencol), hl
    ld hl, GameOver_5
    bcall(_vputs)

        ld hl, $1820-$15
        ld (pencol), hl
    ld hl, EasyScore
    call PRINTHIGHSCORE
    
        ld hl, $2020-$15
        ld (pencol), hl
    ld hl, MedScore
    call PRINTHIGHSCORE
    
        ld hl, $2820-$15
        ld (pencol), hl
    ld hl, HardScore
    call PRINTHIGHSCORE
    
        ld hl, $3020-$15
        ld (pencol), hl
    ld hl, VHardScore
    call PRINTHIGHSCORE
    
        ld hl, $3820-$15
        ld (pencol), hl
    ld hl, ImpScore
    call PRINTHIGHSCORE
    
    jp WAIT_FOR_KEY

PRINTHIGHSCORE:
    ld b, 3
    ld (Temp1), hl
    bcall(_vputsn)
        ld hl, (pencol)
    inc l
    inc l
    inc l
    inc l
        ld (pencol), hl
    ld hl, (Temp1)
    inc hl
    inc hl
    inc hl
    ld (Temp1), hl
    bcall(_ldhlind) ;call LD_HL_MHL
    
    ld de, Score1+4
    ld b, 5
PRINTHIGHSCORE_2:
    bcall(_divhlby10) ;call $4008          ;** Ti-83 equivelent of UNPACK_HL
    add a, '0'                      
    ld (de), a                      
    dec de
    djnz PRINTHIGHSCORE_2
    
    ld hl, Score1
    ld b, 5
    bcall(_vputsn)

        ld hl, (pencol)
    inc l
    inc l
    inc l
    inc l
        ld (pencol), hl

    ld hl, (Temp1)
    inc hl
    inc hl
    ld a, (hl)
    cp 4
    jp z,PRINTHIGHSCORE_E
    cp 5
    jp z,PRINTHIGHSCORE_M
    cp 6
    jp z,PRINTHIGHSCORE_H
    cp 7
    jp z,PRINTHIGHSCORE_V
    jp PRINTHIGHSCORE_I
PRINTHIGHSCORE_E:
    ld hl, Title_5
    bcall(_vputs)
    ret
PRINTHIGHSCORE_M:
    ld hl,Title_6
    bcall(_vputs)
    ret
PRINTHIGHSCORE_H:
    ld hl,Title_7
    bcall(_vputs)
    ret
PRINTHIGHSCORE_V:
    ld hl,Title_8
    bcall(_vputs)
    ret
PRINTHIGHSCORE_I:
    ld hl,Title_9
    bcall(_vputs)
    ret

INPUT_INITIALS:
    bcall(_clrLCDFull)
        ld hl, $0122-$15                    ; y=1, x=34 (adjust)
        ld (pencol), hl
    ld hl, GameOver_3S  
    bcall(_vputs)
    
        ld hl, $1E1B-$15                    ; y=30, x=27 (adjust)
        ld (pencol), hl
    ld hl,GameOver_4  
    bcall(_vputs)
        ld hl, $2E35-$15                    ; y=46, x=60
        ld (pencol), hl                  ; this initializes where the 3 initials
                    ; will be put.
    ld de, Initial1
    ld (Temp3), de
INITIALS_A:
    bcall(_getcsc) ;call GET_KEY
    or a
    jr z, INITIALS_A
    ld hl, ASCII_Table-1
    ld c, 0
    ld b, a
INITIALS_B:        
    inc hl
    djnz INITIALS_B
    ld a, (hl)
    or a
    jp z,INITIALS_A)
    ld de, (Temp3)
    ld (de), a                      ; load key into InitialX variable
    bcall(_vputmap)
    ld de, (Temp3)
    inc de
    ld (Temp3), de
    ld hl, Initial3+1
    bcall(_cphlde) ;call CP_HL_DE
    jp nz,INITIALS_A
    ret

WAIT_FOR_KEY:
    bcall(_getcsc)
    cp skclear
    jr nz,wait_for_key
    ret

SAVEGAME:
    ld hl,GameSaved
    ld a, 1
        ld (hl),a                      ; tell columns that a game is saved
    
    ld hl,SaveMemory
    ld d, h
    ld e, l
        ld hl, $80DF+Offset
        ld bc,112; 140                      
    ldir                            ; store about 140 bytes to save game
        ld hl,TEXT_MEM
        ld bc,28
        ldir
    ret                             ; return to zshell.

REPLACE_GAME:
    ld hl,GameSaved
    xor a
        ld (hl),a                      ; reset GameSaved
    
    ld hl, SaveMemory
    ld de, $80DF+Offset
        ld bc, 112; 140
    ldir                            ; replace text memory
        ld de,TEXT_MEM
        ld bc,28
        ldir
REDRAWBLOCKS:
        ld hl, $80DF+Offset                    ; starting block minus 1
    ld de, $0101
REDRAWBLOCKS_1: 
    ld a, (hl)                      ; load block type into a
    push hl
    ld h, d                         ; load de into hl (for DRAWBLOCK)
    ld l, e                         
    call DRAWBLOCK
    pop hl
    inc hl
    inc d
    ld a, 17
    cp d
    jr z, REDRAWBLOCKS_2
    jr REDRAWBLOCKS_1
REDRAWBLOCKS_2:
    ld d, 1
    inc e
    ld a, 8
    cp e                            ; are we already in column 7?
    jp nz,REDRAWBLOCKS_1            ; no, start next column
    
    ld hl, (Ypos)                   ; redraw current blocks
    ld a, (BottomType)
    call DRAWBLOCK)
    ld a, (MidType)
    inc h
    call DRAWBLOCK)
    ld a, (TopType)
    inc h
    call DRAWBLOCK)

        ld hl, $3A01                    ; y=58 x=01
        ld (pencol), hl
    ld hl,Screen_1
    bcall(_vputs)
    
        ld hl, $3A40                    ; y=58 x=64
        ld (pencol), hl
    ld hl,Screen_2
    bcall(_vputs)

    call UPDATE_SCORE
    call UPDATE_LEVEL           ; print level and score on screen
    
    jp PAUSE                    ; all done!

;These are the strings used in the program:

Title_1: .db "Columns  v3.0", 0
Title_2: .db "Mel Tsai (c)1996", 0
Title_3: .db "tsaimelv@pilot.msu.edu", 0
Title_4: .db "Select Difficulty (L/R):", 0
Title_5: .db "Easy                     ", 0
Title_6: .db "Medium          ", 0
Title_7: .db "Hard                 ", 0
Title_8: .db "Very Hard       ", 0
Title_9: .db "Impossible      ", 0
Title_10: .db "Press 2nd to begin...", 0
Title_11: .db "ION Port by Jonathan Tobe",0
Title_12:   .db "and Joel Seligstein",0
;Title_12: .db "Ti-83 Port by Ahmed El-Helw",0

Screen_1: .db "Blocks:",0
Screen_2: .db "Level:",0

GameOver_1:   .db "Game Over!!!", 0
GameOver_2S:  .db "Final  Score:", 0            ;** Had to add the S, because
GameOver_3S:  .db "New High Score!", 0          ;**TASM confused it with the label.
GameOver_4:   .db "Please Enter Initials:", 0
GameOver_5:   .db "High Scores:", 0

;edit this to change speed in which the blocks fall...

DelayString: .dw 0,4700,4400,4100,3800,3500,3200,2900,2600,2300

EasyScore:   .db "000",0,0,4
MedScore:    .db "000",0,0,5
HardScore:   .db "000",0,0,6
VHardScore:  .db "000",0,0,7
ImpScore:    .db "000",0,0,8

;*Some strings have been mode shorter to make them fit on the display
TeacherStr:
.db "Instructions:  Turn the " 
.db "calc",0
.db "sideways (blocks "
.db "fall down)",0
.db "and get 3 blocks in a row!",0
.db "2ND- Rotates the block",0
.db "CLEAR- Quit Game",0
.db "MODE- Pause/Unpause",0
.db "DEL- Save game and exit,",0
.db "press CLEAR upon returning.",0


ASCII_Table:                   ;Thanks to Magnus H. for this Table!!!
;   .db 0,0,0,0,0,0,0,0,0       ;00-09 - not valid 
;   .db 'X,'T','O','J','E'      ;0A-0E - valid
;   .db 0,0                     ;0F-10 - not valid
;   .db ' ','W','S','N','I'     ;11-15 - valid
;   .db 'D'                     ;16    - valid
;   .db 0,0                     ;17-18 - not valid
;   .db 'Z','V','R','M','H','C' ;19-1E- valid
;   .db 0,0                     ;1F-20 - not valid
;   .db 'Y','U','Q','L','G','B' ;21-26 - valid
;   .db 0,0,0,0                 ;27-2A - not valid
;   .db 'P','K','F','A'         ;2B-2E - valid
;   .db 0,0,0,0,0,0,0,0,0,0     ;Rest  - not valid
;*Table not valid on TI82, the one blow was made from the info in 82-VARS.TXT
;*(see http://www.gbar.dtu.dk/~c958362/ash)
    .db 0,0,0,0,0,0,0                 ; 0..7
    .db 0,0,0,'W','R','M','H',0         ; 8..F
    .db 0,0,0,'V','Q','L','G',0         ; 10..17
    .db 0,0,'Z','U','P','K','F','C'     ; 18..1F
    .db 0,0,'Y','T','O','J','E','B'     ; 20..27
    .db 0,0,'X','S','N','I','D','A'     ; 28..2F
    .db 0,0,0,0,0,0,0,0                 ; 30..37
    .db 0,0                               ; 38
; These bytes are where a game is saved into memory when "enter" is pressed.

GameSaved: .db 0

SaveMemory: 
.dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw 0,0,0,0,0,0,0,0,0,0

; 140 memory bytes


.end
