#include "asm86.h"
#include "ti86asm.inc"

.org _asm_exec_ram

NewGame:
 call $4ab1		;Turns off RunIndicator
 ld a,1 		;Initializes the variables
 ld (LevNo),a

Start:
 call _clrLCD
 call IntVars
 call SetLevel		;Copies the level to a temp one
 call DrawBoard		;Draws the board
 call NewSel		;Draws Selector first time

KeyLoop:
 ei 
 halt
 call GET_KEY
 cp $01
 jp z,CursorDown
 cp $02
 jp z,CursorLeft
 cp $03
 jp z,CursorRight
 cp $04
 jp z,CursorUp
 cp $36
 jp z,SelectPiece
 cp $37
 ret z
 cp $38
 jr z,Start
 cp $0a
 jp z,NextLev
 cp $0b
 jp z,PrevLev
 ld a,(timers)
 or a
 jr z,KeyLoop
 ld a,(timer)
 dec a
 ld (timer),a
 or a
 jr nz,KeyLoop

 xor a
 ld (timers),a
 ld (break),a
 call DrawSel
 jp DoneMove

CursorDown:
 call DrawSel		;Draw Selector

 ld a,(OffSet)
 add a,11
 call CheckB
 or a
 jr nz,RestoreCur

 ld a,(SelectY)		;otherwise, mess with
 add a,8		;the cursor position
 ld (SelectY),a		;and offset
 ld a,(OffSet)
 add a,11		;and redisplay
 ld (OffSet),a
RestoreCur:
 call DrawSel
 jr KeyLoop

CursorUp:
 call DrawSel		;Draw Selector

 ld a,(OffSet)
 add a,-11
 call CheckB
 or a
 jr nz,RestoreCur

 ld a,(SelectY)		;otherwise, mess with
 sub 8			;the cursor position
 ld (SelectY),a		;and offset
 ld a,(OffSet)
 sub 11
 ld (OffSet),a
 jr RestoreCur		;and draw it

CursorRight:
 call DrawSel		;Draw Selector

 ld a,(OffSet)
 inc a
 call CheckB
 or a
 jr nz,RestoreCur

 ld a,(SelectX)		;otherwise, mess with
 inc a			;the cursor position
 ld (SelectX),a		;and offset
 ld a,(OffSet)
 inc a
 ld (OffSet),a
 jr RestoreCur		;and draw it

CursorLeft:
 call DrawSel		;Draw Selector

 ld a,(OffSet)
 dec a
 call CheckB
 or a
 jr nz,RestoreCur

 ld a,(SelectX)		;otherwise, mess with
 dec a			;the cursor position
 ld (SelectX),a		;and offset
 ld a,(OffSet)
 dec a
 ld (OffSet),a
 jr RestoreCur		;and draw it

CheckB:
 ld hl,Level
 ld e,a
 ld d,0
 add hl,de
 ld a,(hl) 
 cp 2
 jr z,NoCur
 xor a
 ret

NoCur:
 ld a,1
 ret

SelectPiece:		;Selects a piece
 call CalcOffSet
 ld a,(hl)
 cp 2
 jp c,KeyLoop
 cp 10
 jp nc,KeyLoop
 jp z,KeyLoop

 call DrawSel		;do not count
 call PutSelected	;display the selector

SelKeyLoop:
 ei
 halt
 call GET_KEY
 cp $36
 jp z,RetNorm
 cp $02
 jp z,MoveLeft
 cp $03
 jp z,MoveRight
 cp $37
 ret z
 ld a,(timers)
 or a
 jr z,SelKeyLoop
 ld a,(timer)
 dec a
 ld (timer),a
 or a
 jr nz,SelKeyLoop

 xor a
 ld (timers),a
 ld (break),a
 call PutSelected
 jp DoneMove

RetNorm:		;Returns to move around mode
 call PutSelected	;from the selector mode
 call DrawSel
 jp KeyLoop

PutSelected:		;displays the selector in 
 ld a,(SelectY)		;the "selected" mode
 ld e,a
 ld a,(SelectX)
 ld hl,block1
 jp PutSprite

MoveLeft:
 call CalcOffSet
 dec hl
 ld a,(hl)
 cp 10
 jp z,WarpL
 or a
 jr nz,SelKeyLoop
 inc hl
 ld a,(hl)

 call GetSpr
 ld a,(SelectY)
 ld e,a
 ld a,(SelectX)
 call PutSprite
 call CalcOffSet
 ld a,(hl)

 push af
 xor a
 ld (hl),a
 pop af
 dec hl
 ld (hl),a

 call GetSpr
 ld a,(SelectY)
 ld e,a
 ld a,(SelectX)
 dec a
 call PutSprite

 call PutSelected

 jr DoneMove

MoveRight:
 call CalcOffSet
 inc hl
 ld a,(hl)
 cp 10
 jp z,Warp
 or a
 jp nz,SelKeyLoop

 dec hl
 ld a,(hl)

 call GetSpr
 ld a,(SelectY)
 ld e,a
 ld a,(SelectX)
 call PutSprite
 call CalcOffSet
 ld a,(hl)

 push af
 xor a
 ld (hl),a
 pop af
 inc hl
 ld (hl),a

 call GetSpr
 ld a,(SelectY)
 ld e,a
 ld a,(SelectX)
 inc a
 call PutSprite

 call PutSelected

DoneMove:
 xor a
 ld (tempx),a
 ld (tempy),a
 ld hl,Level-1
 ld b,88
CheckFall:
 inc hl
 ld a,(hl)
 or a
 jp z,LookAbove
 cp 17
 jr z,CheckAcidFall
 cp 18
 jr z,CheckAcidFall
 cp 12
 jp nc,CheckBreak
ContCheck:
 ld a,(tempx)
 inc a
 ld (tempx),a
 cp 11
 call z,ResetTempV
 djnz CheckFall
 jp CheckMatches

CheckAcidFall:
 push af
 ld de,-11
 add hl,de
 ld a,(hl)
 or a
 jr z,ResetandCont
 pop af
 ld e,a
 push af
 ld a,e
 cp 18
 jr z,KillPiece
Acid:
 ld a,1
 ld (deathflag),a
KillPiece:
 ld a,(hl)
 push hl
 call GetSpr
 ld a,(tempy)
 sub 8
 ld e,a
 ld a,(tempx)
 call PutSprite
 pop hl
 xor a
 ld (hl),a
 pop af
 jp DoneMove
ResetandCont:
 pop af
 ld de,11
 add hl,de
 jr ContCheck
 
ResetTempV:
 xor a
 ld (tempx),a
 ld a,(tempy)
 add a,8
 ld (tempy),a
 ret

WarpL:
 inc hl
 inc hl
Warp:
 dec hl
 ld a,(hl)
 call GetSpr
 ld a,(SelectY)
 ld e,a 
 ld a,(SelectX)
 call PutSprite

 ld hl,Level-1
 xor a
 ld (tempx),a
 ld (tempy),a
WarpLoop:
 inc hl
 ld a,(hl)
 cp 11
 jp z,FoundWarp

 ld a,(tempx) 
 inc a
 ld (tempx),a
 cp 11
 call z,ResetTempV
 jr WarpLoop

FoundWarp:
 ld de,11
 add hl,de
 ld a,(hl)
 or a
 jr nz,NoWarp
 ld de,-11
 add hl,de
 push hl
 call CalcOffSet
 ld a,(hl)
 push af
 xor a
 ld (hl),a
 pop af
 pop hl
 ld de,11
 add hl,de
 ld (hl),a
 call GetSpr
 ld a,(tempy)
 add a,8
 ld e,a
 ld a,(tempx)
 call PutSprite
 call PutSelected
 jp DoneMove

NoWarp:
 call CalcOffSet
 ld a,(hl)
 call GetSpr
 ld a,(SelectY)
 ld e,a
 ld a,(SelectX)
 call PutSprite
 jp SelKeyLoop

CheckBreak:
 cp 16
 jp nc,ContCheck
 ld de,-11
 add hl,de
 ld a,(break)
 or a
 jr nz,ContCBreak
 ld a,(hl)
 cp 12
 jr nc,ContCBreak
 cp 3
 jr nc,FallD
 jr ContCBreak
FallD:
 ld de,11
 add hl,de
 ld a,(hl)

 push hl
 call GetSpr
 ld a,(tempy)
 ld e,a
 ld a,(tempx)
 call PutSprite
 pop hl

 ld a,(hl)
 cp 15
 jp z,FallForReal
 inc (hl)
 ld a,(hl)
 call GetSpr
 ld a,(tempy)
 ld e,a
 ld a,(tempx)
 call PutSprite
 
 ld a,1
 ld (break),a
 ld (timers),a
 ld a,255
 ld (timer),a
 ld (timer2),a
 
 jp DoneMove
 
FallForReal: 
 ld a,1
 ld (break),a
 ld (timers),a
 ld a,255
 ld (timer),a
 ld (timer2),a

 xor a
 ld (hl),a
 ld de,-11
 add hl,de
 jr FallDown

LookAbove:
 ld de,-11
 add hl,de
 ld a,(hl)
 cp 12
 jr nc,FallDown
 cp 10
 jr nc,ContCBreak
 cp 3
 jr nc,FallDown
ContCBreak:
 ld de,11
 add hl,de
 jp ContCheck

FallDown:
 ld a,(hl)

 push hl
 call GetSpr
 ld a,(tempy)
 sub 8
 ld e,a
 ld a,(tempx)
 call PutSprite
 pop hl

 ld a,(hl)
 push af
 xor a
 ld (hl),a
 pop af
 ld de,11
 add hl,de
 ld (hl),a

 call GetSpr
 ld a,(tempy)
 ld e,a
 ld a,(tempx)
 call PutSprite

 jp DoneMove

CheckMatches: 
 xor a
 ld (tempx),a
 ld (tempy),a
 ld hl,Level-1
 ld b,88
CheckLoop:
 inc hl
 ld a,(hl)
 cp 12
 jr nc,ContChk
 cp 3
 jr nc,CheckIt
ContChk:
 ld a,(tempx)
 inc a
 ld (tempx),a
 cp 11
 call z,ResetTempV
 djnz CheckLoop
 jp CheckWin

CheckIt:
 push bc
 ld b,a
 inc hl
 ld a,(hl)
 sub b
 or a
 jr z,MatchR
 ld de,10
 add hl,de
 ld a,(hl)
 sub b
 or a
 jp z,MatchB
 ld de,-11
 add hl,de
 pop bc
 jr ContChk
 
MatchR:
 ld a,(hl)

 push hl

 call GetSpr
 ld a,(tempy)
 ld e,a
 ld a,(tempx)
 call PutSprite

 pop hl
 ld a,(hl)
 push hl

 call GetSpr
 ld a,(tempy)
 ld e,a
 ld a,(tempx)
 inc a
 call PutSprite

 pop hl

 ld a,(hl)
 push af

 xor a
 ld (hl),a
 dec hl
 ld (hl),a 

 inc hl
 inc hl
 pop af
 ld b,a
 ld a,(hl)
 sub b
 jr z,MRR

 ld de,10
 add hl,de
 ld a,(hl)
 sub b
 jr z,MRB
 
 dec hl
 ld a,(hl)
 sub b
 jr z,MRB2

 pop bc
 jp DoneMove

SetMRB:
 ld a,b
 call GetSpr
 ld a,(tempy)
 add a,8
 ld e,a
 ld a,(tempx)
 ret

MRB:
 push hl
 call SetMRB
 inc a
FinMRB:
 call PutSprite
 pop hl
 xor a
 ld (hl),a
 pop bc
 jp DoneMove

MRB2:
 call SetMRB
 jp FinMRB

MRR:
 push hl
 ld a,b
 call GetSpr
 ld a,(tempy) 
 ld e,a
 ld a,(tempx)
 inc a
 inc a
 call PutSprite
 pop hl
 xor a
 ld (hl),a
 pop bc
 jp DoneMove

MatchB:
 ld a,(hl) 
 push hl
 call GetSpr
 ld a,(tempy)
 ld e,a
 ld a,(tempx)
 call PutSprite

 pop hl
 ld a,(hl)
 push hl

 call GetSpr
 ld a,(tempy)
 add a,8
 ld e,a
 ld a,(tempx)
 call PutSprite

 pop hl

 ld a,(hl)

 xor a
 ld (hl),a
 ld de,-11
 add hl,de
 ld (hl),a 

 pop bc
 jp DoneMove

CheckWin:
 ld a,(deathflag)
 or a
 jr nz,NoWin
 ld hl,Level
 ld b,88
WinChkL:
 ld a,(hl)
 cp 10
 jr nc,ContWinChk
 cp 3
 jr nc,NoWin
ContWinChk:
 inc hl
 djnz WinChkL

NextLev:
 ld a,(LevNo)
 inc a
 cp 6
 jp z,Start
 ld (LevNo),a
 jp Start

PrevLev:
 ld a,(LevNo)
 dec a
 or a
 jp z,Start
 ld (LevNo),a
 jp Start

NoWin:
 call DrawSel
 jp KeyLoop

CalcOffSet:		;Calculates the offset of the
 ld hl,Level		;selector using the Offset
 ld a,(OffSet)		;variable originally obtained
 ld e,a			;from the NewSel label.
 ld d,0
 add hl,de
 ret

SetLevel:		;Copies the contents of the 
 ld hl,Level1		;Original level to a temporary
 ld a,(LevNo)
 dec a 
 jp z,SetIt
 ld b,a
SetLevLoop:
 ld de,88
 add hl,de
 djnz SetLevLoop
SetIt:
 ld de,Level		;Level in memory, as to preserve
 ld bc,88		;the original level.  88 bytes
 ldir			;per level, 8*11 = 88.
 xor a
 ld (deathflag),a
 ret

NewSel:			;This basically sets a new selector
 xor a			;at the second empty position [0] in the
 ld (SelectX),a		;level.  The location is calculated
 ld (SelectY),a		;and the number of times looped is stored
 ld hl,Level-1		;inside of the variable offset
SelLoop:		;in order to aid in calculating the offset
 inc hl			;in the moving routines.
 ld a,(hl)
 or a
 jr z,DrawSelC
ContSeLoop:
 ld a,(OffSet)
 inc a
 ld (OffSet),a

 ld a,(SelectX)
 inc a
 ld (SelectX),a
 cp 11
 jr nz,SelLoop
 xor a
 ld (SelectX),a
 ld a,(SelectY)
 add a,8
 ld (SelectY),a
 jr SelLoop

DrawSelC:		;This checks to see if this is
 ld a,(TempVar)		;the first zero we passed or if
 inc a			;it is the second
 cp 2
 jr z,DrawSel
 ld (TempVar),a
 jr ContSeLoop

DrawSel:		;Draws the selector to the screen
 ld hl,selector		;at the SelectX,SelectY coords.
SelPut:
 ld a,(SelectY)
 ld e,a
 ld a,(SelectX)
 jp PutSprite

IntVars:		;Initialize some variables
 ld a,(LevNo)
 push af

 ld hl,BrixMem		;Clear the BrixMem, by
 ld b,110		;setting it all to 0.
IntLoop:
 ld (hl),0
 inc hl
 djnz IntLoop

 pop af
 ld (LevNo),a
 ret	

DrawBoard:
 call DrawLevel		;and draws it on the screen.
 call LogoPut		;Display the Logo
 jp DrawScreen		;Draws remainder of screen

DrawLevel:		;Special thanks to Kirk Meyer
			;for fixing a problem I had with this 
			;routine, and for optomizing it!

 xor a
 ld (XLoc),a
 ld (YLoc),a
 ld hl,Level-1			;Pointer to level
 ld c,8				;We have 8 rows
DrawCols:
 ld b,11			;and 12 columns
DrawLoop:
 push bc
 inc hl
 ld a,(hl)			;into a for sprite type
 push hl			;save hl for a bit
 or a				;if it is zero
 jr nz,DrawBlock		;then draw a blank box
 ld hl,blank
 jr DrawSpr
DrawBlock:
 call GetSpr
DrawSpr:
 ld a,(YLoc)
 ld e,a
 ld a,(XLoc)
 call PutSprite
DoneDraw:
 pop hl			;return hl's value to original
 pop bc			;and bc's as well
 ld a,(XLoc)
 inc a
 ld (XLoc),a
 djnz DrawLoop		
 xor a
 ld (XLoc),a
 ld a,(YLoc)
 add a,8 
 ld (YLoc),a
 dec c
 jr nz, DrawCols	;draw columns again
 ret

DrawScreen:
 ld hl,40*256+92
 ld (_penCol),hl
 ld hl,LevStr
 call _vputs
 ld a,(LevNo)
 call _vdispa
 ret

GetSpr:
 ld hl,block1
 dec a
 add a,a
 add a,a
 add a,a 
 ld d,0
 ld e,a
 add hl,de
 ret

 
;This Routine was converted by AVD from Movax's 83
;Special thanks to ScaBBy for making it XOR Routine!
;Edited for Brix by Ahmed El-Helw.
;I took out the unaligned routine because all the
;sprites will be alligned.  
;Optomized a tad bit by Kirk Meyer.
;hl = image, a = x coord, e = y coord

PutSprite:
 push hl              
 ld hl,0            
 ld d,0
 ex de,hl
 add hl,hl
 add hl,hl
 add hl,hl
 add hl,hl
 ld d,0             
 ld e,a
 add hl,de
 ld de,$FC00
 add hl,de           

ALIGN:
 pop de         
 ld b,8
ALOP1:
 ld a,(de)

 xor (hl)            
FinSpr:
 ld (hl),a
 inc de
 push bc
 ld bc,16
 add hl,bc
 pop bc
 djnz ALOP1
 ret

_vdispa:
 ld l,a
 ld h,0
_vdisphl:			;Routine by SCaBBy
 xor a
 ld de,-1
 ld (_curRow),de
 call 4A33h
 dec hl
 jp _vputs

LogoPut:			;Special thanks to Martin Hock
 ld hl,Logo			;for this routine.  Edited by
 ld de,$FC00+427		;Ahmed for the Brix Logo.
 ld bc,5
 ld a,13
TPutLoop:
 ldir
 dec a
 ret z
 push hl
 ld hl,11
 add hl,de
 ld d,h
 ld e,l
 pop hl
 ld bc,5
 jr TPutLoop

;-------------------------
;Data
;-------------------------
LevStr: .db "Level: ",0

;-------------------------
;Block Sprites 
;Thanks to  Kashan Shaikh
;for making these for me!
;-------------------------
block1:
.db %11111111
.db %11010101
.db %10101011
.db %11010101
.db %10101011
.db %11010101
.db %10101011
.db %11111111

.db %11111111
.db %11010101
.db %10101011
.db %11010101
.db %10101011
.db %11010101
.db %10101011
.db %11111111

.db %11111111
.db %10101011
.db %11010101
.db %10011001
.db %10011001
.db %10101011
.db %11010101
.db %11111111

.db %11111111
.db %11000011
.db %10100101
.db %11000011
.db %11000011
.db %10100101
.db %11000011
.db %11111111

.db %11111111
.db %11000011
.db %10100101
.db %10011001
.db %10011001
.db %10100101
.db %11000011
.db %11111111

.db %11111111
.db %10011011
.db %10001001
.db %11000101
.db %10100011
.db %10010001
.db %11011001
.db %11111111

.db %11111111
.db %10100001
.db %10000101
.db %10010001
.db %10000101
.db %10100001
.db %10001001
.db %11111111

.db %11111111
.db %10001101
.db %10000001
.db %11110001
.db %10001111
.db %10000001
.db %10110001
.db %11111111

.db %11111111
.db %10010001
.db %10010001
.db %11111111
.db %11111111
.db %10001001
.db %10001001
.db %11111111

.db %11111111
.db %10000001
.db %10111111
.db %10100101
.db %10100101
.db %11111101
.db %10000001
.db %11111111

.db %11111111  
.db %10000001
.db %10111101
.db %10100101
.db %10100101
.db %10111101
.db %10000001
.db %11111111

.db %11111111
.db %11111111
.db %11111111
.db %11111111
.db %11111111
.db %11111111
.db %11111111
.db %11111111

.db %11111111
.db %11001011
.db %11111111
.db %11010011
.db %11111111
.db %11001011
.db %11111111
.db %11111111

.db %11111111
.db %10010001
.db %11111111
.db %10010001
.db %11111111
.db %10001001
.db %11111111
.db %11111111

.db %11111111
.db %10000001
.db %10000001
.db %10000001
.db %10000001
.db %10000001
.db %10000001
.db %11111111

.db %11111111
.db %10100101
.db %11111111
.db %10010101
.db %11111111
.db %10010101
.db %10010101
.db %11111111

.db %00000000
.db %00000000
.db %00000000
.db %10101011
.db %11010101
.db %10000001
.db %10000001
.db %11111111

.db %00000000
.db %00000000
.db %00000000
.db %10101011
.db %11010101
.db %10001001
.db %10000001
.db %11111111

selector:
.db %11111111
.db %11000011
.db %10000001
.db %10000001
.db %10000001
.db %10000001
.db %11000011
.db %11111111

blank:
.db 0,0,0,0,0,0,0,0

;------------------------
;Brix Logo
;Special thanks to
;Eathan Hunt for
;the Logo and the nifty
;bmp to asm converter.
;------------------------
Logo:
.db %00111111,%11111111,%11110111,%11111100,%11111000
.db %00100000,%00110000,%00011100,%01000111,%10001000
.db %00100000,%00010000,%00001100,%01000011,%00001000
.db %00100000,%00010000,%00000100,%01000000,%00001000
.db %00111111,%10011111,%11000111,%11110000,%00111000
.db %00111111,%10011111,%11000111,%11011000,%01100000
.db %00100000,%00010000,%00001100,%01001000,%01000000
.db %00100000,%00110000,%00011100,%01001000,%01000000
.db %00100000,%00010000,%00001100,%01011000,%01100000
.db %00111111,%00011111,%10001100,%01110000,%00111000
.db %00100000,%00001000,%10001100,%01000000,%00001000
.db %00100000,%00011000,%10001100,%01000111,%10001000
.db %00111111,%11110000,%11111111,%11111100,%11111000

;--------------------
;Levels
;--------------------
Level1:
.db 0,2,2,2,2,2,2,2,2,2,2
.db 2,2,0,0,0,0,0,0,0,0,2
.db 2,0,0,0,0,0,0,0,0,3,2
.db 2,0,0,0,0,0,0,0,5,6,2
.db 2,0,0,0,0,0,0,4,9,8,2
.db 2,0,0,0,0,0,5,9,8,7,2
.db 2,0,0,0,0,3,4,6,7,2,2
.db 2,2,2,2,2,2,2,2,2,2,0

Level2:
.db 2,2,2,2,2,2,2,2,2,2,2
.db 2,3,0,1,1,1,0,3,0,2,2
.db 2,5,3,0,1,0,5,6,3,2,2
.db 2,2,5,6,0,5,6,2,2,2,2
.db 2,2,2,2,6,2,2,2,2,2,2
.db 2,2,2,2,2,2,2,2,2,2,2
.db 2,2,2,2,2,2,2,2,2,2,2
.db 2,2,2,2,2,2,2,2,2,2,2

Level3:
.db 2,2,2,2,2,2,2,2,2,2,2
.db 2,0,0,0,5,4,3,0,0,0,2
.db 2,0,0,1,1,1,1,1,0,0,2
.db 2,0,0,0,0,0,0,0,0,0,2
.db 2,0,12,0,0,0,0,0,12,0,2
.db 2,0,12,12,12,4,12,12,12,0,2
.db 2,0,12,12,5,1,3,12,12,0,2
.db 2,2,2,2,2,2,2,2,2,2,2

Level4:
.db 2,2,2,2,2,2,2,2,2,2,2
.db 2,0,0,0,0,1,0,0,0,11,2
.db 2,0,0,0,0,1,0,0,0,0,2
.db 2,10,0,8,9,1,0,0,0,0,2
.db 2,1,1,1,1,1,0,0,7,3,2
.db 2,0,0,6,7,1,9,6,4,2,2
.db 2,10,3,4,5,1,8,5,2,2,2
.db 2,2,2,2,2,2,2,2,2,2,2

Level5:
.db 2,2,2,2,2,2,2,2,2,2,2
.db 2,0,0,4,3,5,6,7,0,0,2
.db 2,0,0,1,1,1,1,1,0,0,2
.db 2,0,0,0,0,0,0,0,0,0,2
.db 2,0,0,0,0,0,0,0,0,0,2
.db 2,0,16,17,17,16,18,18,16,0,2
.db 2,0,16,16,16,16,16,16,16,0,2
.db 2,2,2,2,2,2,2,2,2,2,2

;--------------------
;Variables
;--------------------
BrixMem   = $
Level     = BrixMem	;88 bytes
XLoc      = BrixMem+89	;01 bytes
YLoc      = BrixMem+90	;01 bytes
SelectX   = BrixMem+91	;01 bytes
SelectY   = BrixMem+92    ;01 bytes
TempVar   = BrixMem+93    ;01 bytes
OffSet    = BrixMem+94	;01 bytes
LevNo     = BrixMem+95	;01 bytes
tempx     = BrixMem+96    ;01 bytes
tempy     = BrixMem+97    ;01 bytes
break     = BrixMem+98    ;01 bytes
timer     = BrixMem+99	;01 bytes
timer2    = BrixMem+100   ;01 bytes
timers    = BrixMem+101   ;01 bytes
deathflag = BrixMem+102   ;01 bytes

.end
END