;Bricks
;By Michiel Nugter
;If you wan't to use any part of the code give me some credit.
;Note : Sprites, pictures and strings are in the include.asm file

.nolist
#include "ion.inc"
#define	counter	8265h
#define	posx		8267h
#define	posy		8269h
#define	one		8271h
#define	two		8273h
#define	three		8275h
#define	four		8277h 
#define	five		8279h
#define	six		8281h
#define	seven		8283h
#define	eight		8285h
#define	game		8287h
#define	ovcounter	8289h
#define	xco		8295h
#define	yco		8297h
#define	brone		8327h
#define	brtwo		8329h
#define	brthree	8331h
#define	brfour	8333h
#define	brfive	8335h
#define	brsix		8337h
#define	brseven	8339h
#define	breight	8341h
#define	zerox		8345h
#define	zeroy		8347h
#define	checkx	8349h
#define	checky	8351h
#define	move		8355h
#define	temp		8357h
#define	score		8359h
#define	total		8361h
#define	level		8363h
#define	diffcult	8365h

.list
#ifdef TI83P
	.org	progstart-2
	.db	$BB,$6D
#else
	.org	progstart
#endif
	ret		; use xor a if libraries are not used
	jr	nc,begin	; jump to the beginning
	.db	"Bricks v1.25",0
begin:	; Program code goes here
	ld hl,0
	ld (diffset),hl
	ld hl,100
	ld (diffcult),hl
start:
	call reset
	bcall(_clrscr)		;clear screen
	bcall(_cleargbuf)		;clear gr-buffer
	bcall(_indicatorOff)	;turn indicator off

menu:
	ld hl,0
	ld (total),hl
	inc hl
	ld (layout),hl
	bcall(_clrscr)		;clear screen

	call logo
	ld hl,1905h
	ld (PENCOL),hl
	ld hl,menu_one
	bcall(_vputs)
	ld hl,2005h
	ld (PENCOL),hl
	ld hl,menu_three
	bcall(_vputs)
	ld hl,2605h
	ld (PENCOL),hl
	ld hl,menu_two
	bcall(_vputs)
	ld hl,1010h
	ld (PENCOL),hl
	ld hl,menu_by
	bcall(_vputs)
	ld hl,3800h
	ld (PENCOL),hl
	ld hl,hiscore
	bcall(_vputs)
	ld hl,3825h
	ld (PENCOL),hl
	call highselect
	bcall(_setxxxxop2)
	bcall(_op2toop1)
	ld a,$05
	bcall(_dispop1a)

menu_input:
	ld a,0ffh
	out (1),a
	ld a,0bfh
	out (1),a
	in a,(1)
	cp 223
	jp z,initscore
	cp 191
	jp z,options
	cp 127
	jp z,quit
	jp menu_input


highselect:
	ld a,(play)
	cp 0
	call z,play_one
	call nz,play_two
	ret

play_one:
	ld hl,(highprac)
	ret
play_two:
	call detect_score
	ret



options:
	bcall(_clrscr)
	call logo
	ld hl,1020h
	ld (PENCOL),hl
	ld hl,options_txt
	bcall(_vputs)

	ld hl,1605h
	ld (PENCOL),hl
	ld hl,options_one
	bcall(_vputs)
	ld hl,1623h
	ld (PENCOL),hl
	call detectspace
	bcall(_vputs)

	ld hl,2005h
	ld (PENCOL),hl
	ld hl,options_two
	bcall(_vputs)
	ld hl,2610h
	ld (PENCOL),hl
	call detectplay
	bcall(_vputs)

	ld hl,3005h
	ld (PENCOL),hl
	ld hl,diff
	bcall(_vputs)
	ld hl,3030h
	ld (PENCOL),hl
	call diff_detect
	bcall(_vputs)

	ld hl,3605h
	ld (PENCOL),hl
	ld hl,exittomenu
	bcall(_vputs)


options_input:
	ld a,0ffh
	out (1),a
	ld a,0bfh
	out (1),a
	in a,(1)
	cp 223
	jp z,space_lbl
	cp 191
	jp z,playmode
	cp 127
	jp z,menu
	ld a,0ffh
	out (1),a
	ld a,0fdh
	out (1),a
	in a,(1)
	cp 253
	jp z,diff_set
	jp options_input

diff_detect:
	ld a,(diffset)
	cp 0
	jp z,diff_txteasy
	cp 1
	jp z,diff_txtmedium
	cp 2
	jp z,diff_txthard

diff_txteasy:
	ld hl,easy
	ret
diff_txtmedium:
	ld hl,medium
	ret
diff_txthard:
	ld hl,hard
	ret

space_lbl:
	ld a,(space)
	cp 0
	call z,spone
	call nz,sptwo
	jp delay_options
spone:
	ld hl,1
	ld (space),hl
	ret
sptwo:
	ld hl,0
	ld (space),hl
	ret

playmode:
	ld a,(play)
	cp 0
	call z,changeone
	call nz,changetwo
	jp delay_options

changeone:
	ld hl,1
	ld (play),hl
	ld hl,1
	ld (layout),hl
	ret
changetwo:
	ld hl,0
	ld (play),hl
	ret

detectplay:
	ld a,(play)
	cp 0
	call z,playone
	call nz,playtwo
	ret
playone:
	ld hl,practice
	ret
playtwo:
	ld hl,campaign
	ret

detectspace:
	ld a,(space)
	cp 0
	call z,spaceoff
	call nz,spaceon
	ret
spaceon:
	ld hl,sbb_on
	ret
spaceoff:
	ld hl,sbb_off
	ret

diff_set:
	ld a,(diffset)
	cp 0
	call z,diff_easy
	cp 1
	call z,diff_medium
	cp 2
	call z,diff_hard
	jp delay_options

diff_easy:
	ld hl,1
	ld (diffset),hl
	ld hl,90
	ld (diffcult),hl
	ret
diff_medium:
	ld hl,2
	ld (diffset),hl
	ld hl,80
	ld (diffcult),hl
	ret
diff_hard:
	ld hl,0
	ld (diffset),hl
	ld hl,100
	ld (diffcult),hl
	ret
	
delay_options:
	ld bc,6000
doptions_loop:
	dec bc
	ld a,b
	or c
	jp nz,doptions_loop
	jp options



initscore:
	bcall(_clrscr)		;clear screen
	ld hl,(diffcult)
	ld (score),hl
	ld a,(play)
	cp 0
	jp z,layout_select

	jp nz,drawing_begin


aput_one:
	ld a,(space)
	cp 0
	call z,aput_one_no
	call nz,aput_one_yes
	ret

aput_one_no:
	ld a,35
	ld (zerox),a
	ret

aput_one_yes:
	ld a,38
	ld (zerox),a
	ret


aput_two:
	ld a,(space)
	cp 0
	call z,aput_two_no
	call nz,aput_two_yes
	ret

aput_two_no:
	ld a,36
	ld (zeroy),a
	ret

aput_two_yes:
	ld a,38
	ld (zeroy),a
	ret

input_init:			;initializing some vars
	bcall(_clrscr)
	call ionFastCopy
	call drawscreen
	call aput_one
	call aput_two
	ld a,3
	ld (checky),a
	ld (checkx),a

Input:	; asks for a key, direct input
	ld a,0ffh
	out (1),a
	ld a,0feh
	out (1),a
	in a,(1)
	cp 254
	jp z,up
	cp 247
	jp z,down
	cp 253
	jp z,left
	cp 251
	jp z,right
	ld a,0ffh
	out (1),a
	in a,(1)
	ld a,0bfh
	out (1),a
	in a,(1)
	cp 254
	jp z,start
	cp 223
	jp z,check
	cp 253
	jp z,shuffle
	cp 191
	jp z,example
	call dispscr
	ld a,(score)		; check if the score is zero
	cp 0
	jp z,losser
	ld a,(score)
	cp 0
	jp z,losser
	jp input



left:
	ld a,(checkx)
	cp 3
	jp z,input
	dec a
	ld (checkx),a

	ld	hl,(score)
	dec	hl
	ld	(score),hl

	ld a,(zeroy)
	ld (yco),a
	ld a,(zerox)
	ld (xco),a
	add a,8
	ld b,a
	ld a,(space)
	add a,b
	ld (zerox),a
	ld a,(move)
	ld (temp),a
	add a,1
	ld (move),a
	jp delay

right:
	ld a,(move)
	cp 7
	jp z,input
	ld a,(move)
	cp 4
	jp z,input
	ld a,(move)
	cp 1
	jp z,input

	ld	hl,(score)
	dec	hl
	ld	(score),hl

	ld a,(checkx)
	inc a
	ld (checkx),a

	ld a,(zeroy)
	ld (yco),a
	ld a,(zerox)
	ld (xco),a
	sub 8
	ld b,a
	ld a,(space)
	ld c,b
	ld b,a
	ld a,c
	sub b
	ld (zerox),a

	ld a,(move)
	ld (temp),a
	sub 1
	ld (move),a
	jp delay

down:
	ld a,(checky)
	cp 3
	jp z,input
	inc a
	ld (checky),a

	ld	hl,(score)
	dec	hl
	ld	(score),hl

	ld a,(zeroy)
	ld (yco),a
	ld a,(zerox)
	ld (xco),a

	ld a,(zeroy)
	add a,8
	ld b,a
	ld a,(space)
	add a,b
	ld (zeroy),a

	ld a,(move)
	ld (temp),a
	add a,3
	ld (move),a
	jp delay

up:
	ld a,(checky)
	cp 1
	jp z,input
	dec a
	ld (checky),a

	ld	hl,(score)
	dec	hl
	ld	(score),hl

	ld a,(zeroy)
	ld (yco),a
	ld a,(zerox)
	ld (xco),a

	ld a,(zeroy)
	sub 8
	ld b,a
	ld a,(space)
	ld c,b
	ld b,a
	ld a,c
	sub b
	ld (zeroy),a

	ld a,(move)
	ld (temp),a
	sub 3
	ld (move),a
	jp delay

shuffle:
	ld a,(score)
	cp 4
	jp z,input
	cp 3
	jp z,input
	cp 2
	jp z,input
	cp 1
	jp z,input
	ld a,38
	ld b,a
	ld a,(space)
	add a,b
	ld (zerox),a
	ld (zeroy),a
	ld a,3
	ld (checky),a
	ld (checkx),a

	ld a,(score)
	sub 5
	ld (score),a
	jp drawing_begin


example:
	ld a,(move)		; backup move
	ld (temp),a
	ld a,60
	ld (posx),a
	ld a,20
	ld (posy),a
	ld a,1
	ld (move),a

	ld a,(brone)	; backup bricks
	ld (one),a
	ld a,(brtwo)
	ld (two),a
	ld a,(brthree)
	ld (three),a
	ld a,(brfour)
	ld (four),a
	ld a,(brfive)
	ld (five),a
	ld a,(brsix)
	ld (six),a
	ld a,(brseven)
	ld (seven),a
	ld a,(breight)
	ld (eight),a

	ld a,1
	ld (brone),a
	inc a
	ld (brtwo),a
	inc a
	ld (brthree),a
	inc a
	ld (brfour),a
	inc a
	ld (brfive),a
	inc a
	ld (brsix),a
	inc a
	ld (brseven),a
	inc a
	ld (breight),a

example_draw:
	call ixput
	call example_put
	ld a,(move)
	cp 9
	jp nz,example_draw
	call ionFastCopy
example_two:
	ld a,60
	ld (posx),a
	ld a,20
	ld (posy),a
	ld a,1
	ld (move),a
	ld hl,(score)
	dec hl
	ld (score),hl
	ld a,(score)
	cp 0
	jp z,losser
	call dispscr
	ld bc,9999
	ld de,3
example_three:
	ld a,0ffh
	out (1),a
	ld a,0bfh
	out (1),a
	in a,(1)
	cp 223
	jp z,example_exit
	dec BC
	ld a,b
	or c
	jp nz,example_three
	dec DE
	ld b,d
	or e
	jp nz,example_three
	jp example_two

example_put:
	ld a,(move)
	cp 4
	call z,newline_two
	cp 7
	call z,newline_two

	ld a,(posy)
	ld l,a
	ld a,(posx)
	ld b,8
	call ionPutSprite

	ld a,(move)
	inc a
	ld (move),a

	ld a,(posx)
	ld b,8
	add a,b
	ld (posx),a
	ret

example_exit:
	call ixput
	call example_put
	ld a,(move)
	cp 9
	jp nz,example_exit
	call ionFastCopy


	ld a,(one)		; restoring bricks
	ld (brone),a
	ld a,(two)
	ld (brtwo),a
	ld a,(three)
	ld (brthree),a
	ld a,(four)
	ld (brfour),a
	ld a,(five)
	ld (brfive),a
	ld a,(six)
	ld (brsix),a
	ld a,(seven)
	ld (brseven),a
	ld a,(eight)
	ld (breight),a



	ld a,(temp)
	ld (move),a
	jp input

	
newline_two:
	ld a,60		; increase posy with 8
	ld (posx),a
	ld a,(posy)
	ld b,8
	add a,b
	ld (posy),a
	ret



;---------= Display the score and some other stuff=---------
dispscr:

	ld hl,$3620		; display score
	ld (pencol),hl
	ld hl,(score)
	bcall(_setxxxxop2)
	bcall(_op2toop1)
	ld a,$05
	bcall(_dispop1a)

	ld hl,3604h
	ld (PENCOL),hl
	ld hl,hi
	bcall(_vputs)

	ld hl,3630h	; display level
	ld (PENCOL),hl
	ld hl,leveltxt
	bcall(_vputs)

	ld hl,$3645		; display score
	ld (pencol),hl
	ld hl,(level)
	bcall(_setxxxxop2)
	bcall(_op2toop1)
	ld a,$05
	bcall(_dispop1a)
	ret

losser:
	ld a,(play)
	cp 1
	jp z,camplose
	bcall(_cleargbuf)
	call logo

	ld hl,$1519
	ld (pencol),hl
	ld hl,youlose
	bcall(_vputs)

	ld hl,$2019
	ld (pencol),hl
	ld hl,tryagain
	bcall(_vputs)

	ld hl,$3010
	ld (pencol),hl
	ld hl,yes
	bcall(_vputs)

	ld hl,$3030
	ld (pencol),hl
	ld hl,no
	bcall(_vputs)

losser_input:
	ld a,0ffh
	out (1),a
	ld a,0bfh
	out (1),a
	in a,(1)
	cp 223
	jp z,initscore
	ld a,0ffh
	out (1),a
	in a,(1)
	ld a,0fdh
	out (1),a
	in a,(1)
	cp 191
	jp z,start
	jp losser_input

Delay:
	PUSH AF
	PUSH BC
	LD BC,$9999
DelayLoop:
	DEC BC
	LD A, B
	OR C
	Jp NZ, DelayLoop
	POP AF
	POP BC

action:
	call ixput
action_two:
	ld a,(brone)
	ld b,a
	ld a,(move)
	cp b
	jp z,draw_one

	ld a,(brtwo)
	ld b,a
	ld a,(move)
	cp b
	jp z,draw_two

	ld a,(brthree)
	ld b,a
	ld a,(move)
	cp b
	jp z,draw_three

	ld a,(brfour)
	ld b,a
	ld a,(move)
	cp b
	jp z,draw_four

	ld a,(brfive)
	ld b,a
	ld a,(move)
	cp b
	jp z,draw_five

	ld a,(brsix)
	ld b,a
	ld a,(move)
	cp b
	jp z,draw_six

	ld a,(brseven)
	ld b,a
	ld a,(move)
	cp b
	jp z,draw_seven

	ld a,(breight)
	ld b,a
	ld a,(move)
	cp b
	jp z,draw_eight
	jp input

draw_one:
	call loaddraw
	ld a,(temp)
	ld (brone),a

	jp input

draw_two:
	call loaddraw
	ld a,(temp)
	ld (brtwo),a

	jp input

draw_three:
	call loaddraw
	ld a,(temp)
	ld (brthree),a

	jp input
draw_four:
	call loaddraw
	ld a,(temp)
	ld (brfour),a

	jp input
draw_five:
	call loaddraw
	ld a,(temp)
	ld (brfive),a

	jp input

draw_six: 
	call loaddraw
	ld a,(temp)
	ld (brsix),a

	jp input
draw_seven:
	call loaddraw
	ld a,(temp)
	ld (brseven),a

	jp input

draw_eight:
	call loaddraw
	ld a,(temp)
	ld (breight),a
	jp input

loaddraw:
	ld a,(yco)
	ld l,a
	ld a,(xco)
	ld b,8
	PUSH ix
	call ionPutSprite
	ld a,(zeroy)
	ld l,a
	ld a,(zerox)
	ld b,8
	POP ix
	call ionPutSprite
	call ionFastCopy
	ret

check:
	ld a,(brone)
	cp 1
	jp nz,input
	ld a,(brtwo)
	cp 2
	jp nz,input
	ld a,(brthree)
	cp 3
	jp nz,input
	ld a,(brfour)
	cp 4
	jp nz,input
	ld a,(brfive)
	cp 5
	jp nz,input
	ld a,(brsix)
	cp 6
	jp nz,input
	ld a,(brseven)
	cp 7
	jp nz,input
	ld a,(breight)
	cp 8
	jp nz,input

	bcall(_clrscr)
	bcall(_cleargbuf)

	ld a,(play)
	cp 1
	jp z,campwin


	ld de,(highprac)
	ld hl,(score)
	call hiscr
	call z,newhi

	call logo
	ld hl,$1517
	ld (pencol),hl
	ld hl,youwin
	bcall(_vputs)

	ld hl,$2019
	ld (pencol),hl
	ld hl,tryagain
	bcall(_vputs)

	ld hl,$3010
	ld (pencol),hl
	ld hl,yes
	bcall(_vputs)

	ld hl,$3030
	ld (pencol),hl
	ld hl,no
	bcall(_vputs)

winner_input:
	ld a,0ffh
	out (1),a
	ld a,0bfh
	out (1),a
	in a,(1)
	cp 223
	jp z,initscore
	ld a,0ffh
	out (1),a
	in a,(1)
	ld a,0fdh
	out (1),a
	in a,(1)
	cp 191
	jp z,start
	jp winner_input

newhi:
	ld hl,(score)
	ld (highprac),hl
	ret

campwin:
	call addscore

	ld a,(layout)
	cp 15
	jp z,campcomp
	ld hl,(layout)
	inc hl
	ld (layout),hl

	call campdraw
	ld hl,$2820
	ld (pencol),hl
	ld hl,continue
	bcall(_vputs)

	ld hl,$3010
	ld (pencol),hl
	ld hl,yes
	bcall(_vputs)

	ld hl,$3030
	ld (pencol),hl
	ld hl,no
	bcall(_vputs)

wincamp_input:
	ld a,0ffh
	out (1),a
	ld a,0bfh
	out (1),a
	in a,(1)
	cp 223
	jp z,initscore
	ld a,0ffh
	out (1),a
	in a,(1)
	ld a,0fdh
	out (1),a
	in a,(1)
	cp 191
	jp z,campend
	jp wincamp_input

campdraw:
	call logo

	ld hl,$1025
	ld (pencol),hl
	ld hl,okay
	bcall(_vputs)

	ld hl,$1905
	ld (pencol),hl
	ld hl,points
	bcall(_vputs)
	ld hl,$1925
	ld (pencol),hl
	ld hl,(score)
	bcall(_setxxxxop2)
	bcall(_op2toop1)
	ld a,$05
	bcall(_dispop1a)

	ld hl,$2205
	ld (pencol),hl
	ld hl,tpoints
	bcall(_vputs)

	ld hl,$2235
	ld (pencol),hl
	ld hl,(total)
	bcall(_setxxxxop2)
	bcall(_op2toop1)
	ld a,$05
	bcall(_dispop1a)
	ret

campend:
	call detect_score
	ex de,hl
	ld hl,(total)
	call hiscr
	call z,newcamp
	jp menu

newcamp:
	ld a,(diffset)
	cp 0
	jp z,put_easy
	cp 1
	jp z,put_medium
	cp 2
	jp z,put_hard

put_easy:
	ld hl,(total)
	ld (campeasy),hl
	ret
put_medium:
	ld hl,(total)
	ld (campmedium),hl
	ret
put_hard:
	ld hl,(total)
	ld (camphard),hl
	ret

addscore:
	ld bc,(score)
	ld hl,(total)
addloop:
	inc HL
	dec BC
	ld a,b
	or c
	jp nz,addloop
	ld (total),hl
	ret

campcomp:
	bcall(_clrscr)
	call logo

	ld hl,$1010
	ld (pencol),hl
	ld hl,compl_one
	bcall(_vputs)

	ld hl,$1615
	ld (pencol),hl
	ld hl,compl_two
	bcall(_vputs)

	ld hl,$2205
	ld (pencol),hl
	ld hl,your
	bcall(_vputs)

	ld hl,$2235
	ld (pencol),hl
	ld hl,(total)
	bcall(_setxxxxop2)
	bcall(_op2toop1)
	ld a,$05
	bcall(_dispop1a)


	ld hl,$2805
	ld (pencol),hl
	ld hl,curhi
	bcall(_vputs)

	ld hl,$2835
	ld (pencol),hl
	call detect_score
	bcall(_setxxxxop2)
	bcall(_op2toop1)
	ld a,$05
	bcall(_dispop1a)

	ld hl,$3405
	ld (pencol),hl
	ld hl,press
	bcall(_vputs)

	bcall(_getkey)

	jp campend

detect_score:
	ld a,(diffset)
	cp 0
	jp z,score_camp_easy
	cp 1
	jp z,score_camp_medium
	cp 2
	jp z,score_camp_hard

score_camp_easy:
	ld hl,(campeasy)
	ret
score_camp_medium:
	ld hl,(campmedium)
	ret
score_camp_hard:
	ld hl,(camphard)
	ret



camplose:
	bcall(_clrscr)		;clear screen
	bcall(_cleargbuf)		;clear gr-buffer

	call logo

	ld hl,$1019
	ld (pencol),hl
	ld hl,youlose
	bcall(_vputs)

	ld hl,$3405
	ld (pencol),hl
	ld hl,press
	bcall(_vputs)

	bcall(_getkey)
	jp start
	

drawscreen:
	ld b,2
	ld c,62
	ld d,2
	ld e,2
	bcall(_ILine)
	ld b,94
	ld c,62
	ld d,2
	ld e,62
	bcall(_ILine)
	ld b,94
	ld c,62
	ld d,94
	ld e,2
	bcall(_ILine)
	ld b,2
	ld c,2
	ld d,94
	ld e,2
	bcall(_ILine)

	ld b,2
	ld c,10
	ld d,94
	ld e,10
	bcall(_ILine)


	ld b,16
	ld c,47
	ld d,16
	ld e,16
	bcall(_ILine)
	ld b,16
	ld c,47
	ld d,48
	ld e,47
	bcall(_ILine)
	ld b,48
	ld c,47
	ld d,48
	ld e,16
	bcall(_ILine)
	ld b,48
	ld c,15
	ld d,16
	ld e,15
	bcall(_ILine)


	ld b,56
	ld c,47
	ld d,56
	ld e,16
	bcall(_ILine)
	ld b,56
	ld c,47
	ld d,88
	ld e,47
	bcall(_ILine)
	ld b,88
	ld c,47
	ld d,88
	ld e,16
	bcall(_ILine)
	ld b,88
	ld c,15
	ld d,56
	ld e,15
	bcall(_ILine)
	ret

layout_select:		;select which layout for the bricks should be chosen
	bcall(_clrscr)
	call logo

	ld hl,$1905
	ld (pencol),hl
	ld hl,lay_up_txt
	bcall(_vputs)
	ld hl,$2005
	ld (pencol),hl
	ld hl,lay_down_txt
	bcall(_vputs)

	ld hl,$2605
	ld (pencol),hl
	ld hl,lay_txt
	bcall(_vputs)

	ld hl,$3610
	ld (pencol),hl
	ld hl,lay_accept
	bcall(_vputs)

	ld hl,$2605
	ld (pencol),hl
	ld hl,lay_txt
	bcall(_vputs)

	ld hl,$2640
	ld (pencol),hl
	ld hl,(layout)
	bcall(_setxxxxop2)
	bcall(_op2toop1)
	ld a,$05
	bcall(_dispop1a)


	ld hl,2
layout_loop:
	ld a,0ffh
	out (1),a
	ld a,0fdh
	out (1),a
	in a,(1)
	cp 251
	jp z,lay_down
	cp 253
	jp z,lay_up
	cp 254
	jp z,drawing_begin
	jp layout_loop

lay_down:
	ld a,(layout)
	cp 1
	jp z,layout_loop
	dec a
	ld (layout),a
	jp delay_layout

lay_up:
	ld a,(layout)
	cp 15
	jp z,layout_loop
	inc a
	ld (layout),a
	jp delay_layout

delay_layout:
	ld bc,9999
dlayout_loop:
	dec bc
	ld a,b
	or c
	jp nz,dlayout_loop
	dec hl
	ld a,h
	or l
	jp nz,delay_layout
	jp layout_select

drawing_begin:		; The layout placement routine
	bcall(_cleargbuf)
	bcall(_clrscr)
	call reset
	ld a,11
	ld (posx),a
	ld a,20
	ld (posy),a
	ld a,0
	ld (counter),a
	ld (ovcounter),a
	ld a,1
	ld (move),a

drawing_init:
	ld b,8
	ld a,(posx)
	add a,b
	ld b,a
	ld a,(space)
	add a,b
	ld (posx),a

	ld a,(ovcounter)	; check if the line is full (three sprites in a row) if so goto newline
	cp 3
	jr z,newline
counter_lbl:
	ld a,(counter)	; increase the main counter
	inc a
	ld (counter),a
	cp 9
	jp z,input_init

	ld a,(ovcounter)
	inc a
	ld (ovcounter),a	; increase the line counter

drawing:
	ld a,(layout)
	cp 1
	jp z,lay_one
	cp 2
	jp z,lay_two
	cp 3
	jp z,lay_three
	cp 4
	jp z,lay_four
	cp 5
	jp z,lay_five
	cp 6
	jp z,lay_six
	cp 7
	jp z,lay_seven
	cp 8
	jp z,lay_eight
	cp 9
	jp z,lay_nine
	cp 10
	jp z,lay_ten
	cp 11
	jp z,lay_eleven
	cp 12
	jp z,lay_twelve
	cp 13
	jp z,lay_thirteen
	cp 14
	jp z,lay_fourteen
	cp 15
	jp z,lay_fiveteen
	jp drawing

newline:
	ld a,19		; increase posy with 9
	ld b,a
	ld a,(space)
	add a,b
	ld (posx),a
	ld a,(posy)
	ld b,8
	add a,b
	ld b,a
	ld a,(space)
	add a,b
	ld (posy),a
	ld a,0		; reset ovcounter
	ld (ovcounter),a
	jp counter_lbl


lay_one:
	ld hl,1
	ld (level),hl
	ld a,(move)
	ld ix,level_one_one
	cp 2
	jp z,br_one
	ld ix,level_one_two
	cp 8
	jp z,br_two
	ld ix,level_one_three
	cp 6
	jp z,br_three
	ld ix,level_one_four
	cp 1
	jp z,br_four
	ld ix,level_one_five
	cp 5
	jp z,br_five
	ld ix,level_one_six
	cp 4
	jp z,br_six
	ld ix,level_one_seven
	cp 3
	jp z,br_seven
	ld ix,level_one_eight
	cp 7
	jp z,br_eight
lay_two:
	ld hl,2
	ld (level),hl
	ld a,(move)
	ld ix,level_two_one
	cp 8
	jp z,br_one
	ld ix,level_two_two
	cp 7
	jp z,br_two
	ld ix,level_two_three
	cp 6
	jp z,br_three
	ld ix,level_two_four
	cp 5
	jp z,br_four
	ld ix,level_two_five
	cp 4
	jp z,br_five
	ld ix,level_two_six
	cp 3
	jp z,br_six
	ld ix,level_two_seven
	cp 2
	jp z,br_seven
	ld ix,level_two_eight
	cp 1
	jp z,br_eight
lay_three:
	ld hl,3
	ld (level),hl
	ld a,(move)
	ld ix,level_three_one
	cp 7
	jp z,br_one
	ld ix,level_three_two
	cp 8
	jp z,br_two
	ld ix,level_three_three
	cp 5
	jp z,br_three
	ld ix,level_three_four
	cp 6
	jp z,br_four
	ld ix,level_three_five
	cp 3
	jp z,br_five
	ld ix,level_three_six
	cp 4
	jp z,br_six
	ld ix,level_three_seven
	cp 1
	jp z,br_seven
	ld ix,level_three_eight
	cp 2
	jp z,br_eight
lay_four:
	ld hl,4
	ld (level),hl
	ld a,(move)
	ld ix,level_four_one
	cp 3
	jp z,br_one
	ld ix,level_four_two
	cp 5
	jp z,br_two
	ld ix,level_four_three
	cp 4
	jp z,br_three
	ld ix,level_four_four
	cp 2
	jp z,br_four
	ld ix,level_four_five
	cp 6
	jp z,br_five
	ld ix,level_four_six
	cp 1
	jp z,br_six
	ld ix,level_four_seven
	cp 8
	jp z,br_seven
	ld ix,level_four_eight
	cp 7
	jp z,br_eight
lay_five:
	ld hl,5
	ld (level),hl
	ld a,(move)
	ld ix,level_five_one
	cp 6
	jp z,br_one
	ld ix,level_five_two
	cp 4
	jp z,br_two
	ld ix,level_five_three
	cp 7
	jp z,br_three
	ld ix,level_five_four
	cp 3
	jp z,br_four
	ld ix,level_five_five
	cp 8
	jp z,br_five
	ld ix,level_five_six
	cp 5
	jp z,br_six
	ld ix,level_five_seven
	cp 2
	jp z,br_seven
	ld ix,level_five_eight
	cp 1
	jp z,br_eight
lay_six:
	ld hl,6
	ld (level),hl
	ld a,(move)
	ld ix,level_six_one
	cp 3
	jp z,br_one
	ld ix,level_six_two
	cp 2
	jp z,br_two
	ld ix,level_six_three
	cp 1
	jp z,br_three
	ld ix,level_six_four
	cp 8
	jp z,br_four
	ld ix,level_six_five
	cp 5
	jp z,br_five
	ld ix,level_six_six
	cp 7
	jp z,br_six
	ld ix,level_six_seven
	cp 4
	jp z,br_seven
	ld ix,level_six_eight
	cp 6
	jp z,br_eight
lay_seven:
	ld hl,7
	ld (level),hl
	ld a,(move)
	ld ix,level_seven_one
	cp 5
	jp z,br_one
	ld ix,level_seven_two
	cp 3
	jp z,br_two
	ld ix,level_seven_three
	cp 1
	jp z,br_three
	ld ix,level_seven_four
	cp 4
	jp z,br_four
	ld ix,level_seven_five
	cp 6
	jp z,br_five
	ld ix,level_seven_six
	cp 7
	jp z,br_six
	ld ix,level_seven_seven
	cp 8
	jp z,br_seven
	ld ix,level_seven_eight
	cp 2
	jp z,br_eight
lay_eight:
	ld hl,8
	ld (level),hl
	ld a,(move)
	ld ix,level_eight_one
	cp 7
	jp z,br_one
	ld ix,level_eight_two
	cp 3
	jp z,br_two
	ld ix,level_eight_three
	cp 5
	jp z,br_three
	ld ix,level_eight_four
	cp 6
	jp z,br_four
	ld ix,level_eight_five
	cp 4
	jp z,br_five
	ld ix,level_eight_six
	cp 8
	jp z,br_six
	ld ix,level_eight_seven
	cp 1
	jp z,br_seven
	ld ix,level_eight_eight
	cp 2
	jp z,br_eight

lay_nine:
	ld hl,9
	ld (level),hl
	ld a,(move)
	ld ix,level_nine_one
	cp 7
	jp z,br_one
	ld ix,level_nine_two
	cp 3
	jp z,br_two
	ld ix,level_nine_three
	cp 5
	jp z,br_three
	ld ix,level_nine_four
	cp 6
	jp z,br_four
	ld ix,level_nine_five
	cp 4
	jp z,br_five
	ld ix,level_nine_six
	cp 8
	jp z,br_six
	ld ix,level_nine_seven
	cp 1
	jp z,br_seven
	ld ix,level_nine_eight
	cp 2
	jp z,br_eight

lay_ten:
	ld hl,10
	ld (level),hl
	ld a,(move)
	ld ix,level_ten_one
	cp 5
	jp z,br_one
	ld ix,level_ten_two
	cp 1
	jp z,br_two
	ld ix,level_ten_three
	cp 3
	jp z,br_three
	ld ix,level_ten_four
	cp 2
	jp z,br_four
	ld ix,level_ten_five
	cp 8
	jp z,br_five
	ld ix,level_ten_six
	cp 4
	jp z,br_six
	ld ix,level_ten_seven
	cp 6
	jp z,br_seven
	ld ix,level_ten_eight
	cp 7
	jp z,br_eight

lay_eleven:
	ld hl,11
	ld (level),hl
	ld a,(move)
	ld ix,level_eleven_one
	cp 1
	jp z,br_one
	ld ix,level_eleven_two
	cp 8
	jp z,br_two
	ld ix,level_eleven_three
	cp 7
	jp z,br_three
	ld ix,level_eleven_four
	cp 3
	jp z,br_four
	ld ix,level_eleven_five
	cp 2
	jp z,br_five
	ld ix,level_eleven_six
	cp 4
	jp z,br_six
	ld ix,level_eleven_seven
	cp 5
	jp z,br_seven
	ld ix,level_eleven_eight
	cp 6
	jp z,br_eight

lay_twelve:
	ld hl,12
	ld (level),hl
	ld a,(move)
	ld ix,level_twelve_one
	cp 6
	jp z,br_one
	ld ix,level_twelve_two
	cp 2
	jp z,br_two
	ld ix,level_twelve_three
	cp 5
	jp z,br_three
	ld ix,level_twelve_four
	cp 8
	jp z,br_four
	ld ix,level_twelve_five
	cp 3
	jp z,br_five
	ld ix,level_twelve_six
	cp 4
	jp z,br_six
	ld ix,level_twelve_seven
	cp 7
	jp z,br_seven
	ld ix,level_twelve_eight
	cp 1
	jp z,br_eight

lay_thirteen:
	ld hl,13
	ld (level),hl
	ld a,(move)
	ld ix,level_thirteen_one
	cp 2
	jp z,br_one
	ld ix,level_thirteen_two
	cp 1
	jp z,br_two
	ld ix,level_thirteen_three
	cp 4
	jp z,br_three
	ld ix,level_thirteen_four
	cp 3
	jp z,br_four
	ld ix,level_thirteen_five
	cp 6
	jp z,br_five
	ld ix,level_thirteen_six
	cp 5
	jp z,br_six
	ld ix,level_thirteen_seven
	cp 8
	jp z,br_seven
	ld ix,level_thirteen_eight
	cp 7
	jp z,br_eight

lay_fourteen:
	ld hl,14
	ld (level),hl
	ld a,(move)
	ld ix,level_fourteen_one
	cp 4
	jp z,br_one
	ld ix,level_fourteen_two
	cp 1
	jp z,br_two
	ld ix,level_fourteen_three
	cp 8
	jp z,br_three
	ld ix,level_fourteen_four
	cp 5
	jp z,br_four
	ld ix,level_fourteen_five
	cp 7
	jp z,br_five
	ld ix,level_fourteen_six
	cp 3
	jp z,br_six
	ld ix,level_fourteen_seven
	cp 2
	jp z,br_seven
	ld ix,level_fourteen_eight
	cp 6
	jp z,br_eight

lay_fiveteen:
	ld hl,15
	ld (level),hl
	ld a,(move)
	ld ix,level_fiveteen_one
	cp 7
	jp z,br_one
	ld ix,level_fiveteen_two
	cp 3
	jp z,br_two
	ld ix,level_fiveteen_three
	cp 5
	jp z,br_three
	ld ix,level_fiveteen_four
	cp 1
	jp z,br_four
	ld ix,level_fiveteen_five
	cp 8
	jp z,br_five
	ld ix,level_fiveteen_six
	cp 6
	jp z,br_six
	ld ix,level_fiveteen_seven
	cp 2
	jp z,br_seven
	ld ix,level_fiveteen_eight
	cp 4
	jp z,br_eight


; brick drawing
br_one:		;all sprites are in the include.asm file.
	call loadcoord
	ld a,(move)		; load move in var, inc move
	ld (brone),a
	inc a
	ld (move),a

	jp drawing_init

br_two:
	call loadcoord
	ld a,(move)		; load move in var, inc move
	ld (brtwo),a
	inc a
	ld (move),a

	jp drawing_init

br_three:
	call loadcoord
	ld a,(move)		; load move in var, inc move
	ld (brthree),a
	inc a
	ld (move),a

	jp drawing_init

br_four:
	call loadcoord
	ld a,(move)		; load move in var, inc move
	ld (brfour),a
	inc a
	ld (move),a

	jp drawing_init

br_five:
	call loadcoord
	ld a,(move)		; load move in var, inc move
	ld (brfive),a
	inc a
	ld (move),a

	jp drawing_init

br_six:
	call loadcoord
	ld a,(move)		; load move in var, increase var
	ld (brsix),a
	inc a
	ld (move),a

	jp drawing_init

br_seven:
	call loadcoord
	ld a,(move)		; load move in var, inc move
	ld (brseven),a
	inc a
	ld (move),a
	jp drawing_init

br_eight:
	call loadcoord
	ld a,(move)		; load move in var, inc move
	ld (breight),a
	inc a
	ld (move),a
	jp drawing_init

reset:
	ld a,0
	ld (counter),a
	ld (ovcounter),a
	ret

loadcoord:
	ld a,(posy)
	ld l,a
	ld a,(posx)
	ld b,8
	call ionPutSprite
	ret




#INCLUDE "include.asm"
#INCLUDE "levels.asm"
#INCLUDE "ixput.asm"

hiscr:
	push	hl
	xor	a
	sbc	hl,de
	pop	hl
	jr	z,nnhs
	jr	nc,newhs
nnhs:
	ex	de,hl
	inc	a
	ret
newhs:
	or	a
	ret

highprac:
	.dw 0

campeasy:
	.dw 0
campmedium:
	.dw 0
camphard:
	.dw 0
layout:
	.dw 0
space:
	.dw 0
play:
	.dw 0
diffset:
	.dw 0

quit:
	ret
	.end
END
