;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
;
;                                           
;                                         
;                                          
;                                            
;                                           
;
; Boom!
; ver: 1.0
; Author: Bruce Herr 2
; E-mail: herrs@hsonline.net
;
; Date Started: 7/5/1998
; Date Finished: 7/13/1998
; Date released: 8//1998
;
; A "Kaboom!" type game.  Not as efficient as I'd like, but its a good start
; considering its my first assembly language game for the TI-86.  
;
; This game needs a big speed boost.  Once I figure out a way to do that, 
; this game will be perfect.  If you have any suggestions please E-mail me.
;
; I'd like to give a big thanks to Larry Kaplan for making the original game,
; "Kaboom!", for the Atari 2600 from which I got my game idea.
;
; I'd like to give a special thanks to TIcalc.org, TI-Files, and to the many  
; people who posted their source there, providing me with lots of sources from 
; which to learn from. 
;
; This is Freeware, so if you would like to use some of my source, please give
; credit where credit is due.  If you happen to change this source and make
; something cool out of it, please send me it.
;
; If anyone has a Putsprite routine that can put 16*16,8*8,and 12*13 sprites
; and possibly XOR it.  Then please E-Mail me a copy.  I would be glad to put
; you in the credits for my game.
;
; Also, If anyone knows how to save high scores, please E-Mail me an explanation.
; Right now I'm stumped on how to do it.  =(
;
; Please pardon some of my commenting.  After commenting about 700 lines of 
; code you get a little bit lazy, but I'm sure most of it is comprehendable.:>
;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

#include "asm86.h"
#include "ti86asm.inc"
.org _asm_exec_ram

	nop
	jp Main_Prog
	.dw $0000
	.dw Description

Main_Prog:
	call _clrLCD            ;cls
	call _graphbufclr
	call _runindicoff       ;turn off annoying run indicator
	call Draw_Opening       ;draw opening screen

Key_Loop:
	halt
	call GET_KEY
	cp K_EXIT
	jp z,Game_Exit
	cp K_ALPHA
	jp z,Game_Init
	jp Key_Loop

Game_Exit:
	ld hl,0
	ld (_curRow),hl 
	set appTextSave,(iy+appflags)   ; clear _textShadow with _clrScrn
	call _clrScrn
	call _clrLCD
	ret

Game_Init:
	ld a,3
	ld (Lives),a            ;lives = 3
	ld a,0
	ld (MoveCtr),a          ;ld the Move counter for the enemy w/ 0
	ld (Level),a            ;level = 0 (Lev_Loop will inc it to 1)
	ld hl,$0000
	ld (Score),hl           ;score = 0
	ld a,50
	ld (E_X),a              ;starting x coord. for the bomb droppa
	ld (x),a                ;starting x
	ld (lx),a               ;ditto
	ld hl,E_Dir
	ld (hl),1       
	call _clrLCD
	call Draw_Screen
	xor a
	ld (Temp2),a
	ld a,51
	ld (Temp),a
Init_Bucket:
	ld a,(Temp)             ;ld the y
	ld e,a
	ld a,(x)                ;ld the x
	ld hl,S_Bucket_1        ;ld the sprite
	call PutSprite          ;put it!
	ld a,(Temp)             ;ld the y
	ld e,a
	ld a,(x)                ;ld the x
	add a,8
	ld hl,S_Bucket_2        ;ld the sprite
	call PutSprite          ;put it!
	ld a,(Temp)             ;\
	add a,5                 ;add 5 to the y
	ld (Temp),a             ;/
	ld a,(Temp2)
	inc a
	ld (Temp2),a
	cp 3                    ;if its not 3 then
	jp nz,Init_Bucket       ;do more buckets
	
Lev_Loop:
	ld hl,55*256+102        ;row*256+col    
	ld (_penCol),hl
	ld a,(Level)
	inc a                   ;inc level
	ld (Level),a            ;/
	call DispA              ;disp Level
	ld a,(Level)            ;ld a w/ level
	cp 51
	jp z,You_Win
	add a,a                 ;double a
	add a,4                 ;and add 4
	ld (NumBombs),a         ;save it into NumBombs (= 4+2*level)
	ld (BombsLeft),a        ;save it into BombsLeft
	ld h,a
	ld a,225
	sub h
	cp -1
	jp p,Keep_Delay
	ld a,0
Keep_Delay:
	ld (ELevDel),a          ;ld the delay w/ 100 - (4+4*level)
	ld a,0                  ;ld a w/ the loop counter
	ld bc,bx                ;ld bc w/ the pointer to the bomb x array
	ld de,by                ;ld de w/ the pointer to the bomb y array
	ld hl,bl                ;ld hl w/ the pointer to the bomb life array
Init_Bomb:
	ex af,af'               ;save a
	xor a
	ld (bc),a               ;bombx(a) = 0
	ld (de),a               ;bomby(a) = 0
	ld (hl),a               ;bomblife(a) = 0
	inc bc                  ;goto the next subscript
	inc de                  ;ditto
	inc hl                  ;ditto
	ex af,af'               ;load a
	inc a                   ;++loop counter
	push de
	ld d,a
	ld a,(NumBombs)
	inc a
	ld e,a
	ld a,d
	cp e                    ;if its <> NumBombs + 1 then keep looping
	pop de
	jp nz,Init_Bomb
	xor a
	ld (EDelay),a
	ld (BombsDropped),a
	call Hit_2nd
Wait_Loop:        
	halt
	ld a,0ffh               ;Reset keyport
	out (1),a               ;Clear Port
	ld a,%01111110          ;bit 0 is zero, checking for {-,-,-,UP,RIGHT,LEFT,DN}
	out (1),a               ;put it out the port
	nop
	in a,(1)                ;reading...
	ld h,a
	bit 2,a                 ;checking if key is {--,--,--,UP,RIGHT,LEFT,DOWN}
	call z,M_Right          ;if the bit was set, the common key in both sets (Right) was pressed.
	ld a,h
	bit 1,a                 ;checks for LEFT
	call z,M_Left
	ld a,%00111111          ;bit 6 is zero for checking for (EXIT)
	out (1),a               ;put it out the port
	nop
	in a,(1)                ;reading...
	bit 6,a                 ;check the 6th bit to see if its on (EXIT) 
	jp z,Exit_Game          ;if it is then goto the main screen
	ld c,a
	bit 5,a                 ;if its 2nd then
	call z,Erase_Line
	ld a,c
	bit 5,a                 ;if its 2nd then
	jp z,Game_Loop          ;go play game
	call Draw_Bucket        ;update the buckets
	jp Wait_Loop

Game_Loop:
	ld hl,ELevDel
	ld b,2
Pause_Again:        
	ld a,b
	ld b,(hl)
Pause_Loop:
	djnz Pause_Loop
	ld b,a
	djnz Pause_Again
	ld a,0ffh               ;Reset keyport
	out (1),a               ;Clear Port
	ld a,%01111110          ;bit 0 is zero, checking for {-,-,-,UP,RIGHT,LEFT,DN}
	out (1),a               ;put it out the port
	nop
	in a,(1)                ;reading...
	ld h,a
	bit 2,a                 ;checking if key is {--,--,--,UP,RIGHT,LEFT,DOWN}
	call z,M_Right          ;if the bit was set, the common key in both sets (Right) was pressed.
	ld a,h
	bit 1,a                 ;checks for LEFT
	call z,M_Left
	ld a,%00111111          ;bit 6 is zero for checking for (EXIT)
	out (1),a               ;put it out the port
	nop
	in a,(1)                ;reading...
	bit 6,a                 ;check the 6th bit to see if its on (EXIT) 
	jp z,Exit_Game          ;if it is then goto the main screen
	bit 7,a                 ;if its More then
	call z,Pause_Game       ;Pause
	call Draw_Bucket        ;update the buckets
	call Move_Enemy         ;move the enemy bomb droppa
	call Move_Bomb
;Beginning of collision detection routine.
	ld bc,0                 ;offset
Check_Loop:
	ld hl,bl                ;hl is a pointer to the bomb life
	add hl,bc               ;add the offset
	xor a
	cp (hl)                 ;if it is dead then
	jp z,Not_There          ;skip stuff
	ld e,-1
	ld a,51
	ld (Temp),a
_Col_Loop:
	call _Collisions        ;check for a collision
	cp 1                    ;if a collision occured react
	jp z,_Col_Occured       ;/
	inc e                   ;otherwise inc loop counter
	ld a,(Temp)             ;\
	add a,5                 ;+5 to the y 
	ld (Temp),a             ;/
	ld a,(Lives)            ;if lives are greater 
	cp e                    ;than the loop then 
	jp p,_Col_Loop          ;loop again
	ld hl,by                ;ld hl w/ the bomb y coord
	add hl,bc               ;add the offset                                              
	ld a,(hl)               ;ld the value into a
	cp 55                   ;if its not at the bottom then                        
	jp nz,Not_There         ;skip to prepare for another
	ld a,(Lives)
	dec a
	ld (Lives),a
	cp 0
	jp z,You_Lose           ;does you lose stuff 
	ld a,(Level)
	dec a                   ;-1 to level (lev loop will bring it back to the same level)
	ld (Level),a
	ld a,(E_Dir)            ;\
	neg                     ;reverse the enemies direction   
	ld (E_Dir),a            ;/
	jp Next_Round
Not_There:
	inc c                   ;inc the offset      
	ld a,(NumBombs)         ;ld a w/ the NumBombs for this level
	inc a
	cp c                    ;compare the two
	jp z,Game_Loop          ;if its zero then goto game loop
	jp Check_Loop           ;else loop again
;end of collision detection routine

_Col_Occured:
	ld hl,(Score)           ;Score = Score + Level
	ld a,(Level)            ;/
	ld e,a
	ld d,0                  ;/
	add hl,de               ;/
	ld (Score),hl           ;/
	call Display_Score      ;put score on the screen
	ld hl,bl
	add hl,bc
	ld (hl),0
	ld hl,by        
	add hl,bc
	ld e,(hl)
	ld hl,bx
	add hl,bc
	ld a,(hl)
	push bc
	ld hl,S_Bomb
	call PutSprite          ;XOR it!
	pop bc
	ld a,(BombsLeft)
	dec a                   ;-1 to the number of bombs left
	ld (BombsLeft),a
	cp 0
	jp z,Lev_Loop
	jp Not_There            ;skip to prepare for another

Move_Bomb:
	ld bc,0                 ;offset
Chk_Loop:
	ld hl,bl                ;hl is a pointer to the bomb life
	add hl,bc               ;add the offset
	ld a,(hl)               ;ld the life pointed to by hl into a
	cp 0                    
	jp z,Not_Living         
	push bc                 ;save offset
	ld hl,by                ;ld hl w/ the bomb y pointer
	add hl,bc               ;add the offset
	ld e,(hl)               ;save the value into e
	inc (hl)
	ld hl,bx                ;ld hl w/ the bomb x pointer
	add hl,bc               ;add the offset
	ld a,(hl)               ;put the value in a
	ld d,a                  
	push de                 ;save the coords.
	ld hl,S_Bomb            ;load the bomb sprite pointer
	call PutSprite          ;xor it!
	pop de                  ;load the coords
	inc e                   ; and inc the y 
	ld a,d                  ;put the x into a
	ld hl,S_Bomb            ;load the bomb sprite
	call PutSprite          ;and put it!
	pop bc                  ;get the offset back
Not_Living:
	inc c                   ;inc the offset      
	ld a,(NumBombs)         ;ld a w/ the NumBombs for this level
	inc a
	cp c                    ;compare the two
	ret z                   ;if its zero then return
	jp Chk_Loop             ;else loop again

_Collisions:                    
	ld hl,bx                ;ld hl w/ bomb x
	add hl,bc               ;add the offset
	ld d,(hl)               ;load d w/ badguyX coord.
	inc d
	ld a,(x)                ;load a w/ x coord.
	sub 8                   ;sub width of sprite from x
	cp d                    ;IF x - (width) <= badguyX THEN
	jp m,good_col           ;do some more checking
	ld a,0                  ;ELSE there wasn't a collision
	ret                     ;return
good_col:
	add a,12+8              ;add the width + 8
	dec d
	dec d
	cp d                    ;IF x + (width) > badguyX THEN
	jp p,still_good         ;do even more checking
	ld a,0                  ;ELSE there wasn't a collision
	ret                     ;return
still_good:
	ld hl,by                ;ld hl w/ bomb y
	add hl,bc               ;add the offset
	ld a,(hl)               ;load d w/ badguyY coord.
	add a,9                 ;goto bottom of sprite
	ld d,a
	ld a,(Temp)             ;ld a w/y
	cp d
	jp m,still_good2        ;do even more checking
	ld a,0                  ;ELSE there wasn't a collision
	ret                     ;return
still_good2:
	add a,3                 ;add the heighth 
	cp d                    ;IF y + (heighth) > badguyY THEN
	jp p,all_good           ;there was a collision! oohh yeee!
	ld a,0                  ;ELSE there wasn't a collision
	ret                     ;return
all_good:
	ld a,1                  ;tell 'em there was collision
	ret                     ;return                

Next_Round:
	ld bc,0                  ;ld the offset (bc) w/ 0
Next_Loop:
	ld hl,bl                ;ld a pointer to the bomb life array
	add hl,bc               ;add the offset
	ld a,1                  ;if there is a one
	cp (hl)                 ;in that spot 
	call z,Live_One         ;Then show an explosion there
	inc c                   ;inc the offset
	ld a,(NumBombs)         ;loop until c = Numbombs + 1
	inc a
	cp c                    ;NumBombs
	jp nz,Next_Loop         ;/
	call Hit_2nd
Next_Pause:
	halt
	call GET_KEY            ;Pause until they hit second or 
	cp K_EXIT               ;exit if they hit exit
	jp z,Exit_Game
	cp K_SECOND
	jp nz,Next_Pause
	call Erase_Line
	ld bc,0                  ;ld the offset w/ 0
Next_Lop:
	ld hl,bl                ;ld hl w/ the pointer to the bomb life array
	add hl,bc               ;add the offset
	ld a,1                  ;if its one then
	cp (hl)                 ;erase the explosion
	call z,Kill_One         ;and set its life to 0
	inc c                   ;inc the offset
	ld a,(NumBombs)         ;loop until c = Numbombs + 1
	inc a
	cp c                    
	jp nz,Next_Lop          
	ld a,(Lives)            ;ld the lives
	cp 1                    ;if one is left then
	jp z,One_Life           ;y = 56
	ld a,61                 ;else y = 61
	ld (Temp),a             ;/
	jp Erase_Buc            ;/
One_Life:
	ld a,56                 ;y = 56
	ld (Temp),a             ;/
Erase_Buc:
	ld e,a                  ;ld e, w/ y
	ld a,(x)                ;ld the x coord
	ld hl,S_Bucket_1        ;ld the first bucket sprite
	call PutSprite          ;XOR it!
	ld a,(Temp)             ;ld the y coord
	ld e,a                  ;into e
	ld a,(x)                ;ld the x coord
	add a,8                 ;and add 8
	ld hl,S_Bucket_2        ;ld the second bucket sprite
	call PutSprite          ;XOR it!
	jp Lev_Loop             ;Do Lev over

Live_One:
	push bc
	ld hl,by
	add hl,bc
	ld e,(hl)
	ld hl,bx
	add hl,bc
	ld a,(hl)
	ld d,a
	push de
	ld hl,S_Bomb
	call PutSprite          ;XOR it!
	pop de
	ld a,d
	ld hl,S_Explosion
	call PutSprite          ;Put an Explosion!
	pop bc
	ret

Kill_One:
	push bc
	ld hl,by
	add hl,bc
	ld e,(hl)
	ld hl,bx
	add hl,bc
	ld a,(hl)
	ld d,a
	ld hl,S_Explosion
	call PutSprite          ;XOR it!
	pop bc
	ret

Draw_Enemy:        
	ld e,0
	ld a,(E_X)
	ld hl,S_E_UL
	call PutSprite
	ld e,0
	ld a,(E_X)
	add a,8
	ld hl,S_E_UR
	call PutSprite
	ld e,8
	ld a,(E_X)
	add a,8
	ld hl,S_E_LR
	call PutSprite
	ld e,8
	ld a,(E_X)
	ld hl,S_E_LL
	call PutSprite
	ld e,16
	ld a,(E_X)
	ld hl,S_E_Hand
	call PutSprite
	ld e,16
	ld a,(E_X)
	add a,11
	ld hl,S_E_Hand
	call PutSprite
	ret

Hit_2nd:
	ld hl,23*256+0                  ;row*256+col    
	ld (_penCol),hl
	ld hl,T_Hit_2nd                 ;disp "Hit 2nd!!"
	call _vputs
	ret

Erase_Line:
    ld de,23*256-1                 ;row*256+col           
	ld b,50
Erase_Loop:
	inc de
	ld (_penCol),de
	ld hl,T_Blank                 ;disp "        "
	call _vputs
	djnz Erase_Loop
	ret

Exit_Game:
	call Hit_2nd
	ld a,4
	ld (_curRow),a
	ld (_curCol),a
	ld hl,T_Game_Over                 ;disp "Game Over"
	call _puts
Exit_Loop
	halt
	call GET_KEY
	cp K_SECOND
	jp nz,Exit_Loop
	jp Main_Prog

Pause_Game:
	halt
	call GET_KEY
	cp K_EXIT
	jp z,Exit_Game
	cp K_SECOND
	jp nz,Pause_Game
	ret

M_Left:
	ld a,(x)
	cp 0
	ret z
	dec a
	ld (x),a
	ret

M_Right:
	ld a,(x)
	cp 88
	ret z
	inc a
	ld (x),a
	ret

Move_Enemy:
	ld a,(NumBombs)         ;ld d w/ the number of bombs
	ld d,a                  ;/
	ld a,(BombsDropped)     ;ld a w/ the number of bombs dropped
	cp d                    ;if they are equal then
	ret z                   ;don't move the enemy
	call Draw_Enemy         ;XOR the enemy!
	ld a,(E_Dir)            ;ld e the enemy's dir
	ld e,a                  ;/
	ld a,(E_X)              ;ld a w enemies x
	add a,e                 ;E_X = E_X + E_Dir
	ld (E_X),a              ;/
	call Draw_Enemy         ;put the dang enemy!
	ld a,(E_X)
	cp 1                    ;if at 0 then 
	jp m,Neg_E_Dir          ;changes the dir
	cp 83                   ;if at 84 then
	jp p,Neg_E_Dir          ;changes the dir
	ld a,255
	call Random
	cp 1
	jp z,Neg_E_Dir
Ch_Dir:
	ld a,(MoveCtr)
	inc a                   ;inc move ctr
	ld (MoveCtr),a          ;ld a w/ move counter
	cp 25                   ;if its not __ then
	ret nz                  ;return 
	xor a                   ;a=0
	ld (MoveCtr),a          ;else reset move counter
	ld a,(BombsDropped)
	inc a                   ;inc bombs dropped
	ld (BombsDropped),a     ;ld bc w/ it and use it as the offset
	ld b,0
	ld c,a
	ld hl,bx                ;ld hl w/ bomb's x array
	add hl,bc               ;add the offset
	ld a,(E_X)              ;put the enemy's x into a
	add a,4                 ;add 4 to it (to center it)
	ld (hl),a               ;ld that value into the bomb's x
	ld hl,by                ;ld hl w/ the bomb y array
	add hl,bc               ;add the offset
	ld (hl),20              ;ld it w/ 20
	ld hl,bl                ;ld hl w/ the bomb life
	add hl,bc               ;add the offset
	ld (hl),1               ;ld a one into it
	ld e,20                 ;assign e the x value
	ld a,(E_X)              ;get the Enemy's x coord
	add a,4                 ;add 4 to it
	ld hl,S_Bomb            ;ld the bomb sprite pointer
	call PutSprite          ;Put it!
	ret                     ;return

Neg_E_Dir:
	ld a,(E_Dir)            ;ld a w/ the direction the enemy is heading
	neg                     ;switch the sign (1 to -1 or -1 to 1)
	ld (E_Dir),a            ;save it back into E_Dir
	jp Ch_Dir               ;jump to Ch_Dir

Draw_Bucket:
	ld a,(lx)               ;ld the last x into a
	ld hl,x
	cp (hl)                 ;if its not different then
	jp z,Buc_Delay
	xor a
	ld (Temp2),a            ;ld temp2 w/ offset & loop counter
	ld a,51
	ld (Temp),a             ;ld temp w/ 51 (y value)
Draw_Loop:
	ld a,(Temp)             ;ld the y
	ld e,a
	ld a,(lx)               ;ld the lx
	ld hl,S_Bucket_1        ;ld the sprite
	call PutSprite          ;XOR it!
	ld a,(Temp)             ;ld the y
	ld e,a
	ld a,(lx)               ;ld the lx
	add a,8
	ld hl,S_Bucket_2        ;ld the sprite
	call PutSprite          ;XOR it!
	ld a,(Temp)             ;ld the y
	ld e,a
	ld a,(x)                ;ld the x
	ld hl,S_Bucket_1        ;ld the sprite
	call PutSprite          ;put it!
	ld a,(Temp)             ;ld the y
	ld e,a
	ld a,(x)                ;ld the x
	add a,8
	ld hl,S_Bucket_2        ;ld the sprite
	call PutSprite          ;put it!
	ld a,(Temp)             ;\
	add a,5                 ;add 5 to Temp
	ld (Temp),a             ;/
	ld a,(Temp2)            ;ld it into a
	inc a                   ;inc the loop counter
	ld e,a
	ld (Temp2),a            ;/
	ld a,(Lives)            ;if lives are greater 
	inc e
	cp e                    ;than the loop then 
	jp p,Draw_Loop          ;loop again
Done_Bucket:
	ld a,(x)
	ld (lx),a               ;lx = x
	ret                     ;return

Buc_Delay:                      
	ld hl,200               
	ld a,(ELevDel)          
	ld e,a
	ld d,0
	add hl,de
	ex de,hl
	ld hl,0
Buck_Loop:                       
	inc hl
	call CP_HL_DE
	jp nz,Buck_Loop
	jp Done_Bucket
     
You_Lose:
	ld hl,by                ;ld hl w/ the bomb y coord
	add hl,bc               ;add the offset                                              
	ld e,(hl)               ;ld the value into a
	ld hl,bx                ;ld hl w/ the bomb x coord
	add hl,bc               ;add the offset
	ld a,(hl)               ;save it into d
	ld d,a                  ;
	push de                 ;save the coords.
	ld hl,S_Bomb            ;ld the bomb sprite
	call PutSprite          ;XOR it off!
	pop de                  ;get the coords. back
	ld a,d
	ld hl,S_Explosion
	call PutSprite          ;put a dang explosion freakin' there
	set 3,(iy+$05)          ;draw in inverse text
	ld a,4
	ld (_curRow),a
	ld (_curCol),a
	ld hl,T_You_Lose        ;disp "You lose"
	call _puts
	res 3,(iy+$05)          ;res to reg. text
	call Hit_2nd
Lose_Loop:
	call GET_KEY
	cp K_SECOND
	jp nz,Lose_Loop
	jp Main_Prog

You_Win:
	set 3,(iy+$05)          ;draw in inverse text
	ld a,4
	ld (_curRow),a
	ld (_curCol),a
	ld hl,T_You_Win         ;disp "You Win!!"
	call _puts
	res 3,(iy+$05)          ;res to reg. text
	call Hit_2nd
Win_Loop:
	call GET_KEY
	cp K_SECOND
	jp nz,Win_Loop
	jp Main_Prog

_graphbufclr:                          ;clears the graph buffer, so _ILine doesn't mess up
	ld hl,_plotSScreen             ;graphmem into HL
	ld (hl),0                      ;loads 0 into it
	ld de,_plotSScreen+1           ;loads graphmem+1 into de
	ld bc,1024                     ;loads the 1024 into bc
	ldir                           ;draws on screen
	set graphdraw,(iy+graphflags)  ;sets flag
	ret                            ;return from call

Display_Score:
	ld hl,40*256+102                  ;row*256+col    
	ld (_penCol),hl
	ld hl,(Score)                     
	call DispHL
	ret

Draw_Opening:
	ld a,3
	ld (_curRow),a
	ld a,6
	ld (_curCol),a
	ld hl,T_Boom            ;disp "B O O M !"
	call _puts                             
	ld hl,47*256+99         ;row*256+col    
	ld (_penCol),hl
	ld a,2
	call DispA              ;draw a little  next to "By: Bruce Herr"
	ld a,6
	ld (_curRow),a
	ld a,3
	ld (_curCol),a
	ld hl,T_Me              ;disp "By: Bruce Herr"
	call _puts                             
	ld hl,57*256+45         ;row*256+col    
	ld (_penCol),hl
	ld hl,T_Press_ALPHA     ;disp "Press ALPHA"
	call _vputs
	ld a,24
	ld e,a
	ld hl,S_Bomb
	call PutSprite
	ld a,93
	ld e,24
	ld hl,S_Bomb
	call PutSprite
	ld a,56
	ld (E_X),a
	call Draw_Enemy
	ld b,0                        ;x1
	ld c,48                         ;y1
	ld d,126                        ;x2
	ld e,c                          ;y2
	ld h,1                          ;h = 1 for Shading (2 = unshade, 3 = xor)
	call  _ILine                    ;draw the line
	ret

Draw_Screen:
	call _graphbufclr
	ld b,100                        ;x1
	ld c,1                          ;y1
	ld d,126                        ;x2
	ld e,c                          ;y2
	ld h,1                          ;h = 1 for Shading (2 = unshade, 3 = xor)
	call  _ILine                    ;draw the line
	ld b,100                        ;x1
	ld c,0                          ;y1
	ld d,b                          ;x2
	ld e,63                         ;y2
	ld h,1                          ;h = 1 for Shading (2 = unshade, 3 = xor)
	call  _ILine                    ;draw the line
	ld b,100                        ;x1
	ld c,63                         ;y1
	ld d,126                        ;x2
	ld e,c                          ;y2
	ld h,1                          ;h = 1 for Shading (2 = unshade, 3 = xor)
	call  _ILine                    ;draw the line
	ld b,126                        ;x1
	ld c,63                         ;y1
	ld d,b                          ;x2
	ld e,0                          ;y2
	ld h,1                          ;h = 1 for Shading (2 = unshade, 3 = xor)
	call  _ILine                    ;draw the line
	ld b,126                        ;x1
	ld c,16                         ;y1
	ld d,100                        ;x2
	ld e,c                          ;y2
	ld h,1                          ;h = 1 for Shading (2 = unshade, 3 = xor)
	call  _ILine                    ;draw the line
	ld b,126                        ;x1
	ld c,32                         ;y1
	ld d,100                        ;x2
	ld e,c                          ;y2
	ld h,1                          ;h = 1 for Shading (2 = unshade, 3 = xor)
	call  _ILine                    ;draw the line
	ld b,126                        ;x1
	ld c,42                         ;y1
	ld d,100                        ;x2
	ld e,c                          ;y2
	ld h,1                          ;h = 1 for Shading (2 = unshade, 3 = xor)
	call  _ILine                    ;draw the line
	ld b,100                        ;x1
	ld c,48                         ;y1
	ld d,0                          ;x2
	ld e,c                          ;y2
	ld h,1                          ;h = 1 for Shading (2 = unshade, 3 = xor)
	call  _ILine                    ;draw the line
	ld hl,49*256+103                ;row*256+col    
	ld (_penCol),hl
	ld hl,T_Level                   ;disp "Level:"
	call _vputs
	ld hl,33*256+103                ;row*256+col    
	ld (_penCol),hl
	ld hl,T_Score                   ;disp "Score:"
	call _vputs
	call Display_Score              ;disp Score
	ld hl,23*256+103                ;row*256+col    
	ld (_penCol),hl
	ld hl,T_BH2                     ;disp "By:BH2"
	call _vputs
	ld a,102                        ;title x
	ld e,3                          ;title y
	ld hl,S_Title_A                 ;title pointer
	call PutSprite                  ;Put it!
	ld a,110                        ;title x
	ld e,3                          ;title y
	ld hl,S_Title_B                 ;title pointer
	call PutSprite                  ;Put it!
	ld a,118                        ;title x
	ld e,3                          ;title y
	ld hl,S_Title_C                 ;title pointer
	call PutSprite                  ;Put it!
	ld a,102                        ;title x
	ld e,11                         ;title y
	ld hl,S_Title_D                 ;title pointer
	call PutSprite                  ;Put it!
	ld a,110                        ;title x
	ld e,11                         ;title y
	ld hl,S_Title_E                 ;title pointer
	call PutSprite                  ;Put it!
	ld a,118                        ;title x
	ld e,11                         ;title y
	ld hl,S_Title_F                 ;title pointer
	call PutSprite                  ;Put it!
	call Draw_Enemy                 ;draw where the bomb droppa is
	ret

;  |)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))|
;--|Randomization routine by Jimmy Mardell (used in ZTetris v3.0)|--
;  |<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<|
Random:               ; Creates a pseudorandom number 0 <= x < A
   ld b,a
   ld a,r
   add a,a
   ld hl,0
   ld d,0
   ld e,a
RMul:
   add hl,de
   djnz RMul
   ld a,h
   ret


;-----Display HL Routine [By: SCaBBy]-----
DispA:
 ld l,a
 ld h,0
DispHL:                                 ;dipslay 5 digits from hl
 xor a
 ld de,-1
 ld (_curRow),de
 call 4A33h
 dec hl
 jp _vputs

;----------------------
;|Sprite Routine [XOR]
;----------------------
;------------------------------------------------------
;|This Routine was converted by AVD from Movax's 83
;|Special thanks to ScaBBy for making it XOR Routine!
;------------------------------------------------------

;hl = image
;a = x coord
;e = y coord

PutSprite:
       push    hl              ; Save sprite address

;   Calculate the address in graphbuf   

	ld      hl,0            ; Do y*12
	ld      d,0
	ex      de,hl
	add     hl,hl
	add     hl,hl
	add     hl,hl
	add     hl,hl

	ld      d,0             ; Do x/8
	ld      e,a
	srl     e
	srl     e
	srl     e
	add     hl,de

	ld      de,$FC00
	add     hl,de           ; Add address to graphbuf

	ld      b,00000111b     ; Get the remainder of x/8
	and     b
	cp      0               ; Is this sprite aligned to 8*n,y?
	jp      z,ALIGN


;   Non aligned sprite blit starts here   

	pop     ix              ; ix->sprite
	ld      d,a             ; d=how many bits to shift each line

	ld      e,8             ; Line loop
LILOP:  ld      b,(ix+0)        ; Get sprite data

	ld      c,0             ; Shift loop
	push    de
SHLOP:  srl     b
	rr      c
	dec     d
	jp      nz,SHLOP
	pop     de

	ld      a,b             ; Write line to graphbuf
	xor     (hl)
	ld      (hl),a
	inc     hl
	ld      a,c
	xor     (hl)
	ld      (hl),a

	ld      bc,15           ; Calculate next line address
	add     hl,bc
	inc     ix              ; Inc spritepointer

	dec     e
	jp      nz,LILOP        ; Next line

	jp      DONE1


;   Aligned sprite blit starts here   

ALIGN:                          ; Blit an aligned sprite to graphbuf
	pop     de              ; de->sprite
	ld      b,8
ALOP1:  ld      a,(de)
	xor      (hl)            ; xor=erase/blit
	ld      (hl),a
	inc     de
	push    bc
	ld      bc,16
	add     hl,bc
	pop     bc
	djnz    ALOP1

DONE1:
	ret


;Variables:
bl:
    .db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    .db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    .db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    .db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    .db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
bx: 
    .db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    .db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    .db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    .db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    .db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
by:
    .db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    .db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    .db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    .db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    .db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

Temp: .db 0,0
Temp2: .db 0,0
EDelay: .db 0
ELevDel: .db 0
lx: .db 0
x: .db 0
Score: .db 0,0
Lives: .db 0
Level: .db 0
BombsLeft: .db 0
NumBombs: .db 0
BombsDropped: .db 0
MoveCtr: .db 0
E_Dir: .db 0
E_X: .db 0

;Sprites:
S_Bomb:
	.db %00010000
	.db %00111100
	.db %01110110
	.db %11111011
	.db %11111111
	.db %11111111
	.db %01111110
	.db %00111100
S_Explosion:
	.db %11000011
	.db %11100111
	.db %01100110
	.db %00011000
	.db %00011000
	.db %01100110
	.db %11100111
	.db %11000011
S_Blank:
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
S_E_UL:
	.db %00000111
	.db %00001000
	.db %00011111
	.db %00011101
	.db %00011111
	.db %00010001
	.db %00010100
	.db %01111011
S_E_UR:
	.db %11100000
	.db %00010000
	.db %11111000
	.db %10111000
	.db %11111000
	.db %10001000
	.db %00101000
	.db %11011110
S_E_LL:
	.db %10000111
	.db %11111111
	.db %10001000
	.db %11111111
	.db %10001000
	.db %11111111
	.db %10001000
	.db %00000000
S_E_LR:
	.db %11100001
	.db %11111111
	.db %00010001
	.db %11111111
	.db %00010001
	.db %11111111
	.db %00010001
	.db %00000000
S_E_Hand:
	.db %10001000
	.db %11011000
	.db %01110000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000

S_Bucket_1:
	.db %01111111
	.db %11000000
	.db %01111111
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
S_Bucket_2:
	.db %11100000
	.db %00110000
	.db %11100000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
S_Title_A:
	.db %11111100
	.db %10000010
	.db %10010010
	.db %10111010
	.db %10010010
	.db %10000010
	.db %10000100
	.db %10001000
S_Title_B:        
	.db %00000010
	.db %00000100
	.db %00001111
	.db %00011101
	.db %00011110
	.db %00011111
	.db %00001111
	.db %00000000
S_Title_C:        
	.db %00000010
	.db %00000010
	.db %00000010
	.db %10000010
	.db %10000010
	.db %10000010
	.db %00000010
	.db %00000010
S_Title_D:        
	.db %10001000
	.db %10000100
	.db %10000010
	.db %10010010
	.db %10111010
	.db %10010010
	.db %10000010
	.db %11111100
S_Title_E:        
	.db %11101110
	.db %10101010
	.db %10101010
	.db %10101010
	.db %10101010
	.db %10101010
	.db %10101010
	.db %11101110
S_Title_F:        
	.db %11011010
	.db %11011010
	.db %11111010
	.db %10101000
	.db %10101000
	.db %10001010
	.db %10001010
	.db %10001010

T_Level: .db "Level:",0

T_Score: .db "Score:",0

T_BH2:   .db "By:BH2",0

T_You_Lose: .db "You Lose",0

T_You_Win: .db "You Win!!",0

T_Hit_2nd: .db "Hit 2nd!!",0

T_Game_Over: .db "Game Over",0

T_Blank: .db " ",0

T_Boom: .db "B O O M !",0

T_Me: .db "By: Bruce Herr",0

T_Press_ALPHA: .db "Press ALPHA",0

Description: .db "Boom! 1.0 by: Bruce Herr 2",0

.end
		  
