#if 0

                   - - >  B o m b e r B l o k e  < - -

                               version 0.96

                            by Matthew Shepcar
                            Icarus Productions



  Monster Abilities:

  intelligent = gets out of rows/columns with bombs in them

       Blob - none
       Snowman - if you are next to snowman he will walk towards you
                (pyro intelligence)
       Ghost - occasionally walks through walls
       Knight - fast, intelligent
       Droid - fast, intelligent, steals bombs
       Robot - zapper, explodes on death, intelligent, steals bombs


    To do:
        ghosts walking thru walls
        shovel should make blocks disintegrate slowly..
        flame thrower
        check for game won better (ie roundswon)
        ctf
        allow players to choose characters

    Bugs/potential bugs:

        you can walk in the status bar (!!!) at times
         - fixed? (dying robots!?!?) - hmm maybe not?? dunno.
        level 10 ends too quick (got a mystery first???)
         - maybe robot bug?
        monsters flicker - redrawspriteifbounded gone wrong :(
        steal option affects single player?
        what if someone is dying and then time up?
 
    Notes on the program:
 
        The level is stored at Grid.  This always contains the exact
        sprites on the screen including bombs, explosions and powerups.
        Players and enemies are not recorded in the Grid.   There is
        a special bit which can be set on any sprites in the grid. If
        bit 7 is set then the block conceals a powerup (which one it is is
        decided when it is uncovered)
 
        Any bombs the player drops get placed in the Bombs list.  The
        list can hold up to 48 bombs and so each of the 4 players should
        be able to safely drop up to 8 bombs at once.   A bomb with a
        fuse value of 0 in the list is inactive (not drawn).   When a
        fuse reaches 6 the bomb explodes over the next 5 frames.   The
        top 3 bits of the bomb's flags byte store the number of the player
        who dropped the bomb so that their info block can be updated when
        the bomb explodes to allow them to drop another bomb again.   The
        lowest 4 bits store the range of the bomb.

        Mirror images of sprites are created when the program starts.
        The small reversed sprites start with number 85.   The large
        reversed sprites start at number 128 (nb small & large sprites
        are completely separate, ie sml spr 0 <> lrg spr 0 :)

#endif


#include asm86.h
#include ti86asm.inc
#define TI86
;#define HELP

INTADDR                 =0F0F0h ;GreyBuffer+500h+((GreyBuffer+500h)/256)

_divHLbyA       =4048h
CONTRAST        =0C008h
LINKPORT        =7
TIMEOUT         =1000h
KEYDELAY        =3
VERSION         =96h    ;0.96

LETHALSPRITES   =55

.org 8100h      

        ld a,13
        out (5),a
	call _runindicoff
        call _flushallmenus
	call _clrLCD
	call InitGrey
        call FlipSprites
        ld a,r
        ld (Seed),a

#if 0
        xor a
        ld bc,0
ShowAllSprites:
        push af
        push bc
        call PutSprite
        pop bc
        ld a,b
        add a,8
        and 127
        ld b,a
        jr nz,NotNextLine
        ld a,c
        add a,7
        ld c,a
NotNextLine:
        pop af
        inc a
        cp 109
        jr nz,ShowAllSprites
        call WaitForKey
#endif

        ld a,(CONTRAST)
        add a,2
        cp 32
        jr nc,BadContrast
        out (2),a
BadContrast:

ShowMainMenu:
        call ClearScreen
        ld de,0FC02h
        call PutLogo

        ld hl,StartupText
        ld d,3
PutStartupText:
        ld b,(hl)
        inc hl
        ld c,(hl)
        inc hl
        call PutText
        ld a,(hl)
        or a
        jr nz,PutStartupText

        ld b,8
        ld a,150
ScrollTitle:
        push bc
        call Delay
        call Delay

        ld hl,0FD00h
        ld a,2
ScrollGrey:
        ld bc,07802h
DisInt:
        srl (hl)
        inc hl
        sla (hl)
        inc hl
        djnz DisInt
        dec c
        jr nz,DisInt
        ld hl,GreyBuffer+100h
        dec a
        jr nz,ScrollGrey

        pop bc
        ld a,4
        djnz ScrollTitle

DoMainMenu:
        call InitMenuScreen

        ld hl,MainMenu
        call DrawMenu
MainMenuLoop:
        call GetMenuKey
        jp c,Exit
        or a
        jp z,DoGameMenu
        dec a
        jr z,DoConfigMenu
        dec a
        jp z,ShowHiScores
#ifdef HELP
        dec a
        jp z,ShowHelpScreen
#endif
        dec a
        jp z,Exit
        jr MainMenuLoop

DoGameMenu:
        ld a,(MaxLevel)
        ld (MenuMaxLev),a
        ld hl,GameMenu
        call DrawMenu
GameMenuLoop:
        call GetMenuKey
        jr c,DoMainMenu
        or a
        jp z,StartGame1p
        dec a
        jp z,LevelWarp
        dec a
        jp z,StartGame2p
        dec a
        jp z,LinkGame1p
        dec a
        jp z,LinkGame2p
        jr GameMenuLoop


DoConfigMenu:
        ld hl,sWinsNeeded
        ld a,(hl)
        inc hl
        add a,'0'
        ld (WinsAscii),a
        ld a,(hl)
        inc hl
        call CheckYN
        ld (CTFAscii),a
        ld a,(hl)
        inc hl
        call CheckYN
        ld (StealAscii),a
        ld a,(hl)
        inc hl
        add a,'0'
        ld (MonstersAscii),a
        ld a,(hl)
        inc hl
        add a,'0'
        ld (TimeAscii),a
        ld a,(hl)
        inc hl
        add a,'0'
        ld (BlocksAscii),a
        ld a,(hl)
        inc hl
        call CheckYN
        ld (TeleportAscii),a
        ld a,(hl)
        inc hl
        call CheckYN
        ld (IntelligenceAscii),a
;        ld a,(NumPlayers)
;        add a,'0'
;        ld (PlayersAscii),a
ReturnToConfigMenu:
        ld hl,OptionsMenu
        call DrawMenu
ConfigMenuLoop:
        call GetMenuKey
        jr c,DoneConfig
        cp 2
        jr z,DoMultiplayerMenu
;        dec a
;        cp 2
;        jr nc,ConfigMenuLoop
        call CustomiseKeys
        jr DoConfigMenu
        
DoneConfig:
        ld hl,sWinsNeeded
        ld a,(WinsAscii)
        sub '0'
        ld (hl),a
        inc hl
        ld a,(CTFAscii)
        call CheckYNAscii
        ld (hl),a
        inc hl
        ld a,(StealAscii)
        call CheckYNAscii
        ld (hl),a
        inc hl
        ld a,(MonstersAscii)
        sub '0'
        ld (hl),a
        inc hl
        ld a,(TimeAscii)
        sub '0'
        ld (hl),a
        inc hl
        ld a,(BlocksAscii)
        sub '0'
        ld (hl),a
        inc hl
        ld a,(TeleportAscii)
        call CheckYNAscii
        ld (hl),a
        inc hl
        ld a,(IntelligenceAscii)
        call CheckYNAscii
        ld (hl),a
;        ld a,(PlayersAscii)
;        sub '0'
;        ld (NumPlayers),a
        jp DoMainMenu

DoMultiplayerMenu:
        ld hl,MultiplayerMenu
        call DrawMenu
MultiplayerMenuLoop:
        call GetMenuKey
        jr c,ReturnToConfigMenu
        cp 8
        jr nz,MultiplayerMenuLoop

DoExtrasMenu:
        call SetPowerupLimits
        ld hl,ExtrasMenu
        call DrawMenu
ExtrasMenuLoop:
        call GetMenuKey
        jr nc,ExtrasMenuLoop
        call SetPowerupLimits
        jr DoMultiplayerMenu

LinkGame1p:
        ld a,1
        jr LinkGame
LinkGame2p:
        ld a,2
LinkGame:
        ld (NumPlayers),a
        ld hl,LinkMenu
        call DrawMenu
        ld hl,WaitMsg
        ld bc,34*256+43
        call PutText
        ld a,VERSION
        call SendByte
        jr nc,Connected
TryConnect:
        call WaitMenuKey
        jp nc,DoMainMenu
        call TryReceiveByte
;        jr nc,WeAreSending
;        ld a,(0C000h)
;        or a
;        jp nz,DoMainMenu
        jr c,TryConnect
        cp VERSION
        jr z,WeAreSending   
        ld hl,LinkMenu
        call DrawMenu
        ld hl,BadVerMsg
        ld bc,16*256+43
        call PutText
        call WaitForKey        
        jp DoMainMenu
WeAreSending:
        ld a,(NumPlayers)
        call SendByte
        call nc,ReceiveByte
        jp c,DoMainMenu
        cp 3
        jp nc,DoMainMenu
        or 80h
        ld (RemotePlayers),a

ResendLinkSettings:
        ld hl,sLinkGameSettings
        ld de,LinkGameSettings
        ld bc,EndLinkGameSettings-LinkGameSettings
SendLinkGameSettings:
        ld a,(hl)
        add a,b
        ld b,a
        ld a,(hl)
        ldi
        call SendByte
        jp c,DoMainMenu
        ld a,c
        or a
        jr nz,SendLinkGameSettings
        ld a,b
        call SendByte
        call nc,ReceiveByte
        jp c,DoMainMenu
        or a
        jr z,ResendLinkSettings

        jr WoowoowooStartAlinkGame
Connected:
        call ReceiveByte
        jp c,DoMainMenu
        cp 3
        jp nc,DoMainMenu
        ld (RemotePlayers),a
        ld a,(NumPlayers)
        call SendByte
ReReceiveLinkGameSettings:
        ld hl,LinkGameSettings
        ld bc,(EndLinkGameSettings-LinkGameSettings)*256
ReceiveLinkGameSettings:
        call ReceiveByte
        jp c,DoMainMenu
        ld (hl),a
        add a,c
        ld c,a
        inc hl
        djnz ReceiveLinkGameSettings
        call ReceiveByte
        cp c
        jr z,LinkSettingsOK
        xor a
        call SendByte
        jr ReReceiveLinkGameSettings
LinkSettingsOK:
        ld a,-1
        call SendByte
        jr WoowoowooStartAlinkGame

LevelWarp:
        ld a,(StartLevAscii)
        sub '1'
        ld b,1
.org $-1
StartGame1p:
        xor a
        ld (Level),a
        ld a,1
        jr StartGame
StartGame2p:
        ld a,2
StartGame:
        ld (NumPlayers),a
        xor a
        ld (RemotePlayers),a
        ld hl,sLinkGameSettings
        ld de,LinkGameSettings
        ld bc,EndLinkGameSettings-LinkGameSettings
        ldir
WoowoowooStartAlinkGame:
InitGame:
        ld hl,0
        ld (RoundsWon),hl
        ld (RoundsWon+2),hl

        ld a,(NumPlayers)
        ld hl,RemotePlayers
        add a,(hl)
        and 7Fh
        ld (TotalPlayers),a
        cp 1
        jr nz,NotSinglePlayerTeleport
        ld (Teleport),a
        ld a,3
        ld (Lives),a
        xor a
        ld (Score+2),a
        sbc hl,hl
        ld (Score),hl
;        ld hl,Player
;        ld (PlayerInfo+pAnimList),hl
;        jp NotCharacterSelect
NotSinglePlayerTeleport:

#if 0
        push af
        ld hl,128
        inc a
        call _divHLbyA
        ld a,l
        sub 4
        ld d,a
        ld e,l
        push de

        ld hl,ChooseMenu
        call DrawMenu

        ld ix,PlayerInfo
        pop bc
        pop af
InitChooseScreen:
        push af
        push bc
        push ix
        ld c,40
        ld hl,Player
        call InitSpriteBC
        pop ix
        ld (ix+4),6
        ld de,pInfoLen
        add ix,de
        pop bc
        ld a,b
        add a,c
        ld b,a
        pop af
        dec a
        jr nz,InitChooseScreen

        call InitPlayerKeys

DoChooseStuff:
        ld hl,Timer
        ld a,(hl)
        and 15
        jr nz,DoChooseStuff
        ld ix,PlayerInfo
        ld a,(TotalPlayers)
UpdateChooseCharacters:
        push af
;        call UnputAnimatedSprite

        bit 7,(ix+pLink)
        jr z,NotLinkPlayerChoose
BadRecvCh:
        ld a,K_EXIT
        call PollKey
        jr nc,ChooseFailed
        call ReceiveByte
        ld b,a
        jr GotChooseKeys
NotLinkPlayerChoose:
        ld a,(ix+pBombKey)
        call PollKey
        ld a,(ix+pLeftKey)
        call PollKey
        ld a,(ix+pRightKey)
        call PollKey
        ld a,(RemotePlayers)
        or a
        ld a,(LinkKeys)
        ld b,a
        jr z,GotChooseKeys
SendChError:
        ld a,K_EXIT
        call PollKey
        jr nc,ChooseFailed
        ld a,b
        call SendByte
        jr c,SendChError
GotChooseKeys:
        ld a,(ix+4)
        rr b
        jr c,NotChooseRight
        inc a
        cp 7
        jr nz,NotChooseRight
        xor a
NotChooseRight:
        rr b
        jr c,NotChooseLeft
        dec a
        cp -1
        jr nz,NotChooseLeft
        ld a,6
NotChooseLeft:
        rr b
;        jr nc,DoneChoose
        cp (ix+4)
        jr z,NotChangedCh
        ld (ix+4),a
        call GetEnemyAnimList
        ld (ix+pAnimList),l
        ld (ix+pAnimList+1),h
        ld (ix+pAnDir),1
        ld (ix+pAnim),0
NotChangedCh:
        call PutAnimatedSprite
        add ix,de
        pop af
        dec a
        jr nz,UpdateChooseCharacters
        jp UpdateChooseCharacters
ChooseFailed:
        pop af
        jp DoMainMenu
DoneChoose:
        pop af
NotCharacterSelect:
#endif

;        call ClearScreen

        ld a,58
StartRound:
        ld hl,0FC60h
        ld de,GreyBuffer+60h
DoBorder:
        ld (hl),7Fh
        ld bc,0FFFh
StoreTopLine:
        ldi
        ld (hl),255
        djnz StoreTopLine
        ld (hl),0F0h
        ldi
        dec a
        jr nz,DoBorder

        ld a,(Teleport)
        or a
        jr z,DontDrawTeleBar
        ld hl,GreyBuffer+01E0h
        ld b,10
        ld de,15
MooTeleBar:
        set 7,(hl)
        add hl,de
        set 3,(hl)
        inc hl
        djnz MooTeleBar
DontDrawTeleBar:

        ld hl,0FC00H
        ld de,0FC01h
        ld c,5Fh
        push hl
        ld (hl),b
        ldir
        pop hl
        ld c,60h
        ld de,GreyBuffer
        ldir

        ld hl,RoundsWon
        ld a,(TotalPlayers)
        dec a
        jr nz,DontPutOnePlayerStatusBar

        ld hl,LevelMsg
        ld b,91
        call PutText
        ld a,(Level)
        inc b
        inc b
        inc a
        call PutNumA
        ld hl,ScoreMsg
        ld b,36
        call PutText
        inc b
        inc b
        ld a,(Score+2)
        ld hl,(Score)
        rra
        rr h
        rr l
        rra
        rr h
        rr l
        call PutNumHL
        ld hl,Lives
DontPutOnePlayerStatusBar:
        ld b,2
        xor a

PutRoundsWon:
        push bc
        push af
        push bc
        push hl
        ld hl,68*18+BigSprites
        ld ix,BlankMask
        ld a,12
        call PutMaskedSpriteHL
        pop hl
        pop bc
        ld d,1
        ld a,b
        add a,8
        ld b,a
;        cp 2+6+8
;        jr z,NoRoundNum
        ld a,(hl)
        call PutDigit
;NoRoundNum:
        ld a,8Bh
        call PutChar
        ld a,'1'
        call PutChar
        ld a,(WinsNeeded)
        cp (hl)
        jr nz,NotWinner
        ld b,13
        ld hl,WinnerMsg
        call MessageBar
        pop af
        push hl
        inc a
        call PutDigit
        pop hl
        call PutText
        pop af
        call WaitForKey
        jp GameFinished
NotWinner:
        pop de
        pop bc
        inc hl
        ld a,b
        add a,31
        ld b,a
        inc d
        ld a,(TotalPlayers)
        cp d
        ld a,d
        jr nz,PutRoundsWon

        ld hl,(TimeLimit-1)
        xor a
        srl h
        rra
        srl h
        rra
        ld l,a
        ld (TimeSpeed),hl
        ld (TimeFrame),hl

WaitTillAllReleased:
        call GET_KEY
        or a
        jr nz,WaitTillAllReleased

        ld a,(RemotePlayers)
        or a
        jr z,OnePlayerOnly
        rla
        jr c,SendSeed
Uhoh:
        call ReceiveByte
        ld (Seed),a
        call nc,ReceiveByte
        ld (Seed+1),a
        jp c,DoMainMenu
        jr SeedSent
SendSeed:
        ld a,(Seed)
        call SendByte
        ld a,(Seed+1)
        call nc,SendByte
        jp c,DoMainMenu
OnePlayerOnly:
SeedSent:

        ld hl,Lists
        ld de,Lists+1
        ld bc,EndLists-Lists-1
        ld (hl),0       ;clears bombs & player lists
        ldir

BadScenario:
        call Random
        and 7
        cp 6
        jr nc,BadScenario
        ld b,a
        call GetEnemyAnimList
        ld a,b
        and 3
        ld b,a
        add a,a
        ld c,a
        add a,a
        add a,b
        add a,36-63
        ld (BlockAnim),a
        ld a,c
        inc a
        ld (BlockSprite),a
        inc a
        ld (PillarSprite),a
        ld (EnemyType),hl

        ld a,(BlockCvg)
        rrca
        rrca
        rrca
        cpl
        ld (BlockCover),a

        ld hl,0FC20h
        ld de,TopBorder
        ld bc,96
        ldir
        ld hl,GreyBuffer+20h
        ld c,96
        ldir

        ld a,(TotalPlayers)
        dec a
        call z,InitSinglePlayerLevel
        jr z,DoneInitSinglePlayer
	call InitGrid
        call InitEnemies
DoneInitSinglePlayer:
        call MoveEnemies

        ld a,1
        ld (ResetStats),a

        ld b,58
        ld hl,0FC6Fh
        ld (TimePos),hl
        ld de,16
DrawBar:
        ld a,(hl)
        or 3
        ld (hl),a
        add hl,de
        djnz DrawBar

NextLife:
        ld ix,PlayerInfo
        ld bc,ShieldInfo
        ld hl,StartingPoints
        ld a,(TotalPlayers)
InitPlayerSprites:
        ld d,(hl)
        inc hl
        ld e,(hl)
        inc hl
        push hl
        push af
        push ix
        push bc
        ld hl,Player
;        ld h,(ix+pAnimList+1)
;        ld l,(ix+pAnimList)
        call InitSprite
        pop bc
        pop ix
        pop af
        ld (ix+pShieldLeft),10
        ld hl,pOtherInfoLen
        add hl,bc
        ld b,h
        ld c,l
        pop hl
        ld de,pInfoLen
        add ix,de
        dec a
        jr nz,InitPlayerSprites

        ld (ResetStats),a       

        ld ix,ShieldInfo
        ld de,pOtherInfoLen
        ld b,4
SetupShieldInfo:
        ld (ix+pAnimList),Shield & 255
        ld (ix+pAnimList+1),Shield/256
        ld (ix+pDir),1
        ld (ix+pAnDir),1
        add ix,de
        djnz SetupShieldInfo     

        call InitPlayerKeys

        ld a,(TotalPlayers)
        dec a
        jr nz,NotSpecialPowers
        ld ix,PlayerInfo
        ld a,(Level)
        cp 5
        jr c,NotSpecialPowers
        ld (ix+pSpeed),4
        cp 10
        jr c,NotSpecialPowers
        set ppRemote,(ix+pPowerups)
NotSpecialPowers:

        ld b,22h
        ld hl,ReadyMsg
        call MessageBar

DelayAndStartGame:
        ld a,200
        call Delay

Unpaused:
        ld a,(Teleport)
        or a
        jr nz,DontEraseTeleBar
        ld hl,0FDE0h
        ld b,10
        ld de,15
EraseTeleBar:
        res 7,(hl)
        add hl,de
        res 3,(hl)
        inc hl
        djnz EraseTeleBar
DontEraseTeleBar:

        call RedrawGrid

;        set 2,(iy+12h)

        ld hl,Timer
        ld (hl),0
PlaydELAYLoop:
        halt
PlayLoop:
        ld hl,Timer
        ld a,(hl)
        sub 2
        jr c,PlaydELAYLoop
        ld (hl),a

        ld hl,(TimeFrame)
        dec hl
        ld a,h
        or l
        jr nz,NotNextTimeFrame
        ld de,16
        ld hl,(TimePos)
        ld a,(hl)
        and 0FCh
        ld (hl),a
        add hl,de
        ld (TimePos),hl
        ld hl,(TimeSpeed)
        jr nc,NotNextTimeFrame
        ld b,28h
        ld hl,TimeUpMsg
        call MessageBar
        ld a,200
        call Delay
        jp TimeRanOut
NotNextTimeFrame:
        ld (TimeFrame),hl

        ld hl,ProjectileFrame
        dec (hl)
        jr nz,NotNextProjectileFrame
        ld (hl),4
        ld ix,ProjectileInfo
        ld b,4
ProcessProjectiles:
        ld a,(ix)
        or a
        jr z,NoProjectile
        push bc
        push ix
        call InitMove
        call UnputAnimatedSprite
        call MoveInCurrentDir
        jr nz,NotKillProjectile
        ld (ix),a
        ld a,(ix+pSpr)
        cp 15
        jr nc,ProjectileKilled
        ld d,(ix+pBY)
        ld e,(ix+pBX)
        push de
        call GetBlockAddr
        ld b,(ix+pAnDir)
        call DoDropBomb
        pop de
        call FindBomb
        ld a,(ix+pAnim)
        ld (hl),a
        jr ProjectileKilled
NotKillProjectile:
        ld a,(ix+pMask)
        call GetSpriteAddr
        ld a,(ix+pSpr)
        ld b,(ix+pX)
        ld c,(ix+pY)
        push hl
        pop ix
        call PutMaskedSprite
ProjectileKilled:
        pop ix
        pop bc
NoProjectile:
        ld de,pOtherInfoLen
        add ix,de
        djnz ProcessProjectiles
NotNextProjectileFrame:

        ld hl,TransporterFrame
        dec (hl)
        jr nz,NotTransporterFrame
        ld (hl),12
        ld a,(Teleport)
        or a
        jr z,NoTeleporters
        inc hl
        dec (hl)
        jr nz,NotFirstTransporterFrame
        ld (hl),3
NotFirstTransporterFrame:
        ld a,(hl)
        add a,32
        ld ix,TransporterMask
        push af
        ld bc,32
        call PutMaskedSprite
        pop af
        ld ix,TransporterMask
        ld bc,122*256+32
        call PutMaskedSprite
NoTeleporters:

NotTransporterFrame:

        ld hl,BombFrame
        dec (hl)
        jp nz,NotBombFrame
        ld (hl),10

        ld a,(CONTRAST)
        ld b,a
        ld a,K_F4
        call PollKey
        jr c,NotContrastDown
        dec b
NotContrastDown:
        ld a,K_F5
        call PollKey
        jr c,NotContrastUp
        inc b
NotContrastUp:
        ld a,b
        cp 30
        jr nc,NoContrastChg
        ld (CONTRAST),a
        add a,2
        out (2),a
NoContrastChg:

        ld a,(DoorOpen)
        or a
        jr z,DontOpenDoor
        ld hl,DoorSprite
        ld a,(hl)
        cp 31
        jr z,DontOpenDoor
        inc (hl)
        ld hl,(DoorPos)
        ld h,0
        ld de,Grid
        add hl,de
        cp (hl)
        jr nz,DontOpenDoor
        inc (hl)
        sbc hl,de
        ld a,17
        call _divHLbyA
        ld d,l
        ld e,a
        call GetBlockCoords
        ld a,(DoorSprite)
        call PutSprite
DontOpenDoor:

DrawBombs:
        ld hl,BombList
        ld b,48
CheckBombFuses:
        ld e,(hl)
        inc hl
        ld d,(hl)
        inc hl
        ld a,(hl)
        or a
        jp z,NotActiveBomb
        push bc
        push hl
        inc hl
        ld a,(hl)
        dec hl
        bit 7,a
        jr nz,NotPlayersBomb
        and 060h
        push de
        ld e,a
        rrca
        rrca
        ld b,a
        add a,e
        ld e,a
        ld d,0
        srl b
        srl b
        srl b
        ld ix,PlayerInfo
        add ix,de
        pop de
        ld a,(hl)
        cp 7
        jr c,NotRemoteActive    ;remote can't pause exploding bombs :)
        ld a,(ix+pActiveItem)
        cp 2
        jr z,NotFinishedBomb
NotRemoteActive:
        dec (hl)
        jr nz,NotFinishedBomb
        inc (ix+pBombs)
        ld a,(ix+pActiveItem)
        cp 2
        ld a,(ix+pBombs)
        push de
        push hl
        call c,PutWeapStatus
        pop hl
        pop de
NotFinishedBomb:
        inc (hl)
NotPlayersBomb:
        dec (hl)
        push hl
        call GetBlockAddr
        pop hl
        cp LETHALSPRITES
        ld a,(hl)
        jr c,NotChainReaction
        cp 6
        jr c,NotChainReaction
        ld (hl),6
NotChainReaction:
        cp 6
        jr nc,NotExplodeBomb
        push af
        push hl
        ld hl,BlastRestrict
        ld (hl),36
        cp 5
        jr nz,NotNoBlastRestrict
        ld (hl),0
NotNoBlastRestrict:
        or a
        jr z,ClearBlast
        ld a,255
ClearBlast:
        ld (BlastFill),a
        pop hl
        pop af
        neg
        add a,68
        ld c,a
        add a,52-63
BlockAnim =$-1
        ld (WallSprite),a
        inc hl
        ld a,(hl)
        and 31
        ld b,a
        push bc
        call GetBlockCoords
        push bc
        call GetBlockAddr
        pop de
        pop bc
        ld a,-17
        ld ix,-6*256
        call Blast
        ld a,c
        add a,24
        ld c,a
        ld a,17
        ld ix,6*256
        call Blast
        ld a,c
        sub 12
        ld c,a
        ld a,-1
        ld ix,256-7 
        call Blast
        ld a,c
        add a,24
        ld c,a
        ld a,1
        ld ix,7
        call Blast
        ld a,c
        sub 43
        ld b,d
        ld c,e
        ld de,(BlastFill)
        inc e
        dec e
        jr nz,BombExploded
        ld a,(DoorPos)
#if (Grid & 255)>0
        add a,Grid & 255
#endif
        cp l
        ld a,e
        jr nz,BombExploded
        ld a,(DoorSprite)
        jr BombExploded
NotExplodeBomb:
        and 1
        add a,11
        inc hl
        bit 4,(hl)
        jr z,NotNukeSprite
        add a,2
NotNukeSprite:
        push af
        call GetBlockAddr
        pop bc
        cp LETHALSPRITES
        jr nc,DontDrawBombSprite
        ld a,b
        call GetBlockCoords       
BombExploded:
        ld (hl),a
        call PutSprite
DontDrawBombSprite:
        pop hl
        pop bc
NotActiveBomb:
        inc hl
        inc hl
        dec b
        jp nz,CheckBombFuses
DoneAllBombs:
NotBombFrame:

        ld a,255
        ld (MaxBlockCheck),a    ;allow man to walk into explosions :)

        ld ix,PlayerInfo
        xor a
UpdatePlayers:

        push af
        dec (ix+pPowerUpFrame)
        jr nz,NotPowerupFrame
        ld (ix+pPowerUpFrame),25
        ld a,(ix+pShieldLeft)
        or a
        jr z,DontDecShield
        dec (ix+pShieldLeft)
DontDecShield:
        ld a,(ix+pStunLeft)
        or a
        jr z,DontDecStun
        dec (ix+pStunLeft)
DontDecStun:
        ld a,(ix+pDizzyLeft)
        or a
        jr z,DontDecDizzy
        dec (ix+pDizzyLeft)
        call z,ReverseKeys
DontDecDizzy:
NotPowerupFrame:
        pop af

        dec (ix+pFrame)
        jp nz,NotPlayerFrame
        ld b,(ix+pSpeed)
        ld (ix+pFrame),b

        call InitMove
        push hl
        push de                 ;push old coords
        push af

        ld a,(ix+pSelectPause)
        or a
        jr z,NoDecSelectPause
        dec (ix+pSelectPause)
NoDecSelectPause:
        ld a,(ix+pFirePause)
        or a
        jr z,NoDecFirePause
        dec (ix+pFirePause)
NoDecFirePause:

        ld a,(ix+pAnim)
        cp 80h
        jp nc,DaGeezerIsDeeeed

        bit 7,(ix+pLink)
        jr z,NotLinkPlayer
OhShitOhFuckOhPants:
        ld a,K_EXIT
        call PollKey
        jp nc,ExitPressed
        call ReceiveByte        ;receive player's key states
        ld b,a
        xor 55h
        call SendByte
        call nc,ReceiveByte
        jr c,OhShitOhFuckOhPants
        inc a
        jr nz,OhShitOhFuckOhPants
        jr GotPlayerKeyStatesFromRemote

NotLinkPlayer:
        ld a,(ix+pBombKey)
        call PollKey
        ld a,(ix+pSelectKey)
        call PollKey
        ld a,(ix+pDownKey)
        call PollKey
        ld a,(ix+pLeftKey)
        call PollKey
        ld a,(ix+pRightKey)
        call PollKey
        ld a,(ix+pUpKey)
        call PollKey
        ld a,K_EXIT
        call PollKey
        ld a,K_F1
        call PollKey
        ld a,(RemotePlayers)
        or a
        ld a,(LinkKeys)
        ld b,a
        jr z,GotPlayerKeyStates
OhMyGiddyAunt:
        ld a,K_EXIT
        call PollKey
        jp nc,ExitPressed
        ld a,b
        call SendByte
        call nc,ReceiveByte
        jr c,OhMyGiddyAunt
        xor 55h
        cp b
        jr z,SentKeysOk
        xor a
        call SendByte
        jr OhMyGiddyAunt
SentKeysOk:
        ld a,-1
        call SendByte
GotPlayerKeyStates:
GotPlayerKeyStatesFromRemote:
        ld a,(ix+pStunLeft)
        or a
        ld a,b
        jr z,PlayerNotStunned
        and 11000011b
PlayerNotStunned:
        ld bc,-1
        rra
        jp nc,Paused
        rra
        jp nc,ExitPressed
        rra
        call nc,MoveUp
        rra
        call nc,MoveRight
        rra
        call nc,MoveLeft
        rra
        call nc,MoveDown
        pop hl
        push hl
        push bc
        ld b,h
        rra
        push af
        call nc,SelectWeap
        pop af
        rra
        call nc,FireWeap
        pop bc
        ld a,b
        inc a
        jr nz,DoCycle
        ld a,(ix+pPX)
        or (ix+pPY)
        jr nz,ManNotStopped
        ld a,c
        inc a
        jr z,NotEvenOneKeyPressed
        ld (ix+pDir),c
NotEvenOneKeyPressed:
        ld a,(ix+pDir)
        and 1
        inc a
        ld (ix+pAnim),a
        ld (ix+pAnDir),1
        jr DoneMoveMan
ManNotStopped:
        ld b,c
        push bc
        call MoveInCurrentDir
        ld a,b
        pop bc
        inc a
        jr nz,DoneMoveMan
        ld a,b
        inc a
        jr nz,DoneMoveMan
DoCycle:
        ld (ix+pDir),b
DoneMoveMan:

        pop bc
        push bc

        call InitMove
        ld a,h
        or l
        jr nz,NotDoorCheck
        push hl
        push bc
        call GetBlockAddr
        pop bc
        pop hl
        cp 31
        jp z,NextLevel
NotDoorCheck:

        call PlayerCheckBlock
        jr c,DontCheckNextPlayerBlock
        ld a,h
        or l
        jr z,DontCheckNextPlayerBlock
        inc d
        ld a,l
        or a
        jr z,NotCheckPlayerRight
        dec d
        inc e
NotCheckPlayerRight:
        call PlayerCheckBlock
DontCheckNextPlayerBlock:
        jr nc,NotKillPlayer
        ld a,(ix+pShieldLeft)
        or a
        call z,KillSprite
NotKillPlayer:
DaGeezerIsDeeeed:

        pop af
        pop de
        pop hl
        push af
        ld a,(ix+pAnim)
        cp 88h
        call c,UnputAnimatedSprite
        call PutAnimatedSprite

        call CheckIfZapped
        jr nc,PlayerNotZapped
        ld a,(ix+pDizzyLeft)
        or a
        jr z,NotStunPlayer
        ld a,(ix+pStunLeft)
        or a
        jr nz,PlayerNotZapped
        ld (ix+pStunLeft),8
        jr PlayerNotZapped
NotStunPlayer:
        ld (ix+pDizzyLeft),30
        call z,ReverseKeys
PlayerNotZapped:

        pop af

NotPlayerFrame:
        ld de,pInfoLen
        add ix,de
        inc a
        ld hl,TotalPlayers
        cp (hl)
        jp nz,UpdatePlayers

        call MoveEnemies

        ld ix,PlayerInfo
        ld de,pInfoLen
        ld a,(TotalPlayers)
        ld c,a
        ld b,a
CountPlayers:
        ld a,(ix+pAnim)
        cp 0A0h
        jr c,PlayerNotDead
        dec c
PlayerNotDead:
        add ix,de
        djnz CountPlayers

        ld a,(TotalPlayers)
        ld b,a
        dec a
        jr nz,NotOnePlayerDeathCheck
        dec c
        jr z,DoneDeathCheck
        ld hl,Lives
        dec (hl)
        ld bc,(10-31) & 255
        ld a,(hl)
        call PutStatusDigit
        ld a,(Lives)
        or a
        jp nz,NextLife
        ld hl,GameOverMsg
        ld b,22h
        call MessageBar
        ld a,200
        call Delay
        call Delay
        jp GameFinished

NotOnePlayerDeathCheck:
        dec c
AllDead:
        jp z,RoundOver
        inc c
        jr z,AllDead
DoneDeathCheck:

        ld hl,PlayerInfo
CheckPlayersForEnemyCollision:
        push bc
        ld bc,pShieldLeft
        add hl,bc
        ld a,(hl)
        sbc hl,bc
        or a
        jr nz,PlayerIsShielded
        ld bc,(NumMonsters-1)
        ld ix,EnemyInfo
CheckEnemiesForPlayerCollision:
        ld a,(ix+pAnim)
        cp 080h
        jr nc,NoEnemyToCollide
        ld a,(ix+pY)
        sub (hl)
        jr nc,NotNegYCheck
        neg
NotNegYCheck:
        cp 6
        jr nc,EnemyHasNotHitPlayer
        ld a,(ix+pX)
        inc hl
        sub (hl)
        jr nc,NotNegXCheck
        neg
NotNegXCheck:
        dec hl
        cp 7
        jr nc,EnemyHasNotHitPlayer
        ld de,pAnim
        add hl,de
        ld a,7Fh
        cp (hl)
        jr c,PlayerAlreadyDead
        ld (hl),80h
        inc hl
        ld (hl),1
        ld e,pFrame-pAnDir
        add hl,de
        ld (hl),25
        ld e,pAnDir
PlayerAlreadyDead:
        or a
        sbc hl,de
EnemyHasNotHitPlayer:
NoEnemyToCollide:
        ld de,pEnemyInfoLen
        add ix,de
        djnz CheckEnemiesForPlayerCollision
PlayerIsShielded:
        pop bc
        ld de,pInfoLen
        add hl,de
        djnz CheckPlayersForEnemyCollision
        jp PlayLoop

ExitPressed:
        pop hl
        pop hl
        pop hl
GameFinished:
;        res 2,(iy+12h)
        call ClearScreen
        halt
        halt
        call GET_KEY

        ld a,(TotalPlayers)
        dec a
        jr nz,NotHiScore

        ld a,(Score+2)
        ld hl,(Score)
        rra
        rr h
        rr l
        rra
        rr h
        rr l
        ld (Score),hl

        ld hl,HiScores+14
        ld b,5
CheckHiscores:
        push hl
        call LD_HL_MHL
        ld de,(Score)
        call CP_HL_DE
        pop hl
        jr c,NewHiScore
        ld de,16
        add hl,de
        djnz CheckHiscores
NotHiScore:
        jp DoMainMenu

NewHiScore:
        push hl
        push de
        ld a,b
        dec a
        jr z,DontMoveScores
        ld hl,HiScores+63
        ld de,HiScores+79
MoveScores:
        ld bc,16
        lddr
        dec a
        jr nz,MoveScores
DontMoveScores:
        pop de
        pop hl
        ld (hl),e
        inc hl
        ld (hl),d
        ld de,-15
        add hl,de
        push hl
        call InitMenuScreen

        ld hl,NewHiMsg
        call DrawMenu

        ld hl,EnterNameMsg
        ld bc,081Dh
        call PutText

        ld bc,1029h

NameInputLoop:
        push bc
NameInputWait:
        pop bc
        push bc
        ld a,(Timer)
        rlca
        rlca
        rlca
        and 1
        add a,11
        call PutSprite

        call WaitMenuKey
        jr c,NameInputWait
        pop bc
        push bc
        push af
        xor a
        call PutSprite
        pop af

        ld bc,26
        ld hl,AlphaKeys
        cpir
        jr nz,NoAlphaKey
        ld a,90
        sub c
        jr GotKey
NoAlphaKey:
        cp K_SIGN
        ld b,' '
        jr z,GotKeyB
        cp K_STO
        ld b,'<'
        jr z,GotKeyB
        cp K_ENTER
        jr z,NameEntered
        cp K_DEL
        jr nz,NameInputWait
        pop bc
        pop hl
        ld a,b
        cp 17
        jr c,NoDelete
        sub 6
        ld b,a
        dec hl
        ld (hl),'<'
NoDelete:
        push hl
        push bc
        xor a
        call PutSprite
        jr NameInputWait
GotKeyB:
        ld a,b
GotKey:
        pop bc
        ld e,a
        ld a,b
        cp 16+(13*6)
        jr z,NameInputLoop
        pop hl
        ld (hl),e
        inc hl
        push hl
        ld a,e
        ld d,1
        call PutChar
        jr NameInputLoop

NameEntered:
        pop bc
        pop hl
        ld a,b
PadName:
        cp 16+(13*6)
        jp nc,ShowHiScores
        ld (hl),'<'
        inc hl
        add a,6
        jr PadName

InitMenuScreen:
        call ClearScreen
        ld de,0FC02h
        call PutLogo
        ld a,1
        ld (ResetStats),a

BadRandBad:
        call Random
        and 7
        jr z,BadRandBad
        dec a
        call GetEnemyAnimList
        inc hl
        ld ix,PlayerInfo
        ld bc,7403h
        ld de,0
        call InitSpriteBC
BadRandBad2:
        call Random
        and 7
        jr z,BadRandBad2
        dec a
        call GetEnemyAnimList
        inc hl
        ld ix,PlayerInfo+pInfoLen
        ld bc,0403h
        ld de,0
        jp InitSpriteBC

Exit:
        call ClearScreen
	call DeinitGrey
        ld a,(CONTRAST)
        out (2),a
	call _homeup
        call _clrScrn
        jp SaveSettings

Paused:
        pop hl
        pop hl
        pop hl
;        res 2,(iy+12h)
        ld b,46
        ld hl,PauseMsg
        call MessageBar
WaitPauseRelease:
        ld a,K_F1
        call PollKey
        jr nc,WaitPauseRelease
        call GET_KEY
WaitUnpause:
        
        call TryReceiveByte
        jr nc,HasUnpaused
        call GET_KEY
        or a
        jr z,WaitUnpause
WaitReleaseUnpause:
        ld b,a
        call PollKey
        ld a,b
        jr nc,WaitReleaseUnpause
        ld a,(RemotePlayers)
        or a
        ld a,55h        
        call nz,SendByte
HasUnpaused:
        jp Unpaused

RoundOver:
        ld a,(TotalPlayers)
        ld b,a
        ld hl,PlayerInfo+pAnim
        ld ix,RoundsWon
        ld de,pInfoLen
FindWinner:
        rl (hl)
        jr c,ThisPlayerIsSixFootUnder
        inc (ix)
ThisPlayerIsSixFootUnder:
        inc ix
        add hl,de
        djnz FindWinner
TimeRanOut:
;        res 2,(iy+12h)
        ld a,2
        jp StartRound

NextLevel:
        pop af
        pop de
        pop hl

        ld hl,BonusMsg
        ld b,25h
        call MessageBar

        ld hl,0
        ld de,303h
        push bc
        call PutNumHL_C
        pop bc
        ld de,(TimePos)
AddBonus:
        push bc
        push de
        ld de,303h
        push bc
        push de
        push hl
        call PutNumHL_C
        ld hl,20
        call AddScore

        pop hl
        ld de,5
        add hl,de
        pop de
        pop bc
        push hl
        call PutNumHL_C
        ld a,4
        call Delay
        pop hl
        ex (sp),hl
        ld a,(hl)
        and 0FCh
        ld (hl),a
        ld de,16
        add hl,de
        ex de,hl
        pop hl
        pop bc
        jr nc,AddBonus

        ld a,200
        call Delay

        ld ix,PlayerInfo
        call UnputAnimatedSprite

        ld hl,Level
        inc (hl)
        ld a,(MaxLevel)
        cp 9
        jr z,NotNewMaxLevel
        dec a
        cp (hl)
        jr nc,NotNewMaxLevel
        ld a,(hl)
        inc a
        ld (MaxLevel),a
NotNewMaxLevel:
        ld a,(hl)
        cp NUMLEVELS
        jr nz,TimeRanOut

;        res 2,(iy+12h)
        halt
        halt
        call GET_KEY

        call InitMenuScreen
        ld hl,CompletedText
        ld a,1
        call DoDrawHelp
WaitCompleted:
        call WaitMenuKey
        jr c,WaitCompleted
        jp GameFinished

PollKey:
        push bc
        dec a
        ld b,a
        srl b
        srl b
        srl b
        and 7
        ld c,a
        ld a,0FFh
        out (1),a
        inc b
        ld a,07Fh
GetKeyMask:
        rlca
        djnz GetKeyMask
        out (1),a
        in a,(1)
        ld b,c
        inc b
GetKeyBit:
        rra
        djnz GetKeyBit
        push af
        ld hl,LinkKeys
        rl (hl)
        pop af
        pop bc
        ret

PlayerCheckBlock:
        ld a,e
        cp 17
        ret nc
        push hl
        push de
        push bc
        call GetBlockAddr
        pop bc
        push bc
        and 127
        cp 32
        jr nz,NotSlipped
        ld (ix+pStunLeft),4
        ld (hl),0
        jp DonePlayerCheck
NotSlipped:
        cp 15
        jp c,NotGotPowerup
        cp 28
        jp nc,NotGotPowerup
        ld (hl),0
        sub 15
        jr nz,NotTimePowerup
        ld c,10
        call IncTime
        jp DonePlayerCheck
NotTimePowerup:
        dec a
        jr nz,NotRemotePowerup
        set ppRemote,(ix+pPowerups)
NotRemotePowerup:
        dec a
        jr nz,NotBombPowerup
        ld a,(ix+pMaxBombs)
        cp 8
        jp z,DonePlayerCheck
        inc (ix+pMaxBombs)
        inc (ix+pBombs)
        ld a,(ix+pActiveItem)
        cp 2
        ld a,(ix+pBombs)
        call c,PutWeapStatus
        jp DonePlayerCheck
NotBombPowerup:
        dec a
        jr nz,NotRangePowerup
        ld a,(ix+pRange)
        and 15
        cp 8
        jp z,DonePlayerCheck
        inc (ix+pRange)
        jp DonePlayerCheck
NotRangePowerup:
        dec a
        jr nz,NotBootPowerup
        set ppBoot,(ix+pPowerups)
NotBootPowerup:
        dec a
        jr nz,NotNukePowerup
        set ppNuke,(ix+pPowerups)
NotNukePowerup:
        dec a
        jr nz,NotGrabberPowerup
        set ppGrabber,(ix+pPowerups)
NotGrabberPowerup:
        dec a
        jr nz,NotZapperPowerup
        ld (ix+pZapsLeft),8
NotZapperPowerup:
        dec a
        jr nz,NotShieldPowerup
        ld (ix+pShieldLeft),50
NotShieldPowerup:
        dec a
        jr nz,NotShovelPowerup
        ld a,(ix+pShovelLeft)
        add a,3
        cp 8
        jr c,NotTooManyShovels
        ld a,8
NotTooManyShovels:
        ld (ix+pShovelLeft),a
        jr DonePlayerCheck
NotShovelPowerup:
        dec a
        jr nz,NotSpeedup
        ld (ix+pSpeed),4
NotSpeedup:
        dec a
        jr nz,NotFlamerPowerup
        ld (ix+pFlameLeft),64
NotFlamerPowerup:
        dec a
        jr nz,NotPowerdown
       
;        rnd bombs, rev keys, stun, shield
        call Random
        and 3
        jr nz,NotRandomBombs
        ld b,4
PlaceRandomBombs:
        push bc
FindRandomBombCoords:
        call RandomCoords
        call GetBlockAddr
        or a
        jr nz,FindRandomBombCoords
        ld b,81h        ;range + owner (bit 7 = no owner)
        call DoDropBomb
        pop bc
        djnz PlaceRandomBombs
        jr DonePlayerCheck
NotRandomBombs:

        dec a
        jr nz,NotRevKeys
        ld a,(ix+pDizzyLeft)
        ld (ix+pDizzyLeft),30
        or a
        call z,ReverseKeys
        jr DonePlayerCheck
NotRevKeys:
        dec a
        jr nz,NotStun
        ld (ix+pStunLeft),8
        jr DonePlayerCheck
NotStun:
        ld (ix+pShieldLeft),25

NotPowerdown:
        jr DonePlayerCheck
NotGotPowerup:
        cp LETHALSPRITES
        ccf
        ld a,123
        .org $-1
DonePlayerCheck:
        or a
        pop bc
        pop de
        pop hl
        ret

SelectWeap:
        ld a,(ix+pSelectPause)
        or a
        ret nz
        ld (ix+pSelectPause),KEYDELAY
WeaponExpired:
        push bc
DoSelectWeap:
        ld a,(ix+pActiveItem)
        inc a
        ld (ix+pActiveItem),a
        ld b,a
        ld c,(ix+pPowerups)
        ld d,(ix+pBombs)
        ld a,11
        jr z,GotWeapon
        djnz NotSelectNuke
        ld a,13
        bit ppNuke,c
        jr nz,GotWeapon
NotSelectNuke:
        ld d,-16
        djnz NotRemote
        bit ppRemote,c
        ld a,16
        jr nz,GotWeapon
NotRemote:
        djnz NotGrabber
        ld a,21
        bit ppGrabber,c
        jr nz,GotWeapon
NotGrabber:
        djnz NotBoot
        ld a,19
        bit ppBoot,c
        jr nz,GotWeapon
NotBoot:
;        djnz NotJCB
;        ld a,15
;        bit ppJCB,c
;        jr nz,GotWeapon
;NotJCB:
        dec b
        djnz NotShovel
        ld a,(ix+pShovelLeft)
        ld d,a
        or a
        ld a,24       
        jr nz,GotWeapon
NotShovel:
        djnz NotZapper
        ld a,(ix+pZapsLeft)
        ld d,a
        or a
        ld a,22
        jr nz,GotWeapon
NotZapper:
        djnz NotFlamer
        ld a,(ix+pFlameLeft)
        ld d,a
        srl d
        srl d
        srl d
        or a
        ld a,26
        jr nz,GotWeapon
NotFlamer:
        djnz DoSelectWeap
        ld (ix+pActiveItem),-1
        jr DoSelectWeap
GotWeapon:
        pop bc
        ld c,16-31
        set 7,a
        push de
        call PutStatusChar
        pop af
PutWeapStatus:
        ld c,23-31
PutStatusDigit:
        add a,'0'
PutStatusChar:
        push bc
        push af
        ld a,c
        inc b
FindWeaponPos:
        add a,31
        djnz FindWeaponPos
        ld c,b
        ld b,a
        push bc
        ld c,2
        call FindPixel
        ld a,e
        and 15
        add a,TopBorder & 255
        ld l,a
        ld h,TopBorder/256
        jr nc,NotIncTopd
        inc h
NotIncTopd:
        pop bc
        pop af
        push ix
        push hl
        push de
        push bc
        push af
        call CopyBorderBytes
        pop af
        pop bc
        push af
        push bc
        xor a
        call PutSprite
        pop bc
        pop af
        ld d,1
        call PutChar
        pop hl
        pop de
        call CopyBorderBytes
        pop ix
        pop bc
        ret

ReverseKeys:
        push ix
        pop hl
        ld de,pLeftKey
        add hl,de
        call Swap2Keys
        call Swap2Keys
Swap2Keys:
        ld a,(hl)
        inc hl
        ld b,(hl)
        ld (hl),a
        dec hl
        ld (hl),b
        inc hl
        inc hl
        ret

InitPlayerKeys:
        ld hl,PlayerInfo+pLeftKey
        ld bc,pInfoLen
        ld a,(RemotePlayers)
        or a
        jr z,NotSkipRemote
        jp m,NotSkipRemote
SkipRemote:
        add hl,bc
        dec a
        jr nz,SkipRemote
NotSkipRemote:
        ex de,hl
        ld hl,Player1Keys
        ld bc,6
        ldir
        ld a,(NumPlayers)
        dec a
        ret z
        ex de,hl
        ld c,pInfoLen-6
        add hl,bc
        ex de,hl
        ld bc,6
        ldir
        ret


IncTime:
        ld hl,(TimePos)
        ld de,0FC6Fh
        call CP_HL_DE
        ret z
        ld de,-16
        add hl,de
        ld a,(hl)
        or 3
        ld (hl),a
        ld (TimePos),hl
        dec c
        jr nz,IncTime
        ret

CopyBorderBytes:
        ld a,4
CopyBorderByteRow:
        push af
        push hl
        push de
        ld a,2
DoCopyBorderBytes:
        ldi
        push af
        ld a,l
        and 15
        jr z,NotNextTopB
        ld a,(hl)
        ld (de),a
NotNextTopB:
        ld a,h
        cp 0FCh
        jr c,Moo
        ex de,hl
Moo:
        ld bc,95
        add hl,bc
        ld d,GreyBuffer/256
        dec e
        cp 0FCH
        jr c,Moo2
        ex de,hl
Moo2:
        pop af
        dec a
        jr nz,DoCopyBorderBytes
        pop hl
        ld de,16
        add hl,de
        ex (sp),hl
        add hl,de
        pop de
        pop af
        dec a
        jr nz,CopyBorderByteRow
        ret

FireWeap:
        ld a,(ix+pFirePause)
        or a
        ret nz
        ld a,(ix+pActiveItem)
        sub 2
        jr nc,NotDropBomb
        push bc
        call DropBomb
        pop bc
        ld a,(ix+pBombs)
        jp PutWeapStatus
NotDropBomb:
        jr nz,NotUseRemote
        ld hl,BombList
        ld c,48
        ld d,-1
FindShortestFuse:
        inc hl
        inc hl
        ld a,(hl)
        cp 7
        jr c,BombAlreadyDetonated
        cp d
        jr nc,NotShorterFuse
        ld e,a
        inc hl
        ld a,(hl)
        dec hl
        rlca
        rlca
        rlca
        and 7
        cp b
        jr nz,NotMyBomb
        ld d,a
        ld (BestBomb),hl
NotMyBomb:
NotShorterFuse:
BombAlreadyDetonated:
        inc hl
        inc hl
        dec c
        jr nz,FindShortestFuse
        inc d
        ret z
        ld a,6
        ld (1234h),a
BestBomb =$-2
NotUseRemote:
        dec a
        jr nz,NotUseGrabber
        call UsePickupWeapon
        ret nc
        cp 11
        ret c
        cp 15
        ret nc
        ld (hl),0
        call FindBomb
        ld (hl),0
        inc hl
        call LocateBombOwner
        jr nz,DoStealBomb
        ld a,(StealBombs)
        or a
        jr z,DontStealIt
        dec (hl)
DoStealBomb:
        ld a,(ix+pMaxBombs)
        cp 8
        jr z,DoneSteal
        inc (ix+pMaxBombs)
        inc (ix+pBombs)
        jr DoneSteal
DontStealIt:
        inc hl
        inc (hl)
        ld a,(hl)
        call PutWeapStatus
DoneSteal:

        call GetBlockCoords
        xor a
        push ix
        call PutSprite
        pop ix
        ld (ix+pFirePause),KEYDELAY
        ret
NotUseGrabber:
        dec a
        jr nz,NotUseBoot
        call UsePickupWeapon
        ret nc
        cp 11
        ret c
        cp 15
        ret nc
        push hl
        push de
        call GetProjectileInfo
        pop de
        pop bc
        ret nz
        ld a,(bc)
        push af
        xor a
        ld (bc),a
        call GetBlockCoords
        ld (hl),c
        inc hl
        ld (hl),b
        inc hl
        ld (hl),0
        inc hl
        ld (hl),0
        inc hl
        ld (hl),e
        inc hl
        ld (hl),d
        inc hl
        ld a,(ix+pDir)
        ld (hl),a
        inc hl
        push hl
        call FindBomb
        pop de
        ld a,(hl)
        ld (de),a
        ld (hl),0
        inc hl
        inc de
        ld a,(hl)
        ld (de),a
        inc de
        inc de
        inc de
        pop af
        bit 0,a
        jr nz,NotWrongBombAnim
        dec a
NotWrongBombAnim:
        ld (de),a
        inc de
        ld a,84
        ld (de),a
        ret
NotUseBoot:
        dec a
;        jr nz,NotUseJCB
;NotUseJCB:
        dec a
        jr nz,NotUseShovel
        call UsePickupWeapon
        ret nc
        dec a
        cp 10
        ret nc
        and 1
        ret nz
        ld (hl),0
        ld a,(DoorPos)
#if (Grid & 255)>0
        add a,Grid & 255
#endif
        cp l
        jr nz,NotDoorShovel
        ld a,(DoorSprite)
        ld (hl),a
NotDoorShovel:
        push de
        dec (ix+pShovelLeft)
        ld a,(ix+pShovelLeft)
        push af
        call PutWeapStatus
        pop af
        call z,WeaponExpired
        pop de
        jp DoneSteal
NotUseShovel:
        dec a
        jr nz,NotUseZapper
        call ZippyZappyZiggyZaggyZoo
        ret nc
        or a
        ret nz
        call GetProjectileInfo
        ret nz
        push ix
        push bc
        push hl
        call SetProjectileInfo
        ld a,61
        rr d
        jr nc,NotZapperFlipped
        ld a,73
NotZapperFlipped:
        rr d
        jr nc,NotZapperLR
        add a,24
NotZapperLR:
        inc hl
        inc hl
        inc hl
        inc hl
        inc hl
        ld (hl),a
        inc hl
        inc a
        ld (hl),a
        pop ix
        call MoveInCurrentDir
        call nz,MoveInCurrentDir
        call nz,MoveInCurrentDir
        pop bc
        jr nz,ZapFiredOk
        ld (ix),a
        pop ix
        ret
ZapFiredOk:
        pop ix
;        dec (ix+pZapsLeft)
        ld a,(ix+pZapsLeft)
        push af
        call PutWeapStatus
        pop af
        call z,WeaponExpired
        
        ld (ix+pFirePause),KEYDELAY
NotUseZapper:
        ret

LocateBombOwner:
        bit 7,(hl)
        ret nz
        ld a,(hl)
        and 060h
        ld c,a
        rrca
        rrca
        add a,c
        ld c,a
        ld b,0
        ld hl,PlayerInfo+pMaxBombs
        add hl,bc
        ld a,(hl)
        rlca
        rlca
        rlca
        and 3
        ld b,a
        cp a
        ret

SetProjectileInfo:
        ld d,(ix+pDir)
        ld bc,603h
DoSetProjectileInfo:
        ld a,(ix)
        add a,c
        ld c,0
        ld (hl),a
        inc ix
        inc hl
        djnz DoSetProjectileInfo
        ld (hl),d
        ret

GetProjectileInfo:
        push de
        ld hl,ProjectileInfo-pOtherInfoLen
        ld de,pOtherInfoLen
        inc b
FindProjectileInfo:
        add hl,de
        djnz FindProjectileInfo
        pop de
        ld a,(hl)
        or a
        ret

CheckIfZapped:
        ld hl,ProjectileInfo
        ld b,4
CheckProjectiles:
        ld a,(hl)
        or a
        jr z,NoProjectileToCheck
        push hl
        ld de,pDir
        add hl,de
        ld a,(hl)
        pop hl
        push hl
        rra
        ld c,a
        jr nc,CheckVerticalZap
        ld a,(ix+pY)
        sub (hl)
        add a,4
        cp 8
        jr nc,ProjectileChecked
        inc hl
        ld a,(ix+pX)
        sub (hl)
        sub 4
        rr c
        jr nc,NotZappingLeft
        add a,4+7
NotZappingLeft:
        cp 4
        jr nc,ProjectileChecked
ProjectileHit:
        ex (sp),ix
        call InitMove
        call UnputAnimatedSprite
        ld (ix),0
        pop ix
        scf
        ret
CheckVerticalZap:
        ld a,(ix+pY)
        sub (hl)
        sub 3
        rr c
        jr c,NotZappingUp
        add a,3+6
NotZappingUp:
        cp 4
        jr nc,ProjectileChecked
        inc hl
        ld a,(ix+pX)
        sub (hl)
        add a,4
        cp 8
        jr c,ProjectileHit
ProjectileChecked:
        pop hl
NoProjectileToCheck:
        ld de,pOtherInfoLen
        add hl,de
        djnz CheckProjectiles
        ret

DropBomb:
        ld a,(ix+pBombs)
        or a
        ret z
        call InitMove
        ld a,l
        cp 4
        jr c,NotIncBXDrop
        inc e
NotIncBXDrop:
        ld a,h
        cp 3
        jr c,NotIncBYDrop
        inc d
NotIncBYDrop:
        push bc
        call GetBlockAddr
        pop bc
        cp 11
        jr c,NotAlreadyBomb
        cp 15
        ret c
NotAlreadyBomb:
        dec (ix+pBombs)
        ld a,(ix+pActiveItem)
        dec a
        ld a,(ix+pRange)
        jr nz,NotNukeRange
        set 4,a
NotNukeRange:
        add a,2
        ld c,a
        ld a,b
        rrca
        rrca
        rrca
        or c
        ld b,a
        ld (ix+pFirePause),KEYDELAY
DoDropBomb:
        push hl
        ld hl,NextBomb
        ld a,(hl)
        inc a
        cp 48
        jr nz,NotBombZero
        xor a
NotBombZero:
        ld (hl),a
        add a,a
        add a,a
        push bc
        ld c,a
        ld b,0
        inc hl
        add hl,bc
        ld (hl),e
        inc hl
        ld (hl),d
        inc hl
        ld (hl),30              ;fuse - explodes at 6
        inc hl
        pop af
        ld (hl),a               ;bomb flags (range, nuke & player num)
        pop hl
        bit 4,a
        ld a,11
        jr z,NotInitNukeSprite
        add a,2
NotInitNukeSprite:
        ld (hl),a
        call GetBlockCoords
        push ix
        call PutSprite
        pop ix
        ret

UsePickupWeapon:
        ld a,(ix+pPX)
        or (ix+pPY)
        ret nz
ZippyZappyZiggyZaggyZoo:
        ld d,(ix+pBY)
        ld e,(ix+pBX)
        push bc
        ld b,(ix+pDir)
        inc b
        djnz NotPickupUp
        dec d
NotPickupUp:
        djnz NotPickupRight
        inc e
NotPickupRight:
        djnz NotPickupDown
        inc d
NotPickupDown:
        djnz NotPickupLeft
        dec e
NotPickupLeft:
        pop bc
        ld a,e
        cp 17
        ret nc
        ld a,d
        cp 9
        ret nc
        push bc
        call GetBlockAddr
        pop bc
        and 127
        scf
        ret

InitGrid:
	ld hl,Grid
	ld c,9
PutPillarsY:
	ld b,17
PutPillarsX:
	ld a,b
        or c
        rra                     
        ld a,8
PillarSprite =$-1
        jr nc,GotPillar         ;A=2 (pillar) if B and C are both even
        push hl
        push bc
        call Random             ;make a random number in A from 0-255
        pop bc
        pop hl
        cp 64
BlockCover =$-1
        ld a,7
BlockSprite =$-1
        jr nc,GotPillar
        xor a                   ;Create an explodable block when num>64
GotPillar:
	ld (hl),a
	inc hl
	djnz PutPillarsX
	dec c
	jr nz,PutPillarsY
        ld hl,0
        xor a
        ld (Grid),hl
        ld (Grid+17),a
        ld (Grid+15),hl
        ld (Grid+33),a
        ld (Grid+119),a
        ld (Grid+135),a
        ld (Grid+136),hl
        ld (Grid+151),hl        ;Clears corners of grid

        ld a,(Teleport)
        or a
        jr z,DontClearTeleportEntrances
        xor a
        ld (Grid+68),a
        ld (Grid+84),a          ;Clear teleporter entrances
DontClearTeleportEntrances:

        ld hl,PowerupLimits
        ld de,Powerups
        ld bc,13
        ldir
        xor a
        ld (Timer),a
        ld b,(hl)
        ld a,(TotalPlayers)
        ld c,a
        dec a
        jr z,PlaceRandomPowerups
        inc b
PlaceRandomPowerups:
        ld a,(Timer)
        cp 20
        jr nc,RedrawGrid
        push bc
        call Random
        pop bc
        cp 153
        jr nc,PlaceRandomPowerups
        ld e,a
        ld d,0
        ld hl,Grid
        add hl,de
        bit 7,(hl)
        jr nz,PlaceRandomPowerups
        ld a,(hl)       
        dec a
        cp 8
        jr nc,PlaceRandomPowerups
        and 1
        jr nz,PlaceRandomPowerups
        set 7,(hl)
        djnz PlaceRandomPowerups
        xor a
        ld (DoorOpen),a
        ld a,28
        ld (DoorSprite),a
        ld a,(Grid-1) & 255
        dec c
        jr nz,NoDoor
        ld a,l
#if (Grid & 255)>0
        sub Grid & 255
#endif
NoDoor:
        ld (DoorPos),a

RedrawGrid:
        ld hl,Grid
        ld c,8
        ld d,9
PutGridY:
        ld b,3
        ld e,17
PutGridX:
        push bc
        push de
        push hl
        ld a,(hl)
        and 127
        call PutSprite
        pop hl
        pop de
        pop bc
        inc hl
        ld a,b
        add a,7
        ld b,a
        dec e
        jr nz,PutGridX
        ld a,c
        add a,6
        ld c,a
        dec d
        jr nz,PutGridY       
        ret

; a spiffingly excellent random number generator:

Random:
        ld hl,0
        ld de,12345
Seed =$-2
        ld a,7921 & 255
        ld bc,1000h+(7921/256)
domult16:
	add hl,hl
	rla
        rl c
	jr nc,noadd16
	add hl,de
noadd16:
	djnz domult16
        inc hl
        ld (Seed),hl ;seed=(seed*7921+1) MOD 65536
        ld a,h
        ret

FlipSprites:
        ld hl,StartFlipped+10
        ld de,ReversedSprites
        ld b,12 ;12 sprites (2 layers each)
DoFlipSprites:
        push bc
        ld b,6
FlipBytes:
        ld a,(hl)
        ld (de),a
        inc hl
        inc de
        ld a,(hl)
        ld (de),a
        inc de
        dec hl
        dec hl
        dec hl
        djnz FlipBytes
        ld bc,24
        add hl,bc
        pop bc
        djnz DoFlipSprites
        ld hl,StartFlipped+144
        ld bc,EndFlipped-StartFlipped-144
        ex de,hl
MirrorBytes:
        ld a,(de)
        rrca
        push bc
        ld b,8
MirrorByte:
        rla
        rr (hl)
        djnz MirrorByte
        pop bc
        inc hl
        inc de
        dec bc
        ld a,b
        or c
        jr nz,MirrorBytes
        ret

FindPixel:
	ld d,0
	ld a,c
	add a,a
	add a,a
	rl d
	add a,a
	rl d
	add a,a
	rl d
	ld e,b
	srl e
	srl e
	srl e
	or e
	ld e,a
	ld a,b
	and 7
	inc a
	ld b,a
	dec d
	dec d
	dec d
	dec d
	ret

GetBlockCoords:
        push af
        ld a,d
        add a,a
        add a,d
        add a,a
        add a,8
        ld c,a
        ld a,e
        add a,a
        add a,a
        add a,a
        sub e
        add a,3
        ld b,a
        pop af
        ret

KillSprite:
        ld (ix+pAnim),7Fh
        ld (ix+pAnDir),1
        ld (ix+pFrame),60
        ret

InitMove:
        ld e,(ix+pBX)
        ld d,(ix+pBY)
        ld l,(ix+pPX)
        ld h,(ix+pPY)
        ret

MoveDown:
;        call DoMoveDown
;DoMoveDown:
        ld c,2

        call InitMove
        dec l
        inc l
        ret nz
        push af
        dec h
        inc h
        jr nz,GotDown
        ld a,d
        cp 8
        jr z,NotDown
        inc d
        call CheckBlock
        jr c,NotDown
GotDown:
        ld b,c
        inc (ix+pPY)
        inc (ix+pY)
        ld a,h
        cp 5
        jr nz,NotDown
        ld (ix+pPY),0
        inc (ix+pBY)
NotDown:
        pop af
        ret

CheckBlock:
        ld a,e
        cp 17
        jr c,NotTransportCheck
        ld a,d
        cp 4
        scf
        ret nz
        ld a,e
        sub 17
        jr z,DoTransportCheck
        ld a,16
DoTransportCheck:
        ld e,a
NotTransportCheck:
        push hl
        push bc
        call GetBlockAddr
        pop bc
        pop hl
        and 127       
        dec a
        cp 14
        ret c
        cp LETHALSPRITES
        jr nc,NotExplodingBlock
        cp 33
        ccf
        ret c
NotExplodingBlock:
        inc a
        cp 255
MaxBlockCheck =$-1
        ccf
        ret

MoveInCurrentDir:
        ld a,(ix+pDir)
MoveInDirA:
        ld b,-1
        or a
        call z,MoveUp
        dec a
        call z,MoveRight
        dec a
        call z,MoveDown
        dec a
        call z,MoveLeft
        ld a,b
        inc a
        ret

MoveLeft:
;        call DoMoveLeft
;        dec l
;        inc l
;        ret z
;DoMoveLeft:
        ld c,3

        call InitMove
        dec h
        inc h
        ret nz
        push af
        dec l
        inc l
        jr nz,GotLeft
        ld a,e
        or a
        jr nz,NotAtLeftMost
        ld a,d
        cp 4
        jr nz,NotLeft
        ld a,(Teleport)
        or a
        jr z,NotLeft
NotAtLeftMost:
        dec e
        call CheckBlock
        jr c,NotLeft
        ld (ix+pPX),7
        dec (ix+pBX)
;        jr NotTransportLeft
GotLeft:
        inc e
        jr nz,NotTransportLeft
        ld a,l
        cp 4
        jr nz,NotTransportLeft
        ld (ix+pBX),16
        ld (ix+pPX),3
        ld (ix+pX),118
NotTransportLeft:
        dec (ix+pPX)
        dec (ix+pX)
        ld b,c
NotLeft:
        pop af
        ret

MoveUp:
;        call DoMoveUp
;DoMoveUp:
        ld c,0

        call InitMove
        inc l
        dec l
        ret nz
        push af
        inc h
        dec h
        jr nz,GotUp
        ld a,d
        or a
        jr z,NotUp
        dec d
        call CheckBlock
        jr c,NotUp
        ld (ix+pPY),6
        dec (ix+pBY)
GotUp:
        dec (ix+pPY)
        dec (ix+pY)
        ld b,c
NotUp:
        pop af
        ret

MoveRight:
;        call DoMoveRight
;        dec l
;        inc l
;        ret z
;DoMoveRight:
        ld c,1

        call InitMove
        dec h
        inc h
        ret nz
        push af
        dec l
        inc l
        jr nz,GotRight
        ld a,(Teleport)
        or a
        jr z,NoTransportRight
        ld a,d
        cp 4
        jr z,TransportRight
NoTransportRight:
        ld a,e
        cp 16
        jr z,NotRight
TransportRight:
        inc e
        call CheckBlock
        jr c,NotRight
GotRight:
        inc (ix+pX)
        inc (ix+pPX)
        ld b,c
        ld a,l
        cp 6
        jr nz,NotRightBlock
        ld (ix+pPX),0
        inc (ix+pBX)
NotRightBlock:
        cp 3
        jr nz,NotTransportRight
        ld a,e
        cp 16
        jr nz,NotTransportRight
        ld (ix+pPX),4
        ld (ix+pBX),-1
        ld (ix+pX),0
NotTransportRight:
NotRight:
        pop af
        ret

RandomCoords:
GetRandomY:
        call Random
        and 15
        cp 9
        jr nc,GetRandomY
        push af
GetRandomX:
        call Random
        and 31
        cp 17
        jr nc,GetRandomX
        pop de
        ld e,a
        ret

InitEnemies:
        ld bc,(NumMonsters-1)
        ld ix,EnemyInfo
DoInitEnemies:
        push bc
GetRandomCoords:
        call RandomCoords
        and d
        rra
        jr c,GetRandomCoords
        ld a,d
        cp 3
        jr c,CornerY
        cp 5
        jr c,NotCornerY
CornerY:
        ld a,e
        cp 3
        jr c,GetRandomCoords
        cp 14
        jr nc,GetRandomCoords
NotCornerY:

        call GetBlockAddr
;        rlca
;        jr c,GetRandomCoords    ;don't place over a powerup
        inc a
        jr z,GetRandomCoords
        ld (hl),-1
        call GetBlockCoords
        dec c
        dec c
        dec c
        ld hl,Droid
EnemyType =$-2
        inc hl
        ld (ix+pAnimList),l
        ld (ix+pAnimList+1),h
        inc hl
        ld a,(hl)
        ld (ix+pSpr),a
        ld (ix+pX),b
        ld (ix+pY),c
        ld (ix+pDir),2
        ld (ix+pBX),e
        ld (ix+pBY),d
        pop bc
        ld (ix+pAnDir),1
        ld (ix+pSpeed),10
        ld (ix+pFrame),b
        ld a,(Intelligence)
        ld (ix+pEnemyFlags),a
        inc hl
        ld a,(hl)
        ld (ix+pMask),a
        ld de,pEnemyInfoLen
        add ix,de
        djnz DoInitEnemies
        ld ix,EnemyInfo
        ld bc,(NumMonsters-1)
DoneInitEnemies:
        push bc
        call InitMove
        call GetBlockAddr
        ld (hl),0
        ld de,pEnemyInfoLen
        add ix,de
        pop bc
        djnz DoneInitEnemies
        ret

MoveEnemies:
        ld a,LETHALSPRITES-1
        ld (MaxBlockCheck),a    ;disallow enemy from walking into explosions
        ld ix,EnemyInfo
        ld bc,(NumMonsters-1)
DoMoveEnemies:
        push bc
        ld a,(ix+pAnim)
        cp 89h
        jp nc,NoEnemy
        dec (ix+pFrame)
        jp nz,NotEnemyFrame
        ld a,(ix+pSpeed)
        ld (ix+pFrame),a

        call InitMove
        push hl
        push de
        ld a,(ix+pAnim)
        sub 80h
        jr nc,MovedEnemy
        push hl
        call GetBlockAddr
        pop hl
        and 127
        cp LETHALSPRITES
        jr nc,KillEnemy
        ld a,h
        or l
        jr z,NewEnemyDirection
        push de
        inc d
        ld a,l
        or a
        jr z,NotCheckEnemyRight
        dec d
        inc e
NotCheckEnemyRight:
        call GetBlockAddr
        and 127
        cp LETHALSPRITES
        pop de          
        jr c,NotNewEnemyDirection
KillEnemy:
        call KillSprite
        ld hl,200
        call AddScore
        ld hl,EnemiesLeft
        dec (hl)
        jr nz,MovedEnemy
        ld a,1
        ld (DoorOpen),a
        jr MovedEnemy
NewEnemyDirection:

        push de
        bit eDropSkins,(ix+pEnemyFlags)
        call nz,DropSkins

        call Random
        pop de
        and 3

        bit ePyroIntelligent,(ix+pEnemyFlags)
        call nz,PyroIntelligence
        bit eIntelligent,(ix+pEnemyFlags)
        call nz,CleverIntelligence
        bit eBombStealing,(ix+pEnemyFlags)
        call nz,BombStealing

GotNewEnemyDirection:
        ld (ix+pDir),a
NotNewEnemyDirection:
        ld a,(ix+pStunLeft)
        or a
        jr nz,EnemyStunned
        call MoveInCurrentDir
        jr nz,DoPutEnemy
        ld b,2      
DoPutEnemy:
        ld (ix+pDir),b
;        call CycleAnimation
        jr MovedEnemy
EnemyStunned:
        dec (ix+pStunLeft)
MovedEnemy:
        pop de
        pop hl
        call UnputAnimatedSprite
        call PutAnimatedSprite
        call CheckIfZapped
        jr nc,EnemyNotZapped
        ld a,(ix+pStunLeft)
        or a
        jr nz,EnemyNotZapped
        ld (ix+pStunLeft),20
EnemyNotZapped:
NotEnemyFrame:
NoEnemy:
        pop bc
        ld de,pEnemyInfoLen
        add ix,de
        dec b
        jp nz,DoMoveEnemies
        ret

DropSkins:
        push de
        call Random
        pop de
        cp 16
        ret nc
        call GetBlockAddr
        or a
        ret nz
        ld (hl),32
        ret

PyroIntelligence:
        push af
        ld a,(TotalPlayers)
        ld b,a
        ld hl,PlayerInfo+pBX
PyroCheckPlayers:
        ld a,(hl)
        inc hl
        sub e
        ld c,a
        inc a
        cp 3
        jr nc,NotPyro
        ld a,(hl)
        sub d
        inc a
        cp 3
        jr nc,NotPyro
        dec a
        and c
        rra
        jr c,NotPyro
        pop af
        ld a,(hl)
        sub d
        jr z,NotPyroY
        inc a
        ret
NotPyroY:
        ld a,c
        inc a
        xor 3
        ret
NotPyro:
        push de
        ld de,pInfoLen-1
        add hl,de
        pop de
        djnz PyroCheckPlayers
        pop af
        ret

BombStealing:
        push af
        call GetBlockAddr
        ld b,-1
        call CheckSqForBombs
        inc b
        jr z,NoSteal
        ld a,b
        cp 10
        jr nz,NotSteal
        ld b,(ix+pDir)
        inc b
        djnz NotStealUp
        dec d
NotStealUp:
        djnz NotStealRight
        inc e
NotStealRight:
        djnz NotStealDown
        inc d
NotStealDown:
        djnz NotStealLeft
        dec e
NotStealLeft:
        call GetBlockAddr
        sub 11
        cp 4
        jr nc,NoSteal
        ld (hl),0
        call FindBomb
        ld (hl),0
        inc hl
        call LocateBombOwner
        jr nz,MoveTowardsBomb
        inc hl
        inc (hl)
        ld a,(hl)
        call PutWeapStatus
        jr MoveTowardsBomb
NotSteal:
        cp 8
        jr c,NoSteal
;        jr nz,MoveTowardsBomb
;        call Random
;        cp 192
;        jr c,NoSteal
MoveTowardsBomb:
        pop af
        ld a,(ix+pDir)
        ret
NoSteal:
        pop af
        ret

CleverIntelligence:
        push de
        push af
        call GetBlockAddr
        push af
        push hl
        ld (hl),1
        ld bc,0FF00h
        ld h,c
        ld l,c
        dec d
        call CheckSqForBombs
        inc e
        inc d
        call CheckSqForBombs
        dec e
        inc d
        call CheckSqForBombs
        dec d
        dec e
        call CheckSqForBombs
        pop de
        pop af
        ld (de),a
        pop af
        pop de
        inc b
        ret z   ;random if no bombs in range
        ld a,l
        cp 15
        ld a,c  ;dir with furthest bomb
        ret z
GetRandomDir:
        push hl
        push de
        call Random
        pop de
        pop hl
        and 3
        ld c,a
        cpl
        add a,5
        ld b,a
        ld a,l
CheckDirForBomb:
        rrca
        djnz CheckDirForBomb
        rla
        jr c,GetRandomDir
        ld a,c
        ret

CheckSqForBombs:
        push bc
        push de
        push hl
        call GetBlockAddr
        ld bc,0
        ld de,-17
        call CheckDirForBombs
        ld de,1
        call CheckDirForBombs
        ld de,17
        call CheckDirForBombs
        ld de,-1
        call CheckDirForBombs
SqNotOk:
        ld a,c
        pop hl
        pop de
        pop bc
        or a
        jr z,NoBombs
        cp b
        jr nc,NotLongerDist
        ld b,a
        ld c,h
NotLongerDist:
        scf
NoBombs:
        rl l
        inc h
        ret

CheckDirForBombs:
        push hl
        push bc
        ld b,10
SearchForBomb:
        ld a,(hl)
        add hl,de
        and 127
        dec a
        cp 8
        jr c,NotFoundBomb       ;wall hit
        sub 10
        cp 4
        jr c,FoundBomb
        djnz SearchForBomb
NotFoundBomb:
        pop bc
        pop hl
        inc b
        ret
FoundBomb:
        ld a,b
        pop bc
        pop hl
        inc b
        cp c
        ret c
        ld c,a
        dec b
        ld (ix+pDir),b
        inc b
        ret

SPROL = 6

UnputAnimatedSprite:
        ld (SelfSprite),ix
        push ix
        ld b,2
RedrawRight:
        ld a,h
        cp SPROL
        jp nc,NotRedrawUp
        ld a,d
        or a
        jr nz,NotRedrawBorder
        push hl
        push de
        push bc
        call GetBlockCoords
        ld c,2
        call FindPixel
        ld a,e
        and 15
        add a,TopBorder & 255
        ld l,a
        ld h,TopBorder/256
        jr nc,NotIncTopB
        inc h
NotIncTopB:
DoCopyBord:
        ld b,6
CopyBordTop:
        ldi
        inc bc
        ld a,e
        and 15
        jr z,SkipSecondBordCopy
        ld a,(hl)
        ld (de),a
SkipSecondBordCopy:
        push de
        ld de,15
        add hl,de
        ex (sp),hl
        add hl,de
        ex de,hl
        pop hl
        djnz CopyBordTop
        ld a,d
        push hl
        ld hl,GreyBuffer-0FC60h
        add hl,de
        ex de,hl
        pop hl
        cp 0FCh
        jr nc,DoCopyBord
        pop bc
        pop de
        pop hl
        jr NotRedrawUp
NotRedrawBorder:
        ld a,e
        cp 17
        jr nz,NotRedrawTransRight
        push hl
        push de
        push bc
        ld de,GreyBuffer+20Fh
        push de
        ld hl,0FE0Fh
        ld de,-16
        ld b,12
UpdateTransRight:
        add hl,de
        ld a,(hl)
        or 038h
        ld (hl),a
        ex (sp),hl
        djnz UpdateTransRight
        ld b,8
        ld de,16
UpdateTransRight2:
        res 3,(hl)
        add hl,de
        ex (sp),hl
        djnz UpdateTransRight2
        pop hl
        pop bc
        pop de
        pop hl
        jr RedrawnTrans
NotRedrawTransRight:
        inc a
        jr nz,NotRedrawTransLeft
        push hl
        push de
        push bc
        ld de,GreyBuffer+200h
        push de
        ld hl,0FE00h
        ld de,-16
        ld b,12
UpdateTransLeft:
        add hl,de
        ld a,(hl)
        or 0E0h
        ld (hl),a
        ex (sp),hl
        djnz UpdateTransLeft
        ld b,8
        ld de,16
UpdateTransLeft2:
        res 7,(hl)
        add hl,de
        ex (sp),hl
        djnz UpdateTransLeft2
        pop hl
        pop bc
        pop de
        pop hl
        jr RedrawnTrans
NotRedrawTransLeft:
        dec d
        call RedrawBlock
        inc d
NotRedrawUp:
        call RedrawBlock
        inc d
        ld a,h
        or a
        call nz,RedrawBlock
        dec d
RedrawnTrans:
        ld a,l
        or a
        jr z,NotRedrawRight
        inc e
        dec b
        jp nz,RedrawRight
        dec e
NotRedrawRight:

        call GetBlockCoords
        ld a,b
        add a,7
        ld d,a
        inc l
        dec l
        jr z,NotRedrawnLeft
        sub 14
        jr c,NotRedrawnLeft     ;if in lefthand transporter
        ld b,a
NotRedrawnLeft:
        ld a,c
        add a,6
        inc h
        dec h
        jr z,NotRedrawnDown
        add a,6
NotRedrawnDown:
        ld e,a
        ld a,h
        cp SPROL
        jr nc,NotRedrawnUp
        ld a,c
        sub 6
        ld c,a
NotRedrawnUp:
        ex de,hl
        ld ix,PlayerInfo
        ld de,pInfoLen
        ld a,4
        call TryRedrawSprites
        ld ix,EnemyInfo
        ld de,pEnemyInfoLen
        ld a,(NumMonsters)
        call TryRedrawSprites
        pop ix
        ret

TryRedrawSprites:

; redraws any sprites in the area (B,C)-(D,E)
; which is the area of tiles redrawn to clear old sprite
; in order to do this sprites whose X and Y coordinates
; satisfy the following two condition must be redrawn:

;       B-7 < x < H
;       C-6 < y < L+6

        push de
        push bc
        push hl
        push af
        call RedrawSpriteIfBounded
        pop af
        pop hl
        pop bc
        pop de
        add ix,de
        dec a
        jr nz,TryRedrawSprites
        ret

RedrawSpriteIfBounded:
        push hl
        push ix
        pop hl
        ld de,0
SelfSprite =$-2
        or a
        sbc hl,de
        pop hl
        ret z
        ld a,(ix+pX)
        cp h
        ret nc
        add a,7
        cp b
        ret c
        ld a,(ix+pY)
        sub SPROL
        cp l
        ret nc
        add a,6+SPROL
        cp c
        ret c
DoPutAnimatedBigSprite:
        ld b,(ix+pX)
        ld c,(ix+pY)
        ld a,(ix+pSpr)
        inc a
        ret z
        dec a
        ld d,(ix+pMask)
        push bc
        push ix
        call PutMaskedBigSprite
        pop ix
        pop bc
        push ix
        call GetShieldAddr
        ld a,(ix+pSpr)
        ld d,(ix+pMask)
        call nz,PutMaskedBigSprite
        pop ix
NoShieldOnSprite:
        ret

InitSprite:
        push bc
        ld (ix+pBX),e
        ld (ix+pBY),d
        call GetBlockCoords
        pop de
        dec c
        dec c
        dec c
InitSpriteBC:
        ld a,(ResetStats)
        or a
        ld a,1
        jr z,SkipReset
        ld (ix+pSpeed),5
        ld (ix+pAnDir),a
        ld (ix+pMaxBombs),a
        ld (ix+pBombs),a
SkipReset:        
        ld (ix+pY),c
        ld (ix+pX),b
        ld (ix+pAnim),a
        ld (ix+pDir),2
        ld (ix+pAnimList),l
        ld (ix+pAnimList+1),h
        ld (ix+pShieldAddr),e
        ld (ix+pShieldAddr+1),d
        ld (ix+pFrame),a
        ld (ix+pPowerUpFrame),a
        ld (ix+pLink),80h
        xor a
        ld (ix+pPX),a
        ld (ix+pPY),a
        ld (ix+pDizzyLeft),a

PutAnimatedSprite:
        call CycleAnimation
        ret nc
        push ix
        call GetShieldAddr
        call nz,CycleAnimation
        pop ix
        jp DoPutAnimatedBigSprite

GetFlagAddr:
        inc ix
        inc ix
        jr DoGetFlagAddr
GetShieldAddr:
        ld a,(ix+pShieldLeft)
        or a
        ret z
DoGetFlagAddr:
        ld a,(ix+pShieldAddr+1)
        or a
        ret z
        ld h,a
        ld l,(ix+pShieldAddr)
        push hl
        pop ix
        ret

RedrawBlock:
        push bc
        push hl
        push de
        call GetBlockAddr
        call GetBlockCoords
        ld a,(hl)
        call PutSprite
        pop de
        pop hl
        pop bc
        ret

GetBlockAddr:
        ld a,d
        add a,a
        add a,a
        add a,a
        add a,a
        add a,d
        add a,e
        ld c,a
        ld b,0
        ld hl,Grid
        add hl,bc
        ld a,(hl)
        ret  

CycleAnimation:
        ld (ix+pSpr),-1
        ld l,(ix+pAnimList)
        ld h,(ix+pAnimList+1)
        ld d,0
        ld b,1
        bit 7,(ix+pAnim)
        jr nz,GetAnimList
        ld d,80h
        ld b,3
        ld a,(ix+pDir)
        cp b
        jr z,GotAnimList        ;going left..
        ld d,0
        dec a
        jr z,GotAnimList        ;going right..
        inc a
        jr nz,GetAnimList       ;get up list
        dec b                   ;get down list
GetAnimList:
        ld e,(hl)
        inc hl
        add hl,de
        add hl,de
        djnz GetAnimList
GotAnimList:
        ld c,(hl)
        dec c
        ld a,(ix+pAnim)
        add a,(ix+pAnDir)
        jr z,FlipAnDir
        cp c
        jr nz,NotFlipAnDir
FlipAnDir:
        ld b,a
        ld a,(ix+pAnDir)
        neg
        ld (ix+pAnDir),a
        ld a,b
        jr NotNewDir
NotFlipAnDir:
        jr c,NotNewDir
        ld (ix+pAnDir),1
        cp 80h
        jr nc,NotNewDir
        xor a
NotNewDir:
        cp 0A1h
        ret nc
        ld (ix+pAnim),a
        rla
        jr nc,Amphetamine
        ld (ix+pFrame),12
Amphetamine:
        srl a
        inc c
        cp c
        ret nc
        ld c,a
        ld b,0
        add hl,bc
        add hl,bc
        inc hl
        ld a,(hl)
        cp 192
        jr c,NotCheckBossFlip
        ld a,d
        or a
        ld a,(hl)
        jr z,NotCheckBossFlip
        ld d,32
NotCheckBossFlip:
        xor d
        ld b,a
        inc hl
        ld a,(hl)
        xor d
        ld d,a
        ld a,b
        ld b,(ix+pX)
        ld c,(ix+pY)
        ld (ix+pSpr),a
        ld (ix+pMask),d
        cp 255
        ret c
        ld d,(ix+pBY)
        ld e,(ix+pBX)
        push de
        call GetBlockAddr
        ld b,82h
        call DoDropBomb
        pop de
        call FindBomb
        ld (hl),7
        or a
        ret


GetSpriteAddr:
        ld de,SmallSprites
        and 7Fh
        cp 85
        jr c,NotReversedSprite
        sub 85
        ld de,ReversedSprites
NotReversedSprite:
        ld h,0
        ld l,a
	add a,a
        add a,l
        rl h
        ld l,a
        add hl,hl
        add hl,hl
	add hl,de
        ld a,12
        ret

GetBigSpriteAddr:
        ld de,BigSprites
        add a,a
        jr nc,NotReversedBigSprite
        jp m,GetBossSpriteAddr
        ld de,ReversedBigSprites
NotReversedBigSprite:
        ld h,0
        ld l,a
        add hl,hl
        add hl,hl
        add hl,hl
        add hl,de
        ld d,0
        ld e,a
        add hl,de
        ld a,18
        ret

GetBossSpriteAddr:
        ld de,BossSprites
        add a,a
        add a,a
        jr nc,NotReversedBossSprite
        ld de,ReversedBossSprites
NotReversedBossSprite:
        ld l,a
        ld h,0
        add hl,hl
        add hl,de
        ld e,a
        ld d,0
        add hl,de
        ld a,24
        ret

GetBigMaskAddr:
        cp 192
        jr nc,GetBossMaskAddr
        ld de,Masks
        bit 7,a
        jr z,NotReversedBigSprite
        res 7,a
        ld de,ReversedMasks
        jr NotReversedBigSprite
GetBossMaskAddr:
        ld de,BossMasks
        add a,a
        add a,a
        bit 7,a
        jr z,NotReversedBossSprite
        res 7,a
        ld de,ReversedBossMasks
        jr NotReversedBossSprite

        ; SPRITE ROUTINES

        ; A = sprite number
        ; B = X coord
        ; C = Y coord
        ; D = mask number (only for big sprites, set IX for small)

PutMaskedBigSprite:
        push af
        ld a,d
        call GetBigMaskAddr
        push hl
        pop ix
        pop af
        call GetBigSpriteAddr
        jr DoPutBigSprite
PutSprite:
        ld ix,BlankMask
PutMaskedSprite:
	call GetSpriteAddr
PutMaskedSpriteHL:
DoPutBigSprite:     
        ld (SpriteHeight),a

        call FindPixel
        ld c,12
SpriteHeight =$-1
        ex de,hl
        push hl
        push de
        ld de,GreyBuffer-0FC00h
        add hl,de
        pop de
DoPutMaskedSprite:
	push bc
        ld a,h
        cp 0FCh
        ld a,(ix)
        jr c,NotIncIX
        inc ix
NotIncIX:
	ld c,255
        ex de,hl
	push hl
        ld h,(hl)
	ld l,0
	dec b
	jr z,DontRotateMaskedSprite
RotateMaskedSprite:
	scf
        rra
	rr c
	srl h
	rr l	
	djnz RotateMaskedSprite
DontRotateMaskedSprite:
	ex de,hl
	and (hl)
	xor d
	ld (hl),a
	inc hl
	ld a,c
	and (hl)
	xor e
	ld (hl),a
	ld bc,15
	add hl,bc
        pop de
        inc de
	pop bc
        ex (sp),hl
	dec c
	jr nz,DoPutMaskedSprite
        pop hl
	ret

        ; and now for something rather important...

        ; THE BLAST ROUTINE!

        ;  A  = direction in memory to step
        ;  B bits 0-3 = blast range
        ;       bit 4 = nuclear flag (blasts straight through walls)
        ;  C  = fill sprite 
        ; DE  = starting block coordinates
        ; HL  = starting block address
        ; IXL = value to add to X coordinate each loop
        ; IXH = value to add to Y coordinate each loop
        ; (BlastFill) = 255 to put explosion, 0 to clear
        ; (BlastRestrict) = 0 on first call, 36 on subsequent calls
        ;                   (when 36 explosion will only go over old
        ;                    explosion sprites)

Blast:
        push hl
        ld l,a
        rla
        sbc a,a
        ld h,a
        ld (BlastMemAdd),hl
        pop hl
        .db 0DDh \ ld a,l
        ld (XCoordAdd),a
        .db 0DDh \ ld a,h
        ld (YCoordAdd),a
        push bc
        push de
        push hl
        ld a,3Dh
        bit 4,b
        jr z,NotNuke
        dec a
        res 4,b
NotNuke:
        ld (DontBlast),a
DoBlast:
        push bc
        ld bc,0
BlastMemAdd =$-2
        add hl,bc
        pop bc
        ld a,d
        add a,0
XCoordAdd =$-1
        ld d,a
        cp 122
        jp nc,DoneBlast
        ld a,e
        add a,0
YCoordAdd =$-1
        ld e,a
        cp 62
        jr nc,DoneBlast
        cp 7
        jr c,DoneBlast
        ld a,(hl)
        and 127
        dec a
        cp 9
        jr nc,NotBlastWall
        and 1
        jr nz,DoneBlast
NotBlastWall:       
        inc a
        cp LETHALSPRITES
        jr nc,NotABlowingWall
        cp 36
        jr c,NotABlowingWall
        ld a,1
        jr IsABlowingWall
NotABlowingWall:
        cp 36
BlastRestrict =$-1
        jr c,DontBlast
IsABlowingWall:
        push bc
        push hl
        push af
        push de
        dec a
        ld a,c
        jr nz,NotBlowingWall
        push hl
        push de
        ld hl,1
        call AddScore
        pop de
        pop hl
        ld a,(hl)
        and 80h
        or 40h
WallSprite =$-1
NotBlowingWall:
        and 255
BlastFill =$-1
        jr nz,DontPlacePowerup
        ld a,(DoorPos)
#if (Grid & 255)>0
        add a,Grid & 255
#endif
        cp l
        jr nz,DontPlaceDoor
        ld a,(DoorSprite)
        jr DontPlacePowerup
DontPlaceDoor:
        xor a        
        rl (hl)
        jr nc,DontPlacePowerup
        push hl
        push de
TryPowerups:
        call Random
        and 63
        ld hl,TotalPowerups
        cp (hl)
        jr nc,TryPowerups
        ld b,28                     ;sprite number
SelectPowerup:
        dec b                       ;all this stuff just ensures
        dec hl                      ;correct probability weightings :)
        sub (hl)
        jr nc,SelectPowerup         
        ld de,Powerups-PowerupLimits
        add hl,de
        ld a,(hl)
        or a
        jr z,TryPowerups
        dec (hl)
        ld a,b
        pop de
        pop hl
DontPlacePowerup:
        ld (hl),a
        ld b,d
        ld c,e
        call PutSprite
        pop de
        pop af
        pop hl
        pop bc
DontBlast:
        dec a
        jr z,DoneBlast
        dec b
        jp nz,DoBlast
DoneBlast:
        pop hl
        pop de
        pop bc
        ret

PutText:
        ld a,(hl)
        inc hl
        or a
        ret z
        call PutChar
        jr PutText

PutStatusNumHL:
        ld b,5
PutStatusNumHL_C: 
        call UNPACK_HL
        push af
        dec b
        call nz,PutStatusNumHL_C
        ld a,c
        add a,6
        ld c,a
        pop af
        jp PutStatusDigit        

PutNumA:
        ld h,0
        ld l,a
;        push de
        ld e,2
;        call PutNumHL_C
;        pop de
;        ret
        jr PutNumHL_C
PutNumHL:
;        push de
        ld e,5
;        call PutNumHL_C
;        pop de
;        ret
PutNumHL_C:        
        call UNPACK_HL
        push af
        dec e
        call nz,PutNumHL_C
        pop af
PutDigit:
        add a,'0'
PutChar:
        cp 4
        jr nc,NotChangeColour
        ld d,a
        ret
NotChangeColour:
        cp 80h
        jr nc,GotChar
        cp 32
        jr z,PutSpace
        sub '0'
        ret c
        add a,26
        cp 40
        jr c,GotChar
        sub 'A'-'0'+26
        ret c
        and 0DFh
        cp 26
        ret nc
GotChar:
        push hl
        push de
        jr c,NotCharSprite
        inc b
        push bc
        dec b
        ld ix,XorMask
        call PutMaskedSprite
        jr DonePutChar
NotCharSprite:
        push bc
        push de
        add a,a
        ld e,a
        add a,a
        add a,e
        ld e,a
        ld d,0
        ld hl,Font
        add hl,de
        call FindPixel
        pop af
        ld c,a
PutCharGrey:
        srl c
        push hl
        push de
        push bc
        jr nc,SkipGreyLayer
        ld c,6
DoPutChar:
        push bc
        ld c,(hl)
        inc hl
        xor a
        dec b
        jr z,ShiftedFont
ShiftFontChar:
        srl c
        rra
        djnz ShiftFontChar
ShiftedFont:
        ex de,hl
        inc hl
        xor (hl)
        ld (hl),a
        dec hl
        ld a,c
        xor (hl)
        ld (hl),a
        ld c,16
        add hl,bc
        ex de,hl
        pop bc
        dec c
        jr nz,DoPutChar
SkipGreyLayer:
        pop bc
        pop hl
        ld a,h
        ld de,GreyBuffer-0FC00h
        add hl,de
        ex de,hl
        pop hl
        cp 0FCh
        jr nc,PutCharGrey
DonePutChar:
        pop bc
        pop de
        pop hl
PutSpace:
        ld a,b
        add a,6
        ld b,a
        ret  

FindBomb:
        ld hl,BombList
        ld b,48
CheckBombCoords:
        ld a,e
        cp (hl)
        inc hl
        jr nz,NotRightBomb
        ld a,d
        cp (hl)
        jr nz,NotRightBomb
        inc hl
        ld a,(hl)
        or a
        ret nz
        dec hl
NotRightBomb:
        inc hl
        inc hl
        inc hl
        djnz CheckBombCoords
        ret

InitGrey:
;        ld hl,(4065h)
;        ld (RomPatch),hl
	call ClearGreyBuffer
;        res 2,(iy+23h)
	ld hl,IHandler
        ld de,INTADDR ;0D2FEh
;        push de
	ld bc,IHandlerEnd-IHandler
	ldir

        ld hl,INTTABLE
        ld de,INTTABLE+1
        inc b
        ld (hl),INTADDR & 255
        ldir
        ld a,INTTABLE/256
        ld i,a
        im 2

;        ld de,40
;        pop hl
;        ld a,(hl)
;        dec hl
;        push hl
;        ld b,5
;CalcChecksum:
;        add hl,de
;        add a,(hl)
;        djnz CalcChecksum
;        pop hl
;        ld (hl),a
;        set 2,(iy+23h)
;        or a
	ret

MessageBar:
        push hl
        push bc
        ld hl,0FDE0h
        ld c,10
DrawBarLines:
        ld b,15
StoreBarLine:
        ld (hl),0FFh
        inc hl
        djnz StoreBarLine
        ld a,(hl)
        or 0F8h
        ld (hl),a
        inc hl
        dec c
        jr nz,DrawBarLines
        pop bc
        ld c,20h
        pop hl
        ld d,3
        jp PutText

ClearScreen:
#if 0
        ld bc,15000
Disintegrate:
        push bc
        call Random
        and 7
        ld c,a
        ld b,0
        ld a,h
        rlca
        rlca
        and 3
        ld d,a
        ld e,l
        ld hl,BitMasks
        add hl,bc
        ld b,(hl)
        ld hl,GreyBuffer
        add hl,de
        ld a,(hl)
        and b
        ld (hl),a
        ld hl,0FC00h
        add hl,de
        ld a,(hl)
        and b
        ld (hl),a
        pop bc
        dec bc
        ld a,b
        or c
        jr nz,Disintegrate    
BitMasks .db 07Fh,0BFh,0DFh,0EFh,0F7h,0FBh,0FDh,0FEh
#endif
        call _clrLCD
ClearGreyBuffer:
	ld hl,GreyBuffer
	ld de,GreyBuffer+1
	ld bc,3FFh
	ld (hl),0
	ldir
	ret


DeinitGrey:
        im 1
;        res 2,(iy+23h)
        ld a,3Ch
        out (0),a
	ret

IHandler:
        exx
        ex af,af'
	in a,(3)
        bit 3,a
        jr z,NotDownLeftBug
        and 254
        out (3),a
NotDownLeftBug:
	bit 1,a
	jr z,notvbl
	ld hl,Timer
	inc (hl)
        ld hl,GreyCounter
	inc (hl)
	ld a,(hl)
        cp 3
	ld a,3Ch
        jr c,notpage1
	ld a,(GreyBuffer/256)-0C0h
        ld (hl),0
notpage1:
	out (0),a
notvbl:
        jp 3Ah
IHandlerEnd:

; LINK ROUTINES
#if 0
TryReceiveByte:
        in a,(LINKPORT)
        and 3
        cp 3
        scf
        ret z
        push bc
        ld b,14h
        jr DoLink
ReceiveByte:
        push bc
        ld b,15h
        jr DoLink
SendByte:
        push bc
        ld b,0Ah
DoLink:
        push de
        push hl
        ld hl,_ASAP_IND
        ld (hl),b
        ld hl,LinkError
;        ld b,(iy+12h)
;        push bc
        call 41A1h
        call 571Ch
        ld b,a
        call 41A4h
        or 1            ;clear cf
.org $-1
LinkError:
        scf
DoneLink:
        ld a,b
;        pop bc
;        ld (iy+12h),b
        res 2,(iy+12h)
        pop hl
        pop de
        pop bc
        ret
#endif


LINKMASK =3

LinkPrep:
        ex (sp),hl
        push bc
        push de
;        ld b,(iy+12h)
;        push bc
        set 2,(iy+12h)
        ld b,8
        jp (hl)

TryReceiveByte:
        in a,(LINKPORT)
        and LINKMASK
        cp LINKMASK
        scf
        ret z
ReceiveByteCont:
        call LinkPrep
        jr ReceiveCont
ReceiveByte:
        call LinkPrep
ReceiveBits:
        ld de,TIMEOUT
WaitRecBit:
        call CheckLink
        jr z,LinkFailed
        cp LINKMASK
        jr z,WaitRecBit
ReceiveCont:
        sub LINKMASK/3*2
        ld a,LINKMASK/3*2
        ld d,D0LD1H
        jr c,ReceiveLow
        rra
        ld d,D0HD1L
ReceiveLow:
        rr c
        ld (AckBit),a
        ld a,d
        out (LINKPORT),a
        ld de,TIMEOUT
WaitAckRec:
        call CheckLink
        cp 0
AckBit =$-1
        jr nz,WaitAckRec
        ld a,D0HD1H
        out (LINKPORT),a
        ld d,4
WaitReadyRec:
        dec d
        jr z,ReadyRec
        in a,(LINKPORT)
        cp LINKMASK
        jr nz,WaitReadyRec
ReadyRec:
        djnz ReceiveBits
        jr LinkSuccess
  
SendByte:
        call LinkPrep
        ld c,a

        inc b
        jr SendAcked

SendBits:
        rr c
        ld a,D0LD1H
        jr nc,SendLow
        ld a,D0HD1L
SendLow:
        out (LINKPORT),a
        ld de,TIMEOUT
WaitAckSend:
        call CheckLink
        jr nz,WaitAckSend
SendAcked:
        ld a,D0HD1H
        out (LINKPORT),a
        ld de,TIMEOUT
WaitReadySend:
        call CheckLink
        cp LINKMASK
        jr nz,WaitReadySend
        djnz SendBits
LinkSuccess:
        or 0
.org $-1
LinkFailed:
        scf
        ld a,c
        res 2,(iy+12h)
        pop de
        pop bc
        pop hl
        ret

CheckLink:
        pop hl
        dec de
        ld a,d
        or e
        jr z,LinkFailed
        ld a,0BFh
        call _readkeypad
        bit 6,a
        jr z,LinkFailed
        in a,(LINKPORT)
        and LINKMASK
        jp (hl)

_readkeypad:
	out (1),a
	in a,(1)
        push af
	ld a,255
	out (1),a
        pop af
	ret

PutLogo:
        ld hl,Logo
        call LogoCopy
        push hl
        ld hl,GreyBuffer-0FCF0h
        add hl,de
        ex de,hl
        pop hl
LogoCopy:
        ld a,15
DoLogoCopy:
        ld bc,12
        ldir
        inc de
        inc de
        inc de
        inc de
        dec a
        jr nz,DoLogoCopy
        ret

WaitMenuKey:
        call GET_KEY
        or a
        ret nz
        ld hl,Timer
        ld a,(hl)
        and 15
        jr nz,DontAnimateLogoMen
        inc (hl)
        ld hl,0FC0Eh
        ld ix,GreyBuffer+14
        ld de,12
        ld c,15
BlankMenuMen:
        ld b,4
BlankMenuMenR:
        ld (hl),d
        ld (ix),d
        inc hl
        inc ix
        djnz BlankMenuMenR
        add hl,de
        add ix,de
        dec c
        jr nz,BlankMenuMen
        ld ix,PlayerInfo
        call PutAnimatedSprite
        ld ix,PlayerInfo+pInfoLen
        call PutAnimatedSprite
DontAnimateLogoMen:
        scf
        ret

GetMenuKey:
        ld a,(MenuPos)
        sub 0
TopItem =$-1
        ld b,a
        add a,a
        add a,a
        add a,a
        sub b
        add a,29
        ld c,a
        ld b,16
WaitForMenuKey:
        ld a,(Timer)
        rlca
        rlca
        rlca
        and 1
        add a,11
        push bc
        call PutSprite
        call WaitMenuKey
        pop bc
        jr c,WaitForMenuKey
        cp K_EXIT
        scf
        ret z
        ld hl,MenuPos
        cp K_UP
        jr nz,NotCursorUp
        ld a,(hl)
        or a
        jr z,GetMenuKey
        push hl
        xor a
        call PutSprite
        pop hl
        dec (hl)
        ld a,(hl)
        ld hl,TopItem
        cp (hl)
        call c,ScrollMenuUp
        jr GetMenuKey
NotCursorUp:
        cp K_DOWN
        jr nz,NotCursorDown
        ld a,(MenuMax)
        dec a
        cp (hl)
        jr z,NotCursorDown
        push hl
        xor a
        call PutSprite
        pop hl
        inc (hl)
        ld a,(hl)
        sub 5
        jp c,GetMenuKey
        ld hl,TopItem
        cp (hl)
        call nc,ScrollMenuDown
GetMenuKeyLocal:
        jp GetMenuKey
NotCursorDown:
        ld d,-1
        cp K_LEFT
        jr z,LeftRightKey
        ld d,1
        cp K_RIGHT
        jr nz,NotLeftRightKey
LeftRightKey:
        ld a,0
MenuPos =$-1
        inc a
        inc a
        call FindMenuItem
        dec hl
        dec hl
        ld a,(hl)
        cp 'Y'
        jr nz,NotMenuYes
        ld a,'N'
        jr SetNewMenuVal
NotMenuYes:
        cp 'N'
        jr nz,NotMenuNo
        ld a,'Y'
        jr SetNewMenuVal
NotMenuNo:
        cp 10
        jp nc,GetMenuKey
        ld e,'1'
        add a,e
        cp '9'
        jr nz,NotAllow0
        dec e
NotAllow0:
        ld b,a
        dec hl
        ld a,(hl)
        add a,d
        cp e
        jr c,GetMenuKeyLocal
        cp b
        jr z,GetMenuKeyLocal
SetNewMenuVal:
        push af
        push hl
        ld a,(MenuPos)
        inc a
        call FindMenuItem
        push hl
        ld b,24
        ld d,1
        call PutText
        pop hl
        pop de
        pop af
        ld (de),a
        ld b,24
        ld d,1
        call PutText
        jr GetMenuKeyLocal
NotLeftRightKey:       
        cp K_SECOND
        jr z,GotMenuKey
        cp K_ENTER
        jr nz,GetMenuKeyLocal
GotMenuKey:
        ld a,(hl)
        ret

#ifdef HELP
ShowHelpScreen:
        ld hl,HelpText
        ld a,1
        call DoDrawHelp
HelpScreenLoop:
        call WaitMenuKey
        jr c,HelpScreenLoop
        cp K_EXIT
        jp z,DoMainMenu
        ld hl,TopItem
        cp K_UP
        jr nz,NotHelpUp
        ld a,(hl)
        or a
        call nz,ScrollMenuUp
        jr HelpScreenLoop
NotHelpUp:
        cp K_DOWN
        jr nz,HelpScreenLoop
        ld a,(MenuMax)
        sub 5
        cp (hl)
        call nz,ScrollMenuDown
        jr HelpScreenLoop       
#endif

ScrollMenuUp:
        ld a,(hl)
        dec (hl)
        push af
        ld hl,28*256+123
        call vblank
        ld hl,0FF8Fh
        ld de,0FFFFh
        ld bc,1CFh
        push bc
        lddr
        pop bc
        ld hl,GreyBuffer+038Fh
        ld de,GreyBuffer+03FFh
        lddr
        pop af
        ld c,29
        jr PutMenuItem
ScrollMenuDown:
        inc (hl)
        ld a,(hl)
        add a,4
        call ScrollTextUp
PutMenuItem:
        call FindMenuItem
        ld b,24
MenuItemX =$-1
        ld d,1
        push bc
        call PutText
        pop bc
        ld d,1
        call PutText
PutScrollArrows:
        ld a,0
MenuMax =$-1
        cp 6
        ret c
        ld b,a
        ld a,(TopItem)
        add a,5
        cp b
        ld a,LdownArrow
        ld hl,57*256+123
        ld (_penCol),hl
        call nz,_vputmap
        ld hl,28*256+123
        ld (_penCol),hl
        ld a,(TopItem)
        or a
        ld a,LupArrow
        call nz,_vputmap
        ret

ScrollTextUp:
        push af
        ld hl,57*256+123
        call vblank
        ld de,0FDC0h
        ld hl,0FE30h
        ld bc,1CFh
        push bc
        ldir
        pop bc
        ld de,GreyBuffer+1C0h
        ld hl,GreyBuffer+230h
        ldir
        pop af
        ld c,57
        ret

vblank:
        ld (_penCol),hl
        ld b,4
blankloop:
        ld a,' '
        call _vputmap
        djnz blankloop
        ret

DrawMenuBar:
        push hl
        ld hl,0FD00h
        ld de,0FD01h
        ld (hl),0FFh
        ld bc,090h
        ldir
        ld (hl),b
        ld bc,26Fh
        ldir
        ld hl,0FCF0h 
        ld de,GreyBuffer+100h
        ld b,3
        ldir
        pop hl
        ret

DrawMenu:
        ld a,24
DoDrawHelp:
        ld (MenuItemX),a
        push af
        call DrawMenuBar
        xor a
        ld (MenuPos),a
        ld (TopItem),a
        ld a,(hl)
        ld (MenuMax),a
        ld (MenuAddr),hl
        ld e,a
        inc hl
        push hl
        ld bc,-1
        xor a
        cpir
        ld a,c
        add a,a
        add a,c
        add a,70
        ld b,a
        ld c,18
        pop hl
        ld d,3
        call PutText
        pop bc
        ld a,e
        or a
        ret z
        ld c,29
        ld d,1
PutMenuStrings:
        push bc
        ld d,1
        call PutText
        pop bc
        ld a,c
        add a,7
        ld c,a
        cp 62
        jp nc,PutScrollArrows
        dec e
        jr nz,PutMenuStrings
        ret

FindMenuItem:
        ld hl,0
MenuAddr =$-2
        or a
        ret z
        push bc
        ld b,a
        xor a
DoGetMenuItem:
        ld c,255
        cpir
        djnz DoGetMenuItem
        pop bc
        ret

SetPowerupLimits:
        ld hl,PowerupNames
        ld bc,0D00h
        ld de,sPowerupLimits
SetNewPowerupLimits:
        xor a
        push bc
        ld c,255
        cpir
        push hl
        dec hl
        dec hl
        dec hl
        ld b,(hl)
        ld a,(de)
        add a,'0'
        ld (hl),a
        ld a,b
        pop hl
        sub '0'
        ld (de),a
        inc de
        pop bc
        add a,c
        ld c,a
        djnz SetNewPowerupLimits
        ld (de),a
        ret

CustomiseKeys:
        push af
        call DrawMenuBar
        ld bc,25*256+18
        ld d,3
        ld hl,KeysMsg
        call PutText
        pop af
        push af
        add a,'1'
        call PutChar
        call PutText
        pop af
        ld b,a
        add a,a
        add a,b
        add a,a
        add a,Player1Keys & 255
        ld e,a
        ld d,Player1Keys/256
        ld bc,6*256+29
DoGetCustomKeys:
        push bc
        push de
        ld b,24
        ld d,1
        call PutText
        push hl
        push bc
DoGetCustom:
        call WaitForKey
        cp K_EXIT
        jr z,DoGetCustom
        cp K_F5
        jr c,NotBadCustom 
        cp K_F1+1
        jr c,DoGetCustom
NotBadCustom:
        pop bc
        push af
        ld a,'O'
        ld d,1
        call PutChar
        ld a,'K'
        call PutChar
        ld a,c
        add a,7
        cp 64
        ld c,a
        jr c,NotScrollTextUp
        call ScrollTextUp
        push bc
        ld hl,-1
        ld de,-2
        ld bc,6Fh
        ld (hl),0
        lddr
        pop bc
NotScrollTextUp:
        pop af
        pop hl
        pop de
        ld (de),a
        inc de
        pop af
        ld b,a
        djnz DoGetCustomKeys
        ret
 
WaitForKey:
        call GET_KEY
Dowait:
        call GET_KEY
        or a
        jr z,Dowait
        ret

CheckYN:
        or a
        ld a,'N'
        ret z
        ld a,'Y'
        ret
CheckYNAscii:
        sub 'N'
        ret z
        ld a,1
        ret

Delay:
        ld hl,Timer
        ld (hl),0
DoDelay:
        cp (hl)
        jr nc,DoDelay
        ret

GetEnemyAnimList:
        ld e,a
        ld d,0
        ld hl,EnemyAnimLists
        add hl,de
        add hl,de
        jp LD_HL_MHL

InitSinglePlayerLevel:
        ld a,(Level)
        add a,a
        add a,a
        ld l,a
        ld h,0
        ld bc,LevelData
        ld e,l
        ld d,h
        add hl,hl
        add hl,hl
        add hl,de
        add hl,bc
;;        ld (Seed),hl    ;to make single player levels the same every time

        ld a,(hl)
        add a,a
        ld c,a
        add a,a
        add a,(hl)
        add a,36-63
        ld (BlockAnim),a
        ld a,c
        inc a
        ld (BlockSprite),a
        inc a
        ld (PillarSprite),a

        inc hl
        ld a,(hl)
        rrca
        rrca
        rrca
        cpl
        ld (BlockCover),a

        inc hl
        ld a,(hl)
        ld (TimeLimit),a
        inc hl

        ld de,PowerupLimits
        ld a,(hl)
        ldi
        ld b,3
        call LoadSinglePlayerPowerups
        ld b,4
        call LoadSinglePlayerPowerups
        ex de,hl
        ld (hl),0
        ex de,hl
        inc de
        inc b
        call LoadSinglePlayerPowerups
        ld (de),a

        ld a,(hl)
        ld (NumMonsters),a
        ld (EnemiesLeft),a
        inc hl

        push hl
        call InitGrid
        call InitEnemies
        pop de

        ld ix,EnemyInfo
        ld b,6
LoadSinglePlayerEnemies:
        ld a,(de)
        push de
        call GetEnemyAnimList
        ld a,(hl)
        ld (ix+pEnemyFlags),a
        bit eFast,a
        jr z,NotFastEnemy
        ld (ix+pSpeed),7
NotFastEnemy:
        inc hl
        ld (ix+pAnimList),l
        ld (ix+pAnimList+1),h
        inc hl
        inc hl
        ld a,(hl)
        cp 192
        jr c,NotBossY
        ld a,(ix+pY)
        sub 3
        ld (ix+pY),a
NotBossY:
        ld de,pEnemyInfoLen
        add ix,de
        pop de
        inc de
        djnz LoadSinglePlayerEnemies
        cp a
        ret

LoadSinglePlayerPowerups:
        ex de,hl
        ld (hl),0
        ex de,hl
        inc de
        ld c,b
LSPPLoop:
        add a,(hl)
        ldi
        djnz LSPPLoop
        ret

AddScore:
        ld a,(TotalPlayers)
        dec a
        ret nz
        ex de,hl
        ld hl,(Score)
        add hl,de
        ld (Score),hl
        ld a,(Score+2)
        adc a,0
        ld (Score+2),a
        rra
        rr h
        rr l
        rra
        rr h
        rr l
        ld c,13h
        ld d,1
        jp PutStatusNumHL

ShowHiScores:
        ld hl,HiScoresMsg
        call DrawMenu
        ld hl,HiScores
        ld c,29
        ld e,1
PutHiscores:
        push de
        push bc
        ld d,3
        ld a,e
        ld b,1
        call PutDigit
        ld a,'<'
        call PutChar
        ld d,1
        call PutText
        ld a,'<'
        call PutChar
        push hl
        call LD_HL_MHL
        ld d,3
        call PutNumHL
        pop hl
        inc hl
        inc hl
        pop bc
        pop de
        inc e
        ld a,c
        add a,7
        ld c,a
        cp 62
        jr c,PutHiscores
WaitHiscores:
        call WaitMenuKey
        jr c,WaitHiscores
        jp DoMainMenu

WinnerMsg       .db "player ",0," has won;",0
;ElimatedMsg     .db "player ",0," eliminated",0
LevelMsg        .db 3,"lev",1,0
ScoreMsg        .db 3,"sco",1,0
BonusMsg        .db "bonus ",0
ReadyMsg        .db "get ready;",0
TimeUpMsg       .db "time up;",0
GameOverMsg     .db "game over;",0
WaitMsg         .db "waiting<<<",0
BadVerMsg       .db "version conflict",0
PauseMsg        .db "paused"
NewHiMsg        .db 0,"new hiscore;",0
EnterNameMsg    .db 3,"enter your name:",1,0

StartupText     .db 28,16,"version 0<96",0
                .db 10,33,"matthew shepcar of",0
                .db 10,41,"icarus productions",0
                .db 16,57,"matthias brugger",0
                .db 40,26,1,"code by:",0
                .db 22,50,"gfx and ideas:",0
                .db 0

MainMenu:
#ifdef HELP
                .db 5
#endif
#ifndef HELP
                .db 4
#endif
                .db "main menu",0
                .db "start game",0
                .db "options"
HiScoresMsg     .db 0,"hiscores",0
#ifdef HELP
                .db "help",0
#endif
                .db "exit",0

LinkMenu        .db 0,"link mode",0

GameMenu        .db 5
                .db "game type",0
                .db "one player",0
                .db "warp to lev: "
StartLevAscii   .db "1"
MenuMaxLev      .db 1,0,1
                .db "two player",0
                .db "1p and link",0
                .db "2p and link",0

ChooseMenu      .db 0,"choose characters",0

OptionsMenu     .db 3
                .db "options",0
;                .db "players: "
;PlayersAscii    .db " ",2,0,1
                .db "player 1 keys",0
                .db "player 2 keys",0
                .db "multiplayer<<<",0

MultiplayerMenu .db 9
                .db "multiplayer",0
                .db "wins needed: "
WinsAscii       .db " ",9,0
                .db "allow steal: "
StealAscii      .db " ",0
                .db "capture flag: "
CTFAscii        .db " ",0
                .db "teleporters: "
TeleportAscii   .db " ",0
                .db "monsters: "
MonstersAscii   .db " ",6,0
                .db "intelligent: "
IntelligenceAscii .db " ",0
                .db "time limit: "
TimeAscii       .db " ",6,0
                .db "blocks: "
BlocksAscii     .db " ",7,0
                .db "extras<<<",0

KeysMsg         .db "player ",0," keys",0
                .db "left: ",0
                .db "right: ",0
                .db "up: ",0
                .db "down: ",0
                .db "fire: ",0
                .db "select: ",0

ExtrasMenu      .db 13
                .db "extras",0
PowerupNames    .db 8Fh," time:  ",8,0
                .db 90h," remote:  ",8,0
                .db 91h," bomb:  ",8,0
                .db 92h," range:  ",8,0
                .db 93h," boot:  ",8,0
                .db 94h," megabomb:  ",8,0
                .db 95h," grabber:  ",8,0
                .db 96h," zapper:  ",8,0
                .db 97h," shield:  ",8,0
                .db 98h," shovel:  ",8,0
                .db 99h," speed up:  ",8,0
                .db 9Ah," flamer:  ",8,0
                .db 9Bh," mystery:  ",8,0

CompletedText   .db 5
                .db "congratulations;",0

                .db "",0
                .db 3,"fantastic job;",0
                .db 3," ",1,"y",2,"o",3,"u",1,"c",2,"o"
                .db 3,"m",1,"p",2,"l",3,"e",1,"t",2,"e",3,"d ",0
                .db 3,"  bmberblke;  ",0
                .db "",0

#ifdef HELP
HelpText        .db 66
                .db "help",0
                                     
                .db 3
                .db "",0
                .db 3,"   bmberblke  ",0 ;hehe bimberblike :)
                .db 3,"  version <96 ",0
                .db 3,"  m p shepcar ",0
                .db "",0,0

                .db 3," objectives ",0,0
                .db 3,"1 player: ",1,"destroy",0
                .db "the evil enemies on",0
                .db "each of 10 levels<",0,0
                .db 3,"2 or more players:",0
                .db "you must obliterate",0
                .db "the opposition;",0,0
                .db 3,"capture the flag:",0
                .db "two to four players",0
                .db "carry an opponents",0
                .db "flag to your corner",0
                .db "to eliminate them<",0,0

                .db 3," extras ",0,0
                .db 8Fh," time: increases",0
                .db 80h," remaining time",0,0
                .db 90h," remote: detonate",0
                .db 80h," bombs manually",0,0
                .db 91h," bomb: increases",0
                .db 80h," number of bombs",0,0
                .db 92h," range: extends",0
                .db 80h," bomb range",0,0
                .db 93h," boot: lets you",0
                .db 80h," kick bombs about",0,0
                .db 94h," megabomb: blasts",0
                .db 80h," everything in its",0
                .db 80h," path",0,0
                .db 95h," grabber: pick up",0
                .db 80h," bombs next to you",0,0
                .db 96h," zapper: shoot and",0
                .db 80h," reverse opponents",0
                .db 80h," keys< stuns on 2nd",0
                .db 80h," hit;",0,0
                .db 97h," shield: protects",0
                .db 80h," you from danger",0,0
                .db 98h," shovel: dig away",0
                .db 80h," troublesome blocks",0,0
                .db 99h," speed up: lets you",0
                .db 80h," run faster",0,0
                .db 9Ah," flamethrower: burn",0
                .db 80h," baby burn; hehehe",0,0
                .db 9Bh," mystery: hmmm<<<",0,0
                .db ""
#endif

StartingPoints:
        .db 0,0
        .db 8,16
        .db 0,16
        .db 8,0

AlphaKeys       .db 2Eh,26h,1Eh,16h,0Eh
                .db 2Dh,25h,1Dh,15h,0Dh
                .db 2Ch,24h,1Ch,14h,0Ch
                .db 2Bh,23h,1Bh,13h,0Bh
                .db     22h,1Ah,12h,0Ah
                .db     21h,19h

GreyCounter             .db 0
BombFrame               .db 1
TransporterFrame        .db 1
TransporterSprite       .db 1
ProjectileFrame         .db 1

TransporterMask:
        .db 1Fh,1Fh,1Fh,1Fh,1Fh,1Fh
XorMask:
        .db 255,255,255,255,255,255
BlankMask:
        .db 1,1,1,1,1,1

#include sprites.asm
#include logo.asm


; Special abilities gained every 5 levels:
;  5: Speed
; 10: Remote
; 15: Nuke
; 20: Flame

EnemyAnimLists:
        .dw Blob,Snowman,Robot,Droid,Ghost,Knight,Player-1
        .dw Banana,BigMario,Penguin

BL  = 0 \SN  = 1 \RO  = 2 \DR  = 3 \GH  = 4
KN  = 5 \PL  = 6 \BA  = 7 \MA  = 8 \PE  = 9
SC1 = 0 \SC2 = 1 \SC3 = 2 \SC4 = 3 

NUMLEVELS = 15

LevelData:
;   Blocks Time Tim Bmb Rng Boo Grb Zap Shl Shv Mys Enemies            Level

.db SC1, 6, 12,  4,  8,  8,  4,  4,  0,  2,  0,  0, 3,BL,BL,BL, 0, 0, 0,0 ;1
.db SC2, 6, 12,  4,  8,  8,  4,  4,  0,  0,  0,  2, 3,SN,SN,SN, 0, 0, 0,0 ;2 
.db SC1, 6, 12,  4,  8,  8,  2,  4,  0,  4,  2,  2, 4,BL,SN,BL,SN, 0, 0,0 ;3
.db SC2, 6, 12,  4,  6,  6,  2,  3,  0,  2,  0,  2, 4,SN,SN,SN,SN, 0, 0,0 ;4
.db SC1, 4,  8,  4,  4,  4,  0,  0,  4,  0,  0,  8, 2,RO,RO, 0, 0, 0, 0,0 ;5

.db SC3, 6, 10,  4,  6,  6,  2,  3,  1,  2,  2,  4, 6,GH,GH,GH,GH,GH,GH,0 ;6
.db SC4, 4, 10,  2,  4,  4,  2,  2,  3,  1,  0,  2, 4,BL,BL,RO,RO, 0, 0,0 ;7
.db SC2, 4, 10,  2,  4,  4,  2,  2,  3,  1,  0,  2, 5,KN,KN,RO,RO,KN, 0,0 ;8
.db SC1, 6, 10,  0,  2,  2,  2,  2,  2,  2,  0,  4, 6,RO,RO,KN,KN,BL,BL,0 ;9
.db SC3, 2,  6,  4,  4,  4,  0,  2,  4,  2,  0,  8, 6,BL,RO,RO,BA,BA,GH,0 ;10

.db SC4, 4,  8,  4,  4,  4,  2,  2,  3,  2,  1,  4, 4,DR,DR,DR,DR, 0, 0,0 ;11
.db SC3, 5,  6,  4,  2,  4,  2,  2,  2,  1,  1,  4, 4,KN,DR,RO,BL, 0, 0,0 ;12
.db SC2, 4,  4,  8,  2,  4,  2,  2,  2,  1,  1,  4, 6,DR,RO,DR,RO,DR,RO,0 ;13
.db SC4, 3,  4,  8,  3,  4,  2,  1,  2,  1,  1,  4, 6,SN,GH,BL,RO,DR,KN,0 ;14
.db SC1, 2,  8,  2,  4,  4,  2,  0,  1,  1,  0,  8, 6,RO,RO,PE,PE,BA,GH,0 ;15

pY                      =0
pX                      =1
pPX                     =2
pPY                     =3
pBX                     =4
pBY                     =5
pDir                    =6
pAnim                   =7
pAnDir                  =8
pAnimList               =9
pSpr                    =11
pMask                   =12
pShieldAddr             =13
pFlagAddr               =15
pSpeed                  =17
pFrame                  =18
pStunLeft               =19

pEnemyFlags             =20

ePyroIntelligent        =0
eIntelligent            =1
eBombStealing           =2
eFast                   =3
eLaunchUgneps           =4
eDropSkins              =5
eZapsYou                =6
eWalkThroughWalls       =7

pLeftKey                =20
pRightKey               =21
pUpKey                  =22
pDownKey                =23
pBombKey                =24
pSelectKey              =25
pLink                   =20
pActiveItem             =26
pRange                  =27
pShovelLeft             =28
pPowerups               =29
;ppJCB                   =0
ppRemote                =1
ppBoot                  =2
ppGrabber               =3
ppNuke                  =4
pZapsLeft               =30
pShieldLeft             =31
pDizzyLeft              =32
pFlameLeft              =33
pMaxBombs               =34
pBombs                  =35
pSelectPause            =36
pFirePause              =37
pPowerUpFrame           =38

pEnemyInfoLen           =21
pOtherInfoLen           =13
pInfoLen                =40

Workspace               =0D900h

Settings                =0D794h
Player1Keys             =Settings
Player2Keys             =Settings+6
NumPlayers              =Settings+12
sLinkGameSettings       =Settings+13
sPowerupLimits          =Settings+13
sTotalPowerups          =Settings+26
sWinsNeeded             =Settings+27
sCTFGame                =Settings+28
sStealBombs             =Settings+29
sNumMonsters            =Settings+30
sTimeLimit              =Settings+31
sBlockCvg               =Settings+32
sTeleport               =Settings+33
sIntelligence           =Settings+34
MaxLevel                =Settings+35
HiScores                =Settings+36
SaveSettings            =Settings+116

Timer                   =Workspace
Powerups                =Workspace+1    ;num of each of 13 types of powerup left
RoundsWon               =Workspace+15   ;1 byte for each of 4 players
RemotePlayers           =Workspace+19   ;num players on other calc
TotalPlayers            =Workspace+20   ;total players in game
LinkKeys                =Workspace+21   ;key states for/from other calc
Level                   =Workspace+22   
Lives                   =Workspace+23   
DoorPos                 =Workspace+24
DoorSprite              =Workspace+25
DoorOpen                =Workspace+26
EnemiesLeft             =Workspace+27
Score                   =Workspace+28
ResetStats              =Workspace+31
LinkGameSettings        =Workspace+32
PowerupLimits           =LinkGameSettings
TotalPowerups           =LinkGameSettings+13
WinsNeeded              =LinkGameSettings+14
CTFGame                 =LinkGameSettings+15
StealBombs              =LinkGameSettings+16
NumMonsters             =LinkGameSettings+17
TimeLimit               =LinkGameSettings+18
BlockCvg                =LinkGameSettings+19
Teleport                =LinkGameSettings+20
Intelligence            =LinkGameSettings+21
EndLinkGameSettings     =LinkGameSettings+22
TimeFrame               =EndLinkGameSettings
TimeSpeed               =EndLinkGameSettings+2
TimePos                 =EndLinkGameSettings+4
TopBorder               =EndLinkGameSettings+6   ;copy of top of border on screen

Workspace2              =0DA00h
Grid                    =Workspace2      ;the playing grid!
ReversedSprites         =Workspace2+153
ReversedMasks           =Workspace2+153+Masks-StartFlipped
ReversedBigSprites      =Workspace2+153+BigSprites-StartFlipped
ReversedBossSprites     =Workspace2+153+BossSprites-StartFlipped
ReversedBossMasks       =Workspace2+153+BossMasks-StartFlipped
EndReversed             =ReversedSprites+EndFlipped-StartFlipped

Lists                   =EndReversed
NextBomb                =Lists       ;next free entry in bomb list
BombList                =Lists+1     ;4 bytes for each of up to 48 bombs
PlayerInfo              =BombList+(4*48)
EnemyInfo               =PlayerInfo+(pInfoLen*4)  
ShieldInfo              =EnemyInfo+(pEnemyInfoLen*8)
FlagInfo                =ShieldInfo+(pOtherInfoLen*4)
ProjectileInfo          =FlagInfo+(pOtherInfoLen*4)
AnimInfo                =ProjectileInfo+(pOtherInfoLen*4)
EndLists                =AnimInfo+(8*4)

GreyBuffer              =((EndLists-1) | 255)+1
INTTABLE                =GreyBuffer+400h

.end
