
#include asm86.h
#include ti86asm.inc
#include ti86abs.inc

.org _asm_exec_ram

	nop
	jp Start
	.dw 0,Name
Start:
        ld hl,LibName-1
        rst 20h
        rst 10h
        ret c
        call 460Bh
        call 4633h
        call _RAM_PAGE_1
        ld de,-4000h
        add hl,de
        sub d
        out (5),a
        ld d,81h
        push de
        ld b,e
Decompress:
        call lodsb
        or a
        ret z
        jp m,Compressed
        ld b,a
CopyStream:
        call lodsb
        ld (de),a
        inc de
        djnz CopyStream
        jr Decompress
Compressed:
        push hl
        ld c,a
        ld l,(hl)
        or 0F8h
        ld h,a
        ld a,c
        rra
        rra
        rra
        and 0Fh
        add a,3
        ld c,a
        add hl,de
        ldir
        pop hl
        call inchl
        jr Decompress

Settings:
Player1Keys     .db K_LEFT,K_RIGHT,K_UP,K_DOWN,K_SECOND,K_ALPHA
Player2Keys     .db K_STO,K_2,K_4,K_1,K_0,K_DOT
NumPlayers      .db 1
PowerupLimits   .db 0   ;time
                .db 4   ;remote
                .db 8   ;bombs+
                .db 8   ;range+
                .db 4   ;boot
                .db 4   ;nuke
                .db 4   ;grabber
                .db 4   ;zapper
                .db 4   ;shield
                .db 2   ;shovel
                .db 4   ;speed-up
                .db 0   ;flamethrower
                .db 8   ;mystery
TotalPowerups   .db 54
WinsNeeded      .db 5
CTFGame         .db 0
StealBombs      .db 1
NumMonsters     .db 4
TimeLimit       .db 3
BlockCvg        .db 7
Teleporters     .db 1
Intelligence    .db 0
MaxLevel        .db 1

HiScores        .db "norman<<<<<<<",0
                .dw 2500
                .db "fred bloggs<<",0
                .dw 2000
                .db "mr<blobby<<<<",0
                .dw 1500
                .db "tinky winky<<",0
                .dw 1000
                .db "gordon bennet",0
                .dw 500

SaveSettings:
        ld hl,OwnName-1
        rst 20h
        rst 10h
        call 460Bh
        call 521Dh
        ld de,_asm_exec_ram
        ld b,SaveSettings-_asm_exec_ram
DoSave:
        ex de,hl
        ld c,(hl)
        inc hl
        ex de,hl
        call _writeb_inc_ahl
        djnz DoSave
        ret

lodsb:
        ld a,(hl)
inchl:
        inc hl
        bit 7,h
        ret z
	ld h,a
        in a,(5)
        inc a
        out (5),a
	ld a,h
        ld h,40h
        ret

Name    .db "BomberBloke 0.96",0
LibName .db 5,"bloke"
OwnName .db 6,"bomber"

.end
