;************************************************************************
;*BBB   L     00    CC   K  K  EEE  DD      III  N   N   Version  1.3   *
;*B  B  L    0  0  C  C  K K   E    D D      I   NN  N      9/4/99      *
;*BBB   L    0  0  C     KK    EE   D  D     I   N N N                  *
;*B  B  L    0  0  C     K K   E    D  D     I   N  NN                  *
;*BBB   LLL   00    CCC  K  K  EEE  DDD     III  N   N  By Levi Lansing *
;************************************************************************
;
;--Best if viewed and compiled in Asm Studio 86
;--Use two space tab stops to line everything up (no variable width fonts!)
;--If it still looks bad, it's because I used Ti86pc as my font! (if you don't
;  have it, you can get it from Ti-Graph Link 86 (aka winlink).  I like the font a lot.
;
;email me! - puzzlesome@juno.com
;
;by the way, the star of the game is Bob (the little guy you navigate)




#include "asm86.h"
#include "ti86asm.inc"


_getcode		.equ		4068h			;1000's of clocks faster than _getky (AKA GET_KEY).

_cphlde			.equ		403Ch			;compares hl to de
_ldhlz  		.equ		437Bh			;loads b amount of zeros into data pointed to by hl


;The _plotSScreen is where the stuff on the graph is stored.
;It is located at C9FAh to CDF9h (1024 bytes).
;The following variables use this area to store temporary data-

Temp_Level		=		_plotSScreen			;C9FAh
Blank					=		_plotSScreen+20		;CA0Eh
Temp_Block_L	=		_plotSScreen+28		;CA16h
Temp_Block		=		_plotSScreen+52		;CA2Eh
BobX					=		_plotSScreen+60		;CA36h
BobY					=		_plotSScreen+61		;CA37h
Time_Delay		=		_plotSScreen+62		;CA38h
Level					=		_plotSScreen+63		;CA39h
Timer					=		_plotSScreen+65		;CA3Bh
Score					=		_plotSScreen+67		;CA3Dh
Bonus					=		_plotSScreen+69		;CA3Fh
CurSkill			=		_plotSScreen+71		;CA41h
VPTEMP				=		_plotSScreen+72		;CA42h


.org _asm_exec_ram			;Loads the Pragram into RAM and runs it

	nop																				;\
	jp Start1																	; \
.dw $0000																		;  \Ashell
.dw Title																		;  /stuff
Title:																			; /
	.db "Blocked  In  ver 1.3",0							;/


Start1:
 im 1          ;This is where we fix the down-left freeze (and 5 other combos)
 ld hl,$D400   ;I didn't make this code and don;t know how it works
 ld de,$D401
 ld bc,$0100
 ld (hl),$D3
 ldir
 ld hl,int_handler
 ld de,$D3D3
 ld bc,int_end-int_handler
 ldir
 ld a,$D4
 ld i,a
 im 2
 jr donepatch

int_handler:
 ex af,af'
 ld a,($C1B4)   ;_CXCURAPP
 cp $1D
 jr c,int_ok
 cp $20
 jr nc,int_ok
 im 1
 jp $0039
int_ok:
 in a,($03)
 bit 3,a
 jp z,$0039
 res 0,a
 out ($03),a
 jp $0039
int_end:
donepatch:  ;We have just fixed it!

	call _flushallmenus							;Exits all menus in the OS
	call _runindicoff								;turns the stupid run indicator off

	ld a,($C008)	;load contrast value
	cp 31					;check if the contrast is at max
	jr z,Start		;if it is, jump to start (don't increase it)
	inc a					;increase the contrast
	ld ($C008),a	;write it back to memory
	out (2),a			;and to the port

Start:
	call _clrScrn										;clears the screen and the text shaddow
	res plotloc,(iy+plotflags)			;
	res appTextSave,(iy+appflags)		;keeps the program from writing to the text shaddow
	res appAutoScroll,(iy+appflags)	;doesn't allow the screen to scroll automatically
	ld hl,_plotSScreen							;points hl to the graph shaddow memory
	ld b,76													;b = 76 bytes
	call _ldhlz											;clears (inserts 0's) into the first 26 bytes of the graph shaddow memory
	set textInverse,(iy+textflags)
	ld de,$0000											;0 -> d , 0 -> e
	ld (_curRow),de									;_curRow = d , _curCol = e
	ld hl,TitleText									;hl points to TitleText
	call _puts											;put TitleText (intro screen)
	res textInverse,(iy+textflags)
	ld de,$FD80											;points de to the middle of the display memory
	ld ix,Written										;points hl to the Written by.. Sprite
	ld de,$0303
	ld b,10													;bc = 128 bytes
by_Loop:													;loads bc amount of bytes from hl to de (puts to 128 x 8 sprite)
	call PutSprite
	inc d
	djnz by_Loop
	call Load_New_Level
	ld hl,Intro_Data
	ld de,Temp_Level
	ld bc,20
	ldir


Menu_Loop:							;checks for keys pressed in the intro screen and does stuff when they're pressed
	call Refresh_Background
	call _getcode						;check if a key has been pressed without pausing	
	cp K_EXIT							;check if it's Exit
	jp z,Exit							;jump if it is to Exit
	cp K_F1								;check if it's F1
	jp z,Start_Game				;jp if it is to Start_Game
	cp K_F2								;check if it's F2
	jr z,ViewScores				;jp if it is to ViewScores
	cp K_F3								;get the idea....
	jp z,Help
	cp K_F5
	jp z,Exit
	cp K_PLUS
	jr z,Contrast_Up
	cp K_MINUS
	jr z,Contrast_Down
	jr Menu_Loop					;jump to Menu_Loop
	
Contrast_Up:
	ld a,($C008)	;load contrast value
	inc a					;increase the contrast
	ld ($C008),a	;write it back to memory
	out (2),a			;and to the port
	cp 32
	jr z,Contrast_Down
	jr Menu_Loop

Contrast_Down:
	ld a,($C008)	;load contrast value
	dec a					;increase the contrast
	ld ($C008),a	;write it back to memory
	out (2),a			;and to the port
	cp 255
	jr z,Contrast_Up
	jr Menu_Loop

ViewScores:												;displays the high scores

	call _clrScrn										;clear the screen and text shaddow
	call _homeup										;load _curRow & _curCol with 0
	ld hl,HighScoreText							;hl points to HighScoreText
	set textInverse,(iy+textflags)	;turn inverse text on
	call _puts											;put the text
	ld a,(_curRow)									;_curRow -> a
	inc a														;a+1 -> a
	ld (_curRow),a									;a ->_curRow
	call _puts											;print the next line
	ld a,(_curRow)									;\
	inc a														; = (_curRow+1 -> _curRow)
	ld (_curRow),a									;/
	call _puts											;print the next line
	ld a,(_curRow)									;\
	inc a														; = (_curRow+1 -> _curRow)
	ld (_curRow),a									;/
	call _puts											;print the last line
	res textInverse,(iy+textflags)	;text to normal
	
	ld de,$0002						;0 ->d , 2 -> e
	ld (_curRow),de				;d -> _curRow , e -> _curCol
	ld hl,HighScore				;hl points to HighScore
	call _puts						;put it
	ld hl,(HighScoreE)		;hl points to HighScoreE (highscore for the easy levels)
	call _putHL						;jumps to _putHL until a ret is encountered (_putHL puts the Number in hl)
	ld de,$0004						;-- /\
	ld (_curRow),de				;---||
	ld hl,HighScoreE+2		;---||
	call _puts						;---||
	ld hl,(HighScoreM)		;---||
	call _putHL						;---||
	ld de,$0006						;---||
	ld (_curRow),de				;---||
	ld hl,HighScoreM+2		;---||
	call _puts						;---||
	ld hl,(HighScoreH)		;---||
	call _putHL						;---||
Score_Loop:
	call _getcode						;check if a key has been pressed
	cp 0									;check if no key was pressed
	jr z,Score_Loop				;if no key was pressed, loop
	cp K_CLEAR
	jr z,Clear_Scores
	jp Start							;jump to Start

Clear_Scores:
	call _clrScrn
	ld hl,Clear?
	ld de,$0002
	ld (_curRow),de
	call _puts
	ld de,$0007
	ld (_curRow),de
	set textInverse,(iy+textflags)
	call _puts
	res textInverse,(iy+textflags)
Clear_Loop:
	call _getcode
	cp K_F1
	jr z,Clear_em
	cp K_F2
	jp z, ViewScores
	jr Clear_Loop

Clear_em:
	ld hl,Defaults
	ld de,HighScore
	ld bc,61
	ldir	
	call SaveScore
	jp ViewScores


Help:										;displays the help text

	call _clrScrn					;clears the screen and the text shaddow
	ld de,0								;0 -> d , 0 -> e
	ld (_penCol),de				;d -> _penCol , e -> _penRow
	ld hl,HelpText				;hl points to HelpText
	call _vputs						;put the Text in the small font
	ld b,9								;9 -> b
Help_Loop:
	ld a,(_penRow)				;\
	add a,6								; - add 6 to _penRow
	ld (_penRow),a				;/
	ld a,0								;\_ load 0 into _penCol
	ld (_penCol),a				;/
	call _vputs						;put the next line in the small font
	djnz Help_Loop				;decrements b and if it's not 0, jump to Help_Loop
Help_Loop2:
	call _getcode						;check if a key has been pressed
	cp 0									;if no key was pressed,
	jp nz,Start						;jp to Start
	jr Help_Loop2					;if a key was pressed, loop


Start_Game:							;this is where the game beginins

	call _clrScrn					;clear the screen and the text shaddow
	call _homeup					;put the cursor position at 0,0
	ld de,$0002						;\_ cursor position to 0,2
	ld (_curRow),de				;/
	ld hl,Skill_Level			;hl points to text
	call _puts						;put the text (big)
	ld a,(Skill)					;Skill -> a
	inc a									;increment a
	ld b,a								;a -> b
	ld de,22							;22 ->de

Skill_Loop:
	add hl,de							;point hl 22 (de) bytes ahead of whrer is is currently
	djnz Skill_Loop				;decrement b and jp if it isn't 0, to Skill_Loop
	sbc hl,de							;hl points to far ahead because Skill was incremented to be between 1 & 3,
												;so, this points hl 22 bytes in the other direction
	ld de,$0007						;\_ 0 -> _curRow , 7 -> _curCol
	ld (_curRow),de				;/
	call _puts						;put text in hl on the screen
Start_Game_Loop:
	call _getcode					;check if a key was pressed
	cp K_EXIT							;if it was Exit
	jp z,Start						;jump to Start
	cp K_F1								;if it was F1
	jr z,Easy							;jump to Easy
	cp K_F3								;etc...
	jr z,Medium						;etc...
	cp K_F5								;etc...
	jr z,Hard							;etc...
	jr Start_Game_Loop		;jump to Start_Game_Loop

Easy:
	ld hl,1								;0 -> h , 1 -> l
	ld (Level),hl					;hl -> Level (Level is two bytes)
	ld a,1								;1 -> a
	ld (CurSkill),a				;1 -> CurSkill
	jr Start_New					;jump to Start_New
Medium:
	ld a,(Skill)					;skill -> a
	cp 0									;if skill level is 0
	jr z,Start_Game_Loop	;go back, you can't play the medium levels
	ld hl,11							;0 -> h , 11 -> l
	ld (Level),hl					;hl -> Level (Level is 2 bytes long)
	ld a,2								;2 -> a
	ld (CurSkill),a				;2 -> CurSkill (so I know which set of levels you're playing)
	jr Start_New					;jump to Start_New
Hard:
	ld a,(Skill)						;Skill -> a
	cp 2										;check if a = 2
	jr nz,Start_Game_Loop		;if it doesn't, you're not qualified for the hard levels
	ld hl,21
	ld (Level),hl						;21 ->Level
	ld a,3
	ld (CurSkill),a					;3 -> CurSkill (So I know which set of levels you're playing)
	
Start_New:
	call _clrScrn					;clear the screen and the text shaddow
	ld hl,0
	ld (Score),hl					;0 -> Score
LoadNewLevel:
	call Load_New_Level
	jr continue

										;This is the first complicated part...
Load_New_Level:
						;a random routine by Jimmy Mardell
 	ld b,4				;4 -> b (integer between 0 and 3)
 	ld a,r				;r -> a - donno what r is ?? (some thing fairly random I guess
 	add a,a				;doubles a
 	ld hl,0				;0 -> h , 0 -> l
 	ld d,0				;0 -> d
 	ld e,a				;a -> e
RMul:
 	add hl,de			;adds de to hl and stores it in hl
								;e will be added to l until it's greater than 255, then a 1 is put in h and 0 into l
 	djnz RMul			;decrement b and if it isn't 0 jump to RMul
 	ld a,h				;h -> a
						;end of the random routine

	inc a						;increment a so it's between 1 and 4
	cp 1						;check if a = 1
	jr nz,Two				;if it isn't, goto Two and check if it's 2
	ld hl,Block1		;hl points to Block1
	jr Load_Block		;jump to Load_Block

Two:							;the same as above, but checks if a = 2
	cp 2
	jr nz,Three
	ld hl,Block2
	jr Load_Block
Three:						;the same, but checks if a = 3
	cp 3
	jr nz,Four
	ld hl,Block3
	jr Load_Block
Four;							;if a <> 1, 2, or 3, then it = 4...
	ld hl,Block4		;hl points to Block4

Load_Block:
	ld de,Temp_Block_L		;points de to Temp_Block_L
	ld bc,24							;24 -> bc (24 bytes to copy)
	ldir									;copies 24 bytes of hl into de (temporary storage to be manipulated and not destroyed
	ret

continue:
	ld a,20								;20 -> a
	ld (Time_Delay),a			;a -> Time_Delay

	ld hl,(Level)					;\_ loads the level into l
	ld b,l								;/
	ld ix,Times-1					;points ix to 1 bytes before Times
inc_ix:
	inc ix								; points ix forward 1 bytes
	djnz inc_ix						;loop b amount of times
	ld h,0								;0 -> h
	ld a,(ix)							;level time -> a
	ld l,a								;a -> l
	ld (Timer),hl					;level time -> Timer

	ld hl,(Level)					;level -> hl
	ld b,l								;l -> b (the level number)
	ld ix,Bonuses-1				;ix points 1 byte behind of ix
inc_ix2:
	inc ix								;point ix 1 byte forward
	djnz inc_ix2					;decrement b and if it isn't 0, jump to inc_ix2
	ld h,0								;0 -> h
	ld a,(ix)							;level bonus -> a
	ld l,a								;a -> l
	ld (Bonus),hl					;level bonus -> Bonus

;**************************************************************************
;**If you're just learning the asm language, that's the end of the highly**
;**detailed, step-by-step instructions.  From here on out, I'm just going**
;**explain what I'm doing and why because it's a little more complicated.**
;**************************************************************************

Refresh_Old_Level:
	call Level_To_Temp			;loads the current level into a temporary variable
	call Refresh_Background	;puts the blocks, and the goal on the screen
	ld hl,Temp_Level+16			;this is where the Bob's coords are
	ld a,(hl)
	ld (BobX),a
	ld d,a
	inc hl
	ld a,(hl)
	ld (BobY),a
	ld e,a
	ld ix,Bob
	call PutSprite					;puts Bob where he belongs

PutSideBar:					;this puts the stuff on the side; I'll explain one-
	ld de,$0000				;0 -> d, 0-> e
	ld (_penCol),de		;d -> (_penCol), e -> (_penRow)
	ld hl,SideBar			;SideBar text -> hl
	call _vputs				;put small font
	ld de,$0D00
	ld (_penCol),de
	call _vputs
	ld de,$1A00
	ld (_penCol),de
	call _vputs
	ld de,$2700
	ld (_penCol),de
	call _vputs
	ld de,$0600
	ld (_penCol),de
	ld hl,(Level)
	call _vputHL			;_vputHL is a routine (Later in the program) that turns
										;a number in hl (0-65535) into text and puts in the small font
	ld de,$1300
	ld (_penCol),de
	ld hl,(Score)
	call _vputHL
	ld de,$2000
	ld (_penCol),de
	ld hl,(Bonus)
	call _vputHL
	ld de,$2D00
	ld (_penCol),de
	ld hl,(Timer)
	call _vputHL


Main_Loop:
	call Refresh_Background	;puts the blocks, and the goal on the screen

	ld a,(Time_Delay)		;the time delay makes the time run slower
	dec a
	ld (Time_Delay),a
	cp 0
	jr nz, no_Time_Dec	;if the time delay = 0, then it's reset and the timer is decremented
	ld a,20
	ld (Time_Delay),a
	ld hl,(Timer)
	dec hl
	ld (Timer),hl
	ld de,0
	call _cphlde			;compares hl and de
	jp z,TimeUp
no_Time_Dec:
	ld de,$2D00
	ld (_penCol),de
	ld hl,(Timer)
	call _vputHL			;this puts the time left

	ld de,$2000
	ld (_penCol),de
	ld hl,(Bonus)
	call _vputHL			;this puts the bonus left

	call _getcode			;works just like _getky or GET_KEY, but supposed to be faster
	cp K_EXIT
	jp z,CheckScore		;check if you have a high score
	cp K_LEFT
	jr z,Left					;move left if Bob can
	cp K_RIGHT
	jp z,Right				;move right if Bob can
	cp K_UP
	jp z,Up						;Move up if Bob can
	cp K_DOWN
	jp z,Down					;move down if Bob can
	cp K_SECOND
	jr z,Second				;reset the level
	cp K_MORE
	jr z,Pause				;pause
	jp Main_Loop

;***************************************************
;*----Stuff that happens after a key is pressed----*
;***************************************************


Exit:
	set plotloc,(iy+plotflags)				;lets the graph write to the graph buffer
	set appTextSave,(iy+appflags)			;saves the text to the text shaddow
	set appAutoScroll,(iy+appflags)		;lets the screen scroll
	set graphdraw,(IY+graphflags)			;tells the calc that the graph is "dirty"
																		;so it will redraw it
	call _clrScrn	;clear the screen and text shaddow
	call _homeup	;cur = 0,0
	ld a,($C008)	;load contrast value
	dec a					;increase the contrast
	ld ($C008),a	;write it back to memory
	out (2),a			;and to the port
	ret						;return to the OS

Pause:
	call _clrScrn			;clear the screen
	call _homeup			;cur to 0,0
	ld hl,Paused
	call _puts				;display paused text
Paused_Loop:
	call _getcode
	cp 0
	jr z,Paused_Loop	;loop until a key is pressed
	call _clrScrn
	ld a,(BobX)
	ld d,a
	ld a,(BobY)
	ld e,a
	ld ix,Bob
	call PutSprite		;put Bob where he belongs
	jp PutSideBar			;put the side bar and then continue on with the game

Second:
	call _clrScrn
	jp Refresh_Old_Level	;this will reset the level



Left:										;This is where it gets a little confusing!
	ld a,(BobX)
	ld d,a								;x-coord into d
	dec d									;to see where Bob is if he moves left
	ld a,(BobY)
	ld e,a								;y-coord into e
	ld a,(Temp_Level+18)
	ld h,a								;x-coord of goal into h
	ld a,(Temp_Level+19)
	ld l,a								;y-coord of goal into l
	call _cphlde					;compare hl and de
	jp z,Finish						;if they're equal, you passed the level

	ld a,(BobY)
	ld b,a								;y-coord into b
	inc b									;increment b incase it's 0 (I know it can't bo 0, but
												;in a later version it might be possible
	ld hl,Temp_Level-2
Inc_HL_L:
	inc hl
	inc hl
	djnz Inc_HL_L		;if the y-coord was 0, then hl points to the first byte
									;of the temp level.  It moves hl forward 2 bytes for each line
	ld a,(BobX)
	inc a						;To make x-coord between 1 & 16 rather than 0 & 15
	cp 3
	jp z,Main_Loop	;If Bob is as far left as he can go, return to the main loop
	cp 8						;if the x-coord is 8, then when 8 is subtracted, the answer is
	jr z,sub8L			;considered positive and the program thinks that it wants to
									;move to the next byte.  So, we have to skip the test.
	cp 9				;Same goes for 9 except the program's right to move ahead 1 byte.
	jr z,sub8L	;It's also wrong because it can't look ahead to see that it needs
							;to check for a block or a space to the left (in the first byte).
	inc hl			;move ahead one byte so we don't have to do it later
	ld b,a			;a -> b incase a is smaller than 8
	sub 8				;a-8 -> a
	jp p,sub8L	;if it's positive, there's no need to restore a
	ld a,b			;if it's negative, you need to restore a
	dec hl			;and move hl back to where it was
sub8L:
	ld b,a			;stores a in b for the loop
	ld d,a			;1 -> d for storage so we know how many times to rotate a back to normal
	ld a,(hl)		;the piece of the tmp level map is moved to a for easier access
	rrca				;rotate a one bit to the right so if a = 1, it will still be normal
							;in case you don't know, rrca takes the binary equivalent	and rotates
							;one bit to the right circular, meaning bit 0 (the begining) is moved
							;to bit 7 (the end), and the carry flag is = to bit 7.
Rotate_aL:	
	rlca				;does the same as rrca, but to the right and the carry flag = bit 0
	djnz Rotate_aL
	jr c,BlockL		;if the carry flag was set, it means there is a block to the left
	jr Move_Left	;if there isn't a block on the left, just move Bob left

Nine_L:
	dec hl					;move to the previous byte of the temp level map
	bit 0,(hl)			;check if there is a block on the right edge of the byte
	jp nz,Main_Loop	;if there is a block in the way, jump to the main loop
	set 0,(hl)			;since there isn't a block, we have to make a block here
	inc hl					;move to the next block
	res 7,(hl)			;and remove the old block
	jr Move_Left		;then move Bob left

BlockL:
	ld b,a					;save the rotated piece of the temp level map for later
	ld a,(BobX)
	cp 3						;if the x-coord is 3, then the block is against the edge
	jp z,Main_Loop
	cp 9						;if the x-coord is 9, we need to move to the previous byte
	jr z,Nine_L
	ld a,b					;a = the rotated piece of the templevel map again
	rrca						;rotate right circular twice
	rrca
	jp c,Main_Loop	;if there is a block to the left of the block that's on the
									;of Bob, he can't push it.  Go back to the main loop.
	set 7,a					;if there isn't a block there, make one there
	rlca
	res 7,a					;and remove the block to the left of Bob
	ld b,d					;b = the # of times to rotate a back to normal
	rlca						;rotate left circular twice to make up for rotating it right twice
	rlca
Rotate_Back_L:
	rrca
	djnz Rotate_Back_L
	ld (hl),a								;save a in the temporary level map

Move_Left:
	ld hl,(Bonus)
	ld a,l					;since the bonus is going to be less than $FF (255) h will be 0
	cp 0
	jr z,NOBonus_L
	dec hl					;if there is some bounus left, decrement it
	ld (Bonus),hl
NOBonus_L:

	ld a,(BobX)
	ld d,a
	ld a,(BobY)
	ld e,a
	ld ix,Blank
	call PutSprite	;erase where Bob was,
	ld a,(BobX)
	dec a						;move him left
	ld (BobX),a
	ld d,a
	ld ix,Bob
	call PutSprite	;and draw him
	jp Main_Loop		;jump to the main loop to continue


Right:						;almost the same as going left, but diferent variables, and
									;oppisite directions.  So refer to the left routine for more details
	ld a,(BobX)
	ld d,a
	inc d
	ld a,(BobY)
	ld e,a
	ld a,(Temp_Level+18)
	ld h,a
	ld a,(Temp_Level+19)
	ld l,a
	call _cphlde		;if Bob just moved into the goal, you passed the level
	jp z,Finish

	ld a,(BobY)
	ld b,a
	inc b
	ld hl,Temp_Level-1
Inc_HL_R:
	inc hl
	inc hl
	djnz Inc_HL_R
	ld a,(BobX)
	inc a							;To make x-coord between 1 & 16 rather than 0 & 15
	cp 16
	jp z,Main_Loop
	cp 8
	jr z,Eight_R
	ld b,a
	sub 8
	jp p,Positive_R
	ld a,b
	dec hl
Positive_R:
	ld b,a
	ld d,a
	ld a,(hl)
Rotate_aR:
	rlca
	djnz Rotate_aR
	rlca
	jr c,BlockR
	jr Move_Right

Eight_R:
	ld d,0
	ld a,(hl)
	rlca
	jr c,BlockR
	jr Move_Right
	
Six_R:
	inc hl
	bit 7,(hl)
	jp nz,Main_Loop
	set 7,(hl)
	dec hl
	res 0,(hl)
	call Refresh_Background
	jr Move_Right

BlockR:
	ld b,a
	ld a,(BobX)
	cp 14
	jp z,Main_Loop
	cp 6
	jr z,Six_R
	ld a,b
	rlca
	jp c,Main_Loop
	set 0,a
	res 1,a
	rrca
	ld b,a
	ld a,d
	cp 0
	jr z,No_Rotate_Back_R
	ld a,b
	ld b,d
Rotate_Back_R:
	rrca
	djnz Rotate_Back_R
	ld b,a
No_Rotate_Back_R:
	ld a,b
	rrca
	ld (hl),a
	call Refresh_Background

Move_Right
	ld hl,(Bonus)
	ld a,l
	cp 0
	jr z,NOBonus_R
	dec hl
	ld (Bonus),hl
NOBonus_R:

	ld a,(BobX)
	ld d,a
	ld a,(BobY)
	ld e,a
	ld ix,Blank
	call PutSprite
	ld a,(BobX)
	inc a
	ld (BobX),a
	ld d,a
	ld ix,Bob
	call PutSprite
	jp Main_Loop


Up:
	ld a,(BobX)
	ld d,a
	ld a,(BobY)
	ld e,a
	dec e
	ld a,(Temp_Level+18)
	ld h,a
	ld a,(Temp_Level+19)
	ld l,a
	call _cphlde
	jp z,Finish

	ld a,(BobY)
	cp 0
	jp z,Main_Loop
	ld b,a
	inc b
	ld hl,Temp_Level-3
INC_Y_U:
	inc hl
	inc hl
	djnz INC_Y_U
	ld a,(BobX)
	inc a									;make x-coord between 1 and 16
	ld b,a
	cp 8
	jr z,No_Sub_U
	sub 8
	jp p,Positive_U
No_Sub_U:
	ld a,b
	dec hl
Positive_U:
	dec hl
	dec hl
	ld c,(hl)
	inc hl
	inc hl
	ld b,a
	ld d,a
	ld a,(hl)
Rotate_U:
	rlc c
	rlca
	djnz Rotate_U
	jr c,Block_U
	jr Move_Up	

Block_U:
	ld b,a
	ld a,(BobY)
	cp 1
	jp z,Main_Loop
	bit 0,c
	jp nz,Main_Loop
	set 0,c
	ld a,b
	res 0,a
	ld b,d
Rotate_Back_U:
	rrc c
	rrca
	djnz Rotate_Back_U
	ld (hl),a
	dec hl
	dec hl
	ld (hl),c	
	call Refresh_Background

Move_Up:
	ld hl,(Bonus)
	ld a,l
	cp 0
	jr z,NOBonus_U
	dec hl
	ld (Bonus),hl
NOBonus_U:

	ld a,(BobY)
	ld e,a
	dec a
	ld (BobY),a
	ld a,(BobX)
	ld d,a
	ld ix,Blank
	call PutSprite
	dec e
	ld ix,Bob
	call PutSprite
	jp Main_Loop




Down:
	ld a,(BobX)
	ld d,a
	ld a,(BobY)
	ld e,a
	inc e
	ld a,(Temp_Level+18)
	ld h,a
	ld a,(Temp_Level+19)
	ld l,a
	call _cphlde
	jp z,Finish

	ld a,(BobY)
	cp 7
	jp z,Main_Loop
	ld b,a
	inc b
	ld hl,Temp_Level+1
INC_Y_D:
	inc hl
	inc hl
	djnz INC_Y_D
	ld a,(BobX)
	inc a									;make x-coord between 1 and 16
	ld b,a
	cp 8
	jr z,No_Sub_D
	sub 8
	jp p,Positive_D
No_Sub_D:
	ld a,b
	dec hl
Positive_D:
	inc hl
	inc hl
	ld c,(hl)
	dec hl
	dec hl
	ld b,a
	ld d,a
	ld a,(hl)
Rotate_D:
	rlc c
	rlca
	djnz Rotate_D
	jr c,Block_D
	jr Move_Down	

Block_D:
	ld b,a
	ld a,(BobY)
	cp 6
	jp z,Main_Loop
	bit 0,c
	jp nz,Main_Loop
	set 0,c
	ld a,b
	res 0,a
	ld b,d
Rotate_Back_D:
	rrc c
	rrca
	djnz Rotate_Back_D
	ld (hl),a
	inc hl
	inc hl
	ld (hl),c	
	call Refresh_Background

Move_Down:
	ld hl,(Bonus)
	ld a,l
	cp 0
	jr z,NOBonus_D
	dec hl
	ld (Bonus),hl
NOBonus_D:

	ld a,(BobY)
	ld e,a
	inc a
	ld (BobY),a
	ld a,(BobX)
	ld d,a
	ld ix,Blank
	call PutSprite
	inc e
	ld ix,Bob
	call PutSprite
	jp Main_Loop






;*****************************
;*-------Some Routines-------*
;*****************************

Level_To_Temp:
	ld de,(Level)
	ld b,e
	ld de,20
	ld hl,Level_Data-20
Level_Loop:
	add hl,de
	djnz Level_Loop
	ld de,Temp_Level
	ld bc,20
	ldir
	ret

Refresh_Background:
	ld hl,Temp_Block_L
	ld de,Temp_Block
	ld bc,8
	ldir
	ld hl,Temp_Block_L+8
	ld de,Temp_Block_L
	ld bc,8
	ldir
	ld hl,Temp_Block_L+16
	ld de,Temp_Block_L+8
	ld bc,8
	ldir
	ld hl,Temp_Block
	ld de,Temp_Block_L+16
	ld bc,8
	ldir

	ld hl,Temp_Level-1
	ld c,0
	ld b,8
	ld de,0
Next_Loop:
	push bc
Next_Loop2:
	ld b,8
	inc hl
	ld a,(hl)	
Again_B:
	rla
	jr nc,Next_B
	ld ix,Temp_Block
	call PutSprite
Next_B:
	inc d
	djnz Again_B
	ld a,d
	cp 8
	jr z,Next_Loop2
	ld d,0
	inc e
	push de
	ld ix,Temp_Level+18
	ld a,(ix)
	ld d,a
	inc ix
	ld a,(ix)
	ld e,a
	ld ix,Goal
	call PutSprite
	pop de
	pop bc
	djnz Next_Loop
	ret

TimeUp:
	ld de,$0703
	ld (_curRow),de
	ld hl,TimeUP
	set textInverse,(iy+textflags)
	call _puts
	res textInverse,(iy+textflags)
	ld b,30
T_Loop:
	push bc
	call Refresh_Background
	ld de,$0703
	ld (_curRow),de
	ld hl,TimeUP
	set textInverse,(iy+textflags)
	call _puts
	res textInverse,(iy+textflags)
	halt
	halt
	halt
	halt
	halt
	halt
	halt
	pop bc
	djnz T_Loop
	jp CheckScore

Finish:
	ld de,(Timer)
	ld hl,(Score)
	add hl,de
	add hl,de
	ld de,(Bonus)
	add hl,de
	add hl,de
	ld (Score),hl
	ld hl,(Level)
	inc hl
	ld (Level),hl
	ld a,l
	cp 11
	jr nz,SKILL1
	ld a,(Skill)
	cp 0
	jr nz,Passed
	inc a
	ld (Skill),a
	call SaveScore
	jr Passed
SKILL1:
	cp 21
	jr nz,SKILL2
	ld a,(Skill)
	cp 1
	jr nz,Passed
	inc a
	ld (Skill),a
	call SaveScore
	jr Passed
SKILL2:
	cp 31
	jr z,Passed
	call _clrScrn
	jp LoadNewLevel

Passed:
	call _clrScrn
	call _homeup
	ld hl,Congrats
	call _puts
	ld de,(Level)
	ld a,e
	cp 11
	jr z,PutLevel
	cp 21
	jr nz,HardL
	ld de,22
	add hl,de
	jr PutLevel
HardL:
	ld de,44
	add hl,de
PutLevel:
	call _puts
	ld de,$2E10
	ld (_penCol),de
	ld hl,C_Score
	call _vputs
	set textEraseBelow,(iy+textflags)
	set textInverse,(iy+textflags)
	ld a,$56
	ld (_penCol),a
	ld a,' '
	call _vputmap
	ld hl,(Score)
	call _vputHL
	res textEraseBelow,(iy+textflags)
	res textInverse,(iy+textflags)
Pass_Loop:
	call _getcode
	cp 0
	jr z,Pass_Loop


CheckScore:
	ld de,(Score)
	ld a,(CurSkill)
	cp 1
	jr nz,MediumScore
	ld hl,(HighScoreE)
	call _cphlde
	jp nc,ViewScores
	ld (HighScoreE),de
	jr New_HighScore
MediumScore:
	cp 2
	jr nz,HardScore
	ld hl,(HighScoreM)
	call _cphlde
	jp nc,ViewScores
	ld (HighScoreM),de
	jr New_HighScore
HardScore:
	cp 3
	jr nz,HardScore
	ld hl,(HighScoreH)
	call _cphlde
	jp nc,ViewScores
	ld (HighScoreH),de
	jr New_HighScore


New_HighScore:
	call _clrScrn
	call _homeup
	ld hl,NewHS
	call _puts
	ld de,$0003
	ld (_curRow),de
	ld ix,HighScore
	ld a,(CurSkill)
	cp 1
	jr z,EnterName
	cp 2
	jr nz,HardHS
	ld de,20
	add ix,de
	jr EnterName
HardHS:
	ld de,40
	add ix,de
EnterName
	set curAble,(iy+curflags)
	ld b,14
	res shiftLwrAlpha,(iy+shiftflags)
ALPHA:
	bit shiftLwrAlpha,(iy+shiftflags)
	jr z,lower
	res shiftLwrAlpha,(iy+shiftflags)
	jr EnterName_Loop
lower:
	set shiftLwrAlpha,(iy+shiftflags)
EnterName_Loop:
	push bc
	call _getky
	pop bc
	cp K_ENTER
	jr z,Saveit
	cp K_LEFT
	jr z,Delete
	cp K_DEL
	jr z,Delete
	cp K_ALPHA
	jr z,ALPHA
	ld c,a
	ld a,b
	cp 0
	jr z,EnterName_Loop
	ld a,c
	cp $09
	jr c,EnterName_Loop
	cp $2F
	jr nc,EnterName_Loop

	push bc
	sub 9
	ld b,a
	ld hl,CharTable-1
CharLoop:
	inc hl
	djnz CharLoop
	pop bc
	ld a,(hl)
	cp 0
	jr z,EnterName_Loop
	cp ' '
	jr z,CAPS
	bit shiftLwrAlpha,(iy+shiftflags)
	jr nz,CAPS
	add a,32
CAPS: 
	ld (ix),a
	inc ix
	call _putc
	dec b
	jr EnterName_Loop

Delete:
	ld a,b
	cp 14
	jr z,EnterName_Loop
	res curAble,(iy+curflags)
	ld a,' '
	call _putc
	ld hl,_curCol
	dec (hl)
	dec (hl)
	call _putc
	dec (hl)
	inc b
	dec ix
	ld (ix),'.'
	set curAble,(iy+curflags)
	jr EnterName_Loop

Saveit:
	res curAble,(iy+curflags)
	ld a,b
	add a,3
	ld b,a
Dots:
	ld (ix),'.'
	inc ix
	djnz Dots
	res shiftALock,(iy+shiftflags)
	res shiftAlpha,(iy+shiftflags)
	call SaveScore
	jp ViewScores

_vputHL:              ;Writes hl on screen (Small font)
 ld de,VPTEMP+3       ;location to start unpacking
 ld b,4               ;4 digits
_vputHL_2:            ;Begin loop
 call UNPACK_HL       ;divide hl by 10 - a contains remainder
 add a,'0'            ;asciiize it
 ld (de),a            ;store digit
 dec de               ;de points to next digit place
 djnz _vputHL_2       ;decrease b - repeat if not zero
 ld hl,VPTEMP         ;hl points to number
 call _vputs          ;write number on screen
 ret                  ;return

_putHL:               ;Writes hl on screen (Large Font)
 ld de,VPTEMP+3       ;location to start unpacking
 ld b,4               ;4 digits
_putHL_2:            ;Begin loop
 call UNPACK_HL       ;divide hl by 10 - a contains remainder
 add a,'0'            ;asciiize it
 ld (de),a            ;store digit
 dec de               ;de points to next digit place
 djnz _putHL_2       ;decrease b - repeat if not zero
 ld hl,VPTEMP         ;hl points to number
 call _puts          ;write number on screen
 ret                  ;return

delay:
	push bc
	ld b,100
D_Loop:
	halt
	halt
	djnz D_Loop
	pop bc
	ret

;****Taken From ZTetris, But the bytes to copy and some labels were modified

SaveScore:								 ;Saves The New High Score
	ld hl,ProgName        ; All this stuff is to make sure the hiscore table
	rst 20h	       ; and resume stuff are stored in the variable
	rst 10h
	ex de,hl	       ; HL -> start of variable
	ld a,b
	ld de,HighScore-$D748+4  ; DE = relative offset to stuff to store (-4)
	add hl,de
	adc a,0	       ; Next block if necessary
	ld de,HighScore	       ; DE = start of bytes to copy
	ld b,61	       ; 61 bytes to copy
RepCopy:
	push af
	push hl
	call $46C3
	ld a,(de)	       ; Read
	ld (hl),a	       ; And save it in the real variable
	pop hl
	pop af
	call $4637
	inc de
	djnz RepCopy
	ret

;************************************************
;* PutSprite -- By Levi Lansing                 *
;*  Input:                                      *
;*      (d,e) = pos -- (0,0) to (16,8)          *
;*      ix = Sprite (8 by 8)                    *
;*  Output:                                     *
;*      Your sprite right over the top of       *
;*      everything!	(0 clears the pixel and     *
;*      1 turns on the pixel)                   *
;*  Changed:                                    *
;*      ix (points to the next Sprite or Data)  *
;************************************************

PutSprite:
	push hl				;hide these so they don't get changed
	push af				;"
	push bc				;"
	ld c,d				
	ld b,e				;bc now = the coords of the image
	push de				;hide de so it won't get changed
	ld hl,$FB80		;Point 8 lines infront of the video memory (128 bytes)
								;(the video mem starts at FC00)
	inc b					;add 1 to b incase it's 0
	ld de,128			;# Of Bytes Per 8 Lines
YCoord:
	add hl,de			;point hl forward 8 lines
	djnz YCoord
	add hl,bc			;Now HL Points To the video memory + the offset
	ld de,16			;# of bytes per 1 line
	ld b,8				;# of lines in the sprite
Putit:
	ld a,(ix)			;data of the first line of the sprite into a
	ld (hl),a			;then onto the screen
	add hl,de			;increase hl to point to the next line
	inc ix				;increase ix to point to the next line of the sprite
	djnz Putit		;loop 8 times
	pop de				;then restore the variables that were hidden
	pop bc				;in the oppisite order they were pushed
	pop af				;to make sure they get the right values
	pop hl
	ret						;End Of The Routine


;******************************
;*-----Graphics / Sprites-----*
;******************************

Written:

	.db %11111111
	.db %11011101
	.db %11011101
	.db %11010101
	.db %11101011
	.db %11111111
	.db %11111111
	.db %11111111

	.db %11111111
	.db %11101101
	.db %00111000
	.db %01101101
	.db %01101101
	.db %11111111
	.db %11111111
	.db %11111111

	.db %11111111
	.db %11011111
	.db %10001001
	.db %11011011
	.db %11011101
	.db %11111111
	.db %11111111
	.db %11111111


	.db %11111111
	.db %11111101
	.db %00111101
	.db %01011100
	.db %01011100
	.db %11111111
	.db %11111111
	.db %11111111

	.db %11111111
	.db %11111110
	.db %11111110
	.db %10101110
	.db %11011110
	.db %10111111
	.db %11111111
	.db %11111111

	.db %11111111
	.db %11111111
	.db %11100101
	.db %11101101
	.db %00110110
	.db %11111111
	.db %11111111
	.db %11111111

	.db %11111111
	.db %11011101
	.db %01111101
	.db %01011101
	.db %11011100
	.db %11111111
	.db %11111111
	.db %11111111

	.db %11111111
	.db %11111111
	.db %11000100
	.db %11010101
	.db %01100101
	.db %11111111
	.db %11111111
	.db %11111111

	.db %11111111
	.db %11111101
	.db %11100111
	.db %01101101
	.db %01001101
	.db %11111111
	.db %11111111
	.db %11111111

	.db %11111111
	.db %11111111
	.db %00110011
	.db %01010011
	.db %01011011
	.db %11100111
	.db %11111111
	.db %11111111


Bob:
	.db %00011000
	.db %00100100
	.db %00011000
	.db %01111110
	.db %00011000
	.db %00111100
	.db %00100100
	.db %00100100


Block1:							;The following are the blocks which have 4 shades to them
	.db %00000000			;
	.db %01111110			;pixels that show up once in the
	.db %01000010			;three different sprites are light gray
	.db %01011010			;
	.db %01011010			;pixels that show up twice in the
	.db %01000010			;three different sprites are dark gray
	.db %01111110			;
	.db %00000000			;pixels that show up thrice in the
										;three sprites are black
	.db %11111111			;
	.db %10111101			;and of course, pixels  that arn't used in the
	.db %11111111			;three sprites are white (if the contrast is low enough)
	.db %11100111			;
	.db %11100111			;
	.db %11111111			;
	.db %10111101			;
	.db %11111111			;
										;
	.db %00011000			;
	.db %01111110			;
	.db %01000010			;
	.db %11011011			;
	.db %11011011			;
	.db %01000010			;
	.db %01111110			;
	.db %00011000			;the first block ends here

Block2:							;I like this one the best because it really
	.db %00010001			;makes all four shades stand out
	.db %00010010
	.db %00010000
	.db %11110000
	.db %00001111
	.db %00001000
	.db %01001000
	.db %10001000

	.db %01010101
	.db %11010110
	.db %00010111
	.db %11110000
	.db %00001111
	.db %11101000
	.db %01101011
	.db %10101010

	.db %11011111
	.db %11011111
	.db %00011111
	.db %11111111
	.db %11111111
	.db %11111000
	.db %11111011
	.db %11111011


Block3:
	.db %10000000
	.db %11000000
	.db %10000000
	.db %11000000
	.db %10000000
	.db %11000000
	.db %10101010
	.db %11111111

	.db %11110000
	.db %11100000
	.db %11110000
	.db %11100000
	.db %11110101
	.db %11111111
	.db %11111111
	.db %11111111

	.db %11111100
	.db %11111000
	.db %11111101
	.db %11111111
	.db %11111111
	.db %11111111
	.db %11111111
	.db %11111111

Block4:
	.db %00000000
	.db %01100110
	.db %01100110
	.db %00000000
	.db %00000000
	.db %01000010
	.db %00100100
	.db %00000000

	.db %00000000
	.db %01100110
	.db %01100110
	.db %00000000
	.db %00011000
	.db %01000010
	.db %00111100
	.db %00011000

Goal:							;this is the third sprite of the smile block
	.db %00111100		;and the sprite for the goal because they are
	.db %01111110		;same (Saves 8 whole bytes!).  (The label won't
	.db %11111111		;get in the way)
	.db %11111111
	.db %11111111
	.db %11111111
	.db %01111110
	.db %00111100

Intro_Data:
	;.db 16, 8
	.db %00011111, %11111000
	.db %00100000, %00000100
	.db %00100000, %00000100
	.db %00100000, %00000100
	.db %00011111, %11111000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000

	.db 0,0
	.db 0,8


Level_Data:									;   /This allows the sprite editor in Assembly
	;.db 16, 8								;<-/Studio 86 ti read each level individually
	.db %00001101, %10011000	;\
	.db %00001110, %11011000	;|
	.db %00001111, %00111000	;\
	.db %00001101, %01011000	; \The 1's represent a block and the 0's
	.db %00001110, %11011000	; / represent a space
	.db %00001111, %00111000	;/
	.db %00001101, %11011000	;|
	.db %00001110, %00111000	;/
	.db 8,7										;Bob's coords
	.db 8,0										;Goal's coords

	;.db 16, 8								;same for the rest of the thirty levels
	.db %00011110, %10111100
	.db %00011010, %00101100
	.db %00011011, %11011100
	.db %00011101, %01101100
	.db %00011010, %10011100
	.db %00011011, %01101100
	.db %00011100, %11011100
	.db %00011011, %01011100
	.db 8,7
	.db 8,0

	;.db 16, 8
	.db %00011001, %10010110
	.db %00011010, %11001110
	.db %00011011, %10110110
	.db %00011000, %10100110
	.db %00011011, %11110110
	.db %00011011, %00110110
	.db %00011100, %11000110
	.db %00011010, %10111110
	.db 5,7
	.db 11,4

	;.db 16, 8
	.db %00110100, %00011110
	.db %00111101, %11001110
	.db %00110000, %11111110
	.db %00111011, %01111110
	.db %00110110, %10000110
	.db %00110101, %01101110
	.db %00111111, %11010110
	.db %00110000, %00001110
	.db 12,4
	.db 11,2

	;.db 16, 8
	.db %00111000, %00000111
	.db %00111001, %11111111
	.db %00110101, %01010011
	.db %00111011, %01011111
	.db %00110101, %01000011
	.db %00111011, %01111111
	.db %00110100, %00000011
	.db %00111001, %11111111
	.db 12,2
	.db 13,0

	;.db 16, 8
	.db %00111001, %00101011
	.db %00111110, %10111111
	.db %00111011, %01000011
	.db %00100101, %00101011
	.db %00101001, %11011011
	.db %00101110, %01101111
	.db %00101001, %01001011
	.db %00111110, %10110111
	.db 13,0
	.db 3,7

	;.db 16, 8
	.db %00110010, %00010011
	.db %00101010, %10010011
	.db %00110111, %11101011
	.db %00101001, %10010101
	.db %00100111, %01101101
	.db %00100110, %10101011
	.db %00101110, %01110101
	.db %00101011, %01011011
	.db 5,7
	.db 7,7

	;.db 16, 8
	.db %00110001, %00101101
	.db %00010010, %01010001
	.db %00010101, %01001111
	.db %00010101, %11111001
	.db %00010111, %10110001
	.db %00011111, %00101011
	.db %00000100, %10100101
	.db %00001000, %11110101
	.db 14,0
	.db 2,0

	;.db 16, 8
	.db %00000000, %00000000
	.db %00111111, %11111111
	.db %00000011, %00000010
	.db %00111100, %11110101
	.db %00000011, %00001010
	.db %00011111, %11111110
	.db %00100000, %10010000
	.db %00100110, %00100100
	.db 2,0
	.db 2,7

	;.db 16, 8
	.db %00010011, %11000000
	.db %00011100, %11011010
	.db %00010100, %11011101
	.db %00011110, %10001010
	.db %00010101, %01110101
	.db %00011110, %10110011
	.db %00010101, %01100101
	.db %00000110, %01011000
	.db 2,7
	.db 15,6

:-----------Medium Levels-------

	;.db 16, 8
	.db %00101010, %10100100
	.db %00101110, %01000100
	.db %00101011, %10111110
	.db %00111010, %01000010
	.db %00100100, %01111010
	.db %00011011, %10100111
	.db %00010100, %10001110
	.db %00101010, %10111010
	.db 15,7
	.db 2,1

	;.db 16, 8
	.db %00010100, %01000000
	.db %00101011, %10011011
	.db %00001010, %00100111
	.db %00110001, %11011010
	.db %00001101, %01001010
	.db %00011111, %11010110
	.db %00010011, %01111100
	.db %00010000, %00001000
	.db 8,4
	.db 15,2

	;.db 16, 8
	.db %00101000, %10001000
	.db %00001110, %00111011
	.db %00010010, %10110100
	.db %00010100, %01101000
	.db %00011011, %11110110
	.db %00010101, %10001001
	.db %00011100, %01110100
	.db %00001011, %00001010
	.db 15,2
	.db 4,7

	;.db 16, 8
	.db %00010011, %11001001
	.db %00010101, %00101100
	.db %00010101, %01001010
	.db %00010101, %01011001
	.db %00010101, %01001011
	.db %00010101, %01101010
	.db %00010101, %01001110
	.db %00010100, %11010000
	.db 2,7
	.db 15,0

	;.db 16, 8
	.db %00010101, %00010000
	.db %00101111, %10110111
	.db %00010001, %11010000
	.db %00001110, %10111111
	.db %00011010, %11001110
	.db %00010010, %10110100
	.db %00010011, %10011010
	.db %00100100, %10000101
	.db 15,0
	.db 2,7

	;.db 16, 8
	.db %00001000, %00000100
	.db %00001111, %11100010
	.db %00110110, %00011101
	.db %00001101, %11011010
	.db %00010101, %10010101
	.db %00001111, %11110011
	.db %00110101, %00001100
	.db %00000100, %10011110
	.db 2,0
	.db 8,4

	;.db 16, 8
	.db %00001100, %00001001
	.db %00010110, %11110101
	.db %00010011, %10011010
	.db %00001010, %10100111
	.db %00010111, %01101000
	.db %00101101, %01110111
	.db %00010010, %00100101
	.db %00111010, %11111111
	.db 14,6
	.db 3,6

	;.db 16, 8
	.db %00001010, %00100101
	.db %00101101, %10101000
	.db %00010110, %01011101
	.db %00101010, %10001010
	.db %00011111, %11011011
	.db %00010110, %00101100
	.db %00010110, %11010100
	.db %00001110, %00100100
	.db 2,0
	.db 6,7

	;.db 16, 8
	.db %00010101, %01001100
	.db %00010010, %10010010
	.db %00010101, %01101101
	.db %00010010, %11010110
	.db %00011101, %01101000
	.db %00010010, %10101010
	.db %00011111, %11111110
	.db %00000000, %00000000
	.db 4,5
	.db 2,0

	;.db 16, 8
	.db %00001001, %00100000
	.db %00101110, %01110110
	.db %00011001, %10001010
	.db %00100101, %11110110
	.db %00001110, %10011010
	.db %00010110, %10010110
	.db %00000101, %01001010
	.db %00010100, %10100010
	.db 2,0
	.db 15,7

;-----------Hard Levels--------------

	;.db 16, 8
	.db %00010010, %10101101
	.db %00101001, %01010001
	.db %00010110, %10101111
	.db %00101011, %00010110
	.db %00010101, %10111101
	.db %00101010, %11101011
	.db %00010101, %01101101
	.db %00001010, %10100000
	.db 2,7
	.db 15,0

	;.db 16, 8
	.db %00010001, %01010101
	.db %00100110, %01000101
	.db %00010001, %01010101
	.db %00100110, %01000101
	.db %00010001, %01010101
	.db %00100110, %01000101
	.db %00010001, %01010101
	.db %00001110, %01000101
	.db 2,7
	.db 15,6

	;.db 16, 8
	.db %00100001, %11010000
	.db %00010110, %00101101
	.db %00111101, %11010110
	.db %00100101, %01010001
	.db %00011101, %11010110
	.db %00110110, %00111111
	.db %00000111, %11100010
	.db %00100000, %00001001
	.db 8,3
	.db 15,7

	;.db 16, 8
	.db %00001110, %00000111
	.db %00011011, %01010100
	.db %00001110, %01010110
	.db %00000000, %01010100
	.db %00010100, %01010111
	.db %00101010, %01010000
	.db %00101010, %01010000
	.db %00101010, %00100000
	.db 5,1
	.db 15,0

	;.db 16, 8
	.db %00110101, %01101000
	.db %00101010, %10111010
	.db %00100010, %01010100
	.db %00110101, %11100010
	.db %00011001, %01010110
	.db %00001010, %01011011
	.db %00011001, %11010101
	.db %00110110, %10111100
	.db 2,5
	.db 15,5

	;.db 16, 8
	.db %00001000, %10001000
	.db %00101010, %10101010
	.db %00011010, %10101010
	.db %00101010, %10101010
	.db %00001010, %10101010
	.db %00011010, %10101010
	.db %00100010, %10101010
	.db %00000010, %00100011
	.db 2,0
	.db 15,7

	;.db 16, 8
	.db %00001010, %00101011
	.db %00010111, %00101000
	.db %00101010, %10101110
	.db %00011100, %01101101
	.db %00100111, %10101001
	.db %00001010, %10101010
	.db %00101011, %00101010
	.db %00010100, %10101110
	.db 2,0
	.db 15,0

	;.db 16, 8
	.db %00000110, %01010000
	.db %00011001, %00010110
	.db %00100101, %10101100
	.db %00011010, %01001101
	.db %00110011, %01101010
	.db %00010101, %01010101
	.db %00001010, %11101010
	.db %00010110, %10110101
	.db 2,0
	.db 15,7

	;.db 16, 8
	.db %00000101, %00001010
	.db %00001010, %10100001
	.db %00010101, %01111111
	.db %00010100, %11100001
	.db %00010011, %10101110
	.db %00011110, %10101000
	.db %00001010, %10101011
	.db %00111000, %01010010
	.db 15,7
	.db 2,7

	;.db 16, 8
	.db %00111011, %10101011
	.db %00111001, %00111010
	.db %00000001, %00101011
	.db %00110000, %00000010
	.db %00100100, %10110011
	.db %00110110, %10101000
	.db %00100101, %10101011
	.db %00110100, %10110011
	.db 2,2
	.db 14,6



;**********************
;*--Variables / Data--*
;**********************

CharTable:	.db 'X','T','O','J','E', 0 , 0 ,' ','W','S','N','I','D'
						.db  0 , 0, 'Z','V','R','M','H','C', 0 , 0 ,'Y','U','Q'
						.db 'L','G','B', 0 , 0 , 0 ,'-','P','K','F','A'

Times:			.db 95,85,80,75,70,70,70,65,60,70		;these are the time limits
						.db 45,45,50,25,50,30,40,30,30,60		;they go in order (1st 1 for
						.db 30,20,40,15,35,30,30,25,25,60		;level 1 & last for level 30

Bonuses:		.db 30,30,30,45,40,40,45,45,55,100		;same for the bonuses
						.db 40,53,50,50,40,35,45,50,50,100
						.db 35,30,35,25,35,65,30,35,40,100

HighScore:
						.db "Goofy............",0
HighScoreE:	.dw 400
						.db "Donald Duck......",0
HighScoreM:	.dw 200
						.db "Mickey Mouse.....",0
HighScoreH:	.dw 100

Skill:			.db 0			;this is the skill level, when you pass a level or get
											;a highscore it will be saved with the scores

Defaults:
	.db "Goofy............",0
	.dw 400
	.db "Donald Duck......",0
	.dw 200
	.db "Mickey Mouse.....",0
	.dw 100
	.db 0

ProgName:		.db $12,$07,"Blocked"		;this is for the saving routine from tetris
																		;this way it can find the program in the memory

;*********************
;*------Strings------*
;*********************

Clear?:				.db "  Clear High Scores  "
							.db " and Skill Level?!?! ",0
							.db "Yes  No              ",0

SideBar:
							.db "Levl",0
							.db "Scor",0
							.db "Bnus",0
							.db "Time",0

TitleText:
							.db "                     "
							.db "     BLOCKED  IN     "
							.db "       ver 1.3       "
							.db "                     "
							.db "                     "
							.db "  View High          "
							.db "    Scores           "
							.db "Start |  Help    Exit",0

Skill_Level:
							.db "Choose a skill Level-",0
							.db "Easy-----------------",0
							.db "Easy---Medium--------",0
							.db "Easy---Medium----Hard",0

Paused:
							.db " Paused - Press any  "
							.db "   key to resume.",0

Congrats:			.db "  Congratulations!   "
							.db "   You Passed The    ",0
							.db "    Easy Levels!     ",0
							.db "   Medium Levels!    ",0
							.db "    Hard Levels!     "
							.db "Nearly IMPOSSIBLE!!!!",0

C_Score:			.db "Your Score Was--",0

NewHS:				.db "You Hold The New High"
							.db "Score!!              "
							.db "Enter Your Name--",0

HelpText;
							.db "How  To  Play:",0
							.db "          Use  the  arrow  keys  to  move  the",0
							.db "man  and  push  the  blocks  out  of  the",0
							.db "way  so  you  can  reach  the  goal",0
							.db "(Black circle).   You  may  only  push",0
							.db " one  block  at  a  time.  Second  resets",0
							.db "the  blocks,  more  pauses.",0
							.db " ",0
							.db "         Send Q's and Comments to:",0
							.db "                                     puzzlesome@hotmail.com",0
 
HighScoreText:
	.db "     High Scores     "
	.db " Easy Levels--       ",0
	.db " Medium Levels--     ",0
	.db " Hard Levels--       ",0
	.db "                     ",0

TimeUP:		.db "!Time UP!",0

.end
