#include "asm86.h"
#include "ti86asm.inc"

_setxxop2			 equ		4617h
_convop1                         equ            5577h
_fpmult                          equ            548Ch
_homeup				 equ		4A95h
_divHLby10	=	$4044		;divide HL by 10
Digits		=	3		;number of digits to print

.org _asm_exec_ram

;------------------------AShell Description ------------------------------

	nop         ;Identifies the table
	jp Initialize
.dw $0000   ;Version # of Table
.dw Title   ;Absolute pointer to program description

;-------------------------------------------------------------------------
Initialize:
	call	_clrLCD
	call	_runindicoff
	call	titleScreen
	jp	titleGetKey

InitCont:
	call	_clrLCD
	ld	a,0
	ld	(temp),a
	ld	hl,0
	ld	(score),hl
	ld	(you),a
	ld 	a,55
	ld 	e,a
	ld 	a,(you)
 	ld 	hl,man
 	call 	PutSprite
	jp	RandomIce

titleScreen:
	call	_clrLCD
	call	_homeup
	ld	hl,Title
	call	_puts
	ld	hl,9*256+0
	ld	(_penCol),hl
	ld	hl,string1
	call	_vputs
	ld	hl,16*256+0
	ld	(_penCol),hl
	ld	hl,string2
	call	_vputs
	ld	hl,23*256+0
	ld	(_penCol),hl
	ld	hl,string3
	call	_vputs
	ld	hl,30*256+0
	ld	(_penCol),hl
	ld	hl,string4
	call	_vputs
	ld	hl,43*256+0
	ld	(_penCol),hl
	ld	hl,string5
	call	_vputs
	ld	hl,50*256+0
	ld	(_penCol),hl
	ld	hl,string6
	call	_vputs
	ret

titleGetKey:
	halt
	call	GET_KEY
	cp	K_1
	jp	z,easy
	cp	K_2
	jp	z,medium
	cp	K_3
	jp	z,hard
	cp	K_EXIT
	jp	z,Quit
	jp	nz,titleGetKey

easy:
	ld	a,5
	ld	(time),a
	jp	InitCont

medium:
	ld	a,3
	ld	(time),a
	jp	InitCont

hard:
	ld	a,1
	ld	(time),a
	jp	InitCont

Random:
	ld	a,30
	call	_setxxop2
	call	_fpmult
	call	_convop1
	ld	a,e
	ret

RandomIce:	
	call	Random
	ld	(ycoord1),a
	call	Random
	ld	(ycoord2),a
	call	Random
	ld	(ycoord3),a
	call	Random
	ld	(ycoord4),a
	call	Random
	ld	(ycoord5),a
	call	Random
	ld	(ycoord6),a
	call	Random
	ld	(ycoord7),a
	call	Random
	ld	(y8),a
	call	Random
	ld	(y9),a
	call	Random
	ld	(ycoord10),a
	call	Random
	ld	(ycoord11),a
	call	Random
	ld	(ycoord12),a
	call	Random
	ld	(ycoord13),a
	call	Random
	ld	(ycoord14),a
	call	Random
	ld	(ycoord15),a
	call	Random
	ld	(ycoord16),a
	ld	a,0
	ld	(temp),a
	
IceLoop:
 	ld hl,(score)
 	inc hl
 	inc hl
 	ld (score),hl
 	call s1
 	call PutSprite
 	call s2
 	call PutSprite
 	call s3
 	call PutSprite
 	call s4
 	call PutSprite
 	call s5
 	call PutSprite
 	call s6
 	call PutSprite
 	call s7
 	call PutSprite
 	call s8
 	call PutSprite
 	call s9
 	call PutSprite
 	call s10
 	call PutSprite
 	call s11
 	call PutSprite
 	call s12
	call PutSprite
	call s13
	call PutSprite
	call s14
	call PutSprite
	call s15
	call PutSprite
	call s16
	call PutSprite
	ld a,(temp)
 	cp 1
 	jp z,youdie
	ld a,(time)
	ld (temptime),a
	 	  	
KeyLoop:
	halt
	call	GET_KEY
	cp	K_EXIT
	jp	z,Quit
	cp	K_RIGHT
	jp	z,Right
	cp	K_LEFT
	jp	z,Left
	cp	K_MORE
	jp	z,Pause
	jp	nz,KeyLoopCheck


KeyLoopCheck:
	ld	a,(temptime)
	dec	a
	ld	(temptime),a
	cp	0
	jp	nz,KeyLoop
	jp	z,loop2
loop2:
 	ld b,15
 	call delaycoord2
 	call s1
 	call CLRSPR
 	call s2
 	call CLRSPR
 	call s3
 	call CLRSPR
 	call s4
 	call CLRSPR
 	call s5
 	call CLRSPR
 	call s6
	call CLRSPR
 	call s7
 	call CLRSPR
 	call s8
 	call CLRSPR
 	call s9
 	call CLRSPR
 	call s10
 	call CLRSPR
 	call s11
 	call CLRSPR
 	call s12
 	call CLRSPR
	call s13
 	call CLRSPR
	call s14
 	call CLRSPR
	call s15
 	call CLRSPR
	call s16
 	call CLRSPR
 	ld a,(temp)
 	cp 1
 	jp z,youdie
 	ld a,(ycoord1)
 	cp 104
 	jp nc,chg1
 	add a,2
 	ld (ycoord1),a


r1:
 	ld a,(ycoord2)
 	cp 104
 	jp nc,chg2
 	add a,3
 	ld (ycoord2),a
r2:
 	ld a,(ycoord3)
 	cp 104
 	jp nc,chg3
 	add a,2
 	ld (ycoord3),a
r3:
 	ld a,(ycoord4)
 	cp 104
 	jp nc,chg4
 	add a,3
 	ld (ycoord4),a
r4:
 	ld a,(ycoord5)
 	cp 104
 	jp nc,chg5
 	add a,2
 	ld (ycoord5),a
r5:
 	ld a,(ycoord6)
 	cp 104
 	jp nc,chg6
 	add a,3
 	ld (ycoord6),a
r6:
 	ld a,(ycoord7)
 	cp 104
 	jp nc,chg7
 	add a,4
 	ld (ycoord7),a
r7:
 ld a,(y8)
 cp 104
 jp nc,chg8
 add a,3
 ld (y8),a
r8:
 ld a,(y9)
 cp 104
 jp nc,chg9
 add a,2
 ld (y9),a
r9:
 ld a,(ycoord10)
 cp 104
 jp nc,chg10
 add a,2
 ld (ycoord10),a
r10:
 ld a,(ycoord11)
 cp 104
 jp nc,chg11
 add a,3
 ld (ycoord11),a
r11:
 ld a,(ycoord12)
 cp 104
 jp nc,chg12
 add a,2
 ld (ycoord12),a

r12:
 ld a,(ycoord13)
 cp 104
 jp nc,chg13
 add a,2
 ld (ycoord13),a

r13:
 ld a,(ycoord14)
 cp 104
 jp nc,chg14
 add a,2
 ld (ycoord14),a

r14:
 ld a,(ycoord15)
 cp 104
 jp nc,chg15
 add a,2
 ld (ycoord15),a

r15:
 ld a,(ycoord16)
 cp 104
 jp nc,chg16
 add a,2
 ld (ycoord16),a
 jp IceLoop



Left:
 ld a,(you)
 cp 0
 jp z,jplft
 ld a,55
 ld e,a
 ld a,(you)
 ld hl,man
 call CLRSPR
 ld a,(you)
 dec a
 dec a
 ld (you),a
 ld e,55
 ld hl,man
 call PutSprite
 jp loop2

jplft:
 jp loop2

Right: 
 ld a,(you)
 cp 128
 jp z,jprt
 ld a,55
 ld e,a
 ld a,(you)
 ld hl,man
 call CLRSPR
 ld a,(you)
 inc a
 inc a
 ld (you),a
 ld a,55
 ld e,a
 ld a,(you)
 ld hl,man   
 call PutSprite
 jp loop2

jprt:
 jp loop2

chkhit:           ; check to see if the icicle is at the same xposition as you
 ld a,(x)         ;  icicle x-pos +6 -> b
 add a,4
 ld b,a
 ld a,(you)       ; your x-pos ->a
 cp b             ;    IF a=>b   goto di2
 jp nc,di2
 ld a,(x)        ; icicle x-pos ->b
 ld b,a
 ld a,(you)      ; your x-pos +6 ->a
 add a,4
 cp b
 jp c,di2        ; IF a<b   goto di2
 ld a,1
 ld (temp),a
 ret

drawice:
 ld a,e
 cp 24
 jp c,ldrop
 cp 50
 jp c,bdrop
 cp 98
 jp nc,chkhit
di2:
 ld a,e
 ld hl,icicle
 sub 50
 ld e,a
 ld a,(x)
 ret

ldrop:
 ld hl,drop1
 ld e,0
 ld a,(x)
 ret

bdrop:
 ld hl,drop2
 ld e,0
 ld a,(x)
 ret

s1:
 ld a,(ycoord1)
 ld e,a
 ld a,0
 ld (x),a
 jp drawice

s2:
 ld a,(ycoord2)
 ld e,a
 ld a,8
 ld (x),a
 jp drawice

s3:
 ld a,(ycoord3)
 ld e,a
 ld a,16
 ld (x),a 
 jp drawice

s4:
 ld a,(ycoord4)
 ld e,a
 ld a,24
 ld (x),a
 jp drawice

s5:
 ld a,(ycoord5)
 ld e,a
 ld a,32
 ld (x),a
 jp drawice

s6:
 ld a,(ycoord6)
 ld e,a
 ld a,40
 ld (x),a
 jp drawice

s7:
 ld a,(ycoord7)
 ld e,a
 ld a,48
 ld (x),a
 jp drawice

s8:
 ld a,(y8)
 ld e,a
 ld a,56
 ld (x),a
 jp drawice

s9:
 ld a,(y9)
 ld e,a
 ld a,64
 ld (x),a
 jp drawice

s10:
 ld a,(ycoord10)
 ld e,a
 ld a,72
 ld (x),a
 jp drawice

s11:
 ld a,(ycoord11)
 ld e,a
 ld a,80
 ld (x),a
 jp drawice

s12:
 ld a,(ycoord12)
 ld e,a
 ld a,88
 ld (x),a
 jp drawice

s13:
 ld a,(ycoord13)
 ld e,a
 ld a,96
 ld (x),a
 jp drawice

s14:
 ld a,(ycoord14)
 ld e,a
 ld a,104
 ld (x),a
 jp drawice

s15:
 ld a,(ycoord15)
 ld e,a
 ld a,112
 ld (x),a
 jp drawice

s16:
 ld a,(ycoord16)
 ld e,a
 ld a,120
 ld (x),a
 jp drawice


chg1:
 ld a,0
 ld (ycoord1),a
 jp r1

chg2:
 ld a,0
 ld (ycoord2),a
 jp r2

chg3:
 ld a,0
 ld (ycoord3),a
 jp r3

chg4:
 ld a,0
 ld (ycoord4),a
 jp r4

chg5:
 ld a,0
 ld (ycoord5),a
 jp r5

chg6:
 ld a,0
 ld (ycoord6),a
 jp r6

chg7:
 ld a,0
 ld (ycoord7),a
 jp r7

chg8:
 ld a,0
 ld (y8),a
 jp r8

chg9:
 ld a,0
 ld (y9),a
 jp r9

chg10:
 ld a,0
 ld (ycoord10),a
 jp r10

chg11:
 ld a,0
 ld (ycoord11),a
 jp r11

chg12:
 ld a,0
 ld (ycoord12),a
 jp IceLoop

chg13:
 ld a,0
 ld (ycoord13),a
 jp IceLoop


chg14:
 ld a,0
 ld (ycoord14),a
 jp IceLoop


chg15:
 ld a,0
 ld (ycoord15),a
 jp IceLoop


chg16:
 ld a,0
 ld (ycoord16),a
 jp IceLoop


youdie:
 call _clrLCD
 jp Quit

delaycoord2:
 push bc
 ld b,255
 call delay
 pop bc
 djnz delaycoord2
 ret


;-----delay loop--------
delay:
	push bc
	pop bc
	djnz delay
	ret

;-----------quit game!--------------
Pause:
	halt
	call	GET_KEY
	cp	K_ENTER
	jp	z,KeyLoop
	jp	nz,Pause

Quit:	
	call	_clrLCD
	ld	hl,15*256+0
	ld	(_penCol),hl
	ld	hl,string7
	call	_vputs
	ld	hl,15*256+100
	ld	(_penCol),hl
	ld	a,(score)
	call	DispA
	call	_getkey
	ret

;-----Display HL Routine [By: SCaBBy]-----
DispA:
 ld l,a
 ld h,0
DispHL:					;dipslay 5 digits from hl
 xor a
 ld de,-1
 ld (_curRow),de
 call 4A33h
 dec hl
 jp _vputs


;------------------
; Sprite Routine
;------------------

;hl = image
;a = x coord
;e = y coord

PutSprite:
       push    hl              ; Save sprite address

;   Calculate the address in graphbuf   

        ld      hl,0            ; Do y*12
        ld      d,0
	ex	de,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl

        ld      d,0             ; Do x/8
        ld      e,a
        srl     e
        srl     e
        srl     e
        add     hl,de

        ld      de,$FC00
        add     hl,de           ; Add address to graphbuf

        ld      b,00000111b     ; Get the remainder of x/8
        and     b
        cp	0               ; Is this sprite aligned to 8*n,y?
        jp      z,ALIGN


;   Non aligned sprite blit starts here   

        pop     ix              ; ix->sprite
        ld      d,a             ; d=how many bits to shift each line

        ld      e,8             ; Line loop
LILOP:  ld      b,(ix+0)        ; Get sprite data

        ld      c,0             ; Shift loop
        push    de
SHLOP:  srl     b
        rr      c
        dec     d
        jp      nz,SHLOP
        pop     de

        ld      a,b             ; Write line to graphbuf
        or      (hl)
        ld      (hl),a
        inc     hl
        ld      a,c
        or      (hl)
        ld      (hl),a

        ld      bc,15           ; Calculate next line address
        add     hl,bc
        inc     ix              ; Inc spritepointer

        dec     e
        jp      nz,LILOP        ; Next line

        jp      DONE1


;   Aligned sprite blit starts here   

ALIGN:                          ; Blit an aligned sprite to graphbuf
        pop     de              ; de->sprite
        ld      b,8
ALOP1:  ld      a,(de)
        or      (hl)            ; xor=erase/blit
        ld      (hl),a
        inc     de
        push    bc
        ld      bc,16
        add     hl,bc
        pop     bc
        djnz    ALOP1

DONE1:
        ret
; SPRITE 

; CLRSPR
;
;
;Ŀ
; Blit or erase sprite  a=x, e=y, hl=sprite address                         
;
;
CLRSPR:
        push    hl              ; Save sprite address

;   Calculate the address in graphbuf   

        ld      hl,0            ; Do y*12
        ld      d,0
	ex	de,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl

        ld      d,0             ; Do x/8
        ld      e,a
        srl     e
        srl     e
        srl     e
        add     hl,de

        ld      de,$FC00
        add     hl,de           ; Add address to graphbuf

        ld      b,00000111b     ; Get the remainder of x/8
        and     b
        cp      0               ; Is this sprite aligned to 8*n,y?
        jp      z,ALIGN2


;   Non aligned sprite erase starts here   

        pop     ix              ; ix->sprite
        ld      d,a             ; d=how many bits to shift each line

        ld      e,8             ; Line loop
LILOP2: ld      b,(ix+0)        ; Get sprite data

        ld      c,0             ; Shift loop
        push    de
SHLOP2: srl     b
        rr      c
        dec     d
        jp      nz,SHLOP2
        pop     de

        ld      a,b             ; Write line to graphbuf
        cpl
        and     (hl)
        ld      (hl),a
        inc     hl
        ld      a,c
        cpl
        and     (hl)
        ld      (hl),a

        ld      bc,15           ; Calculate next line address
        add     hl,bc
        inc     ix              ; Inc spritepointer

        dec     e
        jp      nz,LILOP2       ; Next line

        jp      DONE5


;   Aligned sprite erase starts here   

ALIGN2:                         ; Erase an aligned sprite in graphbuf
        pop     de              ; de->sprite
        ld      b,8
ALOP2:  ld      a,(de)
        cpl
        and     (hl)
        ld      (hl),a
        inc     de
        push    bc
        ld      bc,16
        add     hl,bc
        pop     bc
        djnz    ALOP2

DONE5:
        ret
; CLRSPR
;

;----------------
;    Sprites
;----------------

icicle:
 .db 01111100b
 .db 01100100b
 .db 01000100b
 .db 00101000b
 .db 00101000b
 .db 00111000b
 .db 00010000b
 .db 00010000b

drop1:
 .db 01111100b
 .db 00111000b
 .db 00000000b
 .db 00000000b
 .db 00000000b
 .db 00000000b
 .db 00000000b
 .db 00000000b

drop2:
 .db 11111110b
 .db 11000110b
 .db 01000100b
 .db 00111000b
 .db 00000000b
 .db 00000000b
 .db 00000000b
 .db 00000000b

man:
 .db 01110000b
 .db 10101000b
 .db 01110000b
 .db 00100000b
 .db 11111000b
 .db 00100000b
 .db 01110000b
 .db 11011000b

;-----------------
;    Variables
;-----------------
 
temp:			.db	0
ycoord1:		.db	0
ycoord2:		.db	0
ycoord3:		.db	0
ycoord4:		.db	0
ycoord5:		.db	0
ycoord6:		.db	0
ycoord7:		.db	0
y8:			.db	0
y9:			.db	0
ycoord10:		.db	0
ycoord11:		.db	0
ycoord12:		.db	0
ycoord13:		.db	0
ycoord14:		.db	0
ycoord15:		.db	0
ycoord16:		.db	0
x:			.db	0
you:			.db	0
inix:			.db	0
score:			.db	0,0
time:			.db	0
temptime:		.db	0

;-----------------
;    Strings
;-----------------

Title: 		.db	"Avalanch 86z",0
string1:	.db	"TI-83 Version - Harper Maddox",0
string2:	.db	"Graphics By - Nathan Powell",0
string3:	.db	"Converted by: Ahmed El-Helw",0
string4:	.db	"http://asm86.home.ml.org",0
string5:	.db	"Choose Your Difficulty Level",0
string6:	.db	"Press a Key From 1-3",0
string7:	.db	"Game Over!  Your Score:",0
	
.end
END