#include "ti86asm.inc"
.org _asm_exec_ram

    nop
    jp ProgStart
    .dw 0
    .dw ShellTitle
AntX:   .db 0
AntY:   .db 0
AntH:   .db 0
delay:  .db 0
randnum:    .db 0
seed:   .db 0,0
style:  .db 0
ShellTitle:
    .db "Antz!",0

ProgStart:
    call _clrLCD
    call RSeed
    ld a,1
    ld (style),a
    ld a,25
    ld (AntX),a
    ld (AntY),a
    ld a,4
    ld (AntH),a
    call AntOn
    ld a,20
    ld (delay),a
MainLoop:
    call _getky
    cp K_PLUS
    jp z,Faster
    cp K_MINUS
    jp z,Slower
    cp K_CLEAR
    call z,_clrLCD
    cp K_F1
    jp z,changestyle
    cp K_EXIT
    jp z,exit
donekey:    
    call NewH
    call NewXY
    call AntOn
    
    ld a,(delay)
    ld b,a
delayloop:
    halt
    halt
    djnz delayloop   
    jp MainLoop
exit:
    call _clrLCD
    ret    
changestyle:
    ld a,(style)
    cp 0
    jp z,is0
    xor a
    ld (style),a
    jp donekey
is0:
    ld a,1
    ld (style),a
    jp donekey
Faster:
    ld a,(delay)
    cp 6
    jp c,donekey
    dec a
    dec a
    dec a
    dec a
    dec a
    ld (delay),a
    jp donekey
Slower:
    ld a,(delay)
    cp 80
    jp nc,donekey
    inc a
    inc a
    inc a
    inc a
    inc a
    ld (delay),a
    jp donekey       
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
AntOn:  ;turn the current x,y on and check to make sure the point is valid.
    ld a,(AntY)
    cp 61
    jp c,noYedge     ;if anty>=61, wrap to other side
    ld a,3
    ld (AntY),a
noYedge:
    ld a,(AntY)
    cp 2
    jp nc,noYedge2   ;if anty<=2, wrap to other side
    ld a,60
    ld (AntY),a
noYedge2:
    ld a,(AntX)
    cp 121
    jp c,noXedge     ;if antx>=121, wrap to other side
    ld a,3
    ld (AntX),a
noXedge:
    ld a,(AntX)
    cp 2
    jp nc,noXedge2
    ld a,120
    ld (AntX),a
noXedge2:
    ld a,(AntX)
    ld b,a
    ld a,(AntY)
    ld c,a
    call Find_Pixel
    or (hl)
    ld (hl),a
    ret
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;    
NewH:   ;generate a new heading for the ant
    call Random
    ld a,(randnum)
    cp 1
    ret z
    cp 2
    jp z,sub1
    cp 3
    jp z,sub1
    cp 4
    jp z,add1
    cp 5
    jp z,add1
    cp 6
    jp z,NewH
sub1:
    ld a,(AntH)
    cp 1
    jp z,AHis1
    ld hl,AntH
    dec (hl)
    ret
AHis1:
    ld a,8
    ld (AntH),a
    ret
add1:
    ld a,(AntH)
    cp 8
    jp z,AHis8
    ld hl,AntH
    inc (hl)
    ret
AHis8:
    ld a,1
    ld (AntH),a
    ret
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;    
    
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
NewXY:  ;generate a new x,y based on the heading
    ld a,(style)        ;turn off old coords if style is 0
    cp 1
    jp z,noOff
    ld a,(AntX)
    ld b,a
    ld a,(AntY)
    ld c,a
    call FindPixel
    cpl
    and (hl)
    ld (hl),a
noOff:    

    ld a,(AntH)
    cp 1
    jp nz,T2a
    ld hl,AntX
    dec (hl)
    ld hl,AntY
    dec (hl)
    ret
    
T2a:
    cp 2
    jp nz,T3a
    ld hl,AntY
    dec (hl)
    ret
    
T3a:
    cp 3
    jp nz,T4a
    ld hl,AntX
    inc (hl)
    ld hl,AntY
    dec (hl)
    ret
    
T4a:
    cp 4
    jp nz,T5a
    ld hl,AntX
    inc (hl)
    ret
    
T5a:
    cp 5
    jp nz,T6a
    ld hl,AntX
    inc (hl)
    ld hl,AntY
    inc (hl)
    ret
    
T6a:
    cp 6
    jp nz,T7a
    ld hl,AntY
    inc (hl)
    ret
    
T7a:
    cp 7
    jp nz,T8a
    ld hl,AntX
    dec (hl)
    ld hl,AntY
    inc (hl)
    ret

T8a:
    ld hl,AntX
    dec (hl)
    ret
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;------------------------------------------------------
;   FIND PIXEL ROUTINES by CLEM <clems@mygale.org>
;
;       Input:  x->b
;               y->c
;
;       Output: hl : byte in LCD memory
;               a  : bitmask for (hl)
;
;       If you need speed, use FindPixel, else
;       use Find_Pixel (shorter).
;
;---------------------- examples ----------------------

;PixelOn:    ld bc,$1010
;            call Find_Pixel
;            or (hl)
;            ld (hl),a
;            ret

;PixelOff:   ld bc,$1010
;            call Find_Pixel
;            cpl
;            and (hl)
;            ld (hl),a
;            ret

;PixelInv:   ld bc,$1010
;            call Find_Pixel
;            xor (hl)
;            ld (hl),a
;            ret

;PixelTest:  ld bc,$1010
;            call Find_Pixel
;            and (hl)
;            ret

;------------------------------------------------------

;   FIND_PIXEL by CLEM

;

;   121 cycles  27 bytes    Destroyes : none

;------------------------------------------------------
Find_Pixel:
    ld h,63
    ld a,c
    add a,a
    add a,a
    ld l,a
    ld a,b
    rra
    add hl,hl
    rra
    add hl,hl
    rra
    or l
    ld l,a
    ld a,b
    and 7
    cpl
    rlca
    rlca
    rlca
    ld (FP_Bit+1),a
    xor a

FP_Bit:
    set 0,a
    ret

;------------------------------------------------------

;   FINDPIXEL by CLEM

;

;   117 cycles  34 bytes    Destroyes : bc

;------------------------------------------------------

FindPixel:
    ld h,63
    ld a,c
    add a,a
    add a,a
    ld l,a
    ld a,b
    rra
    add hl,hl
    rra
    add hl,hl
    rra
    or l
    ld l,a
    ld a,b
    and 7
    ld bc,FP_Bits
    add a,c
    ld c,a
    adc a,b
    sub c
    ld b,a
    ld a,(bc)
    ret

FP_Bits:    .db $80,$40,$20,$10,$08,$04,$02,$01

;------------------------------------------------------



;    +-----------------------------------------+
;    |     name : CLEM                         |
;    | homepage : http://www.mygale.org/~clems | <-- french
;    |   e-mail : mailto:clems@mygale.org      |
;    +-----------------------------------------+
Random:
;Random Number Generator by Steven Hunt (shlefty@home.com).  For details
;on how this routine works, see random.txt
;Please give me credit if you use it.
    ld hl,(seed)    ;this section shifts seed as a whole.
    sla h
    bit 7,l     ;test if shifting LB would overflow
    jr z,noinc1 ;if not, don't inc UB
    inc h
noinc1:
    sla l
    ld (seed),hl ;end

    ld a,h      ;higher byte->a

    cp 42
    jp c,face1
    cp 86
    jp c,face2
    cp 130
    jp c,face3
    cp 174
    jp c,face4
    cp 218
    jp c,face5
face6:
    ld a,6
    ld (randnum),a
    jp testbit
face1:
    ld a,1
    ld (randnum),a
    jp testbit
face2:
    ld a,2
    ld (randnum),a
    jp testbit
face3:
    ld a,3
    ld (randnum),a
    jp testbit
face4:
    ld a,4
    ld (randnum),a
    jp testbit
face5:
    ld a,5
    ld (randnum),a
testbit:            ;prepare new seed number (xor bit 14&15, store in bit 1)
    ld a,h          ;restore higher byte of seed
    and %01000000   ;mask all but bit 7 (15 of seed#)
    ld b,a          ;save result
    ld a,h
    sla a           ;shift higher byte left
    and %01000000   ;mask all but bit 7 (14 of seed# after shift)
    xor b           ;see if bits 15&14 are =
    jp z,resbit     ;=?
    ld hl,seed
    set 0,(hl)      ;they were different, so set bit 0 of seed
    ret
resbit:             ;were the same, so reset bit 0 of seed
    ld hl,seed
    res 0,(hl)
    ret

RSeed:
    call _random        ;0<=op1<1
    call _inco1exp      ;op1*10
    call _inco1exp      ;"      these 4 lines =op1*10,000
    call _inco1exp      ;"
    call _inco1exp      ;"
    call _INTGR         ;make op1 an integer
    call _convop1       ;conv op1 to de,a
    ld (seed),de        ;we want 2 bytes of random stuff
    ld b,3
ShiftSeedLoop:
    ld hl,(seed)    ;this section shifts seed as a whole.
    sla h
    bit 7,l
    jr z,noinc
    inc h
noinc:
    sla l
    ld (seed),hl ;end
    djnz ShiftSeedLoop
    ret
;;;;;;;;;;;;;;;;;

.end
