;*********************************************************;
;                                                         ;
; Alien Breed: Tower Assault                              ;
; Alien Management Routines                               ;
;                                                         ;
; Copyright 2000-2001 Ti-Calculator Programming Alliance ;
; Written and Programmed by James Vernon <james@calc.org> ;
; ICQ#: 71589304                                          ;
; http://tcpa.calc.org                                    ;
;                                                         ;
;*********************************************************;

GetSecuritySpr:
 ld de,SprSecurity
 jr GetASGSpr

GetAlienSpr:
 ld de,SprAlien

GetASGSpr:
 ld l,(ix+1)
 ld h,0
 add hl,hl
 add hl,hl
 add hl,hl
 add hl,de
 jp AfterGetASpr

GetFaceHuggerSpr:
 ld de,SprFaceHugger

GetFHWSpr:
 ld l,(ix+1)
 ld h,0
 add hl,hl
 add hl,hl
 add hl,hl
 add hl,de
 ex de,hl
 ld l,(ix+6)
 ld h,0
 add hl,hl
 add hl,hl
 add hl,hl
 add hl,hl
 add hl,hl
 add hl,de
 jp AfterGetASpr

GetWormSpr:
 ld de,SprWorm
 jr GetFHWSpr

DrawAliens:
 ld ix,EnemyTable
 ld b,NO_ALIENS
DALoop:
 push bc
 ld a,(ix)
 or a
 jr z,EndDA
 dec a
 jr z,GetAlienSpr
 dec a
 jr z,GetFaceHuggerSpr
 dec a
 jr z,GetWormSpr
 jr GetSecuritySpr
AfterGetASpr:
; call StoreSprite
 ld (TempX),hl
 ld l,(ix+4)
 ld h,(ix+5)
 ld de,(StartY)
 or a
 sbc hl,de
 ld de,-8
 bcall(_cphlde)
 jr nc,DAYOK
 ld de,64
 bcall(_cphlde)
 jr nc,EndDA
DAYOK:
 ld c,l
 ld l,(ix+2)
 ld h,(ix+3)
 ld de,(StartX)
 or a
 sbc hl,de
 ld de,-8
 bcall(_cphlde)
 jr nc,DAXOK
 ld de,96
 bcall(_cphlde)
 jr nc,EndDA
DAXOK:
 ld b,l
 ;ld hl,DrawSpr
 ld hl,(TempX)
 push ix
 call putClippedSprite
 pop ix
EndDA:
 pop bc
 ld de,9
 add ix,de
 djnz DALoop
 ret

NewSecurity:
 push ix
 push af
 push hl
 ld ix,EnemyTable
 ld b,NO_ALIENS
FNSS:
 ld a,(ix)
 or a
 ld d,4
 jr z,NSFound
 ld de,9
 add ix,de
 djnz FNSS
 pop hl
 pop af
 pop ix
 ret

NewAlien:
 push ix
 push af
 push hl
 ld ix,EnemyTable
 ld b,NO_ALIENS
FNAS:
 ld a,(ix)
 or a
 ld d,1
 jr z,NSFound
 ld de,9
 add ix,de
 djnz FNAS
 pop hl
 pop af
 pop ix
 ret

NSFound:
 ld a,c
 or a                           ; Check if we should erase trigger (we shouldn't if it's an alien hole or security guard)
 jr nz,NoClearT
 ld (hl),0                      ; Clear trigger
NoClearT:
 ld (ix),d
NewEnemy:                       ; From here on is used for every type of enemy
 ld (ix+1),0                    ; Set direction to up
 call GetXYCoords               ; Get coordinates, output A = XCoord, L = YCoord (Absolute)
 ld h,0
 add hl,hl
 add hl,hl
 add hl,hl                      ; HL = HL*8
 ld (ix+4),l                    ; Save YCoord
 ld (ix+5),h
 ld l,a
 ld h,0                         ; HL = Abs XCoord
 add hl,hl
 add hl,hl
 add hl,hl                      ; HL = HL*8
 ld (ix+2),l
 ld (ix+3),h                    ; Save XCoord
 ld (ix+6),0                    ; Initialise counter
 ld l,(ix)                      ; Now we must work out initial energy
 dec l                          ; L = EnemyType-1 (between 0-3)
 ld h,20                        ; 20 bytes to skip per enemy type
 bcall(_htimesl)                ; Get offset to enemy data
 ld de,EnergyTable
 add hl,de
 ld a,(Level)
 ld e,a
 ld d,0                         ; DE = Offset to byte we want (different energy amounts on different levels)
 add hl,de
 ld b,(hl)                      ; Get initial energy
 ld a,(Difficulty)
 add a,b                        ; If on TOUGH, add 1 to initial energy
 ld (ix+7),a                    ; Initialise energy
 ld b,10
 call iRandom
 ld e,a
 ld d,0
 ld hl,SpeedTable
 add hl,de
 push hl
 ld l,(ix)
 dec l
 ld h,10
 bcall(_htimesl)
 pop de
 add hl,de
 ld a,(hl)
 ld b,a
 add a,a
 add a,a
 or b
 ld (ix+8),a                    ; Initialise speed
 pop hl
 pop af
 pop ix
 ret

NewFaceHugger:
 push ix
 push af
 push hl
 ld b,NO_ALIENS
 ld ix,EnemyTable
FNFS:
 ld a,(ix)
 or a
 jr z,NFSFound
 ld de,9
 add ix,de
 djnz FNFS
 pop hl
 pop af
 pop ix
 ret

NFSFound:
 ld (hl),0
 ld (ix),2
 jp NewEnemy

NewWorm:
 push ix
 push af
 push hl
 ld ix,EnemyTable
 ld b,NO_ALIENS
FNWS:
 ld a,(ix)
 or a
 jr z,NWSFound
 ld de,9
 add ix,de
 djnz FNWS
 pop hl
 pop af
 pop ix
 ret

NWSFound:
 ld (hl),0
 ld (ix),3
 jp NewEnemy

NoMoveAlien:
 or b
 ld (ix+8),a
 jr EndMA

MoveAliens:
 ld ix,EnemyTable
 ld b,NO_ALIENS
MALoop:
 push bc
 ld a,(ix)
 or a
 jr z,EndMA
 ld a,(ix+8)
 and %00000011
 ld b,a
 ld a,(ix+8)
 and %00001100
 dec b
 jr nz,NoMoveAlien
 ld b,a
 srl b
 srl b
 or b
 ld (ix+8),a
 ld e,(ix+2)
 ld d,(ix+3)
 ld hl,(X)
 or a
 sbc hl,de
 jr c,AlienLeft
 jr nz,AlienRight

CheckAlienY:
 ld e,(ix+4)
 ld d,(ix+5)
 ld hl,(Y)
 or a
 sbc hl,de
 jp c,AlienUp
 jp nz,AlienDown

EndMA:
 pop bc
 ld de,9
 add ix,de
 djnz MALoop
 ret

AlienLeft:                      ; DE = XCoord, (IX+0) = Entry in EnemyTable
 ld (ix+1),2
 ex de,hl                       ; HL = XCoord
 dec hl
 ld (TempX),hl
 inc hl
 ld e,(ix+4)
 ld d,(ix+5)                    ; DE = YCoord
 ld (TempY),de
 inc de
 call GetTileSave
 cp 81
 jr nc,CheckAlienY
 cp 75
 jr z,CheckAlienY
 push hl
 ld hl,5
 add hl,de
 ex de,hl
 pop hl
 call GetTileSave
 cp 81
 jr nc,CheckAlienY
 cp 75
 jr z,CheckAlienY
 call CheckAlienCollisions
 jr nc,CheckAlienY
 ld hl,(TempX)
 ld (ix+2),l
 ld (ix+3),h
 call IncAlienAnims
 jr EndMA

PopCAY:
 pop hl
 jp CheckAlienY

AlienRight:                     ; DE = XCoord, (IX+0) = Entry in EnemyTable
 ld (ix+1),3
 inc de                         ; DE = Possible new XCoord
 ld (TempX),de
 push de
 ld hl,6
 add hl,de                      ; HL = XCoord of spot to check
 ld e,(ix+4)
 ld d,(ix+5)                    ; DE = YCoord
 ld (TempY),de
 inc de
 call GetTileSave
 cp 81
 jr nc,PopCAY
 cp 75
 jr z,PopCAY
 push hl
 ld hl,5
 add hl,de
 ex de,hl
 pop hl
 call GetTileSave
 cp 81
 jr nc,PopCAY
 cp 75
 jr z,PopCAY
 pop hl
 call CheckAlienCollisions
 jp nc,CheckAlienY
 ld hl,(TempX)
 ld (ix+2),l
 ld (ix+3),h
 call IncAlienAnims
 jp EndMA

AlienUp:                        ; DE = YCoord, (IX+0) = Entry in EnemyTable
 ld (ix+1),0
 dec de
 ld (TempY),de
 inc de
 ld l,(ix+2)
 ld h,(ix+3)                    ; HL = XCoord
 ld (TempX),hl
 inc hl
 call GetTileSave
 cp 81
 jp nc,EndMA
 cp 75
 jp z,EndMA
 push de
 ld de,5
 add hl,de
 pop de
 call GetTileSave
 cp 81
 jp nc,EndMA
 cp 75
 jp z,EndMA
 call CheckAlienCollisions
 jp nc,EndMA
 ld hl,(TempY)
 ld (ix+4),l
 ld (ix+5),h
 call IncAlienAnims
 jp EndMA

PopEndMA:
 pop hl
 jp EndMA

AlienDown:                      ; DE = YCoord, (IX+0) = Entry in EnemyTable
 ld (ix+1),1
 inc de                         ; DE = Possible new YCoord
 ld (TempY),de
 push de
 ld hl,6
 add hl,de
 ex de,hl
 ld l,(ix+2)
 ld h,(ix+3)                    ; HL = XCoord
 ld (TempX),hl
 inc hl
 call GetTileSave
 cp 81
 jr nc,PopEndMA
 cp 75
 jr z,PopEndMA
 push de
 ld de,5
 add hl,de
 pop de
 call GetTileSave
 cp 81
 jr nc,PopEndMA
 cp 75
 jr z,PopEndMA
 pop de
 call CheckAlienCollisions
 jp nc,EndMA
 ld hl,(TempY)
 ld (ix+4),l
 ld (ix+5),h
 call IncAlienAnims
 jp EndMA

IncAlienAnims:
 ld a,(ix+6)
 inc a
 cp 4
 jr nz,IncAASkip
 xor a
IncAASkip:
 ld (ix+6),a
 ret

CheckAlienCollisions:
 push ix
 ld ix,EnemyTable
 ld bc,NO_ALIENS*256+0
CAC:
 push bc
 ld a,(ix)
 or a
 jr z,EndCAC
 ld hl,(TempX)
 ld e,(ix+2)
 ld d,(ix+3)
 or a
 sbc hl,de
 ld a,l
 jr nc,CACAbsX
 neg
CACAbsX:
 cp 8
 jr nc,EndCAC
 ld hl,(TempY)
 ld e,(ix+4)
 ld d,(ix+5)
 or a
 sbc hl,de
 ld a,l
 jr nc,CACAbsY
 neg
CACAbsY:
 cp 8
 jr nc,EndCAC
 pop bc
 inc c
 push bc
EndCAC:
 pop bc
 ld de,9
 add ix,de
 djnz CAC
 ld a,c
 cp 2
 pop ix
 ret

UpdateMissile:
 ld ix,EBulletTable
 ld b,1
 jp MBLoop
 ret

SecurityMissile:
 ld a,(EBulletTable)
 or a
 jr nz,UpdateMissile
 ld ix,EnemyTable
 ld b,NO_ALIENS
FindSecurity:
 ld a,(ix)
 cp 4
 jr nz,FSNext
 ld e,(ix+2)
 ld d,(ix+3)
 ld hl,(X)
 or a
 sbc hl,de
 ld a,l
 jr nc,SMAbsX
 neg
SMAbsX:
 cp 5
 jr c,SMShoot
 ld e,(ix+4)
 ld d,(ix+5)
 ld hl,(Y)
 or a
 sbc hl,de
 ld a,l
 jr nc,SMAbsY
 neg
SMAbsY:
 cp 5
 jr c,SMShoot
FSNext:
 ld de,9
 add ix,de
 djnz FindSecurity
 ret

SMShoot:
 ld hl,EBulletTable
 ld (hl),5
 inc hl
 ld a,(ix+1)
 ld (hl),a
 inc hl
 ld e,(ix+2)
 ld d,(ix+3)
 ld (hl),e
 inc hl
 ld (hl),d
 inc hl
 ld e,(ix+4)
 ld d,(ix+5)
 ld (hl),e
 inc hl
 ld (hl),d
 ret

DrawMissile:
 ld a,(EBulletTable)
 or a
 ret z
 ld ix,EBulletTable
 ld b,1
 jp DBLoop

CheckSGMissile:
 ld a,(EBulletTable)
 or a
 ret z
 ld de,(EBulletTable+2)
 ld hl,(X)
 or a
 sbc hl,de
 ld a,l
 jr nc,CSMAbsX
 neg
CSMAbsX:
 cp 8
 ret nc
 ld de,(EBulletTable+4)
 ld hl,(Y)
 or a
 sbc hl,de
 ld a,l
 jr nc,CSMAbsY
 neg
CSMAbsY:
 cp 8
 ret nc
 ld a,(Invincible)
 or a
 ret nz
 ld a,(Dead)
 or a
 ret nz
 ld hl,Health
 dec (hl)
 xor a
 ld (EBulletTable),a
 ret
