.DB 00111110B,1                 ; Turn off screen, ON interrupts only
        OUT (3),A               ; Send to port
        CALL $4A86              ; Clear screen, move cursor to up left
        EI                      ; Enable interrupts
        HALT                    ; Wait for ON key
        LD B,21                 ; Max. length
        LD DE,$A000             ; Adress to save input
        LD A,11                 ; Turn on screen
        OUT (3),A               ; Send to port
Security_Loop:
        INC C                   ; Increase size counter
Input_Loop:
        CALL $4068              ; Get a key
        OR A                    ; No key pressed?
        JR Z,Input_Loop         ; Try again
        LD (DE),A               ; Save in mem
        CP 9                    ; Is it enter?
        JR Z,Check_PW           ; If so, check if password is correct
        XOR A                   ; Character to be put on screen
        CALL $4A2B              ; Put it on screen
        INC DE                  ; Next byte
        DJNZ Security_Loop      ; Next loop
Check_PW:
        LD DE,$D60A             ; Real password location
        LD HL,$9FFF             ; Temporary password location
        LD (HL),C               ; Save size
        CALL $4963              ; Compare
        JR NZ, Off              ; Password was wrong so shut down
        CALL $4A86              ; Clear screen, move cursor to up left
        JP $409C                ; Exit to the homescreen
