;
; If you make any changes to the source, please tell me what and why.
; And you are NOT allowed to distribute a modified source, nor the
; compiled version of it. Any changes should be made for personal use only.
;
; //Jimmy Mrdell <mja@algonet.se>
;

#include usgard.h

cBitOfs   = $80DF      ; WORD
cBit	  = $80E1      ; 4 BYTE
cXY	  = $80E5      ; WORD
cB	  = $80E7      ; 24 BYTE
cRot	  = $80FF      ; BYTE
flags	  = $8100      ; BYTE  (0 - Quit, 1 - Update)
newXY	  = $8101      ; WORD
newRot	  = $8103      ; BYTE
counter   = $8104      ; BYTE
next	  = $8105      ; BYTE
linesflag = $8106      ; BYTE
score	  = $8107      ; WORD
scoreU	  = $8109      ; BYTE
lines	  = $810A      ; BYTE
level	  = $810B      ; BYTE
string	  = $810C      ; 6 BYTE
place	  = $8112      ; BYTE
cNBitOfs  = $8113      ; WORD
players   = $8115      ; BYTE
lcounter  = $8116      ; WORD
declines  = $8118      ; BYTE
stlevel   = $8119      ; BYTE
lastbar   = $811A      ; BYTE
hsflag	  = $811B      ; BYTE
scrflag   = $811C      ; BYTE
gap	  = $811D      ; BYTE
sbyte	  = $811E      ; BYTE
sthigh	  = $811F      ; BYTE
high	  = $8120      ; BYTE
linkcnt   = $8121      ; BYTE
board	  = $8A6B      ; 40 BYTE

.org 0
.db "ZTetris 3.0",0

Start:
 ld hl,&Resume
 ld a,(hl)
 or a		       ; Check if the game should resume
 jr z,Restart
 ld (hl),0	       ; Clear that flag so it doesn't resume next time
 inc hl
 ld de,cBitOfs
 ld bc,67
 ldir		       ; Copy variables
 ld de,board
 ld bc,40
 ldir
 ld hl,(cBitOfs)
 ld de,(PROGRAM_ADDR)
 add hl,de
 ld (cBitOfs),hl
 ld hl,(cNBitOfs)
 ld de,(PROGRAM_ADDR)
 add hl,de
 ld (cNBitOfs),hl
 call &ShowLayout
 call &ShowInfo
 call &ShowWell
 call &ShowCurB
 ld de,$FC05
 ld hl,cB+16
 call &ShowB	       ; This will show the next bit
 jp &MainLoop

PutDigit:	       ; Puts digit A on the correct place
 push af	       ; Used when choosing start level
 ld l,2
 cp 5
 jr c,FirstRow
 inc l
 sub 5
FirstRow:
 add a,a
 add a,3
 ld h,a
 ld ($800C),hl
 pop af
 push af
 add a,48
 call TX_CHARPUT
 pop af
 ret

Restart:
 call &ShowFrame       ; Show "ZTETRIS v3.0" and "by Jimmy Mrdell"
 ld de,$1420
 ld ($8333),de
 call D_ZM_STR	       ; "Choose player mode"
 ld de,$0704
 ld ($800C),de
 call D_ZT_STR	       ; "1 player"
 ld de,$0705
 ld ($800C),de
 call D_ZT_STR	       ; "2 players"
 xor a
 ld (stlevel),a        ; When starting a new game, stLevel and stHigh
 ld (sthigh),a	       ; will be reset
 inc a
 ld (players),a        ; Default option, 1 player
ChoosePlayers:
 ld a,(players)
 ld h,$05
 push af
 add a,3
 ld l,a
 ld a,5
 ld ($800C),hl
 call TX_CHARPUT       ; Put the small arrow
 pop af
 ld h,$05
 sub 6
 neg
 ld l,a
 ld a,32
 ld ($800C),hl
 call TX_CHARPUT       ; And remove it from the other position
WKCP:
 call GET_KEY
 ld hl,players
 cp K_EXIT
 jp z,&Quit
 cp K_ENTER
 jr z,LevelChoose
 cp K_UP
 jr z,ChangePlayers
 cp K_DOWN
 jr z,ChangePlayers
 cp K_1
 jr z,OnePlayer
 cp K_2
 jr z,TwoPlayers
 jr WKCP
ChangePlayers:
 ld a,(hl)
 xor 3		       ; This will turn 1 -> 2 and 2 -> 1
 ld (hl),a
 jr ChoosePlayers
OnePlayer:
 ld (hl),1
 jr LevelChoose
TwoPlayers:
 ld (hl),2
LevelChoose:
 call &ShowFrame
 ld a,(stlevel)
 ld (level),a	       ; The cursor will start at the last played level
 ld a,(sthigh)
 ld (high),a	       ; And with the high
 xor a
NewDigit:
 call &PutDigit        ; Put all digits, 0-9
 inc a
 cp 10
 jr nz,NewDigit
 ld hl,$0E02
 ld ($800C),hl
 ld hl,&HighTxt
 call D_ZT_STR	       ; "High"
 ld a,(players)
 dec a		       ; Check if the hiscore should be shown
 jr nz,Show2PlayOpt    ; or two player options
 ld hl,&Hiscore
 ld a,$24
 ld b,3
NewPos:
 ld e,$18
 ld d,a
 add a,6
 ld ($8333),de
 push af
 push bc
 call D_ZM_STR	       ; Show name
 ld a,$52
 ld ($8333),a
 ld b,5
 push hl
 call LD_HL_MHL        ; Get that persons score
 call DM_HL_DECI       ; And show it
 pop hl
 inc hl
 inc hl 	       ; HL -> next hiscore table entry
 pop bc
 pop af
 djnz NewPos
 jr WaitKey
Show2PlayOpt:
 ld hl,$0205
 ld ($800C),hl
 push hl
 ld hl,&SLTxt
 call D_ZT_STR	       ; "Send 2-4 lines"
 ld hl,$0206
 ld ($800C),hl
 push hl
 ld hl,&Infotext+12
 call D_ZT_STR	       ; "Lines "
 pop hl
 ld ($800C),hl
 set 3,(iy+5)
 ld a,76
 call TX_CHARPUT       ; Invert the 'S'
 pop hl
 ld ($800C),hl
 ld a,83
 call TX_CHARPUT       ; And the 'L'
 xor a
 ld (declines),a       ; Clear the flags to the two option above
 ld (scrflag),a
WaitKey:
 ld a,(level)
 set 3,(iy+5)
 call &PutDigit        ; Invert the starting level digit
 res 3,(iy+5)
 ld a,(high)
 ld hl,$1003
 ld ($800C),hl
 add a,48
 call TX_CHARPUT       ; And show the High
 ld a,(players)
 dec a		       ; If two players, the two players options
 jr z,GetKey	       ; should be shown as well
 ld hl,$0806
 ld ($800C),hl
 ld hl,&ScrambleTxt
 ld a,(scrflag)
 or a
 jr z,ShowScrFlag
 ld de,12
 add hl,de
ShowScrFlag:
 call D_ZT_STR	       ; Show "scrambled" or "unscrambled"
GetKey:
 call GET_KEY
 or a
 jr z,GetKey
 cp K_EXIT
 jp z,&Quit
 cp K_ENTER
 jp z,&StartGame
 cp K_F4
 jr z,DecHigh
 cp K_F5
 jr z,IncHigh
 cp K_7
 jr z,ChangeScrFlag
 cp K_6
 jr nz,CheckLevChg
 ld a,(players)
 dec a
 jr z,GetKey
 ld a,(declines)
 xor 1		       ; Change the declines flag (1-3 or 2-4)
 ld (declines),a
 add a,a
 add a,a
 ld hl,$0705
 ld ($800C),hl
 ld hl,&NLTxt
 ld d,0
 ld e,a
 add hl,de
 call D_ZT_STR	       ; Update it on the screen
ToWaitKey:	       ; This label is to avoid JPs below (saves a few bytes)
 jr WaitKey
CheckLevChg:
 dec a
 jr z,ChangeRow
 dec a
 jr z,LevLeft
 dec a
 jr z,LevRight
 dec a
 jr nz,ToWaitKey
 jr ChangeRow

DecHigh:
 ld a,(high)
 or a
 jr z,GetKey	       ; Don't decrease if high is 0
 dec a
 ld (high),a
 jr ToWaitKey

IncHigh:
 ld a,(high)
 cp 5
 jr z,GetKey	       ; Don't increase if high is 5
 inc a
 ld (high),a
 jr ToWaitKey

ChangeRow:
 ld a,(level)
 add a,5	       ; Changing row is like adding with 5, mod 10
ChkLevEdges:
 daa		       ; Modulo 10 (sort of)
 and $0F
SetLevel:
 ld b,a
 ld a,(level)
 call &PutDigit        ; Remove the inverted digit
 ld a,b
 ld (level),a	       ; And set the new level
 jr ToWaitKey
LevLeft:
 ld a,(level)
 dec a
 jr ChkLevEdges
LevRight:
 ld a,(level)
 inc a
 jr ChkLevEdges

ChangeScrFlag:
 ld hl,scrflag
 ld a,(hl)
 xor 1
 ld (hl),a
 jr ToWaitKey

StartGame:
 ld a,(level)
 ld (stlevel),a        ; Copy the selected level and high so they will
 ld a,(high)	       ; be default next time
 ld (sthigh),a
 ld a,(players)
 dec a
 jr z,NoWait
 xor a
 ld (lastbar),a

 call &ShowFrame
 ld hl,$0504
 ld ($800C),hl
 ld hl,&WaitTxt
 call D_ZT_STR	       ; "* WAITING *"

 call &ReceiveByte
 or a
 jr nz,NoWait	       ; If byte gotten, the other calc was waiting
 ld a,1
 ld (hsflag),a	       ; This will allow the user to cancel with EXIT
 ld a,$AA
 call &SendByte        ; Else wait until the other calc responds

NoWait:
 xor a
 ld (hsflag),a
 ld (sbyte),a	       ; This is a linkbuffer byte
 call CLEARLCD
 call &RandP	       ; Randomize the first piece

 ld hl,$FFFF
 ld (board+2),hl
 ld hl,board+4
 ld b,18
InitRow:	       ; Setting up the border aroudn the well
 ld (hl),%00000111
 inc hl
 ld (hl),%11100000
 inc hl
 djnz InitRow

 call &ShowLayout
 ld hl,linkcnt	       ; This counter decrease every frame. When 0,
 ld (hl),10	       ; check link port. If too often check, it slows down
 ld a,(players)
 dec a
 ld a,0 	       ; Can't use 'xor a' here! It would affect the Z flag
 call nz,&ShowBar      ; Show the bar at height 0
ResetVars:
 xor a
 ld (flags),a	       ; Clear a lot of vars
 ld (cBit),a
 ld hl,0
 ld (score),hl
 ld (scoreU),hl        ; Clears lines as well
 call &NewB	       ; Prepares a new piece
 ld a,(high)
 or a
 jr z,MainLoop
 ld hl,scrflag	       ; If starting with trash lines, they should
 ld b,(hl)	       ; always be scrambled even though the option
 push bc	       ; unscrambled is set
 push hl
 ld (hl),1	       ; So temporary set it to scrambled lines
 add a,a	       ; No trash lines = high*2
 call &AddLines        ; Create trash lines
 pop hl
 pop bc
 ld (hl),b	       ; And reset the scrflag

MainLoop:	       ; The main loop
 ld hl,&levelcnts
 ld a,(level)
 ld d,0
 ld e,a
 add hl,de
 ld a,(hl)	       ; A = the delay time of the current level
 ld (counter),a
DelayLoop:
 ld hl,flags
 res 1,(hl)	       ; Clear the update flag
 call GET_KEY
 cp K_EXIT
 jp z,&AbortGame
 cp K_MORE
 jp z,&Pause
 cp K_SECOND
 jr z,Rotate
 cp K_ALPHA
 jp z,&RotateBack
 cp K_DEL
 jp z,&TeacherKey
 cp K_XVAR
 jr z,Drop
 dec a
 jr z,MoveDown
 dec a
 jr z,MoveLeft
 dec a
 jr z,MoveRight
 dec a
 jr z,Rotate
Wait:
 ld hl,flags
 bit 0,(hl)	       ; Check if the player became gameover this frame
 jp nz,&GameOver
 bit 1,(hl)	       ; Check if anything happened (movements)
 call nz,&Update       ; If so, update that
 halt
 halt		       ; Halt is the best way to delay
 halt		       ; The interrupt speed is the same on turboed calcs
 halt
 ld hl,linkcnt
 dec (hl)
 call z,&GetLinkInfo   ; If the link counter reaches zero, check link port
 ld hl,counter
 dec (hl)	       ; Decrease the counter
 jr nz,DelayLoop       ; If not zero, check for keys again
 jr FallDown
MoveDown:
 ld hl,scoreU
 inc (hl)	       ; When DOWN is pressed, increase the score
FallDown:
 call &GetLinkInfo     ; Before moving down, always check linkport
 ld hl,newXY
 dec (hl)	       ; Decrease the y coordinate
 call &Update	       ; Check if possible
 jp z,&MainLoop        ; If so, repeat mainloop
BotReached:
 ld hl,cB	       ; Else the bottom is reached
 ld de,(cXY)
 ld b,4
StoreB: 	       ; Store the piece in the well
 push hl
 call LD_HL_MHL
 add hl,de
 call &PutCoord
 pop hl
 inc hl
 inc hl
 djnz StoreB
 ld a,(players)
 dec a
 call nz,&CheckBar     ; If two player, check your highest line
 call &NewB	       ; Last, randomize a new piece
 jp &MainLoop

MoveRight:
 ld hl,newXY+1
 inc (hl)	       ; Increase X coordinate
 jr SetUpdateFlag      ; Set update flag

MoveLeft:
 ld hl,newXY+1
 dec (hl)	       ; Decrease left coordinate
SetUpdateFlag:
 ld hl,flags
 set 1,(hl)	       ; Set update flag
 jr Wait

Rotate:
 ld hl,newRot
 inc (hl)
 jr SetUpdateFlag

RotateBack:
 ld hl,newRot
 dec (hl)
 jr SetUpdateFlag

Drop:
 ld hl,scoreU	       ; When dropping, increase score with the
 inc (hl)	       ; number of fallen steps
 ld hl,newXY
 dec (hl)	       ; Decrease Y coordinate
 call &Update	       ; Update it on screen
 jr z,Drop	       ; If OK, move down again
 call &GetLinkInfo     ; Get link info
 jr BotReached	       ; Bottom reached, store piece.

TeacherKey:
 ld a,(players)
 dec a
 jp nz,&Wait	       ; If two players, teacher key not allowed
 ld hl,(cBitOfs)
 ld de,(PROGRAM_ADDR)
 sbc hl,de	       ; Save the relative address
 ld (cBitOfs),hl
 ld hl,(cNBitOfs)
 sbc hl,de
 ld (cNBitOfs),hl
 inc a
 ld de,&Resume
 ld (de),a	       ; Set the resume flag
 inc de
 ld hl,cBitOfs
 ld bc,67	       ; Copy all variables
 ldir
 ld hl,board
 ld bc,40
 ldir		       ; And the well
 ld hl,USG_BITS
 set 1,(hl)
 jp &Quit	       ; And quit the game

Pause:
 ld a,(players)
 dec a
 jp nz,&Wait	       ; Pause not allowed in two player game
 call &ShowFrame
 ld hl,$0604
 ld ($800C),hl
 ld hl,&PauseTxt
 call D_ZT_STR	       ; "* PAUSE *"
PauseWait:
 call GET_KEY
 or a
 jr z,PauseWait
 call &ShowLayout      ; Show all stuff again
 call &ShowInfo
 call &ShowWell
 call &ShowCurB
 ld de,$FC05
 ld hl,cB+16
 call &ShowB	       ; And the next piece
 jp &Wait	       ; Resume the game

ShowBar:	       ; Show the bar
 ld (lastbar),a
 ld hl,$FFFB
 ld de,-16
 ld b,64
 add a,a
 add a,a
SB_Rep:
 ld c,a
 ld a,$0F
 and (hl)
 ld (hl),a
 ld a,c
 or a
 jr z,ClearBar
 ld a,$60
 or (hl)
 ld (hl),a
 dec c
ClearBar:
 ld a,c
 add hl,de
 djnz SB_Rep
 ret

AddLines:	       ; Add A lines, scrambled or unscrambled
 ld b,a
 push bc
 ld c,b
 ld b,0
 sla c
 ld de,board+34
 ld h,d
 ld l,e
 sbc hl,bc
 ld a,32
 sub c
 ld b,0
 ld c,a
 lddr
 pop bc
 ld a,b
 push af
 ld a,10
 call &PRandom
 ld (gap),a
 ld hl,board+4
AddTrashRow:
 push bc
 ld de,$FFFF
 push hl
 ld b,5
Holes:
 push bc
 ld hl,$FFFB
 ld a,(scrflag)
 or a
 jr nz,RandGap
 ld a,(gap)
 jr PutGap
RandGap:
 ld a,10
 call &PRandom
PutGap:
 ld b,a
 inc b
RotWord:
 .db $CB,$35	       ; SLL L - an undocumented Z80 instruction
 rl h
 djnz RotWord
 pop bc
 ld a,d
 and h
 ld d,a
 ld a,e
 and l
 ld e,a
 djnz Holes
 pop hl
 ld (hl),e
 inc hl
 ld (hl),d
 inc hl
 pop bc
 djnz AddTrashRow
 ld hl,newXY
 pop af
 add a,(hl)
 cp $10
 jr c,TopNotReached
 ld a,$10
TopNotReached:
 ld (hl),a
 call &Update
 push af
 call &ShowWell
 call &ShowCurB
 pop af
 jp nz,&GameOver
 ret

Update: 	       ; Update the piece on the screen.
 call &TestNewB        ; Return NZ if not possible move
 jr nz,Sync
 call &EraseCurB
 ld hl,(newXY)
 ld (cXY),hl
 ld a,(newRot)
 ld (cRot),a
 ld b,0
 call &Uncrunch
 call &ShowCurB
 xor a
Sync:
 push af
 ld hl,(cXY)
 ld (newXY),hl
 ld a,(cRot)
 ld (newRot),a
 pop af
 ret

GetLinkInfo:	       ; Fins out what happens to the opponent
 ld hl,linkcnt
 ld (hl),10	       ; Reset the link counter
 ld a,(players)
 dec a
 ret z		       ; If one player, leave this routine
 call &ReceiveByte     ; Get a byte
 or a
 jr z,CheckSByte       ; If no byte received, check if a byte should be sent
 ld b,a
 and $0F
 ld c,a
 ld a,b
 srl a
 srl a
 srl a
 srl a
 cp $0F
 jr z,PenaltyRows
 cp $0C
 jp z,&YouWinP
 cp $0D
 jr z,UpdateBar
 cp $0E
 ret nz
 ld c,16
UpdateBar:
 ld a,c
 jp &ShowBar
PenaltyRows:
 ld a,c
 inc a
 jp &AddLines

CheckSByte:
 ld a,(sbyte)	       ; Check if byte in send buffer
 or a
 call nz,&SendByte     ; If so, send it
 ret

AbortGame:
 ld a,(players)
 dec a
 jp z,&CheckHiscore    ; If one player abort, check hiscore table

GameOver:
 ld a,(players)
 dec a
 jr z,FlashGameOver    ; If a two player game, send a byte telling
 ld a,$C0	       ; that you lost
 ld b,3
SendWinByte:
 push bc
 call &SendByte
 call &ReceiveByte     ; This is for clearing up stuff (if both sent
 ld a,(sbyte)	       ; at the same time)
 or a
 pop bc
 jr z,FlashGameOver
 djnz SendWinByte
FlashGameOver:
 call GET_KEY
 cp K_ENTER
 jr z,CheckHiscore
 cp K_EXIT
 jr z,CheckHiscore
 ld a,(iy+5)
 xor 8
 ld (iy+5),a
 ld hl,$0503
 ld ($800C),hl
 ld hl,&GameOverText
 call D_ZT_STR
 ld b,30
FlashWait:
 halt
 djnz FlashWait
 jr FlashGameOver

YouWinP:
 pop hl
YouWin:
 call GET_KEY
 cp K_ENTER
 jr z,CheckHiscore
 cp K_EXIT
 jr z,CheckHiscore
 ld a,(iy+5)
 xor 8
 ld (iy+5),a
 ld hl,$0603
 ld ($800C),hl
 ld hl,&WinTxt
 call D_ZT_STR
 ld b,30
WFlashWait:
 halt
 djnz WFlashWait
 jr YouWin

CheckHiscore:
 ld a,(players)
 dec a
 jp nz,&LevelChoose    ; No hiscore when two players
 ld hl,&Hiscore+14     ; HL -> hiscore
 ld de,(score)	       ; DE = your score
 ld b,3
CheckP:
 push hl
 call LD_HL_MHL
 call CP_HL_DE
 pop hl
 jr c,ScoreGreater
 push de
 ld de,16
 add hl,de	       ; HL -> next score in hiscore table
 pop de
 djnz CheckP
 jp &LevelChoose       ; Not in hiscore table
ScoreGreater:
 ld a,4
 sub b
 ld (place),a
 cp 3		       ; If last place, no moves in hiscore table
 jr z,MoveDone
 ld hl,&Hiscore+19
MoveAgain:	       ; Else move the other people down
 ld d,h
 ld e,l
 ld bc,16
 add hl,bc
 ex de,hl
 ld bc,13
 ldir
 ld hl,&Hiscore+3
 dec a
 jr z,MoveAgain
MoveDone:
 ld a,(place)	       ; Find out where to enter your name
 ld hl,&Hiscore+3
 ld de,16
 dec a
 jr z,EnterName
 add hl,de
 dec a
 jr z,EnterName
 add hl,de
EnterName:
 push hl
 ld b,10
RepClear:
 ld (hl),32	       ; Clear the previous name
 inc hl
 djnz RepClear
 inc hl
 ld de,(score)
 ld (hl),e	       ; Put your score in the table
 inc hl
 ld (hl),d
 call &ShowFrame
 ld hl,$1210
 ld ($8333),hl
 ld hl,&EnterTxt
 call D_ZM_STR	       ; "You entered ..."
 ld de,$1926
 ld ($8333),de
 call D_ZM_STR	       ; "Enter your name"
 ld hl,$0505
 ld ($800C),hl
 pop hl
 ld b,0 	       ; B = number of letters entered so far

WaK:		       ; A simple string input routine follows
 push hl
 call GET_KEY
 cp $02
 jr z,BackSpace
 cp $09
 jr z,NameDone
 cp $11
 jr nz,CheckLetter
 ld a,32
 pop hl
 jr PutLetter
CheckLetter:
 ld hl,&Letters
 push bc
 ld bc,26
 cpir
 ld d,c
 pop bc
 pop hl
 jr nz,WaK
 ld a,65
 add a,d
PutLetter:
 ld c,a
 ld a,b
 cp 10
 jr z,WaK
 ld (hl),c
 inc hl
 inc b
 ld a,c
 call TX_CHARPUT
 jr WaK
BackSpace:
 pop hl
 ld a,b
 or a
 jr z,WaK
 dec b
 dec hl
 push hl
 ld (hl),32
 ld hl,$800D
 dec (hl)
 ld a,32
 call TX_CHARPUT
 dec (hl)
 pop hl
 jr WaK
NameDone:
 pop hl
 jp &LevelChoose

CheckBar:	       ; Find out how it goes for ya
 xor a
 ld hl,board+4
 ld b,16
RepCheckBar:
 push hl
 push af
 call LD_HL_MHL
 pop af
 ld de,%1110000000000111   ; This would indicate an empty row
 call CP_HL_DE
 pop hl
 jr z,EmptyRow
 inc a
 inc hl
 inc hl
 djnz RepCheckBar
EmptyRow:
 add a,$D0
 jp &SendByte	       ; Send high information to opponent

ShowCurB:	       ; This shows the current piece
 ld de,(cXY)
 ld hl,cB
ShowB:
 ld b,4
SNext:
 push hl
 call LD_HL_MHL
 add hl,de
 call &PutBlock        ; Put one block of the piece
 pop hl
 inc hl
 inc hl
 djnz SNext
 ret

EraseCurB:	       ; And this erase the current piece
 ld de,(cXY)
 ld hl,cB
EraseB:
 ld b,4
ENext:
 push hl
 call LD_HL_MHL
 add hl,de
 call &EraseBlock
 pop hl
 inc hl
 inc hl
 djnz ENext
 ret

TestNewB:	       ; Check if the piece is at an allowed position
 ld b,8
 ld a,(newRot)
 call &Uncrunch
 ld de,(newXY)
 ld hl,cB+8
 ld b,4
TNext:
 push hl
 call LD_HL_MHL
 add hl,de
 call &GetCoord
 jr nz,NotPoss
 pop hl
 inc hl
 inc hl
 djnz TNext
 xor a
 ret
NotPoss:
 pop hl
 ret

NewB:		       ; Creates a new piece and updates information
 ld hl,(scoreU)
 ld h,0
 call UNPACK_HL        ; L = (scoreU) DIV 10
 ld (scoreU),a	       ; (scoreU) = (scoreU) MOD 10
 ld a,l
 or a
 jr z,CheckLines       ; If scoreU was <10, no 'real' score update
 ex de,hl
 ld hl,(score)
 add hl,de
 ld (score),hl	       ; Else update the score
 call &ShowInfo        ; And on the screen as well
CheckLines:
 xor a
 ld (linesflag),a      ; This holds how many lines you eliminated
 ld hl,board+4
 ld b,17
RepScan:
 push hl
 call LD_HL_MHL
 ld de,$FFFF	       ; This would indicate a full row
 call CP_HL_DE
 jr nz,NextRow	       ; If it wasn't check next row
 pop hl
 push bc
 push de
 push hl
 ld d,h
 ld e,l
 inc hl
 inc hl
 ld c,b
 ld b,0
 sla c
 ldir		       ; Move everything down
 ld hl,linesflag
 inc (hl)	       ; Increase lines eliminated
 ld hl,lines
 inc (hl)	       ; And also the total line counter
 pop hl
 pop de
 pop bc
 jr RepScan
NextRow:
 pop hl
 inc hl
 inc hl
 djnz RepScan
 ld a,(linesflag)
 or a
 jr z,NoScoring        ; If no lines gotten, no score increase
 push af
 ld b,a
 ld a,(players)
 dec a
 jr z,NoPenLines       ; If one player, no penalty lines sent
 push bc
 call &CheckBar
 pop bc
 dec b
 jr z,NoPenLines       ; If only one line eliminated, no penatly lines
 ld a,(declines)       ; The flag, 1-3 or 2-4 lines to send
 sub b
 neg		       ; Now A = no of penalty lines
 push af
 or $F0
 call &SendByte        ; Send it over to the opponent
 pop af
 ld hl,lastbar
 add a,(hl)	       ; Increase the opponents bar
 inc a
 call &ShowBar	       ; And show it
NoPenLines:
 pop af
 ld hl,&Scoring
 ld d,0
 ld e,a
 dec e
 add hl,de
 ld h,(hl)	       ; H = score for level 0
 ld a,(level)
 inc a
 ld l,a
 call MUL_HL	       ; Multiply with (level+1)
 ex de,hl
 ld hl,Score
 push hl
 call LD_HL_MHL
 add hl,de	       ; Add with total score so far
 ex de,hl
 pop hl
 ld (hl),e	       ; Store the new score
 inc hl
 ld (hl),d
 call &ShowWell        ; Update the well
NoScoring:
 ld h,0
 ld a,(lines)
 ld l,a
 call UNPACK_HL        ; HL = lines DIV 10
 ld a,(level)
 cp l		       ; Check if the level should increase
 jr nc,NoNewLevel
 ld a,l
 ld (level),a	       ; Update the levle
 call &PastePattern    ; Remove the last pattern
 call &ShowPattern     ; And update it with the new pattern
 ld a,(players)
 dec a
 jr z,NoNewLevel
 ld a,(lastbar)
 call &ShowBar
NoNewLevel:
 call &ShowInfo        ; Update score, level and lines on screen
CreateNew:
 call &CreateNewPiece  ; Randomize new piece
 xor a
 ld (cRot),a
 ld (newRot),a
 ld b,0
 call &Uncrunch        ; Uncrunch the piece
 ld hl,$0610
 ld (cXY),hl
 ld (newXY),hl
 call &TestNewB        ; Check if it's possible to put out the piece
 jr z,NotDead
 ld hl,flags
 set 0,(hl)	       ; If not, set dead flag
NotDead:
 jp &ShowCurB	       ; Show the current piece

ShowInfo:	       ; Updates score, level and lives
 ld hl,$0E61
 ld ($8333),hl
 ld hl,Score
 call LD_HL_MHL
 call DM_HL_DECI
 ld hl,$2261
 ld ($8333),hl
 ld hl,Level
 ld l,(hl)
 ld h,0
 call DM_HL_DECI
 ld hl,$3461
 ld ($8333),hl
 ld hl,Lines
 ld l,(hl)
 ld h,0
 jp DM_HL_DECI

CreateNewPiece:
 ld de,$FC05
 ld hl,cB+16	       ; Remove the next piece
 call &EraseB
RandP:
 ld a,(next)
 ld (cBit),a
 ld hl,(cNBitOfs)      ; Make it the current piece instead
 ld (cBitOfs),hl
 ld a,7
 call &PRandom		; Get a random number between 0-6
 inc a		       ; Increase with 1 to get between 1-7
 ld (next),a
 add a,a
 add a,a
 add a,a
 ld hl,&BitData-8
 ld d,0
 ld e,a
 add hl,de	       ; Find out where the bit structure is
 ld (cNBitOfs),hl
 ld b,16
 xor a
 call &Uncrunch2
 ld de,$FC05
 ld hl,cB+16
 jp &ShowB	       ; Show the next piece

Uncrunch:	       ; Extracts the piece from compressed data
 ld hl,(cBitOfs)
Uncrunch2:
 and %00000011
 ld d,0
 ld e,a
 sla e
 add hl,de
 push hl
 ld hl,cB
 ld d,0
 ld e,b
 add hl,de
 ex de,hl
 pop hl
 call LD_HL_MHL
 ld b,8
URep:
 ld a,l
 and %00000011
 ld (de),a
 inc de
 rr h
 rr l
 rr h
 rr l
 djnz URep
 ret

PutCoord:	       ; Stores a block in the wello
 push hl
 call &GetBoardOfs
 or (hl)
 ld (hl),a
 pop hl
 ret

GetCoord:	       ; Finds out if there is a block in the well at H,L
 push hl
 call &GetBoardOfs
 and (hl)
 pop hl
 ret

GetBoardOfs:	       ; Convert location H,L to an address, HL
 push bc
 ld c,l
 sla c
 bit 3,h
 jr z,LeftPart
 inc c
LeftPart:
 ld b,h
 ld a,1
RotateAgain:
 rlca
 djnz RotateAgain
 ld hl,board
 ld b,0
 add hl,bc
 pop bc
 ret

PutBlock:	       ; Put block at H,L
 push bc
 push de
 push hl
 call &GetBlockOfs
PutRow:
 push af
 or (hl)
 ld (hl),a
 pop af
 add hl,de
 djnz PutRow
 pop hl
 pop de
 pop bc
 ret

EraseBlock:	       ; Erase a block at H,L
 push bc
 push de
 push hl
 call &GetBlockOfs
 xor $FF
EraseRow:
 push af
 and (hl)
 ld (hl),a
 pop af
 add hl,de
 djnz EraseRow
 pop hl
 pop de
 pop bc
 ret

GetBlockOfs:	       ; Finds out where on the screen H,L is
 ld c,h
 ld h,0
 ld a,17
 sub l
 ld l,a
 sla l
 sla l
 sla l
 add hl,hl
 add hl,hl
 add hl,hl
 ld a,c
 srl a
 add a,4
 ld d,0
 ld e,a
 add hl,de
 ld de,$FC00
 add hl,de
 ld b,4
 ld de,16
 ld a,$F0
 bit 0,c
 ret z
 ld a,$0F
 ret

PRandom:	       ; Creates a pseudorandom number 0 <= x < A
 push bc
 push de
 push hl
 ld b,a
 ld a,r
 add a,a
 ld hl,0
 ld d,0
 ld e,a
RMul:
 add hl,de
 djnz RMul
 ld a,h
 pop hl
 pop de
 pop bc
 ret

ShowPattern:	       ; Show pattern for the current level
 ld hl,&Pattern
 ld a,(level)
 cp 16
 jr c,Below16
 ld a,15	       ; If level>15, show pattern for level 15
Below16:
 add a,a
 add a,a
 add a,a
 ld d,0
 ld e,a
 add hl,de
 push hl
 pop ix
 ld de,$8641
 ld b,8
SP_Row:
 push bc
 push ix
 pop hl
 ld b,8
SP_Line:
 ld a,(hl)
 inc hl
 push bc
 ld b,16
SP_Byte:
 ld (de),a
 inc de
 djnz SP_Byte
 pop bc
 djnz SP_Line
 pop bc
 djnz SP_Row
 ld ix,&Gaps
 ld b,(ix-1)
MakeGap:
 push bc
 ld h,(ix+1)
 ld l,(ix)
 ld de,$8641
 add hl,de
 ld a,(ix+2)
 ld b,(ix+3)
MK_Row:
 push bc
 push hl
 ld d,a
 ld b,(ix+4)
MK_Col:
 ld c,a
 and (hl)
 ld (hl),a
 ld a,c
 rrca
 jr c,MK_SameByte
 inc hl
MK_SameByte:
 djnz MK_Col
 ld a,d
 pop hl
 pop bc
 ld de,16
 add hl,de
 djnz MK_Row
 ld de,5
 add ix,de
 pop bc
 djnz MakeGap
PastePattern:	       ; XOR the pattern on the screen
 ld hl,$FC00
 ld de,$8641
PasteIt:
 ld a,(de)
 xor (hl)
 ld (hl),a
 inc de
 inc hl
 ld a,h
 or l
 jr nz,PasteIt
 ret

ShowWell:	       ; Show the whole well
 ld hl,$0302
SWNewRow:
 ld b,10
RepPut:
 call &GetCoord
 push af
 call z,&EraseBlock
 pop af
 call nz,&PutBlock
 inc h
 djnz RepPut
 ld h,$03
 inc l
 ld a,l
 cp $12
 jr nz,SWNewRow
 ret

ShowFrame:	       ; Clears the screen and shows some info
 call CLEARLCD
 ld hl,0
 ld ($800C),hl
 set 3,(iy+5)
 ld hl,&Title
 call D_ZT_STR
 res 3,(iy+5)
 ld hl,$3A02
 ld ($8333),hl
 ld hl,&Coder
 jp D_ZM_STR

ShowLayout:	       ; Shows the game layout
 call &ShowFrame
 call CLEARLCD
 ld bc,$0761
 ld ($8333),bc
 ld hl,&InfoText
 call D_ZM_STR
 ld bc,$1B61
 ld ($8333),bc
 call D_ZM_STR
 ld bc,$2D63
 ld ($8333),bc
 call D_ZM_STR
 ld hl,&ZTet
 ld de,$FC60
 ld b,9
GFXNewRow:
 push bc
 ld bc,5
 ldir
 ld bc,11
 ex de,hl
 add hl,bc
 ex de,hl
 pop bc
 djnz GFXNewRow
 ld de,16
 ld b,64
 ld ix,$FC00
DWNextRow:
 ld (ix+5),$10
 ld (ix+10),$08
 add ix,de
 djnz DWNextRow
 ld hl,$1406
 ld ($8333),hl
 ld hl,&Coder
 ld b,8
 call D_LM_STR
 push hl
 ld hl,$1A07
 ld ($8333),hl
 pop hl
 ld b,8
 call D_LM_STR
 jp &ShowPattern

Quit:		       ; Quits the program
 ld hl,$8641
 ld (hl),0
 ld d,h
 ld e,l
 inc de
 ld bc,1023
 ldir		       ; Clear graph memory
 ret

#include linkrout.h    ; Some very nice linkroutines

;
;	  	           	
;     	         	  	  
;

BitData:	       ; Compressed data of the pieces (28 pieces)
 .dw %0001010110011000,%0110010100000100
 .dw %0010000101011001,%0110101001010100
 .dw %0001010110010000,%0010011001010100
 .dw %0001010110011010,%0110010101001000
 .dw %0101100101001000,%0101100101001000
 .dw %0101100101001000,%0101100101001000
 .dw %0001010110010100,%0001011001010100
 .dw %0001011001011001,%0110010101001001
 .dw %0000010101001001,%0010000101010100
 .dw %0000010101001001,%0010000101010100
 .dw %0001010101001000,%0001000001100101
 .dw %0001010101001000,%0001000001100101
 .dw %0001010110011101,%0111011001010100
 .dw %0001010110011101,%0111011001010100

Pattern:	       ; Pattern for each level
 .db $AA,$55,$AA,$55,$AA,$55,$AA,$55
 .db $88,$FF,$22,$FF,$88,$FF,$22,$FF
 .db $FF,$99,$99,$FF,$FF,$99,$99,$FF
 .db $50,$D7,$14,$F7,$00,$F7,$14,$D7
 .db $EA,$AA,$AE,$00,$57,$55,$75,$00
 .db $FE,$AA,$AA,$AA,$28,$AA,$FE,$00
 .db $55,$55,$AA,$AA,$55,$55,$AA,$AA
 .db $80,$FE,$02,$FB,$08,$EF,$20,$BF
 .db $EE,$EE,$EE,$00,$77,$77,$77,$00
 .db $66,$CC,$99,$33,$66,$CC,$99,$33
 .db $CC,$33,$CC,$33,$CC,$33,$CC,$33
 .db $FE,$82,$BA,$AA,$BA,$82,$FE,$00
 .db $CC,$CC,$33,$33,$CC,$CC,$33,$33
 .db $FF,$AA,$FF,$AA,$FF,$AA,$FF,$AA
 .db $7C,$FE,$7C,$00,$7C,$FE,$7C,$00
 .db $FF,$EF,$47,$12,$B8,$FD,$FF,$FF

 .db 6
Gaps:		       ; Gaps where the pattern shouldn't be shown
 .dw $005 \ .db $EF,64,42
 .dw $07B \ .db $FE,14,23
 .dw $1BB \ .db $FE,14,23
 .dw $2DB \ .db $FE,14,23
 .dw $321 \ .db $FD,12,20
 .dw $040 \ .db $7F,30,43

Scoring:	       ; Score for each level
 .db 4,10,30,120

InfoText:
 .db "Score",0
 .db "Level",0
 .db "Lines",0

LevelCnts:
 .db 40,36,32,28,25,22,19,17,15,13,11,10,9,8,7,6,5,4,3,2,1

Resume:
 .db 0
 .db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

Hiscore:
 .db "1. ----------",0,0,0
 .db "2. ----------",0,0,0
 .db "3. ----------",0,0,0

Title:
 .db "ZTetris v3.0         ",0

Coder:
 .db "by Jimmy Mardell  "
 .db "<mja@algonet.se>",0

PlChoose:
 .db "Choose player mode",0
 .db "1 player",0
 .db "2 players",0

GameOverText:
 .db " Game Over ",0

WinTxt:
 .db " You Win ",0

PauseTxt:
 .db "* PAUSE *",0

WaitTxt:
 .db "* WAITING *",0

EnterTxt:
 .db "You entered the hiscore table!",0
 .db "Enter your name:",0

HighTxt:
 .db "High",0

SLTxt:
 .db "Send 2-4 lines",0
NLTxt:
 .db "2-4",0
 .db "1-3",0
ScrambleTxt:
 .db "unscrambled",0
 .db "scrambled  ",0

Letters:
 .db $19,$21,$0A,$12,$1A,$22,$0B,$13,$1B,$23,$2B
 .db $0C,$14,$1C,$24,$2C,$0D,$15,$1D,$25,$2D,$0E
 .db $16,$1E,$26,$2E

ZTet:
 .db %00111111,%11000000,%00000000,%00000000,%00000000
 .db %00111111,%11000000,%00000000,%00000000,%00000000
 .db %00100001,%10000000,%00000000,%00000000,%00000000
 .db %00100011,%00000000,%00000000,%00000000,%00000000
 .db %00000110,%00011101,%10111011,%00101100,%01100010
 .db %00001100,%01010101,%00101010,%10101000,%00010101
 .db %00011000,%01000101,%10001011,%00101110,%01100101
 .db %00111111,%11000101,%00001010,%10100010,%00010101
 .db %00111111,%11000101,%11001010,%10101110,%01101010

.end
