         .include "asm86.h"
         .include "ti86asm.inc"

TEXT_MEM          =_textShadow
GRAPH_MEM         =_plotSScreen
DELC_LEN          =$C012
CURSOR_ROW        =_curRow
CURSOR_COL        =_curCol
CURSOR_X          =_penCol
CURSOR_Y          =_penRow
CONTRAST          =$C008

#define ROM_CALL(index) call index

D_ZT_STR          =_puts
TX_CHARPUT        =_putc
D_ZM_STR          =_vputs
CLEARLCD          =_clrLCD

         .org     _asm_exec_ram

         nop
         jp       start___
         .dw      0
         .dw      prog_name
start___:
#ifndef  dont_clear_text_mem
         ld       hl,$c0f9
         ld       b,168
lctm:    ld       (HL),0
         inc      hl
         djnz     lctm
#endif
         ld       (iy+13),0
         call     prog_code
         ld       (iy+13),6
         ld       hl,0
         ld       ($c00f),hl
         jp       _clrScrn


#ifdef need_FIND_PIXEL
___offsets_table:
         .db      128,64,32,16,8,4,2,1
FIND_PIXEL:
         ld       a,b
         and      7
         ld       hl,___offsets_table
         ld       e,a
         ld       d,0
         add      hl,de

         ld       a,c
         add      a,a
         add      a,a
         rl       d
         add      a,a
         rl       d
         add      a,a
         rl       d
         srl      b
         srl      b
         srl      b
         or       b
         ld       e,a
         ld       a,(hl)
         ret
#endif

#ifdef need_DIV_A_HL
DIV_A_HL:ld       a,10
         push     bc
         LD       C,A
         SUB      A
         LD       B,$10         
Label1:  ADD      HL,HL
         RLA     
         CP       C
         JR       C,Label0
         SUB      C
         INC      L
Label0:  DJNZ     Label1
         pop      bc
         RET                    ;A = remainder, HL = quotient
#endif

#ifdef need_MUL_A_DE
MUL_A_DE:PUSH     BC
         LD       B,8
         LD       L,0                
Mul_Loop:ADD      HL,HL
         RLA
         JR       NC,NoAdd
         ADD      HL,DE
NoAdd:   DJNZ     Mul_Loop
         POP      BC
         RET
#endif

#ifdef need_D_HL_DECI
D_HL_DECI:
         push     bc
         ld       de,up_data+4
         ld       b,5
ldhld:   call     UNPACK_HL
         add      a,48
         ld       (de),a
         dec      de
         djnz     ldhld
         ld       hl,up_data
         ld       b,4
lis:     ld       a,(hl)
         cp       48
         jr       nz,dis
         ld       (hl),32
         inc      hl
         djnz     lis
dis:     ld       hl,up_data
         call     _puts
         pop      bc
         ret
#endif

#ifdef need_D_HL_HEX
D_HL_HEX:
         push     bc
         ld       de,up_data+4
         ld       b,4
hldhld:  ld       a,16
         call     DIV_A_HL+2
         CP       10
         JP       M,no10hl
         add      a,7
no10hl:  add      a,48
         ld       (de),a
         dec      de
         djnz     hldhld
         ld       hl,up_data+1
         call     _puts
         pop      bc
         ret
#endif

#ifdef need_D_A_HEX
D_A_HEX:
         ld       l,a
         ld       h,0
         push     bc
         ld       de,up_data+4
         ld       b,2
aldhld:  ld       a,16
         call     DIV_A_HL+2
         cp       10
         jp       m,no10a
         add      a,7
no10a:   add      a,48
         ld       (de),a
         dec      de
         djnz     aldhld
         ld       hl,up_data+3
         call     _puts
         pop      bc
         ret
#endif

up_data: .db      "PAD97",0

#define LOCATE(x,y) ld de,(x*256)+y \ ld (CURSOR_ROW),de
