#include "asm86.h"
#include "ti86abs.inc"
#include "ti86asm.inc"
#include "ti86un.inc"

board			equ		$b000		;piece positions
cur_pos		equ		board-1	;0-63,bit 7=cursor type
piece_temp		equ		board-2	;save piece when moving
saved_pos		equ		board-3	;original piece locatn
temp_count		equ		board-4

h_flags		equ		board+64	;the history's flags
h_stack_ptr		equ		board+65	;ptr to stack end
h_stack		equ		board+67	;history stack


.org _asm_exec_ram


 call _flushallmenus

 ld hl,h_stack
 ld (h_stack_ptr),hl
 ld hl,start_pos			;copy initial positions
 ld de,board
 ld bc,64
 ldir
 set 3,(iy+$2f)
 res 7,(iy+$2f)
start:
 call OpenGray			;load interrupt
 call _runindicoff

 ld hl,GrayPic_bit1		;first bitplane
 ld de,$fc00
 ld bc,1024
 ldir
 ld hl,GrayPic_bit2		;second bitplane
 ld de,$ca00
 ld bc, 1024
 ldir
 
 ld hl,$0d53
 ld (_penCol),hl
 ld hl,author
 call _vputs
 ld hl,$1653
 ld (_penCol),hl
 ld hl,zoot
 call _vputs
 ld hl,$3a52
 ld (_penCol),hl
 ld hl,last
 call _vputs
 ld a,36				;start cursor on 36th square
 ld (cur_pos),a
 res 6,(iy+$2f)			;white's move

 ld a,%1000
 xor (iy+$2f)			;disp_turn also changes
 ld (iy+$2f),a			; the turn, so change it first
 call disp_turn

 call refresh			;initial refresh
 call reprint_move

waitkey:
 ld a,(UserCounter)
 cp 70				;cursor blinks every
 call nc,cursor_action		; 70 interrupts
 ld a,%1111110
 out (1),a
 nop
 in a,(1)
 rra
 jp nc,down
 rra
 jp nc,left
 rra
 jp nc,right
 rra
 jp nc,up
 ld a,%1111101
; out (1),a
; nop
; in a,(1)
; rra
; rra
; jp nc,inc_contrast
; rra
; jp nc,dec_contrast
 ld a,%1011111
 out (1),a
 nop
 in a,(1)
 bit 7,a
 jp z,takeback
 ld a,%1101111
 out (1),a
 nop
 in a,(1)
 bit 7,a
 jp z,toggle_sides
 ld a,%111111
 out (1),a
 nop
 in a,(1)
 bit 5,a
 call z,second
 ld a,%111111
 out (1),a
 nop
 in a,(1)
 bit 5,a
 call nz,reset_sflag
 bit 4,a
; jp z,view_history
 bit 3,a
 jp z,save_game
 bit 2,a
 jp z,load_game
 bit 6,a
 jr nz,waitkey

 jp CloseGray		;disable int, clear pages and exit

reset_sflag:
 res 0,(iy+$2f)
 ret

inc_contrast:		;these don't work, im 2?
 call key_delay
 ld a,($c008)
 cp $1f
 ret p
 inc a
 out (2),a
 ld ($c008),a
 ret

dec_contrast:
 call key_delay
 ld a,($c008)
 or a
 ret z
 dec a
 out (2),a
 ld ($c008),a
 ret

title:
.db " Z-Blitz v .7   "
author:
.db "by Dux Gregis",0
zoot:
.db "White's Move ",0
w_move:
.db "White",0
b_move:
.db "Black",0
last:
.db "Last:",0

refresh:				;update the screen with
 ld hl,board			;board positions
 ld b,64
refresh_loop:
 ld a,(hl)
 and 15				;ignore the top bits of each piece
 call putsprite			;put the piece
 inc l				;inc hl
 djnz refresh_loop		;repeat 64 times
 ret

putsprite:
 push hl			;save hl (refresh board position)
 push bc			;save bc (refresh loop counter)
 inc a
 ld ixl,a			;copy a to ix low
 ld a,l			;a contains board position (0-63)
 call casper		;get row / column in bc from a
 push af			;push carry flag
 call get_offset
 ex de,hl			;screen offset in de
 ld hl,pieces
 pop af			;pop carry flag to correct for black
 call c,fix_black
 push de			;save destination for bitmap 2
 ld bc,32
piece_loop:
 dec ixl			;dec ixl
 jr z,piece_end
 add hl,bc			;add 32 for each piece
 jr piece_loop
piece_end:
 call put_loop		;put sprite to video mem
 ex (sp),hl			;hl = pushed de, next pop = this hl
 ld de,VIDEO_MEM-_plotSScreen-6
 and a				;reset carry
 sbc hl,de
 ex de,hl			;de points to plotscreen w/ offset
 pop hl			;hl points to second layer of sprite
 call put_loop		;put sprite to plotscreen
 pop bc
 pop hl
 ret

 
put_loop:
 ld bc,8			;sprite size
the_loop:
 ldi				;ld (de),(hl) and dec bc
 ret po			;return when bc is 0
 ld a,e
 add a,15
 ld e,a			;add 15 to e
 jr the_loop		;never carries


;row/col representation looks like: b=0-7, c=0-7
;returns row in b and col in c, input = square in a (0-63)
;bits 0,1,2 are the row; bits 3,4,5 are the col

casper:
 and 63
 ld b,a
 srl b		;divided by 8 to get row
 srl b
 srl b
 and 7		;and with 7 to get col
 ld c,a
 xor b		;xor col with row, bit 0 will be set if 
			; on black square (think about it :-)
 rra			;so copy that bit into the carry flag
 ret

get_offset:
 ld hl,$fc01
 sub a
 cp b
 jr z,skip_offset
 ld de,128
s_mult:			;multiply b by 128 and add it to hl
 add hl,de
 djnz s_mult
skip_offset:
 ld a,l
 add a,c			;add column (never carries)
 ld l,a
 ret

fix_black:			;adjust offset for black squares
 ld bc,16
 add hl,bc
 ret

cursor_action:
 ld hl,cur_pos
 sub a			;clear the counter
 ld (UserCounter),a
 bit 6,(iy+$2f)
 jr nz,held			;if it's held, no cursor blink
 or (hl)			;ld a,(hl) but set flags
 jp m,invert		;check bit 7 of (hl)
 set 7,(hl)			;if bit 7 of (cur_pos) set,
 jp refresh			; then the cursor pos is black
invert:
 res 7,(hl)
 call casper		;a = (cur_pos)
 call get_offset
 push hl
 ld de,16
 ld b,8
invert_loop:		;write a black square to both
 ld (hl),$ff		; bitplanes, it'll get cleared again
 add hl,de			; with a refresh call
 djnz invert_loop
 pop hl
 ld bc,VIDEO_MEM-_plotSScreen-6
 and a
 sbc hl,bc
 ld b,8
invert_loop2:
 ld (hl),$ff
 add hl,de
 djnz invert_loop2
 ret

held:			;if a piece is held, put the held cursor
 ld a,(hl)			;to the screen
 call casper
 call get_offset
 ex de,hl
 ld hl,cursor
 push hl
 push de
 call put_loop
 pop hl
 ld de,VIDEO_MEM-_plotSScreen-6
 and a
 sbc hl,de
 ex de,hl
 pop hl
 call put_loop
 ret

second:				;toggle cursor, pick up / set piece
 bit 0,(iy+$2f)
 ret nz
 set 0,(iy+$2f)
 ld a,(cur_pos)
 and 63				;mask out the flag on bit 7
 ld l,a
 ld h,$b0
 ld a,(hl)				;a = piece at (cur_pos)
 bit 6,(iy+$2f)			;switch cursors
 jr nz,reset_cursor
set_cursor:
 or a
 jr z,c_action			;don't set if no piece
 ld c,a				;save piece in c
 xor (iy+$2f)			;if bit 3 (black) is set in both 
 bit 3,a				;or not set in both, then return
 jr z,c_action
 set 6,(iy+$2f)			;enable 2nd cursor
 ld a,c				;get saved piece
 ld (piece_temp),a		;keep it here until drop piece
 ld a,l
 ld (saved_pos),a			;save pos to later check validity
 ld (hl),0				;clear square where piece picked up
 jr c_action
reset_cursor:
 push hl				;save hl (points to board pos)
 ld a,(cur_pos)
 and 63
 ld hl,saved_pos
 cp (hl)				;don't change sides when not moved
 jr z,disp
 call validity			;check validity
 call disp_turn			;display whose move it is
 call print_move			;display last (this) move
 call h_push
 ld hl,piece_temp
 res 7,(hl)
disp:
 call clear_invalid		;clear any invalid move message
 res 6,(iy+$2f)
 pop hl
 ld a,(piece_temp)
 ld (hl),a				;ld piece to board position
c_action:
 jp cursor_action

disp_turn:				;prints the turn and changes
 ld hl,$1653			; whose turn it is
 ld (_penCol),hl
 bit 3,(iy+$2f)
 jr z,disp_black
disp_white:
 res 3,(iy+$2f)
 ld hl,b_move
 jp _vputs
disp_black:
 set 3,(iy+$2f)
 ld hl,w_move
 jp _vputs

print_move:			;prints the last move
 ld a,$3a
 ld (_penRow),a
 ld a,$65
 ld (_penCol),a
 ld a,(saved_pos)
 bit 7,(iy+$2f)
 call nz,fix_for_reverse
 ld b,a
 ld a,(cur_pos)
 and 63
 bit 7,(iy+$2f)
 call nz,fix_for_reverse
 ld c,a

print:			;print b-c as the last move
 push bc
 ld a,b
 call disp_chars
 ld a,'-'
 call _vputmap
 pop bc
 ld a,c
 call disp_chars
 ld a,' '
 jp _vputmap

fix_for_reverse:
 xor 63
 ret

reprint_move:			;print again when move popped
 ld hl,h_stack_ptr
 call $33			;ld hl,(hl)
 ld de,$b043
 call _cphlde			;cp hl,de
 jr z,print_blank_move
 dec hl
 ld a,(cur_pos)
 push af
 ld a,(hl)
 bit 7,(iy+$2f)
 call nz,fix_for_reverse	;must be fixed if black is on bottom
 ld (cur_pos),a
 dec hl
 ld a,(hl)
 bit 7,(iy+$2f)
 call nz,fix_for_reverse	;must be fixed if black is on bottom
 ld (saved_pos),a
 call print_move
 pop af
 ld (cur_pos),a
 ret

print_blank_move:			;when on first move
 ld a,$3a
 ld (_penRow),a
 ld a,$65
 ld (_penCol),a
 ld hl,spaces2
 jp _vputs

disp_chars:				;disp chars for board pos in a
 call casper
 ld a,c				;column in a
 ld hl,char_map
 call add_hl_a			;find offset in char_map
 ld a,(hl)
 call _vputmap			;put that character
 ld a,b				;row in a
 ld hl,char_map2
 call add_hl_a			;find offset in char_map2
 ld a,(hl)
 jp _vputmap			;and put that char

add_hl_a:				;add hl,a
 add a,l
 ld l,a
 ret nc
 inc h
 ret

char_map:
.db "A","B","C","D","E","F","G","H"
char_map2:
.db "8","7","6","5","4","3","2","1"

validity:
 ld l,a
 ld h,$b0
 ld a,(hl)			;a = piece on square that was a
 or a
 jr z,piece_valid		;if there is no piece, move so far valid
 ld hl,piece_temp
 xor (hl)
 bit 3,a
 jp z,unascribed		;invalid if taking piece of same color
 
piece_valid:
 ld a,(saved_pos)
 call casper
 ld d,b			;when entering the specific check for
 ld e,c			; each piece, de is row/col of position
 ld a,(cur_pos)	; moved from
 call casper		; and bc is row/col of pos moved to
 ld a,(piece_temp)
 call adjust_piece	;if piece is black, make it white
 cp 1
 jr z,check_pawn
 cp 5
 jp z,check_rook
 cp 2
 jp z,check_knight
 cp 3
 jp z,check_knight
 cp 4
 jp z,check_bishop
 cp 6
 jp z,check_queen
 cp 7
 jp z,check_king
 ret

check_pawn:
 ld a,(piece_temp)	;two different algorithms for white
 bit 3,a			; and black pieces
 jr z,top_pawn
bottom_pawn:
 bit 7,(iy+$2f)		; unless white on top
 jr nz,tp
bp:
 ld a,b			;b = pos moved to row
 sub d			;subtract pos moved from row
 cp 2				;if 2, make sure pawn's 1st move
 jr z,check_first_move_pawn
 cp 1				;anything other than 1 or 2
 jp nz,unascribed		; is invalid
 ld a,c
 sub e
 call abs_value
 cp 1				;if pawn moves forward 1 & also
 jr z,check_pawn_attack	; 1 horz, then it must take piece
 or a
 jp nz,unascribed		;more than 1 is always invalid
 ld a,(hl)
 or a				;if this far, pawn is moving forward
 jp nz,unascribed		; 1 square; make sure not taking piece
 ret				; return means it's valid

check_pawn_attack:	;this is valid if taking any piece
 ld a,(hl)			;we already know it's not its own color
 or a
 jp z,unascribed
 ret

check_first_move_pawn:
 ld a,(piece_temp)
 or a
 jp p,unascribed		;bit 7 not set, then piece has
 ld a,c			; already moved
 sub e
 call abs_value
 or a
 jp nz,unascribed		;can't move horzontally
 sub a
 cp (hl)			;compare (hl) to 0
 jp nz,unascribed
 ld bc,8
; or a				;reset carry
 sbc hl,bc			;subtract 8 from hl (1 row down)
 cp (hl)			;ensure no piece is jumped over
 jp nz,unascribed
 ld hl,piece_temp
 set 6,(hl)
 ret				;returns only if valid


top_pawn:			;same as above but in the other
 bit 7,(iy+$2f)		; direction
 jr nz,bp
tp:
 ld a,d
 sub b
 cp 2
 jr z,check_first_move_pawn2
 cp 1
 jp nz,unascribed
 ld a,c
 sub e
 call abs_value
 cp 1
 jr z,check_pawn_attack2
 or a
 jp nz,unascribed
 ld a,(hl)
 or a
 jp nz,unascribed
 ret
check_pawn_attack2:
 ld a,(hl)
 or a
 jp z,unascribed
 ret

check_first_move_pawn2:
 ld a,(piece_temp)
 or a
 jp p,unascribed
 ld a,c
 sub e
 call abs_value
 or a
 jp nz,unascribed
 sub a
 cp (hl)
 jp nz,unascribed
 ld bc,8
 add hl,bc
 cp (hl)
 jp nz,unascribed
 ld hl,piece_temp
 set 6,(hl)
 ret

;queen also has to call rook's algorithm, so if chr
;carries, then it's a valid move

check_rook:
 call chr
 ret c
 jp unascribed

chr:
 ld a,(saved_pos)
 ld l,a
 ld a,b
 cp d				;compare saved row to current row
 jr z,good_return
; jr z,a2
 ld a,c
 cp e				;compare saved column to current column
 jr nz,bad_return		;invalid if both row and column changes
; jr a3

good_return:		;good return if carry flag set
 scf
 ret
bad_return:			;bad if not set
 or a
 ret


;the following doesn't work for either the rook or the bishop
;I tried every hack I could think of, but with no success
;if anyone could fix it, or even understand why it doesn't work,
;I would appreciate it

a2:				;check if rook crosses any pieces on
				;it's horizontal file
 ld a,c
 sub e
 call abs_value
 ld ix,$a000
 ld ixl,a
 ld (temp_count),a
 ld a,c
 cp e
 jr c,e_greater

c_greater:
 inc e
 ld a,c
 sub e
 jr z,good_return
 call get_square_de
 ld a,(hl)
 and 63
 jr nz,bad_return
 jr c_greater

e_greater:
 dec e
 ld a,c
 sub e
 jr z,good_return
 call get_square_de
 ld a,(hl)
 and 63
 jr nz,bad_return
 jr e_greater

test_ix:			;just a hack I tried
 ld a,(temp_count)
 ld c,a
 xor a
 ld b,a
 ld hl,$a001
ix_loop:
 cpi
 jp po,good_return
 jr nz,bad_return
 jr ix_loop
 
a3:				;check if rook crosses any pieces on
				;it's vertical file
 ld a,d
 sub b
 call abs_value
 ld ix,$a000
 ld ixl,a
 ld (temp_count),a
 ld a,b
 cp d
 jr c,b_greater

b_ngreater:
 inc d
 ld a,d
 sub b
 jr z,good_return
 call get_square_de
 ld a,(hl)
 and 63
 jr nz,bad_return
 jr b_ngreater

b_greater:
 dec d
 ld a,b
 sub d
 jr z,good_return
 call get_square_de
 ld a,(hl)
 and 63
 jr nz,bad_return
 jr b_greater

check_knight:
 ld a,b
 sub d
 jp z,unascribed
 call abs_value
 ld d,a			;put copy of change in row into d
 ld a,c
 sub e
 jp z,unascribed
 call abs_value
 add a,d
 cp 3				;change in row + change in col must = 3
 jp nz,unascribed
 ret

abs_value:
 bit 7,a
 ret z
 neg
 ret

check_king:
 ld a,b
 sub d
 call abs_value
 ld d,a			;copy of change in row in d
 ld a,c
 sub e
 ld e,a
 call abs_value
 cp 2				;if col changes by two, possible castle
 jr z,check_castle
 or d				;can change in any direction
 cp 1				;but never more than 1
 jp nz,unascribed
 ret

check_castle:
 ld a,(piece_temp)
 or a
 jp p,unascribed		;make sure king has never moved
 ld a,e
 or a
 ld a,(saved_pos)
 ld l,a
 ld h,$b0
 jp m,castle_high		;flag still set from or a

castle_low:
 bit 7,(iy+$2f)
 jr nz,castle_low2
 inc l
 sub a
 cp (hl)
 jp nz,unascribed
 inc l
 cp (hl)
 jp nz,unascribed
 inc l
 ld a,(hl)
 bit 7,a
 jp z,unascribed
 call adjust_piece
 cp 5
 jp nz,unascribed
 ld c,(hl)
 ld (hl),0
 dec l
 ld a,(piece_temp)
 res 7,a
 ld (hl),a
 dec l
 ld (hl),c
 dec l
 ld (hl),0
 ret

castle_low2:
 inc l
 sub a
 cp (hl)
 jp nz,unascribed
 inc l
 cp (hl)
 jp nz,unascribed
 inc l
 cp (hl)
 jp nz,unascribed
 inc l
 ld a,(hl)
 bit 7,a
 jp z,unascribed
 call adjust_piece
 cp 5
 jp nz,unascribed
 ld c,(hl)
 ld (hl),0
 dec l
 dec l
 ld a,(piece_temp)
 res 7,a
 ld (hl),a
 dec l
 ld (hl),c
 dec l
 ld (hl),0
 ret

castle_high:
 dec l
 sub a
 cp (hl)
 jp nz,unascribed
 dec l
 cp (hl)
 jp nz,unascribed
 dec l
 bit 7,(iy+$2f)
 jr nz,castle_high2
 cp (hl)
 jp nz,unascribed
 dec l
 ld a,(hl)
 bit 7,a
 jp z,unascribed
 call adjust_piece
 cp 5
 jp nz,unascribed
 ld c,(hl)
 ld (hl),0
 inc l
 inc l
 ld a,(piece_temp)
 res 7,a
 ld (hl),a
 inc l
 ld (hl),c
 inc l
 ld (hl),0
 ret

castle_high2:
 ld a,(hl)
 bit 7,a
 jp z,unascribed
 call adjust_piece
 cp 5
 jp nz,unascribed
 ld c,(hl)
 ld (hl),0
 inc l
 ld a,(piece_temp)
 res 7,a
 ld (hl),a
 inc l
 ld (hl),c
 inc l
 ld (hl),0
 ret

;mask out flags and make color generic
adjust_piece:
 and 15
 bit 3,a
 ret z
 res 3,a
 inc a
 ret

check_bishop:
 call chb
 ret c
 jp unascribed
chb:
 ld a,b
 sub d
 call abs_value
 ld ixl,a
 ld a,c
 sub e
 call abs_value
 cp ixl
 jp z,good_return
 jp bad_return

a4:
 ld a,b
 cp d
 ld a,c
 jr c,b_up
b_down:
 cp e
 jr nc,b_down_right
b_down_left:
 inc c
 dec b
 ld a,c
 cp e
 jp z,good_return
 call get_square_bc
 ld a,(hl)
 or a
 jp nz,bad_return
 jr b_down_left

b_down_right:
 dec b
 dec c
 ld a,c
 cp e
 jp z,good_return
 call get_square_bc
 ld a,(hl)
 or a
 jp nz,bad_return
 jr b_down_left

b_up:
 cp e
 jr nc,b_up_right
b_up_left:
 inc c
 inc b 
 ld a,c
 cp e
 jp z,good_return
 call get_square_bc
 ld a,(hl)
 or a
 jp nz,bad_return
 jr b_down_left

b_up_right:
 inc b
 dec c
 ld a,c
 cp e
 jp z,good_return
 call get_square_bc
 ld a,(hl)
 or a
 jp nz,bad_return
 jr b_down_left

get_square_bc:		;return square 0-63 in l from row/col
 ld a,b
 add a,a
 add a,a
 add a,a
 or c
 ld l,a
 ret

get_square_de:
 ld a,d
 add a,a
 add a,a
 add a,a
 or e
 and 63
 ld l,a
 ret

check_queen:
 call chr
 ret c
 call chb
 ret c
 jp unascribed

unascribed:
 call print_invalid	;print invalid on top line of message box
 ld hl,$2956		; and then "Unascribed Action"
 ld (_penCol),hl
 ld hl,unascribed_text
 call _vputs
 ld hl,$305d
 ld (_penCol),hl
 ld hl,action_text
 call _vputs

invalid:
 ld a,(saved_pos)
 ld l,a
 ld h,$b0
 ld a,(piece_temp)
 ld (hl),a			;return piece to saved position
 res 6,(iy+$2f)		;reset 2nd cursor
 pop hl			;the pushed hl
 pop hl			;kill program counter
 call refresh
 jp waitkey

unascribed_text:
.db "Unascribed",0
action_text:
.db "Action",0

print_invalid:		;print "INVALID" to message box
 set textInverse,(iy+textflags)
 ld hl,$2251
 ld (_penCol),hl
 ld hl,invalid_text
 call _vputs
 res textInverse,(iy+textflags)
 ret

invalid_text:
.db " INVALID MOVE!",0

clear_invalid:		;clear message box text
 ld hl,$2251
 ld (_penCol),hl
 ld hl,spaces
 call _vputs
 ld hl,$2956
 ld (_penCol),hl
 ld hl,spaces
 call _vputs
 ld hl,$305d
 ld (_penCol),hl
 ld hl,spaces
 jp _vputs

spaces:
.db "                       "
spaces2:
.db "                       ",0


h_push:
 ld hl,h_stack_ptr
 ex de,hl
 pop bc				;program counter
 pop hl				;peek at hl
 push hl
 push bc
 ld a,(hl)				;(hl) is the piece being taken
 ld c,a				;_ldhlind destroys a
 ld h,d				;ld hl,de
 ld l,e
 call $33				;ld hl,(hl)
 ld (hl),c				;push any taken piece
 inc hl
 ld a,(saved_pos)
 bit 7,(iy+$2f)
 call nz,fix_for_reverse	;must be fixed if black is on bottom
 ld (hl),a
 inc hl
 ld a,(cur_pos)
 bit 7,(iy+$2f)
 call nz,fix_for_reverse	;must be fixed if black is on bottom
 ld (hl),a
 ld a,(piece_temp)
 and %10000000			;copy bit 7 here so it can be put
 or (hl)				;back into the piece later
 ld (hl),a
 ex de,hl
 inc (hl)				;add 3 to the stack pointer
 inc (hl)
 inc (hl)
 ret

h_pop:
 ld hl,(h_stack_ptr)
 ld de,h_stack
 call _cphlde
 jr z,skip_pop			;skip pop if history empty
 dec hl
 ld a,(hl)
 bit 7,(iy+$2f)
 call nz,fix_for_reverse	;must be fixed if black is on bottom
 ld d,a				;copy current position to d
 dec hl
 ld a,(hl)
 bit 7,(iy+$2f)
 call nz,fix_for_reverse	;must be fixed if black is on bottom
 and 63
 ld e,a				;copy saved position to e
 dec hl
 ld a,(hl)
 ld b,a				;copy taken piece to b
 ld hl,h_stack_ptr
 dec (hl)				;subtract 3 from the stack pointer
 dec (hl)
 dec (hl)
 ret
skip_pop:
 pop hl				;kill program counter
 jp waitkey

takeback:
 call key_delay
 bit 6,(iy+$2f)		;don't take back if a piece is picked up
 jp nz,waitkey
 call h_pop			;pop move from history
 ld a,d			;d,e and b contain move info
 and %10000000
 ld c,a			;copy bit 7 of d into c
 ld a,d
 and 63
 ld l,a
 ld h,$b0			;hl points to square that was moved to
 ld a,(hl)			;a is the piece on that square
 or c				;the possible bit 7 into that piece
 ld (hl),b			;replace it with any taken piece
 ld l,e
 ld (hl),a			;put the moved piece back where it came from
 call disp_turn		;switch whose move it is
 call reprint_move	;diplay the last move
 call refresh
 jp waitkey


view_history:
 call CloseGray
 call key_delay
 ld hl,20
 ld (_penCol),hl
 ld hl,title
 set textInverse,(iy+textflags)
 set textEraseBelow,(iy+textflags)
 call _vputs
 res textInverse,(iy+textflags)
 res textEraseBelow,(iy+textflags)
 ld hl,$0904
 ld (_penCol),hl
 call new_hcol
 call h_display
h_waitkey:
 call _getkey
 or a
 jr z,h_waitkey
 jp start

new_hcol:
 ld a,(_penCol)
 ld c,a
 ld hl,w_move
 call _vputs
 ld a,c
 add a,$20
 ld (_penCol),a
 ld hl,b_move
 call _vputs
 ld a,c
 ld (_penCol),a
 ld a,16
 ld (_penRow),a
 ret

h_display:
 ld hl,(h_stack_ptr)
 ld de,h_stack
 and a
 sbc hl,de
 ld b,l
 ld c,1
 ld ix,h_stack

h_disp_loop:
 push bc
 push de
 push hl
 call check_ix
 ld b,(ix+1)
 ld c,(ix+2)
 call print
 ld a,(_penCol)
 add a,10
 and $f0
 ld (_penCol),a
 pop hl
 pop de
 pop bc
 jr h_disp_loop

check_ix:
 ld de,3
 add ix,de
 ld hl,(h_stack_ptr)
 ex (sp),ix
 pop de
 and a
 sbc hl,de
 push de
 ex (sp),ix
 ret nz
 pop hl
 pop hl
 pop hl
 pop hl
 ret


toggle_sides:
 call key_delay
 bit 6,(iy+$2f)		;don't toggle sides when a piece
 jp nz,waitkey		; is picked up
 ld hl,board
 ld de,board+63
 ld a,%10000000
 xor (iy+$2f)		;toggle flag that tells who's on top/bottom
 ld (iy+$2f),a
toggle_loop:
 ld a,(de)			;go through all the pieces and
 ld c,(hl)			; exchange each piece with its couterpart
 ld (hl),a
 ld a,c
 ld (de),a
 dec de
 inc hl
 ld a,32			;loop 32 times
 cp l
 jr nz,toggle_loop
 call refresh
 jp waitkey

save_game:
 call CloseGray
 call _clrScrn
 call _homeup
 ld de,_ioPrompt
 ld hl,prompt
 call _mov10B				;move to prompt buffer
 call _mov10B
 ld hl,(_CLEANTMP)
 push hl					;save _cleantmp
 ld hl,(_PTempCnt)
 ld (_CLEANTMP),hl
 ld a,$0c					;value for input str
 ld (_ASAP_IND),a
 call _exec_pg3				;input the string
 pop hl
 ld (_CLEANTMP),hl			;put _cleantmp back
 ld a,(iy+$2f)
 ld (h_flags),a
 rst 10h					;find string in new variable
 ld a,b					;ld ahl,bde
 ld h,d
 ld l,e
 call _GETB_AHL				;get the length byte
 and 7					;max 7 chars
 inc a
 ld (_OP1+1),a				;put it into _op1
 ld a,$1f
 ld (_OP1+2),a
 ld a,b					;get abs addr again
 ex de,hl
 call $4c3f					;inc ahl by two
 call _SET_ABS_SRC_ADDR			;move from ahl
 sub a
 ld hl,_OP1+3
 call _ABS_MOV10B_SET_D
 call _RAM_PAGE_1
 ld hl,(h_stack_ptr)
 ld de,board
 and a
 sbc hl,de
 push hl
 call _CREATESTRNG
 ld a,b					;ld ahl,bde
 ex de,hl
 call $4c3f					;inc ahl by two
 call _SET_ABS_DEST_ADDR
 pop hl					;string size
 sub a
 call _SET_MM_NUM_BYTES
 ld a,1
 ld hl,$3000				;string source
 call _SET_ABS_SRC_ADDR
 call _mm_ldir
 call _RAM_PAGE_1
 jp start
 
prompt:
.db "Save Game As:",0

load_game:
 call key_delay
 call CloseGray
 call _homeup
 call _RAM_PAGE_7
 ld hl,$bfff		;start searching VAT here
 ld d,h
 ld e,l			
 ld bc,($d29b)		;pointer to the end of the VAT
 and a			;reset carry
 sbc hl,bc			
 ld b,h
 ld c,l			;bc = length of VAT
 ex de,hl			;hl = $bfff
 ld ix,$ca00		;start a table here (it's cleared by CloseGray)
cp_outer_loop:
 ld a,$0c			;looking for strings
cp_loop:
 cpd				;cp (hl), dec hl, dec bc
 jp po,done_cp_loop	;parity is odd when bc = 0
 jr nz,cp_loop
 ld d,h			;save hl because the search continues later
 ld e,l
 dec hl			;dec hl until it points to the string name
 dec hl
 dec hl
 dec hl
 dec hl
 ld a,(hl)
 cp $1f			;if the first char of the string is $1f
 ex de,hl			; then its a zblitz string
 jr nz,cp_outer_loop
 call store_game		;we found a game, so store it
 jr cp_outer_loop		;see if we can't find more
done_cp_loop:
 call _RAM_PAGE_1		;our table is on page 1
 ld hl,$ca00
 ld a,(hl)
 or a				;if the first byte of the table is 0,
 jr nz,ld_interface	; no games were found
 ld hl,no_games_found	; if they were found, then load interface
 call _puts
get_key_loop:
 call _getkey
 jr z,get_key_loop	;wait for a key press, then return to game
 call key_delay
 jp start

ld_interface:
 ld hl,ld_game
 call _puts			;display "Load Game:" at the top
 ld hl,$ca00		;location of our table
 ld bc,$0101		;put the first string's name at this row/col
gewy_loop:
 ld a,l
 add a,5			;first byte of the name
 ld l,a
 ld (_curRow),bc
 call _puts			;put the string
 inc c			;next row down
 ld a,l
 and $f0			;mask out bottom 4 bits (round down by $10)
 add a,$10
 cp ixl			;have reached end of table when equal
 ld l,a
 jr nz,gewy_loop
 ld de,$0001
select_loop:
 ld (_curRow),de
 ld a,5
 push de
 call _putmap
 push hl
 push bc			;_getkey destroys registers!
 call _getkey
 pop bc
 pop hl
 pop de
 cp 3
 jr z,s_up
 cp 4
 jr z,s_down
 cp 9
 jr z,s_delete
 cp 6
 jr z,s_enter
 cp 7
 jr nz,select_loop
 jp start			;return when exit key pushed

s_up:
 ld a,e			;de is the row / col of the cursor
 dec a
 jr z,select_loop		;skip if cursor at top
 ld a,' '			;clear previous cursor
 call _putmap
 dec e			;move cursor up
 jr select_loop

s_down:
 ld a,ixl			;end of table
 and $f0			;mask out bottom 4 bits
 rlca				;move the top 4 bits into the bottom 4 bits
 rlca
 rlca
 rlca
 cp e				;see if result is same as cursor
 jr z,select_loop		;skip if it isn't
 ld a,' '			;clear previous arrow
 call _putmap
 inc e			;increment cursor
 jr select_loop

s_delete:
 push hl
 ld a,e			;cursor row -> a
 dec a			;resets carry
 rlca				;bottom 4 bits -> top 4 bits
 rlca
 rlca
 rlca
 ld l,a			;get the address of the game in table
 ld h,$ca
 inc l			;point hl to name-1
 inc l
 rst 20h			;move name to op1
 rst 10h			;if the variable exists
 call nc,_delvar		;delete it
 pop hl
 jp load_game		;create a new table without deleted game

s_enter:
 ld h,$ca
 ld a,e			;cursor row
 dec a
 rlca				;bottom 4 bits -> top 4 bits
 rlca
 rlca
 rlca
 ld l,a			;hl -> table (abs addr of selected string)
 ld a,(hl)			;so get the abs addr into ahl
 inc l
 ld c,(hl)
 inc l
 ld l,(hl)
 ld h,c
 push af			;save ahl for later
 push hl
 call _load_ram_ahl	;set page
 call $33			;hl now contains length of game to load
 sub a
 call _SET_MM_NUM_BYTES	;load hl into abs # of bytes
 pop hl
 pop af
 call $4c3f			;ahl += 2
 call _SET_ABS_SRC_ADDR
 ld a,1
 ld hl,$3000		;abs addr of $b000 on page 1
 call _SET_ABS_DEST_ADDR
 call _mm_ldir		;put loaded game into active position
 call _RAM_PAGE_1		;return the ram page
 ld a,(h_flags)		;return the game's flags
 ld (iy+$2f),a
 jp start			;return to game

ld_game:
.db "Load Game:",0
 
store_game:			;store found games to table
 ex de,hl
 push de
 inc hl
 push hl
 inc hl
 inc hl
 call ld_table_inc
 call ld_table_inc
 call ld_table_inc
 pop hl
 call ld_table_dec
 ld b,a
str_name_loop:
 call ld_table_dec
 djnz str_name_loop
 ld a,$f0			;bit mask
 and ixl
 add a,$10
 ld ixl,a
 pop hl
 ret

ld_table_inc:		;ld (hl) to the table and inc hl
 ld a,(hl)
 ld (ix),a
 inc hl
 inc ixl
 ret
ld_table_dec:		;ld (hl) to the table and dec hl
 ld a,(hl)
 ld (ix),a
 dec hl
 inc ixl
 ret

no_games_found:
.db "No Games Found",0

down:
 call refresh
 ld a,(cur_pos)
 and 63
 cp 56
 jr nc,down_skip
 add a,8
down_skip:
 set 7,a
 ld (cur_pos),a
 ld a,70
 ld (UserCounter),a
 call key_delay
 jp waitkey

up:
 call refresh
 ld a,(cur_pos)
 and 63
 cp 8
 jr c,up_skip
 sub 8
up_skip:
 set 7,a
 ld (cur_pos),a
 ld a,70
 ld (UserCounter),a
 call key_delay
 jp waitkey

right:
 call refresh
 ld a,(cur_pos)
 and 63
 ld d,a
 call casper
 ld a,c
 cp 7
 ld a,d
 jr z,right_skip
 inc a
right_skip:
 set 7,a
 ld (cur_pos),a
 ld a,70
 ld (UserCounter),a
 call key_delay
 jp waitkey

left:
 call refresh
 ld a,(cur_pos)
 and 63
 ld d,a
 call casper
 ld a,c
 or a
 ld a,d
 jr z,left_skip
 dec a
left_skip:
 set 7,a
 ld (cur_pos),a
 ld a,70
 ld (UserCounter),a
 call key_delay
 jp waitkey

key_delay:			;about 1/10 of a second delay
 ld a,$ff
key_loop_outer:
 ld b,$ff
key_loop:
 nop
 djnz key_loop
 dec a
 ret z
 jr key_loop_outer

#include "sprites.asm"		;all the game's sprites (.6k)
#include "gray2.asm"		;the grayscale routine
#include "bitmap.asm"		;both bitmap layers (2k);
;#include "ptsprite.asm"

start_pos:			;the pieces with their flags set
.db 140,10,11,13,142,11,9,140
.db 136,136,136,136,136,136,136,136
.db 0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0
.db 129,129,129,129,129,129,129,129
.db 133,3,4,6,135,4,2,133

.end
.end