;------------------------------------------------------------
;
;			VEXED v 1.3
;
;		   by Andrew Von Dollen
;		    warn@geocities.com
;
;		  (comments coming soon)
;
;-------------------------------------------------------------

 .include "asm86.h"
 .include "ti86asm.inc"

TEXT_MEM = _textShadow

temp_x = TEXT_MEM
temp_y = TEXT_MEM+1
CursorOffset = TEXT_MEM+2
PieceAddress = TEXT_MEM+3
Piece = TEXT_MEM+5
Flag = TEXT_MEM+6
Movement = TEXT_MEM+7

 .org     _asm_exec_ram

Start:
 call	$4AB1			;Run Indicator Off
 call	_clrLCD
 call	PutTitle
 ld	hl,$3777
 ld	(_penCol),hl
 ld	a,(CurrentLevel)
 inc	a
 ld	h,0
 ld	l,a
 ld   	de,StringTemp+1
 ld   	b,2
ConvLoop:
 call 	UNPACK_HL
 add  	a,'0'
 ld   	(de),a
 dec  	de
 djnz 	ConvLoop
 ld	hl,StringTemp
 call	_vputs
 ld	hl,$3761
 ld	(_penCol),hl
 ld	hl,Level
 call	_vputs
 di
 call	SetupLevel
 call	ReverseBorder
 call	DrawBoard
keyloop:
 ld 	a,%00111110
 out 	(1),a
 in 	a,(1)
 ld 	b,a
 bit 	5,a
 jp	z,MoveBlock
 call	GET_KEY
 cp	K_UP
 jr	z,up
 cp	K_LEFT
 jp	z,left
 cp	K_DOWN
 jp	z,down
 cp	K_RIGHT
 jp	z,right
 cp	K_EXIT
 jr	z,Quit
 cp	K_CLEAR
 jp	z,StartOver
 cp	K_PLUS
 jp	z,AdvanceLevel
 cp	K_MINUS
 jp	z,DownLevel
 ld	hl,Board+13
 ld	b,71
checkw_loop:
 ld	a,(hl)
 or	a
 jr	z,next_piece
 cp	1
 jr	z,next_piece
 cp	10
 jr	c,keyloop
next_piece:
 inc	hl
 djnz	checkw_loop
 jr	AdvanceLevel
Quit:
 call	ScreenAway
 call	_clrLCD
 ei
 ret
AdvanceLevel:
 ld	a,(CurrentLevel)
 cp	58
 jr	z,keyloop
 inc	a
 ld	(CurrentLevel),a
 ld	hl,(CurrentOffset)
 ld	bc,30
 add	hl,bc
 ld	(CurrentOffset),hl
 call	ScreenAway
 jp	Start
DownLevel:
 ld	a,(CurrentLevel)
 cp	0
 jr	z,keyloop
 dec	a
 ld	(CurrentLevel),a
 ld	hl,(CurrentOffset)
 ld	bc,-30
 add	hl,bc
 ld	(CurrentOffset),hl
 call	ScreenAway
 jp	Start
up:
 call	put_cursor
 ld	a,(CursorOffset)
 sub	12
 call	CheckIt
 ld	(CursorOffset),a
 call	put_cursor
 jp	keyloop

down:
 call	put_cursor
 ld	a,(CursorOffset)
 add	a,12
 call	CheckIt
 ld	(CursorOffset),a
 call	put_cursor
 jp	keyloop
left:
 call	put_cursor
 ld	a,(CursorOffset)
 dec	a
 call	CheckIt
 ld	(CursorOffset),a
 call	put_cursor
 jp	keyloop
right:
 call	put_cursor
 ld	a,(CursorOffset)
 inc	a
 call	CheckIt
 ld	(CursorOffset),a
 call	put_cursor
 jp	keyloop
StartOver:
 call	SetupLevel
 call	ReverseBorder
 call	DrawBoard
 jp	keyloop
ScreenAway:
 ld	b,8
loop1:
 push	bc
 ld	hl,$FC00
 ld	b,255
loop11:
 srl	(hl)
 inc	hl
 djnz	loop11
 ld	b,255
loop12:
 srl	(hl)
 inc	hl
 djnz	loop12
 ld	b,255
loop13:
 srl	(hl)
 inc	hl
 djnz	loop13
 ld	b,255
loop14:
 srl	(hl)
 inc	hl
 djnz	loop14
 ei
 ld	b,6
del_loop
 halt
 djnz	del_loop
 di
 pop	bc
 djnz	loop1
 ret

MoveBlock:
 ld	a,(CursorOffset)
 ld	d,0
 ld	e,a
 ld	hl,Board
 add	hl,de
 ld	a,(hl)
 and	%1111111
 or	a
 jp	z,keyloop
 bit 	1,b
 jr 	z,MoveLeft
 bit 	2,b
 jr 	z,MoveRight
 jp	keyloop
MoveRight:
 ld	a,(CursorOffset)
 inc	a
 call	CheckMove
 ld	(CursorOffset),a
 dec	a
 ld	d,0
 ld	e,a
 ld	hl,Board
 add	hl,de
 ld	a,(hl)
 ld	(hl),0
 inc	hl
 ld	(hl),a
 ld	b,8
move_r_loop1:
 push	bc 
 call	FindOffset
 ld	b,8
move_r_loop:
 push	bc
 dec	hl
 srl	(hl)
 inc	hl
 rr	(hl)
 ld	bc,16
 add	hl,bc
 pop	bc
 djnz	move_r_loop
 ei
 ld	b,7
d_loop_r:
 halt
 djnz	d_loop_r
 di
 pop	bc
 djnz	move_r_loop1
 call	DrawBoard
 call	DropKnock
 jp	keyloop

MoveLeft:
 ld	a,(CursorOffset)
 dec	a
 call	CheckMove
 ld	(CursorOffset),a
 inc	a
 ld	d,0
 ld	e,a
 ld	hl,Board
 add	hl,de
 ld	a,(hl)
 ld	(hl),0
 dec	hl
 ld	(hl),a
 ld	b,8
move_l_loop1:
 push	bc 
 call	FindOffset
 ld	b,8
move_l_loop:
 push	bc
 inc	hl
 sla	(hl)
 dec	hl
 rl	(hl)
 ld	bc,16
 add	hl,bc
 pop	bc
 djnz	move_l_loop
 ei
 ld	b,7
d_loop_l:
 halt
 djnz	d_loop_l
 di
 pop	bc
 djnz	move_l_loop1
 call	DrawBoard
 call	DropKnock
 jp	keyloop

DropKnock:
 xor	a
 ld	(Movement),a
 call	DropBlocks
 call	KnockOut
 ld	a,(Movement)
 or	a
 jr	nz,DropKnock
DoneMoving:
 call	DropBlocks
 call	KnockOut
 call	DropBlocks
 call	KnockOut
 call	DropBlocks
 call	KnockOut
 call	DrawBoard
 ret

DropBlocks:
 push	ix
 ld	ix,Board
 ld	b,12
drop_loop:
 push	bc
 push	ix

 ld	b,7
drop_col1:
 push	bc
 ld	b,7
drop_col:
 ld	a,(ix)
 or	a
 jr	z,end_d_loop
 cp	1
 jr	z,end_d_loop
 cp	10
 jr	nc,end_d_loop
 ld	a,(ix+12)
 or	a
 jr	nz,end_d_loop
 ld	a,(ix)
 ld	(ix+12),a
 ld	(ix),0
end_d_loop:
 ld	de,12
 add	ix,de
 djnz	drop_col
 pop	bc
 pop	ix
 push	ix
 djnz	drop_col1
end_of_loop:
 pop	ix
 dec	ix
 pop	bc
 djnz	drop_loop
 pop	ix
 ret

KnockOut:
 ld	hl,Board+13
 ld	(PieceAddress),hl
 ld	b,71
knock_loop:
 push	bc
 ld	hl,(PieceAddress)
 ld	a,(hl)
 and	%1111111
 or	a
 jr	z,dont_check
 cp	1
 jr	z,dont_check
 cp	10
 jr	nc,dont_check
 ld	hl,(PieceAddress)
 inc	hl
 ld	a,(hl)
 and	%1111111
 ld	d,a			;d=right
 ld	hl,(PieceAddress)
 dec	hl
 ld	a,(hl)
 and	%1111111
 ld	e,a			;e=left
 ld	hl,(PieceAddress)
 ld	bc,12
 add	hl,bc
 ld	a,(hl)
 and	%1111111
 ld	c,a			;c=bottom
 ld	hl,(PieceAddress)
 ld	bc,-12
 add	hl,bc
 ld	a,(hl)
 and	%1111111
 ld	b,a			;b=top
 call	TagAccordingly

dont_check:
 ld	hl,(PieceAddress)
 inc	hl
 ld	(PieceAddress),hl
 pop	bc
 djnz	knock_loop

; ld	hl,Board+13			;all of these commented lines do
; ld	b,71				;the block animation when blocks are erased
;re_loop:
; bit	7,(hl)
; jr	z,dont_trash
; ld	(hl),0
; ld	a,99
; ld	(Movement),a
;dont_trash:
; inc	hl
; djnz	re_loop
; call	DrawBoard

 ld	hl,Board+13
 ld	b,71
re_loop:
 bit	7,(hl)
 jr	z,dont_trash
 ld	(hl),0
dont_trash:
 inc	hl
 djnz	re_loop
 ret

; call	DrawBoard
; ld	a,(Movement)
; cp	99
; jr	nz,DontAnimate
; call	delay
; ld	hl,Board+13
; ld	b,71
;re_loop1:
; bit	7,(hl)
; jr	z,dont_trash1
; ld	(hl),18
; set	7,(hl)
;dont_trash1:
; inc	hl
; djnz	re_loop1
; call	DrawBoard
; call	delay
; ld	hl,Board+13
; ld	b,71
;re_loop2:
; bit	7,(hl)
; jr	z,dont_trash2
; ld	(hl),19
; set	7,(hl)
;dont_trash2:
; inc	hl
; djnz	re_loop2
; call	DrawBoard
; call	delay
; ld	hl,Board+13
; ld	b,71
;re_loop3:
; bit	7,(hl)
; jr	z,dont_trash3
; ld	(hl),0
;dont_trash3:
; inc	hl
; djnz	re_loop3
;DontAnimate:

TagAccordingly:
 xor	a
 ld	(Flag),a
 ld	hl,(PieceAddress)
 ld	a,(hl)
 and	%111111
 ld	(Piece),a
 cp	e
 jr	nz,check_right
 dec	hl
 set	7,(hl)
 ld	a,1
 ld	(Flag),a
check_right:
 ld	hl,(PieceAddress)
 ld	a,(Piece)
 cp	d
 jr	nz,check_top
 inc	hl
 set	7,(hl)
 ld	a,1
 ld	(Flag),a
check_top:
 ld	hl,(PieceAddress)
 ld	a,(Piece)
 cp	b
 jr	nz,check_bottom
 ld	b,12
sub12:
 dec	hl
 djnz	sub12
 set	7,(hl)
 ld	a,1
 ld	(Flag),a
check_bottom:
 ld	hl,(PieceAddress)
 ld	a,(Piece)
 cp	c
 jr	nz,head_home
 ld	bc,12
 add	hl,bc
 set	7,(hl)
 ld	a,1
 ld	(Flag),a
head_home:
 ld	a,(Flag)
 cp	1
 jr	nz,dont_erase_piece
 ld	hl,(PieceAddress)
 set	7,(hl)
dont_erase_piece:
 ret

CheckIt:
 push	af
 ld	h,0
 ld	l,a
 ld	de,Board
 add	hl,de
 ld	a,(hl)
 and	%1111111
 cp	1
 jr	z,invalid_move
 cp	10
 jr	nc,invalid_move
 pop	af
 ret
invalid_move:
 pop	af
 inc	sp
 inc	sp
 call	put_cursor
 jp	keyloop

ReverseBorder:
 ld	hl,corner_t_l
 ld	b,7*8
rev_loop
 ld	a,(hl)
 cpl
 ld	(hl),a
 inc	hl
 djnz	rev_loop
 ret

CheckMove:
 push	af
 ld	h,0
 ld	l,a
 ld	de,Board
 add	hl,de
 ld	a,(hl)
 or	a
 jr	nz,invalid_move1
 pop	af
 ret
invalid_move1:
 pop	af
 inc	sp
 inc	sp
 jp	keyloop

put_cursor:
 call	FindOffset
 ld	b,8
row_loop:
 ld	a,(hl)
 cpl
 ld	(hl),a
 ld	de,16
 add	hl,de
 djnz	row_loop
 ret

FindOffset:
 ld	a,(CursorOffset)
 add	a,12
 ld	b,-1
calc_loop:
 inc	b
 sub	12
 cp	12
 jr	nc,calc_loop
 ld	h,0
 ld	l,b
 add	hl,hl		;2
 add	hl,hl		;4
 add	hl,hl		;8
 add	hl,hl		;16
 add	hl,hl		;32
 add	hl,hl		;64
 add	hl,hl		;128
 ld	d,0
 ld	e,a
 add	hl,de
 ld	de,$FC00
 add	hl,de
 ret

SetupLevel:
 ld	hl,Template
 ld	de,Board
 ld	bc,96
 ldir
 ld	hl,levels
 ld	de,(CurrentOffset)
 add	hl,de
 ld	de,Board+13
 ld	b,6
setup_loop:
 push	bc

 ld	b,5
UncompLoop:
 ld	a,(hl)
 srl	a
 srl	a
 srl	a
 srl	a
 ld	(de),a
 ld	a,(hl)
 inc	de
 and	15
 ld	(de),a
 inc	hl
 inc	de
 djnz	UncompLoop

 inc	de
 inc	de
 pop	bc
 djnz	setup_loop
 ld	bc,-1
find_offset:
 ld	hl,Board
 inc	bc
 add	hl,bc
 ld	a,(hl)
 or	a
 jr	nz,find_offset
 ld	a,c
 ld	(CursorOffset),a
 ret

DrawBoard:
 ld	hl,Board
 xor	a
 ld	(temp_y),a
 ld	b,8
yloop1:
 push	bc
 xor	a
 ld	(temp_x),a
 ld	b,12
xloop1:
 push	bc
 ld	a,(temp_x)
 ld	b,a
 ld	a,(temp_y)
 ld	c,a
 ld	a,(hl)
 and	%1111111
 push	hl
 add	a,a
 add	a,a
 add	a,a
 ld	hl,sprites
 ld	d,0
 ld	e,a
 add	hl,de
 call	PutAligned
 pop	hl
 inc	hl
 ld	a,(temp_x)
 inc	a
 ld	(temp_x),a
 pop	bc
 djnz	xloop1
 ld	a,(temp_y)
 inc	a
 ld	(temp_y),a
 pop	bc
 djnz	yloop1
 call	put_cursor
 ret

PutAligned:
 push	hl		;sprite address
 ld	h,0
 ld	l,c
 add	hl,hl		;*2
 add	hl,hl		;*4
 add	hl,hl		;*8
 add	hl,hl		;*16
 add	hl,hl		;*32
 add	hl,hl		;*64
 add	hl,hl		;*128
 ld	de,$FC00
 add	hl,de
 ld	d,0
 ld	e,b
 add	hl,de
 pop	de		;de has sprite, hl has pos in graph mem
 ld	b,8
row_loop2:
 push	bc
 ld	a,(de)
 ld	(hl),a
 inc	de
 ld	bc,16
 add	hl,bc
 pop	bc
 djnz	row_loop2
 ret

PutTitle:
 ld	de,TitlePic
 ld	hl,$FC00+13+(16*7)
 ld	b,52-9
pt_loop:
 push	bc
 ld	a,(de)
 ld	(hl),a
 inc	de
 inc	hl
 ld	a,(de)
 ld	(hl),a
 inc	de
 ld	bc,15
 add	hl,bc
 pop	bc
 djnz	pt_loop
 ret

StringTemp .db "  ",0

CurrentLevel 	.db 0
CurrentOffset 	.dw 0

Board 	= $9000	;.ds 12*8

Level		.db "Level:",0

Template:
.db 10,14,14,14,14,14,14,14,14,14,14,11
.db 15,00,00,00,00,00,00,00,00,00,00,15
.db 15,00,00,00,00,00,00,00,00,00,00,15
.db 15,00,00,00,00,00,00,00,00,00,00,15
.db 15,00,00,00,00,00,00,00,00,00,00,15
.db 15,00,00,00,00,00,00,00,00,00,00,15
.db 15,00,00,00,00,00,00,00,00,00,00,15
.db 12,16,16,16,16,16,16,16,16,16,16,13

levels:
lev1:
.db $11,$11,$11,$11,$11
.db $11,$12,$30,$01,$11
.db $11,$11,$10,$01,$11
.db $11,$10,$00,$01,$11
.db $11,$13,$00,$21,$11
.db $11,$11,$32,$11,$11
lev2:
.db $11,$11,$11,$11,$11
.db $11,$10,$03,$00,$11
.db $11,$10,$02,$00,$11
.db $11,$10,$34,$00,$11
.db $11,$10,$25,$00,$11
.db $11,$12,$54,$04,$11
lev3:
.db $11,$11,$00,$11,$11
.db $11,$10,$00,$01,$11
.db $11,$60,$78,$06,$11
.db $11,$80,$11,$07,$11
.db $11,$18,$00,$71,$11
.db $11,$11,$00,$11,$11
lev4:
.db $11,$11,$11,$11,$11
.db $11,$11,$21,$11,$11
.db $11,$13,$40,$11,$11
.db $11,$11,$30,$30,$11
.db $11,$11,$40,$41,$11
.db $11,$11,$11,$21,$11
lev5:
.db $11,$11,$30,$41,$11
.db $11,$11,$50,$51,$11
.db $11,$11,$10,$61,$11
.db $11,$11,$00,$51,$11
.db $11,$11,$00,$61,$11
.db $11,$11,$41,$31,$11
lev6:
.db $11,$10,$00,$00,$11
.db $11,$16,$00,$07,$11
.db $11,$11,$80,$01,$11
.db $11,$18,$70,$27,$11
.db $11,$16,$80,$72,$11
.db $11,$11,$67,$27,$11
lev7:
.db $11,$11,$11,$11,$11
.db $11,$10,$03,$41,$11
.db $11,$10,$04,$51,$11
.db $11,$10,$05,$31,$11
.db $11,$10,$03,$41,$11
.db $11,$11,$11,$11,$11
lev8:
.db $11,$11,$11,$11,$11
.db $11,$00,$00,$05,$11
.db $11,$00,$00,$06,$11
.db $11,$20,$03,$02,$11
.db $11,$36,$06,$01,$11
.db $11,$62,$51,$21,$11
lev9:
.db $11,$11,$11,$11,$11
.db $11,$11,$10,$21,$11
.db $11,$13,$00,$42,$11
.db $11,$11,$30,$24,$11
.db $11,$11,$10,$41,$11
.db $11,$11,$11,$11,$11
lev10:
.db $11,$00,$00,$00,$11
.db $14,$00,$00,$40,$01
.db $15,$65,$00,$57,$01
.db $16,$24,$00,$74,$21
.db $17,$65,$01,$26,$81
.db $12,$76,$11,$68,$51
lev11:
.db $11,$00,$00,$45,$11
.db $11,$00,$60,$11,$11
.db $11,$00,$10,$00,$11
.db $11,$50,$10,$00,$11
.db $11,$11,$00,$74,$11
.db $11,$40,$06,$47,$11
lev12:
.db $11,$23,$40,$43,$21
.db $11,$11,$10,$11,$11
.db $11,$13,$00,$03,$11
.db $11,$11,$00,$01,$11
.db $11,$11,$00,$01,$11
.db $11,$11,$23,$41,$11
lev13:
.db $13,$45,$40,$54,$31
.db $11,$11,$10,$11,$11
.db $11,$11,$10,$01,$11
.db $11,$11,$10,$01,$11
.db $11,$11,$50,$01,$11
.db $11,$11,$10,$11,$11
lev14:
.db $11,$11,$11,$11,$11
.db $11,$11,$60,$01,$11
.db $11,$11,$70,$01,$11
.db $11,$10,$80,$86,$11
.db $11,$11,$71,$61,$11
.db $11,$11,$11,$11,$11
lev15:
.db $11,$11,$11,$11,$11
.db $11,$11,$13,$01,$11
.db $11,$13,$04,$03,$11
.db $11,$11,$03,$04,$11
.db $11,$14,$01,$43,$11
.db $11,$11,$41,$11,$11
lev16:
.db $11,$11,$11,$11,$11
.db $11,$23,$20,$42,$51
.db $11,$12,$50,$53,$11
.db $11,$11,$40,$31,$11
.db $11,$11,$15,$11,$11
.db $11,$11,$11,$11,$11
lev17:
.db $11,$13,$45,$03,$11
.db $11,$16,$16,$35,$11
.db $11,$17,$07,$64,$11
.db $11,$11,$01,$11,$11
.db $11,$16,$71,$11,$11
.db $11,$17,$31,$11,$11
lev18:
.db $11,$11,$16,$01,$11
.db $11,$11,$17,$00,$11
.db $11,$18,$08,$01,$11
.db $11,$17,$06,$01,$11
.db $11,$11,$07,$00,$11
.db $11,$11,$16,$11,$11
lev19:
.db $11,$11,$20,$11,$11
.db $11,$11,$10,$21,$11
.db $11,$34,$00,$51,$11
.db $11,$53,$00,$24,$11
.db $11,$45,$05,$41,$11
.db $11,$11,$01,$11,$11
lev20:
.db $11,$11,$10,$11,$11
.db $11,$11,$10,$31,$11
.db $11,$11,$00,$40,$11
.db $11,$15,$00,$60,$11
.db $11,$11,$34,$16,$11
.db $11,$11,$11,$15,$11
lev21:
.db $11,$11,$11,$11,$11
.db $11,$11,$02,$11,$11
.db $11,$11,$13,$41,$11
.db $11,$14,$02,$31,$11
.db $11,$15,$04,$50,$11
.db $11,$11,$11,$11,$11
lev22:
.db $11,$80,$00,$01,$11
.db $11,$11,$10,$01,$11
.db $11,$90,$00,$89,$11
.db $11,$11,$00,$11,$11
.db $11,$11,$90,$01,$11
.db $11,$11,$80,$01,$11
lev23:
.db $11,$11,$11,$11,$11
.db $11,$11,$11,$11,$21
.db $11,$00,$00,$30,$41
.db $11,$50,$60,$70,$31
.db $11,$40,$20,$80,$81
.db $11,$50,$70,$60,$61
lev24:
.db $11,$11,$11,$11,$11
.db $11,$15,$05,$00,$11
.db $11,$11,$06,$06,$11
.db $11,$16,$07,$07,$11
.db $11,$15,$01,$11,$11
.db $11,$11,$11,$11,$11
lev25:
.db $11,$11,$11,$11,$11
.db $11,$02,$34,$50,$11
.db $11,$01,$11,$60,$11
.db $11,$00,$10,$20,$11
.db $11,$50,$00,$16,$11
.db $11,$43,$16,$25,$11
lev26:
.db $11,$12,$30,$01,$11
.db $11,$14,$20,$01,$11
.db $11,$13,$40,$51,$11
.db $11,$11,$10,$41,$11
.db $11,$14,$30,$21,$11
.db $11,$15,$10,$31,$11
lev27:
.db $11,$11,$11,$11,$11
.db $11,$11,$10,$41,$11
.db $11,$11,$00,$54,$11
.db $11,$15,$06,$71,$11
.db $11,$11,$47,$40,$11
.db $11,$11,$16,$51,$11
lev28:
.db $11,$11,$11,$11,$11
.db $11,$11,$10,$51,$11
.db $11,$11,$16,$11,$11
.db $11,$17,$07,$00,$11
.db $11,$15,$71,$85,$11
.db $11,$56,$11,$18,$11
lev29:
.db $11,$11,$20,$11,$11
.db $11,$11,$10,$03,$11
.db $11,$13,$00,$04,$11
.db $11,$14,$00,$32,$11
.db $11,$15,$05,$41,$11
.db $11,$14,$01,$11,$11
lev30
.db $11,$11,$11,$11,$11
.db $11,$31,$00,$40,$11
.db $11,$41,$00,$50,$11
.db $11,$60,$70,$65,$11
.db $11,$11,$40,$14,$11
.db $11,$11,$13,$17,$11
lev31
.db $11,$10,$20,$30,$11
.db $11,$10,$32,$40,$11
.db $11,$15,$43,$20,$11
.db $11,$12,$64,$36,$11
.db $11,$11,$56,$23,$11
.db $11,$11,$15,$11,$11
lev32
.db $11,$10,$00,$11,$11
.db $12,$00,$34,$00,$11
.db $11,$00,$41,$00,$01
.db $15,$00,$50,$00,$21
.db $11,$30,$10,$01,$11
.db $11,$51,$11,$41,$11
lev33
.db $11,$11,$23,$11,$11
.db $11,$10,$45,$61,$11
.db $11,$00,$73,$86,$11
.db $11,$00,$45,$97,$11
.db $11,$10,$98,$71,$11
.db $11,$11,$62,$11,$11
lev34
.db $11,$40,$00,$05,$11
.db $11,$11,$00,$11,$11
.db $11,$14,$64,$11,$11
.db $11,$11,$51,$11,$11
.db $11,$11,$60,$11,$11
.db $11,$10,$51,$11,$11
lev35
.db $11,$11,$23,$01,$11
.db $11,$11,$14,$01,$11
.db $11,$11,$11,$01,$11
.db $11,$15,$34,$01,$11
.db $11,$11,$15,$01,$11
.db $11,$12,$34,$25,$11
lev36
.db $11,$13,$41,$11,$11
.db $11,$11,$51,$11,$11
.db $11,$10,$60,$11,$11
.db $11,$00,$40,$06,$11
.db $11,$40,$10,$05,$11
.db $11,$34,$35,$61,$11
lev37
.db $11,$02,$00,$00,$11
.db $11,$03,$00,$40,$11
.db $11,$31,$30,$14,$11
.db $11,$10,$56,$01,$11
.db $11,$60,$45,$62,$11
.db $11,$13,$64,$21,$11
lev38
.db $11,$11,$10,$02,$31
.db $11,$11,$10,$03,$21
.db $11,$10,$00,$24,$31
.db $11,$53,$11,$11,$11
.db $11,$42,$11,$11,$11
.db $11,$54,$11,$11,$11
lev39
.db $11,$12,$30,$01,$11
.db $11,$14,$50,$11,$11
.db $11,$11,$60,$11,$11
.db $11,$11,$16,$11,$11
.db $11,$11,$03,$51,$11
.db $11,$10,$04,$21,$11
lev40
.db $11,$11,$10,$02,$31
.db $11,$11,$10,$04,$21
.db $11,$11,$10,$25,$31
.db $11,$43,$00,$11,$11
.db $11,$52,$11,$11,$11
.db $11,$35,$11,$11,$11
lev41
.db $11,$10,$02,$31,$11
.db $11,$14,$03,$11,$11
.db $11,$53,$04,$03,$11
.db $11,$32,$05,$31,$11
.db $11,$53,$03,$51,$11
.db $11,$11,$31,$11,$11
lev42
.db $11,$10,$00,$11,$11
.db $11,$14,$50,$01,$11
.db $11,$11,$65,$00,$11
.db $11,$11,$14,$06,$11
.db $11,$11,$11,$04,$11
.db $11,$11,$11,$11,$11
lev43
.db $11,$30,$01,$11,$11
.db $11,$40,$14,$11,$11
.db $11,$15,$05,$61,$11
.db $11,$16,$03,$56,$11
.db $11,$11,$05,$31,$11
.db $11,$11,$13,$11,$11
lev44
.db $11,$23,$00,$04,$11
.db $11,$54,$50,$05,$11
.db $11,$12,$43,$04,$11
.db $11,$11,$11,$01,$11
.db $11,$11,$11,$01,$11
.db $11,$11,$11,$11,$11
lev45
.db $11,$12,$10,$03,$11
.db $11,$13,$10,$24,$11
.db $11,$15,$04,$62,$11
.db $11,$11,$05,$26,$11
.db $11,$11,$02,$61,$11
.db $11,$11,$03,$11,$11
lev46
;too wide!
lev47
.db $11,$12,$01,$11,$11
.db $11,$13,$00,$00,$11
.db $11,$11,$00,$02,$11
.db $11,$10,$03,$13,$11
.db $11,$10,$02,$12,$11
.db $11,$10,$03,$23,$11
lev48
.db $11,$11,$11,$11,$11
.db $11,$02,$30,$43,$51
.db $11,$04,$60,$65,$11
.db $11,$01,$10,$11,$11
.db $11,$46,$20,$41,$11
.db $11,$11,$10,$21,$11
lev49
.db $11,$10,$02,$00,$11
.db $11,$13,$04,$00,$11
.db $11,$11,$01,$00,$11
.db $11,$10,$04,$00,$11
.db $11,$13,$03,$14,$11
.db $11,$12,$02,$11,$11
lev50
.db $11,$23,$01,$11,$11
.db $11,$42,$50,$01,$11
.db $14,$11,$11,$00,$11
.db $16,$00,$00,$60,$01
.db $14,$05,$25,$23,$21
.db $11,$51,$11,$11,$11
lev51
.db $11,$12,$03,$11,$11
.db $10,$03,$01,$00,$41
.db $12,$15,$00,$45,$11
.db $11,$11,$00,$61,$11
.db $11,$15,$06,$11,$11
.db $11,$16,$03,$11,$11
lev52
.db $11,$20,$00,$03,$11
.db $14,$50,$23,$06,$41
.db $17,$60,$11,$04,$51
.db $11,$10,$00,$01,$11
.db $11,$10,$00,$71,$11
.db $11,$11,$76,$11,$11
lev53
.db $11,$11,$02,$11,$11
.db $11,$11,$03,$11,$11
.db $10,$00,$02,$04,$51
.db $16,$00,$03,$05,$61
.db $11,$11,$02,$11,$11
.db $11,$11,$04,$11,$11
lev54
.db $11,$11,$23,$41,$11
.db $11,$11,$52,$31,$11
.db $11,$10,$41,$50,$11
.db $11,$00,$11,$10,$31
.db $11,$00,$52,$50,$41
.db $11,$54,$11,$14,$21
lev55
.db $11,$00,$23,$40,$11
.db $11,$01,$11,$10,$31
.db $11,$00,$05,$00,$61
.db $11,$60,$06,$00,$21
.db $11,$40,$24,$00,$71
.db $11,$24,$61,$37,$51
lev56
.db $11,$11,$11,$11,$11
.db $12,$30,$00,$04,$51
.db $15,$64,$00,$73,$61
.db $16,$25,$00,$65,$71
.db $17,$52,$00,$17,$51
.db $11,$11,$11,$11,$11
lev57
.db $11,$02,$13,$00,$11
.db $11,$45,$11,$10,$11
.db $11,$56,$00,$10,$11
.db $11,$47,$10,$10,$11
.db $11,$76,$20,$03,$11
.db $11,$82,$40,$48,$11
lev58
.db $11,$11,$11,$11,$11
.db $10,$00,$00,$20,$01
.db $13,$00,$40,$50,$01
.db $16,$00,$54,$32,$01
.db $17,$00,$45,$28,$01
.db $16,$00,$79,$82,$91
lev59
.db $11,$12,$01,$10,$31
.db $11,$11,$00,$00,$41
.db $11,$10,$00,$30,$11
.db $11,$50,$63,$20,$11
.db $11,$14,$21,$70,$11
.db $11,$16,$71,$32,$31
lev60
.db $20,$11,$11,$30,$31
.db $10,$12,$00,$40,$51
.db $10,$11,$00,$60,$61
.db $12,$06,$50,$40,$47
.db $11,$11,$60,$10,$76
.db $11,$11,$40,$10,$11
TitlePic:
.db %00000011,%01100000
.db %00000011,%01100000
.db %00000011,%01100000
.db %00000011,%01100000
.db %00000001,%11000000
.db %00000001,%11000000
.db %00000001,%11000000
.db %00000001,%11000000
.db %00000000,%00000000
.db %00000001,%11000000
.db %00000011,%01100000
.db %00000011,%01100000
.db %00000011,%11100000
.db %00000011,%00000000
.db %00000011,%01100000
.db %00000001,%11000000
.db %00000000,%00000000
.db %00000011,%01100000
.db %00000001,%11000000
.db %00000001,%11000000
.db %00000001,%11000000
.db %00000001,%11000000
.db %00000001,%11000000
.db %00000011,%01100000
.db %00000000,%00000000
.db %00000001,%11000000
.db %00000011,%01100000
.db %00000011,%01100000
.db %00000011,%11100000
.db %00000011,%00000000
.db %00000011,%01100000
.db %00000001,%11000000
.db %00000000,%00000000
.db %00000000,%01100000
.db %00000000,%01100000
.db %00000001,%11100000
.db %00000011,%01100000
.db %00000011,%01100000
.db %00000011,%01100000
.db %00000011,%01100000
.db %00000011,%01100000
.db %00000001,%11100000
.db %00000000,%00000000

sprites:
 .db 0,0,0,0,0,0,0,0
edge:
 .db %10101010
 .db %01010101
 .db %10101010
 .db %01010101
 .db %10101010
 .db %01010101
 .db %10101010
 .db %01010101
block1:
 .db %01111110
 .db %10001001
 .db %10011001
 .db %10111101
 .db %10111101
 .db %10011001
 .db %10010001
 .db %01111110
block2:
 .db %01111110
 .db %10011001
 .db %10100101
 .db %11000011
 .db %11000011
 .db %10100101
 .db %10011001
 .db %01111110
block3:
 .db %01111110
 .db %11000011
 .db %10100101
 .db %10000001
 .db %10000001
 .db %10100101
 .db %11000011
 .db %01111110
block4:
 .db %01111110
 .db %10011001
 .db %10011001
 .db %11100111
 .db %11100111
 .db %10011001
 .db %10011001
 .db %01111110
block5:
 .db %01111110
 .db %10000001
 .db %10100101
 .db %10011001
 .db %10011001
 .db %10100101
 .db %10000001
 .db %01111110
block6:
 .db %01111110
 .db %10111101
 .db %11000011
 .db %10100101
 .db %10011001
 .db %10011001
 .db %10011001
 .db %01111110
block7:
 .db %01111110
 .db %10000001
 .db %10111101
 .db %10100101
 .db %10100101
 .db %10111101
 .db %10000001
 .db %01111110
block8:
 .db %01111110
 .db %10000001
 .db %10011001
 .db %10111101
 .db %10111101
 .db %10011001
 .db %10000001
 .db %01111110

corner_t_l:
 .db %11111111
 .db %10001000
 .db %10001000
 .db %11111111
 .db %10000000
 .db %10000000
 .db %10000000
 .db %11111111
corner_t_r:
 .db %11111111
 .db %00001001
 .db %00001001
 .db %11111111
 .db %01000001
 .db %01000001
 .db %01000001
 .db %11111111
corner_b_l:
 .db %10001001
 .db %10001000
 .db %10001000
 .db %11111111
 .db %10000000
 .db %10000000
 .db %10000000
 .db %11111111
corner_b_r:
 .db %10001001
 .db %00001001
 .db %00001001
 .db %11111111
 .db %01000001
 .db %01000001
 .db %01000001
 .db %11111111
border_t:
 .db %11111111
 .db %00000100
 .db %00000100
 .db %11111111
 .db %01000000
 .db %01000000
 .db %01000000
 .db %11111111
bord_l_r:
 .db %10001001
 .db %10001001
 .db %10001001
 .db %11111111
 .db %10000001
 .db %10000001
 .db %10000001
 .db %11111111
bord_b:
 .db %11111111
 .db %00000100
 .db %00000100
 .db %11111111
 .db %01000000
 .db %01000000
 .db %01000000
 .db %11111111

;anim1:
;.db %01001001
;.db %00010000
;.db %01000010
;.db %00011000
;.db %01000010
;.db %00010000
;.db %10000100
;.db %00100001
;anim2:
;.db %00000000
;.db %00100010
;.db %00001000
;.db %01000010
;.db %00010100
;.db %00000000
;.db %01000010
;.db %00000000
;anim3:
;.db %00000000
;.db %00000000
;.db %00010000
;.db %00000100
;.db %01010000
;.db %00001000
;.db %00000000
;.db %00000000

.end
