;HELLO    I'm Alan Bailey
;
;
;
;I'm posting this source because some people have asked about it.
;This is a good source to learn from, however, a better one is my kollums
;source, which is fully commented.  It's at ticalc.org also.
;
;Most of this source was first written by Dan Eble for the TI-85.  I've asked his
;permission before releasing this first, though.  
;
;Contact Me!
;Alan Bailey
;mailto:bailela@charlie.cns.iit.edu
;WEB: http://www.iit.edu/~bailela/
;IRC: Abalone


#include "asm86.h"
#include "ti86asm.inc"






KeyBuf = $C0F9		 ;7
KeyUp = $C100		   ;7
Score1 = $C107		   ;2
Score2 = $C109			 ;2
Y1 = $C10B
X1 = $C10C
Y2 = $C10D
X2 = $C10E
DeltaY1	= $C10F
DeltaX1 = $C110
DeltaY2 = $C111
DeltaX2 = $C112
Movement1 = $C113		 ;2
Movement2 = $C115		   ;2
CrashStatus = $C117
DelayCnt = $C118
StringPlace = $C119		   ;6



.org _asm_exec_ram

	ld hl,$C0F9
	ld de,$C0FA
	ld (hl),0
	ld bc,37
	ldir
	call _clrLCD
	ld hl,$0500
	ld (_curRow),hl
	ld hl,TitleStr
	call _puts
	ld hl,$0302
	ld (_curRow),hl
	ld hl,AuthorStr
	call _puts
Startloop:
	call GET_KEY
	cp K_EXIT
	jp z,Exit
	cp 0
	jr nz,Action
	jr Startloop

Action:
	ld hl,$0000
	ld (Score1),hl
	ld (Score2),hl
	res 0,(IY+12h)
	ld a,$18
	ld (DelayCnt),a

start:
	call _clrLCD
	ld hl,movetable+2
	ld (Movement1),hl
	ld hl,movetable+6
	ld (Movement2),hl

    ld a, -1                ; initialize all variables
    ld (DeltaX2), a
    inc a
    ld (DeltaY1), a
    ld (DeltaY2), a
    inc a
    ld (DeltaX1), a
    ld a, $1C
    ld (Y1), a
    ld (Y2), a
    ld a, $20
    ld (X1), a
    ld a, $5F
    ld (X2), a


    ld b, $37
    ld hl, $FC80    ; ninth row
    ld de, 15
VertLineLoop:
  	ld (hl), 10100000b      ; make left line
    add hl, de
    ld (hl), 00000101b      ; make right line
    inc hl
    djnz VertLineLoop
    ; hl = $FFF0
    ld (hl), $FF
    ld de, $FFF1
    ld c, 15        ; b = 0
    ldir
    ld a, 16
    ld c, a
    ; hl = $FFFF
    ld de, $FFDF
    lddr
    ld c, a
    inc hl          ; hl = $FFF0
    ld de, $FC90
    ldir
    ld c, a
    dec hl          ; hl = $FFFF
    ld e, $7F       ; d = $FC
    lddr
    ld de, $0002
    ld hl, (Score1)         ; display p1 score
    call HL_Decimal
    ld de, $006b
    ld hl, (Score2)         ; display p2 score
    call HL_Decimal

Loop:
	call UpdatePos		;updates x and y of both guys
	call CheckCrash	;returns indicator in mem	  <--------------
	call PlotPoint
	ld a,(CrashStatus)		;is from CheckCrash
	cp 1
	jp z,wongame2
	cp 2
	jp z,wongame1
	cp 3
	jp z,wongameneither
	call getkeys
	call Checkkeys		;checks keys and changes variables
	call Delay
	jr Loop



Player2LeftTurn:
	ld hl,(Movement2)
	call ChangeLeft
	ld (Movement2),hl
	call LD_HL_MHL
	ld (DeltaY2),hl
	ret
Player2RightTurn:
	ld hl,(Movement2)
	call ChangeRight
	ld (Movement2),hl
	call LD_HL_MHL
	ld (DeltaY2),hl
	ret
Player1LeftTurn:
	ld hl,(Movement1)
	call ChangeLeft
	ld (Movement1),hl
	call LD_HL_MHL
	ld (DeltaY1),hl
	ret
Player1RightTurn:
	ld hl,(Movement1)
	call ChangeRight
	ld (Movement1),hl
	call LD_HL_MHL
	ld (DeltaY1),hl
	ret

ChangeLeft:
	dec hl
	dec hl
	ld a,(hl)
	cp $80
	jr z,ChangeLeft2
	ret
ChangeLeft2:
	ld hl,movetable+6
	ret
ChangeRight:
	inc hl
	inc hl
	ld a,(hl)
	cp $80
	jr z,ChangeRight2
	ret
ChangeRight2:
	ld hl,movetable
	ret


PlotPoint:
	ld bc,(Y1)
	call Point_on
	ld bc,(Y2)
	call Point_on
	ret


getkeys:
    push af
    push bc
    push de
    push hl
    ld b, 7
    ld a, $7F
    ld hl, KeyUp
    ld de, KeyBuf
KeyLoop1:
    rlca
    out (1),a
    nop
    nop
    nop
    nop
    push af
    in a, (1)
    push af
    xor 255
    and (hl)
    ex de,hl
    ld (hl), a
    ex de,hl
    pop af
    ld (hl),a
    pop af
    inc hl
    inc de
    dec b
    jr nz, KeyLoop1
    pop hl
    pop de
    pop bc
    pop af
	ret

Checkkeys:
	ld a,(KeyBuf+6)
	bit 5,a
	call nz,Player1LeftTurn
	ld a,(KeyBuf+5)
	bit 6,a
	call nz,Player1RightTurn
	ld a,(KeyBuf+0)
	bit 3,a
	call nz,Player2RightTurn
	ld a,(KeyBuf+0)
	bit 0,a
	call nz,Player2LeftTurn
	ld a,(KeyBuf+3)
	bit 2,a
	call nz,PauseTime
	ld a,(KeyBuf+6)
	bit 6,a
	jr nz,AnyPlayerExit
	ret


AnyPlayerExit:
	pop hl
	call GET_KEY

Exit:
	call _clrLCD
	ret

PauseTime:
   	push af
    call GET_KEY
    ld a, 11100000b
    ld ($FC80),a
PauseKey:
    call Delay
    call Delay
    ld b, 16
    ld hl, $FC80
    ld a, (hl)
    rrca
ScrLoop:
    ld (hl),a
    inc hl
    djnz ScrLoop
    call GET_KEY
    cp $1B          ; 5 = continue game
    jr z, PauseDone
    cp $37          ; EXIT = exit
    jr nz, PNot_Exit
    pop af
		pop hl			;return address
		pop hl			;return address
    jr Exit
PNot_Exit:
    cp $36
    jr nc, PauseKey ; key > 35 : nothing
    cp $31
    jr c, PauseKey  ; key < 31 : nothing
    sub $30 ; delay = 8*(key-30)
    rlca
    rlca
    rlca
    ld (DelayCnt), a
    jr PauseKey
PauseDone:
    ld bc, 16
    ld hl, $FFE0
    ld de, $FC80
    ldir
	ld a,(KeyUp+3)
	res 2,a
	ld (KeyUp+3),a
    pop af
    	ret			;normal return






UpdatePos:
    ld de, Y1
    ld hl, DeltaY1
    ld b, 4
ChangePosLoop:
    ld a, (de)              ; change positions
    add a, (hl)
    ld (de), a
    inc de
    inc hl
    djnz ChangePosLoop
	ret


Delay:
	push af
    push bc         ; delay cycle movement
    ld a, (DelayCnt)
    ld b, a
    ld c, 255
DelayLoop:
    dec bc
    ld a, b
    or c
    jr nz, DelayLoop
    pop bc
    pop af
    ret




CheckCrash:
	ld a,0
    ld (CrashStatus),a
	ld hl,(Y1)
    ld de,(Y2)
	or a
    sbc hl,de
	jr z,crashtogether
	ld bc,(Y1)
	call Read_Point		;1 crash
	or a
	call nz,onecrashed
	ld bc,(Y2)
	call Read_Point
	or a
	call nz,twocrashed
	ret
crashtogether:
	ld a,3
	ld (CrashStatus),a
	ret
onecrashed:
	ld a,(CrashStatus)
	set 0,a
    ld (CrashStatus),a
	ret
twocrashed:
    ld a,(CrashStatus)
	set 1,a
	ld (CrashStatus),a
	ret





;

; Turn on point.  B=x  C=y  ;

;

; . (0,63)       . (127,63) ;

;                           ;

;   Screen Layout           ;

;                           ;

; . (0,0)        . (127,0)  ;

;

Point_on:
   	push bc
    call FIND_PIXEL    ; HL=offset, A=2^bit
    ld de, $FC00
    add hl, de
    or (hl)
    ld (hl),a
    pop bc
    ret


; . (0,63)       . (127,63) ;
;                           ;
;   Screen Layout           ;
;                           ;
; . (0,0)        . (127,0)  ;

	;b=x;c=y a returned boolean value
Read_Point:
  	push bc
    call FIND_PIXEL    ; HL=offset, A=2^bit
    ld de, $FC00
    add hl, de
    and (hl)
    pop bc
    ret


FIND_PIXEL:
	ld a,c
	xor %00111111
	push af
	and %11110000
	rrca
	rrca
	rrca
	rrca
	ld h,a
	pop af
	and %00001111
	rlca
	rlca
	rlca
	rlca
	ld l,a				;de now contains offset for row
	ld a,b			;now work with x coord
	push af
	and %01111000
	rrca
	rrca
	rrca
	ld c,a
	ld b,0
	add hl,bc
	pop af
	and %00000111
	xor %00000111
	ld b,a
	inc b				;so it's 1-8
	sub a
	scf
pixelloop:
	rla
	djnz pixelloop
	ret					;with a containing bit, hl containing offset


wongame1:
			call UpdateScore1
			jr GoKeyLoop

wongame2:
			call UpdateScore2
			jr GoKeyLoop

wongameneither:
			call UpdateScore1
			call UpdateScore2
			jr GoKeyLoop

UpdateScore2:
   	ld hl,  $0002
    ld (_penCol), hl
    ld hl, CrashStr
    call _vputs
    ld hl, (Score2)
    inc hl
    ld (Score2), hl
	ret
UpdateScore1:
    ld hl,  $006b
    ld (_penCol), hl
    ld hl, CrashStr
    call _vputs
    ld hl, (Score1)
    inc hl
    ld (Score1), hl
	ret

GoKeyLoop:
	call GET_KEY
	cp K_EXIT
	ret z
	cp K_5
	jr nz, GoKeyLoop
	
	ld a,(KeyUp+3)
	res 2,a
	ld (KeyUp+3),a
	jp start

HL_Decimal:
   	ld (_penCol), de
    ld de, StringPlace+4
    ld b, 5
ConvLoop:
    call UNPACK_HL
    add a, '0'
    ld (de), a
    dec de
    djnz ConvLoop
    ld hl, StringPlace
    call _vputs
    ret


	.db $80,$80
movetable:
	.db 1,0,0,1,-1,0,0,-1,$80,$80			;as move right. right turns


CrashStr: .db "CRASH", 0

TitleStr:
	.db "Tron86 v1.5",0
AuthorStr:
	.db "By: Alan Bailey",0



	.end
;mnkfg
