#include "ti86asm.inc"

Pile1 = _textShadow        ;Number of bricks, Size of bricks
Pile2 = Pile1+11
Pile3 = Pile2+11
Temp =  Pile3+11            ;Pile XCoord, which brick, which size
PP =	Temp+5			;Picked piece
From =	PP+1
NoM =	From+1			;Number of moves
Counter =	NoM+2
PXCoord =	Counter+1
XCoord =	PXCoord+1
YCoord =	XCoord+1

.org _asm_exec_ram
        nop
        jp Start
.dw $0000
.dw Title

Start:
        call _flushallmenus
        call _runindicoff
        call _clrLCD
        res 1,(iy+$0D)

	ld hl,Name
	rst 20h
	rst 10h
	jr c,Notexist
	ld a,b
	ex de,hl
	call _ahl_plus_2_pg3
	call _set_abs_src_addr
	ld a,1
	ld hl,$0100
	call _set_abs_dest_addr
	xor a
	ld hl,2000
	call _set_mm_num_bytes
	call _mm_ldir
	call _ram_page_1
	call $8100

Notexist:
        ld hl,Pile1
        ld de,Pile1+1
        ld bc,50
        ld (hl),0
        ldir

Message:
	call _homeup
	set textInverse,(iy+textflags)
	ld hl,Title
	call _puts
	res textInverse,(iy+textflags)

DispBlocks:
	ld bc,51*256+27
	ld (_penCol),bc
	call _vputs
	ld bc,57*256+27
	ld (_penCol),bc
	call _vputs
	ld bc,11*256+1
	ld (_penCol),bc
	call _vputs
	ld bc,29*256+1
	ld (_penCol),bc
	call _vputs

	ld hl,$FD30
	ld d,h
	ld e,l
	ld a,%01111111
	ld (hl),a
	inc hl
	rlca
	ld (hl),a
	inc hl
	ex de,hl
	ld bc,14
	ldir

	ld de,$FDBF
	inc hl
	ld bc,16
	lddr

	ld hl,$FD40
	ld d,h
	ld e,l
	ld a,$80
	ld (hl),a
	inc hl
	rlca
	ld (hl),a
	inc hl
	ex de,hl
	ld bc,110
	ldir

	ld hl,$FE54
	ld d,h
	ld e,l
	ld a,%01111111
	ld (hl),a
	ld a,255
	inc hl
	ld (hl),a
	inc hl
	ld (hl),a
	inc hl
	ld a,%11111110
	ld (hl),a
	inc hl
	ex de,hl
	ld bc,4
	ldir

	ld hl,$FEFC
	ex de,hl
	ld bc,9
	lddr

	ld hl,$FE64
	ld d,h
	ld e,l
	ld a,%10000000
	ld (hl),a
	inc hl
	inc hl
	inc hl
	rlca
	ld (hl),a
	inc hl
	ex de,hl
	ld bc,4
	ldir

	ld hl,$FE60
	ld de,$FE70
	ld bc,128
	ldir


DispNumbers:
	ld hl,$14FB
	ld (_penCol),hl
	ld c,2
	ld b,7
DNLoop
	ld a,(_penCol)
	add a,8
	ld (_penCol),a
	inc c
	ld a,c
	call DispA
	djnz DNLoop
	inc c
	ld a,(_penCol)
	add a,7
	ld (_penCol),a
	ld a,c
	call DispA
	
	ld hl,39*256+35
	ld (_penCol),hl
	ld hl,NormalTxt
	call _vputs
	ld a,(_penCol)
	add a,7
	ld (_penCol),a
	call _vputs

	ld a,(CMode)
	call BigInvert

	ld a,(Blocks)
	call Select

	call Stupid2

MessageLoop:
	call Stupid
MessageLoopB:
	call _getkey
	cp kLeft
    jr z,DecNoB
	cp kDown
	jr z,SelectMode
	cp kExit
	jp z,Quit
	cp kEnter
	jr z,StartGame
	cp kRight
	jr nz,MessageLoopB

IncNoB:
	ld a,(Blocks)
	cp 10
	jr z,MessageLoopB
	inc a
	ld (Blocks),a
	dec a
Common:
	call Select
	ld a,(Blocks)
	call Select
	jr MessageLoopB

DecNoB:
	ld a,(Blocks)
	cp 3
	jr z,MessageLoopB
	dec a
	ld (Blocks),a
	inc a
	jr Common

SelectMode:
	call Stupid
SelectModeLoop:
	call _getkey
	cp kEnter
	jr z,StartGame
	cp kRight
	jr z,SetMode
	cp kUp
	jr z,MessageLoop
	cp kExit
	jp z,Quit
	cp kLeft
	jr nz,SelectModeLoop

SetMode:
	ld a,(CMode)
	call BigInvert
	ld a,(CMode)
	xor 1
	ld (CMode),a
	call BigInvert
	jr SelectModeLoop

StartGame
	ld a,(CMode)
	or a
	jr z,Begin
	jp Puzzle

Begin:
	call _clrLCD
	ld hl,Pile1
    ld a,(Blocks)
    ld (hl),a
    inc hl
    ld b,a
Loop:
    ld (hl),a
    dec a
    inc hl
    djnz Loop
Loopend:
	ld a,-23
	ld (PXCoord),a
    call DrawFirst
        
Move:
	ld a,-23
	ld (PXCoord),a
	call _getkey
	cp kExit
	jp z,EndRound
	cp kF1
	jr z,FromRoutine
	cp kF3
	jr z,FromRoutine
	cp kF5
	jr nz,Move

FromRoutine:
	ld l,7
	sub $C2
	sra a
	ld b,a
	ld (From),a
	add a,a
	ld c,a
	add a,a
	ld d,a
	add a,c
	add a,b
	add a,3
	ld h,a
	ld (_curRow),hl
	sub 3
	add a,d
	ld e,a
	ld d,0
	ld hl,Pile1
	add hl,de
	ld a,6
	call _putc
	ld c,(hl)
	xor a
	cp c
	jr z,MoveNot
	dec (hl)
	ld b,0
	add hl,bc
	ld a,(hl)
	ld (PP),a
	xor a
	ld (hl),a
	jr To
MoveNot:
	call DrawFirst
	jr Move

To:
	call _getkey
	cp kExit
	jp z,EndRound
	cp kF1
	jr z,ToRoutine
	cp kF3
	jr z,ToRoutine
	cp kF5
	jr nz,To

ToRoutine:
	sub $C2
	sra a
	ld b,a
	ld a,(From)
	cp b
	jr z,CouldntMove
	ld a,b
	add a,a
	add a,b
	add a,a
	add a,a
	sub b
	ld e,a
	ld d,0
	ld hl,Pile1
	add hl,de
	ld d,h
	ld e,l
	ld c,(hl)
	xor a
	cp c
	jr nz,NotZ
	inc hl
NotZ:
	ld b,0
	add hl,bc
	ld b,(hl)
	xor a
	cp b
	jr z,Zero
	ld a,(PP)
	cp b
	jr nc,CouldntMove
Zero:
	ld h,d
	ld l,e
	inc (hl)
	ld c,(hl)
	ld b,0
	add hl,bc
	ld a,(PP)
	ld (hl),a
	ld hl,(NoM)
	inc hl
	ld (NoM),hl
	call DrawFirst

CheckDone:
	ld hl,Pile2
	ld a,(Blocks)
	ld b,(hl)
	cp b
	jr z,Done
	ld hl,Pile3
	ld a,(Blocks)
	ld b,(hl)
	cp b
	jr z,Done
	jp Move

CouldntMove:
	ld a,(From)
	ld b,a
	add a,a
	add a,b
	add a,a
	add a,a
	sub b
	ld e,a
	ld d,0
	ld hl,Pile1
	add hl,de
CMRoutine:
	inc (hl)
	ld c,(hl)
	ld b,0
	add hl,bc
	ld a,(PP)
	ld (hl),a
	call DrawFirst
	jp Move

Done:
	ld hl,$0301
	ld (_curRow),hl
	ld hl,Congrats
	call _puts
	call _getkey
	call _clrLCD
	jp Notexist

Puzzle:
	ld a,(Blocks)
	ld b,a
PuzzleLoop:
	call Random
	ld e,a
	add a,a
	add a,e
	add a,a
	add a,a
	sub e
	ld e,a
	ld d,0
	ld hl,Pile1
	add hl,de
	inc (hl)
	ld e,(hl)
	add hl,de
	ld (hl),b	
	djnz PuzzleLoop
	jp Loopend

EndRound:
	call _clrLCD
	jp Notexist

Select:
	sub 3
	add a,a
	ld e,a
	ld d,0
	ld hl,$FD40
	add hl,de
	ld de,15
	ld b,7
Invert:
	ld a,(hl)
	xor %01111111
	ld (hl),a
	inc hl
	ld a,(hl)
	xor %11111110
	ld (hl),a
	add hl,de
	djnz Invert
	ret


Random:
	push bc
	push de
	push hl
	call _random
	call _op2set3
	call _FPMULT
	call _convop1
	pop hl
	pop de
	pop bc
	ret
	

DrawFirst:
	ld hl,$FC00
	ld de,$CA00
	ld bc,1024
	ldir
	ld a,$0A
	out (0),a
	call _clrLCD
        ld hl,Pile1-1
DrawPile1:
        ld a,0
        ld (Temp+1),a
        inc hl
        ld b,10
        ld a,(PXCoord)
        add a,43
        ld (PXCoord),a
DrawP1Loop:
        push bc
        ld a,(Temp+1)
        inc a
        ld (Temp+1),a
        inc hl
        ld a,(hl)
        push hl
        call CheckSize
        pop hl
        pop bc
        djnz DrawP1Loop
        ld a,(Counter)
        inc a
        ld (Counter),a
        cp 3
        jr nz,DrawPile1

Return:
	ld hl,(NoM)
	ld bc,$0101
	ld (_penCol),bc
	call DispHL
	xor a
	ld (Counter),a
	ld b,4
	ld hl,Temp
RetLoop:
	ld (hl),a
	inc hl
	djnz RetLoop

	ld a,$3C
	out (0),a

	ret

CheckSize:
        or a
        jr z,DrawPin

        ld (Temp+2),a
        ld a,(Temp+1)
		add a,a
		add a,a
        ld b,a
        ld a,63
        sub b
        ld (YCoord),a
        jr PutItOut

DrawPin:
        ld a,(PXCoord)
        dec a
        ld (XCoord),a
        ld a,(Temp+1)
		add a,a
		add a,a
        ld b,a
        ld a,63
        sub b
        ld (YCoord),a
        ld a,(YCoord)
        ld b,4
        sub b
        ld d,a
        ld (YCoord),a
        ld c,4
PinYLoop:        
        ld b,2
        ld a,(YCoord)
        dec a
        ld (YCoord),a
        ld a,(XCoord)
        ld e,a

PinXLoop:
        call PutPixel
        inc e
        djnz PinXLoop
        dec c
        jr nz,PinYLoop
        ret
        
PutItOut:
        ld a,(Temp+2)
        add a,a
        ld b,a
        ld a,(PXCoord)
        sub b
        ld e,a
        ld (XCoord),a
        ld a,(YCoord)
        ld b,8
        sub b
        ld d,a
        ld (YCoord),a
        push de
        ld a,(Temp+2)
		add a,a
		add a,a
        ld b,a
        ld c,3
YLoop:
        ld a,(YCoord)
        inc a
        ld (YCoord),a
        ld a,(Temp+2)
		add a,a
		add a,a
        ld b,a
        ld a,(XCoord)
        ld e,a

XLoop:
        call PutPixel
        inc e
        djnz XLoop
        dec c
        jr nz,YLoop
        pop de
        ret

PutPixel:
        push bc
        ld a,(YCoord)
        ld c,a
		ld b,e
        call Find_Pixel
        or (hl)
        ld (hl),a
        pop bc
        ret

Quit:        
	set graphdraw,(iy+graphflags)
	set 1,(iy+$0D)
    call _clrScrn
	jp _homeup



BigInvert:
	add a,a
	add a,a
	add a,4
	ld e,a
	ld d,0
	ld hl,$FE60
	add hl,de
	ld de,13
	ld b,9
BInvert:
	ld a,(hl)
	xor %01111111
	ld (hl),a
	inc hl
	ld a,(hl)
	cpl
	ld (hl),a
	inc hl
	ld a,(hl)
	cpl
	ld (hl),a
	inc hl
	ld a,(hl)
	xor %11111110
	ld (hl),a
	add hl,de
	djnz BInvert
	ret


Stupid:
	ld hl,$FCB0
	call SelectWhat
Stupid2:
	ld hl,$FDD0
SelectWhat:
	ld de,12
	ld c,7
ThisLoop:
	ld b,4
SmthLoop:
	ld a,(hl)
	cpl
	ld (hl),a
	inc hl
	djnz SmthLoop
	add hl,de
	dec c
	jr nz,ThisLoop
	ret

DispA:                                  ;Routine to Display A [By: Matthew Shepcar]
 ld l,a                                 ;Loads a into l
 ld h,0                                 ;0 into H
DispHL:                                 ;Displays HL [By: Matthew Shepcar]
 xor a                                  ;Loads 0 into A
 ld de,-1                               ;Loads -1 into DE
 ld (_curRow),de                        ;Loads de into CurRow
 call 4A33h                             ;Calls 4A33h
 dec hl                                 ;Decrease it
 jp _vputs                              ;Put on screen and return




;------------------------------------------------------
;   FIND PIXEL ROUTINE by CLEM <clems@mygale.org>
;
;       Input:  x->b
;               y->c
;
;       Output: hl : byte in LCD memory
;               a  : bitmask for (hl)
;
;   121 cycles  27 bytes    Destroyes : none
;------------------------------------------------------

Find_Pixel:
    ld h,63
    ld a,c
    add a,a
    add a,a
    ld l,a
    ld a,b
    rra
    add hl,hl
    rra
    add hl,hl
    rra
    or l
    ld l,a
    ld a,b
    and 7
    cpl
    rlca
    rlca
    rlca
    ld (FP_Bit+1),a
    xor a
FP_Bit:
    set 0,a
    ret


NormalTxt:	.db "Normal",0
PuzzleTxt:	.db "Puzzle",0

CMode:	.db 0
Blocks:	.db 3

Title:
        .db " The Tower of Hanoi  ",0

Author:
	.db "Made by Andreas Finne",0
Email:
	.db "a_finne@hotmail.com",0

Numbertxt:	.db "Blocks:",0
Modetxt:	.db "Mode:",0

Congrats:	.db "Congratulations!",0
Name:	.db $0C,5,"intro",0

.end
