;THX 1138
;(c) 1998 Brandon Turok
;
;This is my first worthwhile ASM program.  It's probably
;very inefficient, so i don't see why you'd want to copy
;and paste from it.  If you find a need to, email me at
;windowswiz@ibm.net and ask me first.  thanks.
;

#include "asm86.h"
#include "ti86asm.inc"

.org _asm_exec_ram

; variables
XCoord		= _textShadow
YCoord		= _textShadow+2
Direction	= _textShadow+4
TempAcc		= _textShadow+6
Speed		= _textShadow+8
Score		= _textShadow+10
TermZero	= _textShadow+162

; the program

init:
  ld hl,pic
  ld de,$fc00
  ld bc,$400
  ldir

SpeedLoop:
  call _getky
  or a
  cp K_F1
  jp z,VerySlow
  cp K_F2
  jp z,Slow
  cp K_F3
  jp z,Normal
  cp K_F4
  jp z,Fast
  cp K_F5
  jp z,VeryFast
  cp K_EXIT
  jp z,End
  jp SpeedLoop

VerySlow:
  call _clrtextmem
  ld hl,$2200
  ld (Speed),hl
  jp Init

Slow:
  call _clrtextmem
  ld hl,$1700
  ld (Speed),hl
  jp Init

Normal:
  call _clrtextmem
  ld hl,$1000
  ld (Speed),hl
  jp Init

Fast:
  call _clrtextmem
  ld hl,$750
  ld (Speed),hl
  jp Init

VeryFast:
  call _clrtextmem
  ld hl,$250
  ld (Speed),hl
  jp Init


Init:
  call _clrLCD
  call _grbufclr
  ld a,0
  ld (TempAcc),a
  ld a,63
  ld (XCoord),a
  ld a,27
  ld (YCoord),a
  ld a,0
  ld (Score),a
  ld a,4
  ld (Direction),a
  ld b,0
  ld c,1
  ld d,126
  ld e,1
  ld h,1
  call _ILine
  ld b,0
  ld c,1
  ld d,0
  ld e,55
  ld h,1
  call _ILine
  ld b,0
  ld c,55
  ld d,126
  ld e,55
  ld h,1
  call _ILine
  ld b,126
  ld c,55
  ld d,126
  ld e,1
  ld h,1
  call _ILine
  ld a,1
  ld (_penRow),a
  ld a,1
  ld (_penCol),a
  ld hl,TitleStr
  call _vputs
  ld hl,0000
  ld a,1
  ld (_penRow),a
  ld a,113
  ld (_penCol),a
  call DM_HL_DECI

MainLoop:
  call Delay
  halt
  call _getky
  or a
  cp K_EXIT
  jp z,End
  cp K_UP
  call z,GoUp
  cp K_RIGHT
  call z,GoRight
  cp K_LEFT
  call z,GoLeft
  cp K_DOWN
  call z,GoDown
  cp K_MORE
  call z,Pause
  jp PlotCheck
MainLoop2:
  call IncScore
  jp MainLoop
;-------------------------------
;Direction Key:
;      1
;   4 <^> 2
;      v
;      3
;-------------------------------

GoUp:
  ld a,(Direction)
  ld d,a
  ld a,3
  cp d
  ret z
  ld a,1
  ld (Direction),a
  ret

GoRight:
  ld a,(Direction)
  ld d,a
  ld a,4
  cp d
  ret z
  ld a,2
  ld (Direction),a
  ret

GoDown:
  ld a,(Direction)
  ld d,a
  ld a,1
  cp d
  ret z
  ld a,3
  ld (Direction),a
  ret

GoLeft:
  ld a,(Direction)
  ld d,a
  ld a,2
  cp d
  ret z
  ld a,4
  ld (Direction),a
  ret


PlotCheck:          ;check which direction the line is going
  ld a,(Direction)
  cp 1
  call z,PlotUp
  cp 2
  call z,PlotRight
  cp 3
  call z,PlotDown
  cp 4
  call z,PlotLeft

  ld a,(XCoord)       ;check for collision
  ld b,a
  ld a,(YCoord)
  ld c,a
  ld d,3
  call _IPoint
  jp nz,Crash

  ld a,(XCoord)       ;plot next point on line
  ld b,a
  ld a,(YCoord)
  ld c,a
  ld d,1
  call _IPoint
  jp MainLoop2

PlotUp:
  ld hl,YCoord
  inc (hl)
  ret

PlotDown:
  ld hl,YCoord
  dec (hl)
  ret

PlotLeft:
  ld hl,XCoord
  dec (hl)
  ret

PlotRight:
  ld hl,XCoord
  inc (hl)
  ret

Delay:
  ld bc,(Speed)
DelayLoop:
  dec bc
  ld a,b
  or c
  jr nz,DelayLoop
  ret

IncScore:
  ld hl,TempAcc
  inc (hl)
  ld a,7
  ld b,a
  ld a,(TempAcc)
  cp b
  call z,UpdateScore
  ret

UpdateScore:
  ld a,0
  ld (TempAcc),a
  ld hl,(Score)
  inc hl
  ld (Score),hl
  ld a,1
  ld (_penRow),a
  ld a,113
  ld (_penCol),a
  call DM_HL_DECI
  ret

Pause:
  ld a,1
  ld (_penRow),a
  ld a,1
  ld (_penCol),a
  ld hl,BlankStr
  call _vputs
  ld a,1
  ld (_penRow),a
  ld a,10
  ld (_penCol),a
  ld hl,BlankStr
  call _vputs
  ld a,1
  ld (_penRow),a
  ld a,1
  ld (_penCol),a
  ld hl,PauseStr
  call _vputs
  call _getkey
  ld a,1
  ld (_penRow),a
  ld a,1
  ld (_penCol),a
  ld hl,TitleStr
  call _vputs
  ret

Crash:
  ld a,1
  ld (_penRow),a
  ld a,1
  ld (_penCol),a
  ld hl,BlankStr
  call _vputs
  ld a,1
  ld (_penRow),a
  ld a,10
  ld (_penCol),a
  ld hl,BlankStr
  call _vputs
  ld a,1
  ld (_penRow),a
  ld a,1
  ld (_penCol),a
  ld hl,CrashStr
  call _vputs
  ld a,1
  ld (_penRow),a
  ld a,73
  ld (_penCol),a
  ld hl,FinalScore
  call _vputs
  ld a,35
  ld (_penRow),a
  ld a,26
  ld (_penCol),a
  ld hl,BlankStr
  call _vputs
  ld b,25
  ld c,22
  ld d,103
  ld e,22
  ld h,0
  call _ILine
  ld b,25
  ld c,21
  ld d,103
  ld e,21
  ld h,1
  call _ILine
  ld b,25
  ld c,29
  ld d,103
  ld e,29
  ld h,1
  call _ILine
  ld b,25
  ld c,21
  ld d,25
  ld e,29
  ld h,1
  call _ILine
  ld b,26
  ld c,22
  ld d,26
  ld e,28
  ld h,0
  call _ILine
  ld b,103
  ld c,21
  ld d,103
  ld e,29
  ld h,1
  call _ILine
  ld a,35
  ld (_penRow),a
  ld a,27
  ld (_penCol),a
  ld hl,SpeedStr
  call _vputs

KeyLoop3:
  call _getky
  or a
  jp z,KeyLoop3
  cp K_UP
  jp z,KeyLoop3
  cp K_DOWN
  jp z,KeyLoop3
  cp K_LEFT
  jp z,KeyLoop3
  cp K_RIGHT
  jp z,KeyLoop3
  cp K_F1
  jp z,VerySlow
  cp K_F2
  jp z,Slow
  cp K_F3
  jp z,Normal
  cp K_F4
  jp z,Fast
  cp K_F5
  jp z,VeryFast
  cp K_EXIT
  jp z,End
  jp KeyLoop3

End:
  call _clrLCD
  ret

DM_HL_DECI:              ; *** DISPLAY HL IN MENU TEXT (thanks to Terry Peng)
 push bc                 ; 1
 ld de,TermZero          ; 3
 ld b,5                  ; 2
ConvLoop:
 call UNPACK_HL          ; 3
 add a,'0'               ; 2
 dec de                  ; 1
 ld (de),a               ; 1
 djnz ConvLoop           ; 2
 ld b,4                  ; 2
 ld hl,_curRow           ; 3
Compare:
 ld a,(de)               ; 1
 cp '0'                  ; 2
 jr nz,PrintString       ; 2
 inc de                  ; 1
 ld a,(hl)               ; 1
 add a,4                 ; 2
 ld (hl),a               ; 1
 djnz Compare            ; 2
PrintString:
 ex de,hl                ; 1
 call _vputs             ; 3
 pop bc                  ; 1
 ret                     ; 1 = 38 bytes

_grbufclr:		     	;Clears the graph buffer, so _ILine doesn't mess up
 ld hl,_plotSScreen	     	;GraphMem into HL
 ld (hl),0            		;Loads 0 into it
 ld de,_plotSScreen+1    	;Loads GraphMem+1 into de
 ld bc,1024                     ;Loads the 1024 into bc
 ldir                           ;Draws on screen
 set graphdraw,(iy+graphflags)  ;Sets Flag
 ret                            ;Return from Call

_clrtextmem:
  call _clrScrn
  ld hl,_textShadow
  ld de,_textShadow+1
  ld (hl),0
  ld bc,168
  ldir
  ret

TitleStr: .db "T H X   1 1 3 8",0
FinalScore: .db "Final Score:",0
PauseStr: .db "PAUSE",0
BlankStr: .db "                              ",0
CrashStr: .db "CRASH!",0
SpeedStr: .db "Pick a speed: [F1] - [F5]",0

pic:
  .db %00000000,%00000110,%10000000,%00000000,%00000000,%00000000,%00000100,%11000000,%00000001,%10000011,%01110010,%01100000,%00110111,%01110110,%00000000,%00000000
  .db %00000000,%00001000,%11000100,%01001100,%10001101,%10001000,%10001100,%01001001,%01001000,%10100010,%01000110,%00100000,%00100100,%01000010,%00000000,%00000000
  .db %00000000,%00001000,%10101010,%10101001,%01001001,%01010101,%01010100,%01010101,%01010100,%10000010,%01100010,%00100111,%00100110,%01100010,%00000000,%00000000
  .db %00000000,%00001000,%10101010,%10100101,%10000101,%10011001,%10010100,%01011001,%01011000,%10100010,%01000010,%00100000,%00100100,%00010010,%00000000,%00000000
  .db %00000000,%00000110,%10100100,%01001100,%11001101,%00001100,%11001100,%01001100,%10001100,%10000011,%01000111,%01100000,%00110100,%01100110,%00000000,%00000000
  .db %00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000
  .db %11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111
  .db %11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111
  .db %11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111
  .db %11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111
  .db %11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111
  .db %11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111
  .db %11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111
  .db %00000000,%00000000,%01111111,%10000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000
  .db %00000000,%00000000,%01111111,%10000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000
  .db %00000000,%00000000,%01111111,%10000000,%00111111,%11100000,%00000000,%00000000,%01111111,%10000111,%11111111,%00000000,%00000000,%00000111,%11111111,%00000000
  .db %00000000,%00000000,%01111111,%10000000,%00111111,%11100000,%00000000,%00000000,%01111111,%10000011,%11111111,%10000000,%00000000,%00001111,%11111110,%00000000
  .db %00000000,%00000000,%01111111,%10000000,%00111111,%11100000,%00000000,%00000000,%01111111,%10000001,%11111111,%11000000,%00000000,%00011111,%11111100,%00000000
  .db %00000000,%00000000,%01111111,%10000000,%00111111,%11100000,%00000000,%00000000,%01111111,%10000000,%11111111,%11100000,%00000000,%00111111,%11111000,%00000000
  .db %00000000,%00000000,%01111111,%10000000,%00111111,%11100000,%00000000,%00000000,%01111111,%10000000,%01111111,%11110000,%00000000,%01111111,%11110000,%00000000
  .db %00000000,%00000000,%01111111,%10000000,%00111111,%11100000,%00000000,%00000000,%01111111,%10000000,%00111111,%11111000,%00000000,%11111111,%11100000,%00000000
  .db %00000000,%00000000,%01111111,%10000000,%00111111,%11100000,%00000000,%00000000,%01111111,%10000000,%00011111,%11111100,%00000001,%11111111,%11000000,%00000000
  .db %00000000,%00000000,%01111111,%10000000,%00111111,%11100000,%00000000,%00000000,%01111111,%10000000,%00001111,%11111110,%00000011,%11111111,%10000000,%00000000
  .db %00000000,%00000000,%01111111,%10000000,%00111111,%11100000,%00000000,%00000000,%01111111,%10000000,%00000111,%11111111,%00000111,%11111111,%00000000,%00000000
  .db %00000000,%00000000,%01111111,%10000000,%00111111,%11100000,%00000000,%00000000,%01111111,%10000000,%00000011,%11111111,%10001111,%11111110,%00000000,%00000000
  .db %00000000,%00000000,%01111111,%10000000,%00111111,%11100000,%00000000,%00000000,%01111111,%10000000,%00000001,%11111111,%11011111,%11111100,%00000000,%00000000
  .db %00000000,%00000000,%01111111,%10000000,%00111111,%11100000,%00000000,%00000000,%01111111,%10000000,%00000000,%11111111,%11111111,%11111000,%00000000,%00000000
  .db %00000000,%00000000,%01111111,%10000000,%00111111,%11100000,%00000000,%00000000,%01111111,%10000000,%00000000,%01111111,%11111111,%11110000,%00000000,%00000000
  .db %00000000,%00000000,%01111111,%10000000,%00111111,%11111111,%11111111,%11111111,%11111111,%10000000,%00000000,%00111111,%11111111,%11100000,%00000000,%00000000
  .db %00000000,%00000000,%01111111,%10000000,%00111111,%11111111,%11111111,%11111111,%11111111,%10000000,%00000000,%00011111,%11111111,%11000000,%00000000,%00000000
  .db %00000000,%00000000,%01111111,%10000000,%00111111,%11111111,%11111111,%11111111,%11111111,%10000000,%00000000,%00001111,%11111111,%10000000,%00000000,%00000000
  .db %00000000,%00000000,%01111111,%10000000,%00111111,%11111111,%11111111,%11111111,%11111111,%10000000,%00000000,%00000111,%11111111,%00000000,%00000000,%00000000
  .db %00000000,%00000000,%01111111,%10000000,%00111111,%11111111,%11111111,%11111111,%11111111,%10000000,%00000000,%00001111,%11111111,%10000000,%00000000,%00000000
  .db %00000000,%00000000,%01111111,%10000000,%00111111,%11111111,%11111111,%11111111,%11111111,%10000000,%00000000,%00011111,%11111111,%11000000,%00000000,%00000000
  .db %00000000,%00000000,%01111111,%10000000,%00111111,%11111111,%11111111,%11111111,%11111111,%10000000,%00000000,%00111111,%11111111,%11100000,%00000000,%00000000
  .db %00000000,%00000000,%01111111,%10000000,%00111111,%11100000,%00000000,%00000000,%01111111,%10000000,%00000000,%01111111,%11111111,%11110000,%00000000,%00000000
  .db %00000000,%00000000,%01111111,%10000000,%00111111,%11100000,%00000000,%00000000,%01111111,%10000000,%00000000,%11111111,%11111111,%11111000,%00000000,%00000000
  .db %00000000,%00000000,%01111111,%10000000,%00111111,%11100000,%00000000,%00000000,%01111111,%10000000,%00000001,%11111111,%11011111,%11111100,%00000000,%00000000
  .db %00000000,%00000000,%01111111,%10000000,%00111111,%11100000,%00000000,%00000000,%01111111,%10000000,%00000011,%11111111,%10001111,%11111110,%00000000,%00000000
  .db %00000000,%00000000,%01111111,%10000000,%00111111,%11100000,%00000000,%00000000,%01111111,%10000000,%00000111,%11111111,%00000111,%11111111,%00000000,%00000000
  .db %00000000,%00000000,%01111111,%10000000,%00111111,%11100000,%00000000,%00000000,%01111111,%10000000,%00001111,%11111110,%00000011,%11111111,%10000000,%00000000
  .db %00000000,%00000000,%01111111,%10000000,%00111111,%11100000,%00000000,%00000000,%01111111,%10000000,%00011111,%11111100,%00000001,%11111111,%11000000,%00000000
  .db %00000000,%00000000,%01111111,%10000000,%00111111,%11100000,%00000000,%00000000,%01111111,%10000000,%00111111,%11111000,%00000000,%11111111,%11100000,%00000000
  .db %00000000,%00000000,%01111111,%10000000,%00111111,%11100000,%00000000,%00000000,%01111111,%10000000,%01111111,%11110000,%00000000,%01111111,%11110000,%00000000
  .db %00000000,%00000000,%01111111,%10000000,%00111111,%11100000,%00000000,%00000000,%01111111,%10000000,%11111111,%11100000,%00000000,%00111111,%11111000,%00000000
  .db %00000000,%00000000,%01111111,%10000000,%00111111,%11100000,%00000000,%00000000,%01111111,%10000001,%11111111,%11000000,%00000000,%00011111,%11111100,%00000000
  .db %00000000,%00000000,%01111111,%10000000,%00111111,%11100000,%00000000,%00000000,%01111111,%10000011,%11111111,%10000000,%00000000,%00001111,%11111110,%00000000
  .db %00000000,%00000000,%01111111,%10000000,%00111111,%11100000,%00000000,%00000000,%01111111,%10000111,%11111111,%00000000,%00000000,%00000111,%11111111,%00000000
  .db %00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000
  .db %00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000
  .db %11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111
  .db %11111111,%11111111,%11111111,%11111000,%11111111,%11100011,%11111111,%10001011,%11111111,%11111110,%00101100,%10111011,%11111111,%11111111,%11111111,%11111111
  .db %11111111,%11111111,%11111111,%11111010,%10011101,%11101010,%01110111,%11011001,%10101101,%11011110,%11111010,%10011001,%11111111,%11111111,%11111111,%11111111
  .db %11111111,%11111111,%11111111,%11111010,%10101010,%11101010,%10101011,%11011010,%10011010,%10101110,%01101100,%10101011,%11111111,%11111111,%11111111,%11111111
  .db %11111111,%11111111,%11111111,%11111010,%10101001,%11101010,%10100111,%11011010,%10111001,%10011110,%11101110,%10101011,%11111111,%11111111,%11111111,%11111111
  .db %11111111,%11111111,%11111111,%11111000,%10101100,%11100010,%10110011,%11011010,%10111100,%11001110,%00101001,%10101101,%11111111,%11111111,%11111111,%11111111
  .db %11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111
  .db %00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000
  .db %00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000
  .db %10100000,%00000001,%00000000,%00110000,%01000000,%00000000,%00000100,%00010000,%10011101,%11011100,%11000000,%00000000,%00100000,%00000111,%00000000,%00000100
  .db %10100100,%10101100,%00100110,%00001000,%10100000,%00000000,%00001000,%11001001,%10010101,%01010100,%10101010,%01101100,%01100100,%11000010,%01010101,%00100100
  .db %10101010,%11001001,%01010101,%00010000,%10100000,%00000000,%00001001,%00001000,%10011101,%11011100,%11001100,%10101010,%10101010,%10100010,%01010110,%01010101
  .db %01001100,%10000101,%01010101,%00100000,%10100000,%00000000,%00001001,%00001000,%10000100,%01010100,%10101000,%10101010,%10101010,%10100010,%01010100,%01010110
  .db %01000110,%10001101,%00100101,%00111010,%01000000,%00000000,%00000100,%11010001,%11011001,%10011100,%11001000,%01101010,%01100100,%10100010,%01110100,%00100101
.end
