#include "82port2.inc"

ProgDesc:
.db "SubHunt v1.3",0

string = TEXT_MEM
boatx  = TEXT_MEM+6
boaty  = TEXT_MEM+7
numlb  = TEXT_MEM+8
numrb  = TEXT_MEM+9
score  = TEXT_MEM+10
Bcounter = TEXT_MEM+12  ;counter for bullet drop speed
BWLcounter = TEXT_MEM+13 ;delay after firing a bullet from left
BWRcounter = TEXT_MEM+16 ;delay after firing a bullet from right
level = TEXT_MEM+14
temp = TEXT_MEM+15
yourHP = TEXT_MEM+17
temp3 = TEXT_MEM+18
eCounter1 = TEXT_MEM+19
eCounter2 = TEXT_MEM+20
eCounter3 = TEXT_MEM+21
shipsmax  = TEXT_MEM+22
shipsleft = TEXT_MEM+23
numhit    = TEXT_MEM+24
detonated = TEXT_MEM+25

ebullet1x = TEXT_MEM+26  ;storage for sub bullet coords
ebullet1y = TEXT_MEM+27  

homingb1x = TEXT_MEM2+80
homingb1y = TEXT_MEM2+81


enemy1x = TEXT_MEM2         ;storage for enemy coords
enemy1y = TEXT_MEM2+1
bullet1x = TEXT_MEM2+20        ;storage for bullet coords
bullet1y = TEXT_MEM2+21
bullet6y = TEXT_MEM2+31

enemy1hp  = TEXT_MEM2+50    ;storage for hp
enemy1s  = TEXT_MEM2+60   ;storage for speed
enemy1d  = TEXT_MEM2+70


ProgStart:
 ld hl,TEXT_MEM		
 ld bc,127		
 call OTH_CLEAR		
 ld hl,TEXT_MEM2
 ld bc,127
 call OTH_CLEAR

 ld a,2
 ld (Bcounter),a

 ld	hl,$0636
 ld	(boatx),hl
 dec h \ ld l,h
 ld	(numlb),hl

 set 3,(iy+5)
 set 6,(iy+24)
 ld hl,TopText
 ld de,$0000
 call DZM
 res 3,(iy+5)
 ld e,$56+24
 call DZM
 res 6,(iy+24)

 ld hl,$c9fa
 ld de,TEMPMEM+10
 ld bc,96
 ldir

Title:
 call PutBoat
 ROM_CALL(DISP_GRAPH)

 ld hl,ProgDesc
 ld de,$191E+16
 call DZM

 ld hl,AuthorTxt
 ld de,$2018+16
 call DZM

 ld de,$2721+12
 call DZM

 ld de,$2E10+12
 call DZM

 ld hl,(Highscore)
 ld e,$46+16
 ld b,5
 call DM_HL_DECI

 call InitLevel
 call Main
CheckHigh:
 ld hl,(Highscore)
 ld de,(score)
 call	CP_HL_DE
 jp nc,DoneGame
 ld hl,Highscore
 ld (hl),e
 inc hl
 ld (hl),d

 ld hl,HiScr
 ld de,$1E13+16
 call DZM

 ld hl, $0805
 ld (CURSOR_ROW),hl
 	ld	hl,HighName
	ld b,3								;max 10 letters
nameloop:
	push bc								;save counter
	push hl								;save pointer to high score data
namewait:
	ld a,'_'
	call $4A27						;put an underscore on the screen
	call GET_KEY
	cp G_ENTER							;if enter, leave this routine
	jr z,donename
	cp G_DEL							;if del, go back a space
	jr z,backspace
	or a								;if no keypress, check again
	jr z,namewait
	ld e,a								;save keypress in e
	ld a,$2e							;$2e = keypress for A
	ld d,0								;d is a counter...
letterloop:
	cp e
	jr z,gotletter						;if keypress = keypress for a certain letter
	inc d								;go to next letter in alphabet
	jr z,namewait						;if d = 0, it was a bad key (no letter above it)
	sub 8								;go to corresponding keypress for the next letter
	cp $0a								;check the include file...  there is a pattern for the letters
	jr nc,letterloop
	add a,$27
	jr letterloop						;keep going until the key codes match
gotletter:
	ld a,d								;put the number of the letter in a
	cp 20								;decrement if over 20 (equal sign)
	adc a,-1
	cp 24								;decrement if over 26 (pattern is disrupted for some reason...)
	adc a,-1
	cp 26								;the space doesn't follow the pattern, so it has to be fixed manually
	call z,space

	add a,$41							;translate to ascii codes
	call TX_CHARPUT							;stick it on the screen
	pop hl								;get address of high score back
	ld (hl),a							;save the letter there
	inc hl								;go to next byte
	pop bc
	djnz nameloop
      call OTH_PAUSE						;repeat up to 10 times
	jp DoneGame							;and then we're done

donename:								;if enter was pressed...
	pop hl
	pop bc
spaceloop:
	ld (hl),$20							;fill the rest of the string with spaces
	inc hl
	djnz spaceloop	
	jr DoneGame

space:
	ld a,$20-$41						;code for the space, adjusted to fit in the routine
	ret

backspace:
	ld a,$20
	call $4A27						;erase the underscore
	ld a,(CURSOR_COL)
	dec a								;go back a space in the text coordinates
	cp 4
	jr z,namewait
	ld (CURSOR_COL),a	
	pop hl
	dec hl								;same with the high score data
	pop bc
	inc b								;and the counter
	push bc
	push hl
	jr namewait
DoneGame:
 ld hl,ProgName        ; All this stuff is to make sure the hiscore table
 rst 20h	       ; and resume stuff are stored in the variable
 rst 10h
 ex de,hl	       ; HL -> start of variable
 ld a,b
 ld de,HighName-$D748+4   ; DE = relative offset to stuff to store (-4)
 add hl,de
 adc a,0	       ; Next block if necessary
 ld de,HighName        ; DE = start of bytes to copy
 ld b,6	       ; 156 bytes to copy
RepCopy:
 push af
 push hl
 call $46C3
 ld a,(de)	       ; Read
 ld (hl),a	       ; And save it in the real variable
 pop hl
 pop af
 call $4637
 inc de
 djnz RepCopy
	ret

ProgName:
 .db $12,5,"sub86"

TestCounters:
 ld a,(hl)
 sub 1
 jr nc,TestDone
 ld a,b
TestDone:
 ld (hl),a
 ret

Main:

 ld hl,eCounter3
 ld b,1
 call TestCounters

 dec hl 
 ld b,2
 call TestCounters

 dec hl
 ld b,3
 call TestCounters

 ld a,(level)
 cp 7
 jr nc,ThisBtoC
 ld a,6
ThisBtoC:
 ld b,a
 ld a,255
 call RANDOM
 cp b
 call c,NewEnemy

 call PutBoat
 call MoveEnemies
 call MoveBullets
 call ScanBullets

 ld a,(yourHP)
 cp 3
 jp nc,Dead
 ROM_CALL(DISP_GRAPH)
 ld a,(detonated)
 or a
 call nz,BigDelay  ;Wait a little while if there is an explosion onscreen
 xor a
 ld (detonated),a  ;This zero, whether something has exploded or not

 ld a,(shipsleft)
 or a
 call z,LevelUp

 ld a,(boatx)
 ld c,a

OTH_ARROW:                    ;Thank you Usgard!!!
        LD      A,$fe
        OUT     ($01),A ; Port 1 Keypad
        NOP \ NOP \ NOP \ NOP     
        IN      A,($01) ; Port 1 Keypad
        LD      B,A
        LD      A,$ff
        IN      A,($01) ; Port 1 Keypad
        LD      A,B
        LD      A,$bf
        OUT     ($01),A ; Port 1 Keypad
        IN      A,($01) ; Port 1 Keypad
        OR      $0f
        AND     B

 bit 2,a
 call z,MoveR
 bit 1,a
 call z,MoveL

 ld b,a

 ld a,c
 ld (boatx),a

 ld a,b
 bit 6,a
 ret z

 bit 7,a
 call z,Pause


 ld hl,BWLcounter
 ld a,(hl)
 or a
 jr z,NotRecentlyFiredL
 dec (hl)
 jr RRR

NotRecentlyFiredL:
 ld a,b
 bit 4,a
 push bc
 call z,FireL
 pop bc
RRR:
 ld hl,BWRcounter 
 ld a,(hl)
 or a
 jr z,NotRecentlyFiredR
 dec (hl)
 jr FinishLoop

NotRecentlyFiredR
 ld a,%00111111
 out (1),a
 in a,(1)
 bit 3,a
 call z,FireR
FinishLoop:
 jp Main

Pause:
  LD  A, 01           ; bit 3 = lcd status
  OUT ($03), A        ; bit 0 = ON-interrupt status
  EI                  ; enable interrupts
  HALT                ; wait for ON (that's the only interrupt)
  RES 4, (IY $09)     ; Turn off 'ON' flag
  ret

FireR:
 ld a,(Bcounter)
 cp 2
 ret nz

 ld a,(numrb)
 or a
 ret z
 dec a
 ld (numrb),a

 ld a,6
 ld (BWRcounter),a

StartRB:
 ld hl,bullet6y
 ld c,22
 jr StartB

 
ThisBullet:	
 ld a,(boaty)
 add a,8
 ld (hl),a
 dec hl
 ld a,(boatx)
 add a,c
 ld (hl),a
 ret 

 
FireL:
 ld a,(Bcounter)
 cp 2
 ret nz

 ld a,(numlb)
 or a
 ret z
 dec a
 ld (numlb),a

 ld a,6
 ld (BWLcounter),a

StartLB:
 ld hl,bullet1y
 ld c,0
StartB:
 ld b,5
WhichB1:
 ld a,(hl)
 or a
 jr z,ThisBullet
 inc hl
 inc hl
 djnz WhichB1
 ret


MoveR:
 ld b,a
 ld a,c
 cp 104
 ld a,b
 ret z
 inc c
 ret

MoveL:
 ld b,a
 ld a,c
 or a
 ld a,b
 ret z		
 dec c
 ret 


CopyA:
 ld b,16 
CALoop:
 ld a,c
 or (hl)
 ld (hl),a
 inc hl
 djnz CALoop
 ret

PutBoat:
 call _grbufclr
 ld a,(boatx)
 ld b,a

 ld a,(yourHP)
 ld c,a
 ld a,(boaty)
 add a,c
 ld c,a

 ld hl,Boat
 call PutSprite2
ShowTop:
 ld hl,GRAPH_MEM+(16*14)
 ld c,%10000000
 call CopyA

 ld hl,GRAPH_MEM+(16*15)
 ld c,%01111111
 call CopyA


 ld de,GRAPH_MEM
 ld hl,TEMPMEM+10
 ld bc,96
 ldir

 set 6,(iy+24)
 ld hl,(score)
 ld de,$0034+20
 ld b,5
 call DM_HL_DECI

 ld a,(level)
 ld l,a
 ld h,0
 ld de,$0056+32
 call DM_HL_DECI2

 res 6,(iy+24)

 ld hl,GRAPH_MEM+16
 ld de,GRAPH_MEM
 ld bc,96
 ldir
 
 ld hl,GRAPH_MEM+80
 ld (hl),$ff
 ld de,GRAPH_MEM+81
 ld bc,15
 ldir

 ld hl,Bombs

 ld a,(numlb)
 or a
 jr z,otherside
 ld bc,$4401
leflop:
 call PutSprite
 dec b
 dec b
 dec b
 dec a
 jr nz, leflop

otherside
 ld a,(numrb)
 or a
 ret z
 ld bc,$5D01
rightlop:
 call PutSprite
 inc b
 inc b
 inc b
 dec a
 jr nz, rightlop
 ret


MoveBullets:
 ld hl,Bcounter
 dec (hl)

 ld hl,Code_MoveBullets	;* Modify source and call the double routine
 ld (_TO_MODIFY_1+1),hl
 ld de,Bombs
 ld hl,bullet1y
 ld b,10
 call MoveSomeBullets		

MoveEBullets:
 ld hl,Code_MoveEBullets	;* Modify source and call the double routine
 ld (_TO_MODIFY_1+1),hl
 ld de,EBomb
 ld hl,ebullet1y
 ld b,30
 call MoveSomeBullets

MoveHBullets:
 ld hl,Code_MoveHBullets	;* Modify source and call the double routine
 ld (_TO_MODIFY_1+1),hl
 ld de,EBomb2
 ld hl,homingb1y
 ld b,15
 call MoveSomeBullets		

 ld hl,Bcounter
 ld a,(hl)
 or a
 ret nz
 ld a,2
 ld (hl),a
 ret 

MoveEnemies:
 ld a,8
 ld bc,enemy1s
 ld de,enemy1y
 ld hl,enemies
EMovLoop:
 push af
 push bc
 ld a,(de)
 or a
 jr z,SkipE
 push bc
 ld a,85
 call RANDOM
 call z,FireShot
CheckSpeed:
 pop bc
 ld a,(bc)
 ld bc,eCounter1
 or a
 jr z,CheckIt
 inc bc
 dec a
 jr z,CheckIt
 dec a
 jr nz,SpeedNow
 inc bc
CheckIt:
 ld a,(bc)
 or a
 jr nz,SkipE2
SpeedNow:
 dec de

 ld a,(HL)
 or a
 jr nz,GoRight

 ld a,(de)
 inc a
 cp 128
 jr z,ShipGone
 ld (de),a
 inc de
 jr SkipE2

GoRight:
 ld a,(de)
 dec a
 cp -16
 jr z,ShipGone
 ld (de),a
 inc de

SkipE2:
 push de
 push hl
 ld a,(de)
 ld c,a
 dec de
 ld a,(de)
 ld b,a
 inc hl
 call PutSprite3
 pop hl
 pop de

SkipE:
 ld bc,17
 add hl,bc

 pop bc
 inc bc
 inc de
 inc de

 pop af
 dec a
 jr nz,EMovLoop
 ret

ShipGone:
 pop bc
 push hl 
 ld h,b
 ld l,c
 ld bc,10
 add hl,bc
 ld (hl),0

 ld hl,shipsleft
 dec (hl)
 pop hl

 inc de
 xor a
 ld (de),a
 push bc
 jr SkipE

FireShot:
 push hl
 ld a,(level)
 cp 8
 jr c,SimpleFire
 ld a,5
 call RANDOM
 jr nz,SimpleFire
 ld hl,homingb1y
 ld b,15
 jr FLoop

SimpleFire
 ld hl,ebullet1y
 ld b,30
FLoop:
 ld a,(hl)
 or a
 jr z,EGood
 inc hl
 inc hl
 djnz FLoop
FDone
 pop hl
 ret     ;None availible

EGood:
 ld a,(de)
 ld (hl),a
 dec de
 dec hl
 ld a,(de)
 add a,7
 ld (hl),a
 inc de
 jr FDone

NewEnemy:
 ld a,8            ;15 enemies max
 ld hl,enemy1y     ;Y coordinate used to determine if enemy already out there
 ld de,enemies     ; DE = Pointer to enemy sprites
 ld bc,enemy1hp    ; BC = Pointer to enemy HP and enemy speed
SearchEmpty:
 push af           ;Save the no. of loops remaining
 ld a,(hl)         ;Load Y coord to A
 or a              ;Activate Z or NZ flag
 jr z,NoE          ;If Y = 0, then there's no enemy in this slot

 inc bc            ;Go to next HP entry

 ld a,e
 add a,17
 ld e,a
 ld a,d
 adc a,0
 ld d,a

 pop af            ;Restore loop counter

 inc hl
 inc hl             ;Go to next set of enemy coords
 dec a              ;Decrease A
 jr nz,SearchEmpty  ;If not zero, then keep looping
 ret                ;none empty then screen full and return

NoE:
 pop af             ;Pop the loop counter

 ld a,(shipsmax)
 or a
 ret z
 dec a
 ld (shipsmax),a


 push de            ;Save the sprite pointer
 push hl            ;Save Y coord

 ld h,b
 ld l,c            ;Load BC to HL
 ld de,10
 add hl,de         ;Add 10 to BC to get the enemy speed data

 ld a,4
 call RANDOM       ;Get a random # between 0-3
 ld (hl),a         ;Load that to current enemy speed

 push hl
 ld de,10
 add hl,de         ;Now DE points to enemy depth
 ex de,hl
 pop hl
 
 add a,3  		 ;Increase that number three times (3-6)
 ld h,a            ;Load that to H

 push bc

 push af
TestDepth:
 pop af
 ld a,8
 call RANDOM  ;random number (0-7)  ;8 different depths
 push af      ;Save AF
 inc a        ;So zero isn't an option
 ld c,a
 ld b,8
 ld ix,enemy1d
CheckDepths:
 ld a,(ix)
 cp c
 jr z,TestDepth
 inc ix
 djnz CheckDepths
 ld a,c
 ld (de),a

 inc a
 ld l,a               ;Load A to L
 call MUL_HL2          ;Multiply H*L = HL
 ld a,l               ;Load HL to A
 pop hl     		;* pop AF as HL (H=A)
 pop bc
 ld (bc),a            ;Load A to the enemy HP pointer

 ld l,6               ;Load 6 to L
 call MUL_HL2          ;HL = H*L
 ld de,16
 add hl,de 
 ld a,l               ;Load answer to A

 pop hl               ;Restore Y coord pointer
 ld (hl),a            ;Sub depth stored!  got that? ;)

 dec hl               ;Decrease HL to point to current X coord

 ld a,(bc)            ;Load enemy HP to A

SetESprite:
 set 6,(iy+24)  ;Write to graph_mem
 set 3,(iy+5)  ;Write inverse text
 push af          ;Save enemy HP pointer
 push hl          ;Save X coord pointer
 call _grbufclr   ;Clear Graph_mem, and trash all registers
 ld a,2 
 call RANDOM          ;Random number (0-1)
 ld (temp),a          ;Load it to temp space for use later (I'm tired of PUSH/POP's ;)
 pop hl	           ; do some stuff before GoRight2 and GoLeft2
 ld de,$0004           ;
 jr nz,GoLeft2        ;If 1, then ship moves left

GoRight2:               ;If zero, then go here
 ld (hl),-16              ;set coords
 pop af                 ;Restore enemyHP
 ld l,a                 ;Load enemy HP to A
 ld h,d			;Load 0 to HL
 inc e			;Write to these coords
 call DM_HL_DECI2       ;Use Mardell's DM_HL_DECI routine

 ld hl,SubRight
 jr PutNumber           ;Now copy the stuff to the right place


GoLeft2:
 ld (hl),128
 pop af         ;Pop enemyHP

 ld l,a       ;Load enemyHP to L
 ld h,d	  ; Load zero to H
 call DM_HL_DECI2  ;Mardell's DECI routine

 ld hl,SubLeft

PutNumber:
 res 3,(iy+5)  
 res 6,(iy+24) ;restore flags
 ld bc,$0000
 call PutSprite3   ;Right the appropriate sprite to the screen
 ld a,(temp)       ;hehe, finally the temp data is used
 pop de            ;Pop the sprite pointer
 ld (de),a         ;Load the sprite direction to the sprite data (used for movement routines)
 inc de            ;Go to actual sprite data
 ld hl,GRAPH_MEM   ;Copy first byte of first 8 lines of graph_mem 
 call copy_G_A     ;Do it

 ld de,8           ;Sprite pointer switched to HL by copy_G_A      
 add hl,de         ;Increase that by 8
 ex de,hl          ;Switch HL and DE

 ld hl,GRAPH_MEM+1   ;Now copy second byte of graph_mem
copy_G_A: 
 push de            ;Save SpritePointer
 ld b,8             ;8 lines to copy
cclop
 ld a,(hl)          ;ld (HL) to A
 ld (de),a          ;ld A to (de)
 inc de             ;Increase DE once
 push de            ;Save DE
 ld de,16
 add hl,de          ;Increase HL 12 times to get to the next row
 pop de             ;Restore DE
 djnz cclop         ;Decrease B, if not zero then loop 
 pop hl             ;Restore SpritePointer as HL
 ret                ;The x,y coords are set, the sprite is copied,

MUL_HL2:
 push bc 	
 call MUL_HL
 pop bc
 ret 

ScanBullets:
 ld a,10
 ld hl,bullet1x
ScanLoop:
 ld ix,enemy1hp
 ld de,enemy1x
 ld b,8
 push af
ScanLoop2:
 push de
 push hl
 push bc
 ld a,(hl)
 inc a
 ld b,a
 ld a,(de)
 cp 230
 jr nc,CheckNeg    ;If the enemy coord<0, then the carry will never be set.
 sub b
 jr z,CheckY
 jr nc,SkipThisE
 add a,18
 jr c,CheckY

SkipThisE:
 pop bc
 pop hl
 pop de

 inc de
 inc de
 inc ix
 djnz ScanLoop2
 inc hl
 inc hl
 pop af
 dec a
 jr nz,ScanLoop
 ret

CheckNeg:
 sub b
 jr z,CheckY
 add a,18
 jr nc,SkipThisE
CheckY:
 inc hl
 ld b,(hl) \ dec b
 inc de
 ld a,(de)
 sub b
 jr z,HitSub
 jr nc,SkipThisE
 add a,7
 jr c,HitSub
 jr SkipThisE

HitSub:
 ld c,(hl)
 xor a
 ld (de),a
 ld (hl),70
 dec hl
 ld b,(hl)

 dec c
 dec c
 dec c
 dec c

 dec b
 dec b
 ld hl,Explode
 push ix
 call PutSprite
 pop ix
 ld d,a
 ld a,(ix)
 ld e,a
 ld hl,(score)
 add hl,de
 ld (score),hl

 push ix
 pop hl
 ld de,20
 add hl,de
 ld (hl),0

 ld hl,shipsleft
 dec (hl)

 ld hl,numhit
 inc (hl)

 ld hl,detonated
 inc (hl)
 jr SkipThisE


Dead:
 ld b,58
DeadLoop:
 push bc
 ld hl,yourHP
 inc (hl)
 call PutBoat
 ROM_CALL(DISP_GRAPH)
 call BiggerDelay
 pop bc
 djnz DeadLoop
 ret


LevelUp:
 ld hl,(level)
 ld h,5
 call MUL_HL2
 ld a,l

 ld hl,(numhit)
 ld h,100
 call MUL_HL2

 call $4048

 ld a,l
 cp 100
 jr z,YouDaMan
 ld de,$201D+16
 call DM_HL_DECI2

AllGood:
 ld de,$1920+16
 ld hl,LevelDone
 call DZM

 ld de,$2025+16
 call DZM


InitLevel:
 ld a,(level)
 inc a
 ld (level),a
 cp 16
 jr z,Won

 ld l,a
 ld h,5
 call MUL_HL2
 ld a,l
 ld (shipsmax),a
 ld (shipsleft),a
 xor a
 ld (numhit),a
OTH_PAUSE:
 call GET_KEY
 cp G_ENTER
 ret z
 cp G_MODE
 jr nz,OTH_PAUSE
 inc sp
 inc sp
 ret

Won:
 ld de,$1E0B+16
 ld hl,YouWin
 call DZM
 call OTH_PAUSE
 inc sp 
 inc sp
 ret

YouDaMan:
 ld b,3
 ld de,$2019+16
 call DM_HL_DECI

 ld de,$270B+16
 ld hl,Perfect
 call DZM

 ld hl,(score)
 ld de,100
 add hl,de
 ld (score),hl
 jr AllGood


;------------------------------------------------------------------------------------
; MoveSomeBullets: used by MoveBullets and MoveEBullets
; 	address of sprite Bombs or EBomb in DE
;	address of Code_MoveBullets or Code_MoveEBullets stored in _TO_MODIFY_1+1
;	hl contains address bullet1y or ebullet1y
:------------------------------------------------------------------------------------
MoveSomeBullets:
MovBLoop:
 push bc
 push hl
 ld a,(hl)
 or a
 jr z,SkipB
 ld a,(Bcounter)
 or a
 jr nz,NoMove

_TO_MODIFY_1:
 call $0000		;* will be Code_MoveBullets or Code_MoveEBullets
 jr nc,SkipB		;* function returns nc when Detonate or ClearB executed

NoMove:
 ld c,(hl)
 dec hl
 ld b,(hl)

 ex de,hl
 call PutSprite
 ex de,hl
SkipB:
 pop hl			
 inc hl
 inc hl
 pop bc
 djnz MovBLoop
 ret

;------------------------------------------------------------------------------------
; 'Plugin' code for MoveSomeBullets
;   returns carry if ClearB is not executed
;           not-carry if clearB is not executed
:------------------------------------------------------------------------------------
Code_MoveBullets:
 inc (hl)	; Increase Y coords of current bullet
 ld a,(hl)
 cp 64
 ret c
ClearB:
 xor a
 ld (hl),a
 ld a,b

 ld bc,numlb
 cp 6
 jr nc,ResetL	
ResetR:
 inc bc
ResetL:
 ld a,(bc)
 inc a
 ld (bc),a
 or a
 ret

Code_MoveHBullets:
 dec hl
 ld a,(hl)
 ld b,a
 ld a,(boatx)
 add a,10
 sub b
 jr z,NoWhere
 jr c,ShiftLeft
ShiftRight:
 inc (hl)
 inc (hl)
ShiftLeft:
 dec (hl)
NoWhere:
 inc hl
;------------------------------------------------------------------------------------
; 'Plugin' code for MoveSomeBullets
;   returns not-carry if Detonate is not executed
;           carry if Detonate is executed
:------------------------------------------------------------------------------------
Code_MoveEBullets:
 dec (hl)      ; Increase Y coords of current bullet
 ld a,(hl)
 cp 12
 scf
 ret nz

Detonate: 
 ld c,a
 xor a 
 ld (hl),a 	
 dec hl
 ld b,(hl)
 ld hl,Explode2
 call PutSprite
 ld hl,detonated
 inc (hl)
 ld c,b
CheckLop:
 ld a,(boatx)
 inc a
 sub c
 jr z,hitBoat
 jr nc,EndDetonate
 add a,19
 jr c,hitBoat
 jr EndDetonate
hitBoat:
 ld hl,yourHP
 inc (hl)
EndDetonate:
 or a
 ret 

;Misc Routines

BiggerDelay:
 call BigDelay
BigDelay:
 ei
 halt
 halt
 halt
 halt
 halt
 ret


PutSprite3:
 push hl
 push de
 call PutSprite
 call NextSprite
 jr Pop_N_Ret2

PutSprite2:
 call PutSprite
 call NextSprite
NextSprite:
 ld de,8
 add hl,de
 ld a,b
 ld b,8
 add a,b
 ld b,a


;----------------------------------------------------------------------------
;[ PutSprClpXOR ] [ABCDEFIX]                      [ 139 bytes ] [ CrASH_Man ]
;----------------------------------------------------------------------------
; Draws a sprite using only XOR data, with clipping
;
; parameters: HL -> sprite, (B,C) = coordinates
; returns:    Puts sprite in GRAPH_MEM
;

PutSprite:
 PUSH HL
 push de
 PUSH BC
 push af
 CALL PutSprClpXOR
 pop af
Pop_N_Ret:
 POP BC
Pop_N_Ret2:
 pop de
 POP HL
 RET


RANDOM:
 push hl
 push de 
 push bc
 ld b,a 	; Create a Random number
 ld hl,(TEMPMEM)
 ld a,r
 ld d,a
 ld e,(hl)
 add hl,de
 add a,l
 xor h
 ld (TEMPMEM),hl
 ld hl,0
 ld e,a
 ld d,h
randl:
 add hl,de
 djnz	randl
 ld a,h
 or a
 jr Pop_N_Ret
	

PutSprClpXOR:
   XOR  A
__XChange_1:    LD   DE, 8     ; D = 0, E = Height

                OR   C                            ; If C < 0
                JP   M, _SCX_NoBotClp             ; No bottom clip.

                LD   A, $3F                       ; Is C is offscreen?
                SUB  C
                RET  C

__XChange_2:    CP   8-1       ; If C + 7 < 64
                JR   NC, _SCX_NoVertClp           ; No vertical clip.
                INC  A
                LD   E, A
                JR   _SCX_NoVertClp               ; Height = 64 - C

_SCX_NoBotClp:
__XChange_3:    CP   -(8-1)    ; Is C is offscreen?
                RET  C

                ADD  A, E                         ; Find how many lines
                LD   C, A                         ; to actually draw
                SUB  E

                NEG
                LD   E, A
                ADD  HL, DE                       ; Move HL down
                LD   E, C                         ; by -C lines
                LD   C, D

_SCX_NoVertClp: PUSH HL                           ; IX -> Sprite
                POP  IX

                LD   A, $77                       ; OP code for
                LD   (_SCX_OPchg_1), A            ;   LD   (HL), A
                LD   (_SCX_OPchg_2), A

                XOR  A                            ; Is B > 0?
                OR   B
                JP   M, _SCX_NoRightClp

                CP   121                           ; Is B < 89?
                JR   C, _SCX_ClpDone
                CP   128
                RET  NC

                LD   HL, _SCX_OPchg_1             ; Modify LD to NOP
                JR   _SCX_ClpModify

_SCX_NoRightClp:CP   -7                           ; Is B is offscreen?
                RET  C

                LD   HL, _SCX_OPchg_2             ; Modify LD to NOP
_SCX_ClpModify: LD   (HL), D

_SCX_ClpDone:   LD   B, D
                LD   H, B
                LD   L, C    ;1
                ADD  HL, BC  ;2                     ; HL = Y * 16
                ADD  HL, BC  ;3
                ADD  HL, BC  ;4 
                ADD  HL, HL  ;8
                ADD  HL, HL  ;16

                LD   C, A                         ; HL = Y*16 + X/8
                SRA  C
                SRA  C
                SRA  C
                INC  C

                ADD  HL, BC
                LD   BC, GRAPH_MEM
                ADD  HL, BC

                LD   B, E                         ; B = number of rows

                CPL
                AND  %00000111                    ; find number of
                LD   E, A                         ; instructions to jump
                ADD  A, E
                ADD  A, E
                LD   (_SCX_OPchg_3 + 1), A        ; 3 * (7 - number)

                LD   DE, 17

_SCX_LineLoop:  LD   C, (IX)
                XOR  A
_SCX_OPchg_3:   JR   _SCX_OPchg_3                 ; modify

                RR   C
                RRA
                RR   C
                RRA
                RR   C
                RRA
                RR   C
                RRA
                RR   C
                RRA
                RR   C
                RRA
                RR   C
                RRA

                XOR  (HL)                         ; XOR with background
_SCX_OPchg_1:   LD   (HL), A                      ; Write
                DEC  HL                           ; HL -> next 8 pixels

                LD   A, C
                XOR  (HL)                         ; XOR with background
_SCX_OPchg_2:   LD   (HL), A                      ; Write
                ADD  HL, DE                       ; HL -> next row

                INC  IX                           ; Increment to next data
                DJNZ _SCX_LineLoop
                RET

DM_HL_DECI2:
 ld b,2
DM_HL_DECI:
 ld (CURSOR_X),de

 ld de,string+5
 xor a
 ld (de),a
RepUnp:
 dec de
 call UNPACK_HL
 add a,48
 ld (de),a
 djnz RepUnp
 ex de,hl
 jp D_ZM_STR


DZM:
 ld (CURSOR_X),de
DZM2:
 jp D_ZM_STR

_grbufclr:
 ld hl,GRAPH_MEM
 ld bc,1023
OTH_CLEAR:
 ld (hl),0
 ld d,h
 ld e,l
 inc de
 ldir
 ret

Bombs:
 .db %11000000
 .db %11000000
 .db %00000000
 .db %00000000
 .db %00000000
 .db %00000000
 .db %00000000
 .db %00000000


EBomb:
 .db %10100000
 .db %01000000
 .db %10100000
 .db %00000000
 .db %00000000
 .db %00000000
 .db %00000000
 .db %00000000

EBomb2:
 .db %01000000
 .db %01000000
 .db %10100000
 .db %00000000
 .db %00000000
 .db %00000000
 .db %00000000
 .db %00000000

Explode:
 .db %01110000
 .db %11011000
 .db %10101000
 .db %11011000
 .db %01110000
 .db %00000000
 .db %00000000
 .db %00000000

Explode2:
 .db %10101010
 .db %01010100
 .db %00111000
 .db %00000000
 .db %00000000
 .db %00000000
 .db %00000000

Boat:
 .db %00000000
 .db %00000100
 .db %00000010
 .db %00000111
 .db %11111111
 .db %01111111
 .db %00111111
 .db %00011111

 .db %01100110
 .db %01100110
 .db %11111111
 .db %11111111
 .db %11111111
 .db %11111111
 .db %11111111
 .db %11111111

 .db %00000000
 .db %00010000
 .db %00100111
 .db %11000100
 .db %11111110
 .db %11111100
 .db %11111000
 .db %11110000


SubRight:
 .db %00000111
 .db %10111000
 .db %11111000
 .db %11111000
 .db %11111000
 .db %10111000
 .db %00000000
 .db %00000000

 .db %11111000
 .db %00000110
 .db %00000111
 .db %00000111
 .db %00000111
 .db %00000110
 .db %00000000
 .db %00000000

SubLeft:
 .db %00001111
 .db %01110000
 .db %11110000
 .db %11110000
 .db %11110000
 .db %01110000
 .db %00000000
 .db %00000000

 .db %11110000
 .db %00001101
 .db %00001111
 .db %00001111
 .db %00001111
 .db %00001101
 .db %00000000
 .db %00000000


AuthorTxt:
 .db "Programmed by:",0
 .db "Sam Heald",0
HighTxt:
 .db "HighScore:  "
HighName:
 .db "SAM",0
Highscore:
 .dw 0


HiScr:  .db "A NEW HIGH SCORE!",0


TopText:
 .db "      SubHunt v1.3      ",0
 .db "L:",0
LevelDone:
 .db "Level Done!",0
 .db "% Destroyed",0

Perfect:
 .db "Perfect! 100 point bonus!",0

YouWin:
 .db "Congratulations! You won!",0

letters:
	.db $19,$21,$0a,$12,$1a,$22,$0b,$13,$1b,$23,$2b
	.db $0c,$14,$1c,$24,$2c,$0d,$15,$1d,$25,$2d,$0e
	.db $16,$1e,$26,$2e

DISP_GRAPH:
 ld hl,GRAPH_MEM
 ld de,$fc00
 ld bc,1024
 ldir
 ei
 halt
 halt
 halt
 ret

TEMPMEM:
enemies = TEMPMEM+200
.end


