; ASCR	- Advanced Sprite Clipping Routines
;
; 	by Jimmy Mrdell	970304	 Last update 970803
;
; Temporary variables needed:
;  clipmask  : Byte
;  rows2put  : Byte
;  bitmask	 : Byte
;
;
; PutSprite_MSB:
;  Puts an 8x8 sprite at coordinates B,C. HL should point to a bitmapped
;  sprite followed by a bitmapped mask, total 16 bytes. DE should point
;  to an a memory location where the background will be stored as a
;  bitmap (8 bytes). The sprite will be clipped.
;
; PutSprite:
;  Puts an 8x8 sprite at B,C. HL = pointer to sprite. No mask and no
;  background storage, just clipping.


PutSprite_MSB:		; BC = x,y	DE = background storage  HL = sprite + mask
 ld a,c
 cp 150
 jr nc,PMSB_NoBotClip
 cp 64
 ret nc
PMSB_NoBotClip:
 push bc
 push de
 push hl
 push ix
 ld a,$FF
 ld (clipmask),a
 bit 7,b
 jr z,PMSB_CheckRightClip
 ld a,b
 cp 249
 jr c,EndPMSB
 neg
 push bc
 ld b,a
 ld a,$FF
PMSB_LeftClip:
 srl a
 djnz PMSB_LeftClip
 pop bc
 res 7,b
 dec c
 ld (clipmask),a
 jr PMSB_CheckBotClip
PMSB_CheckRightClip
 ld a,b
 sub 113
 jr c,PMSB_CheckBotClip
 push bc
 ld b,a
 inc b
 ld a,$FF
PMSB_RightClip:
 add a,a
 djnz PMSB_RightClip
 ld (clipmask),a
 pop bc
PMSB_CheckBotClip:
 ld a,8
 ld (rows2put),a
 bit 7,c
 jr nz,PMSB_CheckTopClip
 bit 6,c
 jp nz,EndMSB
 ld a,64
 sub c
 cp 8
 jr nc,PMSB_ClippingDone
 ld (rows2put),a
 jr PMSB_ClippingDone
PMSB_CheckTopClip:
 ld a,c
 cp 249
EndPMSB:
 jr c,EndMSB
 ret c
 push bc
 neg
 ld b,a
 sub 8
 neg
 ld (rows2put),a
PMSB_TopClip:
 inc hl
 inc de
 djnz PMSB_TopClip
 pop bc
 ld c,0
PMSB_ClippingDone:
 di
 push iy
 push hl
 pop iy
 push de
 pop ix
 ld a,(rows2put)
 push af
 call FIND_PIXEL
Modify_5:
 ld de,$FC00
 add hl,de
 ld (bitmask),a
 pop bc
PMSB_PutRow:
 push bc
 push hl
 ld a,(clipmask)
 ld e,a
 ld a,(iy+8)
 and e
 ld e,a 	 ; e = mask for this row
 ld d,0 	 ; d = background for this row
 ld b,8 	 ; b = pixels left to put
 ld c,(iy) ; c = sprite row
 inc iy
PMSB_PutCol:
 push bc
 sla d
 ld a,(bitmask)
 and (hl)
 jr z,PMSB_NPH
 inc d
PMSB_NPH:
 rlc e
 jr nc,PMSB_NextBit
 ld a,(bitmask)
 rlc c
 jr c,PMSB_BitOn
 cpl
 and (hl)
 ld (hl),a
 jr PMSB_NextBit
PMSB_BitOn:
 or (hl)
 ld (hl),a
PMSB_NextBit:
 ld a,(bitmask)
 rrca
 ld (bitmask),a
 jr nc,PMSB_SSB
 inc hl
PMSB_SSB:
 pop bc
 rlc c
 djnz PMSB_PutCol
 ld (ix),d
 inc ix
 pop hl
 ld de,16
 add hl,de
 pop bc
 djnz PMSB_PutRow
 pop iy
 ei
EndMSB:
 pop ix
 pop hl
 pop de
 pop bc
 ret

PutSprite:		 ; BC = x,y  HL = sprite
 push bc
 push de
 push hl
 push ix
 ld a,$FF
 ld (clipmask),a
 bit 7,b
 jr z,PSC_CheckRightClip
 ld a,b
 cp 249
 jr c,EndPPS
 neg
 push bc
 ld b,a
 ld a,$FF
PSC_LeftClip:
 srl a
 djnz PSC_LeftClip
 pop bc
 res 7,b
 dec c
 ld (clipmask),a
 jr PSC_CheckBotClip
PSC_CheckRightClip
 ld a,b
 sub 113
 jr c,PSC_CheckBotClip
 push bc
 ld b,a
 inc b
 ld a,$FF
PSC_RightClip:
 add a,a
 djnz PSC_RightClip
 ld (clipmask),a
 pop bc
PSC_CheckBotClip:
 ld a,8
 ld (rows2put),a
 bit 7,c
 jr nz,PSC_CheckTopClip
 bit 6,c
 jr nz,EndPS
 ld a,64
 sub c
 cp 8
 jr nc,PSC_ClippingDone
 ld (rows2put),a
 jr PSC_ClippingDone
PSC_CheckTopClip:
 ld a,c
 cp 249
EndPPS:
 jr c,EndPS
 push bc
 neg
 ld b,a
 sub 8
 neg
 ld (rows2put),a
PSC_TopClip:
 inc hl
 inc de
 djnz PSC_TopClip
 pop bc
 ld c,0
PSC_ClippingDone:
 push hl
 pop ix
 ld a,(rows2put)
 push af
 call FIND_PIXEL
Modify_6:
 ld de,$FC00
 add hl,de
 ld d,a
 pop bc
PSC_PutRow:
 push bc
 push hl
 ld a,(clipmask)
 ld e,a
 ld b,8
 ld c,(ix)
 inc ix
PSC_PutCol:
 push bc
 rlc e
 jr nc,PSC_NextBit
 ld a,d
 rlc c
 jr c,PSC_BitOn
 cpl
 and (hl)
 ld (hl),a
 jr PSC_NextBit
PSC_BitOn:
 or (hl)
 ld (hl),a
PSC_NextBit:
 rrc d
 jr nc,PSC_SSB
 inc hl
PSC_SSB:
 pop bc
 rlc c
 djnz PSC_PutCol
 pop hl
 ld bc,16
 add hl,bc
 pop bc
 djnz PSC_PutRow
EndPS:
 pop ix
 pop hl
 pop de
 pop bc
 ret

FIND_PIXEL:
 push bc
 push de
 ld hl,ExpTable+1
 ld d,0
 ld a,b
 and $07
 ld e,a
 add hl,de
 ld e,(hl)
 ld h,d
 srl b
 srl b
 srl b
 ld a,c
 add a,a
 add a,a
 ld l,a
 add hl,hl
 add hl,hl
 ld a,e
 ld e,b
 add hl,de
 pop de
 pop bc
 ret

.end
