#include "asm86.h"
#include "ti86asm.inc"

#define OTH_DEL $08
#define SIZE_BUL 50

_getcsc = $4068

.org $d748

     call _runindicoff
     ld a,IT-1
     ld i,a
     im 2

kipDescr:
        ld hl,$0505
        ld (LScore),hl

TheBeginning:
        ld hl,LBullets-8
        ld de,LBullets-7
        ld bc,SIZE_BUL+SIZE_BUL+7
        ld (hl),0
        ldir
        call EmptyKey

        call GetRand
        ld de,$0800
        add hl,de
        ld (LShipPos),hl
        call GetRand
        ld de,$4000
        add hl,de
        ld (RShipPos),hl
        xor a
        ld (LShipRot),a
        ld a,12
        ld (RShipRot),a

        ld hl,$FC00
        ld de,$FC01
        ld bc,$03FF
        ld (hl),c
        ldir
        ld hl,$FC00
        ld de,_plotscreen
        ld bc,$0400
        ldir

Recycle:
        call DrawShips
WaitKey:
        xor a
        ld (CopyToGraph),a
        ld hl,LBullets
        ld b,20
Turnoffloop:
        push bc
        ld a,(hl)
        or a
        jr z,Thisonenot
        push hl
        inc hl
        ld c,(hl)
        inc hl
        ld b,(hl)
        call DoBullet
        pop hl
Thisonenot:
        ld de,5
        add hl,de
        pop bc
        djnz Turnoffloop

        ld hl,(LCUsed)
        ld a,h
        or l
        jr z,Really1
        dec hl
        ld a,h
        or l
        jr z,LGee
        dec hl
LGee:
        ld a,h
        or a
        jp nz,WinRight
Really1:
        ld (LCUsed),hl
        srl l
        srl l
        inc l
        ld c,l
        ld hl,$FFF0
        ld de,-16
        ld b,64
        ld a,00000101b
Loopie1:
        dec c
        jr nz,Really2
        ld a,11110101b
Really2:
        ld (hl),a
        add hl,de
        djnz Loopie1

        ld hl,(RCUsed)
        ld a,h
        or l
        jr z,Really3
        dec hl
        ld a,h
        or l
        jr z,RGee
        dec hl
RGee:
        ld a,h
        or a
        jp nz,WinLeft
Really3:
        ld (RCUsed),hl
        srl l
        srl l
        inc l
        ld c,l
        ld hl,$FC0F
        ld de,$0010
        ld b,64
        ld a,10100000b
Loopie2:
        dec c
        jr nz,Really4
        ld a,10101111b
Really4:
        ld (hl),a
        add hl,de
        djnz Loopie2

        ld hl,LBullets
        ld b,20
Turnonloop:
        push bc
        ld a,(hl)
        or a
        jr z,Thistwonot
        push hl
        inc hl
        ld e,(hl)
        inc hl
        ld d,(hl)
        inc hl
        call LD_HL_MHL
        call AddHlDe
        cp $6F+8
        jr nc,OffScreen
        ld a,l
        cp $3F
        jr nc,OffScreen
        ex de,hl
        pop hl
        push hl
        inc hl
        ld (hl),e
        inc hl
        ld (hl),d
        ld b,d
        ld c,e
        push bc
        call FIND_PIXEL
        ld hl,_plotscreen - $FC00
        add hl,de
        and (hl)
        or a
        call z,SomeoneWon
        pop bc
        call DoBullet
        pop hl
        jr Thistwonot
OffScreen:
        pop hl
        xor a
        ld (hl),a
Thistwonot:
        ld de,$0005
        add hl,de
        pop bc
        djnz Turnonloop

     ld b,$10
     halt
     djnz $-1

     ld a,($c006)
     cp K_EXIT
     jp z,_exit

     ld a,($c001)
     or a
     jp z,WaitKey

        call DrawShips

        ld a,00111111b
        out (1),a
        in a,(1)
        bit 4,a
        jr nz,NoLCloak
        ld a,(LCUsed)
        cp 120
        jr nc,NoLCloak
        call GetRand
        ld a,h
        add a,a
        add a,8
        ld h,a
        ld (LShipPos),hl
        ld hl,(LCUsed)
        ld de,$0080
        add hl,de
        ld (LCUsed),hl
NoLCloak:
        ld a,01110111b
        out (1),a
        in a,(1)
        bit 0,a
        jr nz,NoRCloak
        ld a,(RCUsed)
        cp 120
        jr nc,NoRCloak
        call GetRand
        ld a,h
        add a,a
        add a,8
        ld h,a
        ld (RShipPos),hl
        ld hl,(RCUsed)
        ld de,$0080
        add hl,de
        ld (RCUsed),hl
NoRCloak:
     ld bc,0101111100000001b
        out (c),b
        in b,(c)
        bit 7,b
        call z,KFire
        bit 5,b
        call z,KLefts
        bit 1,b
        call z,KRights

        ld b,01101111b
        out (c),b
        in b,(c)
        bit 3,b
        call z,KUps

        ld b,01111011b
        out (c),b
        in b,(c)
        bit 4,b
        call z,RKUp

        ld b,01111101b
        out (c),b
        in b,(c)
        bit 0,b
        call z,RKFire
        bit 2,b
        call z,RKLeft
        bit 6,b
        call z,RKRight

        jp Recycle

KLefts:
        ld a,(LShipRot)
        inc a
        cp 24
        jr c,KLeftOk
        xor a
KLeftOk:
        ld (LShipRot),a
        ld hl,(LCUsed)
        inc hl
        ld (LCUsed),hl
        ret
KRights:
        ld a,(LShipRot)
        dec a
        cp 24
        jr c,KRightOk
        ld a,23
KRightOk:
        ld (LShipRot),a
        ld hl,(LCUsed)
        inc hl
        ld (LCUsed),hl
        ret
RKLeft:
        ld a,(RShipRot)
        inc a
        cp 24
        jr c,RKLeftOk
        xor a
RKLeftOk:
        ld (RShipRot),a
        ld hl,(RCUsed)
        inc hl
        ld (RCUsed),hl
        ret
RKRight:
        ld a,(RShipRot)
        dec a
        cp 24
        jr c,RKRightOk
        ld a,23
RKRightOk:
        ld (RShipRot),a
        ld hl,(RCUsed)
        inc hl
        ld (RCUsed),hl
        ret
KFire:
     push bc
        ld hl,(LCUsed)
        ld de,$0006
        add hl,de
        ld (LCUsed),hl
        ld a,(LShipRot)
        call GetRot
        push hl
        ld hl,PLFire
        ld a,(LShipRot)
        add a,a
        ld d,0
        ld e,a
        add hl,de
        call LD_HL_MHL
        ld de,(LShipPos)
        add hl,de
        push hl
        ld hl,LBullets
        ld b,10
Searchforfree:
        ld a,(hl)
        or a
        jr z,CommonGround
        ld de,$0005
        add hl,de
        djnz Searchforfree
        pop hl
        pop hl
     pop bc
        ret

RKFire:
     push bc
        ld hl,(RCUsed)
        ld de,$0006
        add hl,de
        ld (RCUsed),hl
        ld a,(RShipRot)
        call GetRot
        push hl
        ld hl,PLFire
        ld a,(RShipRot)
        add a,a
        ld d,0
        ld e,a
        add hl,de
        call LD_HL_MHL
        ld de,(RShipPos)
        add hl,de
        push hl
        ld hl,RBullets
        ld b,10
RSearchforfree:
        ld a,(hl)
        or a
        jr z,CommonGround
        ld de,$0005
        add hl,de
        djnz RSearchforfree
        pop hl
        pop hl
     pop bc
        ret

CommonGround:
        inc a
        ld (hl),a
        inc hl
        pop de
        ld (hl),e
        inc hl
        ld (hl),d
        inc hl
        pop de
        ld (hl),e
        inc hl
        ld (hl),d
        dec hl
        dec hl
        dec hl
        ld c,(hl)
        inc hl
        ld b,(hl)
        xor a
        ld (CopyToGraph),a
        call DoBullet
        pop bc
        ret

KUps:
        ld a,(LShipRot)
        call GetRot
        ex de,hl
        ld hl,(LShipPos)
        call AddHlDe
        cp $08
        jr nc,KUp1
        ld a,$08
KUp1:
        cp $70
        jr c,KUp2
        ld a,$6F
KUp2:
        ld h,a
        ld a,l
        cp $08
        jr nc,KUp3
        ld a,$07
KUp3:
        cp $40
        jr c,KUp4
        ld a,$3F
KUp4:
        ld l,a
        ld (LShipPos),hl
        ld hl,(LCUsed)
        inc hl
        inc hl
        ld (LCUsed),hl
        ret
RKUp:
        ld a,(RShipRot)
        call GetRot
        ex de,hl
        ld hl,(RShipPos)
        call AddHlDe
        cp $08
        jr nc,RKUp1
        ld a,$08
RKUp1:
        cp $70
        jr c,RKUp2
        ld a,$6F
RKUp2:
        ld h,a
        ld a,l
        cp $08
        jr nc,RKUp3
        ld a,$07
RKUp3:
        cp $40
        jr c,RKUp4
        ld a,$3F
RKUp4:
        ld l,a
        ld (RShipPos),hl
        ld hl,(RCUsed)
        inc hl
        inc hl
        ld (RCUsed),hl
        ret
        
WinLeft:
        ld hl,$0000
        ld (RCUsed),hl

        ld hl,$FC0F
        ld de,$0010
        ld b,64
        ld a,10100000b
Loopy2:
        ld (hl),a
        add hl,de
        djnz Loopy2
        call DrawRShip
        ld de,BlowUp
        ld b,6
WLDraw:
        push bc
        push de
        ld bc,(RShipPos)
        call Bitmap
        pop de
        ld hl,$0008
        add hl,de
        ex de,hl
        ld b,OTH_DEL
     halt
     djnz $-1
        pop bc
        djnz WLDraw
        call DrawLShip
        ld hl,RScore
        dec (hl)
        jr MoreCommon

WinRight:
        ld hl,$0000
        ld (LCUsed),hl

        ld hl,$FC00
        ld de,$0010
        ld b,64
        ld a,00000101b
Loopy1:
        ld (hl),a
        add hl,de
        djnz Loopy1
        call DrawLShip
        ld de,BlowUp
        ld b,6
WRDraw:
        push bc
        push de
        ld bc,(LShipPos)
        call Bitmap
        pop de
        ld hl,$0008
        add hl,de
        ex de,hl
        ld b,OTH_DEL
     halt
     djnz $-1
        pop bc
        djnz WRDraw
        call DrawRShip
        ld hl,LScore
        dec (hl)
MoreCommon:
        ld hl,$FC01
        ld b,64
MCLoop2:
        push bc
        ld b,14
MCLoop1:
        xor a
        ld (hl),a
        inc hl
        djnz MCLoop1
        pop bc
        inc hl
        inc hl
        djnz MCLoop2
        ld hl,$1C25
        ld de,SRM
        call MENU_STR
        ld hl,$1610
        ld de,ProgDescr
        call MENU_STR
        ld hl,$0800
        ld (TheIdiot),hl
        ld hl,PL01
        ld (TheStupid),hl
        ex de,hl
        ld hl,$0C1C
        ld a,(LScore)
        ld b,a
        call DispIt
        ld hl,$F800
        ld (TheIdiot),hl
        ld hl,$6C1C
        ld a,(RScore)
        ld b,a
        ld de,(TheStupid)
        call DispIt
        call EmptyKey
        call WAIT_KEY
        ld a,(LScore)
        or a
        jr z,_exit
        ld a,(RScore)
        or a
        jr z,_exit
        jp TheBeginning

_exit:
     im 1
     jp _clrlcd

DispIt:
        or a
        ret z
        push bc
        push hl
        push de
        ld b,h
        ld c,l
        call Bitmap
        pop de
        pop hl
        ld bc,(TheIdiot)
        add hl,bc
        pop bc
        djnz DispIt
        ret

DrawShips:
        call DrawLShip
        jp DrawRShip
DrawLShip:
        ld a,$FF
        ld (CopyToGraph),a
        ld hl,PL00
        ld a,(LShipRot)
        add a,a
        add a,a
        add a,a
        ld d,0
        ld e,a
        add hl,de
        ex de,hl
        ld bc,(LShipPos)
        jp Bitmap
DrawRShip:
        ld a,$FF
        ld (CopyToGraph),a
        ld hl,PL00
        ld a,(RShipRot)
        add a,a
        add a,a
        add a,a
        ld d,0
        ld e,a
        add hl,de
        ex de,hl
        ld bc,(RShipPos)
        jp Bitmap

AddHlDe:
        ld a,l
        add a,e
        ld l,a
        ld a,h
        add a,d
        ld h,a
        ret

;This sprite routine by Andreas Ess
Bitmap:
 xor  a
 ld   (TempByte), a
 push de                   ;save de & bc temporary
 push bc
 call FIND_PIXEL
 ex   de,hl
; ld   de, VIDEO_MEM        ;let it point to the vid-ram
; add  hl, de
 pop  bc                   ;pop de & bc
 pop  de
 ld   c, a
 ld   b, 128               ;b is 128 = bit 7 of bitmap
Loop:
 ld   a, (de)              ;load bitmap-data into a
 and  b                    ;test only one bit
 jr   z, Loop1             ;if bit = zero; erase point
 ld   a, (hl)              ;otherwise, draw point
 xor  c                    ;<< was or c, I changed it
 ld   (hl), a              ;now save this into video-ram
 ld   a,(CopyToGraph)
 or   a
 jr   z,Loop1
 push hl
 push de
 ld de,VIDEO_MEM-_plotscreen
 sbc hl,de
 ld a,(hl)
 xor c
 ld (hl),a
 pop de
 pop hl
Loop1:
 srl  c                    ;and shift the video-mask -> next pixel
 jr   nz, Loop2            ;if mask is zero -> fill 128 into c
 ld   c, 128               ;and use next byte of vid-data
 inc  hl
Loop2:
 srl  b                    ;now shift the bitmap-mask
 jr   nz, Loop             ;if <> zero, loop again
NextLine:
 push de                   ;save de
 ld   de, 15
 add  hl, de               ;add 15 bytes to hl
 pop  de
 inc  de                   ;and increment bitmap-pointer
 ld   b, 128               ;load 128 into bitmap-pointer
 ld   a, (TempByte)        ;TempByte holds line
 inc  a
 ld   (TempByte), a
 cp   8
 jr   nz, Loop             ;if line<8, loop again
 ret

DoBullet:
        ld de,Bullet
        dec b
        inc c
        jp Bitmap

GetRot:
        ld hl,PLMov
        add a,a
        ld d,0
        ld e,a
        add hl,de
        call LD_HL_MHL
        ret

SomeoneWon:
        ld de,-RBullets
        add hl,de
        jr c,AddToGoober
        ld hl,(LCUsed)
        ld de,$0070
        add hl,de
        ld (LCUsed),hl
        ret
AddToGoober:
        ld hl,(RCUsed)
        ld de,$0070
        add hl,de
        ld (RCUsed),hl
        ret

GetRand:
        call GET_RAND
        ld a,h
NOK1:
        cp 48
        jr c,OK1
        sub 48
        jr NOK1
OK1:
        ld h,a
        ld a,l
NOK2:
        cp 56
        jr c,OK2
        sub 56
        jr NOK2
OK2:
        add a,8
        ld l,a
        ret

EmptyKey:
     halt
     ld a,($C001)
     or a
     jr nz,EmptyKey
     ret

PLMov:
.dw $0300,$0301,$0302,$0303,$0203,$0103,$0003,$FF03,$FE03,$FD03
.dw $FD02,$FD01,$FD00,$FDFF,$FDFE,$FDFD,$FEFD,$FFFD,$00FD,$01FD
.dw $02FD,$03FD,$03FE,$03FF

PLFire:
.dw $07FD,$07FD,$0700,$0700,$0601,$0601,$0401,$0001,$0001,$0000
.dw $0000,$00FD,$00FD,$00FC,$00F9,$00F9,$01F8,$00F8,$03F8,$06F8
.dw $06F8,$07F9,$07F9,$07FC

PL00:
.db 00000000b
.db 11000000b
.db 11111000b
.db 11111110b
.db 11111000b
.db 11000000b
.db 00000000b
.db 00000000b

.db 00000000b   ;
.db 00000000b
.db 11100000b
.db 11111110b
.db 11111100b
.db 01110000b
.db 01000000b
.db 00000000b

.db 00000000b   ;
.db 00000110b
.db 00111100b
.db 11111000b
.db 01111000b
.db 01110000b
.db 00100000b
.db 00000000b

.db 00000000b   ;
.db 00000110b
.db 00111100b
.db 11111100b
.db 01111000b
.db 00111000b
.db 00010000b
.db 00000000b

.db 00000010b   ;
.db 00000110b
.db 00001110b
.db 00011110b
.db 00111100b
.db 00011100b
.db 00000100b
.db 00000000b

.db 00000010b   ;
.db 00000110b
.db 00000110b
.db 00001110b
.db 00011110b
.db 00011110b
.db 00111110b
.db 00000110b

PL01:
.db 00001000b   ;
.db 00001000b
.db 00011100b
.db 00011100b
.db 00011100b
.db 00111110b
.db 00111110b
.db 00000000b   ;

.db 01000000b   ;
.db 01100000b
.db 01100000b
.db 01110000b
.db 01111000b
.db 01111000b
.db 01111100b
.db 01100000b

.db 01000000b   ;
.db 01100000b
.db 01110000b
.db 01111000b
.db 00111100b
.db 00111000b
.db 00100000b
.db 00000000b

.db 00000000b   ;
.db 01100000b
.db 00111100b
.db 00111111b
.db 00011110b
.db 00011100b
.db 00001000b
.db 00000000b

.db 00000000b   ;
.db 01100000b
.db 00111100b
.db 00011111b
.db 00011110b
.db 00001110b
.db 00000100b
 .db 00000000b

.db 00000000b   ;
.db 00000000b
.db 00000111b
.db 01111111b
.db 00111111b
.db 00001110b
.db 00000010b
.db 00000000b

.db 00000000b
.db 00000011b
.db 00011111b
.db 01111111b
.db 00011111b
.db 00000011b
.db 00000000b
.db 00000000b

.db 00000000b
.db 00000010b
.db 00001110b
.db 00111111b
.db 01111111b
.db 00000111b
.db 00000000b
.db 00000000b

.db 00000000b
.db 00000100b
.db 00001110b
.db 00011110b
.db 00011111b
.db 00111100b
.db 01100000b
.db 00000000b

.db 00000000b
.db 00001000b
.db 00011100b
.db 00011110b
.db 00111111b
.db 00111100b
.db 01100000b
.db 00000000b

.db 00000000b
.db 00100000b
.db 00111000b
.db 00111100b
.db 01111000b
.db 01110000b
.db 01100000b
.db 01000000b

.db 01100000b
.db 01111100b
.db 01111000b
.db 01111000b
.db 01110000b
.db 01100000b
.db 01100000b
.db 01000000b

.db 00000000b
.db 00111110b
.db 00111110b
.db 00011100b
.db 00011100b
.db 00011100b
.db 00001000b
.db 00001000b

.db 00000110b
.db 00111110b
.db 00011110b
.db 00011110b
.db 00001110b
.db 00000110b
.db 00000110b
.db 00000010b

.db 00000000b
.db 00000100b
.db 00011100b
.db 00111100b
.db 00011110b
.db 00001110b
.db 00000110b
.db 00000010b

.db 00000000b
.db 00010000b
.db 00111000b
.db 01111000b
.db 11111100b
.db 00111100b
.db 00000110b
.db 00000000b

.db 00000000b
.db 00100000b
.db 01110000b
.db 01111000b
.db 11111000b
.db 00111100b
.db 00000110b
.db 00000000b

.db 00000000b
.db 01000000b
.db 01110000b
.db 11111100b
.db 11111110b
.db 11100000b
.db 00000000b
.db 00000000b

BlowUp:
.db 00000000b
.db 00001100b
.db 00111100b
.db 00111110b
.db 01111110b
.db 01111110b
.db 00011110b
.db 00000000b

.db 00001100b
.db 00110010b
.db 01000010b
.db 01000001b
.db 10000001b
.db 10000001b
.db 01100001b
.db 00011110b

.db 00001100b
.db 00110010b
.db 01000010b
.db 01000001b
.db 10000001b
.db 10000001b
.db 01100001b
.db 00011110b

.db 00000000b
.db 00001100b
.db 00110100b
.db 00100010b
.db 01000010b
.db 01100010b
.db 00011110b
.db 00000000b

.db 00000000b
.db 00000000b
.db 00001000b
.db 00010100b
.db 00100100b
.db 00011100b
.db 00000000b
.db 00000000b

.db 00000000b
.db 00000000b
.db 00000000b
.db 00001000b
.db 00011000b
.db 00000000b
.db 00000000b
.db 00000000b

Bullet:
.db 01000000b
.db 11100000b
.db 01000000b
.db 00000000b
.db 00000000b
.db 00000000b
.db 00000000b
.db 00000000b

SRM:
.db "SHIPS REMAINING",0

; these are the ZOS routines

FIND_PIXEL:
     ld a,$3F
     sub c
     ld   c,a

     ld   a,b
     and  $07
     or   FindPixelTable&255
     ld   l,a
     ld   h,FindPixelTable/256
     ld   d,$3F
     ld   a,c
     add  a,a
     add  a,a
     add  a,a
     rl   d
     add  a,a
     rl   d
     srl  b
     srl  b
     srl  b
     or   b
     ld   e,a
     ld   a,(hl)
     ret

WAIT_KEY:
        push hl
WKLoop:
     halt
        call _getcsc
        or a
        jr z,WKLoop
        pop hl
        ret

GET_RAND:
        ld hl,(RNSeed)
        ld a,h
        rlca
        inc a
        xor l
        ld h,a
        ld a,l
        rra
        inc a
        xor h
        ld l,a
        ld (RNSeed),hl
        ret        
RNSeed:
.dw $C581

MENU_STR:
        ld (_penCol),hl
        ex de,hl
        jp D_ZM_STR



ProgDescr:
     .db "SpaceWar 2183 by Kirk Meyer",0

.org (($-1)|7)+1
FindPixelTable:
     .db $80,$40,$20,$10,$08,$04,$02,$01

.org ($-1|255)+1

IT = ($ / 256) + 1
 .db IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT
 .db IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT
 .db IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT
 .db IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT
 .db IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT
 .db IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT
 .db IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT
 .db IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT
 .db IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT
 .db IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT
 .db IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT
 .db IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT
 .db IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT
 .db IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT
 .db IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT
 .db IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT,IT
 .db IT

.org (IT + (IT * 256))
     exx
     ex af,af'
     in a,(3)
     bit 3,a
     jp z,$003A
     and $FE
     out (3),a
     jp $003A

asdf = $ + 256

TempByte       = asdf
LShipRot       = asdf+1
RShipRot       = asdf+2
LShipPos       = asdf+3
RShipPos       = asdf+5

LScore         = asdf+7
RScore         = asdf+8
CopyToGraph    = asdf+9
LCloak         = asdf+11
RCloak         = asdf+12
LCUsed         = asdf+13
RCUsed         = asdf+15
TheStupid      = asdf+17
TheIdiot       = asdf+19

LBullets       = asdf+21
RBullets       = asdf+21+SIZE_BUL

_plotscreen    = asdf+21+SIZE_BUL+SIZE_BUL

.end

