;Falling Snow - Merry X-Mas, Happy new year
; Andreas Ess
; ess.andreas@computerhaus.at
;
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#include "ti-85.h"

SNOWPT = TEXT_MEM        ;256 snow flakes' x/y pos & flag.
SaveA = TEXT_MEM+2
SNOWSET = GRAPH_MEM	 ;is a flake already on bottom

.org 0
.db "SNOW by Andreas Ess",0

Main:
 ;Allocate 512 bytes for star array(thanks to Rob Taylor)

 ld   hl,($8be5)   ;get end of VAT
 dec  hl
 dec  hl           ;make sure we're clear it..
 ld   a,h
 sub  2            ;2*256
 ld   h,a
 ld   l,0
 push hl

 ld   de,($8be1)
 or   a
 sbc  hl,de
 pop  hl
 ld   (SNOWPT), hl
 jr   nc,GoOnProg
 ROM_CALL(CLEARLCD)
 ld   hl, (PROGRAM_ADDR)
 ld   de, ErrorMem
 add  hl, de
 ROM_CALL(D_ZT_STR)
 ret
GoOnProg:
 ld   a, 4
 out  (5), a            ;needed if FIND_PIXEL is used
 CALL_(SetUpSnow)
 ld   hl, VIDEO_MEM
 ld   de, VIDEO_MEM
 inc  de
 ld   (hl), 255
 ld   bc, 1007
 ldir
 set  3, (iy+5)
 ld   hl, 2
 ld   ($800C), hl
 ld   hl, (PROGRAM_ADDR)
 ld   de, Message
 add  hl, de
 ROM_CALL(D_ZT_STR)
 res  3, (iy+5)
;There's a white, vertical line at the end of the text, make it black:
 ld   b, 126
 ld   c, 20
MakeBlack:
 CALL_(ErasePixel)
 inc  c
 ld   a, c
 cp   60
 jr   nz, MakeBlack
 ld   hl, VIDEO_MEM
 ld   de, GRAPH_MEM
 ld   bc, 1007
 ldir
SnowLoop:
 ld   hl, GRAPH_MEM
 ld   de, VIDEO_MEM
 ld   bc, 1008
 ldir
 CALL_(DoSnow)
 CALL_(Delay)
 call GET_KEY
 cp   K_EXIT
 jr   nz, SnowLoop
 ret

SetUpSnow:
 ld    b, 0
 ld    hl, (SNOWPT)
SetUpSnow_Loop:
 ld    a, r            ;Get random number for X-Position
 and   01111111b       ;we only want a number from 0-127
 ld    (hl), a
 inc   hl
 ld    a, r
 and   01111111b       ;a number from 64 - 192
 add   a, 64
 ld    (hl), a
 inc   hl
 djnz SetUpSnow_Loop
 ret

DoSnow:
 ld    b, 0
 ld    hl, (SNOWPT)
DoSnowLoop:
 push  bc
 ld    a, r
 and   00000011b
 cp    3
 jr    nz, Not2
 xor   a
Not2:
 dec   a
 add   a, b
 and   01111111b
 ld    b, a
 ld    (hl), b
 inc   hl
 ld    c, (hl)
 dec   c
 CALL_(TestPixel)
 jr    nz, GoOnLoop
 inc   b
 CALL_(TestPixel)
 jr    nz, GoOnLoop
 dec   b
 dec   b
 CALL_(TestPixel)
 jr    nz, GoOnLoop
 inc   b
 ld    c, (hl)
NewFlake:
 CALL_(SetPixel)
 CALL_(DrawPixel)
 ld    c, 63
GoOnLoop:
 ld    a, c
 and   01111111b
 ld    (hl), a
 ld    c, a
 inc   hl
 CALL_(DrawPixel)
 pop   bc
 djnz  DoSnowLoop
 ret

;These routines work with clipping!

TestPixel:
 ld   a, c
 and  a
 ret  z
 push hl
 push bc
 ROM_CALL(FIND_PIXEL)  ;HL=byte offset in video buffer, A=2^(bit to change)
 ld   de, GRAPH_MEM
 add  hl, de
 and  (hl)
 pop  bc
 pop  hl
 ret

ErasePixel: ;Black pixel
 ld   a, c
 cp   63
 ret  nc
 push hl
 push bc
 ROM_CALL(FIND_PIXEL)  ;HL=byte offset in video buffer, A=2^(bit to change)
 ld   de, VIDEO_MEM
 add  hl, de
 or   (hl)
 ld   (hl), a
 pop  bc
 pop  hl
 ret

SetPixel: ;set pixel on VIDEO_MEM & GRAPH_MEM
 ld   a, c
 cp   63
 ret  nc
 push hl
 push bc
 ROM_CALL(FIND_PIXEL)  ;HL=byte offset in video buffer, A=2^(bit to change)
 ld   de, GRAPH_MEM
 add  hl, de
 xor  255
 and  (hl)
 ld   (hl), a
 pop  bc
 pop  hl
 ret

DrawPixel: ;White pixel
 ld   a, c
 cp   63
 ret  nc
 push hl
 push bc
 ROM_CALL(FIND_PIXEL)  ;HL=byte offset in video buffer, A=2^(bit to change)
 ld   de, VIDEO_MEM
 add  hl, de
 xor  255
 and  (hl)
 ld   (hl), a
 pop  bc
 pop  hl
 ret

;-----------------------------------------------------------------------------
;Delay: waits
;-----------------------------------------------------------------------------
Delay:
 ld bc, $1000
DelayLoop:
 dec bc
 ld a, b
 or c
 jr nz, DelayLoop
 ret

ErrorMem: .db "FAILED TO ALLOC 512B",0
Message:  .db "  A   MERRY   X-MAS  "
	  .db "AND A PRODUCTIVE 1997",0


.end
