;--------------= rom calls =------------

#ifdef TI83
_htimesl        =$4382                  ; hl = h*l
_chkfindsym     =$442A                  ; find var in sym table
_sfontlen       =$4A6C                  ; c = width of char (hl)
#else
_htimesl        =$4276                  ; hl = h*l
_chkfindsym     =$42F1                  ; find var in sym table
_sfontlen       =$4786                  ; c = width of char (hl)
#endif


;-------------= data types =------------

progobj         =$05                    ; program
protprogobj     =$06                    ; protected program


;---------------= ports =---------------

lcdinstport     =$10                    ; lcd driver


#ifdef  slopes
;-------------= slopes vars =-----------

#define curvat          saferam1        ; 2  bytes - location in vat
#define high            curvat+2        ; 2  bytes - high score
#define highptr         high+2          ; 2  bytes - pointer to high score
#define level           highptr+2       ; 2  bytes - pointer to level data
#define leveldata       level+2         ; 96 bytes - decompresses level data
#define row             leveldata+96    ; 1  byte  - level offset
#define col             row+1           ; 1  byte  - skier position
#define score           col+1           ; 2  bytes - score
#define time            score+2         ; 1  byte  - time
#define life            time+1          ; 1  byte  - life
#define flakes          life+1          ; 30 bytes - snow flake coords (y,x)
#define menusize        flakes+30       ; 1  byte  - number of menu items
#define menuitem        menusize+1      ; 1  byte  - highlighted menu item
#define menutop         menuitem+1      ; 1  byte  - menu drawing offset
#define menustart       menutop+1       ; ?  bytes - begining of menu


#else
;-------------= editor vars =-----------

#define curvat          saferam1        ; 2  bytes - location in vat
#define name            curvat+2        ; 25 bytes - level name
#define level           name+25         ; 2  bytes - pointer to level data
#define leveldata       level+2         ; 96 bytes - decompressed level data
#define row             leveldata+96    ; 1  byte  - level offset
#define col             row+1           ; 1  byte  - skier position
#define inputdata       col+1           ; 24 bytes - place to store input
#define itemnum         inputdata+24    ; 1  byte  - item number when editing
#define menusize        itemnum+1       ; 1  byte  - number of menu items
#define menuitem        menusize+1      ; 1  byte  - highlighted menu item
#define menutop         menuitem+1      ; 1  byte  - menu drawing offset
#define menustart       menutop+1       ; ?  bytes - begining of menu
#define menuitem1       menustart       ; 2  bytes - first menu item
#define menuitem2       menuitem1+2     ; 2  bytes - second menu item
#define menuitem3       menuitem2+2     ; 2  bytes - third menu item
#endif
