;
; SIM Community 2000  v2.21
;   written by Kirk Meyer
;   kirkmeyer@bigfoot.com
;

;
; This is intended to help people even though its sparsely commented. It
; illustrates lots of things like how to create recursive routines and draw
; big transparent sprites. Don't steal a bunch of stuff from this without
; giving me credit - this took me literally months to finish. If you want to
; improve something, do and send me the code. If I like it I'll put you in
; the easter egg and release your changes.
;

#include "asm86.h"
#include "ti86asm.inc"
#include "ti86abs.inc"

;$C3EE = onflags

;sc2k.h begin
TheCity = $C9FA
all_of_the_sprites = $8400
all_of_the_titles = $A400
page_x = $FC00

MenuSel_Byte = _textShadow
MenuSel_Word = _textShadow+1
MenuSel_Item = _textShadow+3
Res_SimCount = _textShadow+4
Ind_SimCount = _textShadow+6
Com_SimCount = _textShadow+8
Street_Going = _textShadow+10
Newer_Counts = _textShadow+11
Street_Count = _textShadow+11
Police_Count = _textShadow+13
FireSt_Count = _textShadow+15
Hospit_Count = _textShadow+17
School_Count = _textShadow+19
Librar_Count = _textShadow+21
PowerP_Count = _textShadow+23
Church_Count = _textShadow+25
Airpor_Count = _textShadow+27
Seapor_Count = _textShadow+29
Recrea_Count = _textShadow+31
Res_Total    = _textShadow+33
Ind_Total    = _textShadow+35
Com_Total    = _textShadow+37
Reward_Flags = _textShadow+39
Cheat_Code   = _textShadow+40
Temp_Storage = _textShadow+42
TempStorage  = _textShadow+44
Arco_Count   = _textShadow+46

;stuff that must be saved w/ city
Saved_Start  = _textShadow+48
MapPositionY = _textShadow+48
MapPositionX = _textShadow+49
MapPosition  = _textShadow+48
Total_Money  = _textShadow+50
Preset_Taxes = _textShadow+53
Time_Months  = _textShadow+54
Time_Years   = _textShadow+55
Disast_Going = _textShadow+57
City_Flags   = _textShadow+58
Saved_Finish = _textShadow+60
Loaded_City  = _textShadow+60
Action_Flag  = _textShadow+63
Free_Space   = _textShadow+64
Save_Custom  = _textShadow+164
Save_Stack   = _textShadow+166

Token_Res = 22
Token_Ind = 34
Token_Com = 46

;sc2k.h end

;  x/\
;  /  \
; y\  /
;   \/

;x'=(7-x+y)*width
;y'=(x+y)*height

;x'=(7-x+y)*1
;y'=(x+y)*4*16

;video mem = $FC00 + 7 - x + y + 64x + 64y
;          = 63x + 65y + $FB07 <== this value changed I think

.org _asm_exec_ram

        ld (Save_Stack),sp
        ld hl,($C408)
        ld (Save_Custom),hl
        ld hl,$0000
        ld ($C408),hl
        im 1

        ld a,r
        ld b,a
        ld a,r
        rrca \ rrca \ rrca \ rrca
        xor b
        ld (RandVar),a
        call GetRand
        or %11000000
        ld (Disast_Going),a

        ld a,1
        ld hl,$2C00
        call _SET_ABS_DEST_ADDR
        ld hl,name_graphics-1
        rst 20h
        rst 10h
        jp c,cannot_find
        cp $0C
        jp nz,cannot_find
        ld a,b
        ex de,hl
        call $521D              ;get size into DE, AHL+=2
        call _SET_ABS_SRC_ADDR
        xor a
        ex de,hl
        call _SET_MM_NUM_BYTES
        call _mm_ldir
        call _RAM_PAGE_1
        ld hl,$AC00
        ld de,$8400
Decompress:
        ld a,(hl)
        bit 7,a
        jr z,Compressed
        inc hl
        and 01111111b
        ld b,0
        ld c,a
        ldir
        jr Decompress
Compressed:

        push af
        or 11111100b
        ld b,a
        inc hl
        ld c,(hl)
        inc hl
        pop af
        and 01111100b
        rrca
        rrca
        or a
        jr z,Decompress_End
        push hl
        ld h,d
        ld l,e
        add hl,bc
        inc a
        inc a
        ld b,0
        ld c,a
        ldir
        pop hl
        jr Decompress
Decompress_End:

        call _runindicoff

        ld a,$36
        out (0),a

actually_start_over:
        xor a
        ld (MenuSel_Byte),a
        ld hl,cheat_keys
        ld (Cheat_Code),hl

title_do_over:
        call _clrlcd
        ld hl,title_pic
        ld de,$FC00
        ld bc,349
        ldir
        ld hl,$0103
        ld (_curRow),hl
        ld hl,copyright
        call _puts
        ld hl,$FC00
        ld de,$F600
        ld bc,$0200
        ldir

disp_title:
        call _clrlcd
        ld hl,$2105
        ld (_penCol),hl
        ld hl,website
        call _vputs
        ld hl,menu_x
        ld (MenuSel_Word),hl
        ld a,$2D
        ld (_penRow),a
        ld hl,$FED6
        call Put_Menu
        ld hl,$FE00
        ld de,$F800
        ld bc,$0200
        ldir
title_key:
        call wait_for_key
        cp K_UP
        jr nz,title_up
        ld hl,MenuSel_Byte
        dec (hl)
        ld a,(hl)
        cp 3
        jr c,disp_title
        ld (hl),2
        jr disp_title
title_up:
        cp K_DOWN
        jr nz,title_down
        ld hl,MenuSel_Byte
        inc (hl)
        ld a,(hl)
        cp 3
        jr c,disp_title
        ld (hl),0
        jr disp_title
title_down:
        cp K_SECOND
        jr nz,title_select
        ld a,(MenuSel_Byte)
        cp 1
        jp z,load_game
        jp nc,exitroutine
        jp new_game
title_select:
        cp K_EXIT
        jp z,exitroutine
        ld hl,(Cheat_Code)
        cp (hl)
        jr nz,cheat_false
        inc hl
        ld (Cheat_Code),hl
        ld a,(hl)
        or a
        jr nz,title_key
        jr easter_egg
cheat_false:
        ld hl,cheat_keys
        ld (Cheat_Code),hl
        jr title_key

easter_egg:
        call _clrlcd
        ld hl,easter_0
        call easter_call
        call _clrlcd
        ld hl,easter_1
        call easter_call
        call _clrlcd
        ld hl,$0003
        ld (_curRow),hl
        ld hl,easter_x
        call _puts
        ld hl,$FD80
        ld de,$F780
        ld bc,$0070
        ldir
        ld hl,easter_2
        call easter_call
        
        jp title_do_over

easter_call:
        ld b,(hl)
        inc hl
multiple_strings:
        ld e,(hl)
        inc hl
        ld d,(hl)
        inc hl
        ld (_penCol),de
        call _vputs
        djnz multiple_strings
copy_half:
        ld hl,$FE00
        ld de,$F800
        ld bc,$0200
        ldir
        jp wait_for_key

load_game:
        ld hl,_textShadow
        ld (hl),$00
        ld bc,$00A3
        call fillarea

        ld hl,$0000
        ld (TheCity),hl

        ld hl,search_string
        rst 20h
        ld hl,TheCity+2
        push hl
travel_vars:            ;this could be done much faster; i'll make it faster
                        ;in some future version, I was lazy
                        ;(this finds all the cities to be loaded)
        xor a
        call $514B
        jr c,travel_done
        rst 10h
        ex de,hl
        ld a,b
        ld de,2
        add hl,de
        adc a,0
        call $521D
        push hl
        ld hl,$F2E9
        or a
        sbc hl,de
        pop de
        jr nz,travel_vars
        ld hl,TheCity
        inc (hl)
        pop hl
        ld (hl),a
        inc hl
        ld (hl),e
        inc hl
        ld (hl),d
        inc hl
        push hl
        jr travel_vars
travel_done:
        ld a,(TheCity)
        or a
        jr nz,is_a_city
        ld hl,no_cities_here
        call message_box
        jp title_do_over
is_a_city:
        call _clrlcd
        ld hl,$2A00
        ld (_penCol),hl
        ld hl,load_game_str
        call _vputs

        ld a,(TheCity+1)
        ld c,a
        add a,c
        add a,c
        ld d,0
        ld e,a
        ld hl,TheCity+2
        add hl,de
        ld a,(hl)
        inc hl
        ld c,(hl)
        inc hl
        ld h,(hl)
        ld l,c
;descr
        ld de,Free_Space
        ld c,a
        push hl
        call _GETB_AHL
        ld (_penCol),a
        pop hl
        ld a,c
        call _inc_ptr_ahl
        ld c,a
show_description:
        ld a,c
        push hl
        call _GETB_AHL
        ld (de),a
        pop hl
        ld a,c
        call _inc_ptr_ahl
        ld c,a
        ld a,(de)
        inc de
        or a
        jr nz,show_description
        ld a,c
        call _SET_ABS_SRC_ADDR
        ld a,$30
        ld (_penRow),a
        ld hl,Free_Space
        call _vputs
go_up_or_down:
        call copy_half
        cp K_UP
        jr nz,travel_vars_up
        ld hl,TheCity
        ld c,(hl)
        inc hl
        dec (hl)
        ld a,(hl)
        cp c
        jr c,is_a_city
        dec c
        ld (hl),c
        jr is_a_city
travel_vars_up:
        cp K_DOWN
        jr nz,travel_vars_down
        ld hl,TheCity
        ld c,(hl)
        inc hl
        inc (hl)
        ld a,(hl)
        cp c
        jr c,is_a_city
        ld (hl),$00
        jr is_a_city
travel_vars_down:
        cp K_EXIT
        jp z,disp_title
        cp K_SECOND
        jr nz,go_up_or_down
        xor a
        ld hl,Saved_Finish-Saved_Start
        call _SET_MM_NUM_BYTES
        ld hl,Saved_Start
        call _SET_ABS_DEST_ADDR
        ld a,(_ABS_SRC_ADDR)
        ld hl,(_ABS_SRC_ADDR+1)
        ld (Loaded_City+1),hl
        ld (Loaded_City),a
        call _mm_ldir
        xor a
        ld hl,1024
        call _SET_MM_NUM_BYTES
        ld hl,TheCity
        call _SET_ABS_DEST_ADDR
        call _mm_ldir
        jp already_loaded

new_game:
        ld hl,_textShadow
        ld (hl),$00
        ld bc,$00A5
        call fillarea

get_name_clear:
        ld hl,Free_Space+4
        ld (Free_Space),hl
        ld (hl),$00
        ld hl,$2020
        ld (Free_Space+2),hl
get_name:
        call _clrlcd
        ld hl,$2A00
        ld (_penCol),hl
        ld hl,new_game_str
        call _vputs
        ld hl,$3100
        ld (_penCol),hl
        ld hl,Free_Space+4
        call _vputs
        set 1,(iy+$05)
        set 3,(iy+$05)
        ld a,' '
        call _vputmap
        res 3,(iy+$05)
        res 1,(iy+$05)
get_name_crap:
        call copy_half
        cp K_EXIT
        jp z,disp_title
        cp K_SECOND
        jr z,get_name_done
        cp K_DEL
        jr z,get_name_del
        cp K_CLEAR
        jr z,get_name_clear
        sub K_PLUS
        jr c,get_name_crap
        cp K_GRAPH-K_PLUS
        jr nc,get_name_crap
        ld hl,Key_Translator
        ld d,0
        ld e,a
        add hl,de
        ld c,(hl)
        ld a,c
        or a
        jr z,get_name_crap
        ld a,(Free_Space+2)
        or a
        jr z,get_name_crap
        ld hl,(Free_Space)
        dec hl
        ld a,(hl)
        inc hl
        cp ' '
        jr nz,no_caps
        res 5,c
no_caps:
        ld (hl),c
        inc hl
        ld (Free_Space),hl
        ld (hl),$00
        ld hl,Free_Space+2
        dec (hl)
        jr get_name

get_name_del:
        ld hl,Free_Space+2
        ld a,(hl)
        cp $20
        jr nc,get_name_crap
        inc (hl)
        ld hl,(Free_Space)
        dec hl
        ld (Free_Space),hl
        ld (hl),$00
        jp get_name

get_name_done:
        ld hl,_OP1+1
        ld (hl),$00
        inc hl
        ld de,Free_Space+4
generate_var:
        ld a,(de)
        inc de
        cp ' '
        jr z,generate_var
        or a
        jr z,generate_done
        ld (hl),a
        inc hl
        push hl
        ld hl,_OP1+1
        inc (hl)
        ld a,(hl)
        pop hl
        cp 8
        jr c,generate_var
generate_done:
        ld a,(_OP1+1)
        or a
        jp z,new_game

        rst 10h
        jr c,doesnt_exist

        ld hl,already_exists
        call message_box
        jp title_do_over

doesnt_exist:
        ld a,(Free_Space+2)
        neg
        add a,$21
        ld hl,1039
        ld d,0
        ld e,a
        push de
        add hl,de
        ld a,$3C
        out (0),a
        call _createstrng
        ld a,$36
        out (0),a
        ld a,b
        ex de,hl
        ld de,$0002
        add hl,de
        adc a,0
        call _SET_ABS_DEST_ADDR

        ld a,(_penCol)
        sub 2
        srl a
        neg
        add a,$40
        ld (Free_Space+3),a
        ld hl,$F2E9
        ld (Free_Space+1),hl
        pop hl
        xor a
        ld de,$0003
        add hl,de
        call _SET_MM_NUM_BYTES
        ld hl,Free_Space+1
        call _SET_ABS_SRC_ADDR
        call _mm_ldir
        ld a,(_ABS_DEST_ADDR)
        ld hl,(_ABS_DEST_ADDR+1)
        ld (Loaded_City+1),hl
        ld (Loaded_City),a

        ld hl,page_x
        ld (hl),$00
        ld bc,$03FF
        call fillarea

        call GetRand
        and %00001111
        add a,8
        ld h,a
        ld l,$00
        ld (TempStorage),hl
        ld hl,river_handler
        ld (FillLocal_+1),hl
        call river_filllocal

        ld hl,page_x
        ld de,TheCity
        ld bc,$0400
        ldir

        ld hl,2000
        ld (Time_Years),hl
        ld hl,20000
        ld (Total_Money+1),hl
        ld a,5
        ld (Preset_Taxes),a

        call save_the_game

already_loaded:
        call _RAM_PAGE_1

        ld hl,menu_0
        ld (MenuSel_Word),hl

        jp Something_Changed

enormous:
        ld hl,page_x
        ld (hl),$00
        ld bc,$03FF
        call fillarea

;        ld hl,$09F9
;        ld bc,$0000
        ld hl,$0000
        ld ix,TheCity
displayloop:
        push bc
        ld hl,(MapPosition)
;ancient values as follows
;hl = $0000 + mapposition
;bc = $09F9

;current values as follows
;bc = $0000
;hl = mapposition

;input row,col of city in b,c and map origin row,col of city in h,l
        ld a,b
;        sub h
        neg
        add a,h
        add a,$06
        add a,c
        sub l
        cp $0D
        jp nc,skipitall
        add a,$03
        ld e,a
        ld a,c
        sub l
        add a,b
        sub h
        add a,$08
        cp $17          ;slower / more accurate
;faster / less accurate        cp $11
        jp nc,skipitall
        add a,a
        add a,a
        add a,a
        ld h,0
        ld l,a
        add hl,hl
        add hl,hl
        add hl,hl
        ld d,0
        add hl,de

        ld de,page_x-448
        add hl,de

        push ix
        ld a,(ix)
        and %00111111
        ld de,$FC49
        push hl
        pop ix
        push hl
        ld hl,city_flags+1
        ld c,a
        bit 1,(hl)
        jr z,laura
        cp Token_res+1
        jr c,laura
        ld c,Token_res
        cp Token_ind
        jr c,laura
        ld c,Token_ind
        cp Token_com
        jr c,laura
        ld c,Token_com
laura:
        ld a,c
        bit 5,(hl)
        pop hl
        jr z,go_crap
        or a
        sbc hl,de
        jr nz,go_crap
        add a,a ;*2
        add a,a ;*4
        ld h,0
        ld l,a
        add hl,hl       ;*8
        add hl,hl       ;*16
        add hl,hl       ;*32
        add hl,hl       ;*64
        add hl,hl       ;*128
        ld bc,all_of_the_sprites
        add hl,bc

        push hl
        ld bc,64
        add hl,bc
        pop de          ;de = bitmap            (page 0)
                        ;hl = bitmap + 64       (page 1)

        ld b,32
sprite_invert:          ;here you will see a lot of T-STATE counts, etc.
        ld a,(hl)
        cpl
        ld c,a
        ld a,(de)
        cpl
        and c
        ld c,a
        ld a,(de)
        and (ix)
        or c
        ld (ix),a
        inc hl          ;6
        inc de          ;6
        inc ix          ;?
        ld a,(hl)
        cpl
        ld c,a
        ld a,(de)
        cpl
        and c
        ld c,a
        ld a,(de)
        and (ix)
        or c
        ld (ix),a
        inc hl          ;6
        inc de          ;6
        push bc         ;11
        ld bc,$000F     ;10
        add ix,bc       ;15
        pop bc          ;10
        djnz sprite_invert
        ld hl,City_Flags+1
        res 5,(hl)
        jr go_crapper
go_crap:
        call sprite
go_crapper:
        pop ix

;        halt

skipitall:
        inc ix
        pop bc
        inc c
        ld a,c
        cp $20
        jp c,displayloop
        ld c,$00
        inc b
        ld a,b
        cp $20
        jp c,displayloop

        ret

Something_Changed:
        call tally_it_all

Key_Handler:
        ld hl,City_Flags+1
        set 5,(hl)
        call enormous

        ld hl,City_Flags+1
        res 4,(hl)

Whole_Redraw:
        ld hl,page_x
        call blankit

        xor a
        ld (_penRow),a
        ld hl,page_x
        call Put_Menu
        call Show_Info

        ld hl,page_x
        ld de,$F600
        ld bc,$0400
        ldir \ halt

waitkey:
        bit onInterrupt,(iy+onflags)
        jr z,no_execute

        res onInterrupt,(iy+onflags)
        jp Simulate_It

no_execute:
        ld a,%11111011
        out (1),a
        nop \ nop
        in a,(1)
        bit 1,a
        call z,downroutine        ;3
        bit 3,a
        call z,uproutine          ;9
        ld a,%11101111
        out (1),a
        nop \ nop
        in a,(1)
        bit 3,a
        call z,leftroutine        ;7
        bit 1,a
        call z,rightroutine       ;1

        ld a,%10111111
        out (1),a
        nop \ nop
        in a,(1)
        bit 5,a
        jp z,getmegoin

        ld hl,City_Flags+1
        bit 4,(hl)
        jp nz,Key_Handler

        call _getky

        or a
        jr z,waitkey
        cp K_EXIT
        jr nz,NotExit
        ld a,(MenuSel_Item)
        or a
        jr z,waitkey
        ld (MenuSel_Byte),a
        xor a
        ld (MenuSel_Item),a
        ld hl,menu_0
        ld (MenuSel_Word),hl
        jp Whole_Redraw
NotExit:
        cp K_ALPHA
        jr nz,not_alpha
        ld hl,city_flags+1
        ld a,%00000010
        xor (hl)
        ld (hl),a
        jp key_handler
not_alpha:
        cp K_CLEAR
        jp z,exit_and_save
        cp K_ENTER
        jp z,query_me
        cp K_LEFT
        jp z,rotate_left
        cp K_RIGHT
        jp z,rotate_right
        cp K_DOWN
        jr z,getmedown
        cp K_UP
        jp nz,waitkey

getmeup:
        ld hl,(MenuSel_Word)
        ld c,(hl)
        ld hl,MenuSel_Byte
        dec (hl)
        ld a,(hl)
        cp c
        jp c,Whole_Redraw
        dec c
        ld (hl),c
        jp Whole_Redraw

getmedown:
        ld hl,(MenuSel_Word)
        ld c,(hl)
        ld hl,MenuSel_Byte
        inc (hl)
        ld a,(hl)
        cp c
        jp c,Whole_Redraw
        ld (hl),0
        jp Whole_Redraw

downroutine:                    ;3
        push af
        ld hl,MapPositionY
        inc (hl)
        ld a,(hl)
        cp $20
        jr c,everybody_dance
        ld (hl),$1F
        jr everybody_dance

uproutine:                      ;9
        push af
        ld hl,MapPositionX
        dec (hl)
        ld a,(hl)
        cp $20
        jr c,everybody_dance
        ld (hl),$00
        jr everybody_dance

leftroutine:                    ;7
        push af
        ld hl,MapPositionY
        dec (hl)
        ld a,(hl)
        cp $20
        jr c,everybody_dance
        ld (hl),$00
        jr everybody_dance

rightroutine:                   ;1
        push af
        ld hl,MapPositionX
        inc (hl)
        ld a,(hl)
        cp $20
        jr c,everybody_dance
        ld (hl),$1F
everybody_dance:
        ld hl,City_Flags+1
        set 4,(hl)
        pop af
        ret

getmegoin:
        ld a,(MenuSel_Byte)
        add a,a
        ld hl,(MenuSel_Word)
        ld d,0
        ld e,a
        add hl,de
        inc hl
        inc hl
        ld a,(hl)
        cp $C0
        jp nc,calling_stuff
        ld b,(hl)
        dec hl
        ld c,(hl)
        call getthing_ix
        ld a,(hl)
        and %00111111
        cp c
        jp z,nothing_to_do
        cp $03
        jr c,commonplacer
        cp Token_Res
        jr z,commonplacer
        cp Token_Ind
        jr z,commonplacer
        cp Token_Com
        jr z,commonplacer
        jp nothing_to_do
commonplacer:
        push af
        push hl
        ld a,b
        cp $BE
        jr nc,big_amount
        ld l,b
        ld h,0
        ld d,h
        ld e,l
        add hl,hl
        add hl,hl
        add hl,de
        ex de,hl
        jr small_amount
big_amount:
        ld de,4000
        jr z,small_amount
        ld de,50000
small_amount:
        ld a,(Total_Money)
        cp $80
        jr nc,not_enough_money
        ld hl,(Total_Money+1)
        or a
        sbc hl,de
        sbc a,0
        jr nc,enough_money
not_enough_money:
        pop hl
        pop af
        ld a,$3E
        ld ix,$FD09
        call sprite
        ld hl,$FC00
        ld de,$F600
        ld bc,$0400
        ldir \ halt
        jp Key_Handler
enough_money:
        ld (Total_Money),a
        ld (Total_Money+1),hl
        pop hl
        pop af
        ld a,c
        cp Token_Res
        jr c,skip_the_crap
        call GetRand
        and %00000011
        rrca
        rrca
        add a,c
skip_the_crap:
        ld (hl),a
        cp 15
        jp nz,Something_Changed
        ld hl,(arco_count)
        ld de,500
        or a \ sbc hl,de
        jp c,Something_Changed

        ld hl,TheCity
        ld bc,$0400
eliminate_arcos:
        ld a,(hl)
        cp 15
        jr nz,not_an_arco
        ld (hl),$13
not_an_arco:
        inc hl
        dec bc
        ld a,b
        or c
        jr nz,eliminate_arcos

        call wait_for_release
        ld hl,event_launch
        call message_box
        jp Something_Changed

nothing_to_do:
        ld hl,City_Flags+1
        bit 4,(hl)
        jp z,waitkey
        jp Key_Handler

calling_stuff:
        dec hl
        ld l,(hl)
        ld h,a
Jumper_HL:
        jp (hl)

demolish:
        call getthing_ix
        ld a,(hl)
        and %00111111
        or a
        jr z,nothing_to_do
        cp $04
        jr c,demolishrubble
        cp Token_Res
        jr z,demolishrubble
        cp Token_Ind
        jr z,demolishrubble
        cp Token_Com
        jr z,demolishrubble
        cp $12
        jr nc,test_extra
demolish_failed:
        ld (hl),$01
        jp Something_Changed
demolishrubble:
        ld (hl),$00
        jp Something_Changed
test_extra:
        cp $16
        jr c,nothing_to_do
        jr demolish_failed

Query_Me:
        ld hl,cheat_keys
        ld (Cheat_Code),hl

        call _clrlcd

        ld hl,$0724
        ld (_penCol),hl
        call getthing_ix
        ld a,(hl)
        and %00111111
        ld hl,all_of_the_titles
        push af
        or a
        jr z,skip_lookup
        ld b,a
loop_lookup:
        ld a,(hl)
        inc hl
        or a
        jr nz,loop_lookup
        djnz loop_lookup
skip_lookup:
        call _vputs

        ld hl,$0D24
        ld (_penCol),hl
        pop af
        push af
        ld hl,zoning_0
        cp Token_res
        jr c,go_zoning
        ld hl,zoning_1
        cp Token_ind
        jr c,go_zoning
        ld hl,zoning_2
        cp Token_com
        jr c,go_zoning
        ld hl,zoning_3
go_zoning:
        call _vputs

        ld hl,$1324
        ld (_penCol),hl
        ld hl,population
        call _vputs
        pop af
        push af
        call get_population
        or a
        jr z,not_apply
        xor a
        ld c,5
        call disp_ahl_deci
        jr skip_property
not_apply:
        ld hl,not_apply_str
        call _vputs
skip_property:
        ld hl,$2424
        ld (_penCol),hl
        ld hl,disasters_str
        call _vputs
        ld hl,city_flags+1
        bit 0,(hl)
        ld hl,disasters_yes
        jr z,some_disasters
        ld hl,disasters_no
some_disasters:
        call _vputs

        ld hl,$2E24
        ld (_penCol),hl
        ld hl,population
        call _vputs
        call get_city_pop
        ld c,8
        call disp_ahl_deci

        ld hl,$3424
        ld (_penCol),hl
        ld hl,taxes_0
        call _vputs
        ld a,(Preset_Taxes)
        ld l,a
        xor a
        ld h,a
        ld c,2
        call disp_ahl_deci
        ld a,'%'
        call _vputmap

        ld hl,$3A24
        ld (_penCol),hl
        ld hl,yearly_0
        call _vputs
        call get_money_out
        ld c,5
        call disp_ahl_deci

        pop af
        ld ix,$FC01
        call sprite

        call show_info

        ld hl,$FE20
        ld bc,$000F
        ld (hl),$FF
        call fillarea

        ld hl,$FC00
        ld de,$F600
        ld bc,$0400
        ldir
query_wait:
        call wait_for_key
        cp K_EXIT
        jp z,Key_Handler
        cp K_TAN
        jr nz,darn_it
        ld a,%00000001
        ld hl,city_flags+1
        xor (hl)
        ld (hl),a
        jp Query_Me
darn_it:
        cp K_UP
        jr z,taxes_up
        cp K_DOWN
        jr z,taxes_down
        ld hl,(Cheat_Code)
        cp (hl)
        jr nz,false_cheat
        inc hl
        ld (Cheat_Code),hl
        ld a,(hl)
        or a
        jr nz,query_wait
        ld hl,cheat_menu
        ld a,1
        ld (MenuSel_Item),a
        xor a
        ld (MenuSel_Byte),a
        ld (MenuSel_Word),hl
        jr query_wait
false_cheat:
        ld hl,cheat_keys
        ld (Cheat_Code),hl
        jr query_wait
taxes_up:
        ld hl,Preset_Taxes
        inc (hl)
        ld a,(hl)
        cp 21
        jp c,Query_Me
        ld (hl),20
        jr query_wait
taxes_down:
        ld hl,Preset_Taxes
        dec (hl)
        ld a,(hl)
        cp 21
        jp c,Query_Me
        ld (hl),0
        jr query_wait

getthing_ix:
        ld de,(MapPosition)
        ld a,d
        ld d,0
        add a,a
        add a,a
        add a,a
        ld h,0
        ld l,a
        add hl,hl
        add hl,hl
        add hl,de
        ld de,TheCity
        add hl,de
        ret

get_population:
        ld hl,property_values
        ld d,0
        ld e,a
        add hl,de
        ld a,(hl)
        ld l,a
        cp $FF
        jr nz,gp_not_arco
        ld hl,20000
        jr gp_is_arco
gp_not_arco:
        ld h,0
        add hl,hl
gp_is_arco:
        ld a,l
        ret

menu_zone:
 ld hl,menu_1
open_menu:
 ld a,(MenuSel_Byte)
 ld (MenuSel_Item),a
 xor a
 ld (MenuSel_Byte),a
 ld (MenuSel_Word),hl
 call wait_for_release
 jp Whole_Redraw

menu_serv:
 ld hl,menu_2
 jr open_menu

menu_recr:
 ld a,(city_flags+1)
 and %00000100
 rrca \ rrca
 add a,4
 ld hl,menu_3
 ld (hl),a 
 jr open_menu

get_city_pop:
        xor a
        ld h,a
        ld l,a
        ld (Temp_Storage),a
        ld (TempStorage),hl
        ld hl,TheCity
        ld bc,$0400
count_population:
        ld a,(hl)
        and %00111111
        inc hl
        push hl
        call get_population
        ex de,hl
        ld a,(Temp_Storage)
        ld hl,(TempStorage)
        add hl,de
        adc a,0
        ld (TempStorage),hl
        ld (Temp_Storage),a
        pop hl
        dec bc
        ld a,b
        or c
        jr nz,count_population
        ld a,(Temp_Storage)
        ld hl,(TempStorage)
        ret

fillarea:
        ld d,h
        ld e,l
        inc de
        ldir
        ret

;puts a masked 16x32 sprite given by A at video location HL
sprite:


        add a,a ;*2
        add a,a ;*4
        ld h,0
        ld l,a
        add hl,hl       ;*8
        add hl,hl       ;*16
        add hl,hl       ;*32
        add hl,hl       ;*64
        add hl,hl       ;*128
        ld bc,all_of_the_sprites
        add hl,bc
        push hl
        ld bc,64
        add hl,bc
        pop de          ;de = bitmap            (page 0)
                        ;hl = bitmap + 64       (page 1)

        ld b,32
sprite_loop1:
       .db $DD \ ld a,h
        cp $FC
        jr nc,sprite_loop2
        inc hl          ;6
        inc de          ;6
        inc hl          ;6
        inc de          ;6
        push bc         ;11
        ld bc,$0010     ;10
        add ix,bc       ;15
        pop bc          ;10
        djnz sprite_loop1
sprite_loop2:
        ld a,(de)       ;7
        and (ix)        ;19
        or (hl)        ;7
        ld (ix),a       ;19
        inc hl          ;6
        inc de          ;6
        ld a,(de)       ;7
        and (ix+1)        ;19
        or (hl)        ;7
        ld (ix+1),a       ;19
        inc hl          ;6
        inc de          ;6
        push bc         ;11
        ld bc,$0010     ;10
        add ix,bc       ;15
        pop bc          ;10
        ret c
        djnz sprite_loop1
        ret

rotate_left:
        ld ix,TheCity
        ld de,$1F00
rotate_left_loop:
        push de
        call getthing_ix_2
        ld de,$FC00
        add hl,de
        ld a,(ix)
        ld (hl),a
        pop de
        inc ix
        dec d
        ld a,d
        cp $20
        jr c,rotate_left_loop
        ld d,$1F
        inc e
        ld a,e
        cp $20
        jr c,rotate_left_loop
        ld hl,(MapPosition)
        ld c,h
        ld a,l
        xor $1F
        ld h,a
        ld l,c
        ld (MapPosition),hl
        ld hl,$FC00
        ld de,TheCity
        ld bc,$0400
        ldir
        jp Key_Handler

rotate_right:
        ld ix,TheCity
        ld de,$001F
rotate_right_loop:
        push de
        call getthing_ix_2
        ld de,$FC00
        add hl,de
        ld a,(ix)
        ld (hl),a
        pop de
        inc ix
        inc d
        ld a,d
        cp $20
        jr c,rotate_right_loop
        ld d,$00
        dec e
        ld a,e
        cp $20
        jr c,rotate_right_loop
        ld hl,(MapPosition)
        ld c,l
        ld a,h
        xor $1F
        ld h,c
        ld l,a
        ld (MapPosition),hl
        ld hl,$FC00
        ld de,TheCity
        ld bc,$0400
        ldir
        jp Key_Handler

exit_and_save:
        call save_the_game

exitroutine:
        ld sp,(Save_Stack)
        ld hl,(Save_Custom)
        ld ($C408),hl

        ld a,$3C
        out (0),a
        
        ld hl,TheCity
        ld (hl),$00
        ld bc,$03FF
        call fillarea
        set 0,(iy+$03)          ;since we cleared the graph
                                ;screen, set a flag so that
                                ;everything will graph again

        xor a
        ld ($D6FD),a

        call _clrscrn
        jp _homeup

blankit:
        ld b,64
        ld de,$000d
blankitloop:
        ld (hl),$00
        inc hl
        ld (hl),$00
        inc hl
        ld (hl),$00
        inc hl
        ld (hl),$00
        add hl,de
        djnz BlankitLoop
        ret

disp_ahl_deci:
        push bc
        cp $C0
        jr c,not_negative_deci
        dec hl
        sbc a,0
        cpl
        push af
        ld a,h
        cpl
        ld h,a
        ld a,l
        cpl
        ld l,a
        ld a,'-'
        call _vputmap
        pop af
not_negative_deci:
        ld de,_OP2 - 2
        push hl
        pop ix
        ld l,a
disp_ahl_loop:
        ld b,$18
        ld h,$00
inner_ahl_loop:
        add ix,ix
        adc hl,hl
        ld a,h
        cp $0A
        jr c,continue_ahl_loop
        sub $0A
        ld h,a
        .db $DD \ inc l
continue_ahl_loop:
        djnz inner_ahl_loop
        add a,'0'
        ld (de),a
        dec de
        dec c
        jr nz,disp_ahl_loop

        pop bc
        ld b,c
skip_zeros_deci:
        inc de
        ld a,(de)
        cp '0'
        jr nz,skip_zeros_done
        djnz skip_zeros_deci
skip_zeros_done:
        xor a
        ld (_OP2-1),a
        ex de,hl
        jp _vputs

cannot_find:
        ld hl,exitroutine
        push hl
        ld hl,cannot_find_str
message_box:
        push hl
        ld hl,$FD80
        ld (hl),$FF
        ld bc,31
        call fillarea
        ex de,hl
        ld (hl),$00
        ld bc,16*13-1
        call fillarea
        ex de,hl
        ld (hl),$FF
        ld bc,31
        call fillarea
        pop hl
        ld de,$1A00
        ld (_penCol),de
        call _vputs
        ld de,$2000
        ld (_penCol),de
        call _vputs
        ld hl,$FD80
        ld de,$F780
        ld bc,16*17
        ldir
        jp wait_for_key

show_info:
        ld a,$24
        ld (_penRow),a
        ld a,(City_Flags)
        ld b,7
        ld de,complaint_table
complaint_loop:
        rra
        push af
        jr nc,complaint_none
        pop af
        ex de,hl
        ld a,(hl)
        ld (_penCol),a
        inc hl
        call _vputs
        ld a,(hl)
        ld (_penCol),a
        inc hl
        ld a,$2A
        ld (_penRow),a
        call _vputs
        jr complaint_done
complaint_none:
        ld c,2
complaint_lookup:
        ld a,(de)
        inc de
        or a
        jr nz,complaint_lookup
        dec c
        jr nz,complaint_lookup
        pop af
        djnz complaint_loop
complaint_done:
        ld hl,$3A00
        ld (_penCol),hl
        ld a,(Time_Months)
        add a,a
        add a,a
        ld hl,month_table
        ld d,0
        ld e,a
        add hl,de
        ld b,4
        call _vputsn
        xor a
        ld hl,(Time_Years)
        ld c,4
        call disp_ahl_deci
        ld hl,$3400
        ld (_penCol),hl
        ld a,'$'
        call _vputmap
        ld a,(Total_Money)
        ld hl,(Total_Money+1)
        ld c,6
        jp disp_ahl_deci

Simulate_It:
        ld hl,City_Flags+1
        res 5,(hl)
        call enormous

        ld hl,page_x
        call blankit

        ld a,$3F
        ld ix,page_x+1
        call sprite

        call show_info
 
        ld hl,page_x
        ld de,$F600
        ld bc,$0400
        ldir \ halt

        ld hl,city_flags+1
        bit 0,(hl)
        jp nz,wait_key
        ld a,(Disast_Going)
        dec a
        ld (Disast_Going),a
        jp nz,wait_key
        call GetRand
        or %11000000
        ld (Disast_Going),a
Disaster_Anything:
        call GetRand
        and %00011000
        jr z,No_Earthquake
        and %00001000
        jr z,Disaster_Tornado

        ld b,10
earth_quake:
        push bc
        ld hl,$FC40
        ld de,$F600
        ld bc,$03C0
        ldir
        ld b,$08
wait_wait:
        halt
        djnz wait_wait
        ld hl,$FC00
        ld de,$F600
        ld bc,$03C0
        ldir
        ld b,$08
wait_wait_:
        halt
        djnz wait_wait_
        pop bc
        djnz earth_quake

        ld de,$0400
        ld hl,TheCity
earthquake_set_rubble:
        ld a,(hl)
        cp 4
        jr c,forget_that
        call GetRand
        and %00111111
        cp 60
        jr c,forget_that
        ld (hl),$01
        cp 63
        jr nz,forget_that
        ld (hl),$13
forget_that:
        inc hl
        dec de
        ld a,d
        or e
        jr nz,earthquake_set_rubble        

No_Earthquake:
        call GetRand
        and %00011111
        ld h,a
        call GetRand
        and %00011111
        ld l,a
        ld (MapPosition),hl
        call getthing_ix
        ld (hl),$13
        jp simulate_it
        
Disaster_Tornado:
        call GetRand
        and %00011111
        ld h,a
        call GetRand
        and %00011111
        ld l,a
        ld (MapPosition),hl
        call getthing_ix
        call GetRand
        and %00000111
        rrca \ rrca
        add a,$14
        ld (hl),a
        jp simulate_it

wait_key:
        halt
        halt
        halt
        halt

        bit onInterrupt,(iy+onflags)
        jr z,no_execute_2

        res onInterrupt,(iy+onflags)
        jp Something_Changed

no_execute_2:
        call tally_it_all

        ld hl,TheCity
        ld de,page_x
        ld bc,$0400
        ldir

        ld hl,reward_flags
        bit 3,(hl)
        jp z,no_funkys

        ld de,$0000
funky:
        push de
        ld (TempStorage),de
        call getthing_ix_2
        ld de,page_x
        add hl,de
        ld a,(hl)
        and %00111111
        cp $16
        jr nc,funky_loop
        cp $14
        jr c,other_disasters
        ld de,TheCity-page_x
        add hl,de
        ld c,(hl)
        cp $14
        jr z,funky_monster
        ld (hl),$01
        jr funky_tornado
funky_monster:
        ld (hl),$13
funky_tornado:        
        call GetRand
        and %00000001
        ld hl,(TempStorage)
        ld b,a
        ld a,c
        and %11000000
        rlca \ rlca
        add a,b
        and %00000011
        cp 2
        jr z,funky_2
        jr nc,funky_3
        or a
        jr nz,funky_1
        inc h
        ld a,h
        jr funky_0
funky_1:
        inc l
        ld a,l
        jr funky_0
funky_2:
        dec h
        ld a,h
        jr funky_0
funky_3:
        dec l
        ld a,l
funky_0:
        cp $20
        jr nc,funky_loop
;        ld (MapPosition),hl
        ex de,hl
        push bc
        call getthing_ix_2
        pop bc
        ld de,TheCity
        add hl,de
        ld (hl),c
        jr funky_loop
other_disasters:
        cp $13
        jr nz,funky_loop
        ld a,(hl)
        ld de,TheCity-page_x
        add hl,de
        add a,$40
        ld (hl),a
        and %11000000
        jr z,extinguish
        cp  %10000000
        jr nz,funky_loop
        ld hl,City_Flags
        bit 2,(hl)
        jr nz,bad_fire_dept
        call GetRand
        and %00011000
        jr nz,extinguish
bad_fire_dept:
        ld hl,disaster_handler
        ld (FillLocal_+1),hl
        call FillLocal_All
        jr funky_loop
extinguish:
        ld (hl),$01
funky_loop:
        pop de
        inc e
        ld a,e
        cp $20
        jp c,funky
        ld e,$00
        inc d
        ld a,d
        cp $20
        jp c,funky
        jp Simulate_It

no_funkys:
        ld hl,Time_Months
        inc (hl)
        ld a,(hl)
        cp 12
        jr c,months_okay
        ld (hl),0
        ld hl,(Time_Years)
        inc hl
        ld (Time_Years),hl
months_okay:

        ld a,(Time_Months)
        cp 3
        jr nz,no_trees
        call GetRand
        and %00011111
        ld d,a
        call GetRand
        ld e,a
        and %00011111
        call getthing_ix_2
        ld de,TheCity
        add hl,de
        ld a,(hl)
        cp 2
        jr nc,no_trees
        ld (hl),2
        jp month_complete
no_trees:
        or a
        jr nz,not_january
        call get_money_out
        ld de,(Total_Money+1)
        add hl,de
        adc a,0
        ld (Total_Money+1),hl
        ld hl,Total_Money
        add a,(hl)
        ld (Total_Money),a
        ld hl,(Total_Money+1)
        cp $C0
        jr c,no_debt_jan
        cp $FF
        jr nz,yes_debt_jan
        ld de,$3CB0
        or a \ sbc hl,de
        jp nc,month_complete
yes_debt_jan:
        ld hl,event_debt
        call message_box
        jp actually_start_over
no_debt_jan:
        cp $0F
        jp c,month_complete
        jr nz,yes_wealth_jan
        ld de,$4240
        or a \ sbc hl,de
        jp c,month_complete
yes_wealth_jan:
        ld hl,event_wealth
        call message_box
        ld a,$01
        ld hl,$86A0
        ld (Total_Money),a
        ld (Total_Money+1),hl
        jp month_complete

not_january:
        cp 6
        jp nz,month_complete
        ;it's july - check for rewards
        call get_city_pop
        ld b,h
        ld c,l

        ld hl,reward_flags
        bit 0,(hl)
        jr nz,no_statue
        or a
        jr nz,yes_statue
        ld hl,9999
        or a \ sbc hl,bc
        jr nc,no_statue
yes_statue:
        call find_place
        jr nz,no_civic
        ld (MapPosition),de
        ld (hl),12
        ld hl,reward_statue
        call message_box
        jp Simulate_It
no_statue:

        ld hl,reward_flags
        bit 1,(hl)
        jr nz,no_cityhall
        or a
        jr nz,yes_cityhall
        ld hl,29999
        or a \ sbc hl,bc
        jr nc,no_cityhall
yes_cityhall:
        call find_place
        jr nz,no_civic
        ld (MapPosition),de
        ld (hl),13
        ld hl,reward_cityhall
        call message_box
        jp Simulate_It
no_cityhall:

        ld hl,reward_flags
        bit 2,(hl)
        jr nz,no_civic
        or a
        jr z,no_civic
        cp 2
        jr nc,yes_civic
        ld hl,$7317
        or a \ sbc hl,bc
        jr nc,no_civic
yes_civic:
        call find_place
        jr nz,no_civic
        ld (MapPosition),de
        ld (hl),14
        ld hl,reward_civic
        call message_box
        jp Simulate_It
no_civic:

        ld hl,city_flags+1
        bit 2,(hl)
        jr nz,no_arcos
        ld a,(Temp_Storage)
        ld hl,(TempStorage)
        or a
        jr z,no_arcos
        cp 2
        jr nc,yes_arcos
        ld bc,$D4C0
        or a \ sbc hl,bc
        jr c,no_arcos
yes_arcos:
        ld hl,reward_arcos
        call message_box
        ld hl,city_flags+1
        set 2,(hl)
        ld a,5
        ld (menu_3),a
        jp Simulate_It
no_arcos:

month_complete:

        ld de,$0000
Formulate:
        push de
        ld (TempStorage),de
        call getthing_ix_2
        ld de,page_x
        add hl,de
        ex de,hl
        ld a,(de)
        and %00111111
        cp Token_res
        jp c,FormulateLoop

        call GetRand
        and %00001100
        jp nz,FormulateLoop

        ld b,d
        ld c,e

        ld hl,City_Flags
        bit 0,(hl)
        jp nz,zone_minus

        push bc
        call GetRand
        and %00011111
        ld c,a
        ld a,(Preset_Taxes)
        cp c
        pop bc
        jp nc,zone_minus

        ld a,(de)
        and %11000000
        rlca
        rlca
        ld (Street_Going),a

        ld hl,$0000
        ld (Res_SimCount),hl
        ld (Ind_SimCount),hl
        ld (Com_SimCount),hl

        ld hl,zone_handler
        ld (FillLocal_+1),hl
        
        push de
        call Street_Going_To
        pop bc
        ld a,(bc)
        and %00111111
        call do_a_mod_12
        ld d,0
        ld e,a
        ld hl,(Res_SimCount)
        call $403C
        jr c,cant_get_around
        ld hl,(Ind_SimCount)
        call $403C
        jr c,cant_get_around
        ld hl,(Com_SimCount)
        call $403C
        jr c,cant_get_around
        jr transport_good
cant_get_around:
        ld hl,TheCity-page_x
        add hl,bc
        ld a,(hl)
        add a,$40
        ld (hl),a
        and %11000000
        jr nz,FormulateLoop
        jr zone_minus
transport_good:
        ld a,(bc)
        and %00111111
        call do_a_mod_12
        call Jumper_HL
        ld a,(Action_Flag)
        cp 1
        jr z,FormulateLoop
        jr c,zone_minus
        ld a,(bc)
        and %00111111
        call do_a_mod_12
        cp 11
        jr z,FormulateLoop
        ld hl,TheCity-page_x
        add hl,bc
        ld a,(hl)
        inc a
        ld (hl),a
        jr FormulateLoop
zone_minus:
        ld a,(bc)
        and %00111111
        call do_a_mod_12
        or a
        jr z,FormulateLoop
        ld hl,TheCity-page_x
        add hl,bc
        ld a,(hl)
        dec a
        ld (hl),a
FormulateLoop:
        pop de
        inc e
        ld a,e
        cp $20
        jp c,Formulate
        ld e,$00
        inc d
        ld a,d
        cp $20
        jp c,Formulate
        jp Simulate_It

zone_to_res:
        ld de,(City_Flags)
        ld hl,Action_Flag

        ld (hl),1
        bit 7,d
        ret nz

        ld (hl),0
        ld a,e
        and %01111000
        ret nz

        ld (hl),2
        bit 7,e
        ret z
        ld (hl),0
        ld hl,TheCity-page_x
        add hl,bc
        ld a,(hl)
        and %00111111
        cp Token_Res
        ret nz
        ld (hl),$0B
        ld hl,City_Flags
        res 7,(hl)
        ret

zone_to_ind:
        ld de,(City_Flags)
        ld hl,Action_Flag

        ld (hl),1
        bit 7,d
        ret z

        ld (hl),0
        bit 2,e
        ret nz

        ld (hl),2
        ret

zone_to_com:
        ld de,(City_Flags)
        ld hl,Action_Flag

        ld (hl),1
        bit 7,d
        ret z

        ld (hl),0
        bit 1,e
        ret nz

        ld (hl),2
        ret

zoned_res_:
        ld a,(de)
        and %00111111
        call do_a_mod_12
        ld hl,(Res_Total)
        ld b,0
        ld c,a
        add hl,bc
        ld (Res_Total),hl
        ret
zoned_ind_:
        ld a,(de)
        and %00111111
        call do_a_mod_12
        ld hl,(Ind_Total)
        ld b,0
        ld c,a
        add hl,bc
        ld (Ind_Total),hl
        ret
zoned_com_:
        ld a,(de)
        and %00111111
        call do_a_mod_12
        ld hl,(Com_Total)
        ld b,0
        ld c,a
        add hl,bc
        ld (Com_Total),hl
        ret
emptyland_:
;        ld a,r
;        or a
;        ret nz
;        ld hl,TheCity-page_x
;        add hl,de
;        ld (hl),2
        ret
street_:
        ld hl,(Street_Count)
        inc hl
        ld (Street_Count),hl
        ret
powerplant_:
        ld hl,(PowerP_Count)
        inc hl
        inc hl
        ld (PowerP_Count),hl
        ret
police_:
        ld hl,(Police_Count)
        inc hl
        ld (Police_Count),hl
        ret
firedept_:
        ld hl,(FireSt_Count)
        inc hl
        ld (FireSt_Count),hl
        ret
hospital_:
        ld hl,(Hospit_Count)
        inc hl
        ld (Hospit_Count),hl
        ret
school_:
        ld hl,(School_Count)
        inc hl
        ld (School_Count),hl
        ret
park_:
        ld hl,(Recrea_Count)
        inc hl
        inc hl
        inc hl
        inc hl
        ld (Recrea_Count),hl
        ret
library_:
        ld hl,(Librar_Count)
        inc hl
        inc hl
        ld (Librar_Count),hl
        ret
statue_:
        ld hl,reward_flags
        set 0,(hl)
        ret
cityhall_:
        ld hl,reward_flags
        set 1,(hl)
        ret
civic_:
        ld hl,reward_flags
        set 2,(hl)
        ret
arcology_:
        ld hl,(Arco_Count)
        inc hl
        ld (Arco_Count),hl
        ret
airport_:
        ld hl,(Airpor_Count)
        inc hl
        ld (Airpor_Count),hl
        ret
seaport_:
        ld hl,(Seapor_Count)
        inc hl
        ld (Seapor_Count),hl
        ret
church_:
        ld hl,(Church_Count)
        inc hl
        ld (Church_Count),hl
        ret
disaster_:
        ld hl,reward_flags
        set 3,(hl)
        ret

zone_handler:
        ld a,(hl)
        and %00111111
        cp Token_com
        jr c,zone_commie
        sub Token_com
        ld hl,(Com_SimCount)
        ld d,0
        ld e,a
        add hl,de
        ld (Com_SimCount),hl
        ret
zone_commie:
        cp Token_ind
        jr c,zone_indies
        sub Token_ind
        ld hl,(Ind_SimCount)
        ld d,0
        ld e,a
        add hl,de
        ld (Ind_SimCount),hl
        ret
zone_indies:
        cp Token_res
        jr c,zone_ressie
        ld hl,(Res_SimCount)
        ld d,0
        ld e,a
        add hl,de
        ld (Res_SimCount),hl
        ret
zone_ressie:
        cp 4
        ret nz
        ld a,(Street_Going)
        sub c
        and %00000010
        ret nz
        ld (Temp_Storage),de
        ld hl,City_Flags+1
        set 6,(hl)
        ret

disaster_handler:
        ld a,(hl)
        cp $02
        ret c
        cp $03
        ret z
        cp $16
        jr nc,disaster_okay
        cp $12
        ret nc
disaster_okay:
        ld de,TheCity-page_x
        add hl,de
        ld (hl),$13
        ret

SimulateTable:
        .dw emptyland_
        .dw emptyland_
        .dw emptyland_
        .dw emptyland_
        .dw street_
        .dw powerplant_
        .dw police_
        .dw firedept_
        .dw hospital_
        .dw school_
        .dw park_
        .dw church_
        .dw statue_
        .dw cityhall_
        .dw civic_
        .dw arcology_
        .dw airport_
        .dw seaport_
        .dw library_
        .dw disaster_
        .dw disaster_
        .dw disaster_
        .dw zoned_res_
        .dw zoned_res_
        .dw zoned_res_
        .dw zoned_res_
        .dw zoned_res_
        .dw zoned_res_
        .dw zoned_res_
        .dw zoned_res_
        .dw zoned_res_
        .dw zoned_res_
        .dw zoned_res_
        .dw zoned_res_
        .dw zoned_ind_
        .dw zoned_ind_
        .dw zoned_ind_
        .dw zoned_ind_
        .dw zoned_ind_
        .dw zoned_ind_
        .dw zoned_ind_
        .dw zoned_ind_
        .dw zoned_ind_
        .dw zoned_ind_
        .dw zoned_ind_
        .dw zoned_ind_
        .dw zoned_com_
        .dw zoned_com_
        .dw zoned_com_
        .dw zoned_com_
        .dw zoned_com_
        .dw zoned_com_
        .dw zoned_com_
        .dw zoned_com_
        .dw zoned_com_
        .dw zoned_com_
        .dw zoned_com_
        .dw zoned_com_

Street_Going_To:
        ld hl,City_Flags+1
        res 6,(hl)
        call FillLocal_All
        ld hl,City_Flags+1
        bit 6,(hl)
        ret z
        ld hl,(Temp_Storage)
        ld (TempStorage),hl
        jr Street_Going_To

river_handler:
        ld (hl),$03
        ld a,c
        cp 2
        ret nz
        call GetRand
        and %00000111
        cp 3
        jr c,river_continue
        sub 5
        add a,d
        ld d,a
river_continue:
        ld (TempStorage),de

river_filllocal:
        ld de,(TempStorage)
        call getthing_ix_2
        ld de,page_x
        add hl,de
        ld (hl),$03

FillLocal_All:
        call FillLocal_1
        call FillLocal_2
        call FillLocal_3

FillLocal_4:
        ld hl,(TempStorage)
        ld a,l
        inc a
        cp $20
        ret nc
        ld d,h
        ld e,a
        call getthing_ix_2
        ld bc,page_x
        add hl,bc
        ld c,2
FillLocal_:
        jp $0000
FillLocal_1:
        ld hl,(TempStorage)
        ld a,h
        dec a
        cp $20
        ret nc
        ld d,a
        ld e,l
        call getthing_ix_2
        ld bc,page_x
        add hl,bc
        ld c,1
        jp FillLocal_
FillLocal_2:
        ld hl,(TempStorage)
        ld a,h
        inc a
        cp $20
        ret nc
        ld d,a
        ld e,l
        call getthing_ix_2
        ld bc,page_x
        add hl,bc
        ld c,3
        jp FillLocal_
FillLocal_3:
        ld hl,(TempStorage)
        ld a,l
        dec a
        cp $20
        ret nc
        ld d,h
        ld e,a
        call getthing_ix_2
        ld bc,page_x
        add hl,bc
        ld c,0
        jp FillLocal_

get_money_out:
        ld hl,(Res_Total)
        ld de,(Ind_Total)
        ld bc,(Com_Total)
        add hl,de
        add hl,bc
        ld d,h
        ld e,l
        ld hl,0
        ld a,(Preset_Taxes)
        or a
        jr z,no_new_taxes
        ld b,a
some_taxes:
        add hl,de
        djnz some_taxes
no_new_taxes:
        push hl
        ld hl,(Police_Count)
        ld de,(FireSt_Count)
        add hl,de
        ld de,(Hospit_Count)
        add hl,de
        add hl,hl               ;256 ^
        ld de,(School_Count)
        add hl,de
        add hl,hl               ;128 ^
        ld de,(Librar_Count)
        add hl,de
        add hl,hl               ;64  ^
        ld de,(Recrea_Count)
        add hl,de
        add hl,hl               ;32  ^
        add hl,hl               ;16  ^
        add hl,hl               ;8   ^
        add hl,hl               ;4   ^
        ld de,(Street_Count)
        add hl,de
        add hl,hl               ;2   ^
        ex de,hl
        pop hl
        xor a
        sbc hl,de
        sbc a,0
        ret

getthing_ix_2:
        ld a,d
        ld b,0
        ld c,e
        add a,a
        add a,a
        add a,a
        ld h,0
        ld l,a
        add hl,hl
        add hl,hl
        add hl,bc
        ret

do_a_mod_12:
        ld hl,zone_to_res
        sub Token_res
        cp 12
        ret c
        ld hl,zone_to_ind
        sub 12
        cp 12
        ret c
        ld hl,zone_to_com
        sub 12
        ret

Cheat_Money:
        ld a,(Total_Money)
        ld hl,(Total_Money+1)
        ld de,10000
        add hl,de
        adc a,0
        cp $C0
        jr nc,Cheat_Money_Okay
        cp $0F
        jr c,Cheat_Money_Okay
        push hl
        ld de,$4240
        or a \ sbc hl,de
        pop hl
        jr c,Cheat_money_Okay
        call wait_for_release
        ld hl,event_imbecile
        call message_box
        jp actually_start_over
Cheat_Money_Okay:
        ld (Total_Money),a
        ld (Total_Money+1),hl
        jp Whole_Redraw

Put_Menu:
        push hl
        ld hl,(MenuSel_Word)
        ld b,(hl)
        ld de,11
        add hl,de
display_menu:
        ld a,(hl)
        ld (_penCol),a
        inc hl
        call _vputs
        ld de,_penRow
        ld a,(de)
        add a,6
        ld (de),a
        djnz display_menu

        ld a,(MenuSel_Byte)
        ld c,a
        add a,a
        add a,c
        add a,a
        add a,a
        add a,a
        add a,a
        ld h,0
        ld l,a
        add hl,hl
        pop de
        add hl,de

        ld de,$000D
        ld b,7
InvertLoop:
        ld a,(hl)
        cpl
        ld (hl),a
        inc hl
        ld a,(hl)
        cpl
        ld (hl),a
        inc hl
        ld a,(hl)
        cpl
        ld (hl),a
        inc hl
        ld a,(hl)
        cpl
        ld (hl),a
        add hl,de
        djnz InvertLoop
        ret

wait_for_key:
        halt
        call _getky
        or a
        jr z,wait_for_key
        ret

wait_for_release:
 halt
 ld a,%10111111
 out (1),a
 nop \ nop
 in a,(1)
 bit 5,a
 jr z,wait_for_release
 ret

find_place:
        ld hl,TheCity
        ld de,$0000
find_place_loop:
        ld a,(hl)
        cp Token_com
        ret z
        inc hl
        inc e
        ld a,e
        cp $20
        jr c,find_place_loop
        ld e,$00
        inc d
        ld a,d
        cp $20
        jr c,find_place_loop
        or a
        ret

tally_it_all:
        ld hl,Newer_Counts
        ld (hl),$00
        ld bc,30
        call FillArea

        ld hl,$0400
        ld de,TheCity
tally_loop:
        push hl
        ld a,(de)
        and %00111111
        add a,a
        ld hl,SimulateTable
        ld b,0
        ld c,a
        add hl,bc
        ld a,(hl)
        inc hl
        ld h,(hl)
        ld l,a
        call Jumper_HL
        pop hl
        inc de
        dec hl
        ld a,h
        or l
        jr nz,tally_loop

        ld hl,City_Flags+1
        res 7,(hl)
        ld hl,(Com_Total)
        ld de,(Ind_Total)
        add hl,de
        ld de,(Res_Total)
        push de
        call $403C
        jr nc,flags_0
        ld hl,City_Flags+1
        set 7,(hl)
flags_0:
        pop de
        ld e,d
        ld d,0

        inc e
        ld hl,(PowerP_Count)
        call $403C
        ld hl,City_Flags
        rr (hl)
        dec e

        ld hl,(Police_Count)
        call $403C
        ld hl,City_Flags
        rr (hl)

        ld hl,(FireSt_Count)
        call $403C
        ld hl,City_Flags
        rr (hl)

        ld hl,(Hospit_Count)
        call $403C
        ld hl,City_Flags
        rr (hl)

        ld hl,(School_Count)
        call $403C
        ld hl,City_Flags
        rr (hl)

        ld hl,(Librar_Count)
        call $403C
        ld hl,City_Flags
        rr (hl)

        ld hl,(Recrea_Count)
        call $403C
        ld hl,City_Flags
        rr (hl)

        inc e
        ld hl,(Church_Count)
        call $403C
        ld hl,City_Flags
        rr (hl)
        ret

save_the_game:
        ld a,(Loaded_City)
        ld hl,(Loaded_City+1)
        call _SET_ABS_DEST_ADDR
        xor a
        ld hl,Saved_Finish-Saved_Start
        call _SET_MM_NUM_BYTES
        ld hl,Saved_Start
        call _SET_ABS_SRC_ADDR
        call _mm_ldir
        xor a
        ld hl,1024
        call _SET_MM_NUM_BYTES
        ld hl,TheCity
        call _SET_ABS_SRC_ADDR
        call _mm_ldir
        ret

GetRand:
        ld a,(randvar)
        ld b,a
        add a,a
        add a,a
        add a,b
        add a,a
        add a,a
        add a,b
        rrca
        inc a
        ld (randvar),a
        ret

menu_x:
 .db 3
name_graphics:
 .db 8,"sc2k_LIB"
RandVar:
 .db 0
 .db 50,"New City",0
 .db 49,"Load City",0
 .db 58,"Exit",0

website:
 .db "http://simcommunity"		;use http://www.bigfoot.com/~kirkmeyer to make sure you get through
 .db ".home.ml.org",0			;this address could stop working soon

title_pic:
.db 255,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,255
.db 255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,252,15
.db 140,31,7,192,0,0,0,0,0,0,0,0,0,0,248,3,140
.db 31,7,192,224,0,0,0,0,0,0,4,32,0,240,3,140,14
.db 7,195,32,0,0,0,0,0,0,4,32,0,241,225,140,78,71
.db 194,32,4,0,16,0,16,16,0,32,0,241,241,140,78,71,196
.db 1,196,33,16,132,16,16,133,255,4,240,127,140,78,71,200,3
.db 68,99,17,140,16,17,132,33,6,248,15,140,68,71,200,4,38
.db 99,25,140,32,18,132,32,136,252,3,140,100,199,200,4,34,165
.db 10,148,34,18,132,32,136,255,193,140,100,199,200,8,34,165,10
.db 148,38,20,132,32,144,241,241,140,100,199,200,8,35,41,12,164
.db 38,20,132,32,176,240,241,140,96,199,200,72,35,41,12,164,74
.db 24,132,32,160,248,1,140,113,199,200,136,67,49,76,197,82,152
.db 228,32,64,248,3,140,113,199,199,5,130,33,136,134,115,16,4
.db 32,64,254,7,140,113,199,198,2,0,32,0,128,32,16,4,32
.db 128,255,255,255,255,255,192,0,0,0,0,0,0,0,4,65,0
.db 255,255,255,255,255,192,28,0,28,0,28,0,28,0,1,0,0
.db 0,0,0,0,0,4,0,20,0,20,0,20,0,2,0,255,255
.db 255,255,255,255,221,255,213,255,213,255,213,255,254,0,0,0,0
.db 0,0,0,16,0,20,0,20,0,20,0,0,0,0,0,0,0
.db 0,0,28,0,28,0,28,0,28

copyright:
.db "(C) 1998 Kirk Meyer",0

new_game_str:
.db "Please give a name "
.db "for your city:",0

load_game_str:
.db "Choose a city to "
.db "load (",6,'/',7,"):",0

already_exists:
.db "That city or one with "
.db "a similar name",0
.db "already exists on "
.db "this calculator.",0

no_cities_here:
.db "There are not any "
.db "cities on this",0
.db "calculator that "
.db "can be loaded.",0

cannot_find_str:
.db "Cannot find the string "
.db "called ",39,"sc2k_LIB",39,0
.db "which is required in "
.db "order to continue.",0

reward_statue:
.db "Your citizens love "
.db "you so much that",0
.db "they built a statue "
.db "in your honor!",0

reward_cityhall:
.db "Your citizens have "
.db "raised funds to",0
.db "give your community"
.db " a city hall!",0

reward_civic:
.db "Your citizens have "
.db "raised funds to",0
.db "create a large "
.db "civic center!",0

reward_arcos:
.db "By popular vote, "
.db "your citizens now",0
.db "allow you to build "
.db "arcologies at will.",0

event_debt:
.db "You are so far "
.db "into debt that your ",0
.db "sims relieve you "
.db "of your duties.",0
event_wealth:
.db "Your bank has shut "
.db "down. The",0
.db "FDIC insures you "
.db "for $100000.",0
event_launch:
.db "The sims in your arcos "
.db "have decided to",0
.db "explore new frontiers "
.db "in space.",0
event_imbecile:
.db "Your embezzling has "
.db "caught up with",0
.db "you. You are relieved "
.db "of your duties.",0

easter_0:
 .db 4
 .dw $2325 \ .db "PROGRAMMED BY",0
 .dw $292D \ .db "Kirk Meyer",0
 .dw $3422 \ .db "CHIEF BETA TESTER",0
 .dw $3A29 \ .db "Adam Morgan",0

easter_1:
 .db 3
 .dw $2621 \ .db "GRAPHICS & DESIGN",0
 .dw $2C2D \ .db "Kirk Meyer",0
 .dw $3228 \ .db "John Tompkins",0

easter_x:
 .db "THE BETA TESTING TEAM",0

easter_2:
 .db 10
 .dw $200D \ .db "Ricci Adams",0
 .dw $260C \ .db "Keith Batten",0
 .dw $2C00 \ .db "Caymran Cummings",0
 .dw $3207 \ .db "Ahmed El-Helw",0
 .dw $380B \ .db "Dan Koester",0
 .dw $2048 \ .db "Bryan Rabeler",0
 .dw $2646 \ .db "Nicolas Schmitt",0
 .dw $2C4D \ .db "Brian Smith",0
 .dw $3248 \ .db "John Tompkins",0
 .dw $3850 \ .db "Alex Tran",0

menu_0:
 .db 5
 .dw demolish
 .db 4,2
 .dw menu_zone
 .dw menu_serv
 .dw menu_recr
 .db 1,"Demolish",0
 .db 5,"Street",0
 .db 7,"Zones",0
 .db 2,"Services",0
 .db 9,"Rec.",0

menu_1:
 .db 5
 .db Token_res,1
 .db Token_ind,1
 .db Token_com,1
 .db 17,30
 .db 16,50
 .db 10,"Res.",0
 .db 10,"Ind.",0
 .db 8,"Com.",0
 .db 3,"Seaport",0
 .db 4,"Airport",0

menu_2:
 .db 5
 .db 5,$BE
 .db 6,100
 .db 7,100
 .db 8,100
 .db 9,50
 .db 5,"Power",0
 .db 6,"Police",0
 .db 9,"Fire",0
 .db 3,"Hospital",0
 .db 5,"School",0

menu_3:
 .db 0
 .db 2,1
 .db 3,15
 .db 10,50
 .db 18,100
 .db 15,$BF
 .db 7,"Trees",0
 .db 6,"Water",0
 .db 8,"Park",0
 .db 3,"Library",0
 .db 1,"Arcology",0

cheat_menu:
 .db 5
 .dw Cheat_Money
 .dw Disaster_Anything
 .db 12,0
 .db 13,0
 .db 14,0
 .db 2,"Imbecile",0     ;sounds like embezzle, and if you hold 2nd down too
                        ;long on this menu option you really are an imbecile!
 .db 3,"Disaster",0     ;humm i couldn't come up with a creative name...
 .db 1,"Ego Boost",0    ;wouldn't it be cool to have a statue of yourself?
 .db 6,"Laura",0        ;i think the city hall is the best building and
                        ;therefore by analogy...
 .db 6,"Party!",0       ;hehe what else would a civic center be used for? ;)

search_string:
.db 12,0

cheat_keys:
 .db K_7,K_LOG,K_7,K_RAISE,K_LOG,K_9,0          ;LALEAN

Key_Translator:
.db  "xtoje",$00,$00
.db " wsnid",39,$00
.db "zvrmhc",$00,$00
.db "yuqlgb",$00,$00
.db $00,$00,"pkfa"

month_table:
        .db "Jan "
        .db "Feb "
        .db "Mar "
        .db "Apr "
        .db "May "
        .db "Jun "
        .db "Jul "
        .db "Aug "
        .db "Sep "
        .db "Oct "
        .db "Nov "
        .db "Dec "

complaint_table:
        .db 2,"citywide",0
        .db 1,"blackout",0
        .db 6,"crime",0
        .db 7,"rising",0
        .db 3,"too few",0
        .db 2,"firemen",0
        .db 4,"disease",0
        .db 2,"rampant",0
        .db 1,"Jake can",0
        .db 2,"not read",0
        .db 8,"book",0
        .db 1,"shortage",0
        .db 2,"wildlife",0
        .db 3,"in yards",0

zoning_0:
 .db "not zoned",0
zoning_1:
 .db "zoned residential",0
zoning_2:
 .db "zoned industrial",0
zoning_3:
 .db "zoned commercial",0

population:
 .db "population: ",0

value_0:
        .db "city value: $",0
taxes_0:
        .db "taxes (",6,'/',7,"): ",0
yearly_0:
        .db "annual income: $",0
not_apply_str:
        .db "N/A",0

disasters_str:
        .db "[D]isasters: ",0
disasters_yes:
        .db "yes",0
disasters_no:
        .db "no",0

property_values:
 .db 0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,255
 .db 0,0,0,0,0,0

 .db 0
 .db 25,12,3,2
 .db 25,10,5
 .db 200,100,50
 .db 250

 .db 0
 .db 1,5,10,3,2,4
 .db 8,7,25,100,150

 .db 0
 .db 1,2,10,8,3,9
 .db 50,5,1,75,200

.end
