#include "ti86.inc"
#include "ti86asm.inc"


;StuntCopter 86 y2k [1]
;--------------------
;By Justin TerAvest
;base16@crosswinds.net
;http://www.crosswinds.net/~base16
; -Z80 Assembly coders
; -http://www.zed80asm.org
;
;Lines that are commented out have recently been removed
;or are sections of the program that are not yet
;implemented and are not recommended for use.
;
;(C) Copyright 1999 Justin TerAvest
;
;Portions of this code are used by permission from other
;programmers. Such portions are copyright the respective
;programmers. If you want to use any of the code in this
;program, please contact the programmer.
;
;Have a nice day! =)
;
;WARNING! This program is still in beta stages and it may
;cause a fault in the environment that it is run under.
;The programmer takes no responsibility for any damage
;done by the source, its resulting program, or any of the
;files that may be included with this program.

.org $D748

clipmask = _textShadow	;[1] used by sprite routine
rows2put = _textShadow + 1 ;[1] "
bitmask = _textShadow + 2 ;[1] current sprite
manx = _textShadow + 3 ;[1] x-location of the little guy =)
many = _textShadow + 4 ;[1] y-location of the little guy
oldmanx = _textShadow + 5 ;[1] old x location of the little guy
oldmany = _textShadow + 6 ;[1] old y location of the little guy
horse = _textShadow + 7 ;[1] x-location of the horse
time = _textShadow + 8 ;[1] used for delaying the horse
timemax = _textShadow + 9 ;[1] used for delaying the horse
points = _textShadow + 10 ;[2] points
movebyte = _textShadow + 12 ;[1] has the copter/man moved?
lives = _textShadow + 13 ;[1] This is pretty darn obvious.
grav = _textShadow + 14 ;[1] gravity variable
gravtemp = _textShadow + 15;[1] temp variable
topmany = _textShadow + 16 ;[1] used for points
horsemax = 157 ;This is here for calibration
horsey = 54 ;"
;coptermax = 157 ;yet to be implemented

Init:
 call _runindicoff
 ld a,16 ;16 -> a
 ld (timemax),a ;16 -> timemax
 ld a,3 ;3 -> a
 ld (lives),a ;3 -> lives
 ld a,1 ;1 -> a
 ld (grav),a ;1 -> grav
 ld a,0
 ld (topmany),a
 ld hl,0000
 ld (points),hl
Init2:
 ld a,16 ;16->a
 ld (manx),a ;16->initial x-position of man
 ld (oldmanx),a ;16 -> oldmanx
 ld a,8 ;8->a
 ld (many),a ;8->intial y-position of man
 ld (oldmany),a
 ld	a,0 ;0->a
 ld (time),a ;0->time
 ld (gravtemp),a
 ld bc,0000 ;0->bc
 ld	de,0000 ;0->de
 ld	hl,0000 ;0->hl
 call _clrLCD ;clear screen
 ld a,$FF
 ld hl,$FC00+(16*62)
 ld b,16
Init3:
 ld (hl),a
 inc hl
 djnz Init3
 ld a,1	 ;set 'character moved' so it will draw
 ld (movebyte),a ;"
 call UpdateSpr ;Update sprites (initial draw)

Main:
 ld a,0
 ld (movebyte),a
 call GET_KEY ;get keypress
 cp 0
 jr z,Main2
 cp	K_DOWN ;is down pressed?
 jr	z,mvdown ;if yes, go to mvdown
 cp	K_UP ;is up pressed?
 jr	z,mvup ;if yes, go to mvup
 cp	K_LEFT 
 jr	z,mvleft
 cp	K_RIGHT ;is right pressed?
 jr	z,mvright ;if so, go to mvright
 cp K_SECOND ;is 2nd pressed?
 jp z,mandrop ;if so, go to mandrop
 cp K_EXIT ;is exit pressed?
 jp z,quit ;if so, quit.
Main2:
 ld a,(timemax)
 ld b,a
 ld a,(time)
 inc a
 ld (time),a
 cp b
 jr z,updhorse
 jr Goback
updhorse:
 ld a,0
 ld (time),a 
 ld	a,(horse) ;horse x-position -> a
 inc a ;a+1 -> a
 cp	horsemax ;see if it needs to loop around
 call z,setato0 ;loop around if needed
 ld (horse),a
Goback:
 call UpdateSpr ;update sprites
 jr	Main ;go back to main loop
mvdown:
 ld a,1
 ld (movebyte),a
 ld	a,(many) ;man y-position -> a
 ld (oldmany),a
 inc a ;a+1 -> a
 cp 46		;don't go TOO far down!
 jr z,Main2
 ld	(many),a ;put a back into man y-position
 jr	Main2 ;update horse
mvup:
 ld a,1
 ld (movebyte),a
 ld	a,(many) ;man y-position -> a
 ld (oldmany),a
 dec a ;a-1 -> a
 cp 0
 jr z,Main2
 ld	(many),a ;put a back into man y-position
 jr Main2 ;update horse
mvleft:
 ld a,1
 ld (movebyte),a
 ld a,(manx)
 ld (oldmanx),a
 dec a
 ld (manx),a
 jr	Main2
mvright:
 ld a,1
 ld (movebyte),a
 ld	a,(manx) ;man x-position -> a
 ld (oldmanx),a
 inc a ;a+1 -> a
 ld	(manx),a ;put a back into man x-position
 jr	Main2 ;update horse
setato0:
 ld	a,0 ;0 -> a
 ret ;go back to where you came from
UpdateSpr:
clearspr:
 ld a,(movebyte)
 cp 0
 jr z,horsea
 ld hl,blankspr
 ld a,(oldmanx)
 ld b,a
 ld a,(oldmany)
 ld c,a
 call PutSprite
 ld hl,blankspr
 ld a,(oldmanx)
 sub 8
 ld b,a
 ld a,(oldmany)
 sub 8
 ld c,a
 call PutSprite
 ld hl,blankspr
 ld a,(oldmanx)
 ld b,a
 ld a,(oldmany)
 sub 8
 ld c,a
 call PutSprite
drawman:
 ld	hl,man ;put a pointer to the man sprite into hl
 ld a,(manx) ;load man x-position into a
 ld b,a ;a -> b
 ld a,(many) ;load man y-position into a
 ld c,a ;a -> c
 call PutSprite	;draw the sprite for the little man
copter:
 ld	hl,copter1 ;put a pointer to part of the copter sprite into hl
 ld	a,(manx) ;load man x-position into a
 sub 8 ;a-8 -> a
 ld	b,a ;a -> b
 ld a,(many) ;load man y-position into a
 sub 8 ;a-8 -> a
 ld	c,a ;a -> c
 call PutSprite ;draw sprite
 ld hl,copter2 ;put a pointer to part of the copter sprite into hl
 ld a,(manx) ;load man x-position into a
 ld b,a ;a -> b
 ld	a,(many) ;load man y-position into a
 sub 8 ;a-8 -> a
 ld	c,a ;a -> c
 call PutSprite ;draw sprite
horsea:
 ld hl,horsespr ;put a pointer to the horse sprite into hl
 ld a,(horse) ;load horse x-position into a
 ld b,a ;a -> b
 ld c,horsey ;load horse y-position(constant) into c
 call PutSprite ;draw the sprite
cart:
 ld	hl,cart2 ;put a pointer to part of the cart sprite into hl
 ld	a,(horse) ;put horse x-position into a
 sub 8 ;a-8 -> a
 ld	b,a ;a -> b
 ld c,horsey ;load horse y-position into c
 call PutSprite ;draw sprite
 ld	hl,cart1 ;put a pointer to part of the cart sprite into hl
 ld	a,(horse) ;put horse x-position into a
 sub 16 ;a-16 -> a
 ld	b,a ;a -> b
 ld	c,horsey ;put horse y-position into c
 call PutSprite ;draw sprite
 ret ;go back to where you came from
mandrop:
 ld a,(many)	;
 ld (topmany),a	;these 2 lines don't seem to work...
mandrop2:
 call GET_KEY ;part of delay
  
 ld a,(grav)
 ld b,a
 ld d,0
 ld a,(gravtemp)
 inc a
 ld (gravtemp),a
 cp b
 jr nz,DropLoop
 ld d,1
 ld a,0
 ld (gravtemp),a
 ld	a,(many) ;load man y-position into a
 inc a ;a+1 -> a
 cp	horsey ;does it match the horse's y-position?
 jr	z,landtest ;if so, see if the guy lands in a good spot or not
 ld	(many),a ;put a back into y-position
DropLoop:
 ld	a,(horse) ;load horse x-position into a
 inc a ;a+1 -> a
 cp	horsemax ;does the horse have to loop?
 call z, setato0 ;if so, set horse x-position to 0
 ld	(horse),a ;put a back into horse x-position
 call drawspr2 ;update the sprites
 jr mandrop2 ;go back to the man drop loop
landtest:
 ld a,(horse) ;load horse x-position into a
 ld c,a ;a -> c
 ld a,(manx) ;load man x-position into a
 ld	b,12 ;12 -> b
landtest2:
 dec c ;c-1 -> c
 djnz landtest2 ;go back to landtest2: 12 times
 ld b,17 ;17 -> b
test:
 cp	c ;does c land at a?
 jr	z,landgood ;if so, go to landgood
 dec c ;c-1 -> c
 djnz test ;go back to test: 17 time
landbad:
 call _clrLCD
 ld a,(lives)
 dec a
 ld (lives),a
 cp 0
 jp z,quit
 jp Init2
  ;landed in bad spot. exit program.
landgood:
 call _clrLCD
 ld a,(lives)
 inc a
 ld (lives),a
 ld a,(topmany)
 ld b,a
 ld a,70
sublandgood:
 dec a
 djnz sublandgood
 ld b,a
 ld hl,(points)
sublandgood2:
 inc hl
 djnz sublandgood2
 ld (points),hl
 ld a,4
 ld b,a
 ld a,(timemax)
landgoodloop:
 dec a
 cp 0
 jr z,landgood2 
 djnz landgoodloop
 ld (timemax),a
 jp Init2
landgood2:
 ld a,16
 ld (timemax),a
 ld a,(grav)
 inc a
 ld (grav),a
 jp Init2
; call _clrLCD ;clear screen
; call $4A95	;make it display text in upper left
; ld	hl,winstring ;load pointer to the winning string into hl
; call _puts ;display string
; ret ;exit program.
drawspr2:
 ld a,d
 cp 0
 jr z,drawhorse2
 ld hl,blankspr
 ld a,(many)
 dec a
 ld c,a
 ld a,(manx)
 ld b,a
 call PutSprite
 ld hl,man ;load pointer to the man sprite into hl
 ld a,(manx) ;load man x-position into a
 ld b,a ;a -> b
 ld a,(many) ;load man y-position into a
 ld c,a ;a -> c
 call PutSprite ;draw sprite
drawhorse2:
 ld hl,horsespr ;do horse
 ld a,(horse)
 ld b,a
 ld c,horsey
 call PutSprite
 ld hl,cart2 ;do cart
 ld a,(horse)
 sub 8
 ld b,a
 ld c,horsey
 call PutSprite
 ld	hl,cart1
 ld	a,(horse)
 sub 16
 ld b,a
 ld	c,horsey
 call PutSprite
 ret ;go back to where you came from
quit:
 call _clrLCD
 ld a,0
 ld hl,(points)
 call $4a33		;display score
 ret
; ASCR  - Advanced Sprite Clipping Routines
;
;       by Jimmy M?rdell        970304   Last update 970803
;
; Temporary variables needed:
;  clipmask  : Byte
;  rows2put  : Byte
;  bitmask       : Byte
;
; PutSprite:
;  Puts an 8x8 sprite at B,C. HL = pointer to sprite. No mask and no
;  background storage, just clipping.


PutSprite:               ; BC = x,y  HL = sprite
 push bc
 push de
 push hl
 push ix
 ld a,$FF
 ld (clipmask),a
 bit 7,b
 jr z,PSC_CheckRightClip
 ld a,b
 cp 249
 jr c,EndPPS
 neg
 push bc
 ld b,a
 ld a,$FF
PSC_LeftClip:
 srl a
 djnz PSC_LeftClip
 pop bc
 res 7,b
 dec c
 ld (clipmask),a
 jr PSC_CheckBotClip
PSC_CheckRightClip:
 ld a,b
 sub 121
 jr c,PSC_CheckBotClip
 push bc
 ld b,a
 inc b
 ld a,$FF
PSC_RightClip:
 add a,a
 djnz PSC_RightClip
 ld (clipmask),a
 pop bc
PSC_CheckBotClip:
 ld a,8
 ld (rows2put),a
 bit 7,c
 jr nz,PSC_CheckTopClip
 bit 6,c
 jr nz,EndPS
 ld a,64
 sub c
 cp 8
 jr nc,PSC_ClippingDone
 ld (rows2put),a
 jr PSC_ClippingDone
PSC_CheckTopClip:
 ld a,c
 cp 249
EndPPS:
 jr c,EndPS
 push bc
 neg
 ld b,a
 sub 8
 neg
 ld (rows2put),a
PSC_TopClip:
 inc hl
 inc de
 djnz PSC_TopClip
 pop bc
 ld c,0
PSC_ClippingDone:
 push hl
 pop ix
 ld a,(rows2put)
 push af
 call FIND_PIXEL
Modify_6:
 ld de,$FC00
 add hl,de
 ld d,a
 pop bc
PSC_PutRow:
 push bc
 push hl
 ld a,(clipmask)
 ld e,a
 ld b,8
 ld c,(ix)
 inc ix
PSC_PutCol:
 push bc
 rlc e
 jr nc,PSC_NextBit
 ld a,d
 rlc c
 jr c,PSC_BitOn
 cpl
 and (hl)
 ld (hl),a
 jr PSC_NextBit
PSC_BitOn:
 or (hl)
 ld (hl),a
PSC_NextBit:
 rrc d
 jr nc,PSC_SSB
 inc hl
PSC_SSB:
 pop bc
 rlc c
 djnz PSC_PutCol
 pop hl
 ld bc,16
 add hl,bc
 pop bc
 djnz PSC_PutRow
EndPS:
 pop ix
 pop hl
 pop de
 pop bc
 ret

FIND_PIXEL:
 push bc
 push de
 ld hl,ExpTable+1
 ld d,0
 ld a,b
 and $07
 ld e,a
 add hl,de
 ld e,(hl)
 ld h,d
 srl b
 srl b
 srl b
 ld a,c
 add a,a
 add a,a
 ld l,a
 add hl,hl
 add hl,hl
 ld a,e
 ld e,b
 add hl,de
 pop de
 pop bc
 ret

ExpTable:
 .db $01,$80,$40,$20,$10,$08,$04,$02,$01

;winstring:
; .db "You win!",0

man:
	.db %10011001
	.db %10011001
	.db %11111111
	.db %00111100
	.db %00111100
	.db %00111100
	.db %01100110
	.db %01100110

horsespr:
	.db %00000010
	.db %00000111
	.db %00001110
	.db %01111100
	.db %10111100
	.db %10100100
	.db %10100100
	.db %00010010

cart1:
	.db %00011101
	.db %00111111
	.db %01111111
	.db %01011100
	.db %01100010
	.db %01101011
	.db %01100010
	.db %00011100

cart2:
	.db %11001000
	.db %11111100
	.db %11111100
	.db %00000111
	.db %00110100
	.db %11001100
	.db %01001000
	.db %00110000

copter1:
	.db %00000000
	.db %00011111
	.db %00000000
	.db %00000011
	.db %10000100
	.db %11111000
	.db %00000100
	.db %00000011

copter2:
	.db %00000000
	.db %11111111
	.db %01000000
	.db %11111000
	.db %00011100
	.db %00000010
	.db %00000100
	.db %11111000

blankspr:
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000

.end
