;
;       R E P T O N    8 6
;       v. 0.9   22/10/97
;
;       by Matthew Shepcar
;       scabby@warzone.com
;
;  Apologies for the lack of comments but
;  it's hard enough to code 4738 lines never
;  mind comment them all as well! :)
;
;  Feel free to read this code and take any
;  of my ideas but please don't just copy
;  chunks of it into your own programs without
;  asking me first! 
;
; TO DO:  (*=priority)
;
;         better 12x12 sprite code
;     *   fungus (which can eat spirits)
;         teacher key (save games?)
;         check: should spirits move faster than repton?
;         flash screen on low time?
;     *   make it smaller!!!  remove the stupid external titlescreen... :)
;         - make a universal menu routine


#include asm86.h
#include ti86asm.inc

.org _asm_exec_ram

 call _runindicoff
 res appTextSave,(iy+appflags)

 ld hl,$FC00
 ld de,origscreen
 ld bc,$400
 ldir
 ld hl,(_curRow)
 ld (oldcurrow),hl
 xor a
 ld (screenhidden),a
 ld hl,_textShadow
 ld de,origtextshadow
 ld bc,168
 ldir

 call HideDrawing

 ld hl,0
 ld bc,$3F7F
 ld a,$55
 call block
 ld hl,$0D0A
 ld bc,$3275
 call box3do

 ld hl,$251F
 ld (_penCol),hl
 ld hl,StartMsg
 call _vputs
 ld hl,$2B17
 ld (_penCol),hl
 ld hl,EmailAddy
 call _vputs

 ld hl,TitleVar
 rst 20h
 rst 10h
 ld a,41h
 out (6),a
 jr c,NoTitleScreen
 ex de,hl
 ld c,b
 call getbyte
 call getbyte

; ld hl,TitlePic
 ld e,22
 ld ix,$FCF1
CopyTitlePic:
  ld b,14
CopyTitlePicRow:
   call getbyte
   or (ix)
   ld (ix),a
   inc ix
   djnz CopyTitlePicRow
  inc ix
  inc ix
  dec e
  jr nz,CopyTitlePic

 call shredscreen

 call _getkey
 cp kExit
 jp z,abort

NoTitleScreen:
 ld a,$8F
 ld de,$8E00
 ld bc,257
 call repstosb
 ld hl,IHandler
 ld de,$8F8F
 ld bc,IHandlerEnd-IHandler
 ldir
 ld a,$8E
 ld i,a

 call CountLevels

 call HideDrawing
 call _clrLCD
 call DrawReptonWindow
 ld a,(levelcnt)
 cp 1
 jr nz,countedlevels
 xor a
 ld (currentlevel),a
 call levelselected
 jr maingamemenunotitle

 call DrawReptonWindow
chooselevels:
 call CountLevels
countedlevels:
 call SelectLevel
 jp c,abort

maingamemenu:
 call HideDrawing
 call _clrLCD
 call DrawReptonWindow
maingamemenunotitle:

 ld hl,$0A03
 ld bc,$3C7C
 ld a,$55
 call block

 ld hl,$0D06
 ld bc,$394E
 call box3do

 ld hl,$0D07
 ld (_penCol),hl
 ld hl,levelname
checkforshortlevelname:
  ld a,(hl)
  or a
  jr z,noshortlevelname
  inc hl
  cp '-'
  jr nz,checkforshortlevelname
  ld a,(hl)
  cp ' '
  jr nz,nospaceafterhyphen
  inc hl
nospaceafterhyphen:
  jr gotshortname
noshortlevelname:
 ld hl,levelname
gotshortname:
 call _vputs
 ld hl,$1307
 ld (_penCol),hl
 ld hl,levelname
 xor a
 ld bc,60
 cpir
 call _vputs

 ld hl,$0D06
 ld bc,$394E
 call box3d

 ld hl,$0E07
 ld bc,$194D
 ld a,255
 call xorblock

 ld hl,$1408
 ld ix,Hiscores
 ld b,5
showscorers:
  ld de,$600
  add hl,de
  push hl
  push bc
  push ix
  ld d,5
  add hl,de
  ld c,$4B
  ld a,$55
  call horizline
  pop hl
  ld de,scorer
  ld bc,18
  ldir
  push hl
  pop ix
  pop bc
  pop hl
  push bc
  ld (_penCol),hl
  ld a,'6'
  sub b
  push hl
  ld hl,placemsg
  ld (hl),a
  ld a,')'
  ld (placemsg+1),a
  ld a,32
  ld (placemsg+2),a
  call _vputs
  ld l,(ix)
  ld h,(ix+1)
  inc ix
  inc ix
  pop bc
  push bc
  ld c,$4E
  call putnum
  pop hl
  pop bc
  djnz showscorers

 ld hl,$1254
 ld bc,$3478
 call box3do

 ld hl,$145D
 ld (_penCol),hl
 ld hl,PlayMsg
 call _vputs
 ld hl,$1C57
 ld (_penCol),hl
 ld hl,PwdMsg
 call _vputs
 ld hl,$245A
 ld (_penCol),hl
 ld hl,ScreensMsg
 call _vputs
 ld hl,$2C5F
 ld (_penCol),hl
 ld hl,QuitMsg
 call _vputs

 call shredscreen
 call clearkbbuf
 ld hl,$1456
 ld bc,$1A76
 ld d,0
HighlightGameMenuItem:
 push hl
 push bc
 push de
 call xorblock
 pop de
 pop bc
 pop hl
WaitForGameMenuKey:
  push bc
  push hl
  push de
  call _getkey ;GET_KEY
  pop de
  pop hl
  pop bc
  cp kExit ;K_EXIT
  jp z,abort
  cp kUp ;K_UP
  jr nz,notgamemenuup
  ld a,d
  or a
  jr z,WaitForGameMenuKey
  dec d
  push hl
  push bc
  push de
  call xorblock
  pop de
  pop bc
  pop hl
  ld a,h
  sub 8
  ld h,a
  ld a,b
  sub 8
  ld b,a
  jp HighlightGameMenuItem
notgamemenuup:
  cp kDown ;K_DOWN
  jr nz,notgamemenudown
  ld a,d
  cp 3
  jr z,WaitForGameMenuKey
  inc d
  push hl
  push bc
  push de
  call xorblock
  pop de
  pop bc
  pop hl
  ld a,h
  add a,8
  ld h,a
  ld a,b
  add a,8
  ld b,a
  jp HighlightGameMenuItem
notgamemenudown:
  cp kEnter ;K_ENTER
  jr z,GotGameMenuKey
  cp kClear ;K_CLEAR
  jr nz,GotGameMenuKey
GotGameMenuKey:
 ld a,d
 cp 3
 jp z,abort
 or a
 jp z,startgame
 cp 2
 jp z,chooselevels

enterpwd:
 ld hl,$0A03
 ld bc,$3C7C
 ld a,$55
 call block

 ld hl,$1722
 ld bc,$285A
 call box3do

 ld hl,$1825
 ld (_penCol),hl
 ld hl,EnterPwdMsg
 call _vputs

 ld hl,$0604
 ld (_curRow),hl
 ld de,pwdbuffer
 ld a,8
 call textinput
 jr c,abortpwd

 ld e,0
checkpasswords:
  push de
  ld a,e
  call decodemapinfo
  pop de
  ld ix,password
  ld hl,pwdbuffer
  ld b,7
checkpwd:
   ld a,(ix)
   xor (hl)
   res 5,a   ;ignore case
   or a
   jr nz,mismatch
   inc hl
   inc ix
   djnz checkpwd
 ld a,1
 ld (usedpass),a
 ld a,e
 ld (currentmap),a
 jp startwithpwd

mismatch:
   inc ix
   djnz mismatch
  inc ix
  inc ix
  inc e
  ld a,(mapcnt)
  cp e
  jr nz,checkpasswords

 ld hl,$0A03
 ld bc,$3C7C
 ld a,$55
 call block

 ld hl,$1E22
 ld bc,$285C
 call box3do

 ld hl,$0604
 ld (_curRow),hl
 ld hl,MismatchMsg
 call _puts
 call _getkey
abortpwd:
 jp maingamemenu

startgame:
; ld a,(mapcnt)
; dec a
; ld (currentmap),a
; xor a
; ld (usedpass),a
; jp EndLevel

 xor a
 ld (currentmap),a
 ld (usedpass),a
startwithpwd:
 ld a,3
 ld (lives),a
 ld hl,0
 ld (score),hl
newlevel:
 ld a,(currentmap)
 add a,'A'
 ld (scrmsgletter),a
 ld a,' '
 ld (endofscrmsg),a

 call HideDrawing

 ld a,(currentmap)
 call decodemap 

 ld hl,$0A03
 ld bc,$3C7C
 ld a,$55
 call block

 ld hl,$1622
 ld bc,$305C
 call box3do

 ld hl,$0603
 ld (_curRow),hl
 ld hl,ScrMsg
 call _puts

 ld hl,$2030
 ld (_penCol),hl
 ld hl,PassMsg
 call _vputs

 ld hl,$2023
 ld bc,$265B
 call xorblock

 ld hl,$0705
 ld (_curRow),hl
 ld hl,password
 call _puts

 call shredscreen
 call HideDrawing
 call _clrLCD

 call _getkey

 ld a,(contrast)
 out (2),a

 call updatesidebar

startlife:
 xor a
 ld (deathflag),a
 ld a,83   ;about 5 seconds
 ld (snoretimer),a
 ld hl,(startpos)
 ld (curpos),hl
 ld a,17
 ld (curanim),a

 call getmapblock
 set 6,a
 call setmapblock

 call resettime

 call calculatescreenoffsets

 ld a,1
 ld (animdir),a
 ld a,12
 ld (scrlamt),a
 ld a,4       
 ld (curdir),a

 ld hl,(scrly)
 ld de,64
 add hl,de
 ld (scrly),hl
 ld hl,topleftblock+1
 ld a,(topleftybits)
 add a,4
 cp 12
 jr c,notoverwee
 sub 12
 inc (hl)
notoverwee:
 ld (topleftybits),a
 ld a,(hl)
 add a,5
 ld (hl),a

 call shredscreen

 ld b,64
dropmapin:
  push bc
  call scrollup   ;weeeeeeeee! ;)
  pop bc
  djnz dropmapin

docontinue:
 set 2,(iy+$12)     ;thanks for this Jimmy! :)
 im 2

RedrawSprite:
  ld a,(curanim)
  ld bc,$1A2A
  call putsprite
MainLoop:
  ld a,$FF
  out (1),a ;strange things happen w/o this...
  ld a,$BF
  out (1),a
  in a,(1)
  bit 0,a
  jp z,abortgame
  bit 1,a
  jp z,reptonisdead
  bit 6,a
  jp z,reptonisdead
  bit 5,a
  jp z,pausegame
  bit 7,a
  jp z,pausegame
  bit 4,a
  jr nz,notmap
  im 1
  call showmap
  im 2
  jp RedrawSprite
notmap:
  ld a,$F7
  out (1),a
  in a,(1)
  bit 7,a
  jp z,abort      ;emergency exit
  call checkpowerkey

  ld hl,timer+1
  ld a,(hl)
  sub 3
  jr c,MainLoop
  ld (hl),a
  dec hl
  ld a,(hl)
  sub 12
  cp 128
  jp nc,noupdate
doupdate:
  ld (hl),a
  ld a,(contrastdelay)
  or a
  jr z,testcontrastkeys
  dec a
  ld (contrastdelay),a
  jr notminus
testcontrastkeys:
  ld a,$FD
  out (1),a
  in a,(1)
  bit 1,a
  jr nz,notplus
  ld a,(contrast)
  cp 31
  jr z,notminus
  inc a
  jr setingamecontrast
notplus:
  bit 2,a
  jr nz,notminus
  ld a,(contrast)
  or a
  jr z,notminus
  dec a
setingamecontrast:
  ld (contrast),a
  out (2),a
  ld a,5
  ld (contrastdelay),a
notminus:

  call updateactiveobjects
  ld hl,(nexttick)
  ld de,(timedelta)
  add hl,de
  ld (nexttick),hl
  jr nc,notimerupdate
  call decreasetime
notimerupdate:

  ld hl,snoretimer
  dec (hl)
  jr nz,notsleepyrepton
  ld a,10
  ld (hl),a
  ld a,4       
  ld (curdir),a
  ld a,(curanim)
  cp 17
  jr z,lookingahead
  ld a,17
  jr gotsleepyanim
lookingahead:
  ld a,(animdir)
  neg
  ld (animdir),a
  inc a
  srl a
  add a,43
gotsleepyanim:
  ld (curanim),a
  jp RedrawSprite
notsleepyrepton:

  ld a,(levelcompleted)
  or a
  jp nz,EndLevel
  ld a,(deathflag)
  or a
  jp nz,reptonisdead
  ld a,(scrlamt)
  cp 12
  jr z,getnewdir
noupdate:

  ld a,(scrlamt)
  cp 12
  jp z,MainLoop
  ld a,83
  ld (snoretimer),a
  ld a,(curdir)
  jp continuemoving

getnewdir:
  ld a,$FE
  out (1),a
  in a,(1)

trynewdir:
  ld d,-1
  bit 0,a
  jr nz,notdown
  set 0,a
  ld d,2
  jr gotnewdir
notdown:
  bit 1,a
  jr nz,notleft
  set 1,a
  ld d,3
  jr gotnewdir
notleft:
  bit 2,a
  jr nz,notright
  set 2,a
  ld d,1
  jr gotnewdir
notright:
  bit 3,a
  jr nz,notup
  set 3,a
  ld d,0
  jr gotnewdir
notup:
  jp MainLoop
gotnewdir:
  ld e,a
  ld hl,(curpos)
  push de
  ld a,d
  call adjustHLfordir
  call checkifmapblockempty
  pop de
  ld a,e
  jr c,trynewdir
  ld a,12
  ld (scrlamt),a
  ld a,d
  ld (curdir),a
continuemoving:
  or a
  jr z,continueup
  dec a
  jr z,continueright
  dec a
  jr z,continuedown
continueleft:
  call scrollleft
  ld de,$2629
  ld bc,$1A2B
  jr donescroll
continueup:
  call scrollup
  ld de,$2021
  ld bc,$1B2A
  jr donescroll
continueright:
  call scrollright
  ld de,$2225
  ld bc,$1A29
  jr donescroll
continuedown:
  call scrolldown
  ld de,$2021
  ld bc,$192A
donescroll:
  ld (animextents),de
  ld a,31
  call putsprite

  ld a,(scrlamt)
  dec a
  jr nz,notresetscroll
  ld hl,(curpos)
  ld a,(curdir)
  call adjustHLfordir
  call moverepton
  ld a,12
notresetscroll:
  ld (scrlamt),a

  ld bc,(animextents)
  inc b
  ld de,(animdir)
  ld hl,curdir
  bit 0,(hl)
  jr z,updownanim
  cp 6
  jr z,doanim
updownanim:
  cp 12
  ld a,(curanim)
  jr nz,noanim
doanim:
  ld a,(curanim)
  add a,e
noanim:
  cp b
  jr nc,notat1stanim
  ld a,1
  ld (animdir),a
  ld a,b
  dec a
notat1stanim:
  cp c
  jr c,notatlastanim
  ld a,-1
  ld (animdir),a
  ld a,c
notatlastanim:
  ld (curanim),a
  ld bc,$1A2A
  call putsprite
  ld a,(scrlamt)
  cp 12
  jp nz,MainLoop
  ld hl,timer
  ld a,(hl)
  sub 12
  jp doupdate

EndLevel:
 im 1
 res 2,(iy+$12)
 call clearkbbuf
 call HideDrawing
 call _clrLCD
 ld a,(currentmap)
 inc a
 ld (currentmap),a
 call DrawReptonWindow
 ld a,(currentmap)
 ld hl,mapcnt
 cp (hl)
 jp nz,newlevel

 ld hl,$0A03
 ld (_penCol),hl
 ld a,(usedpass)
 ld hl,tryagainmsg
 or a
 jr nz,didusepass
 ld hl,endmessage
didusepass:
 push hl
 call _vputs
 ld a,(_penCol)
 neg
 add a,131
 srl a
 push af

 ld hl,$0A03
 ld (_penCol),hl
 ld hl,levelname
 call _vputs
 ld a,(_penCol)
 neg
 add a,131
 srl a
 push af

 ld hl,$0A03
 ld bc,$3C7C
 ld a,$55
 call block

 ld hl,$0E0A
 ld bc,$1873
 call box3do

 ld hl,$0202
 ld (_curRow),hl
 ld hl,congratmsg
 call _puts

 ld hl,$1D0A
 ld bc,$3773
 call box3do

 ld hl,$1F28
 ld (_penCol),hl
 ld hl,completedmsg
 call _vputs

 pop af
 ld l,a
 ld h,$27
 ld (_penCol),hl
 ld hl,levelname
 call _vputs

 pop af
 ld l,a
 ld h,$2F
 ld (_penCol),hl
 pop hl
 call _vputs

 call shredscreen
 call _getkey
 jp abortgame

reptonisdead:
  im 1
  call resetcontrast
  res 2,(iy+$12)
  ld a,50
  ld de,$FF10
deathanimloop:
   push af
   push de
   ld bc,$1A2A
   call putsprite
   pop de
   ld b,e
deathanimwait:
    halt
    djnz deathanimwait
   pop af
   cp 31
   jr z,donedeathanim
   add a,d
   cp 48
   jr nz,notlastdeathanim
   ld d,1
notlastdeathanim:
   cp 51
   jr nz,deathanimloop
   ld a,31
   ld e,$40
   jr deathanimloop
donedeathanim:
 ld hl,(curpos)
 call getmapblock
 res 6,a
 call setmapblock
 call checkmaparea
 ld hl,(curpos)
 ld a,(curdir)
 call adjustHLfordir
 call getmapblock
 res 6,a
 call setmapblock
 call checkmaparea
 call HideDrawing

 ld a,(lives)
 add a,$5C
 ld l,a
 ld h,$FF
 ld b,8
removelifepic:
  ld a,(hl)
  and $3
  ld (hl),a
  ld de,16
  add hl,de
  djnz removelifepic

 ld hl,lives
 dec (hl)
 jr z,gameover

 ld hl,$0000
 ld bc,$3F5F
 xor a
 call block
 jp startlife

gameover:
 im 1

 ld hl,$1E16
 ld bc,$2850
 call box3do

 ld hl,$0404
 ld (_curRow),hl
 ld hl,GameOverMsg
 call _puts
 call shredscreen
 call clearkbbuf
 call _getkey
 jp abortgame

pausegame:
 res 2,(iy+$12)
 im 1
 call HideDrawing

 ld hl,$0000
 ld bc,$3F5F
 ld a,$55
 call block

 ld hl,$0707
 ld bc,$3757
 call box3do

 ld hl,$0301
 ld (_curRow),hl
 ld hl,PauseMsg
 call _puts

 ld hl,$0808
 ld bc,$0F56
 call xorblock

 ld hl,$110E
 ld (_penCol),hl
 ld hl,ContrastMsg
 call _vputs

 ld hl,$1713
 ld (_penCol),hl
 ld hl,MapMsg
 call _vputs

 ld hl,$1D13
 ld (_penCol),hl
 ld hl,KillMsg
 call _vputs

 ld hl,$2313
 ld (_penCol),hl
 ld hl,EndGameMsg
 call _vputs

 ld hl,$2912
 ld (_penCol),hl
 ld hl,OffMsg
 call _vputs

 ld hl,$2F0D
 ld (_penCol),hl
 ld hl,ReturnMsg
 call _vputs

 call shredscreen

waitforunpause:
  call _getkey ;GET_KEY

  cp kUp ;K_UP
  jr nz,notcontrastup
  ld a,(contrast)
  cp 31
  jr z,waitforunpause
  inc a
  jr doadjustcontrast
notcontrastup:
  cp kDown ;K_DOWN
  jr nz,notcontrastdown
  ld a,(contrast)
  or a
  jr z,waitforunpause
  dec a
doadjustcontrast:
  ld (contrast),a
  out (2),a
  halt
  halt
  jr waitforunpause
notcontrastdown:
  cp kExit ;K_EXIT
  jp z,continuegame
  cp kF4 ;K_F4
  jr nz,notsuicide
  ld a,1
  ld (deathflag),a
  jp continuegame
notsuicide:
  cp kF1 ;K_F1
  jr nz,notsmap
  call showmap
  jp docontinue
notsmap:
  cp kF5 ;K_F5
  jr z,abortgame
  call checkpowerkey
  jr waitforunpause

continuegame:
 call HideDrawing
 call redrawscreen
 call shredscreen
 jp docontinue

abortgame:
 res 2,(iy+$12)
 im 1

 ld ix,Hiscores-20
 ld de,(score)
 ld b,5
checkforhiscore:
  push bc
  ld bc,20
  add ix,bc
  pop bc
  ld l,(ix+18)
  ld h,(ix+19)
  or a
  sbc hl,de
  jr c,newhiscore
  djnz checkforhiscore
 jp maingamemenu

newhiscore:
 push ix
 dec b
 jr z,noshiftscores
 ld hl,Hiscores+79
 ld de,Hiscores+99
shiftscores:
  push bc
  ld bc,20
  lddr
  pop bc
  djnz shiftscores
noshiftscores:

 call HideDrawing
 call _clrLCD
 call DrawReptonWindow

 ld hl,$0A03
 ld bc,$3C7C
 ld a,$55
 call block

 pop ix
 ld de,(score)
 ld (ix+18),e
 ld (ix+19),d
 push ix

 ld hl,$1717
 ld bc,$2867
 call box3do

 ld hl,$1819
 ld (_penCol),hl
 ld hl,NewHiscoreMsg
 call _vputs

 call shredscreen

 ld hl,$0404
 ld (_curRow),hl
 pop de
 ld a,12
 call textinput
 jr nc,gotnewscorer
 xor a
 ld (de),a
gotnewscorer:
 call encodehiscores
 jp maingamemenu

abort:
 call HideDrawing
 ld de,$FC00
 ld hl,origscreen
 ld bc,$400
 ldir
 call shredscreen

 ld de,_textShadow
 ld hl,origtextshadow
 ld bc,168
 ldir

 ld hl,(oldcurrow)
 ld (_curRow),hl

cleanup:

 res 2,(iy+$12)
 im 1                  ; just in case :)

 ld hl,ProgVar
 rst 20h
 rst 10h
 ex de,hl
 ld a,b
 ld de,screenbuffer-_asm_exec_ram+4
 add hl,de
 adc a,0
 call $4633
 set 6,a
 out (5),a
 inc a
 out (6),a
 ld de,-4000h
 add hl,de
 ld de,screenbuffer
 ld bc,end-screenbuffer
 ldir
 ld a,13
 out (5),a
 ld a,41h
 out (6),a
 call clearkbbuf

 set appTextSave,(iy+appflags)
 res onInterrupt,(iy+onflags)
 ret

checkpowerkey:
 in a,(3)
 bit 3,a
 ret nz
 call waitforonrelease
 ld a,1
 out (3),a
 ld hl,6
 res 0,(hl)
 halt
 ld a,11
 out (3),a
 set 0,(hl)
waitforonrelease:
  in a,(3)
  bit 3,a
  jr z,waitforonrelease
 ret

MulHLby12:
 push bc
 add hl,hl
 add hl,hl
 ld c,l
 ld b,h
 add hl,hl
 add hl,bc
 pop bc
 ret

clearkbbuf:
 call GET_KEY
 or a
 jr nz,clearkbbuf
 ret

textinput:
 ld (maxtextlen),a
 push de
 ld a,' '
 ld de,_textShadow
 ld bc,168
 call repstosb
 pop de
 ld b,0
 ld a,12
 ld (iy+curflags),a
 set appTextSave,(iy+appflags)
putcursor:
;  ld a,'_'
;  push de
;  call _putmap
;  pop de
waitforinput:
  bit shiftALock,(iy+shiftflags)
  jr nz,dontresetshiftflags
  ld (iy+shiftflags),$50    ;prevent user from getting out of alphalock
dontresetshiftflags:
  push de
  push bc
  call _getkey
  pop bc
  pop de
  cp kExit
  jp z,abortinp
  cp kClear
  jr nz,notclearinp
doclearinp:
   call deleteinputchar
   ld a,b
   or a
   jr nz,doclearinp
  jr putcursor
notclearinp:
  cp kEnter
  jr z,gotinp
  cp kLeft
  jr z,dodelete
  cp kDel
  jr nz,notdelete
dodelete:
  call deleteinputchar
  jr putcursor
notdelete:
  cp kSpace
  jr nz,notspace
  ld l,' '
  jr gotalpha
notspace:
  cp kCapA
  jr c,notcapalpha
  cp kCapZ+1
  jr nc,notcapalpha
  add a,65-kCapA
  jr gotalpha
notcapalpha
  cp ka
  jr c,notsmlalpha
  cp kz+1
  jr nc,notsmlalpha
  add a,97-ka
gotalpha:
  ld l,a
  ld a,(maxtextlen)
  cp b
  jr z,waitforinput
  ld a,l
  ld (de),a
  inc de
  push de
  call _putc
  pop de
  inc b
  jr putcursor
notsmlalpha:
  jr waitforinput
gotinp:
 ld a,(maxtextlen)
 sub b
 jr z,bufferfilled
 ld b,a
 xor a
filltoendofbuf:
  ld (de),a
  inc de
  djnz filltoendofbuf
bufferfilled:
 res appTextSave,(iy+appflags)
 ld (iy+curflags),0
 ld (iy+shiftflags),0
 or a
 ret
abortinp:
 res appTextSave,(iy+appflags)
 ld (iy+curflags),0
 ld (iy+shiftflags),0
 scf
 ret

deleteinputchar:
 ld a,b
 or a
 ret z
 push de
 ld a,' '
 call _putmap
 pop de
 xor a
 dec de
 ld (de),a
 ld a,(_curCol)
 dec a
 ld (_curCol),a
 push de
 ld a,' '
 call _putmap
 pop de
 dec b
 ret


setupline:
 ld c,a
 ld a,l
 and 7
 inc a
 ld b,a
 ld a,1
calcstartpixel:
  rrca
  djnz calcstartpixel
 rlc l
 srl h
 rr l
 srl h
 rr l
 srl h
 rr l
 srl h
 rr l
 dec h
 dec h
 dec h
 dec h
 ld b,c
 ret

box3do:
 push bc
 dec h
 dec l
 inc b
 inc c
 xor a
 push hl
 push bc
 call block
 pop bc
 pop hl
 inc h
 inc l
 inc b
 inc c
 xor a
 push hl
 call rect
 pop hl
 pop bc

box3d:
 ld a,255
 push hl
 push bc
 ld h,b
 inc h
 inc c
 inc l
 call horizline
 pop bc
 pop hl
 push hl
 push bc
 ld l,c
 inc h
 inc b
 inc l
 call vertline
 pop bc
 pop hl

rect:                   ; hl=y1x1  bc=y2x2
 push af
 push hl
 push bc
 dec c
 call horizline
 pop bc
 pop hl
 push hl
 push bc
 ld l,c
 dec b
 call vertline
 pop bc
 pop hl
 pop af
 push hl
 push bc
 dec b
 call vertline
 pop bc
 pop hl
 ld h,b
 call horizline
 ret

rightbitoffsets:
 .db %10000000
 .db %11000000
 .db %11100000
 .db %11110000
 .db %11111000
 .db %11111100
 .db %11111110
leftbitoffsets:
 .db %11111111
 .db %01111111
 .db %00111111
 .db %00011111
 .db %00001111
 .db %00000111
 .db %00000011
 .db %00000001

preparehorizline:             ; h=y l=x1 c=x2
 ld a,c
 and 7
 ld ix,rightbitoffsets
 ld e,a
 ld d,0
 add ix,de
 push ix
 ld a,l
 and 7
 ld ix,leftbitoffsets
 ld e,a
 ld d,0
 add ix,de

 ld a,h
 add a,a
 add a,a
 add a,a
 rl d
 add a,a
 rl d
 srl l
 srl l
 srl l
 or l
 ld e,a
 dec d
 dec d
 dec d
 dec d

 srl c
 srl c
 srl c
 ld a,c
 sub l
 ld b,a
 jr nz,notsinglebyteline
 ld a,(ix)
 pop hl
 and (hl)
 ex de,hl
 ret
notsinglebyteline:
 ld a,(ix)
 pop hl
 ld c,(hl)
 ex de,hl
 ret

horizline:
 ld e,a
 push de
 call preparehorizline
 pop de
blitreadyline:
 push af
 and e
 ld d,a
 pop af
 cpl
 and (hl)
 or d
 ld (hl),a
 ld a,b
 or a
 ld a,e
 ret z
 dec b
 jr z,lastlinebyte
fillline:
  inc hl
  ld (hl),a
  djnz fillline
lastlinebyte:
 inc hl
 ld a,c
 and e
 ld d,a
 ld a,c
 cpl
 and (hl)
 or d
 ld (hl),a
 ld a,e
 ret

xorreadyline:
 xor (hl)
 ld (hl),a
 ld a,b
 or a
 ret z
 dec b
 jr z,lastxorlinebyte
xorfillline:
  inc hl
  ld a,(hl)
  cpl
  ld (hl),a
  djnz xorfillline
lastxorlinebyte:
 inc hl
 ld a,c
 xor (hl)
 ld (hl),a
 ret

block:                    ; hl=y1x1  bc=y2x2
 ld e,a
 ld a,b
 sub h
 inc a
 ld d,a
 push de
 call preparehorizline
 pop de
blockrows:
  push af
  push bc
  push de
  push hl
  call blitreadyline
  pop hl
  ld de,16
  add hl,de
  pop de
  rrc e
  pop bc
  pop af
  dec d
  jr nz,blockrows
 ret

xorblock:                    ; hl=y1x1  bc=y2x2
 ld a,b
 sub h
 inc a
 ld d,a
 push de
 call preparehorizline
 pop de
xorblockrows:
  push af
  push bc
  push de
  push hl
  call xorreadyline
  pop hl
  ld de,16
  add hl,de
  pop de
  pop bc
  pop af
  dec d
  jr nz,xorblockrows
 ret

vertline:               ; h=y1 l=x b=y2
 ld d,a
 ld a,b
 sub h
 inc a
 call setupline
drawvertline:
  push af
  push de
  ld e,a
  and d
  ld d,a
  ld a,e
  cpl
  and (hl)
  or d
  ld (hl),a
  ld de,16
  add hl,de
  pop de
  pop af
  rrc d
  djnz drawvertline
 ld a,d
 ret

getspriteaddr:
 push de
 res 7,a  ;active sprites have bit 7 set
 bit 6,a
 jr z,notinvissprite
 ld a,31
notinvissprite:
 ld h,0
 ld l,a
 add hl,hl
 add hl,hl
 add hl,hl
 ld d,h
 ld e,l
 add hl,hl
 add hl,de
 ld de,Chars
 add hl,de
 pop de
 ret

sixbysixmasks:
 .db %00000011,%11111111
 .db %10000001,%11111111
 .db %11000000,%11111111
 .db %11100000,%01111111
 .db %11110000,%00111111
 .db %11111000,%00011111
 .db %11111100,%00001111
 .db %11111110,%00000111

putsmlsprite:
 ld d,a
 add a,a
 add a,d
 add a,a
 ld e,a
 ld d,0
 ld hl,MapChars
 add hl,de
 call findpixel
 or a
 jr z,alignedsmlsprite

 push hl
 ld e,a
 ld d,0
 ld hl,sixbysixmasks
 add hl,de
 add hl,de
 ld e,(hl)
 inc hl
 ld d,(hl)
 pop hl

; cp 5
; jr nc,leftshiftingsmlsprite

 ld b,a
 ld c,6
plotsmlspriterowsrt:
  push bc
  push hl
  ld l,(hl)
  ld h,0
dorightshift:
   srl l
   rr h
   djnz dorightshift
  ld a,(ix)
  and e
  or l
  ld (ix),a
  ld a,(ix+1)
  and d
  or h
  ld (ix+1),a
  ld bc,16
  add ix,bc
  pop hl
  pop bc
  ret c
  inc hl
  dec c
  jr nz,plotsmlspriterowsrt
 ret

alignedsmlsprite:
 ld b,6
 ld de,16
plotsmlspriterows:
  ld a,(ix)
  and 3
  or (hl)
  ld (ix),a
  add ix,de
  ret c
  inc hl
  djnz plotsmlspriterows
 ret
 
;leftshiftingsmlsprite:
; neg
; add a,8
; ld b,a
; ld c,6
;plotsmlspriterowslt:
;  push bc
;  push hl
;  ld h,(hl)
;  ld l,0
;doleftshift:
;   sla h
;   rl l
;   djnz doleftshift
;  ld a,(ix)
;  and e
;  or l
;  ld (ix),a
;  ld a,(ix+1)
;  and d
;  or h
;  ld (ix+1),a
;  ld bc,16
;  add ix,bc
;  pop hl
;  pop bc
;  ret c
;  inc hl
;  dec c
;  jr nz,plotsmlspriterowslt
; ret

findpixel:
 ld a,c
 and 7
 push hl
 sra c
 sra c
 sra c
 ld h,0
 ld l,b
 bit 7,b
 jr z,notnegativey
 dec h
notnegativey:
 add hl,hl
 add hl,hl
 add hl,hl
 add hl,hl
 ld b,0
 bit 7,c
 jr z,notnegativeX
 dec b
notnegativeX:
 add hl,bc
 dec h
 dec h
 dec h
 dec h
 ex (sp),hl
 pop ix
 ret

putsprite:            ; bc=yx  a=spr num
 call getspriteaddr
 call findpixel

 ld b,12
plotspriterows:
 neg
 add a,11
 ld c,a
spriteyloop:
  push bc
  push hl
  push ix
  ld b,c
  ld c,(hl)
  inc hl
  ld h,(hl)
  ld l,c
  ld c,0
  xor a
  ld de,$FFF
  inc b
  dec b
  jr z,noshift
shift:
   add hl,hl
   rl c
   sla e
   rl d
   rl a
   djnz shift
noshift:
  push hl
  ld b,a
  push bc
  push ix
  pop bc
  ld a,c
  ld hl,$FBFE ;(screenoffset)
;  sub l
;  dec hl
;  dec hl
  or a
  sbc hl,bc
  pop bc
  jr nc,offscreen
  and 15
  ld h,a
  cp 15
  jr z,notthirdbyte
  cp 14
  jr z,notsecondbyte
  ld a,b
  or a
  jr z,notthirdbyte
  cpl
  and (ix)
  xor c
  ld (ix),a
notthirdbyte:
  ld a,h
  ld c,a
  cp 11
  jr z,offscreen
  pop hl
  inc ix
  ld a,d
  cpl
  and (ix)
  xor h
  ld (ix),a
  ld a,c
  cp 10
  jr nz,firstbyte
  jr notfirstbyte
notsecondbyte:
  inc ix
  pop hl
firstbyte:
  inc ix
  ld a,e
  cpl
  and (ix)
  xor l
  ld (ix),a
  jr notfirstbyte
offscreen:
  pop hl
notfirstbyte:
  pop ix
  ld bc,16
  add ix,bc
  pop hl
  pop bc
  inc hl
  inc hl
  djnz spriteyloop 

 ret

scrolldown:
 call upcontrast
 ld hl,$FC10
 ld de,$FC00
 ld b,63
scrollrowsdown:
  push bc
  ld bc,12
  ldir
  inc hl
  inc hl
  inc hl
  inc hl
  inc de
  inc de
  inc de
  inc de
  pop bc
  djnz scrollrowsdown
 ld hl,(scrly)
 inc hl
 ld (scrly),hl
 ld hl,(topleftblock)
 ld a,(topleftybits)
 cp 11
 jr nz,notresetblockydown
 ld a,-1
 inc h
 ld (topleftblock),hl
notresetblockydown:
 inc a
 ld (topleftybits),a
 ld ix,$FFF0
 inc h
 inc h
 inc h
 inc h
 inc h
 add a,3
 cp 12
 jr c,fillrow
 sub 12
 inc h
 jr fillrow

scrollup:
 call upcontrast
 ld hl,$FFEF
 ld de,$FFFF
 ld b,63
scrollrowsup:
  push bc
  dec hl
  dec hl
  dec hl
  dec hl
  dec de
  dec de
  dec de
  dec de
  ld bc,12
  lddr
  pop bc
  djnz scrollrowsup
 ld hl,(scrly)
 dec hl
 ld (scrly),hl
 ld hl,(topleftblock)
 ld a,(topleftybits)
 or a
 jr nz,notresetblockyup
 ld a,12
 dec h
 ld (topleftblock),hl
notresetblockyup:
 dec a
 ld (topleftybits),a
 ld ix,$FC00

fillrow:
 add a,a
 ld d,0
 ld e,a
 ld a,(topleftxbits)
 neg
 or a
 jr z,noleftxbits
 dec ix
 add a,8
 cp 0
 jr nc,noleftxbits
 dec ix
 add a,8
noleftxbits:
 ld c,a
 ld b,9
dofillrow:
  push hl
  push de
  push bc
  push ix
  call getmapblock
  call getspriteaddr
  add hl,de
  ld b,1
  ld a,c
  call plotspriterows
  pop ix
  pop bc
  pop de
  pop hl
  inc l
  inc ix
  ld a,c
  add a,4
  cp 12
  jr c,notnextrowbyte
  sub 8
  inc ix
notnextrowbyte:
  ld c,a
  djnz dofillrow

resetcontrast:
 ld a,(contrast)
 out (2),a
 ret

scrollright:
 call upcontrast
 ld hl,0
 ld b,64
scrollrowright:
  dec hl
  dec hl
  dec hl
  dec hl
  dec hl
  sla (hl)
  dec hl 
  rl (hl)
  dec hl
  rl (hl)
  dec hl
  rl (hl)
  dec hl
  rl (hl)
  dec hl
  rl (hl)
  dec hl 
  rl (hl)
  dec hl
  rl (hl)
  dec hl 
  rl (hl)
  dec hl
  rl (hl)
  dec hl
  rl (hl)
  dec hl
  rl (hl)
  djnz scrollrowright
 ld hl,(scrlx)
 inc hl
 ld (scrlx),hl
 ld hl,(topleftblock)
 ld a,(topleftxbits)
 or a
 jr nz,notresetblockxright
 ld a,12
 inc l
 ld (topleftblock),hl
notresetblockxright:
 dec a
 ld (topleftxbits),a
 ld a,$C6
 ld (setinstruc+3),a
 ld a,$86
 ld (resinstruc+3),a
 ld ix,$FC0B
 inc l
 inc l
 inc l
 inc l
 inc l
 inc l
 inc l
 ld a,(topleftxbits)
 sub 11
 jr nc,fillcolumn
 add a,12
 inc l
 jr fillcolumn

scrollleft:
 call upcontrast
 ld hl,$FC00
 ld b,64
scrollrowleft:
  srl (hl)
  inc hl
  rr (hl)
  inc hl
  rr (hl)
  inc hl
  rr (hl)
  inc hl
  rr (hl)
  inc hl
  rr (hl)
  inc hl
  rr (hl)
  inc hl
  rr (hl)
  inc hl
  rr (hl)
  inc hl
  rr (hl)
  inc hl
  rr (hl)
  inc hl
  rr (hl)
  inc hl
  inc hl
  inc hl
  inc hl    ;ahh what the hell.. big is beautiful :)
  inc hl
  djnz scrollrowleft
 ld hl,(scrlx)
 dec hl
 ld (scrlx),hl
 ld hl,(topleftblock)
 ld a,(topleftxbits)
 cp 11
 jr nz,notresetblockxleft
 ld a,-1
 dec l
 ld (topleftblock),hl
notresetblockxleft:
 inc a
 ld (topleftxbits),a
 ld a,$FE
 ld (setinstruc+3),a
 ld a,$BE
 ld (resinstruc+3),a
 ld ix,$FC00
 ld a,(topleftxbits)

fillcolumn:
 ld b,43h
 bit 3,a
 jr z,nothigh4
 dec b
 res 3,a
nothigh4:
 rlca
 rlca
 rlca
 add a,b
 ld (bitinstruc+1),a
 push hl
 call getmapblock
 call getspriteaddr
 ld b,0
 ld a,(topleftybits)
 ld c,a
 add hl,bc
 add hl,bc
 neg
 add a,12
 ld c,a
 ld a,(topleftxbits)
 ld b,a
dofillcolumn:
dothisblock:
   ld e,(hl)
   inc hl
   ld d,(hl)
   inc hl
bitinstruc:
   bit 0,d
   jr z,resetbit
setinstruc:
   set 7,(ix)
   jr donebit
resetbit:
resinstruc:
   res 7,(ix)
donebit:
   push bc
   ld bc,16
   add ix,bc
   pop bc
   jr c,columnisfull
   dec c
   jr nz,dothisblock
  ld c,12
  pop hl
  inc h
  push hl
  call getmapblock
  call getspriteaddr
  jr dofillcolumn
columnisfull:
 pop hl
 jp resetcontrast

upcontrast:
 ld a,(contrast)
 cp 31
 ret z
 inc a
 out (2),a
 ret

calculatescreenoffsets:
 ;Repton is drawn at (42,26) so calculate the
 ;top left block coords to ensure that (curpos) will
 ;occur at these coordinates:

 ld a,(curpos)
 sub 4
 ld l,a
 ld a,(curpos+1)
 sub 3
 ld h,a
 ld (topleftblock),hl
 
 ld hl,$0A06
 ld (topleftxbits),hl

 ld hl,(curpos)
 ld h,0
 call MulHLby12
 ld de,-42
 add hl,de
 ld (scrlx),hl

 ld hl,(curpos+1)
 ld h,0
 call MulHLby12
 ld de,-26
 add hl,de
 ld (scrly),hl
 ret

redrawscreen: 
 ld hl,(topleftblock)
 ld c,7
DrawY:
  push hl
  ld b,9
DrawX:
   call plotmapblock
   inc l
   djnz DrawX
  pop hl
  inc h
  dec c
  jr nz,DrawY
 ret

locatemap:
 push af
 ld hl,(curleveladdr)
 ld a,(curleveladdr+2)
 ld c,a
SkipLevelsName:
  call getbyte
  or a
  jr nz,SkipLevelsName
SkipLevelsAuthor:
  call getbyte
  or a
  jr nz,SkipLevelsAuthor
 pop af

 add a,a
 ld e,a
 xor a
 ld d,a
 add hl,de
 adc a,c
 ld c,a
 ld b,a
 push hl
 call getbyte
 ld e,a
 call getbyte
 ld d,a

 ld a,(curleveladdr+2)
 ld hl,(curleveladdr)
 add hl,de
 adc a,0
 ld c,a     ;(a,hl)->data
 pop de     ;(b,de)->pointer
 ret

getbyte:
 ld a,c
 push hl
 call CONV_ADDR
 pop hl
 push af
 ld a,c
 call NEXT_BYTE
 ld c,a
 ld a,$41
 out (6),a
 pop af
 ret

setbyte:
 push hl
 push af
 ld a,c
 call CONV_ADDR
 pop af
 ld (hl),a
 pop hl
 ld a,c
 call NEXT_BYTE
 ld c,a
 ld a,$41
 out (6),a
 ret

decodemapinfo:
 push af
 call locatemap
 pop af
 ld b,a
 add a,a
 add a,a
 add a,b
 add a,3
 ld d,a
 ld ix,mapinfo
 ld b,9
decodepwd:
  call getbyte
  xor d
  ld (ix),a
  ld a,7
  add a,d
  ld d,a
  inc ix
  djnz decodepwd
 ld b,20
storemapinfo:
  call getbyte
  ld (ix),a
  inc ix
  djnz storemapinfo
 ret

decodehiscores:
 ld a,(mapcnt)
 call locatemap
 ex de,hl
 ld c,b
 ld d,$FF
 ld ix,Hiscores
 ld b,140
dodecodehiscores:
  call getbyte
  xor d
  ld (ix),a
  inc ix
  ld a,d
  add a,-3
  ld d,a
  djnz dodecodehiscores
 ret

encodehiscores:
 ld a,(mapcnt)
 call locatemap
 ex de,hl
 ld c,b
 ld d,$FF
 ld ix,Hiscores
 ld b,140
doencodehiscores:
  ld a,(ix)
  xor d
  call setbyte
  inc ix
  ld a,d
  add a,-3
  ld d,a
  djnz doencodehiscores
 ret


decodegraphics:
 ld hl,ProgVar
 rst 20h
 rst 10h
 ld a,41h
 out (6),a
 jr c,nodefaultgfx
 ex de,hl
 ld a,b
 ld de,StandardChars-_asm_exec_ram+4
 add hl,de
 adc a,0
 ld c,a
 ld b,51
 call decodegfx
nodefaultgfx:
 ld a,(mapcnt)
 call locatemap
 ex de,hl
 ld a,b
 ld de,140
 add hl,de ;skip hiscores
 adc a,0
 ld c,a
decodegfx:
 ld de,Chars
 call getbyte
 cp 48
 ret nz
dodecodegfx:
 call getbyte
 ld b,a
 or a
 jr z,decodenextlist
decodecharlist:
  push bc
  ld b,6
decodechar:
  push bc
  call getbyte
  ld b,a
  srl a
  srl a
  srl a
  srl a
  inc de
  ld (de),a
  dec de
  sla b
  sla b
  sla b
  sla b
  call getbyte
  push af
  srl a
  srl a
  srl a
  srl a
  or b
  ld (de),a
  inc de
  inc de
  pop af
  and 15
  inc de
  ld (de),a
  dec de
  call getbyte
  ld (de),a
  inc de
  inc de
  ld a,c
  pop bc
  ld c,a
  djnz decodechar
 ld a,c
 pop bc
 ld c,a
 djnz decodecharlist
decodenextlist:
 call getbyte   ;get num chars to skip
 or a
 ret z
 ld b,a
 add a,a
 add a,b
 push hl
 ld l,a
 xor a
 ld h,a
 add hl,hl
 add hl,hl
 add hl,hl
 add hl,de
 ex de,hl
 pop hl
 jr dodecodegfx

showmap:
 call HideDrawing

 ld hl,0
 ld bc,$065F
 xor a
 call block
 ld hl,0
 ld (_penCol),hl
 ld hl,PassMsg
 call _vputs
 ld hl,_penCol
 inc (hl)
 ld hl,password
 call _vputs

 ld a,(mappable)
 or a
 jr z,candomap
 ld hl,$0700
 ld bc,$3F5F
 ld a,$55
 call block

 ld hl,$1E16
 ld bc,$2850
 call box3do

 ld hl,$0504
 ld (_curRow),hl
 ld hl,NoMapMsg
 call _puts

 call shredscreen
 res 2,(iy+$12)
 call _getkey
 set 2,(iy+$12)
 jr closemap
candomap:

 ld hl,-1
 call doshowmap
 call shredscreen
 ld hl,-1
maploop:
  ld a,$BF
  out (1),a
  in a,(1)
  bit 6,a
  jr z,closemap
  ld a,$FE
  out (1),a
  in a,(1)
  srl a
  jr c,notmapdown
  ld a,(mapheight)
  sub 9
  cp h
  jr z,maploop
  inc h
  call doshowmap
  jr maploop
notmapdown:
  srl a
  jr c,notmapleft
  ld a,-1
  cp l
  jr z,maploop
  dec l
  call doshowmap
  jr maploop
notmapleft:
  srl a
  jr c,notmapright
  ld a,(mapwidth)
  sub 15
  cp l
  jr z,maploop
  inc l
  call doshowmap
  jr maploop
notmapright:
  srl a
  jr c,notmapup
  ld a,-1
  cp h
  jr z,maploop
  dec h
  call doshowmap
notmapup:
  jr maploop
closemap:
 call HideDrawing
 call redrawscreen
 call shredscreen
 ret
doshowmap:
 push hl
 ld b,7
drawmapy:
  push hl
  ld c,0
drawmapx:
   push hl
   push bc
   call getmapblock
   and 63
   cp 32
   jr c,notinvismapspr
   ld a,31
notinvismapspr:
   call putsmlsprite
   pop bc
   pop hl
   inc l
   ld a,c
   add a,6
   ld c,a
   cp 96
   jr c,drawmapx
  pop hl
  inc h
  ld a,b
  add a,6
  ld b,a
  cp 64
  jr c,drawmapy
 pop hl
 ret

decodemap:
 call decodemapinfo

 ld (temp),hl

 ld a,48
 ld (timeleft),a
 ld hl,0
 ld (nexttick),hl
 ld (diamonds),hl
 ld (timebomb),hl
 xor a
 ld (monsters),a
 ld (levelcompleted),a
 inc a
 ld (safes),a
 ld hl,$0404
 ld (startpos),hl

 ld a,(mapheight)
 ld d,a
 ld ix,map
 xor a
 ld l,0
decodemaploop:
  push af
  ld a,(mapwidth)
  ld b,a
  pop af
  push ix
decodemaprow:
   sub 5
   jr nc,gotenoughbits
   ld e,l
   push af
   ld hl,(temp)
   call getbyte
   ld (temp),hl
   ld l,a
   ld h,0
   pop af
   add a,5
   push af
   push bc
   or a
   jr z,noadjust
   ld b,a
adjustnewhighbits:
    sla l
    rl h
    djnz adjustnewhighbits
noadjust:
   push de
   ld d,0
   add hl,de
   pop de
   pop bc
   pop af
   add a,3
gotenoughbits:
   push af
   ld a,l
   and 31
   ld (ix),a
   cp 14
   jr nz,notcrown
   ld a,1
   ld (crown),a
notcrown:
   cp 18            ;cage
   jr z,isdiamond   
   cp 23            ;safe
   jr z,isdiamond
   cp 30            ;diamond
   jr nz,notdiamond
isdiamond:
   push hl
   ld hl,(diamonds)
   inc hl
   ld (diamonds),hl
   pop hl
   jr notstartpos
notdiamond:
   cp 28
   jr nz,notegg
   ld a,(monsters)
   inc a
   ld (monsters),a
   jr notstartpos
notegg:
   cp 15
   jr nz,nottimebomb
   ld a,1
   ld (timebomb),a
nottimebomb:
   cp 17
   jr nz,notstartpos
   ld a,(mapwidth)
   sub b
   ld (startpos),a
   ld a,(mapheight)
   sub d
   ld (startpos+1),a
notstartpos:
   inc ix
   pop af
   srl h
   rr l
   srl h
   rr l
   srl h
   rr l
   srl h
   rr l
   srl h
   rr l
   dec b
   jp nz,decodemaprow
  pop ix
  push de
  ld de,32
  add ix,de
  pop de
  dec d
  jp nz,decodemaploop

 xor a
 ld (activeobjects1),a
 ld (activeobjects2),a
 ld (curobjlist),a

checkmapforactiveobjects:
 ld h,0
checkforactiveobjectsy:
  ld l,0
checkforactiveobjectsx:
   push hl
   call checkmapblock
   pop hl
   inc l
   ld a,(mapwidth)
   cp l
   jr nz,checkforactiveobjectsx
  inc h
  ld a,(mapheight)
  cp h
 jr nz,checkforactiveobjectsy
 ret

unlocksafes:
 ld a,(safes)
 or a
 ret z
 xor a
 ld (safes),a
 ld hl,map
 ld a,23
 ld bc,1024
findsafes:
  cpir
  jr nz,doneallsafes
  dec hl
  ld (hl),30
  inc hl
  jr findsafes
doneallsafes:
 call redrawscreen
 ret

moverepton:
 push hl
 ld hl,(curpos)
 ld a,31
 call setmapblock
 ex (sp),hl
 ld (curpos),hl
 call getmapblock
 and 63
 cp 27
 jr nz,notkey
 im 1
 call unlocksafes
 call checkmapforactiveobjects
 im 2
 jr domoverepton
notkey:
 cp 16
 jr z,reptonwillDIE	;buahahahaha! >:D
 cp 21
 jr z,reptonwillDIE
 cp 22
 jr z,reptonwillDIE
 cp 181
 jr nz,reptonwontdie
reptonwillDIE:
 ld a,1
 ld (deathflag),a
 pop hl
 ret
reptonwontdie:
 cp 30
 jr nz,noteatendiamond
 ld hl,(diamonds)
 dec hl
 ld (diamonds),hl
 call writenumdiamonds
 ld a,5
 call increasescore
 jr domoverepton
noteatendiamond:
 cp 14
 jr nz,noteatencrown
 xor a
 ld (crown),a
 call writenumdiamonds
 ld a,50
 call increasescore
 jr domoverepton
noteatencrown:
 cp 26
 jr nz,nottransporter
 call transportrepton
nottransporter:
 cp 20
 jr nz,nottimepill
 call resettime
nottimepill:
 cp 15
 jr nz,noteatentimebomb
 xor a
 ld (timebomb),a
 call writenumdiamonds
noteatentimebomb:
domoverepton:
 ld hl,(curpos)
 ld a,$5F
 call setmapblock
 pop hl

checkmaparea:
 dec h
 dec l
 call checkmapblock  ; -1,-1
 inc l
 call checkmapblock  ;  0,-1
 inc l
 call checkmapblock  ;  1,-1
 inc h               
 call checkmapblock  ;  1, 0
 dec l
 call checkmapblock  ;  0, 0
 dec l
 call checkmapblock  ; -1, 0
 inc h
 call checkmapblock  ; -1, 1
 inc l
 call checkmapblock  ;  0, 1
 inc l
                     ;  1, 1
checkmapblock:
 call getmapblock
 cp 29               ;boulder
 jr z,foundboulder
 cp 28               ;egg (uses same drop checking code)
 jr z,foundboulder
 cp 22
 jr z,foundspirit
; cp 21
; jr z,foundfungus
 ret

foundboulder:
 push hl
 call canboulderfall
 pop hl
 ld de,0
 call z,addandmarkactiveobject
 ret

foundspirit:
 ld a,$1F 
 call setmapblock
 ld de,$C108
 push hl
 dec h  ;(0,-1)
 call checkblockforspirit
 jr nz,gotspiritstartdir
 inc d
 inc h
 inc l  ;(1,0)
 call checkblockforspirit
 jr nz,gotspiritstartdir
 inc d
 dec l
 inc h  ;(0,1)
 call checkblockforspirit
 jr nz,gotspiritstartdir
 ld d,$C0
 dec l
 dec h  ;(-1,0)
 call checkblockforspirit
 jr nz,gotspiritstartdir
 ld d,$C3 ;3=left but it is decremented & spirit will start goin' down
gotspiritstartdir:
 pop hl
 call addactiveobject
 ret

foundfungus:
 push hl
 call checkiffungusislive
 pop hl
 ret nz
 ld d,10
 call addandmarkactiveobject
 ret

checkiffungusislive:
 dec l
 call checkblockforfungus
 ret z
 inc l
 inc h
 call checkblockforfungus
 ret z
 dec h
 inc l
 call checkblockforfungus
 ret z
 dec l
 dec h
 call checkblockforfungus
 ret

checkblockforspirit:
 call checkblockformonster
 ret z
 call getmapblock
 cp 18 ;cage
 ret nz
 set 7,a
 call setmapblock
 cp a
 ret

checkblockforfungus:
checkblockformonster:
 call getmapblock
 bit 6,a
 jr z,notrepton
 cp a
 ret
notrepton:
 and 63
 cp 24 ;earth 1
 ret z
 cp 25 ;earth 2
 ret z
 cp 22 ;spirit (not yet activated)
 ret z
 cp 31 ;space
 ret

addandmarkactiveobject:
 call getmapblock
 set 7,a
 call setmapblock       ;mark as active
addactiveobject:
 push hl
 push de
 ld b,h
 ld c,l
 ld hl,activeobjects1
 ld a,(curobjlist)
 or a
 jr z,uselist1
 ld hl,activeobjects2
uselist1:
 ld a,(hl)
; cp maxobjects
; jr nz,nothitmax
; pop hl
; pop de
; scf
; ret 
;nothitmax:
 inc (hl)
 inc hl
 ld e,a
 ld d,0
 add hl,de
 add hl,de
 add hl,de
 add hl,de
 pop de
 ld (hl),c
 inc hl
 ld (hl),b
 inc hl
 ld (hl),e
 inc hl
 ld (hl),d
 pop hl
 or a   ;cf=0
 ret

canboulderfall:
 ld a,-1
 ld e,0
moveboulder:
 ld b,h
 ld c,l
 call tryrock
 jr z,notaduffrock
 ld h,b
 ld l,c
 call getmapblock
 res 7,a
 call setmapblock
 or a
 ret
notaduffrock:
 cp -1
 ret z  ;a=-1 for a 'canboulderfall' test
 set 7,a
 call setmapblock
 call plotmapblock
 push hl
 ld h,b
 ld l,c
 ld a,31
 call setmapblock
 call plotmapblock
 pop hl
 cp a
 ret
tryrock:
 ld d,a
 inc h
 call getmapblock
 cp 31
 jp z,domoveboulder
 bit 6,a
 jr nz,domoveboulderontorepton
 res 7,e
 dec h
 cp 0
 jr z,moveboulderonleftslope
 cp 9
 jr nz,movebouldernotonleftslope
moveboulderonleftslope:
 dec l
 call getmapblock
 cp 31
 ret nz
 inc h
 jp testblockforrock
movebouldernotonleftslope:
 cp 1
 jr z,moveboulderonrightslope
 cp 10
 jr nz,movebouldernotonrightslope
moveboulderonrightslope:
 inc l
 call getmapblock
 cp 31
 ret nz
 inc h
 jp testblockforrock
movebouldernotonrightslope:
 cp 16
 jr z,moveboulderrounded
 cp 20
 jr z,moveboulderrounded
 cp 15
 jr z,moveboulderrounded
 cp 14
 jr z,moveboulderrounded
 cp 32
 ret nc ;it won't be 32 so z=0 
 cp 27
 ret c  ;z=0 if c=1
moveboulderrounded:
 dec l
 call getmapblock
 cp 31
 jr nz,movebouldercantfallleft
 inc h
 call getmapblock
 cp 31
 jr z,domoveboulder
 dec h
movebouldercantfallleft:
 inc l
 inc l
 call getmapblock
 cp 31
 ret nz
 inc h
 call getmapblock
 jr testblockforrock
domoveboulderontorepton:
 bit 7,e
 jr nz,cankillrepton
 or a
 ret
cankillrepton:
 ld a,1
 ld (deathflag),a
domoveboulder:
 set 7,e
 inc h
 call getmapblock
 dec h
 bit 6,a
 jr z,bonkwontkillrepton
 push af
 ld a,1
 ld (deathflag),a
 pop af
bonkwontkillrepton:
 cp 31
 jr z,dontcrackegg
 ld a,d
 and 63
 cp 28
 jr nz,dontcrackegg

 ld de,$AF19      ;cwacked egg! hatching time approx 1.5 seconds
dontcrackegg:
 ld a,d
 ld d,0
 cp a
 ret

testblockforrock:
 call getmapblock
 bit 6,a
 jr nz,domoveboulderontorepton
 cp 31
 jr z,domoveboulder
 ret

adjustHLfordir:
 and 3
 jr nz,notadjustup
 dec h
notadjustup:
 dec a
 jr nz,notadjustright
 inc l
notadjustright:
 dec a
 jr nz,notadjustdown
 inc h
notadjustdown:
 dec a
 ret nz
 dec l
 ret

movespirit:
 call plotmapblock
 call getmapblock
 bit 6,a
 jr z,notspiriteatrepton
 ld a,1
 ld (deathflag),a
notspiriteatrepton:
 inc e
 inc e
 inc e
 inc e
 ld a,e
 cp 12
 jr nz,domovespirit
 bit 7,d
 jr nz,spiritisstuck
; call getmapblock
; res 6,a            
; call setmapblock
 ld a,d
 call adjustHLfordir ;move to new square
 call getmapblock
 and 63
 cp 18
 jr nz,notcage
 ld a,30
 call setmapblock
 call plotmapblock
 call checkmaparea
 ld a,1
 or a   ;z=0
 ret
notcage:
spiritisstuck:
 ld e,0
 ld b,4     ;check all four directions
 ld a,d
 dec a
 and 3
 ld d,a     ;check wall to the left
findnewspiritdir:
  push hl
  ld a,d
  call adjustHLfordir       
  call checkblockforspirit
  pop hl
  jr z,gotnewspiritdir
  ld a,d
  inc a
  and 3
  ld d,a
  djnz findnewspiritdir
 set 7,d
 jr domovespirit
gotnewspiritdir:
 push hl
 call adjustHLfordir
; call getmapblock
; set 6,a            ;set next block as fatal
; call setmapblock
 pop hl
domovespirit:
 push de
 push hl
 push de
 call getmapblockcoords
 pop de
 jr c,dontplotspirit
 ld a,d
 call adjustspritecoords
 jr c,dontplotspirit
 ld a,e
 cp 6
 ld a,22
 jr c,nototherspiritanim
 ld a,42
nototherspiritanim:
 call putsprite
dontplotspirit:
 pop hl
 pop de
 set 6,d
 cp a   ;z=1
 ret

crackegg:
 dec e
 jr z,egghascracked
 cp a
 ret
egghascracked:
 ld a,31
 call setmapblock   
 call plotmapblock
 ld de,$A009
 cp a
 ret

adjustspritecoords:
 and $83
 jr nz,dontadjustup
 ld a,b
 sub e
 ld b,a
 jr gotadjustedcoords
dontadjustup:
 dec a
 jr nz,dontadjustright
 ld a,c
 add a,e
 ld c,a
 jr gotadjustedcoords
dontadjustright:
 dec a
 jr nz,dontadjustdown
 ld a,b
 add a,e
 ld b,a
 jr gotadjustedcoords
dontadjustdown:
 dec a
 jr nz,gotadjustedcoords
 ld a,c
 sub e
 ld c,a
gotadjustedcoords:
 ld a,c
 add a,11
 cp 107
 ccf
 ret c
 ld a,b
 add a,11
 cp 75
 ccf
 ret

movemonster:
 call plotmapblock
 call getmapblock
 bit 6,a
 jr z,reptonnotdevoured
 ld a,1
 ld (deathflag),a
 jr monsternotdead
reptonnotdevoured:
 call checkblockformonster
 jr z,monsternotdead
 call adjustHLfordir
 call plotmapblock
 ld hl,monsters
 dec (hl)
 call writenumdiamonds
 ld a,20
 call increasescore
 ld a,1
 or a
 ret
monsternotdead:
; inc e
 inc e
 inc e
 inc e
 ld a,e
 cp 12
 jr nz,domovemonster
 bit 7,d
 jr nz,monsterisstuck
 ld a,d
 call adjustHLfordir ;move to new square
monsterisstuck:
 ld e,0
 ld a,(curpos)
 cp l
 jr z,trymonstervert
 ld a,(curpos+1)
 cp h
 jr z,dotrymonsterhoriz
 call random
 bit 3,a
 jr z,trymonstervert
dotrymonsterhoriz:
 call trymonsterhoriz
 jr z,gotnewmonsterdir
trymonstervert:
 ld a,(curpos+1)
 cp h
 ld d,2
 jr nc,dontmoveup
 ld d,0
dontmoveup:
 call checknewmonsterdir
 jr z,gotnewmonsterdir
 call trymonsterhoriz
 jr z,gotnewmonsterdir
 set 7,d
gotnewmonsterdir:
domovemonster:
 push de
 push hl
 push de
 call getmapblockcoords
 pop de
 jr c,dontplotmonster
 ld a,d
 call adjustspritecoords
 jr c,dontplotmonster
 ld a,e
 cp 6
 ld a,45
 jr c,notothermonsteranim
 ld a,46
notothermonsteranim:
 call putsprite
dontplotmonster:
 pop hl
 pop de
 set 5,d
 cp a   ;z=1
 ret

trymonsterhoriz:
 ld a,(curpos)
 cp l
 ld d,1
 jr nc,dontmoveleft
 ld d,3
dontmoveleft:

checknewmonsterdir:
 push hl
 ld a,d
 call adjustHLfordir
 call checkblockformonster
 pop hl
 ret

random:
 push hl
 push de
 ld hl,(randomseed)
 rl l
 rl h
 rl l
 rl h
 rl l
 rl h
 xor l
 ld l,a
 ld a,(timer)
 xor h
 ld h,a
 ld de,54235
 add hl,de
 ld (randomseed),hl
 ld a,l
 pop de
 pop hl
 ret
randomseed:
 .dw 13423

movefungus:
 dec d
 jr z,checkfungustime
 cp a
 ret
checkfungustime:
 ld d,10
 call random
 cp 10
 jr c,domovefungus
 cp a
 ret
domovefungus:
 call random
findfungusdir:
  inc a
  and 3
  ld d,a
  push hl
  call adjustHLfordir
  call checkblockforfungus
  pop hl
  ld a,d
  jr nz,findfungusdir
 push hl
 call adjustHLfordir
 ld a,21
 call setmapblock
 call plotmapblock
 call checkmapblock
 pop hl
 push hl
 call checkiffungusislive
 pop hl
 ret z
 ld a,21
 call setmapblock
 or a
 ret        

updateactiveobjects:
 ld a,(curobjlist)
 ld ix,activeobjects1
 ld hl,activeobjects2
 or a
 jr z,updatelist1
 ld ix,activeobjects2
 ld hl,activeobjects1
updatelist1:
 xor 1
 ld (curobjlist),a
 ld a,(ix)
 or a
 ret z
 ld b,a
 ld (ix),0  ;NOT NEEDED?
 ld (hl),0  ;clear the other list
 inc ix
processobjects:
  push bc
  push ix
  ld l,(ix)
  ld h,(ix+1)
  ld e,(ix+2)
  ld d,(ix+3)
  push hl
  call getmapblock
  bit 6,d
  jr z,notfoundaspirit
  call movespirit
  jr processedobj
notfoundaspirit:
  bit 5,d
  jr z,notfoundamonster
  call movemonster
  jr processedobj
notfoundamonster:
  cp $95
  jr nz,notfoundfungus
  call movefungus
  jr processedobj
notfoundfungus:
  cp $9C
  jr z,foundanegg
  cp $9D
  jr nz,notfoundaboulder
foundanegg:
  call moveboulder
  jr processedobj
notfoundaboulder:
  cp $AF
  jr nz,notfoundahatchingegg
  call crackegg
  jr processedobj
notfoundahatchingegg:
processedobj:
  jr nz,deleteobject
  call addactiveobject
  call checkmaparea
  pop hl
  call checkmaparea
  jr dontdelete
deleteobject:
  pop hl
;  call getmapblock
;  and 63
;  call setmapblock
dontdelete:
  pop ix
  pop bc
  inc ix
  inc ix
  inc ix
  inc ix
  djnz processobjects
 ret

getmapblock:    ;hl=yx
 ld a,(mapwidth)
 dec a
 cp l
 jr c,invalidblock
 ld a,(mapheight)
 dec a
 cp h
 jr nc,validblock
invalidblock:
 ld a,8
 ret
validblock:
 push de
 push hl
 rl l
 rl l
 rl l
 srl h
 rr l
 srl h
 rr l
 srl h
 rr l
 ld de,map
 add hl,de
 ld a,(hl)
 pop hl
 pop de
 ret

setmapblock:
 push hl
 push de
 rl l
 rl l
 rl l
 srl h
 rr l
 srl h
 rr l
 srl h
 rr l
 ld de,map
 add hl,de
 ld (hl),a
 pop de
 pop hl
 ret

plotmapblock:
 push bc
 push de
 push hl
 call getmapblockcoords
 pop hl
 jr c,abortplot
 call getmapblock
 push hl
 call putsprite
 pop hl
abortplot:
 pop de
 pop bc
 ret

getmapblockcoords:  ;find screen coords of given map block, HL
 ld a,l
 ld l,h
 ld h,0
 bit 7,l
 jr z,notnegyplot
 dec h
notnegyplot:
 add hl,hl
 add hl,hl
 ld d,h
 ld e,l
 add hl,hl
 add hl,de
 ld de,(scrly)
 or a
 sbc hl,de
 ld b,l
 ld de,11
 add hl,de
 ld de,75
 or a
 sbc hl,de
 ccf
 ret c
 ld l,a
 ld h,0
 bit 7,l
 jr z,notnegxplot
 dec h
notnegxplot:
 add hl,hl
 add hl,hl
 ld d,h
 ld e,l
 add hl,hl
 add hl,de
 ld de,(scrlx)
 or a
 sbc hl,de
 ld c,l
 ld de,11
 add hl,de
 ld de,107
 or a
 sbc hl,de
 ccf
 ret

transportrepton:
 im 1
 ld hl,(curpos)
 ld a,31
 call setmapblock   ;remove transporter
 push hl
 call checkmaparea
 pop hl
 ld ix,transporters
 ld b,4
findtransporter:
  ld a,(ix)
  cp l
  jr nz,checknexttransporter
  ld a,(ix+1)
  cp h
  jr nz,checknexttransporter
  ld l,(ix+2)
  ld h,(ix+3)
  ld (curpos),hl
  ld (startpos),hl
  call calculatescreenoffsets

  ld a,(curanim)
  ld bc,$1A2A
  call putsprite
  call HideDrawing
  call redrawscreen
  ld a,(curanim)
  ld bc,$1A2A
  call putsprite
  call shredscreen
  im 2
  ret
checknexttransporter:
  ld de,4
  add ix,de
  djnz findtransporter
 ret


repstosb:
 push hl
 ld (de),a
 dec bc
 ld h,d
 ld l,e
 inc de
 ldir
 pop hl
 ret

checkifmapblockempty:
 push af
 call getmapblock
 and 63
 cp 15
 jr nz,nothittimebomb
 ld a,(crown)
 or a
 jr nz,blocknotokay
 push hl
 ld hl,(diamonds)
 ld de,0
 sbc hl,de
 pop hl
 jr nz,blocknotokay
 ld a,(monsters)
 or a
 jr nz,blocknotokay
 jr blockokay
nothittimebomb:
 cp 14
 jr z,blockokay
 cp 16
 jr z,blockokay
 cp 20
 jr z,blockokay
 cp 21
 jr z,blockokay
 cp 22
 jr z,blockokay
 cp 24
 jr z,blockokay
 cp 25
 jr z,blockokay
 cp 26
 jr z,blockokay
 cp 27
 jr z,blockokay
 cp 28
 jr z,pushboulder
 cp 29
 jr z,pushboulder
 cp 30
 jr z,blockokay
 cp 31
 jr z,blockokay
blocknotokay:
 pop af
 scf
 ret
pushboulder:
 ld e,a
 ld a,(curpos)
 cp l
 jr z,blocknotokay
 push hl
 jr c,pushright
 dec l
 dec l
pushright:
 inc l
 call getmapblock
 cp 31
 jr z,canpushboulder
 pop hl
 jr blocknotokay
canpushboulder:
 ld a,e
 call setmapblock
 call plotmapblock
 pop hl
 push hl
 ld a,$5F
 call setmapblock
 call plotmapblock
 call checkmaparea
 pop hl
blockokay:

 call getmapblock
 set 6,a
 call setmapblock

 pop af
 or a
 ret

HideDrawing:
 ld hl,screenhidden
 bit 0,(hl)
 ret nz
 set 0,(hl)
 ld hl,$FC00
 ld de,screenbuffer
 ld bc,$400
 ldir
 ld a,(screenbuffer/$100)-$C0
 out (0),a
 ret

shredscreen:    ;transition/screen clear effect (coooooool... :)
 ld e,4
doshred:
  ld c,16
  ld ix,$FC00
  ld hl,screenbuffer
shredrows:
  ld b,32
shredrow:
   ld a,(ix)
   rl a
   rl a
   rl a
   rl a
   ld d,a
   ld a,(hl)
   rr a
   and 240
   rl d
   ld d,a
   ld a,(hl)
   rl a
   and 15
   or d
   ld (hl),a

   ld a,(ix)
   srl a
   and 112
   ld d,a
   ld a,(ix)
   sla a
   and 14
   or d
   ld (ix),a

   inc ix
   inc hl
   djnz shredrow

  ld b,32
shredrow2:
   ld a,(ix)
   sla a
   sla a
   sla a
   and 8
   ld d,a
   ld a,(hl)
   srl a
   and 7
   or d
   ld d,a

   ld a,(ix)
   srl a
   srl a
   srl a
   and 16
   or d
   ld d,a

   ld a,(hl)
   sla a
   and 224
   or d
   ld (hl),a

   ld a,(ix)
   srl a
   and 7
   ld d,a
   ld a,(ix)
   sla a
   and 224
   or d
   ld (ix),a

   inc ix
   inc hl
   djnz shredrow2

   dec c
   jr nz,shredrows
  ld b,16
shredpause:
   halt
   djnz shredpause
  dec e
  jp nz,doshred

 ld hl,screenhidden
 bit 0,(hl)
 ret z
 ld de,$FC00
 ld hl,screenbuffer
 ld bc,$400
 ldir
ShowDrawing:
 ld hl,screenhidden
 res 0,(hl)
 ld a,$3C
 out (0),a
 ret

;boxscreen:
; ld hl,$0000
; ld bc,$3F7F
;Cheaps:
;  push hl
;  push bc
;  xor a
;  call rect
;  halt
;  halt
;  halt
;  halt
;  pop bc
;  pop hl
;  inc h
;  inc l
;  dec b
;  dec c
;  ld a,h
;  cp $20
;  jr nz,Cheaps
; ret

DrawReptonWindow:
 ld b,8
 ld hl,$FC00 ;(screenoffset)
 ld de,$16
 add hl,de
 ex de,hl
 ld hl,SideTitlePic
Titlebartext:
  ldi
  ldi
  ldi
  ldi
  ld a,e
  add a,12
  ld e,a
  djnz Titlebartext
; ld hl,$0700
; ld (_curRow),hl
; ld hl,TitleMsg
; call _puts

 ld hl,$016C
 ld (_penCol),hl
 ld hl,VerMsg
 call _vputs

 ld hl,$FC00 ;(screenoffset)
 ld de,$90
 add hl,de
 ld c,8
inverttitley:
 ld b,16
inverttitle:
  dec hl
  ld a,(hl)
  cpl
  ld (hl),a
  djnz inverttitle
 srl a
 ld (hl),a
 dec c
 jr nz,inverttitley

 ld hl,$0001
 ld bc,$3E7E
 call box3d
 ret

SelectLevel:
 call HideDrawing
 xor a
 ld (topmenuitem),a
 ld (currentlevel),a

 ld hl,$0A03
 ld bc,$3C7C
 xor a
 call block

 ld hl,$0903
 ld (_penCol),hl
 ld hl,SelectMsg
 call _vputs

 ld hl,$3703
 ld (_penCol),hl
 ld hl,SelectHelpMsg
 call _vputs

 ld hl,$1003
 ld bc,$367C
 ld a,$FF
 call rect

 ld a,(levelcnt)
 cp 0
 jr nz,Not0levels

 ld hl,$0104
 ld (_curRow),hl
 ld hl,NoLevelsMsg
 call _puts
 call shredscreen
 call _getkey
 jp abortlevelselect
Not0levels:

 cp 7
 jr c,NoMoreThan6
 ld hl,$2F74
 ld (_penCol),hl
 ld hl,DownArrow
 call _vputs
 ld a,6
NoMoreThan6:
 ld b,a
 ld hl,$1105
 xor a
ShowLevels:
  push af
  push bc
  push hl
  ld (_penCol),hl
  call WriteLevelName
  pop hl
  pop bc
  ld a,6
  add a,h
  ld h,a
  pop af
  inc a
  djnz ShowLevels

 call shredscreen

Rehighlight:
 call HighlightMenuitem
WaitForSelectKey:
  call _getkey ;GET_KEY
  cp kExit ;K_EXIT
  jp z,abortlevelselect
  cp kUp ;K_UP
  jr nz,notuparrow
  ld a,(currentlevel)
  or a
  jr z,WaitForSelectKey
  call HighlightMenuitem
  ld a,(topmenuitem)
  ld b,a
  ld a,(currentlevel)
  dec a
  ld (currentlevel),a
  cp b
  jr nc,Rehighlight
  ld a,b
  dec a
  ld (topmenuitem),a

  ld hl,$1174
  ld bc,$167B
  xor a
  call block
  ld hl,$FEEF
  ld de,$FF4F
  ld bc,$1E0
  lddr
  ld hl,$1104
  ld bc,$167B
  xor a
  call block
  ld a,(topmenuitem)
  or a
  jr z,nouparrow
  ld hl,$1174
  ld (_penCol),hl
  ld hl,UpArrow
  call _vputs
nouparrow:
  ld hl,$2F74
  ld (_penCol),hl
  ld hl,DownArrow
  call _vputs
  ld a,(topmenuitem)
  ld hl,$1105
  ld (_penCol),hl
  call WriteLevelName
  jp Rehighlight
notuparrow:
  cp kDown ;K_DOWN
  jp nz,notdownarrow
  ld a,(levelcnt)
  dec a
  ld b,a
  ld a,(currentlevel)
  cp b
  jp z,WaitForSelectKey
  call HighlightMenuitem
  ld a,(currentlevel)
  inc a
  ld (currentlevel),a
  ld b,a
  ld a,(topmenuitem)
  add a,5
  cp b
  jp nc,Rehighlight
  sub 4
  ld (topmenuitem),a
  ld hl,$2F74
  ld bc,$357B
  xor a
  call block
  ld hl,$FD70
  ld de,$FD10
  ld bc,$1E0
  ldir
  ld hl,$2F04
  ld bc,$357B
  xor a
  call block
  ld a,(topmenuitem)
  ld b,a
  ld a,(levelcnt)
  sub 6
  cp b
  jr z,nodownarrow
  ld hl,$2F74
  ld (_penCol),hl
  ld hl,DownArrow
  call _vputs
nodownarrow:
  ld hl,$1174
  ld (_penCol),hl
  ld hl,UpArrow
  call _vputs
  ld a,(topmenuitem)
  add a,5
  ld hl,$2F05
  ld (_penCol),hl
  call WriteLevelName
  jp Rehighlight
notdownarrow:

;  cp kSecond ;K_SECOND
;  jr z,levelselected
  cp kEnter ;K_ENTER
  jr z,levelselected
  cp kClear ;K_CLEAR
  jp nz,WaitForSelectKey

levelselected:
 ld a,(currentlevel)
 call StoreLevelName
 call decodegraphics
 call decodehiscores
 or a
 ret
abortlevelselect:
 scf
 ret

StoreLevelName:
 ld b,a
 add a,a
 add a,b
 ld c,a
 ld b,0
 ld hl,leveladdresses
 add hl,bc
 ld e,(hl)
 inc hl
 ld d,(hl)
 inc hl
 ld c,(hl)
 ld l,e
 ld h,d
 ld a,c
 ld (curleveladdr),hl
 ld (curleveladdr+2),a
 call getbyte
 call getbyte
 call getbyte
 ld (mapcnt),a
 ld de,levelname
 ld b,60
copylevelname:
  call getbyte
  ld (de),a
  inc de
  djnz copylevelname
 ret

WriteLevelName:
 call StoreLevelName
 ld hl,levelname
 call _vputs
 ret

HighlightMenuitem:
 ld h,0
 ld a,(topmenuitem)
 ld b,a
 ld a,(currentlevel)
 sub b
 ret c
 cp 6
 ret nc
 add a,a
 ld b,a
 add a,a
 add a,b
 add a,$11
 ld l,4
 ld c,$7B
 ld h,a
 add a,6
 ld b,a
 call xorblock
 ret

CountLevels:
 ld ix,leveladdresses
 xor a
 ld (levelcnt),a
 call SWAP_RAM7
 ld hl,$BFFF
SearchVariables:
  ld de,(VAT_END)
  inc de
  or a
  sbc hl,de
  jr c,NoMoreVariables
  add hl,de
  ld a,(hl)
  cp 12
  jr nz,NotString
  push hl
  dec hl
  ld c,(hl)
  dec hl
  ld b,(hl)
  dec hl
  ld a,(hl)
  ld h,b
  ld l,c
  call NEXT_BYTE
  call NEXT_BYTE ;skip over string length
  ld c,a
  push hl
  CALL CONV_ADDR ;& get byte
  pop hl 
  cp $86          ;check signature byte
  jr nz,NotLevel
  ld a,c
  call NEXT_BYTE
  push hl
  CALL CONV_ADDR 
  pop hl
  cp $19          ;high sig byte.. sig=$1986
  jr nz,NotLevel
  ld a,$41
  out (6),a
  ld a,c
  ld de,1
  or a
  sbc hl,de
  sbc a,0
  ld (ix),l
  inc ix
  ld (ix),h
  inc ix
  ld (ix),a
  inc ix
  ld hl,levelcnt
  inc (hl)
NotLevel:
  pop hl
  call SWAP_RAM7
NotString:
  ld de,-5
  add hl,de
  ld e,(hl)
  ld d,0
  or a
  sbc hl,de
  dec hl
  jp SearchVariables
NoMoreVariables:
 ld a,$41
 out (6),a
 ret

decreasetime:
 ld a,(timeleft)
 or a
 jr nz,nottimeout
 ld a,1
 ld (deathflag),a
nottimeout:
 dec a
 ld (timeleft),a
 neg
 add a,$3A
 ld h,a
 ld l,$64
 ld c,$65
 xor a
 call horizline
 ret

resettime:
 ld a,48
 ld (timeleft),a
 ld hl,0
 ld (nexttick),hl
 ld hl,$0A63
 ld bc,$3C66
 ld a,255
 call block
 ret

updatesidebar:
 ld de,$FC0C
 ld hl,SideTitlePic
 ld b,8
DrawSideTitleY:
  ldi
  ldi
  ldi
  ldi
  ld a,e
  add a,12
  ld e,a
  djnz DrawSideTitleY

 ld hl,$0861
 ld bc,$3E7E
 call box3d

 ld hl,$0A63
 ld bc,$3C66
 ld a,255
 call block

 xor a
 ld (endofscrmsg),a
 ld hl,$0A69
 ld (_penCol),hl
 ld hl,Sidescrmsg
 call _vputs

 ld hl,$0A68
 ld bc,$107C
 call xorblock

 ld hl,$1168
 ld (_penCol),hl
 ld hl,ScoreMsg
 call _vputs


; ld hl,$2E69
; ld (_penCol),hl
; ld hl,LivesMsg
; call _vputs

; ld hl,$2D68
; ld bc,$337C
; call xorblock

 ld a,(lives)
 ld c,a
 ld de,$FF5D
ShowLives:
  push de
  ld b,8
  ld hl,LifePic
CopyLifePic:
   ld a,(de)
   or (hl)
   ld (de),a
   ld a,e
   add a,16
   ld e,a
   inc hl
   djnz CopyLifePic
  pop de
  inc de
  dec c
  jr nz,ShowLives

 ld bc,$1F6B
 ld a,30
 call putsprite
 xor a
 call increasescore

writenumdiamonds:
 ld hl,$2B68
 ld bc,$307C
 xor a
 call block
 ld hl,(diamonds)
 ld de,0
 sbc hl,de
 jr nz,notnodiamondsleft
 ld a,(timebomb)
 or a
 jr z,discountmonsters
 ld a,(monsters)
 or a
 jr z,discountmonsters
 ld bc,$1F6B
 ld a,45
 call putsprite
 ld hl,(monsters)
 ld h,0
 ld bc,$2B78
 jr putnum

discountmonsters:
 ld a,(crown)
 or a
 jr z,nocrownleft
 ld bc,$1F6B
 ld a,14
 call putsprite
 ret
nocrownleft:
 ld bc,$1F6B
 ld a,15
 call putsprite
 ld a,(timebomb)
 or a
 ret nz
 ld a,1
 ld (levelcompleted),a
 ret
notnodiamondsleft:
 ld bc,$2B78
 call putnum
 ret

increasescore:
 ld d,0
 ld e,a
 push de

 ld hl,$1768
 ld bc,$1C7C
 xor a
 call block

 ld hl,(score)
 pop de
 add hl,de
 ld (score),hl

 ld bc,$177A

putnum:
 push bc
 call storedigits
 ld a,c
 add a,a
 add a,a
 pop hl
 neg
 add a,l
 dec a
 ld l,a
 ld (_penCol),hl
 ld h,d
 ld l,e
 dec hl
 ld a,32
 ld (hl),a
 call _vputs
 ret

storedigits:
 ld de,digitbuffer
 xor a
 ld (de),a
 ld c,0
storedigitloop:
  dec de
  call UNPACK_HL
  add a,48
  ld (de),a
  inc c
;  inc hl
;  jr z,negativedigit
;  dec hl
;  jr nz,storedigitloop
  push de
  ld de,0
  or a
  sbc hl,de
  pop de
  jr nz,storedigitloop
 ret
;negativedigit:
; dec de
; ld a,'-'
; ld (de),a
; inc c
; ret

IHandler:
 ex af,af'
 exx
 ld hl,(timer)
 inc h
 inc l
 ld (timer),hl
 jp $3A
IHandlerEnd:

contrastdelay:
 .db 0

TitleMsg:
 .db "Repton!",0
VerMsg:
 .db "v0.9",Lbeta,0
StartMsg:
 .db "by Matthew Shepcar",0
EmailAddy:
 .db "<scabby@warzone.com>",0

SelectMsg:
 .db "Choose Screens:",0
SelectHelpMsg:
 .db 6,"  ",7," -move     "
 .db "ENTER-select     "
 .db "EXIT-quit",0
NoLevelsMsg:
 .db "No screens detected",0
UpArrow:
 .db 6,0
DownArrow:
 .db 7,0

PlayMsg:
 .db "Start",0
ScreensMsg:
 .db "Screens",0
EnterPwdMsg:
 .db "Enter "
PwdMsg:
 .db "Password",0
QuitMsg:
 .db "Quit",0

PassMsg:
 .db "Password:",0
PauseMsg:
 .db "- Paused -",0
ContrastMsg:
 .db 6,"  ",7,"  - Contrast",0
OffMsg:
 .db "ON - Power off",0
MapMsg:
 .db "F1 - Map",0
KillMsg:
 .db "F4 - Suicide",0
EndGameMsg:
 .db "F5 - End Game",0
ReturnMsg:
 .db "EXIT - Return to Game",0

ScrMsg:
 .db "- "
Sidescrmsg:
 .db "Map "
scrmsgletter:
 .db "A"
endofscrmsg:
 .db " -",0
MismatchMsg:
 .db "- Nope! -",0
NoMapMsg:
 .db "No Map!",0

GameOverMsg:
 .db "Game Over",0

ScoreMsg:
 .db "Score:",0
;LivesMsg:
; .db "Lives:",0
LifePic:
 .db %01110000
 .db %01110000
 .db %00100000
 .db %10001000
 .db %10001000
 .db %00000000
 .db %01010000
 .db %01010000

;maxobjectshitmsg:  
; .db "ERROR: Object lists  "
; .db "full!",0

congratmsg:
 .db "Congratulations!!",0
completedmsg:
 .db "You completed",0
tryagainmsg:
 .db "Now try without "
 .db "passwords!",0

NewHiscoreMsg:
 .db "High score!  Enter name:",0

ProgVar:
 .db $12
 .db 6,"repton"     ;the program _must_ be called this! :)
TitleVar:
 .db $0C
 .db 8,"reptitle"
timer:
 .dw 0

#include sidetitl.inc
;#include titlepic.inc
#include mapchars.inc
screenbuffer    =(($-1) | 255)+1   ;1024 byte buffer
#include chars.inc
end             =screenbuffer+1024

origscreen      =$9000
map             =$9400
Chars           =$9800
Hiscores        =$9CC8
endmessage      =$9D2C
origtextshadow  =$9D54
varspace        =$9DFC

contrast        =$C008

levelcnt        =varspace
topmenuitem     =varspace+1
currentlevel    =varspace+2
mapcnt          =varspace+3
currentmap      =varspace+4
diamonds        =varspace+5
deathflag       =varspace+7
curdir          =varspace+8
lives           =varspace+9
curanim         =varspace+10
animdir         =varspace+11
animextents     =varspace+12
scrlx           =varspace+14
scrly           =varspace+16
scrlamt         =varspace+18
topleftblock    =varspace+19
topleftxbits    =varspace+21
topleftybits    =varspace+22
curpos          =varspace+23
maxtextlen      =varspace+25
curleveladdr    =varspace+26 ;24 bit addy
timeleft        =varspace+29
nexttick        =varspace+30
timebomb        =varspace+32
crown           =varspace+33
safes           =varspace+34
monsters        =varspace+35
score           =varspace+36
levelcompleted  =varspace+38
snoretimer      =varspace+39
usedpass        =varspace+40

levelname       =varspace+41
leveladdresses  =levelname+60

digitbuffer     =varspace+107
pwdbuffer       =varspace+101
placemsg        =varspace+101
scorer          =varspace+104

mapinfo         =varspace+109
password        =mapinfo
mappable        =mapinfo+8
timedelta       =mapinfo+9
transporters    =mapinfo+11
mapwidth        =mapinfo+27
mapheight       =mapinfo+28
screenhidden    =varspace+138

startpos        =varspace+139
oldcurrow       =varspace+141
temp            =varspace+143

MAXOBJECTS      =64
OBJECTLISTSIZE  =MAXOBJECTS*4   

curobjlist      =varspace+143
activeobjects1  =varspace+144
objectlist1     =activeobjects1+1
activeobjects2  =objectlist1+OBJECTLISTSIZE
objectlist2     =activeobjects2+1

.end
