#include "ti86asm.inc"
.org _asm_exec_ram
	nop
	jp Intro
	.dw 0
	.dw ShellTitle
ShellTitle:
	.db "Ben Weber's ProSkater86",0
Intro:
 call _clrLCD
 ld hl,$0403
 ld (_curRow),hl
 ld hl,T1
 call _puts
 ld hl,$0404
 ld (_curRow),hl
 ld hl,T2
 call _puts
 call _getkey
 jp Park
T1: .db "Ben Weber's",0
T2: .db "ProSkater86",0
Park:
 call _clrLCD
 ld hl,$0802
 ld (_curRow),hl
 ld hl,T3
 call _puts
 ld hl,$0203
 ld (_curRow),hl
 ld hl,T4
 call _puts
 ld b,20
 ld c,34
 ld hl,Skater1 
 call PutSprite 
 ld b,80
 ld hl,Can
 call PutSprite
 call _getkey
 jp ProgStart
T3: .db "Level 1",0
T4: .db "A walk in the Park",0
ProgStart:
J = $CAF8         ;scroll var
P = $CAF9         ;scroll x
Q = $CAF0         ;scroll y
X = $CAF1         ;skater x
Y = $CAF2         ;skater y
O = $CAF7         ;obstacle var
V = $CAF3         ;obstacle x
U = $CAF4         ;obstacle y
S = $CAF5         ;jump v
T = $CAF6         ;trick var 
N = $CAFB         ;skater var 
 ld a,1
 ld (J),a
 ld a,0
 ld (N),a  
 ld a,4
 ld (S),a 
 ld a,76
 ld (P),a 
 ld a,12
 ld (Q),a 
 ld a,0
 ld (O),a 
 ld a,0
 ld (S),a
 ld a,0
 ld (T),a
 ld a,16
 ld (X),a
 ld a,38
 ld (Y),a
 ld a,128
 ld (V),a
 ld a,50
 ld (U),a
 call _clrLCD
 ld hl,$0000
 ld (_curRow),hl
 ld hl,Ben 
 call _puts
 ld a,(X)
 ld b,a
 ld a,(Y)
 ld c,a
 ld hl,Skater1
 call PutSprite
 ld b,0
LdGround:
 ld c,58
 ld hl,Ground
 call PutSprite
 ld c,8
 ld hl,StupidLine
 call PutSprite 
 inc b
 ld a,112
 cp b
 jp z,Background
 jp LdGround
Background:
 ld a,(J)
 ld b,a
 ld a,1
 cp b
 jp z,CloudS
 ld a,2
 cp b 
 jp z,TreeS
CloudS:
 ld b,0
 ld c,58
 ld hl,Ground
 call PutSprite
 halt
 halt
 halt
 ld a,(P)
 ld b,a
 ld a,2
 cp b 
 jp z,Sloop
 ld a,(Q)
 ld c,a
 ld hl,Blank8
 call PutSprite
 dec b
 ld a,b
 ld (P),a
 ld hl,Cloud
 call PutSprite
 jp Obstacles
Sloop:
 ld a,(P)
 ld c,a
 ld a,(Q)
 ld c,a
 ld hl,Blank8
 call PutSprite
 ld a,112
 ld (P),a
 ld a,26
 ld (Q),a 
 ld a,2
 ld (J),a
 jp Obstacles
TreeS:
 ld b,0
 ld c,58
 ld hl,Ground
 call PutSprite
 ld a,(P)
 ld b,a
 ld a,2
 cp b 
 jp z,SloopT
 ld a,(Q)
 ld c,a
 ld hl,Blank24
 call PutSprite
 dec b
 ld a,b
 ld (P),a
 ld hl,Tree
 call PutSprite
 jp Obstacles
SloopT:
 ld a,(P)
 ld c,a
 ld a,(Q)
 ld c,a
 ld hl,Blank24
 call PutSprite
 ld a,12
 ld (Q),a 
 ld a,112
 ld (P),a
 ld a,1
 ld (J),a
 jp Obstacles
Obstacles:
 ld a,(O)
 ld c,a
 ld a,1
 cp c
 ld a,2
 jp z,CanO
 cp c
 jp BenchO
CanO:
 ld a,(V)
 ld b,a
 ld a,0
 cp b 
 jp z,Oloop1
 ld a,(U)
 ld c,a
 ld hl,Blank8
 call PutSprite
 dec b
 dec b
 ld a,b
 ld (V),a
 ld hl,Can
 call PutSprite
 ld a,(X)
 ld b,a
 ld a,(V)
 inc a
 inc a
 inc a 
 inc a
 cp b 
 jp z,Hit
 inc a
 cp b 
 jp z,Hit
 inc a
 cp b 
 jp z,Hit
 inc a
 cp b 
 jp z,Hit
 jp Move
Oloop1:
 ld a,(V)
 ld c,a
 ld a,(U)
 ld c,a
 ld hl,Blank8
 call PutSprite
 ld a,128
 ld (V),a
 ld a,2
 ld (O),a
 jp Move
BenchO:
 ld a,(V)
 ld b,a
 ld a,0
 cp b 
 jp z,Oloop2
 ld a,(U)
 ld c,a
 ld hl,Blank8
 call PutSprite
 dec b
 dec b
 ld a,b
 ld (V),a
 ld hl,Bench
 call PutSprite
 ld a,(X)
 ld b,a
 ld a,(V)
 cp b 
 jp z,Hit
 inc a
 cp b 
 jp z,Hit
 inc a
 cp b 
 jp z,Hit
 inc a
 cp b 
 jp z,Hit
 inc a
 cp b 
 jp z,Hit
 inc a
 cp b 
 jp z,Hit
 inc a
 cp b 
 jp z,Hit
  jp Move
Oloop2:
 ld a,(V)
 ld c,a
 ld a,(U)
 ld c,a
 ld hl,Blank8
 call PutSprite
 ld a,128
 ld (V),a
 ld a,1
 ld (O),a
 jp Move
Hit:
 ld a,(Y)
 add a,12
 ld b,a
 ld a,57
 cp b
 jp z,Die
 ld a,56
 cp b
 jp z,Die
 ld a,55
 cp b
 jp z,Die
 ld a,54
 cp b
 jp z,Die
  ld a,53
 cp b
 jp z,Die
 ld a,52
 cp b
 jp z,Die
 ld a,51
 cp b
 jp z,Die
 ld a,50
 cp b
 jp z,Die
 jp Move
Move:
 ld a,(S)
 ld c,a
 ld a,1
 cp c
 jp z,Jump1
 ld a,2
 cp c
 jp z,Jump2
 call _getky 
 cp K_SECOND
 jp z,Jump
 jp Skater
Skater:
 cp K_EXIT
 ret z
 cp K_LEFT
 jp z,Left
 cp K_RIGHT
 jp z,Right
 jp J3
Left:
 ld a,(X)
 ld b,a
 ld a,2
 cp b
 jp z,Move
 ld a,(X)
 ld b,a
 ld a,(Y)
 ld c,a
 ld hl,Blank
 call PutSprite
 ld a,(X) 
 dec a
 dec a
 ld (X),a
 jp J3
Right:
 ld a,(X)
 ld b,a
 ld a,96
 cp b
 jp z,Move
 ld a,(X)
 ld b,a
 ld a,(Y)
 ld c,a
 ld hl,Blank
 call PutSprite
 ld a,(X) 
 inc a
 inc a
 ld (X),a
 jp Skater
J3:
 ld a,(T)
 ld b,a
 ld a,1 
 cp b
 jp z,Kick1
 ld a,2
 cp b
 jp z,Kick2
 ld a,3
 cp b
 jp z,Kick3
 ld a,(S)
 ld b,a
 ld a,1
 cp b
 jp z,Background
 ld a,(X)
 ld b,a
 ld a,(Y)
 ld c,a
 ld hl,Skater1
 call PutSprite
 jp Background
Jump:
 ld a,1
 ld (S),a
 jp Skater
Jump1:
 ld a,(Y)
 ld c,a
 ld a,18
 cp c
 jp z,J1
 ld a,(X)
 ld b,a
 ld a,(Y)
 ld c,a
 ld hl,Blank
 call PutSprite
 dec c 
 dec c
 ld a,c
 ld (Y),a
 ld hl,Skater4
 call PutSprite
 call _getky
 cp K_LEFT
 jp z,Left
 cp K_RIGHT
 jp z,Right
 cp K_ALPHA
 jp z,Flip
 cp K_EXIT
 ret z
 jp Skater
J1:
 ld a,2
 ld (S),a
 ld a,(X)
 inc a
 ld (X),a 
 jp Skater
Jump2:
 ld a,(Y)
 ld c,a
 ld a,38
 cp c
 jp z,J2
 ld a,(X)
 ld b,a
 ld a,(Y)
 ld c,a
 ld hl,Blank
 call PutSprite
 inc c 
 inc c
 ld a,c
 ld (Y),a
 ld hl,Skater1
 call PutSprite
 call _getky
 cp K_LEFT
 jp z,Left
 cp K_RIGHT
 jp z,Right
 cp K_EXIT
 ret z
 jp Skater
J2:
 ld a,4
 ld (S),a
 jp Skater
Flip:
 ld a,1
 ld (T),a
 jp J3
Kick1:
 ld a,(X)
 ld b,a
 ld a,(Y)
 ld c,a
 ld hl,Skater3
 call PutSprite
 ld a,2
 ld (T),a 
 jp Background
Kick2:
 ld a,(X)
 ld b,a
 ld a,(Y)
 ld c,a
 ld hl,Skater2
 call PutSprite
 ld a,3
 ld (T),a
 jp Background
Kick3:
 ld a,(X)
 ld b,a
 ld a,(Y)
 ld c,a
 ld hl,Skater3
 call PutSprite
 ld a,0
 ld (T),a
 jp Background
Die:
 ld hl,$0202
 ld (_curRow),hl
 ld hl,Died
 call _puts
Exit:
 call _getky
 cp K_EXIT
 ret z
 jp Exit
Died: .db "You Died, Poser",0
Ben: .db "ProSkater86",0 
StupidLine:
	.db 16, 1
	.db %11111111, %11111111
Bench:
	.db 16, 8
	.db %00000000, %00000000
	.db %11111111, %11111111
	.db %11111111, %11111111
	.db %11000000, %00000011
	.db %11111111, %11111111
	.db %11111111, %11111111
	.db %00110000, %00000110
	.db %01111000, %00001111
Cloud:
	.db 16, 8
	.db %00011111, %00111100
	.db %01100000, %11000010
	.db %10000000, %00000001
	.db %10000000, %00000001
	.db %10000000, %00000001
	.db %10000000, %00000001
	.db %01100000, %11100010
	.db %00011111, %00011100
Can:
	.db 16, 8
	.db %00000011, %10000000
	.db %00001111, %11110000
	.db %00001101, %10110000
	.db %00001101, %10110000
	.db %00001101, %10110000
	.db %00001101, %10110000
	.db %00001101, %10110000
	.db %00000111, %11100000
	.db %00000011, %10000000
	.db %00001111, %11110000
	.db %00001101, %10110000
	.db %00001101, %10110000
	.db %00001101, %10110000
	.db %00001101, %10110000
	.db %00001101, %10110000
	.db %00000111, %11100000
Tree:
	.db 16, 24
	.db %00011111, %11111000
	.db %00100000, %00000100
	.db %01000000, %00000010
	.db %10000000, %00000001
	.db %10000000, %00000001
	.db %10000000, %00000001
	.db %10000000, %00000001
	.db %10000000, %00000001
	.db %10000000, %00000001
	.db %01000000, %00000010
	.db %00100000, %00000100
	.db %00011111, %11111000
	.db %00000010, %01000000
	.db %00000010, %01000000
	.db %00000010, %01000000
	.db %00000010, %01000000
	.db %00000010, %01000000
	.db %00000010, %01000000
	.db %00000010, %01000000
	.db %00000010, %01000000
	.db %00000010, %01000000
	.db %00000010, %01000000
	.db %00000100, %00100000
	.db %00011111, %11111000

Ground:
	.db 16, 8
	.db %11111111, %11111111
	.db %11111111, %11111111
	.db %11111111, %11111111
	.db %11111111, %11111111
	.db %11111111, %11111111
	.db %11111111, %11111111
	.db %11111111, %11111111
	.db %11111111, %11111111

Skater1:
	.db 16, 20
	.db %00000011, %10000000
	.db %00001111, %11000000
	.db %00000010, %01000000
	.db %00000010, %01000000
	.db %00011101, %10111000
	.db %00100000, %00000100
	.db %01001100, %01110010
	.db %01010100, %01001111
	.db %01010111, %11000010
	.db %00110100, %00100000
	.db %01111000, %10010000
	.db %00101001, %01010000
	.db %00001001, %01010000
	.db %00001001, %01010000
	.db %00001001, %01010000
	.db %00011110, %01111000
	.db %01011110, %01111010
	.db %00111111, %11111100
	.db %00011000, %00011000
	.db %00011000, %00011000
Skater2: 
	.db 16, 20
	.db %00000011, %10000000
	.db %00001111, %11000000
	.db %00000010, %01000000
	.db %00000010, %01000000
	.db %00011101, %10111000
	.db %00100000, %00000100
	.db %01001100, %01110010
	.db %01010100, %01001111
	.db %01010111, %11000010
	.db %00110100, %00100000
	.db %01111000, %10010000
	.db %00101001, %01010000
	.db %00001001, %01010000
	.db %00001001, %01010000
	.db %00001001, %01010000
	.db %00011110, %01111000
	.db %00011110, %01111000
	.db %00011000, %00011000
	.db %00011000, %00011000
	.db %01111111, %11111110
Skater3:
	.db 16, 20
	.db %00000011, %10000000
	.db %00001111, %11000000
	.db %00000010, %01000000
	.db %00000010, %01000000
	.db %00011101, %10111000
	.db %00100000, %00000100
	.db %01001100, %01110010
	.db %01010100, %01001111
	.db %01010111, %11000010
	.db %00110100, %00100000
	.db %01111000, %10010000
	.db %00101001, %01010000
	.db %00001001, %01010000
	.db %00001001, %01010000
	.db %00001001, %01010000
	.db %00011110, %01111000
	.db %00011110, %01111000
	.db %00111111, %11111100
	.db %01111111, %11111110
	.db %00111111, %11111100
Skater4:
	.db 16, 20
	.db %00000011, %10000000
	.db %00001111, %11000000
	.db %00000010, %01000000
	.db %00000010, %01000000
	.db %00011101, %10111000
	.db %00100000, %00000100
	.db %01001100, %01110010
	.db %01010100, %01001111
	.db %01010111, %11100010
	.db %00110100, %00010000
	.db %01111000, %10001000
	.db %00101001, %01001000
	.db %00001001, %01001010
	.db %00001001, %00111100
	.db %00001001, %00111100
	.db %00011110, %01101100
	.db %00011110, %10000000
	.db %00000111, %00000000
	.db %00011011, %00000000
	.db %00000000, %00000000

Blank:
	.db 16, 20
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
Blank8:
	.db 16, 8
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
Blank24:
	.db 16, 24
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
	.db %00000000, %00000000
; =============================================================
; Puts a sprite stored at (HL) at B,C
; =============================================================
PutSprite:
 push bc                        ; Save BC (X, Y) 
 push de                        ; Save DE
 push hl                        ; Save HL (Start of Sprite Data)
 push hl                        ; Save HL (Start of Sprite Data)
 push bc
 ld d, c
 ld e, b
 call FindPixel                 ; Finds pixel at E, D
 pop bc
                               ; PutSprite16 needs pixel at B, C
                                ; A = Bitmask with one bit set; this will be the bit (pixel) "counter"
 ex de,hl                       ; DE = Address in Display of Sprite
 pop hl                         ; HL = Start of Sprite Data
 ld b,(hl)                      ; B = X width of Sprite 
 inc hl                         ; Next byte
 ld c,(hl)                      ; C = Y width of Sprite
 inc hl                         ; Next byte (now pointing at actual sprite data)
 push hl                        ; Save the twice incremented HL into stack
 pop ix                         ; IX = The recently twice incremented HL
 ex de,hl                       ; HL = Address in Display of Sprite
PS_NewRow:
 push bc                        ; Save X width of Sprite and Y width of Sprite
 ld d,(ix)                      ; D = (IX), so D = First byte from Sprite
 inc ix
 ld e,(ix)                      ; E = (IX), so E = Second byte from Sprite
 inc ix                         ; IX points to next row
 push af                        ; Save Bitmask 
 push hl                        ; Save HL, Address in Display of Sprite
PS_NewCol:                      ; Now the fun begins, remember A is the bitmask, D = the Left Column Byte from Sprite, E = the Right Column Byte from Sprite
 sla e                          ; 16-bit rotation DE
 rl  d
 push af                        ; Save Bitmask
 jr nc,PS_NoPixel               ; Check pixel from sprite to see if it is set
 or (hl)                        ; Sets Pixel at the "current bit" (Bitmask is the "bit counter")
 ld (hl),a                      ; (HL) = A, Save changes to
 jr PS_NextPixel
PS_NoPixel:
 cpl                            ; Invert Bitmask
 and (hl)                       ; Clears pixel at the "current bit" (Bitmask is the "bit counter")
 ld (hl),a                      ; (HL) = A Save changes
PS_NextPixel:
 pop af                         ; Restore Bitmask
 rrca                           ; A is rotated right *through* carry
 jr nc,PS_SameByte              ; If the carry was set, that means that one bit set in A (bit counter) 
                             ;  rotated all the way to the end right into carry and recycles back into Bit 7
                               ;  so it can be used for the next byte
 inc hl                         ; Move on to next byte
PS_SameByte:
 djnz PS_NewCol                 ; B = X (width of sprite), so it loops to PS_NewCol X times. This means that is X = 6, 
                                ; it will Shift Right the bitmask (move the bit counter to the right) 6 times, comparing 
                                ; each bit of the bitmask and the sprite and setting or clearing the pixel in that
                                ; particular bit. It then moves on the the next pixel.
                                ; Move on to the next row
 pop hl                         ; Recover HL, the Address in Display of the Sprite
 pop af                         ; Recover AF, A = Bitmask
 ld de,16                       ; DE = 16
 add hl,de                      ; HL = HL + 16, this moves down ONE row in the Display Area (128 width / (8 bits/pixel) = 16 bytes)
 pop bc                         ; Recover X_width and Y_height of Sprite
 dec c                          ; C = Y_height of Sprite, subract one, which means one row of the Sprite has been drawn
 jr nz,PS_NewRow                ; If there are more rows to be drawn, go back to PS_NewRow
; No more rows. Since there were "effectively" 3 pushes before PS_NewRow, there must be three pops that way the
; ret statement will retrieve the correct address when it returns to the calling program.
 pop hl                                         
 pop de
 pop bc
 ret
; =============================================================
; Dan Eble & James Yopp FindPixel routine
; Input:  D = y, E = x
; Output: HL= addr in vid mem, A = bitmask, C is modified
; =============================================================
FindPixel:
        ld hl,FP_Bits
        ld a,e
        and $07         ; a = bit offset
        add a,l
        ld l,a
        adc a,h
        sub l
        ld h,a
        ld c,(hl)       ; c = bitmask for (hl)
;48 t-states up to this point
        ld hl,FP_RLD
        ld (hl),d
        ld a,e          ; a = x/8 (byte offset within row)
        rrca
        rrca   
        rrca
        rld
        or $FC 
        ld l,(hl)
        ld h,a          ; hl -> byte in vid mem
        ld a,c          ; now a = bitmask for (hl)
;121 t-states up to this point
        ret
FP_RLD:  .db $00
FP_Bits: .db $80,$40,$20,$10,$08,$04,$02,$01

.end








