#include asm86.h
#include ti86asm.inc

.org _asm_exec_ram

;------------------AShell / Rascall Description-------------------------
	nop         ;Identifies the table
	jp Initialize
.dw $0000   ;Version # of Table
.dw Title   ;Absolute pointer to program description

;---------------------------Begin Program --------------------------------

Initialize:
        call _runindicoff       ;Run Indicator Off
	call _clrLCD		;Clears the Screen
        
StartGame:
        call NewVarInit         ;Sets up variables
        call ScreenSetup        ;Sets up the Screen
	call DispHighScore	;Displays the High Score
	call DispShip		;Displays the Ship
        jr GameLoop             ;Goto GameLoop

LevelUp:
        call _clrLCD
        ld a,(Level)
        inc a
        ld (Level),a
        call ScreenSetup
        call DispHighScore
        call DispShip
        call DispEnemyII
        ld a,(Level)
        cp 3
        call z,DispEnemyIII
        
;---------------------------
;|GetKey Loop and Movement
;---------------------------

GameLoop:
	ld 	a,0ffh		;Reset keyport
        out     (1),a           ;Clear Port
	ld 	a,0feh		;Load desired port
        out   (1),a             ;Clear Keys
        in      a,(1)           ;Input Key
        cp      251             ;If key is right
        jp      z,M_Right       ;Goto Right
        cp      253             ;If key is left
        jp      z,M_Left        ;Goto Left
	ld 	a,0ffh		;Reset keyport
        out     (1),a           ;Clear Port
	ld 	a,0bfh		;Load desired port
        out   (1),a             ;Clear Keys
        in      a,(1)           ;Input Key
        cp      223             ;Is it 2nd
	jp 	z,Fire		;Fire if so
	cp 127			;Is it Delete?
	call z,Pause		;Pause!
        cp      191             ;Is it Exit 
        ret     z               ;Return if so

NoKeyLoop:
	call MoveTarget		;Move the Target
	call MoveEnemy		;Move the Enemy
	call CheckEnemyHit	;See if you hit the enemy
	
CheckDeath:                     ;Checks to see if you are dead
	ld a,(Lives)		;Lives into A
        or a                    ;Is it 0?
	jp z,EndOfGame		;Goto End Of Game

ContinueNKL:
	call CheckFire		;Checks the FireBall
        ld a,(Level)
        cp 3
        jr z,GameLoop
        ld a,(Hits)             ;Hits into A
        cp 15                   ;Is it 15?
        jp z,LevelUp
        jr GameLoop             ;Goto GameLoop

M_Right:                        ;Move Right
	ld a,(ShipX)		;Ship X into A
        cp 74                   ;Is it 74 [Line]
	jr z,GameLoop		;ReLoop, don't move
        cp 75                   ;Is it 75 [Line]
	jr z,GameLoop		;ReLoop, don't move
	call DispShip		;Clear Ship
	ld a,(ShipX)		;Ship X back into A
        inc a                   ;Increment it
        inc a                   ;Increment it
	ld (ShipX),a		;A back into ShipX
	call DispShip		;RePut Ship
	jr NoKeyLoop		;Goto NoKeyLoop

M_Left:				;Move Left
	ld a,(ShipX)		;Ship X into A
        cp 3                    ;Is it 3 [Line]
	jr z,GameLoop		;ReLoop, don't move
        cp 4                    ;Is it 4 [Line]
	jr z,GameLoop		;ReLoop, don't move
	call DispShip		;Clear Ship
	ld a,(ShipX)		;Ship X back into A
        dec a                   ;Decrement it
        dec a                   ;Decrement it
	ld (ShipX),a		;A back into ShipX
	call DispShip		;RePut Ship
	jr NoKeyLoop		;Goto NoKeyLoop

DispShip:				;XORs the Ship Sprite on/off the screen
        ld a,(ShipY)                    ;Ship Y into A
        ld e,a                          ;A goes into E, E = Y Coord
        ld a,(ShipX)                    ;Ship X into A
	ld hl,PlayerShip		;Sprite name into HL
        call PutSprite                  ;XOR it!
	ret				;Return to call

DispTarget:				;XORs the Target Sprite on/off the screen
        ld a,(TargetY)                  ;Target Y into A
        ld e,a                          ;A into E , E = Y Coord
        ld a,(TargetX)                  ;Target X Coord into A
	ld hl,TargetShip		;Sprite Name into HL
        call PutSprite                  ;XOR it!
        ret                             ;Return to Call

DispEnemy:                      ;XORs the Enemy Sprite on/off the screen
	ld a,(EnemyY)		;Enemy Y into A
	ld e,a			;A goes into E, E = Y Coord
	ld a,(EnemyX)		;Enemy X into A
	ld hl,EnemyShip		;Sprite name into HL
	call PutSprite		;XOR it!
        ret                     ;Return to call

DispEnemyII:                     ;XORs the Enemy Sprite on/off the screen
        ld a,(Enemy2Y)          ;Enemy Y into A
	ld e,a			;A goes into E, E = Y Coord
        ld a,(Enemy2X)          ;Enemy X into A
        ld hl,Enemy2Ship        ;Sprite name into HL
	call PutSprite		;XOR it!
        ret                     ;Return to call

DispEnemyIII:                   ;XORs the Enemy Sprite on/off the screen
        ld a,(Enemy3Y)          ;Enemy Y into A
	ld e,a			;A goes into E, E = Y Coord
        ld a,(Enemy3X)          ;Enemy X into A
        ld hl,Enemy3Ship        ;Sprite name into HL
	call PutSprite		;XOR it!
        ret                     ;Return to call

DispFire:                       ;XORs the Ship Sprite on/off the screen
	ld a,(FireY)		;Fire Y into A
	ld e,a			;A goes into E, E = Y Coord
	ld a,(FireX)		;Fire X into A
	ld hl,FireBall		;Sprite name into HL
	call PutSprite		;XOR it!
        ret                     ;Return to call


Pause:
	call _getkey
	ret

;----------------------
;|Fire Routine
;----------------------

Fire:
	ld a,(FireZ)		;Loads FireZ into A
        or a                    ;If it is 0 [No Fire]
	jr z,NewFire		;Put a new fireball
	jp nz,NoKeyLoop		;NoKeyLoop otherwise

NewFire:                        ;Creates new FireBall
	ld a,1			;1 into A
	ld (FireZ),a		;A into FireZ
	ld a,(ShipX)		;Ship X into A
	ld (FireX),a		;Loads A into FireX
	ld a,(ShipY)		;ShipY into A
	ld (FireY),a		;A into FireY
	call DispFire		;Display FireBall
	jp NoKeyLoop		;Goto NoKeyLoop

CheckFire:
	call Delay			;Creates a Short Delay
        ld a,(FireZ)                    ;FireZ into a
	or a				;If it is 0 [No Fire]
	ret z				;Return, no need to bother
        ld a,(FireY)                    ;FireY into A
	or a				;If it is 0
        jr z,CheckHit                   ;Check for Hit
        call DispFire                   ;Clear Fire
        ld a,(FireY)                    ;Fire Y into A again
	dec a				;Decrease it
        ld (FireY),a                    ;A into FireY
        call DispFire                   ;RePut Fire
	ret				;Return

CheckHit:                               ;Checks if you hit target
	ld a,(FireX)			;Loads Fire X into A
	add a,8				;Add 8 to A [End of Sprite]
	ld b,a				;Loads A into B
	ld a,(TargetX)			;Loads TargetX into A
        cp b                            ;Compares a to b
	jp c,ContinueCheck		;Continue Checking if a>b

MissHit:
        call DecScore
        call DecScore
        call DecScore
        call DecScore
        call DecScore
	ld hl,34*256+88			;Load Coords into HL
	ld (_penCol),hl			;Loads PenCol into HL
	ld hl,BlankStr			;Blank String into HL
        call _vputs                     ;Display it
        ld hl,27*256+105                ;Set Coords into HL
	ld (_penCol),hl			;Loads HL into PenCol
	ld hl,(Score)			;Variable into HL
        call DispHL                     ;Display HL
        call ResetFire                  ;Reset the Fire Otherwise
        ret                             ;Return from Call
	
DecScore:
        ld       de,(Score)
        ld       a,d
        or       e
        ret      z
        dec      de
        ld       (Score),de
        ret

ContinueCheck:
	ld a,(TargetX)			;Target X into A
	add a,8				;Add 8 to A [End of Sprite]
	ld b,a				;Loads A into B
	ld a,(FireX)			;Fire X into A
        cp b                            ;Compare A to B
	jp c,HitTarget			;If b>a then you hit it
	jp MissHit
        ret                             ;Return to Call

HitTarget:
	call ResetFire			;Reset the Fire
	ld hl,(Score)			;Load Score into HL
        ld bc,25                        ;Loads 25 into bc
        add hl,bc                       ;Adds BC and HL
	ld (Score),hl			;Load HL back into Score
	ld hl,34*256+88			;Load Coords into HL
	ld (_penCol),hl			;Loads PenCol into HL
	ld hl,BlankStr			;Blank String into HL
        call _vputs                     ;Display it
        ld hl,27*256+105                ;Set Coords into HL
	ld (_penCol),hl			;Loads HL into PenCol
	ld hl,(Score)			;Variable into HL
        call DispHL                     ;Display HL
        ld a,(Hits)
        inc a
        ld (Hits),a
        ret                             ;Return from Call

ResetFire:                              ;Reset the Fire
	call DispFire			;Clears the Fire
        xor a                           ;Loads 0 into A
	ld (FireZ),a			;Reset FireZ
	ld (FireX),a			;Reset FireX
	ld (FireY),a			;Reset FireY
        ret                             ;Return from Call

CheckEnemyHit:
        call Delay                      ;Creates a Short Delay
	ld a,(FireZ)			;FireZ into a
        or a                            ;If it is 0 [No Fire]
        ret z                           ;Return, no need to bother
	ld a,(FireY)			;FireY into A
        cp 30                           ;Is it 30?
        jr z,CheckEHit                  ;Check for Hit
        ld a,(Level)                    ;Level # into A
        cp 1                            ;Is it 1?
        jp nz,CheckE2Hit                ;Check Enemy II Hit Otherwise
        jp DecFire
                                        ;Return

CheckEHit:                              ;Checks if you hit target
	ld a,(FireX)			;Loads Fire X into A
	add a,8				;Add 8 to A [End of Sprite]
	ld b,a				;Loads A into B
	ld a,(EnemyX)			;Loads EnemyX into A
        cp b                            ;Compares a to b
	jp c,ContinueECheck		;Continue Checking if a>b
        ret                             ;Return from Call Otherwise

ContinueECheck:
	ld a,(EnemyX)			;Enemy X into A
	add a,8				;Add 8 to A [End of Sprite]
	ld b,a				;Loads A into B
	ld a,(FireX)			;Fire X into A
        cp b                            ;Compare A to B
	jp c,HitEnemy			;If b>a then you hit it
        ret                             ;Return to Call Otherwise

CheckE2Hit:                             ;Checks if you hit target 2
        ld a,(Level)
        cp 1
        jp z,DecFire
	ld a,(FireX)			;Loads Fire X into A
	add a,8				;Add 8 to A [End of Sprite]
	ld b,a				;Loads A into B
        ld a,(Enemy2X)                  ;Loads Enemy2X into A
        cp b                            ;Compares a to b
        jp c,ContinueE2Check            ;Continue Checking if a>b
        jp CheckE3Hit

DecFire:
        call DispFire
        ld a,(FireY)
        dec a
        ld (FireY),a
        call DispFire
        ret

ContinueE2Check:
        ld a,(Enemy2X)                  ;Enemy 2X into A
	add a,8				;Add 8 to A [End of Sprite]
	ld b,a				;Loads A into B
	ld a,(FireX)			;Fire X into A
        cp b                            ;Compare A to B
        jp c,CheckE2Y                   ;If b>a then you hit it
        jp CheckE3Hit

CheckE2Y:
        ld a,(FireY)                    ;Loads FireY into A
	add a,4				;Add 8 to A [End of Sprite]
	ld b,a				;Loads A into B
        ld a,(Enemy2Y)                  ;Loads Enemy Y into A
        cp b                            ;Compares a to b
        jp c,ContinueCheck2Y            ;Continue Checking if a>b
        jp CheckE3Hit                   ;Missed Otherwise
       
ContinueCheck2Y:
        ld a,(Enemy2Y)                  ;Enemy Y into A
	add a,4				;Add 8 to A [End of Sprite]
	ld b,a				;Loads A into B
        ld a,(FireY)                    ;Fire Y into A
        cp b                            ;Compare A to B
        jp c,HitEnemy2                  ;If b>a then hit
        jp CheckE3Hit                   ;You missed otherwise

CheckE3Hit:                             ;Checks if you hit target 3
        ld a,(Level)
        cp 3
        jp nz,DecFire
	ld a,(FireX)			;Loads Fire X into A
	add a,8				;Add 8 to A [End of Sprite]
	ld b,a				;Loads A into B
        ld a,(Enemy3X)                  ;Loads Enemy3X into A
        cp b                            ;Compares a to b
        jp c,ContinueE3Check            ;Continue Checking if a>b
        jp DecFire

ContinueE3Check:
        ld a,(Enemy3X)                  ;Enemy 3X into A
	add a,8				;Add 8 to A [End of Sprite]
	ld b,a				;Loads A into B
	ld a,(FireX)			;Fire X into A
        cp b                            ;Compare A to B
        jp c,CheckE3Y                   ;If b>a then you hit it
        jp DecFire                      ;Decrease Fire and Return otherwise

CheckE3Y:
        ld a,(FireY)                    ;Loads FireY into A
	add a,4				;Add 8 to A [End of Sprite]
	ld b,a				;Loads A into B
        ld a,(Enemy3Y)                  ;Loads Enemy Y into A
        cp b                            ;Compares a to b
        jp c,ContinueCheck3Y            ;Continue Checking if a>b
        jp DecFire                      ;Missed Otherwise
       
ContinueCheck3Y:
        ld a,(Enemy3Y)                  ;Enemy Y into A
	add a,4				;Add 8 to A [End of Sprite]
	ld b,a				;Loads A into B
        ld a,(FireY)                    ;Fire Y into A
        cp b                            ;Compare A to B
        jp c,HitEnemy3                  ;If b>a then hit
        jp DecFire                      ;You missed otherwise


HitEnemy:
        call Delay                      ;Creates a short delay
	call DispFire			;Views the Fire
	ld a,(FireY)			;Loads Y into A
        inc a                           ;Increases It
	ld (FireY),a			;Back into A
	call DispFire			;Redisplays
	ld a,(FireY)			;Loads Y into A
        cp 54                           ;Is it 54?
	jp nz,HitEnemy			;If not, reloop
	jr CheckYouHit			;Check if you are hit

CheckYouHit:                            ;Checks if you die
	ld a,(FireX)			;Loads Fire X into A
        add a,6                         ;Add 8 to A [End of Sprite]
	ld b,a				;Loads A into B
	ld a,(ShipX)			;Loads ShipX into A
        cp b                            ;Compares a to b
	jp c,ContinueUCheck		;Continue Checking if a>b
	call ResetFire			;Reset Fire
        ret                             ;Return from Call Otherwise

ContinueUCheck:
	ld a,(EnemyX)			;Enemy X into A
        add a,6                         ;Add 6 to A [End of Sprite]
	ld b,a				;Loads A into B
	ld a,(ShipX)			;Fire X into A
        cp b                            ;Compare A to B
        jp c,HitYou                     ;If b>a then you hit it
	call ResetFire			;ResetFire
        ret                             ;Return to Call Otherwise

HitEnemy2:
        call Delay                      ;Creates a short delay
	call DispFire			;Views the Fire
	ld a,(FireY)			;Loads Y into A
        inc a                           ;Increases It
	ld (FireY),a			;Back into A
	call DispFire			;Redisplays
	ld a,(FireY)			;Loads Y into A
        cp 54                           ;Is it 54?
        jp nz,HitEnemy2                 ;If not, reloop
        jr CheckYou2Hit                 ;Check if you are hit

CheckYou2Hit:                           ;Checks if you die
	ld a,(FireX)			;Loads Fire X into A
        add a,6                         ;Add 6 to A [End of Sprite]
	ld b,a				;Loads A into B
	ld a,(ShipX)			;Loads ShipX into A
        cp b                            ;Compares a to b
        jp c,ContinueU2Check            ;Continue Checking if a>b
	call ResetFire			;Reset Fire
        ret                             ;Return from Call Otherwise

ContinueU2Check:
        ld a,(Enemy2X)                   ;Enemy X into A
        add a,6                         ;Add 8 to A [End of Sprite]
	ld b,a				;Loads A into B
	ld a,(ShipX)			;Fire X into A
        cp b                            ;Compare A to B
        jp c,HitYou                     ;If b>a then you hit it
	call ResetFire			;ResetFire
        ret                             ;Return to Call Otherwise

HitYou:
        call DecScore
        call DecScore
        call DecScore
        call DecScore
        call DecScore
        call DecScore
        call DecScore
        call DecScore
        call DecScore
        call DecScore
        call DecScore
	call ResetFire
	ld a,(Lives)			;Load lives into A
        dec a                           ;decrease A
	ld (Lives),a			;Load a back
        ld hl,20*256+105                ;Set Coords into HL
	ld (_penCol),hl			;Loads HL into PenCol
	ld hl,BlankStr			;BlankStr into HL
        call _vputs                     ;Display it!
        ld hl,20*256+105                ;Set Coords into HL
	ld (_penCol),hl			;Loads HL into PenCol
	ld a,(Lives)			;Variable into A
        call DispA                      ;Display A
	ld hl,34*256+88			;Load Coords into HL
	ld (_penCol),hl			;Loads PenCol into HL
	ld hl,BlankStr			;Blank String into HL
        call _vputs                     ;Display it
        ld hl,27*256+105                ;Set Coords into HL
	ld (_penCol),hl			;Loads HL into PenCol
	ld hl,(Score)			;Variable into HL
        call DispHL                     ;Display HL
        ret                             ;Return!

HitEnemy3:
        call Delay                      ;Creates a short delay
	call DispFire			;Views the Fire
	ld a,(FireY)			;Loads Y into A
        inc a                           ;Increases It
	ld (FireY),a			;Back into A
	call DispFire			;Redisplays
	ld a,(FireY)			;Loads Y into A
        cp 54                           ;Is it 54?
        jp nz,HitEnemy3                 ;If not, reloop
        jp CheckYou2Hit                 ;Check if you are hit

CheckYou3Hit:                           ;Checks if you die
	ld a,(FireX)			;Loads Fire X into A
        add a,6                         ;Add 6 to A [End of Sprite]
	ld b,a				;Loads A into B
	ld a,(ShipX)			;Loads ShipX into A
        cp b                            ;Compares a to b
        jp c,ContinueU3Check            ;Continue Checking if a>b
	call ResetFire			;Reset Fire
        ret                             ;Return from Call Otherwise

ContinueU3Check:
        ld a,(Enemy3X)                   ;Enemy X into A
        add a,6                         ;Add 8 to A [End of Sprite]
	ld b,a				;Loads A into B
	ld a,(ShipX)			;Fire X into A
        cp b                            ;Compare A to B
        jp c,HitYou                     ;If b>a then you hit it
	call ResetFire			;ResetFire
        ret                             ;Return to Call Otherwise

;--------------------------------
;|Target Routine, to Move Target
;--------------------------------

MoveTarget:
	call DispTarget			;XOR the Target Ship on the Screen
	ld a,(TargetD)			;Target Direction into A
        or a                            ;Is it 0
	jr z,M_T_Right			;Move Target Right
	jr nz,M_T_Left			;Otherwise Move Left

M_T_Right:
	ld a,(TargetX)			;Target X into A
        cp 75                           ;Is it 75
        jr z,ResetTargetMove            ;Reset Target to Move Other Direction
        cp 74                           ;Is it 74
	jr z,ResetTargetMove		;Reset Target to Move Other Direction
        inc a                           ;Increase it again
	ld (TargetX),a			;Into TargetX
	call DispTarget			;Replace Target on Screen
        ret                             ;Return

M_T_Left:
	ld a,(TargetX)			;Target X into A
        cp 3                            ;Is it 3
	jr z,ResetTargetMove		;Reset Target to Move Other Direction
        cp 4                            ;Is it 4
	jr z,ResetTargetMove		;Reset Target to Move Other Direction
        dec a                           ;Decrease it
	ld (TargetX),a			;Into TargetX
	call DispTarget			;Replace Target on Screen
        ret                             ;Return

ResetTargetMove:
	ld a,(TargetD)			;Load Target Direction into A
        or a                            ;Is it 0?
	jr z,ResetLeft			;Reset it to go left!
        xor a                           ;Loads 0 into a
	ld (TargetD),a			;Loads A into Direction 
	jr M_T_Right			;Move Right

ResetLeft:
	ld a,1				;Load 1 into A
	ld (TargetD),a			;Loads A into Target Direction
        jr M_T_Left                     ;Move Left

;--------------------------------
;|Enemy Routine, to Move Enemy
;--------------------------------

MoveEnemy:
        ld a,(Level)
        cp 1
        jp z,Level1Enemy
        cp 2
        jp z,Level2Enemy
        jp nz,Level3Enemy

Level3Enemy:
        call Level1Enemy
        call Level2Enemy
        call DispEnemyIII
        ld a,(Enemy3D)
        or a
        jp nz,M_E_DownLeft

M_E_UpRight:
        ld a,(Enemy3Y)                  ;Y Coordinate into A
        cp 12                           ;Is it 12?
        jp z,Reset_E3_Dir               ;Change the Direction if so
        ld a,(Enemy3Y)                  ;Y Coord into A
        dec a                           ;Decrease it [Going Up]
        ld (Enemy3Y),a                  ;A into Enemy 2 Y
        ld a,(Enemy3X)                  ;Load Enemy 2 X into A
        inc a                           ;Increment it
        ld (Enemy3X),a                  ;Loads A into Enemy2X
        call DispEnemyIII               ;Display Enemy III
        ret                             ;Return

Level2Enemy:
        call Level1Enemy                ;Call Level1 Enemy, so it will move
        call DispEnemyII                ;XOR Enemy II
        ld a,(Enemy2D)
        or a                            ;Is it 0?
        jp nz,M_E_DownRight             ;No?? Then move down/right

M_E_UpLeft:
        ld a,(Enemy2Y)                  ;Y Coordinate into A
        cp 12                           ;Is it 12?
        jp z,Reset_E2_Dir               ;Change the Direction if so
        ld a,(Enemy2Y)                  ;Y Coord into A
        dec a                           ;Decrease it [Going Up]
        ld (Enemy2Y),a                  ;A into Enemy 2 Y
        ld a,(Enemy2X)                  ;Load Enemy 2 X into A
        dec a                           ;Decrement it
        ld (Enemy2X),a                  ;Loads A into Enemy2X
        call DispEnemyII                ;Display Enemy II
        ret                             ;Return

M_E_DownLeft:
        ld a,(Enemy3Y)                  ;Y Coordinate into A
        cp 46                           ;Is it 46?
        jp z,Reset_E3_Dir               ;Change the Direction if so
        ld a,(Enemy3Y)                  ;Y Coord into A
        inc a                           ;Increase it [Going Down]
        ld (Enemy3Y),a                  ;A into Enemy 2 Y
        ld a,(Enemy3X)                  ;Load Enemy 2 X into A
        dec a                           ;Increment it
        ld (Enemy3X),a                  ;Loads A into Enemy2X
        call DispEnemyIII               ;Display Enemy III
        ret                             ;Return


M_E_DownRight:
        ld a,(Enemy2Y)                  ;Y Coordinate into A
        cp 46                           ;Is it 46?
        jp z,Reset_E2_Dir               ;Change the Direction if so
        ld a,(Enemy2Y)                  ;Y Coord into A
        inc a                           ;Increase it [Going Down]
        ld (Enemy2Y),a                  ;A into Enemy 2 Y
        ld a,(Enemy2X)                  ;Load Enemy 2 X into A
        inc a                           ;Increment it
        ld (Enemy2X),a                  ;Loads A into Enemy2X
        call DispEnemyII                ;Display Enemy II
        ret                             ;Return

Level1Enemy:
	call DispEnemy			;XOR the Enemy Ship on the Screen
	ld a,(EnemyD)			;Enemy Direction into A
        or a                            ;Is it 0
	jr z,M_E_Right			;Move Target Right
	jr nz,M_E_Left			;Otherwise Move Left

M_E_Right:
	ld a,(EnemyX)			;Enemy X into A
        cp 75                           ;Is it 75
	jr z,ResetEnemyMove		;Reset Target to Move Other Direction
        cp 74                           ;Is it 74
	jr z,ResetEnemyMove		;Reset Target to Move Other Direction
        inc a                           ;Increase it again
        inc a                           ;Increase it again
	ld (EnemyX),a			;Into EnemyX
	call DispEnemy			;Replace Enemy on Screen
        ret                             ;Return

M_E_Left:
	ld a,(EnemyX)			;Enemy X into A
        cp 3                            ;Is it 3
	jr z,ResetEnemyMove		;Reset Enemy to Move Other Direction
        cp 4                            ;Is it 4
        jr z,ResetEnemyMove             ;Reset Enemy to Move Other Direction
        dec a                           ;Decrease it
        dec a                           ;Decrease it again
	ld (EnemyX),a			;Into EnemyX
	call DispEnemy			;Replace Enemy on Screen
        ret                             ;Return

ResetEnemyMove:
	ld a,(EnemyD)			;Load Enemy Direction into A
        or a                            ;Is it 0?
	jr z,ResetELeft			;Reset it to go left!
        xor a                           ;Loads 0 into a
	ld (EnemyD),a			;Loads A into Direction 
	jr M_E_Right			;Move Right

ResetELeft:
	ld a,1				;Load 1 into A
	ld (EnemyD),a			;Loads A into Target Direction
        jr M_E_Left                     ;Move Left

Reset_E2_Dir:
        ld a,(Enemy2D)                  ;Load Direction into a
        inc a                           ;Increase it
        cp 2                            ;If it is 2
        jp z,Make_E2Dir_UL              ;that means it was 1, d/r.. so switch
        ld a,1                          ;Otherwise, it was u/l, so switch
        ld (Enemy2D),a                  ;Load 1 into Direction
        jp M_E_DownRight               ;Goto DownRight Movement

Make_E2Dir_UL:
        xor a                            ;Make a be = to 0
        ld (Enemy2D),a                 ;Make that the direction
        jp M_E_UpLeft                   ;Move Up/Left

Reset_E3_Dir:
        ld a,(Enemy3D)                  ;Load Direction into a
        inc a                           ;Increase it
        cp 2                            ;If it is 2
        jp z,Make_E3Dir_UR              ;that means it was 1, d/l.. so switch
        ld a,1                          ;Otherwise, it was u/r, so switch
        ld (Enemy3D),a                  ;Load 1 into Direction
        jp M_E_DownLeft                 ;Goto DownLeft Movement

Make_E3Dir_UR:
        xor a                          ;Make a be = to 0
        ld (Enemy3D),a                 ;Make that the direction
        jp M_E_UpRight                 ;Move Up/Right

;----------------------
;|End of Game Routines
;----------------------
EndOfGame:
  ld hl,DiesStr				;String Name in HL

Message:	
  push hl                               ;Pushes it
  call Wee                              ;Scrolls
  ld hl,$404				;Loads Coords
  ld (_curRow),hl                       ;Into Cursor Row
  pop hl                                ;Pops the String
  call _puts				;Displays it
  call _getkey				;Waits for a key
  call _clrLCD                          ;Returns from Prog
  jr GameAllDone                        ;Game All Done, Check for Score, etc.

Wee:
  ld a,64
Byee:
   ld hl,$FC10
   ld de,$FC00
   ld bc,$3F0
   ldir
   halt
   halt
   dec a
   jr nz,Byee
   ret

GameAllDone:                ;we're working on score
    call UpdateScore
    ld hl,(Score)           ;Score into HL
    ex de,hl                ;We want your score in de
    ld hl,(HighScore)       ;get the high score
    or a                    ;clear carry flag
    sbc hl,de               ;because this subtraction includes the carry flag
    ret nc                  ;but it sets the carry flag if subtraction went over
                            ;if high is higher, go all the way back to start
    ex de,hl                ;now put _your_ score in hl, it was in de
    ld (HighScore),hl       ;and put in new high score
    ld hl,HighScoreName     ;this is used later
    jr HighScoreTime        ;and go to enter the initials

UpdateScore:
    ld hl,(Score)          ;now we get score
    ld de,StringPlace+4     ;start of unpacking
    ld b,5                  ;5 digits
UpdateScore2:
    call UNPACK_HL          ;divide hl by 10 and a contains remainder
    add a,'0'               ;asciiize it
    ld (de),a               ;put it in
    dec de                  ;next digit place to load
    djnz UpdateScore2       ;keep going
    ret

;-----------------
;enters the high scores
HighScoreTime:
    push hl                 ;saves the table to enter initials
    call _clrLCD            ;first we clear the screen, dum, de, dum
    ld hl,$0500             ;this is place for text
    ld (_curRow),hl         ;load it in
    ld hl,HighScoreStr      ;High Score!
    call _puts              ;put string
    ld hl,$0801             ;place for first initial
    ld (_curRow),hl         ;load it
    ld hl,StringPlace       ;this has your previous high score, from UpdateScore
    call _puts              ;put that score
    ld b,3                  ;3 initials as counter
    ld hl,$0903             ;place to put first initial
    ld (_curRow),hl         ;right there
    pop hl                  ;now this is the place to store initials, from before
InputLoop:
    push bc                 ;save the counter
    push hl                 ;save place to store initials
    ld a,$DF                ;this is ti-ascii for the cursor
    call _putc              ;put the cursor
    ld hl,_curCol           ;this is the after putting the cursor
    dec (hl)                ;put it back to where the cursor is
KeyLoop:
    call GET_KEY            ;gets the key
    ld c,a                  ;get table value from InputTable
    ld b,0                  ;
    ld hl,InputTable
    add hl,bc               ;by adding the keyvalue to InputTable
    ld a,(hl)               ;and get the value
    or a                    ;if it is zero
    jr z,KeyLoop            ;we still need a key
    pop hl                  ;get the initial address back
    ld (hl),a               ;and load the first initial
    inc hl                  ;and move to the next initial
    call _putc              ;put that initial
    pop bc                  ;counter...
    djnz InputLoop          ;and get all three
    ld de,$FFFF             ;or not, at which point we set up a delay
LoopWait:
    dec de                  ;you've seen this before
    ld a,d
    or e
    jr nz,LoopWait
    ret                     ;and all done, so go back to intro screen

;----------------------
;|Screen Setups
;----------------------

ScreenSetup:
	call GraphBufClear		;Clear GraphBuffer [so ILine doesn't mess up]
	call ScreenBox			;Draws a box around the screen
	ld b,85				;Set coordinates for line
	ld c,0				;These coordinates specify
	ld d,85				;the line that seperates
	ld e,64				;the game screen from the stats screen
        ld h,1                          ;h=1 is to let it draw points, not erase or xor
        call _ILine                     ;This tells the calc to draw the line
	ld b,86				;Setting coordinates for another line
   	ld c,48				;this line is the line under
        ld d,128                        ;the "Poke v 1.0" title
   	ld e,48				;setting coords to draw it
  	ld h,1				;h = 1 so it would draw
  	call  _ILine			;Draw the line!
	ld hl,2*256+90			;Setting Col = 90, Row = 2
	ld (_penCol),hl			;Putting that into PenCol
	ld hl,PokeStr			;Loading string into HL 
        call _vputs                     ;Display it! Small text, "Poke v 1.0"
	ld hl,9*256+95			;Sets Coords into HL
	ld (_penCol),hl			;Sets it into PenCol
	ld hl,ByMeStr			;String name into HL
        call _vputs                     ;Display, small size font [By: AE]
	ld hl,20*256+88			;Sets Coords agian
	ld (_penCol),hl			;Into PenCol
	ld hl,LiveStr			;String name into HL
        call _vputs                     ;Display it! [Lvs:]
	ld hl,27*256+88			;Sets Coords again
	ld (_penCol),hl			;Load HL into PenCol
	ld hl,ScorStr			;Load string name into HL
        call _vputs                     ;Display it! [Scr:]
	ld hl,41*256+88			;Sets Coords again
	ld (_penCol),hl			;Load into HL
	ld hl,HScrStr			;Load String Name into HL
        call _vputs                     ;Display it! [High Scr:]
        ;---------------------Variable Setup---------------------
	ld a,54				;54 into A
	ld (ShipY),a			;A into Ship's Y Coord
	ld a,30				;Loads 30 into A
	ld (EnemyY),a			;Loads A into EnemyY
        xor a                           ;Loads 0 into A
	ld (TargetD),a			;Loads A into Target Direction
	ld (EnemyD),a			;Loads A into Enemy Direction
        ld (Enemy2D),a                  ;Loads A into Enemy 2 Direction
        ld (Enemy3D),a                  ;Loads A into Enemy 3 Direction
        ld (Hits),a                     ;Number of hits = 0
        ld a,40                         ;Loads 40 into A
        ld (Enemy2Y),a                  ;Loads A into Enemy2Y
        ld (Enemy3Y),a                  ;Loads A into Enemy3Y
        ld a,65                         ;Loads 65 into A
        ld (Enemy2X),a                  ;A into Enemy2X
        ld a,12
        ld (Enemy3X),a
	ld a,2				;Loads 2 into A
	ld (TargetY),a			;Loads A into Target Y
	ld a,43				;43 into A
	ld (EnemyX),a			;A into EnemyX
	ld (ShipX),a			;A into ShipX
	ld (TargetX),a			;A into TargetX
        ;-----------------Finish Initializing----------------
        ld hl,27*256+105                ;Set Coords into HL
	ld (_penCol),hl			;Loads HL into PenCol
	ld hl,(Score)			;Variable into HL
        call DispHL                     ;Display HL
        ld hl,20*256+105                ;Set Coords into HL
	ld (_penCol),hl			;Loads HL into PenCol
	ld a,(Lives)			;Variable into A
        call DispA                      ;Display A
	call DispTarget			;Display Target
	call DispEnemy			;Display Enemy
        ret                             ;Return

NewVarInit:
        ld a,5				;Loads 5 into A
	ld (Lives),a			;Loads A into Lives
        ld a,1
        ld (Level),a
	ld hl,0				;Load 0 into HL
	ld (Score),hl			;Load HL into Score
        ret

ScreenBox:                              ;Draws a box around the screen
	ld b,0				;Sets Coordinates
	ld c,0				;Setting Coords
	ld d,0				;Setting Coords
	ld e,64				;Setting Coords
	ld h,1				;h = 1 for shading
        call _ILine                     ;Draw a line!
        ld b,126                        ;Set Coord for line
	ld c,0				;Set Coords
        ld d,126                        ;Set Coords
	ld e,64				;Set Coords
	ld h,1				;H = 1 for shading
        call _ILine                     ;Draw the Line!
	ld b,0				;Setting Coords
   	ld c,63				;Set Coords
        ld d,128                        ;Set Coords
   	ld e,63				;Set Coords
  	ld h,1				;H = 1 for Shading [2 = Unshade, 3 = XOR]
  	call  _ILine			;Draw the Line!
	ld b,0				;Setting Coords
   	ld c,1				;Set Coords
        ld d,128                        ;Set Coords
   	ld e,1				;Set Coords
  	ld h,1				;H = 1 for Shading
  	call  _ILine			;Draw the line!
        ret                             ;Return!

;-----------------------------------------------------------------------------
;|High Score Stuff, Obtained from Kollums 2.0, By: Alan Bailey
;------------------------------------------------------------------------------

DispHighScore:               ;now it works on the information
    ld hl,48*256+88	     ;Loads Coords for text
    ld (_penCol),hl	     ;Into PenCol
    ld hl,HighScore          ;High Score is our wanted Variable
    push hl                  ;Hides it in stack
    call LD_HL_MHL           ;gets the high score from mem
    ld de,StringPlace+4      ;sets de for putting score
    ld b,5                   ;5 characters in score
UpdateHigh:
    call UNPACK_HL           ;divides hl by 10 and has the remainder in a,
    add a,'0'                ;make digit ascii
    ld (de),a                ;load it into stringplace, ready for displaying
    dec de                   ;next spot to load
    djnz UpdateHigh          ;and go to UpdateHigh for next 4 characters
    ld hl,StringPlace        ;now it contains the score, asciiized and zero-terminated
    call _vputs              ;display the score
    ld a,(_penCol)           ;get the Col from mem
    ld b,4                   ;increase it
    add a,b                  ;like that
    ld (_penCol),a           ;and load it back
    pop hl                   ;this is the address to high score
    inc hl                   ;right after it is Initials, so this increments to that
    inc hl                   ;increment again
    call _vputs              ;and put the Initials of High Scorer
    ret                      ;Return from call

;------------------------------
;|Misc. Routines
;------------------------------

GraphBufClear:		     		;Clears the graph buffer, so _ILine doesn't mess up
	ld hl,GRAPH_MEM	     		;GraphMem into HL
	ld (hl),0            		;Loads 0 into it
	ld de,GRAPH_MEM+1    		;Loads GraphMem+1 into de
        ld bc,1024                      ;Loads the 1024 into bc
        ldir                            ;Draws on screen
	set graphdraw,(iy+graphflags)	;Sets Flag
        ret                             ;Return from Call

DispA:					;Routine to Display A [By: Matthew Shepcar]
 ld l,a					;Loads a into l
 ld h,0					;0 into H
DispHL:					;Displays HL [By: Matthew Shepcar]
 xor a					;Loads 0 into A
 ld de,-1                               ;Loads -1 into DE
 ld (_curRow),de                        ;Loads de into CurRow
 call 4A33h                             ;Calls 4A33h
 dec hl					;Decrease it
 jp _vputs                              ;Put on screen and return

Delay:					;Delay Loop, converted from Dan Eble's 85 Bounce
	PUSH AF				;hide current AF value
	PUSH BC				;hide current BC value 
        LD BC,$1000                     ;dlay length->bc
delayLoop:
	DEC BC				;bc-1->bc
	LD A, B				;Loads b into a
        OR C                            ;Checks if c=0
        JR NZ, delayLoop                ;if not, continue loop 
	POP BC				;unhide current BC value
	POP AF				;unhide current AF value 
        ret                             ;Return to Call


;-----------------------------
;|Sprites
;-----------------------------

PlayerShip:
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %11111111
	.db %11010101
	.db %10101011
	.db %11111111

EnemyShip:
	.db %00000000
	.db %00000000
	.db %00000000
	.db %11111111
	.db %11111111
	.db %00000000
	.db %00000000
	.db %00000000

Enemy2Ship:
        .db %00000000
        .db %00000000
        .db %00000000
        .db %10101010
        .db %11111111
        .db %01010101
        .db %00000000
        .db %00000000

Enemy3Ship:
        .db %00000000
        .db %00000000
        .db %00000000
        .db %10101010
        .db %10000001
        .db %01010101
        .db %00000000
        .db %00000000


TargetShip:
	.db %11111111
	.db %10011001
	.db %10011001
	.db %11111111
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000

FireBall:
	.db %00000000
	.db %00000000
	.db %00011000
	.db %00111100
	.db %01111110
	.db %00111100
	.db %00011000
	.db %00000000


;----------------------
;|Sprite Routine [XOR]
;----------------------
;------------------------------------------------------
;|This Routine was converted by AVD from Movax's 83
;|Special thanks to ScaBBy for making it XOR Routine!
;------------------------------------------------------

;hl = image
;a = x coord
;e = y coord

PutSprite:
       push    hl              ; Save sprite address

;   Calculate the address in graphbuf   

        ld      hl,0            ; Do y*12
        ld      d,0
	ex	de,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl

        ld      d,0             ; Do x/8
        ld      e,a
        srl     e
        srl     e
        srl     e
        add     hl,de

        ld      de,$FC00
        add     hl,de           ; Add address to graphbuf

        ld      b,00000111b     ; Get the remainder of x/8
        and     b
        cp	0               ; Is this sprite aligned to 8*n,y?
        jp      z,ALIGN


;   Non aligned sprite blit starts here   

        pop     ix              ; ix->sprite
        ld      d,a             ; d=how many bits to shift each line

        ld      e,8             ; Line loop
LILOP:  ld      b,(ix+0)        ; Get sprite data

        ld      c,0             ; Shift loop
        push    de
SHLOP:  srl     b
        rr      c
        dec     d
        jp      nz,SHLOP
        pop     de

        ld      a,b             ; Write line to graphbuf
        xor     (hl)
        ld      (hl),a
        inc     hl
        ld      a,c
        xor     (hl)
        ld      (hl),a

        ld      bc,15           ; Calculate next line address
        add     hl,bc
        inc     ix              ; Inc spritepointer

        dec     e
        jp      nz,LILOP        ; Next line

        jp      DONE1


;   Aligned sprite blit starts here   

ALIGN:                          ; Blit an aligned sprite to graphbuf
        pop     de              ; de->sprite
        ld      b,8
ALOP1:  ld      a,(de)
        xor      (hl)            ; xor=erase/blit
        ld      (hl),a
        inc     de
        push    bc
        ld      bc,16
        add     hl,bc
        pop     bc
        djnz    ALOP1

DONE1:
        ret
; SPRITE 


;------------------------------------
;|Begin Data [Text, Variables, Etc.]
;------------------------------------

Title:	.db	"Poke 1.0 - By: Ahmed El-Helw",0
PokeStr:	.db	"Poke 1.0",0
ByMeStr:	.db	"By: AE  ",0
LiveStr:	.db	"Lvs:",0
ScorStr:	.db	"Scr:",0
HScrStr:	.db	"High Scr:",0
DiesStr:	.db	"- Game Over -",0
BlankStr:       .db     "             ",0
HighScoreStr:   .db     "High Score!",0

ShipX:		.db	0			;Ship's X Coord
ShipY:		.db	0			;Ship's Y Coord [Constant]
FireX:		.db	0			;Weapon's X Coord
FireY:		.db	0			;Weapon's Y Coord
FireZ:		.db	0			;Weapon Fired or No?
TargetX:        .db     0                       ;Target's X Coord
TargetY:        .db     0                       ;Target's Y Coord
TargetD:        .db     0                       ;Target's Direction
EnemyX:		.db	0			;Enemy's X Coord
EnemyY:		.db	0			;Enemy's Y Coord
EnemyD:		.db	0			;Enemy's Direction
Enemy2X:        .db     0
Enemy2Y:        .db     0
Enemy2D:        .db     0
Enemy3X:        .db     0
Enemy3Y:        .db     0
Enemy3D:        .db     0
Lives:		.db	0			;Lives Remaining
Hits:           .db     0                       ;The Number of Hits
Level:          .db     0                       ;The Level you are on

Temp:           .db     0,0                     ;Temporary Variable
Score:		.db	0,0			;Current Score

HighScore:      .db $01,$00
HighScoreName:  .db 'A','R','E',$00 
StringPlace:	.db 0,0,0,0,0,0

;This is the key table, takes the value from call GET_KEY
;and converts it to this ascii character

InputTable:
    .db 0,0,0,0,0,0,0,0,0,0
    .db 'X','T','O','J','E',0,0
    .db ' ','W','S','N','I','D',0,0
    .db 'Z','V','R','M','H','C',0,0
    .db 'Y','U','Q','L','G','B',0,0,0,0
    .db 'P','K','F','A',0,0,0,0,0,0,0,0,0,0

.end
END
