; PLAINJUMP (C) 1997 BY ANDREAS ESS
;	    TUFERS 11
;	    A-6811 GOEFIS
;	    AUSTRIA/EUROPE
;	    ess.andreas@computerhaus.at
;	    http://andi.ganymed.org
;
; TI-86 port made was by Jimmy Mrdell <mja@algonet.se> with permission

#include asm86.h
#include ti86asm.inc
#include ti86ops.inc

INC_AHL   = $4637
READ_AHL  = $46C3
SWAP_RAM7 = $47F3

;---------------------------
; Variables in text-memory:
;---------------------------

LEVELY	    = _textShadow    ;position in level
JUMPFLAG    = _textShadow+1  ;0 = no jump; 1 = up; 2 = down
SPEED	    = _textShadow+2  ;speed of ball
LIFE	    = _textShadow+3  ;lifes of player
SCORE	    = _textShadow+4  ;contains player's score
BALLY	    = _textShadow+6  ;only needed for savegame
BALLX	    = _textShadow+7
LEVELNAME   = _textShadow+8

SAVELEN     = 18

SCROLLY     = _textShadow+21 ;position in level-y
SCROLLY1    = _textShadow+22 ;
SCROLLY2    = _textShadow+23 ;
WHATPLAIN   = _textShadow+24

LEVELPT     = _textShadow+42 ;pointer to level data
ORIGLVL     = _textShadow+44 ;pointer to start of level
PLAYERPT1   = _textShadow+46 ;pointer to black-player image
ANICOUNT    = _textShadow+48 ;animation counter


HiScoreTemp = _textShadow+28
TempByte    = _textShadow+30
ANISCROLLC  = _textShadow+31

LvlNo	    = _textShadow+35
Top	    = _textShadow+36
LvlMinusTop = _textShadow+37

Levels	    = _plotSScreen

BackgroundTemp	= _cmdShadow

BITMAPMEM   = _plotSScreen

.org _asm_exec_ram

Title:
 call _runindicoff
 res 1,(iy+$0D)
 call _clrLCD

 ld hl,_textShadow
 ld bc,167
 call ClearMem	; Clear _textShadow (reset variables)

 ld ix,TitlePicture
 ld hl,$FC20
 call ZCP  ; Extract ZCP picture from IX to HL
 ld hl,$2C29
 ld (_penCol),hl
 ld hl,ByStr
 call _vputs
 ld de,$3310
 ld (_penCol),de
 call _vputs
 ld de,$3A0A
 ld (_penCol),de
 call _vputs
Wait:
 call _getky
 or a
 jr z,Wait

 ld hl,LevelSaved
 ld a,(hl)
 or a
 jr nz,LoadGame
 call LoadLevel
 jp c,QuickQuit
 jr RegularGame

LoadGame:
 ld (hl),0
 inc hl
 ld bc,SAVELEN
 ld de,LEVELY
 ldir	;Copy saved game to _textShadow
 ld hl,LEVELNAME
 call ReadLevel
 jp c,QuickQuit
 ld a,(LEVELY)
 ld e,a
 ld d,0
 add hl,de
 ld bc,(BALLY)
 jr SetParams

RegularGame:
 ld a,6
 ld (life),a
 ld bc,$342E
SetParams:
 ld (ORIGLVL),hl
 ld (LEVELPT),hl
 ld hl,BlackBall1
 ld (PLAYERPT1),hl
 jr StartGameLoop

StartAfterLife:
 ld bc,$342E
StartGameLoop:
 call DisplayInfo
 ld hl,$0203
 ld (_curRow),hl
 ld hl,LifeStatus
 call _puts
 ld a,(LIFE)
 ld h,0
 ld l,a
 call DT_HL_DECI
WaitInfo:
 halt
 push bc
 call _getky
 pop bc
 or a
 jr z,WaitInfo
 call ClearDBuf
 call DrawScreen
 call ScanBk

;-------------------------------------------------------------------------------
;The game loop:
;-------------------------------------------------------------------------------
GameLoop:
 di
 call DrawBk
 ld a,c
 cp 46
 jr nz,TestKeys
 push bc
 ld a,b
 add a,8
 ld b,a
 ld c,60
 call FIND_PIXEL
 ld de,BITMAPMEM
 add hl,de
 and (hl)
 pop bc
 jp z,LostLife
TestKeys:
 push bc
 ld a,$FE
 out (1),a
 in a,(1)
 ld b,a
 ld a,$BF
 out (1),a
 in a,(1)
 or $0F
 and b
 pop bc
 cp $FF
 jp z,Redraw
TestLeftKey:
 ld d,a
 ld a,(SPEED)
 ld e,a
 bit 1,d
 jr nz,TestRightKey
 ld a,b
 cp 2
 jr c,TestRightKey
 dec b
 ld a,e
 cp 3
 jr nz,TestRightKey
 dec b
TestRightKey:
 bit 2,d
 jr nz,TestUpKey
 ld a,b
 cp 111
 jr nc,TestUpKey
 inc b
 ld a,e
 cp 3
 jr nz,TestUpKey
 inc b
TestUpKey:
 bit 3,d
 jr nz,TestDownKey
 ld a,e
 cp 3
 jr nc,TestDownKey
 inc e
TestDownKey:
 bit 0,d
 jr nz,Test2ndKey
 ld a,e
 or a
 jr z,Test2ndKey
 dec e
Test2ndKey:
 ld a,e
 ld (SPEED),a
 bit 5,d
 jr nz,TestExitKey
 ld a,(JUMPFLAG)
 or a
 jr nz,TestExitKey
 inc a
 ld (JUMPFLAG),a
TestExitKey:
 bit 6,d
 jp z,ExitGame
TestPauseKey:
 bit 7,d
 jp z,Pause
TestF1Key:
 bit 4,d
 jp z,LSaveGame

Redraw:
 ld a,(JUMPFLAG)
 or a
 jr z,ReallyRedraw
 dec a
 jr nz,FlyDown
 ld a,c
 cp 20
 jr z,SetFlyDown
 dec c
 jr ReallyRedraw
SetFlyDown:
 ld a,2
 ld (JUMPFLAG),a
FlyDown:
 ld a,c
 cp 46
 jr nz,FlyDown1
 xor a
 ld (JUMPFLAG),a
 jr ReallyRedraw
FlyDown1:
 inc c
ReallyRedraw:
 ld a,(SPEED)
 or a
 jr z,RedrawBall
 push bc
 ld b,a
DoScrolling:
 call DoScroll
 djnz DoScrolling
 pop bc

RedrawBall:
 call ScanBk
 ld de,WhiteBall
 call WhiteSprite
 ld de,(PLAYERPT1)
 call BlackSprite

 ld a,(ANISCROLLC)
 ld hl,SPEED
 add a,(hl)
 ld (ANISCROLLC),a
 cp 6
 jr c,GoOnMainLoop

 xor a
 ld (ANISCROLLC),a
 ld hl,ANICOUNT
 inc (hl)
 ld a,(hl)
 cp 3
 jr nz,NextFrame
 ld (hl),0
 ld hl,BlackBall1
 ld (PLAYERPT1),hl
 jr GoOnMainLoop
NextFrame:
 ld hl,(PLAYERPT1)
 ld de,32
 add hl,de
 ld (PLAYERPT1),hl

GoOnMainLoop:
 ld de,$FC00
 ld hl,BITMAPMEM
 push bc
 ld bc,1024
 ldir
 pop bc
J2GameLoop:
 jp GameLoop

Pause:
 push bc
 call _getky
 pop bc
 or a
 jr z,Pause
 jr J2GameLoop

LostLife:
 ei
 xor a
 ld (SPEED),a
NoFade:
 ld a,(LIFE)
 dec a
 jr z,GameOver
 call _clrLCD
 ld (LIFE),a
 xor a
 ld hl,SCROLLY
 ld (hl),a
 inc hl
 ld (hl),a
 inc hl
 ld (hl),a
 inc hl
 ld (hl),a
 ld hl,(LEVELPT)
FindStone:
 dec hl
 ld (LEVELPT),hl
 ld a,(LEVELY)
 dec a
 ld (LEVELY),a
 jp z,StartAfterLife
 ld c,$80
 ld b,1
FindStone1:
 ld a,(hl)
 and c
 jr nz,FoundDone
 srl c
 jr z,FindStone
 ld a,b
 add a,16
 ld b,a
 jr FindStone1
FoundDone:
 ld c,46
 jp StartGameLoop

GameOver:
 call HiScoreHand
 jr ExitGame

LSaveGame:
 ld (BALLY),bc
 ld hl,LevelSaved
 ld (hl),1
 inc hl
 ld de,LEVELY
 ex de,hl
 ld bc,SAVELEN
 ldir
ExitGame:
 call ClearDBuf
 call _getky
QuickQuit:
 ei
 ld hl,ProgName
 rst 20h
 rst 10h
 ex de,hl
 ld a,b
 ld de,LevelSaved-_asm_exec_ram+4 ; offset to start of where to store
 add hl,de
 adc a,0  ; add AHL with DE
 ld de,LevelSaved
 ld b,11+SAVELEN  ; bytes to store
RepCopy:
 push af
 push hl
 call $46C3
 ld a,(de)
 ld (hl),a
 pop hl
 pop af
 call $4637
 inc de
 djnz RepCopy

 set 1,(iy+$0D)
 res 0,(iy+$03)
 call _clrScrn
 ld hl,0
 ld ($C00F),hl
 ret

;-----------------------------------------------------------
; ClearDBuf: clears graphmem which is used as double buffer
;-----------------------------------------------------------
ClearDBuf:
 push bc
 ld hl,BITMAPMEM
 ld bc,1023
 call ClearMem	;ClearMem clears bc+1 bytes at hl
 pop bc
 ret

;---------------------------------------------------------------
; WhiteLine: draws a horizontal, white line from (B,D) to (C,D)
;---------------------------------------------------------------
WhiteLine:
 push hl
 push de
 ld a,c
 sub b
 push af
 ld c,d
 call FIND_PIXEL
 ld de,BITMAPMEM
 add hl,de
 ld b,a
 pop af
 ld c,a
WLoop:
 ld a,b
 cpl
 and (hl)
 ld (hl),a
 dec c
 jr z,EndWhite
 rrc b
 jr nc,WLoop
 inc hl
 jr WLoop
EndWhite:
 pop de
 pop hl
 ret

;---------------------------------------------------------------
; BlackLine: draws a horizontal, black line from (B,D) to (C,D)
;---------------------------------------------------------------
BlackLine:
 push hl
 push de
 ld a,c
 sub b
 push af
 ld c,d
 call FIND_PIXEL
 ld de,BITMAPMEM
 add hl,de
 ld b,a
 pop af
 ld c,a
BLoop:
 ld a,(hl)
 or b
 ld (hl),a
 dec c
 jr z,EndBlack
 rrc B
 jr nc,BLoop
 inc hl
 jr BLoop
EndBlack:
 pop de
 pop hl
 ret

;-----------------------------------------------------------------
; DrawLine: this draws a line at y-pos D, accoriding to bits in E
;-----------------------------------------------------------------
DrawLine:
 push bc
 push ix
 ld ix,StartLine
 ld b,0
 ld c,d
 sla c
 add ix,bc
 add ix,bc
 ld l,$80
DrawLine_Loop1:
 ld a,63
 sub (ix)
 ld b,a
 ld a,63
 sub (ix+1)
 ld c,a
 bit 4,l
 jr z,NotMiddle
 ld c,63
NotMiddle:
 inc ix
 ld a,e
 and l
 jr z,WhiteLine_1
 call BlackLine
 jr DrawLine_Loop1_2
WhiteLine_1:
 call WhiteLine
DrawLine_Loop1_2:
 rrc l
 ld a,l
 cp $08
 jr nz,DrawLine_Loop1
 dec ix
 ld b,63
 jr SkipMiddle
DrawLine_Loop2:
 ld a,(ix+1)
 add a,63
 ld b,a
SkipMiddle:
 ld a,(ix)
 add a,63
 ld c,a
 dec ix
 ld a,e
 and l
 jr z,WhiteLine_2
 call BlackLine
 jr DrawLine_Loop2_2
WhiteLine_2:
 call WhiteLine
DrawLine_Loop2_2:
 rrc l
 jr nc,DrawLine_Loop2
 pop ix
 pop bc
 ret

;------------
; Drawscreen
;------------
DrawScreen:
 push bc
 ld ix,(LEVELPT)
 ld e,(ix)
 ld b,31
DrawScrLoop:
 ld a,b
 add a,32
 ld d,a
 call DrawLine
 djnz DrawScrLoop
 ld e,(IX+1)
 ld b,21
DrawScrLoop1:
 ld a,b
 add a,11
 ld d,A
 call DrawLine
 djnz DrawScrLoop1
 ld e,(ix+2)
 ld b,11
DrawScrLoop2:
 ld d,b
 call DrawLine
 djnz DrawScrLoop2
 pop bc
 ret

;-----------------------------
; DoScroll: handles scrolling
;-----------------------------
DoScroll:
 ld hl,SCROLLY
 inc (hl)
 ld a,(hl)
 cp 32
 jr nz,LoadhlScr
 xor a
 ld (hl),a
 ld d,a
 ld h,a
 ld l,a
 ld (SCROLLY1),hl
 ld (_penCol),hl
 ld hl,(SCORE)
 call DM_HL_DECI
 push bc
 ld b,6
 ld de,BITMAPMEM
 ld hl,$FC00
CopyVid2Grf:
 push bc
 ldi
 ldi
 ldi
 ld bc,13
 add hl,bc
 ex de,hl
 add hl,bc
 ex de,hl
 pop bc
 djnz CopyVid2Grf
 pop bc
 ld a,(LEVELY)
 inc a
 cp 251
 jr nz,NoBonus
Bonus:
 ld hl,LIFE
 inc (hl)
NoBonus:
 cp 253
 jr nz,GoOnScroll
 xor a
 ld hl,(ORIGLVL)
 inc hl
 ld (LEVELPT),hl
GoOnScroll:
 ld (LEVELY),a
 ld hl,(SCORE)
 ld d,0
 ld a,(SPEED)
 ld e,a
 add hl,de
 ld (SCORE),hl
 ld hl,(LEVELPT)
 inc hl
 ld (LEVELPT),hl
LoadhlScr:
 ld a,(WHATPLAIN)
 inc a
 cp 4
 jr nz,WhatPlain_Set
 ld a,1
WhatPlain_Set:
 ld (WHATPLAIN),a
 cp 2
 jr z,Plain_2
 cp 3
 jr z,Plain_3
Plain_1:
 ld a,(SCROLLY1)
 inc a
 ld (SCROLLY1),a
 ld d,a
 ld hl,(LEVELPT)
 inc hl
 inc hl
 ld e,(hl)
 call DrawLine
Plain_2:
 ld a,(SCROLLY2)
 inc a
 ld (SCROLLY2),a
 add a,10
 ld d,a
 ld hl,(LEVELPT)
 inc hl
 ld e,(hl)
 call DrawLine
Plain_3:
 ld a,(SCROLLY)
 add a,32
 ld d,a
 ld hl,(LEVELPT)
 ld e,(hl)
 call DrawLine
 ret

;---------------------------------------------------------
; ScanBk: stores background from(B,C)-(B+16,C+16) in BKPT
;---------------------------------------------------------
ScanBk:
 push bc
 call FIND_PIXEL
 ld de,BITMAPMEM
 add hl,de
 ld de,BackgroundTemp
 ld b,16
ScanLoop:
 push bc
 call _mov3b
 ld bc,13
 add hl,bc
 pop bc
 djnz ScanLoop
 pop bc
 ret

;--------------------------------------------------------
; DrawBk: draws background from(B,C)-(B+16,C+16) in BKPT
;--------------------------------------------------------
DrawBk:
 push bc
 call FIND_PIXEL
 ld de,BITMAPMEM
 add hl,de
 ld de,BackgroundTemp
 ex de,hl
 ld b,16
PutLoop:
 push bc
 call _mov3b
 ld bc,13
 ex de,hl
 add hl,bc
 ex de,hl
 pop bc
 djnz PutLoop
 pop bc
 ret

;---------------------------------------------------------
; WhiteSprite: draws each white element of a 16*16 sprite
;---------------------------------------------------------
WhiteSprite:
 push bc
 push de
 ld a,32
 ld (TempByte),a
 call FIND_PIXEL
 ld de,BITMAPMEM
 add hl,de
 pop de
 ld c,a
 ld b,128
WSLoop:
 ld a,(de)
 and b
 jr nz,WSLoop1
 ld a,c
 cpl
 and (hl)
 ld (hl),a
WSLoop1:
 rrc c
 jr nc,WSLoop2
 inc hl
WSLoop2:
 rrc b
 jr nc,WSLoop
WSNextLine:
 inc de
 ld a,(TempByte)
 dec a
 ld (TempByte),a
 jr z,WSEndBMP
 bit 0,a
 jr nz,WSLoop
 push de
 ld de,14
 add hl,de
 pop de
 jr WSLoop
WSEndBMP:
 pop bc
 ret

;---------------------------------------------------------
; BlackSprite: draws each black element of a 16*16 sprite
;---------------------------------------------------------
BlackSprite:
 push bc
 push de
 ld a,32
 ld (TempByte),a
 call FIND_PIXEL
 ld de,BITMAPMEM
 add hl,de
 pop de
 ld c,a
 ld b,128
BSLoop:
 ld a,(de)
 and b
 jr z,BSLoop1
 ld a,(hl)
 or c
 ld (hl),a
BSLoop1:
 rrc c
 jr nc,BSLoop2
 inc hl
BSLoop2:
 rrc b
 jr nc,BSLoop
BSNextLine:
 inc de
 ld a,(TempByte)
 dec a
 ld (TempByte),a
 jr z,BSEndBMP
 bit 0,a
 jr nz,BSLoop
 push de
 ld de,14
 add hl,de
 pop de
 jr BSLoop
BSEndBMP:
 pop bc
 ret

;-----------------------------------------------------------------------------
;Handle Hi-score
;-----------------------------------------------------------------------------
HiScoreHand:
 call _clrLCD
 ld hl, HiScore
 call LD_HL_MHL
 ld de,(SCORE)
 ld (HiScoreTemp),de
 call CP_HL_DE
 ret nc
 ld hl,HiScore
 ex de,hl
 ld hl,HiScoreTemp
 ld c,2
 ldi
 ldi
 ld hl,$0300
 ld (_curRow),hl
 ld hl,HiScr
 call _puts
 ld de,$0A1F
 ld (_penCol),de
 call  _vputs
 ld hl, $0803
 ld (_curRow),hl
 ld hl,HiScrName
 ld c,3
 push hl
 ld d,$41
 ld a,(_curCol)
 ld e,a
 ld b,0
 jr InvLet
WaitKey:
 push bc
 push de
 push hl
 call _getky
 pop hl
 pop de
 pop bc
 cp K_UP
 jr z,LetUp
 cp K_DOWN
 jr z,LetDown
 cp K_SECOND
 jr nz,WaitKey
 ld (hl),d
 inc hl
 ld a,d
 call _putc
 inc e
 inc b
 ld a,c
 cp b
 jr nz,InvLet
 ld (hl),0
 pop hl
 ret
LetUp:
 inc d
 ld a,d
 cp $5B
 jr nz,InvLet
 ld d,$41
 jr InvLet
LetDown:
 dec d
 ld a,d
 cp $40
 jr nz,InvLet
 ld d,$5A
InvLet:
 set 3,(iy+$05)
 ld a,d
 call _putc
 ld a,e
 ld (_curCol),a
 res 3,(iy+$05)
 jr WaitKey

DisplayInfo:
 push bc
 call _clrLCD
 ld hl,$FC00
 call Invert
 ld hl,-112
 call Invert
 ld hl,$0001
 ld (_penCol), hl
 set 3,(iy+$05)
 ld hl,Instr
 call _vputs
 ld a,82
 ld (_penCol),a
 ld hl,HiScrTxt
 call _vputs
 call LD_HL_MHL
 call DM_HL_DECI
 ld hl,$390D
 ld (_penCol),hl
 ld hl,EMail
 call _vputs
 res 3,(iy+$05)
 pop bc
 ret

LoadLevel:
 call DisplayInfo
 ld ix,Levels
 xor a
 ld (LvlNo),a
 call SWAP_RAM7
 ld hl,$BFFF
SearchLoop:
 ld de,($D298)
 inc de
 or a
 sbc hl,de
 jr c,SearchDone
 add hl,de
 ld a,(hl) ; A=var type
 dec hl
 ld e,(hl)
 dec hl
 ld d,(hl)
 dec hl
 cp $0C
 ld a,(hl) ; ADE = ABS address to variable data
 push hl
 jr nz,ContinueSearch
 ex de,hl  ; AHL -> variable data
 call INC_AHL ; Increase AHL twice (skip length)
 call INC_AHL
 ld c,a
 push hl
 call READ_AHL ; A = byte at AHL (RAM page changed)
 cp 3 ; Check first header byte
 pop hl
 ld a,c
 jr nz,NotPJLevel
 call INC_AHL
 call READ_AHL
 or a ; Check second header byte
 jr nz,NotPJLevel
 call SWAP_RAM7
 pop hl ; hl -> VAT entry
 dec hl
 dec hl
 ld b,(hl) ; B = var name len
 ld (ix),b
 push ix
CopyName:
 inc ix
 dec hl
 ld a,(hl)
 ld (ix),a
 djnz CopyName
 dec hl
 pop ix
 ld de,9
 add ix,de
 ld a,(LvlNo)
 inc a
 ld (LvlNo),a
 jr SearchLoop
NotPJLevel:
 call SWAP_RAM7
ContinueSearch:
 pop hl
 dec hl
 dec hl
 ld b,(hl)
 inc b
SkipName:
 dec hl
 djnz SkipName
 jr SearchLoop

SearchDone:
 xor a
 ld (SetD+1),a
 ld a,(LvlNo)
 or a
 jp z,NoLevels
ShowLevels:
 ld hl,$0801
 ld (_penCol),hl
 ld hl,$FC00+112
 ld bc,799
 call ClearMem
 ld hl,(Top)
 ld h,9
 call MUL_HL
 ld de,Levels
 add hl,de
 ld b,8
 ld a,(LvlNo)
 cp 8
 jr nc,ShowLevel
 ld b,a
ShowLevel:
 push hl
 push bc
 ld b,(hl)
 inc hl
 call _vputsn
 pop bc
 pop hl
 ld de,9
 add hl,de
 ld a,(_penRow)
 add a,6
 ld (_penRow),a
 ld a,1
 ld (_penCol),a
 djnz ShowLevel
 ld hl,top
 ld a,(LvlNo)
 sub (hl)
 cp 8
 jr c,SetMax
 ld a,8
SetMax:
 ld e,a
 dec e
SetD:
 ld d,0
 call ShowBar
CL_KeyLoop:
 push de
 call _getky
 pop de
 cp K_DOWN
 jr z,ScrollDown
 cp K_UP
 jr z,ScrollUp
 cp K_ENTER
 jr z,AcceptLevel
 cp K_EXIT
 jr nz,CL_KeyLoop
 scf
 ret
ScrollDown:
 call ShowBar
 ld a,d
 cp e
 jr z,ScrollL_Down
 inc d
 jr ShowIt
ScrollL_Down:
 ld (SetD+1),a
 ld a,(LvlNo)
 sub 8
 jr c,ShowIt
 ld hl,Top
 cp (hl)
 jr z,ShowIt
 inc (hl)
 jp ShowLevels
ScrollUp:
 call ShowBar
 ld a,d
 or a
 jr z,ScrollL_Up
 dec d
 jr ShowIt
ScrollL_Up:
 ld (SetD+1),a
 ld a,(Top)
 or a
 jr z, ShowIt
 dec a
 ld (Top),a
 jp ShowLevels
ShowIt:
 call ShowBar
 jr CL_KeyLoop
AcceptLevel:
 ld a,(Top)
 add a,d
 ld l,a
 ld h,9
 call MUL_HL
 ld de,Levels
 add hl,de
 push hl
 ld de,LEVELNAME
 call _mov9b
 pop hl

ReadLevel:  ; Read level hl
 dec hl  ; First byte at _OP1 should not be used
 call _mov10toop1
 call _FINDSYM
 ret c
 ld a,b
 ex de,hl
 ld ix,LevelData
 ld bc,300
ContRead:  ; Copy level
 push af
 push hl
 call READ_AHL
 ld (ix),a
 inc ix
 pop hl
 pop af
 call INC_AHL
 ld d,a
 dec bc
 ld a,b
 or c
 ld a,d
 jr nz,ContRead
 ld hl,LevelData+4
 ret

NoLevels:
 ld hl, $0801
 ld (_penCol), hl
 ld hl, NoLevel
 call _vputs
 call OTH_PAUSE
 scf
 ret

ShowBar:
 push de
 ld l,d
 ld h,96
 call MUL_HL
 ld de,$FC80
 add hl,de
 call Invert
 pop de
 ret

Invert:
 ld bc,112
InvLoop:
 ld a,(hl)
 cpl
 ld (hl),a
 inc hl
 dec bc
 ld a,b
 or c
 jr nz,InvLoop
 ret

ClearMem:
 ld (hl),0
 ld d,h
 ld e,l
 inc de
 ldir
 ret

OTH_PAUSE:
 push bc
 push de
 push hl
WaitEnter:
 halt
 call _getky
 cp K_ENTER
 jr nz,WaitEnter
 pop hl
 pop de
 pop bc
 ret

DT_HL_DECI:
 push bc
 call ExtractWord
 push hl
 ld hl,_curCol
 ld a,(hl)
 add a,c
 ld (hl),a
 pop hl
 call _puts
 pop bc
 ret

DM_HL_DECI:
 push bc
 call ExtractWord
 push hl
 ld hl,_penCol
 ld a,(hl)
 sla c
 sla c
 add a,c
 ld (hl),a
 pop hl
 call _vputs
 pop bc
 ret

ExtractWord:
 ld de,_OP1+5
 xor a
 ld (de),a
 ld b,5
ConvLoop:
 call UNPACK_hl
 add a,'0'
 dec de
 ld (de),a
 djnz ConvLoop
 ld bc,$0400
Compare:
 ld a,(de)
 cp '0'
 jr nz,PrintString
 inc de
 inc c
 djnz Compare
PrintString:
 ex de,hl
 ret

FIND_PIXEL:
 push bc
 push de
 ld hl,ExpTable
 ld d,0
 ld a,b
 and $07
 ld e,a
 add hl,de
 ld e,(hl)
 ld h,d
 srl b
 srl b
 srl b
 ld a,c
 add a,a
 add a,a
 ld l,a
 add hl,hl
 add hl,hl
 ld a,e
 ld e,b
 add hl,de
 pop de
 pop bc
 ret

ExpTable:
 .db $80,$40,$20,$10,$08,$04,$02,$01

ZCP:
 ld (hl),0
 ld c,$80
ZCP_NextByte:
 inc ix
 ld a,(ix)
 or a
 ret z
 ld e,a
 bit 7,a
 jr nz,ZCP_Stream
 and $3F
 ld b,a
ZCP_Next:
 bit 6,e
 jr z,ZCP_WhiteLine
 ld a,(hl)
 or c
 ld (hl),a
ZCP_WhiteLine:
 rrc c
 jr nc,ZCP_SameByte
 inc hl
 ld (hl),0
ZCP_SameByte:
 djnz ZCP_Next
 jr ZCP_NextByte
ZCP_Stream:
 rl e
 ld b,7
ZCP_RepStream:
 rl e
 jr nc,ZCP_WhitePixel
 ld a,(hl)
 or c
 ld (hl),a
ZCP_WhitePixel:
 rrc c
 jr nc,ZCP_NextStream
 inc hl
 ld (hl),0
ZCP_NextStream
 djnz ZCP_RepStream
 jr ZCP_NextByte

;--------------------------
; Some important variables
;--------------------------

NoLevel:    .db "No level found!",0
Instr:	    .db "PJ 1.1 by AE",0
HiScr:	    .db "NEW HIGH SCORE!",0
EnterInit:  .db "ENTER YOUR INITIALS:",0
EMail:	    .db "ess.andreas@computerhaus.at",0
ByStr:	    .db "by Andreas Ess",0
	    .db "TI-86 port by Jimmy Mardell",0
TitTxt:     .db "Title picture by"
	    .db " Johannes Rajala",0
LifeStatus: .db "Lifes left:",0
ProgName:   .db $0C,2,"pj"

;------------------------
; This contains savegame
;------------------------

LevelSaved: .db 0  ;standard: no level saved
SavedLevel: .db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
HiScrTxt:   .db "Hi: "
HiScrName:  .db "AND",0
HiScore:    .dw 10	;This is standard hi-score

;-------------------------------------------
; This array contains startend-line indexes
;-------------------------------------------

StartLine:
 .db 16,12,8,4	  ;#0
 .db 17,13,8,4
 .db 17,13,9,4
 .db 18,13,9,4
 .db 19,14,10,5    ;#4
 .db 19,15,10,5
 .db 20,15,10,5
 .db 21,16,11,5
 .db 22,17,11,6    ;#8
 .db 23,17,11,6
 .db 23,18,12,6
 .db 24,18,12,6
 .db 25,19,13,6    ;#12
 .db 26,19,13,6
 .db 26,20,13,7
 .db 27,21,14,7
 .db 28,21,14,7    ;#16
 .db 29,22,14,7
 .db 29,22,15,7
 .db 30,23,15,8
 .db 31,23,16,8    ;#20
 .db 32,24,16,8
 .db 33,25,16,8
 .db 33,25,17,8
 .db 34,26,17,9    ;#24
 .db 35,26,18,9
 .db 35,27,18,9
 .db 36,27,18,9
 .db 37,28,19,9    ;#28
 .db 38,29,19,9
 .db 38,29,19,9
 .db 39,30,20,10
 .db 40,30,20,10    ;#32
 .db 41,31,21,10
 .db 41,31,21,10
 .db 42,32,21,11
 .db 43,33,22,11    ;#36
 .db 44,33,22,11
 .db 44,34,22,11
 .db 45,34,23,11
 .db 46,35,23,12    ;#40
 .db 47,35,24,12
 .db 47,36,24,12
 .db 48,37,24,12
 .db 49,37,25,12    ;#44
 .db 50,38,25,13
 .db 50,38,26,13
 .db 51,39,26,13
 .db 52,39,26,13    ;#48
 .db 53,40,27,13
 .db 54,41,27,14
 .db 55,41,27,14
 .db 55,42,28,14    ;#52
 .db 56,42,28,14
 .db 56,43,29,14
 .db 57,43,29,14
 .db 58,44,29,15    ;#56
 .db 59,45,30,15
 .db 59,45,30,15
 .db 60,46,30,15
 .db 61,46,31,15    ;#60
 .db 62,47,31,16
 .db 62,47,32,16
 .db 63,48,32,16


;------------
; Bitmapdata
;------------

WhiteBall:
 .db $FF,$FF,$FF,$FF,$F8,$3F,$E0,$0F,$C0,$07,$C0,$07,$80,$03,$80,$03
 .db $80,$03,$80,$03,$80,$03,$C0,$07,$C0,$07,$E0,$0F,$F8,$3F,$FF,$FF

BlackBall1:
 .db $00,$00,$07,$C0,$18,$30,$20,$08,$40,$04,$40,$04,$80,$02,$80,$02
 .db $80,$02,$C0,$06,$A0,$0A,$54,$54,$6A,$AC,$35,$58,$1A,$B0,$07,$C0

 .db $00,$00,$07,$C0,$18,$30,$20,$08,$40,$04,$40,$04,$8A,$A2,$D5,$56
 .db $AA,$AA,$D5,$56,$8A,$A2,$40,$04,$40,$04,$20,$08,$18,$30,$07,$C0

 .db $00,$00,$07,$C0,$1A,$B0,$35,$58,$6A,$AC,$54,$54,$A0,$0A,$C0,$06
 .db $80,$02,$80,$02,$80,$02,$40,$04,$40,$04,$20,$08,$18,$30,$07,$C0

TitlePicture:
 .db $00,$3F,$2C,$C0,$3F,$3F,$22,$C0,$0A,$C0,$3F,$A0,$3F,$2C,$C0,$80
 .db $E0,$22,$C0,$90,$84,$37,$E0,$FF,$39,$C0,$34,$4D,$19,$C0,$82,$81
 .db $0A,$E0,$1B,$E3,$80,$C0,$83,$F0,$98,$88,$10,$C0,$98,$98,$84,$BE
 .db $12,$C0,$BE,$FC,$10,$E2,$87,$B0,$12,$E0,$BC,$F0,$83,$E6,$18,$F6
 .db $EF,$82,$09,$E9,$E3,$C0,$13,$FB,$48,$0B,$E1,$E0,$09,$C0,$B9,$F0
 .db $F0,$A4,$8D,$9F,$98,$18,$FE,$8F,$0B,$E9,$FC,$C0,$09,$F0,$F0,$98
 .db $BC,$ED,$9F,$CC,$19,$F0,$8E,$84,$8D,$DC,$0B,$C0,$F0,$B0,$DC,$8F
 .db $BE,$9F,$E7,$1A,$E0,$87,$91,$EE,$B0,$0A,$E0,$F0,$88,$EC,$87,$FF
 .db $8F,$F3,$C0,$14,$E3,$E3,$E3,$4A,$83,$C1,$C1,$E8,$C5,$DC,$86,$F7
 .db $8F,$F3,$F0,$13,$E3,$F9,$F1,$DF,$F0,$FF,$9C,$87,$B1,$E1,$CC,$F7
 .db $B8,$BE,$B9,$C0,$10,$E3,$F9,$E3,$8F,$F9,$C3,$F8,$83,$CF,$D9,$DE
 .db $E3,$B9,$80,$F0,$90,$10,$E3,$F9,$C3,$8F,$CF,$80,$F8,$81,$FD,$CF
 .db $FB,$E2,$98,$E3,$E0,$17,$E1,$F3,$C3,$8F,$8F,$09,$F0,$87,$E6,$BF
 .db $CF,$08,$C7,$FC,$1B,$E0,$87,$C7,$8F,$8F,$C0,$8E,$83,$F9,$CF,$E1
 .db $C0,$88,$BE,$1F,$E8,$BF,$DC,$8E,$9F,$90,$8C,$87,$F3,$9F,$E1,$09
 .db $CB,$23,$E7,$4C,$83,$C7,$EE,$83,$C3,$9C,$E7,$F8,$A0,$84,$8C,$20
 .db $E3,$4C,$93,$C7,$E7,$C1,$C6,$8C,$E3,$F8,$A0,$82,$AC,$1F,$F0,$FF
 .db $BC,$F3,$8F,$CF,$E3,$D8,$98,$E3,$F2,$D0,$C4,$D8,$1D,$FC,$BF,$8E
 .db $B9,$C7,$E7,$F1,$F8,$8D,$B0,$B0,$A6,$C0,$B7,$1D,$E6,$8F,$CF,$9C
 .db $EB,$F3,$F8,$FE,$9E,$CC,$80,$D1,$E8,$8B,$F0,$16,$C3,$A3,$E7,$08
 .db $E3,$E3,$F8,$4C,$8B,$08,$C8,$FA,$A6,$EC,$15,$C0,$B4,$B1,$E1,$C5
 .db $BD,$BF,$9F,$FF,$8D,$C8,$B6,$9E,$F1,$D8,$A0,$18,$EC,$A3,$C0,$CA
 .db $F0,$FC,$B8,$F8,$B7,$CF,$C8,$BD,$D3,$B8,$1E,$F6,$97,$87,$8C,$F2
 .db $FC,$BA,$0A,$FE,$B9,$C7,$B3,$B9,$C0,$1A,$FA,$93,$F3,$E2,$B3,$BC
 .db $9B,$80,$FE,$BC,$9E,$B1,$F8,$BC,$1E,$FC,$E4,$8B,$E3,$F4,$F9,$89
 .db $C7,$F8,$9F,$F7,$F0,$EF,$F8,$1D,$E6,$F9,$E9,$F1,$FD,$FD,$09,$49
 .db $83,$FE,$9F,$80,$FC,$20,$E3,$FF,$88,$FC,$BF,$EE,$E0,$49,$B0,$B1
 .db $E0,$E0,$86,$22,$C1,$F3,$4A,$B1,$EC,$99,$D7,$F8,$98,$C0,$E0,$E0
 .db $84,$29,$E0,$49,$9F,$E0,$8E,$87,$E0,$84,$09,$C0,$C0,$98,$31,$FF
 .db $8F,$C0,$9F,$FF,$18,$C1,$08,$C0,$32,$F0,$0D,$4A,$0E,$C0,$14,$C0
 .db $33,$E0,$0B,$E1,$E0,$19,$C4,$3F,$98,$0A,$C0,$90,$27,$C0,$36,$C0
 .db $10,$C0,$3F,$88,$00

;-------------------------
; Temporary level storage
;-------------------------

LevelData:

.end

