#include "ti86asm.inc"
#include "asm86.h"

pinb 		= $C110
bitmask		= $C10D
clipmask	= $C10B
rows2put	= $C10C


.org _asm_exec_ram

	nop
	jp ProgStart
	.dw 0
	.dw ShellTitle

ShellTitle:
	.db "Pinball 86",0

ProgStart:
 call _flushallmenus		; close any open menus
 call _runindicoff			; turn off the run indicator
 ld hl,Pic					; point to RLE picture to display
 ld de,$fc00				; display picture in video memory
 call DispRLE				; decode and display the picture
 call _getkey
 ld hl,BackGround
 ld de,$fc00
 call DispRLE
 call putBlock
 call putBlock
 call putBlock
 call putBlock
 
Start:

 call putpaddles
 call main 
exit:
 call _clrLCD
 ret

main:
 call GET_KEY
 cp K_EXIT
 jp z,exit
 cp K_LEFT
 jp z,MoveLeft
 cp K_RIGHT
 jp z,MoveRight
 jp main 

putpaddles:
 ld hl,LeftFlipper1
 ld b,41
 ld c,56
 ld de,pinb
 call PutSprite
 ld hl,LeftFlipper2
 ld b,49
 ld c,56
 ld de,pinb
 call PutSprite
 ld hl,RightFlipper1
 ld b,81
 ld c,56
 ld de,pinb
 call PutSprite
 ld hl,RightFlipper2
 ld b,73
 ld c,56
 ld de,pinb
 call PutSprite
 ret
 
MoveLeft:
 ld b,41
 ld c,56
 ld hl,Blank
 call PutSprite
 ld b,49
 ld c,56
 ld hl,Blank
 call PutSprite
 ld hl,LeftFlip1
 ld b,41
 ld c,56
 ld de,pinb
 call PutSprite
 ld hl,LeftFlip2
 ld b,41
 ld c,48
 ld de,pinb
 call PutSprite
 ld hl,LeftFlip3
 ld b,49
 ld c,48
 ld de,pinb
 call PutSprite
 ld hl,LeftFlip4
 ld b,49
 ld c,56
 ld de,pinb
 call PutSprite
 ld hl,RightFlipper1
 ld b,81
 ld c,56
 ld de,pinb
 call PutSprite
 ld hl,RightFlipper2
 ld b,73
 ld c,56
 ld de,pinb
 call PutSprite
 call _getkey
 ld b,41
 ld c,56
 ld hl,Blank
 call PutSprite
 ld b,41
 ld c,48
 ld hl,Blank
 call PutSprite
 ld b,49
 ld c,48
 ld hl,Blank
 call PutSprite
 ld b,49
 ld c,56
 ld hl,Blank
 call PutSprite
 jp Start 
 
MoveRight:
 ld b,81
 ld c,56
 ld hl,Blank
 call PutSprite
 ld b,73
 ld c,56
 ld hl,Blank
 call PutSprite
 ld hl,RightFlip1
 ld b,81
 ld c,56
 ld de,pinb
 call PutSprite
 ld hl,RightFlip2
 ld b,81
 ld c,48
 ld de,pinb
 call PutSprite
 ld hl,RightFlip3
 ld b,73
 ld c,48 
 ld de,pinb
 call PutSprite
 ld hl,RightFlip4
 ld b,73
 ld c,56
 ld de,pinb
 call PutSprite
 ld hl,LeftFlipper1
 ld b,41
 ld c,56
 ld de,pinb
 call PutSprite
 ld hl,LeftFlipper2
 ld b,49
 ld c,56
 ld de,pinb
 call PutSprite
 call _getkey
 ld b,81
 ld c,56
 ld hl,Blank
 call PutSprite
 ld b,81
 ld c,48
 ld hl,Blank
 call PutSprite
 ld b,73
 ld c,48 
 ld hl,Blank
 call PutSprite
 ld b,73
 ld c,56
 ld hl,Blank
 call PutSprite
 jp Start 


Random: 	       ; Creates a random number 0 <= x < A
 push bc
 push de
 push hl
 ld b,a
 ld a,r
 add a,a
 ld hl,0
 ld d,0
 ld e,a
RMul:
 add hl,de
 djnz RMul
 ld a,h
 pop hl
 pop de
 pop bc
 ret

putBlock:
 ld a,103
 call Random
 inc a
 inc a
 inc a
 inc a
 inc a
 inc a
 inc a
 inc a
 inc a
 ld b,a
 ld a,41
 call Random
 inc a
 inc a
 inc a
 inc a
 inc a
 inc a
 inc a
 inc a
 inc a
 ld c,a
 ld hl,Block
 ld de,pinb
 call PutSprite_MSB

LeftFlipper1:
	.db %11110000
	.db %11111100
	.db %11111111
	.db %11111111
	.db %11111111
	.db %11111111
	.db %11111111
	.db %11111111

LeftFlipper2:
	.db %00000000
	.db %00000000
	.db %00000000
	.db %11000000
	.db %11110000
	.db %11111100
	.db %11111111
	.db %11111111

RightFlipper1:
	.db %00001111
	.db %00111111
	.db %11111111
	.db %11111111
	.db %11111111
	.db %11111111
	.db %11111111
	.db %11111111

RightFlipper2:
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000011
	.db %00001111
	.db %00111111
	.db %11111111
	.db %11111111

LeftFlip1:
	.db %11111111
	.db %11111111
	.db %01111111
	.db %01111111
	.db %00111111
	.db %00111111
	.db %00011110
	.db %00011100

LeftFlip2:
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00011111
	.db %01111111
	.db %11111111

LeftFlip3:
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %11111110
	.db %11111110
	.db %11111100

LeftFlip4:
	.db %11111000
	.db %11110000
	.db %11100000
	.db %11000000
	.db %10000000
	.db %00000000
	.db %00000000
	.db %00000000

RightFlip1:
	.db %11111111
	.db %11111111
	.db %11111110
	.db %11111110
	.db %11111100
	.db %11111100
	.db %01111000
	.db %00111000

RightFlip2:
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %11111000
	.db %11111110
	.db %11111111

RightFlip3:
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %01111111
	.db %01111111
	.db %00111111

RightFlip4:
	.db %00011111
	.db %00001111
	.db %00000111
	.db %00000011
	.db %00000001
	.db %00000000
	.db %00000000
	.db %00000000

Block:
	.db %00000000
	.db %00111100
	.db %01000010
	.db %01011010
	.db %01011010
	.db %01000010
	.db %00111100
	.db %00000000
	.db %00000000
	.db %00111100
	.db %01111110
	.db %01111110
	.db %01111110
	.db %01111110
	.db %00111100
	.db %00000000

Blank:
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000


; --- Sprite routines from Jimmy Mardell's SQRXZ ---

; PutSprite_MSB:
;  Puts an 8x8 sprite at coordinates B,C. HL should point to a bitmapped
;  sprite followed by a bitmapped mask, total 16 bytes. DE should point
;  to an a memory location where the background will be stored as a
;  bitmap (8 bytes). The sprite will be clipped.
PutSprite_MSB:
 ld a,c
 cp 150
 jr nc,PMSB_NoBotClip
 cp 64
 ret nc
PMSB_NoBotClip:
 push bc
 ld a,$FF
 ld (clipmask),a
 bit 7,b
 jr z,PMSB_CheckRightClip
 ld a,b
 cp 249
 jr c,EndPMSB
 neg
 push bc
 ld b,a
 ld a,$FF
PMSB_LeftClip:
 srl a
 djnz PMSB_LeftClip
 pop bc
 res 7,b
 dec c
 ld (clipmask),a
 jr PMSB_CheckBotClip
PMSB_CheckRightClip
 ld a,b
 sub 120
 jr c,PMSB_CheckBotClip
 push bc
 ld b,a
 inc b
 ld a,$FF
PMSB_RightClip:
 add a,a
 djnz PMSB_RightClip
 ld (clipmask),a
 pop bc
PMSB_CheckBotClip:
 ld a,8
 ld (rows2put),a
 bit 7,c
 jr nz,PMSB_CheckTopClip
 bit 6,c
 jp nz,EndMSB
 ld a,64
 sub c
 cp 8
 jr nc,PMSB_ClippingDone
 ld (rows2put),a
 jr PMSB_ClippingDone
PMSB_CheckTopClip:
 ld a,c
 cp 249
EndPMSB:
 jr c,EndMSB
 ret c
 push bc
 neg
 ld b,a
 sub 8
 neg
 ld (rows2put),a
PMSB_TopClip:
 inc hl
 inc de
 djnz PMSB_TopClip
 pop bc
 ld c,0
PMSB_ClippingDone:
 di
 push iy
 push hl
 pop iy
 push de
 pop ix
 ld a,(rows2put)
 push af
 call FIND_PIXEL
Modify_5:
 ld de,$FC00
 add hl,de
 ld (bitmask),a
 pop bc
PMSB_PutRow:
 push bc
 push hl
 ld a,(clipmask)
 ld e,a
 ld a,(iy+8)
 and e
 ld e,a 	 ; e = mask for this row
 ld d,0 	 ; d = background for this row
 ld b,8 	 ; b = pixels left to put
 ld c,(iy) ; c = sprite row
 inc iy
PMSB_PutCol:
 push bc
 sla d
 ld a,(bitmask)
 and (hl)
 jr z,PMSB_NPH
 inc d
PMSB_NPH:
 rlc e
 jr nc,PMSB_NextBit
 ld a,(bitmask)
 rlc c
 jr c,PMSB_BitOn
 cpl
 and (hl)
 ld (hl),a
 jr PMSB_NextBit
PMSB_BitOn:
 or (hl)
 ld (hl),a
PMSB_NextBit:
 ld a,(bitmask)
 rrca
 ld (bitmask),a
 jr nc,PMSB_SSB
 inc hl
PMSB_SSB:
 pop bc
 rlc c
 djnz PMSB_PutCol
 ld (ix),d
 inc ix
 pop hl
 ld de,16
 add hl,de
 pop bc
 djnz PMSB_PutRow
 pop iy
 ei
EndMSB:
 pop bc
 ret

; PutSprite:
;  Puts an 8x8 sprite at B,C. HL = pointer to sprite. No mask and no
;  background storage, just clipping.
PutSprite:
 push bc
 ld a,$FF
 ld (clipmask),a
 bit 7,b
 jr z,PSC_CheckRightClip
 ld a,b
 cp 249
 jr c,EndPPS
 neg
 push bc
 ld b,a
 ld a,$FF
PSC_LeftClip:
 srl a
 djnz PSC_LeftClip
 pop bc
 res 7,b
 dec c
 ld (clipmask),a
 jr PSC_CheckBotClip
PSC_CheckRightClip
 ld a,b
 sub 120
 jr c,PSC_CheckBotClip
 push bc
 ld b,a
 inc b
 ld a,$FF
PSC_RightClip:
 add a,a
 djnz PSC_RightClip
 ld (clipmask),a
 pop bc
PSC_CheckBotClip:
 ld a,8
 ld (rows2put),a
 bit 7,c
 jr nz,PSC_CheckTopClip
 bit 6,c
 jr nz,EndPS
 ld a,64
 sub c
 cp 8
 jr nc,PSC_ClippingDone
 ld (rows2put),a
 jr PSC_ClippingDone
PSC_CheckTopClip:
 ld a,c
 cp 249
EndPPS:
 jr c,EndPS
 push bc
 neg
 ld b,a
 sub 8
 neg
 ld (rows2put),a
PSC_TopClip:
 inc hl
 inc de
 djnz PSC_TopClip
 pop bc
 ld c,0
PSC_ClippingDone:
 push hl
 pop ix
 ld a,(rows2put)
 push af
 call FIND_PIXEL
Modify_6:
 ld de,$FC00
 add hl,de
 ld d,a
 pop bc
PSC_PutRow:
 push bc
 push hl
 ld a,(clipmask)
 ld e,a
 ld b,8
 ld c,(ix)
 inc ix
PSC_PutCol:
 push bc
 rlc e
 jr nc,PSC_NextBit
 ld a,d
 rlc c
 jr c,PSC_BitOn
 cpl
 and (hl)
 ld (hl),a
 jr PSC_NextBit
PSC_BitOn:
 or (hl)
 ld (hl),a
PSC_NextBit:
 rrc d
 jr nc,PSC_SSB
 inc hl
PSC_SSB:
 pop bc
 rlc c
 djnz PSC_PutCol
 pop hl
 ld bc,16
 add hl,bc
 pop bc
 djnz PSC_PutRow
EndPS:
 pop bc
 ret

; FindPixel routine used by sprite routines
;  Input: b=x, c=y
;  Output: hl = offset from $FC00, A = bitmask

; this routine is also used by the game, somewhat inefficiently due
; to the hl output, but still better than including 2 FindPixel routines

FIND_PIXEL:
 push bc
 push de
 ld hl,ExpTable
 ld d,0
 ld a,b
 and $07
 ld e,a
 add hl,de
 ld e,(hl)
 ld h,d
 srl b
 srl b
 srl b
 ld a,c
 add a,a
 add a,a
 ld l,a
 add hl,hl
 add hl,hl
 ld a,e
 ld e,b
 add hl,de
 pop de
 pop bc
 ret

ExpTable:
 .db $80,$40,$20,$10,$08,$04,$02,$01


#include "rle.asm"			; include RLE picture displayer
Pic:
#include "pin.asm"		; RLE picture made by RLE2PIC
BackGround
#include "Back.asm"


.end
