;##################################################################
;
;   P H O E N I X         F O R        T I - 8 2
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated October 28, 2000.
;
;##################################################################     

        .include    "crash82.inc"

#define __TI82__

GFX_AREA    =GRAPH_MEM

        .db     "Phoenix 0.90",0

;############## Include variable and data structure definitions
        
#include "source/phoenixz.h"

;############## Initialization

        ld      a,($8D0F)               ; Prevent running from MirageOS
        or      a
        ret     z

        ld      (OTH_EXIT+1),sp

        ld      a,(INT_STATE)
        or      a
        jp      nz,interrupt_installed

        ld      de,$8401                ; Save data after GRAPH_MEM
        ld      hl,GRAPH_MEM+768
        ld      bc,256
        ldir

        ld      hl,timer_interrupt
        ld      de,$8282
        ld      bc,timer_interrupt_end-timer_interrupt
        ldir

        ld      a,$83
        ld      i,a

        ld      hl,$8300
        ld      (hl),$82
        ld      bc,256
        call    OTH_FILL

        im      2

        ld      (iy+13),0

        ld      hl,level_table
        ld      (level_addr),hl

        call    &restore_game
  
;############## Title screen

redraw_title:
        ROM_CALL(CLEARLCD)
        ld      hl,title_main

show_title:
        call    display_hl_msgs
        
title_loop:
        call    GET_KEY
        cp      G_2
        jr      z,show_contact
        cp      G_3
        jr      z,show_instructions
        cp      G_1
        jp      z,start_new_game
        cp      G_CLEAR
        jr      z,game_exit
        cp      G_ALPHA
        jr      z,show_highs
        cp      G_DEL
        jr      nz,title_loop

game_exit:
        im      1
        call    restore_memory
OTH_EXIT:
        ld      sp,0
        ROM_CALL(CLEARLCD)
        ret

interrupt_installed:
        ROM_CALL(CLEARLCD)
        ld      (CURSOR_ROW),de
        ld      hl,int_err
        ROM_CALL(TX_CHARPUT)
        call    CR_KHAND
        jr      OTH_EXIT

show_highs:
        call    no_high_score
        jr      redraw_title

show_contact:
        ld      hl,title_contact
        jr      show_title

show_instructions:
        ld      hl,title_instructions
        jr      show_title

;############## Title screen messages

int_err:
        .db     "ERROR:  You must"
        .db     "remove installed"
        .db     "interrupts.",0

title_main:
        .db     "  Phoenix  0.90",0
        .db     0
        .db     "  Programmed by",0
        .db     "Patrick Davidson",0
        .db     0
        .db     " 1 - Start Game",0
        .db     "2 - Contact Info",0
        .db     "3 - Instructions",0
        .db     -1

title_instructions:
        .db     "Arrows Move Ship",0
        .db     "#s Select Weapon",0
        .db     "2nd Fires Weapon",0
        .db     "MODE Save & Exit",0
        .db     -1

title_contact:
        .db     "E-Mail:         ",0
        .db     "    pad@calc.org",0
        .db     "World Wide Web: ",0
        .db     "   pad.calc.org ",0
        .db     -1

;############## Initialize a new game

start_new_game:
        call    initialize_game

pre_main_loop:
        ld      hl,-6
        add     hl,sp
        ld      (collision_done+1),hl
        
;############## Game main loop
        
main_loop:
        ld      hl,(game_timer)
        inc     hl
        ld      (game_timer),hl

        bit     0,l
        jr      z,time_elapsed
        ld      hl,(time_score)
        ld      a,h
        or      l
        jr      z,time_elapsed
        dec     hl
        ld      (time_score),hl
time_elapsed:

        call    clear_buffer           ; Prepare main display buffer

        call    do_player              ; Move and draw player
        call    do_companion           ; Move and draw companion ship

        call    enemies                ; Move and draw enemies

        call    player_bullets         ; Move and draw player bullets

        call    enemy_bullets          ; Move and draw enemy bullets
        call    hit_player             ; Collisions involving player

        call    prepare_indicator       ; Prepare the shield indicator
        call    synchronize            ; Wait for next 1/30 second cycle
        call    display_screen         ; Copy display buffer to video memory

        call    hit_enemies            ; Collisions btw. bullets & enemies

        call    handle_input           ; Process control keys
        ld      a,(enemies_left)
        or      a
        call    z,load_level
        jr      main_loop

;############## TI-82 library

restore_memory:
        ld      hl,$8401                ; Restore data after GRAPH_MEM
        ld      de,GRAPH_MEM+768
        ld      bc,256
        ldir
        ret

OTH_CLEAR:
        ld      (hl),0
OTH_FILL:
        ld      d,h
        ld      e,l
        inc     de
        ldir
        ret

OTH_ARROW:
        ld      a,%00111111
        out     (1),a
        push    ix
        pop     ix
        in      a,(1)
        or      %00001111
        ld      b,a
        ld      a,%01111110
        out     (1),a
        push    ix
        pop     ix
        in      a,(1)
        and     b
        ret

;############## Include remainder of game files

#include "source/lib.asm"
#include "source82/new82.asm"
#include "source82/disp82.asm"
#include "source/drwspr.asm"
#include "source82/player82.asm"
#include "source/shoot.asm"
#include "source/bullets.asm"
#include "source/enemies.asm"
#include "source/init.asm"
#include "source/enemyhit.asm"
#include "source/collide.asm"
#include "source/ebullets.asm"
#include "source/hityou.asm"
#include "source82/shop82.asm"
#include "source/helper.asm"
#include "source/eshoot.asm"
#include "source82/score82.asm"
#include "source/images.asm"
#include "source/data.asm"
#include "source/levels.asm"

        .end
