;##################################################################
;
;   P H O E N I X         F O R        T I - 8 5   /  T I - 8 6
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated November 18, 2000.
;
;##################################################################     
        
#ifdef  __TI86__
#include "source/ti-86.h"
#else
#define __TI85__
        .include "usgard.h"
        .org    0
GFX_AREA        =GRAPH_MEM
#endif

title:  .db     "Phoenix 0.90 by Patrick D",0

;############## Include variable and data structure definitions
        
#include "source/phoenixz.h" 

;############## Initialize TIOS variables & allocate memory (TI-85 only)

main:   ld      (iy+13),0               ; No-scroll text mode

#ifdef  __TI85__
        ld      hl,(VAT_END)               ; Locate grayscale page
        ld      de,-1024                    
        add     hl,de
        ld      l,0
        ld      de,(FIRST_FREE)
        call    CP_HL_DE
        jr      nc,allocok
        call    CLEARLCD
        ld      (CURSOR_ROW),de
        ld      hl,&nomem
        call    D_ZT_STR
        jp      OTH_PAUSE
nomem:  .db     "YOU NEED AT LEAST    "
        .db     "1.25K OF FREE RAM!",0
allocok:
        ld      (&smc_alloc_start+1),hl
        ld      a,h
        ld      de,-512
        add     hl,de
        ld      (&smc_alloc_minus512+1),hl
        and     $3f
        ld      (&smc_alloc_page+1),a
#endif

;############## Initialize synchronization, screen sides, external levels
        
        call    &set_up_sides

        ld      hl,&timer_interrupt
        call    INT_INSTALL

#ifdef  __TI85__
        ld      hl,(PROGRAM_ADDR)
        ld      (data_addr),hl
#endif

        ld      hl,&level_table
        ld      (level_addr),hl
        xor     a
        ld      (ext_level),a

        call    &restore_game

        ld      hl,$fc00
        ld      (&smc_gfxmem_start+1),hl

        ld      a,4
        ld      (speed),a

#ifdef  __TI86__
        ld      hl,($AC1D)
        ld      de,31337
        call    CP_HL_DE
        jr      nz,noel
        ld      a,1
        ld      (ext_level),a
        dec     a
        ld      ($AC1D),a
        ld      (saved_flag),a
        ld      hl,$AC1D+2
        ld      (level_addr),hl
#else
        ld      hl,(DELC_LEN+1)
        ld      de,31337
        call    CP_HL_DE
        jr      nz,noel
        ld      a,1
        ld      (ext_level),a
        dec     a
        ld      (DELC_LEN+1),a
        ld      (saved_flag),a
        ld      hl,(DELC_LEN+3)
        ld      (level_addr),hl
        ld      hl,(DELC_LEN+5)
        ld      (data_addr),hl
#endif
noel:   
  
;############## Title screen

redraw_title:
        call    CLEARLCD
        ld      hl,&title_main

show_title:
        push    hl
        call    &clear_buffer
        ld      hl,$fe00
        ld      bc,$1ff
        call    OTH_CLEAR
        pop     hl

        call    &display_hl_msgs
        
title_loop:
        call    &scroll_sides
        call    &display_sides
        
        call    &synchronize
        call    GET_KEY
        cp      K_F2
        jr      z,show_contact
        cp      K_F3
        jr      z,show_instructions
        cp      K_F1
        jp      z,&start_new_game
        cp      K_ALPHA
        jr      z,show_highs
        cp      K_EXIT
        jr      nz,title_loop

game_exit:
        call    INT_REMOVE
        ld      a,$3c
        out     (0),a
        jp      OTH_EXIT

show_highs:
        call    &no_high_score
        jr      redraw_title

show_contact:
        ld      hl,&title_contact
        jr      show_title

show_instructions:
        ld      hl,&title_instructions
        jr      show_title

;############## Title screen messages

title_main:
        .db     "  Phoenix  0.90",0
        .db     0
        .db     "  Programmed by",0
        .db     "Patrick  Davidson",0
        .db     0
        .db     " F1 - Start Game",0
        .db     "F2 - Contact Info",0
        .db     "F3 - Instructions",0
        .db     -1

title_instructions:
        .db     "Arrows: Move Ship",0
        .db     "Fn: Select Weapon",0
        .db     "2nd: Shoot Weapon",0
        .db     "MORE: Save + Exit",0
        .db     -1

title_contact:
        .db     "E-Mail:",0
        .db     "     pad@calc.org",0
        .db     "World Wide Web:",0
        .db     "    pad.calc.org",0
        .db     -1

;############## Initialize a new game

start_new_game:
        call    &initialize_game

pre_main_loop:
        ld      hl,-6
        add     hl,sp
        ld      (&collision_done+1),hl
        
;############## Game main loop
        
main_loop:
        ld      hl,(game_timer)
        inc     hl
        ld      (game_timer),hl

        bit     0,l
        jr      z,time_elapsed
        ld      hl,(time_score)
        ld      a,h
        or      l
        jr      z,time_elapsed
        dec     hl
        ld      (time_score),hl
time_elapsed:

        call    &scroll_sides           ; Scroll sides (inside side buffer)
        call    &clear_buffer           ; Prepare main display buffer

        call    &do_player              ; Move and draw player
        call    &do_companion           ; Move and draw companion ship

        call    &enemies                ; Move and draw enemies

        call    &player_bullets         ; Move and draw player bullets

        call    &enemy_bullets          ; Move and draw enemy bullets
        call    &hit_player             ; Collisions involving player

        call    &prepare_indicator      ; Prepare shield indicator
        call    &synchronize            ; Wait for next 1/30 second cycle
        call    &display_screen         ; Copy display buffer to video memory

        call    &handle_input           ; Process control keys

        call    &hit_enemies            ; Collisions btw. bullets & enemies

        ld      a,(enemies_left)
        or      a
        call    z,&load_level
        jr      main_loop

;############## Include remainder of game files
        
#include "source/lib.asm"
#include "source/newgame.asm"
#include "source/display.asm"
#include "source/drwspr.asm"
#include "source/player.asm"
#include "source/shoot.asm"
#include "source/bullets.asm"
#include "source/enemies.asm"
#include "source/init.asm"
#include "source/enemyhit.asm"
#include "source/collide.asm"
#include "source/ebullets.asm"
#include "source/hityou.asm"
#include "source/shop.asm"
#include "source/helper.asm"
#include "source/eshoot.asm"
#include "source/score.asm"
#include "source/data.asm" 
#include "source/images.asm"
#include "source/levels.asm"

        .end
