;##################################################################
;
;   Phoenix-Z80 (Header and low-level library for TI-86)
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated November 18, 2000.
;
;##################################################################

;############## Definitions of system calls

#define ROM_CALL(addr) call addr

LD_HL_MHL       =$4010              ; _ldHLind
UNPACK_HL       =$4044              ; _divHLby10
TX_CHARPUT      =$4A2B              ; _putc
D_ZT_STR        =$4A37              ; _puts
CLEARLCD        =$4A7E              ; _clrLCD
BUSY_OFF        =$4AB1              ; _runindicoff

;############## Definitions of memory areas

GFX_AREA        =$9000
BACKUP          =$9400
EXT_LEVEL       =$AC1D
VIDEO_2         =$CA00

CONTRAST        =$C008              
CURSOR_ROW      =$C00F              ; _curRow
CURSOR_COL      =$C010              ; _curCol
TEXT_MEM        =$C0F9              ; _textShadow

_asm_exec_ram   =$D748

;############## Definitions of GET_KEY values

K_MORE          =$38
K_EXIT          =$37
K_F1            =$35
K_F2            =$34
K_F3            =$33
K_F4            =$32
K_F5            =$31
K_ALPHA         =$30
K_DEL           =$20
K_3             =$12
K_ENTER         =$09
K_UP            =$04
K_DOWN          =$01

;############## TI-86 program header (for YAS, etc.)

        .org    _asm_exec_ram
        nop
        jp      startup
        .dw     0
        .dw     title

;############## Interrupt handler

interrupt_code:
        push    af
        push    hl
        call    $0                      ; Actual address written over this
        pop     hl

        in      a,(3)                   ; Bit 1 = ON key status
        and     1
        add     a,9                     ; A = 10 if ON pressed, 9 if not
        out     (3),a                  
        ld      a,11
        out     (3),a                   
        ei
        pop     af
        reti
interrupt_code_end:

;############## Initialization

startup:
        ld      hl,VIDEO_2
        ld      de,BACKUP
        ld      bc,256
        ldir
        call    $49DC                   ; _flushAllMenus
        call    BUSY_OFF
        ld      (OTH_EXIT+1),sp
        jp      main

;############## Simulation of Usgard functions

OTH_CLEAR:
        ld      (hl),0
OTH_FILL:
        ld      d,h
        ld      e,l
        inc     de
        ldir
        ret

OTH_ARROW:
        ld      a,%00111111
        out     (1),a
        push    ix
        pop     ix
        in      a,(1)
        or      %00001111
        ld      b,a
        ld      a,%01111110
        out     (1),a
        push    ix
        pop     ix
        in      a,(1)
        and     b
        ret

INT_INSTALL:
        ld      (interrupt_code+3),hl
        ld      hl,$A000
        ld      (hl),$A1
        ld      bc,256
        call    OTH_FILL
        ld      hl,interrupt_code
        ld      de,$a1a1
        ld      bc,interrupt_code_end-interrupt_code
        ldir
        ld      a,$a0
        ld      i,a
        im      2
        ret

INT_REMOVE:
        im      1
        ret           

OTH_EXIT:
        ld      sp,0

        ld      hl,variable_name
        call    $46CB                   ; _FINDSYM; BDE -> start of program
        ld      hl,permanent_data_start+4-_asm_exec_ram
        ld      a,b
        add     hl,de
        adc     a,0                     ; AHL -> perm storage in variable
        call    $5285                   ; _SET_ABS_DEST_ADDR
        ld      a,0
        ld      hl,permanent_data_start
        call    $4647                   ; _SET_ABS_SRC_ADDR
        ld      a,0
        ld      hl,permanent_data_end-permanent_data_start
        call    $464f                   ; _SET_MM_NUM_BYTES
        call    $52ed                   ; _mm_ldir

        ld      hl,TEXT_MEM
        ld      (hl),' '
        ld      bc,167
        call    OTH_FILL
        call    CLEARLCD
        ld      hl,0
        ld      (CURSOR_ROW),hl
        ld      (iy+13),6
        res     0,(iy+3)

restore_backup:
        ld      hl,BACKUP
        ld      de,VIDEO_2
        ld      bc,256
        ldir
        ret

variable_name:
        .db     "phoenix",0

;############## GET_KEY replacement

GET_KEY:
        push    hl
        push    de
        push    bc
        ld      e,0                     ; E = GET_KEY result
        ld      hl,getkeylastdata       ; HL = ptr to last read's table
        ld      a,$fe                   ; A = key port mask
        ld      d,1                     ; D = individual key's mask
        ld      c,0                     ; C = key number counter
gkol:   out     (1),a
        ld      b,8                         
        push    af
gkl:    inc     c
        in      a,(1)
        and     d
        jr      nz,nokey
        ld      a,(hl)
        and     d
        jr      z,nokey
        ld      e,c
nokey:  rlc     d
        djnz    gkl
        in      a,(1)
        ld      (hl),a
        pop     af
        inc     hl
        rlca     
        cp      $7F
        jr      nz,gkol
        ld      a,e
        pop     bc
        pop     de
        pop     hl
        ret

getkeylastdata:
        .db     $ff,$ff,$ff,$ff,$ff,$ff,$ff

;############## CP_HL_DE replacement

CP_HL_DE:
        push    hl
        and     a
        sbc     hl,de
        pop     hl
        ret

;############## D_HL_DECI replacement

D_HL_DECI:
        push    bc
        ld      de,up_data+4
        ld      b,5
ldhld:  call    UNPACK_HL
        add     a,48
        ld      (de),a
        dec     de
        djnz    ldhld
        ld      hl,up_data
        ld      b,4
lis:    ld      a,(hl)
        cp      48
        jr      nz,dis
        ld      (hl),32
        inc     hl
        djnz    lis
dis:    ld      hl,up_data
        call    D_ZT_STR
        pop     bc
        ret

up_data:
        .db     "PAD98",0               ; Because this was coded in 1998!

