;##################################################################
;
;   Phoenix-Z80 (Enemy bullets)
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated October 28, 2000.
;
;##################################################################     

;############## Enemy bullet routine
;
; Calls the code specified by the bullet 'type'.  The 'type', which must
; be a multiple of 3, is an index into the table of jumps for bullet code.
; Bullet routines should move the bullet and draw its image.  They are
; called with HL pointing to the bullet entry, and can change all registers.

enemy_bullets:
        xor     a
        ld      (doing_enemies),a

        ld      hl,&img_eb_3
        ld      (beb_image),hl

        ld      a,(which_shot)
        rlca
        call    c,&enemy_bullets_2

        ld      hl,&eb_array
        ld      b,eb_num
loop_enemy_bullets:
        ld      a,(hl)
        ld      (&do_enemy_bullet+1),a
        push    hl
        push    bc
        call    &do_enemy_bullet
        pop     bc
        pop     hl
        ld      de,eb_size
        add     hl,de
        djnz    loop_enemy_bullets
        ret

enemy_bullets_2:
        ld      hl,&img_eb_4
        ld      (beb_image),hl

        ld      hl,&eb_array
        ld      b,eb_num
loop_enemy_bullets_2:
        ld      a,(hl)
        cp      23
        jr      c,none
        ld      (&do_enemy_bullet+1),a
        push    hl
        push    bc
        call    &do_enemy_bullet
        pop     bc
        pop     hl
none:   ld      de,eb_size
        add     hl,de
        djnz    loop_enemy_bullets_2
        ret

        jp      &exploding_enemy        ;This is offset -5
do_enemy_bullet:
        jr      point_to_ebullet_code
point_to_ebullet_code:

;############## Enemy bullet routine table starts here

no_ebullet:
        ld      (hl),0
        ret

        jp      &std_ebullet            ;3
        jp      &bonus_ebullet          ;6
        jp      &left_ebullet           ;9
        jp      &right_ebullet          ;12
        jp      &half_left_ebullet      ;15
        jp      &half_right_ebullet     ;18
        jp      &arrow_bullet           ;21
        jp      &big_ebullet_left3      ;24
        jp      &big_ebullet_left2      ;27
        jp      &big_ebullet_left1      ;30
        jp      &big_ebullet_down       ;33
        jp      &big_ebullet_right1     ;36
        jp      &big_ebullet_right2     ;39
        jp      &big_ebullet_right3     ;42
                                        ;45

;############## Big bullets

big_ebullet_left1:
        ld      a,(game_timer)
        rra
        jr      c,big_ebullet_left2
        jr      big_ebullet_down

big_ebullet_right1:
        ld      a,(game_timer)
        rra
        jr      c,big_ebullet_right2

big_ebullet_down:
        inc     hl
        inc     hl
common_bigbullet:
        ld      d,(hl)
        inc     hl
        inc     hl
        inc     (hl)
        ld      e,(hl)
        ld      a,96
        sub     e
        jr      z,destroy_ebullet
        ld      hl,(beb_image)
        jp      &drw_spr

big_ebullet_left3:
        call    &poss_up
big_ebullet_left2:
        inc     hl
        inc     hl
        dec     (hl)
decide_bbullet:
        jr      z,destroy_ebullet_x
        jr      common_bigbullet

big_ebullet_right3:
        call    &poss_up
big_ebullet_right2:
        inc     hl
        inc     hl
        inc     (hl)
        ld      a,126
        cp      (hl)
        jr      decide_bbullet

poss_up:
        ld      a,(game_timer)
        rra
        ret     c
        push    hl
        ld      de,eb_y
        add     hl,de
        dec     (hl)
        pop     hl
        ret

;############## Arrow enemy bullet

arrow_bullet:
        inc     hl
        inc     hl
        ld      d,(hl)
        inc     hl
        inc     hl
        inc     (hl)
        ld      e,(hl)
        ld      a,96
        sub     e
        jr      z,destroy_ebullet
        ld      hl,&img_eb_2
        jp      &drw_spr

;############## Bullet moving half right

half_right_ebullet:
        ld      a,(game_timer)
        rra
        jr      c,right_ebullet
        jr      std_ebullet

;############## Bullet moving half left

half_left_ebullet:
        ld      a,(game_timer)
        rra
        jr      c,left_ebullet
        jr      std_ebullet

;############## Bullet moving right

right_ebullet:
        inc     hl
        inc     hl
        inc     (hl)
        ld      a,126
        cp      (hl)
        jr      decide_ebullet

;############## Bullet moving left

left_ebullet:
        inc     hl
        inc     hl
        dec     (hl)
decide_ebullet:
        jr      z,destroy_ebullet_x
        jr      common_ebullet

;############## Standard enemy bullet

std_ebullet:
        inc     hl
        inc     hl
common_ebullet:
        ld      d,(hl)
        inc     hl
        inc     hl
        inc     (hl)
        ld      e,(hl)
        ld      a,96
        sub     e
        jr      z,destroy_ebullet
        ld      hl,&img_eb_1
        jp      &drw_spr

destroy_ebullet:
        ld      de,-4
        add     hl,de
        ld      (hl),a
        ret

destroy_ebullet_x:
        dec     hl
        dec     hl
        ld      (hl),0
        ret

;############## Falling bonus

bonus_ebullet:
        inc     hl
        inc     hl
        ld      d,(hl)
        inc     hl
        inc     hl
        ld      a,(game_timer)
        rra
        jr      c,no_fall_bonus
        inc     (hl)
no_fall_bonus:
        ld      e,(hl)
        ld      a,96
        sub     e
        jr      z,destroy_ebullet
        ld      hl,&img_money
        jp      &drw_spr

