;##################################################################
;
;   Phoenix-Z80 (Variable and data structure defintions)
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated September 4, 2000.
;
;##################################################################   

;############## Player bullet structure definition

pb_type         =0
pb_dmg          =1
pb_x            =2
pb_w            =3
pb_y            =4
pb_h            =5
pb_img          =6
pb_data         =8

pb_size         =10

pb_num          =16

;############## Enemy structure definition

e_type          =0          ; Type (offset in jump table)
e_phase         =1          ; Phase of movement (enemy-specific use)
e_timer         =2          ; Timer (enemy-specific use)
e_x             =3          ; X coordinate
e_w             =4          ; Width 
e_y             =5          ; Y coordinate
e_h             =6          ; Height
e_pwr           =7          ; Shield strength
e_img           =8          ; Image pointer (not required)
e_data          =10         ; Misc. data (enemy-specific use)

e_size          =12

e_num           =18

;############## Enemy bullet structure definition

eb_type         =0
eb_dmg          =1
eb_x            =2
eb_w            =3
eb_y            =4
eb_h            =5
eb_data         =6

eb_size         =10

eb_num          =15

;############## Screen side data

sidesdata       =$FA70
leftsidecoord   =$FB70
leftsidevel     =$FB71
rightsidecoord  =$FB72
rightsidevel    =$FB73

;############## Permanent variables

perm_var_start  =TEXT_MEM

posqueue        =TEXT_MEM
player_y        =TEXT_MEM+20
player_x        =TEXT_MEM+21
enemies_left    =TEXT_MEM+22
level           =TEXT_MEM+23
player_pwr      =TEXT_MEM+24
player_cash     =TEXT_MEM+25
weapon_upgrade  =TEXT_MEM+27
weapon_2        =TEXT_MEM+28
weapon_3        =TEXT_MEM+29
weapon_4        =TEXT_MEM+30
weapon_5        =TEXT_MEM+31
fire_counter    =TEXT_MEM+32
chosen_weapon   =TEXT_MEM+33
game_timer      =TEXT_MEM+34
pattern         =TEXT_MEM+36
companion_pwr   =TEXT_MEM+38
companion_y     =TEXT_MEM+39
companion_x     =TEXT_MEM+40
companion_img   =TEXT_MEM+41
difficulty      =TEXT_MEM+43
which_shot      =TEXT_MEM+44

perm_var_size   =45

;############## Temporary variables

temp            =TEXT_MEM+160
shop_item       =TEXT_MEM+161
test_coords     =TEXT_MEM+162
timer           =TEXT_MEM+166
jp2nd           =TEXT_MEM+167
