;##################################################################
;
;   Phoenix-Z80 (Player firing)
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated September 3, 2000.
;
;##################################################################

;############## Bullet descriptions   

bullet_data_normal:
        .db     6,2,2,6

bullet_data_enhanced:
        .db     3,4,4,8

bullet_double_left:
        .db     9,2,3,7

bullet_double_right:
        .db     12,2,3,7

bullet_triple_left:
        .db     15,3,4,4

bullet_triple_right:
        .db     18,3,4,4

bullet_triple_center:
        .db     21,4,4,4

bullet_quad_left:
        .db     24,8,3,5

bullet_quad_right:
        .db     27,8,3,5

;############## Main shooting routine

player_shoot:
        ld      a,(chosen_weapon)
        or      a
        jr      z,player_shoot_1
        dec     a
        jr      z,player_shoot_2
        dec     a
        jr      z,player_shoot_3

player_shoot_4:
        ld      a,(weapon_4)
        xor     128
        ld      (weapon_4),a
        ld      a,0
        jp      m,&ps4l
        ld      a,7
ps4l:
        ld      (&whichside+1),a
        add     a,2
        ld      c,a

        call    &find_bullet
        ex      de,hl
        ld      hl,&bullet_quad_right
        call    &bullet_copy

        call    &find_bullet
        ex      de,hl
        ld      hl,&bullet_quad_left
whichside:
        ld      c,0
        jr      bullet_copy

player_shoot_3:
        call    &find_bullet
        ex      de,hl
        ld      hl,&bullet_triple_center
        ld      c,4
        call    &bullet_copy

        call    &find_bullet
        ex      de,hl
        ld      hl,&bullet_triple_left
        ld      c,2
        call    &bullet_copy

        call    &find_bullet
        ex      de,hl
        ld      hl,&bullet_triple_right
        ld      c,6
        jr      bullet_copy

player_shoot_2:
        call    &find_bullet
        ex      de,hl
        ld      hl,&bullet_double_left
        ld      c,1
        call    &bullet_copy

        call    &find_bullet
        ex      de,hl
        ld      hl,&bullet_double_right
        ld      c,8
        jr      bullet_copy

player_shoot_1:
        call    &find_bullet
        ex      de,hl
        ld      a,(weapon_upgrade)
        or      a
        jr      nz,shoot_enhanced
        ld      hl,&bullet_data_normal
        ld      c,5
        jr      bullet_copy

shoot_enhanced:
        ld      c,4     
        ld      hl,&bullet_data_enhanced

;############## Copy bullet data, HL->description, DE->data, C-2 = X offset

bullet_copy:
        ldi                             ; Type
        ldi                             ; Amount of damage
        ld      a,(player_x)
        add     a,c
        ld      (de),a                  ; X-coordinate
        inc     de
        ldi                             ; Width
        ld      a,(player_y)
        add     a,-3
        ld      (de),a                  ; Y-coordinate
        inc     de
        ldi                             ; Height
        ret

;############## Find an unused bullet

find_bullet:
        ld      hl,&pb_array            ; Locate unused bullet in HL
        ld      b,pb_num
        ld      de,pb_size
loop_search_bullet:
        ld      a,(hl)
        or      a
        ret     z
        add     hl,de
        djnz    loop_search_bullet
        pop     hl
        ret
