;##################################################################
;
;   Phoenix-Z80 (Level initialization)
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated September 5, 2000.
;
;##################################################################     

;############## Load the next level

restart:
        ld      hl,level
        ld      (hl),0

load_level:
        ld      hl,level
        ld      a,(hl)
        inc     (hl)
        ld      hl,&level_table
        add     a,a
        call    &ADD_HL_A
        call    LD_HL_MHL
#ifndef __TI86__
        ld      de,(PROGRAM_ADDR)
        add     hl,de
#endif
        jp      (hl)

level_table:
        .dw     lev1
        .dw     lev2
        .dw     lev3
        .dw     shop
        .dw     lev4
        .dw     lev5
        .dw     bounce6
        .dw     lev6
        .dw     shop
        .dw     lev4a
        .dw     lev5a
        .dw     bounce8
        .dw     lev6a
        .dw     shop
        .dw     lev7
SPLIT_LEVEL     =15
        .dw     lev8
        .dw     bounce10
        .dw     lev9
        .dw     shop
        .dw     lev10
        .dw     lev11
        .dw     lev12
        .dw     restart

;############## Initialize levels with bouncing enemies

bounce10:
        ld      a,10
        jr      bounce_install
bounce8:
        ld      a,8
        jr      bounce_install
bounce6:
        ld      a,6
bounce_install:
        ld      (enemies_left),a
        ld      b,a
        ld      hl,&e_array
        ld      a,14
        ld      de,e_size-7
loop_put_bouncing:
        ld      (hl),15                 ; e_type
        inc     hl
        ld      (hl),3                  ; XV
        inc     hl
        ld      (hl),3                  ; YV
        inc     hl
        ld      (hl),a
        inc     hl
        add     a,10
        ld      (hl),8
        inc     hl
        ld      (hl),20
        inc     hl
        ld      (hl),9
        inc     hl
        ld      (hl),36
        add     hl,de
        djnz    loop_put_bouncing
        ret

;############## Initialize levels with circle/bar enemies

lev9:
        ld      de,&oval_pattern
        ld      a,13
        call    &install_delayed
        ex      de,hl
        ld      bc,e_size
        ld      hl,&boss_data
        ldir
        ld      hl,enemies_left
        inc     (hl)
        ret

lev7:
        ld      de,&circle_pattern
        ld      a,14
        jr      install_delayed

lev8:
        ld      de,&figure_eight_pattern
        ld      a,13
install_delayed:
        ld      (pattern),de
        ld      hl,&e_array
        ld      b,a
        ld      (enemies_left),a
        ld      de,e_size-5
loop_install_delayed:
        ld      (hl),9                  ; e_type
        inc     hl
        ld      (hl),a                  ; e_phase
        inc     hl
        inc     hl
        ld      (hl),0                  ; e_x
        inc     hl
        inc     hl
        ld      (hl),0                  ; e_y
        add     a,15
        add     hl,de
        djnz    loop_install_delayed
        ret

;############## Installation of normal enemies

lev3:
        ld      de,&img_enemy_1
lev3main:
        ld      hl,&e_array
        ld      a,7
        ld      (enemies_left),a

        ld      b,6
        ld      a,14
        ld      c,20
        call    &set_up_enemies

        ex      de,hl
        ld      bc,e_size
        ld      hl,&boss_data
        ldir
        ret

boss_data:
        .db     12                      ; e_type
        .db     0                       ; e_phase
        .db     32                      ; e_timer
        .db     90                      ; e_x
        .db     16                      ; e_w
        .db     1                       ; e_y
        .db     10                      ; e_h
        .db     60                      ; e_pwr

boss_data2:
        .db     18                      ; e_type
        .db     0                       ; e_phase
        .db     32                      ; e_timer
        .db     90                      ; e_x
        .db     16                      ; e_w
        .db     1                       ; e_y
        .db     10                      ; e_h
        .db     80                      ; e_pwr

lev2:
        ld      de,&img_enemy_1
lev2main:
        ld      hl,&e_array
        ld      a,18
        ld      (enemies_left),a

        ld      b,6
        ld      a,14
        ld      c,0
        call    &set_up_enemies

        ld      b,6
        ld      a,14
        ld      c,20
        call    &set_up_enemies

        ld      b,6
        ld      a,17
        ld      c,10
        jr      set_up_enemies

lev4a:
        ld      de,&img_enemy_2a
        jr      lev1main

lev5a:
        ld      de,&img_enemy_2a
        jr      lev2main

lev6a:
        ld      de,&img_enemy_2a
        jr      lev3main

lev4:
        ld      de,&img_enemy_2
        jr      lev1main

lev5:
        ld      de,&img_enemy_2
        jr      lev2main

lev6:
        ld      de,&img_enemy_2
        jr      lev3main

lev11:
        ld      de,&img_enemy_4
        jr      lev2main

lev12:
        ld      de,&img_enemy_4
lev12main:
        ld      hl,&e_array
        ld      a,7
        ld      (enemies_left),a

        ld      b,6
        ld      a,14
        ld      c,20
        call    &set_up_enemies

        ex      de,hl
        ld      bc,e_size
        ld      hl,&boss_data2
        ldir
        ret

lev10:  ld      a,1
        ld      (which_shot),a
        ld      de,&img_enemy_4
        jr      lev1main

lev1:   xor     a
        ld      (which_shot),a
        ld      de,&img_enemy_1
lev1main:
        ld      hl,&e_array
        ld      a,18
        ld      (enemies_left),a

        ld      b,6
        ld      a,14
        ld      c,0
        call    &set_up_enemies

        ld      b,6
        ld      a,14
        ld      c,10
        call    &set_up_enemies

        ld      b,6
        ld      a,14
        ld      c,20

;############## Install enemy data for one row of enemies
;
; HL -> position in e_array to start installing
; B = number of enemies in row
; C = Y coordinate of row (from top of screen)
; DE = enemy image
;
; Returns with HL -> first unused enemy, B = 0

set_up_enemies:
        ld      (hl),3          ; Enemy type
        inc     hl
        ld      (hl),0          ; Phase
        inc     hl
        ld      (hl),-60        ; Timer
        inc     hl
        ld      (hl),a          ; X-coordinate
        add     a,15
        inc     hl

        push    af

        ld      a,(de)
        ld      (hl),a          ; Width
        inc     hl
        ld      (hl),c          ; Y-coordinate
        inc     hl
        inc     de
        ld      a,(de)
        ld      (hl),a          ; Height
        dec     de
        inc     hl

        dec     de
        ld      a,(de)
        ld      (hl),a          ; Power
        inc     de

        pop     af

        inc     hl
        ld      (hl),e          ; Image, low byte
        inc     hl
        ld      (hl),d          ; Image, high byte
        inc     hl
        inc     hl
        inc     hl
        djnz    set_up_enemies

        ret
