;##################################################################
;
;   Phoenix-Z80 (Enemies)
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated September 4, 2000.
;
;##################################################################     

;############## Enemy routines
;
; Calls the code specified by the enemy 'type'.  The 'type', which must
; be a multiple of 3, is an index into the table of jumps for enemy code.
; Enemy routines should move the enemy and draw its image.  They are
; called with HL pointing to the enemy entry, and can change all registers.

enemies:
        ld      hl,&e_array
        ld      b,e_num
loop_enemies:
        ld      a,(hl)
        ld      (&do_enemy+1),a
        push    hl
        push    bc
        call    &do_enemy
        pop     bc
        pop     hl
        ld      de,e_size
        add     hl,de
        djnz    loop_enemies
        ret

        jp      &exploding_enemy        ; This is offset -5

do_enemy:
        jr      point_to_enemy_code
point_to_enemy_code:

;############## Enemy routine table starts here

no_enemy:
        ld      (hl),0
        ret
        jp      &standard_enemy         ;3
        jp      &figure_eight           ;6
        jp      &figure_eight_waiting   ;9
        jp      &standard_boss          ;12
        jp      &bounce_enemy           ;15
        jp      &advanced_boss          ;18

;############## Advanced boss

aboss_shoot:
        ld      a,11
        add     a,(hl)
        ld      (hl),a
        push    hl
        call    &fire_big_bullet
        pop     hl
        ld      a,-11
        add     a,(hl)
        ld      (hl),a
        push    hl
        call    &fire_big_bullet
        pop     hl
        jr      aboss_shot

advanced_boss:
        call    &boss_move
        ld      a,(game_timer)
        and     %111111
        jr      z,aboss_shoot
aboss_shot:
        ld      d,(hl)
        inc     hl
        inc     hl
        ld      e,(hl)
        push    de
        ld      hl,&img_boss2_left
        call    &drw_spr
        pop     de
        ld      a,8
        add     a,d
        ld      d,a
        ld      hl,&img_boss2_right
        jp      &drw_spr

;############## Boss

boss_shoot:
        ld      a,14
        add     a,(hl)
        ld      (hl),a
        push    hl
        call    &fire_aimed_bullet
        pop     hl
        ld      a,-14
        add     a,(hl)
        ld      (hl),a
        push    hl
        call    &fire_aimed_bullet
        pop     hl
        jr      boss_shot

standard_boss:
        call    &boss_move
        ld      a,(game_timer)
        and     %111111
        jr      z,boss_shoot
boss_shot:
        ld      d,(hl)
        inc     hl
        inc     hl
        ld      e,(hl)
        push    de
        ld      hl,&img_boss_left
        call    &drw_spr
        pop     de
        ld      a,8
        add     a,d
        ld      d,a
        ld      hl,&img_boss_right
        jp      &drw_spr

boss_move:
        inc     hl
        ld      a,(hl)
        or      a
        jr      z,boss_descending

        inc     hl
        dec     (hl)
        jr      nz,boss_no_reverse
        neg
        dec     hl
        ld      (hl),a
        inc     hl
        ld      (hl),90
boss_no_reverse:
        inc     hl
        add     a,(hl)
        ld      (hl),a
        ret

boss_descending:
        inc     hl
        dec     (hl)
        jr      nz,not_entered
        dec     hl
        ld      (hl),-1
        inc     hl
        ld      (hl),83
not_entered:
        inc     hl
        inc     hl
        inc     hl
        inc     (hl)
        dec     hl
        dec     hl
        ret

;############## Figure-eight waiting code

figure_eight_waiting:
        inc     hl
        dec     (hl)
        ret     nz
        dec     hl
        ld      (hl),6
        inc     hl
        ld      (hl),32
        inc     hl
        ld      (hl),0
        inc     hl
        ld      a,(level)
        cp      SPLIT_LEVEL
        jr      nz,nosplit
        bit     0,b
        jr      nz,nosplit
        ld      (hl),72
        jr      f8split
nosplit:
        ld      (hl),16
f8split:
        inc     hl
        ld      (hl),8
        inc     hl
        ld      (hl),24
        inc     hl
        ld      (hl),8
        inc     hl
        ld      (hl),13
        inc     hl
        ld      bc,3
        jp      OTH_CLEAR

;############## Figure-eight enemy code

figure_eight:
        inc     hl
        ld      a,(hl)                  ; hl -> e_phase (holds timer info)
        or      a
        jr      z,next_phase
        dec     (hl)
        inc     hl                      ; hl -> e_timer (holds phase info)
        jr      figure_phase

next_phase:
        inc     hl
        inc     (hl)
        ld      a,(hl)
restart_phase:
        ld      b,a
        add     a,a
        add     a,b
        ex      de,hl                   ; de -> e_timer
        ld      hl,(pattern)
        dec     a
        call    &ADD_HL_A
        ld      a,(hl)
        or      a
        jr      z,restart_pattern
        dec     de                      ; de -> e_phase
        ld      (de),a
        inc     de                      ; de -> e_timer
        inc     hl                      ; hl -> phase direction data
        jr      phase_located

restart_pattern:
        ex      de,hl
        inc     a
        ld      (hl),a
        jr      restart_phase

figure_phase:
        ld      a,(hl)
        ld      b,a
        add     a,a
        add     a,b
        ex      de,hl                   ; de -> e_timer
        ld      hl,(pattern)
        call    &ADD_HL_A               ; hl -> phase direction data

phase_located:
        ex      de,hl                   ; de -> direction data, hl -> e_timer
        ld      bc,8
        add     hl,bc                   ; hl -> e_data
        ld      a,(de)
        add     a,(hl)
        ld      b,a
        and     15
        ld      (hl),a
        ld      a,b
        sra     a
        sra     a
        sra     a
        sra     a
        ld      bc,-7
        add     hl,bc                   ; hl -> e_x
        add     a,(hl)
        ld      (hl),a

        inc     de
        ld      bc,8
        add     hl,bc                   ; hl -> e_data
        ld      a,(de)
        add     a,(hl)
        ld      b,a
        and     15
        ld      (hl),a
        ld      a,b
        sra     a
        sra     a
        sra     a
        sra     a
        ld      bc,-6
        add     hl,bc                   ; hl -> e_y
        add     a,(hl)
        ld      (hl),a

        ld      e,a
        push    hl
        dec     hl
        dec     hl
        ld      d,(hl)
        ld      hl,&img_enemy_3
semi_aim_shoot:
        call    &drw_spr
        pop     hl

        call    &FAST_RANDOM
        and     %01111110
        ret     nz

        ld      a,(player_y)
        sub     (hl)
        ret     c
        srl     a
        srl     a
        ld      b,a                     ; B = (PY - EY)
        srl     a
        add     a,b
        ret     z
        ld      b,a                     ; B = (3/8) * (PY - EY)
        dec     hl
        dec     hl
        ld      a,(player_x)
        sub     (hl)                    ; A = PX - EX
        inc     hl
        inc     hl
        jr      c,figurefireleft
        cp      b
        jp      c,&fire_enemy_bullet_std
        jp      &fire_bullet_half_right

figurefireleft:
        neg
        cp      b
        jp      c,&fire_enemy_bullet_std
        jp      &fire_bullet_half_left

;     KKK            EEE
;    L   JJ        DD   F
;   L      JJ    DD      F
;| A         JJDD         G |
;| A         DDJJ         G |
;v A       DD    JJ       G v
;   B    DD        JJ    H
;    BCCC            IIIH

figure_eight_pattern:
        .db     0,12
        .db     12,12,12        ;B
        .db     16,16,0         ;C
        .db     34,16,-12       ;D
        .db     16,15,0         ;E
        .db     12,12,12        ;F
        .db     8,0,12          ;G
        .db     12,-12,12       ;H
        .db     16,-15,0        ;I
        .db     34,-16,-12      ;J
        .db     16,-16,0        ;K
        .db     12,-12,12       ;L
        .db     8,0,12          ;A
        .db     0

circle_pattern:
        .db     0,14
        .db     8,12,12
        .db     16,16,0
        .db     8,12,-12
        .db     16,0,-16
        .db     8,-12,-12
        .db     16,-16,0
        .db     8,-12,12
        .db     16,0,16
        .db     0

oval_pattern:
        .db     0,16
        .db     4,12,12
        .db     76,16,0
        .db     4,12,-12
        .db     6,0,-16
        .db     4,-12,-12
        .db     76,-16,0
        .db     4,-12,12
        .db     6,0,16
        .db     0

;############## Standard enemy code

standard_enemy:
        inc     hl                      ; HL -> e_phase
        ld      a,(hl)
        ld      (&which_phase+1),a
        inc     hl                      ; HL -> e_timer
        inc     (hl)
        ld      a,(hl)
        rrca
        jr      nc,no_move_enemy
        cp      $88
        jr      nz,not_phase_end

        ld      (hl),0
        dec     hl                      ; HL -> e_phase
        ld      a,(hl)
        inc     a
        inc     a
        inc     a
        inc     a
        and     12
        ld      (hl),a
        inc     hl                      ; HL -> e_timer
not_phase_end:
        inc     hl                      ; HL -> e_x
        push    hl
        call    &which_phase

enemy_display:
        ld      e,(hl)                  ; E = e_y
        inc     hl
        inc     hl
        inc     hl                      ; E -> e_img
        call    LD_HL_MHL               ; HL = e_img
        pop     bc
        ld      a,(bc)
        ld      d,a
        jp      &drw_spr

no_move_enemy:
        inc     hl                      ; HL -> e_x
        push    hl
        inc     hl
        inc     hl
        call    &FAST_RANDOM
        and     %01111110
        push    hl
        call    z,&normal_enemy_shoot
        pop     hl
        jr      enemy_display

which_phase:
        jr      phase1
phase0: inc     hl
        inc     hl
        inc     (hl)
        ret
phase1: inc     (hl)
        inc     hl
        inc     hl
        ret
phase2: inc     hl
        inc     hl
        dec     (hl)
        ret
phase3: dec     (hl)
        inc     hl
        inc     hl
        ret

;############## Exploding enemy

exploding_enemy:
        inc     hl
        inc     hl
        inc     hl                      ; HL -> e_x     
        ld      d,(hl)                  ; D = X
        inc     hl
        inc     hl                      ; HL -> e_y
        ld      e,(hl)                  ; E = Y
        inc     hl
        inc     hl                      ; HL -> e_pwr
        ld      (hl),25                 ; Don't let explosion be killed
        inc     hl

        push    de                      ; Save X, Y

        push    hl
        pop     de                      ; DE -> e_img

        ld      c,(hl)
        inc     hl
        ld      b,(hl)
        ld      hl,8
        add     hl,bc                   ; HL = new image address
        ld      a,(hl)
        add     a,a
        jr      c,end_of_explosion      ; -1 -> end of list

        ld      a,l                     ; Save new image address
        ld      (de),a
        inc     de
        ld      a,h
        ld      (de),a

        pop     de                      ; Restore X, Y
        jp      &drw_spr

end_of_explosion:
        ld      hl,-e_img
        add     hl,de
        ld      (hl),0                  ; HL -> e_type

        push    hl
        ld      hl,enemies_left
        dec     (hl)
        pop     hl
        pop     de

        call    &FAST_RANDOM
        and     %01011000
        ret     nz

        ld      de,e_y
        add     hl,de                   ; HL -> e_y
        jp      &deploy_bonus

;############## Bouncing enemies

bounce_enemy:
        inc     hl
        ld      c,(hl)                  ;C = YV (bit 1 - right, bit 0 - fast)
        inc     hl
        ld      b,(hl)                  ;B = XV (bit 1 - down, bit 0 - fast)
        inc     hl

        ld      a,(game_timer)
        or      b
        rrca
        jr      nc,bounce_nox
        bit     1,b
        jr      z,bounce_left
bounce_right:
        inc     (hl)
        ld      a,107
        cp      (hl)
        jr      nz,bounce_nox
        dec     hl
        call    &FAST_RANDOM
        and     1
        ld      (hl),a
        inc     hl
        jr      bounce_nox
bounce_left:
        dec     (hl)
        ld      a,13
        cp      (hl)
        jr      nz,bounce_nox
        dec     hl
        call    &FAST_RANDOM
        and     1
        or      2
        ld      (hl),a
        inc     hl
bounce_nox:

        ld      d,(hl)
        inc     hl
        inc     hl

        ld      a,(game_timer)
        or      c
        rrca
        jr      nc,bounce_noy
        bit     1,c
        jr      z,bounce_up
bounce_down:
        inc     (hl)
        ld      a,60
        cp      (hl)
        jr      nz,bounce_noy
        push    hl
        ld      bc,-4
        add     hl,bc
        call    &FAST_RANDOM
        and     1
        ld      (hl),a
        pop     hl
        jr      bounce_noy
bounce_up:
        dec     (hl)
        ld      a,31
        cp      (hl)
        jr      nz,bounce_noy
        push    hl
        ld      bc,-4
        add     hl,bc
        call    &FAST_RANDOM
        and     1
        or      2
        ld      (hl),a
        pop     hl
bounce_noy:

        ld      e,(hl)
        push    hl
        ld      hl,&img_bounce
        jp      &semi_aim_shoot

