;##################################################################
;
;   Phoenix-Z80 (Data storage, Save/Restore)
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated September 4, 2000.
;
;##################################################################     

;############## Save the game

game_save:
#ifndef __TI86__
        scf
        ccf
        ld      de,(PROGRAM_ADDR)
        ld      hl,(pattern)
        sbc     hl,de
        ld      (pattern),hl
#endif
        ld      de,&saved_flag
        ld      a,1
        ld      (de),a
        inc     de
        ld      hl,perm_var_start
        ld      bc,perm_var_size
        ldir
        jp      &game_exit

;############## Test for saved game, restoring if it exists

restore_game:
        ld      hl,&saved_flag
        ld      a,(hl)
        or      a
        ret     z
        ld      (hl),0
        inc     hl
        ld      de,perm_var_start
        ld      bc,perm_var_size
        ldir
#ifndef __TI86__
        ld      de,(PROGRAM_ADDR)
        ld      hl,(pattern)
        add     hl,de
        ld      (pattern),hl
#endif
        jp      &main_loop

;############## Actual storage space

permanent_data_start:

saved_flag:
        .db     0

saved_data:
        .dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

pb_array:
        .dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        .dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        .dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        .dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

e_array:
        .dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        .dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        .dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        .dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        .dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        .dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

eb_array:             
        .dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        .dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        .dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

permanent_data_end:
