
; -- Peaworm v0.9 --
; by Matthew Shepcar
; 28th December 1998

#include asm86.h
#include ti86asm.inc
#include ti86abs.inc

.org _asm_exec_ram
                    
	nop
	jp Start
  .dw 0,WormMsg
Start:

  call _runindicoff
  call _clrLCD

  ld a,r
  ld (Seed),a

  ld hl,0FC70h
  push hl
  ld de,0FC71h
  ld bc,31
  ld (hl),-1
  ldir
  inc hl
  ld (hl),192
  ld l,9*16+15
  ld (hl),3
  inc hl
  ex de,hl
  ld bc,52*16
  ldir
  pop hl
  ld c,32
  ldir

  ld (_penCol),de
  ld hl,WormMsg
  call _vputs
  ld a,48
  ld (_penCol),a
  call _vputs
  ld a,91
  ld (_penCol),a
  call _vputs
  ld a,(hl)
  call PutNum

  call BuildTrigTables

  call NewPea
  ld a,25
  ld (GrowAmt),a
  ld hl,(HeadPos)
  ld (TailPos),hl
  xor a
  ld (Heading),a
  ld (Eaten),a
  ld bc,0400Ah
  ld d,a
  ld e,a

GameLoop:
  ld a,8
Delay:
  halt
  dec a
  jr nz,Delay

  ld hl,0A000h
HeadPos =$-2
  ld (hl),c
  inc hl
  ld (hl),b
  inc hl
  res 4,h
  ld (HeadPos),hl

  ld hl,SinCosTable
Heading =$-2

  ld a,0FEh
  out (1),a
  in a,(1)
  rra
  rra
  jr c,NotRight
  ld a,l
  add a,8
  ld l,a
  inc a
NotRight:
  rra
  jr c,NotLeft
  ld a,l
  sub 8
  ld l,a
NotLeft:

  ld (Heading),hl

  push bc
  ld a,(hl)
  add a,a
  add a,d
  ld d,a
  bit 7,(hl)
  jr z,NotNegX
  dec b
NotNegX:
  jr nc,NotMoveX
  inc b
NotMoveX:
  ld a,l
  add a,40h
  ld l,a
  ld a,(hl)
  add a,a
  add a,e
  ld e,a
  bit 7,(hl)
  jr z,NotNegY
  dec c
NotNegY:
  jr nc,NotMoveY
  inc c
NotMoveY:

  pop hl
  push de
  ld a,h
  sub b
  and 1
  ld h,a
  ld a,l
  sub c
  and 1
  add a,h
  ld d,4
  jr z,GotFour
  xor 3
  ld d,a
GotFour:

  call CheckPixel
  inc b
  call CheckPixel
  inc c
  call CheckPixel
  dec b
  call CheckPixel
  dec c
  rl d
  jr nc,WormNotCrashed
  ld hl,0
PeaX =$-2
PeaY =$-1
  ld a,b
  sub h
  inc a
  cp 4
  jr nc,WormDead
  ld a,c
  sub l
  inc a
  cp 4
  jr nc,WormDead
  push bc
  call DrawPea
  ld a,0
GrowAmt =$-1
  add a,15
  ld (GrowAmt),a
  call NewPea
  ld a,70
  ld (_penCol),a
  ld hl,Eaten
  inc (hl)
  ld a,(hl)
  call PutNum
  pop bc
WormNotCrashed:

  push bc
  call SetPixel
  inc b
  call SetPixel
  inc c
  call SetPixel
  dec b
  call SetPixel

  ld hl,GrowAmt
  dec (hl)
  jr nz,GrowWorm
  inc (hl)
  ld hl,0A000h
TailPos =$-2
  ld c,(hl)
  inc hl
  ld b,(hl)
  inc hl
  res 4,h
  ld (TailPos),hl

  call ResPixel
  inc b
  call ResPixel
  inc c
  call ResPixel
  dec b
  call ResPixel

GrowWorm:

  ld a,0BFh
  out (1),a
  in a,(1)
  rla
  jr c,NotPaused
  call _getky
WaitUnpause:
  call _getky
  or a
  jr z,WaitUnpause
  ld a,128
NotPaused:
  pop bc
  pop de
  rla
  jp c,GameLoop
  push hl
WormDead:
  pop de
  ld a,(Eaten)
  ld hl,HiScore
  cp (hl)
  jr c,NotNewHigh
  ld (hl),a
  ld hl,Varname-1
  rst 20h
  rst 10h
  call 460Bh
  ld de,HiScore-_asm_exec_ram+2
  add hl,de
  adc a,0
  call _load_ram_ahl
  ld a,(HiScore)
  ld (hl),a
NotNewHigh:
  call _clrScrn
  call _homeup
  jp _getky

NewPea:
  call Random
  ld a,h
  and 7Fh
  cp 7Bh
  jr nc,NewPea
  add a,2
  ld h,a
  ld a,l
  and 3Fh
  cp 30h
  jr nc,NewPea
  add a,12
  ld l,a
  ld (PeaX),hl
  ld d,2
  push hl
  call CheckPea
  pop hl
  dec d
  jr z,NewPea
DrawPea:
  ld d,0
CheckPea:
  ld b,h
  ld c,l
  call PeaPixel
  inc c
  call PeaPixel
  inc b
  call PeaPixel
  dec c
PeaPixel:
  push de
  call FindPixel
  pop de
  ld e,a
  ld a,d
  or a
  ld a,e
  jr z,DrawPeaPixel
  and (hl)
  ret z
  ld d,1
  ret
DrawPeaPixel:
  xor (hl)
  ld (hl),a
  ret

Random:
  ld hl,0
  ld de,12345
Seed =$-2
  ld a,7921 & 255
  ld bc,1000h+(7921/256)
domult16:
	add hl,hl
	rla
  rl c
	jr nc,noadd16
	add hl,de
noadd16:
	djnz domult16
  inc hl
  ld (Seed),hl ;seed=(seed*7921+1) MOD 65536
  ld a,h
  ret

ResPixel:
  call FindPixel
  cpl
  and (hl)
  ld (hl),a
  ret

SetPixel:
  call FindPixel
  or (hl)
  ld (hl),a
  ret

CheckPixel:
  push de
  call FindPixel
  and (hl)
  pop de
  ret z
  dec d
  ret

FindPixel:
  push bc
  ld a,b
  and 7
  add a,offsets_table & 255
  ld e,a
  ld d,offsets_table/256
  ld h,0
  ld a,c
  add a,a
  add a,a
  rl h
  add a,a
  rl h
  add a,a
  rl h
  srl b
  srl b
  srl b
  or b
  ld l,a
  ld a,(de)
  dec h
  dec h
  dec h
  dec h
  pop bc
  ret

PutNum:
  ld l,a
  ld h,0
  call UNPACK_HL
  push af
  ld a,l
  call PutDigit
  pop af
PutDigit:
  add a,'0'
  jp _vputmap

offsets_table:
  .db 128,64,32,16,8,4,2,1

#include trigtab.asm

WormMsg .db "Peaworm!",0
PeasMsg .db "Eaten: 00",0
HiMsg   .db "Hiscore: ",0
HiScore .db 0
Varname .db 4,"worm"
Eaten =$

SinCosTable =09000h

.end
