;best if compiled with Assembly Studio 86 3.1
;- Jonah Cohen <ComAsYuAre@aol.com>


#include "ti86asm.inc"

_alt_flag			equ		$c408
_cursoroff	  		equ		$498c

password_size		equ		$d610
password			equ		$d611
temp_size			equ		$87ff
temp_pw			equ		$8800
temp2_size		equ		$880f
temp_pw2			equ		$8810


.org _asm_exec_ram

begin:
	nop
	jp start
	.dw $0000
	.dw description

move_loop:
;bc is current penCol and penRow
;moves pen cursor down 10 pixels and displays whatever hl points to. (only used twice)
	ld a,b
	add a,10
	ld b,a
	ld (_penCol),bc
	jp _vputs

start:
	call _runindicoff			;turn off run indicator
	call _flushallmenus		;close all menus

#define checksum $8e

#ifndef checksum
	call _clrWindow
	ld a,'$'
	call _putc
;calculate the checksum
	ld a,(_alt_off_exec)
	ld hl,_alt_off_chksum
	ld de,40
	ld b,5
checksum_loop:
	add hl,de
	add a,(hl)
	djnz checksum_loop
	ld (_alt_off_chksum),a
;a contains checksum.  now we display it
	push af
	call _shracc			;a=upper nibble
	call dispnibble
	pop af
	call dispnibble
	jp _newline

dispnibble:
	and $0f				;clear upper nibble
	cp 10
	jr nc,skipadd
	add a,'0'
skipadd:
	jp _putc
#endif

	ld hl,off_chksum
	ld de,_alt_off_chksum
	ld bc,off_end-off_chksum
	ldir					;copy into alternate off area of ram
	call title				;display title
	ld bc,$100b			;move pen location
	ld (_penCol),bc
	ld hl,f1				;display first message
	call _vputs
	bit 7,(iy+$23)			;if alternate off routine flag isn't set, F2 enables it
	jr z,not_disable			;otherwise, F2 disables it
	ld hl,disable_message	;change message
not_disable:
	call move_loop			;move cursor and display text
	ld hl,able_message		;last part of message ("able On86")
	call _vputs
	call move_loop			;display exit


						;if On86 hasn't been run before, all ram at _alt_off_exec is filled with 0's
	ld a,(password_size)		;see if On86 hasn't been run yet
	or a
	jr nz,start_loop			;if it has been run before, skip next step


						;set default password
	ld hl,$0901				;1 is default password length
						;enter (9) is default password
	ld (password_size),hl


start_loop:
	call _get_key			;get a keypress
	cp K_EXIT				;is it exit?
	jr z,exit				;if so, exit
	sub K_F1				;is it F1?
	jr z,change_password		;if so, change password
	inc a					;is it F2?
	jr nz,start_loop			;if not, get another keypress

change_flag:
	ld de,_alt_flag			;alt routine flag
	ld a,(de)				;get byte
	ld hl,on_reset
	bit 7,a				;see if alternate off routine is enabled
	jr nz,toggle
	ld hl,on_set
toggle:
	xor 128				;flip bit 7
	ld (de),a				;store toggled flag

display:
	ld c,$2a

display2:
	push bc
	push hl
	call title				;clear screen, keeping title bar at top
	pop hl
	pop bc
	ld b,$1c				;normal row location
	ld (_penCol),bc			;move cursor
	call _vputs				;display message (enabled/disabled)

getkey:
	call _getky				;wait for keypress, then exit
	or a
	jr z,getkey

exit:
	res 4,(iy+9)			;reset on flag
	jp _clrWindow			;clear screen, move cursor to upper left, then quit

change_password:
	call title				;clear screen, keeping title bar at top
	ld hl,old				;"Enter old password"
	call get_pw			;get password from user
	ld ix,new_password		;where to go if password is correct
	call check_password		;check passwords
;wrong password
	ld hl,wrong_pw_message	;hl points to message "incorrect password."
	ld c,$1e				;column
display3:
	jr display2				;displays, waits for keypress, then exits

store_pw:
						;if it makes it to this point, passwords are identical.
	ld hl,temp2_size			;hl points to temp2 (temp2 is used because its first byte is size and so is the real password's)
	ld de,password_size		;de points to where password will be stored
	ld c,16				;1 byte for size, 15 for password (b=0 already)
	ldir					;copy data
	call title				;clear screen, leaving title at top
	res 7,(iy+$23)			;so that it's "enabled"
	jr change_flag			;enable routine

new_password:
	call title				;clear screen, keeping title bar at top
	ld hl,new				;"Enter new password:"
	call get_pw			;get password

						;since we need to get the new password twice, save data from first input
	ld a,c				;save password length
	ld (temp2_size),a
	ld hl,temp_pw			;hl points to input
	ld de,temp_pw2			;de points to storage
	ld b,0				;clear b (c is already length of input)
	ldir					;copy data

	call _newline			;move to next line
	ld hl,and_again			;message: "And again:"
	call get_pw_cursorset		;get second input
	ld ix,store_pw			;where to go if passwords are identical
	ld de,temp2_size		;de points to first input
	call check_pw
;a mistype
	ld hl,mistype_message	;hl points to message "passwords do not match." (or whatever it is :)
	ld c,$18				;column
	jr display3				;displays, waits for keypress, then exits

off_chksum:
#ifdef checksum
	.db checksum			;previously calculated checksum
#endif
off:
	ei					;enable interrupts
release_key:
	halt
	in a,(3)
	bit 3,a
	jr z,release_key			;make sure they aren't holding down on
shutdown:
	ld hl,(_curRow)			;get cursor row/col
	push hl				;save onto stack
	ld a,1
	out (3),a				;turn off screen
	halt					;wait for on key
	res 1,(iy+13)			;don't save to textShadow
	call _cursoroff			;turn off cursor
	call title-off+_alt_off_exec
						;clear screen and display title bar
	ld hl,enter_password-off+_alt_off_exec
						;display "Enter password:"

	ld a,11
	out (3),a				;turn on screen

	call get_pw-off+_alt_off_exec
						;get password

	pop hl				;retrieve cursor position
	ld (_curRow),hl			;restore cursor

	ld ix,_jforcecmdnochar	;return to home screen if correct password
	call check_password-off+_alt_off_exec
	jr shutdown			;invalid password

check_password:
	ld de,password_size		;de points to real password
check_pw:
	ld a,(de)
	cp c					;check if they're the same length
	ret nz
	ld hl,temp_size
	ld (hl),c
	call _strcmp
	ret nz
;data equal
	pop hl				;clean up stack
	jp (ix)				;passwords equal

title:
	call _clrLCD			;clear screen
	ld c,$1a				;move pen location (b=0 from _clrLCD)
	ld (_penCol),bc
	ld hl,description-off+_alt_off_exec
						;display title message
	call _vputs				;display message
	ld hl,$fc00				;hl points to video mem
	ld b,112				;7 lines of 16 bytes each
reverseline:				;modified from plain jump
	ld a,(hl)				;get byte
	cpl					;reverse it
	ld (hl),a				;store it
	inc hl					;move to next byte
	djnz reverseline			;repeat
	ret

get_pw:
	ld c,2				;third line
	ld (_curRow),bc
get_pw_cursorset:			;don't set cursor
	call _puts				;display message
	call _newline			;next line
	ld hl,temp_pw-1
	ld bc,$0f00				;set counter for 15 keypresses max
pw_loop:
	inc c					;c is counter
	inc hl					;move hl to next byte in storage
	push bc				;save registers
	push hl
key_input:
	call _getky				;get a key
	or a					;is it 0
	jr z,key_input			;if so, get another keypress
	pop hl				;retrieve registers
	pop bc
	ld (hl),a				;store input at temporary password storage
	cp K_ENTER			;is it enter?
	ret z					;if so, return.
						;since c is counter, length is saved even
						;if less than 15 keypresses are stored
	ld a,'*'				;print a * to the screen
	call _putc
	djnz pw_loop			;get next keypress
	ret

;messages used in off routine

description:		.db "On86 2.0 by Jonah Cohen",0
enter_password:		.db "Enter password:",0

off_end:					;end of off routine


;messages not used in off routine

f1:				.db "F1 - Change Password",0
				.db "F2 - En",0
disable_message:	.db "F2 - Dis",0
able_message:		.db "able On86",0
				.db "Exit - Quit On86",0
on_reset:			.db "On86 disabled",0
on_set:			.db "On86 enabled",0
old:				.db "Enter Old Password:",0
new:				.db "Enter New Password:",0
and_again:			.db "And again:",0
wrong_pw_message:	.db "Incorrect Password",0
mistype_message:	.db "Passwords do not match",0


.end
