         .include "ti-86.h"
 ; --------- VARIABLE LOCATIONS ----------------
map       =$8641
xcoords   =$8841
ycoords   =$8941
x         =$80df    ; IX usually points here
y         =$80e0    ; (ix+1)
xv        =$80e1    ; (ix+2)
yv        =$80e2    ; (ix+3)
speed     =$80e3    ; (ix+4)
numgot    =$80e4    ; (ix+5)

length    =$80e5    ; (ix+6)
expand    =$80e6    ; (ix+7)
exptotal  =$80e7    ; (ix+8)
level     =$80e8    ; (ix+9)
head      =$80e9    ; (ix+10)
tail      =$80ea    ; (ix+11)

ptr       =$80eb    ; (ix+12)
oxv       =$80ec    ; (ix+14)
oyv       =$80ed    ; (ix+15)
 ; ---------- START UP SCREEN ------------------
         call     wipe
         ld       ix,$c00f
         ld       (ix),0
         ld       (ix+1),0
         ld       hl,initmsg
         call     _puts
         ld       ix,$c00f
         inc      (ix)
         inc      (ix)
         inc      (ix)
         call     _puts
         call     wait_key
         ld       ix,x
         ld       (ix+4),130
         cp       K_F2
         jr       nz,not_f2
         ld       (ix+4),79
not_f2:  cp       K_F3
         jr       nz,not_f3
         ld       (ix+4),43
not_f3:  cp       K_F4
         jr       nz,not_f4
         ld       (ix+4),20
not_f4:  cp       K_F5
         jr       nz,not_f5
         LD       (IX+4),7
not_f5:  cp       K_CLEAR
         jr       nz,not_on
         ld       (ix+4),1
not_on:  ld       (ix+9),0
 ; ----------- DO THE LEVELS -------------------
levloop: ld       hl,level
         ld       b,(hl)
         ld       hl,level_data
         ld       de,64
         ld       a,0
         cp       b
         jr       z,firstlev2
sll2:    add      hl,de
         djnz     sll2
firstlev2:
         ld       a,255
         cp       (hl)
         jp       z,skip_p
         push     hl
         call     wipe       ; preview
         ld       ix,$c00f
         ld       (ix),0
         ld       (ix+1),0
         ld       hl,approach
         call     _puts
         ld       hl,($80e8)
         ld       h,0
         inc      l
         call     D_HL_DECI
         pop      hl
         ld       ix,$fd75
         ld       b,18
         ld       de,16
vertloop:ld       (ix),1
         ld       (ix+5),128
         add      ix,de
         djnz     vertloop
         ld       b,4
         ld       ix,$fd76
hl1:     ld       (ix),255
         inc      ix
         djnz     hl1
         ld       b,4
         ld       ix,$fe86
hl2:     ld       (ix),255
         inc      ix
         djnz     hl2
         ld       ix,$fd86
         ld       b,16
         ld       de,16
preview: ld       a,(hl)
         ld       (ix),a
         inc      hl
         ld       a,(hl)
         ld       (ix+1),a
         inc      hl
         ld       a,(hl)
         ld       (ix+2),a
         inc      hl
         ld       a,(hl)
         ld       (ix+3),a
         inc      hl
         add      ix,de
         djnz     preview
         call     wait_key
skip_p:
         call     loadlevel
         ld       ix,x
         ld       (ix),0
         ld       (ix+1),0
         ld       (ix+2),1
         ld       (ix+3),0
         ld       (ix+5),0
         ld       (ix+6),1
         ld       (ix+7),8
         ld       (ix+8),8
         ld       (ix+10),0
         ld       (ix+11),0
         call     make_goodie
         call     level_play
         ld       a,(ix+5)
         cp       10
         Jr       nz,lose
         inc      (ix+9)
         jp       levloop
lose:
         call     wipe
         ld       ix,$c00f
         ld       (ix),0
         ld       (ix+1),0
         ld       hl,str_you_lose
         call     _puts
         call     wait_key
         jp       wipe
 ; -------------- PLAY THE LEVEL ---------------
level_play:
         ld       a,(ix)           ; Move
         add      a,(ix+2)
         and      31
         ld       (ix),a
         ld       c,(ix+10)         
         ld       hl,xcoords
         ld       b,0
         add      hl,bc
         ld       (hl),a
         ld       a,(ix+1)
         add      a,(ix+3)
         and      15
         ld       (ix+1),a
         inc      h
         ld       (hl),a
         inc      (ix+10)
         ld       a,(ix+7)
         or       a
         jp       z,moving
         dec      (ix+7)
continue:ld       hl,$fc00         ; Draw a piece of you
         ld       a,(ix+1)
         srl      a
         srl      a
         or       h
         ld       h,a
         ld       a,(ix+1)
         and      3
         sla      a
         sla      a
         sla      a
         sla      a
         sla      a
         sla      a
         ld       l,a
         ld       a,(ix)
         srl      a
         or       l
         ld       l,a
         ld       de,16
         bit      0,(ix)
         jp       nz,putwrmr
         jp       putwrml
wrmput:  ld       b,0
         LD       c,(IX+1)         ; interact with environment
         ld       hl,map
         bit      3,c
         jr       z,nope1
         inc      h
nope1:   sla      c
         sla      c
         sla      c
         sla      c
         sla      c
         add      hl,bc
         ld       c,(ix)
         add      hl,bc
         ld       a,(hl)
         cp       1
         ret      z
         ld       (hl),1
         ld       hl,(ptr)         ; random (?) number generation
         inc      hl
         inc      hl
         res      7,h
         ld       (ptr),hl
         cp       -1               ; see if you got a goodie
         jr       nz,nogoodie
         ld       a,(ix+5)
         inc      a
         ld       (ix+5),a
         cp       10
         ret      z
         ld       a,(ix+7)
         add      a,(ix+8)
         ld       (ix+7),a
         call     make_goodie
nogoodie:ld       a,(ix+2)
         ld       (ix+14),a
         ld       a,(ix+3)
         ld       (ix+15),a
         ld       a,(ix+4)
waste_time:
         ld       b,200
waste_o: push     bc
         ld       b,a
waste_i: nop
         djnz     waste_i
         pop      bc
         push     af
         ld       c,1
         ld       a,%00111111
         out      (c),a
         in       a,(c)
         bit      6,a
         jr       z,bye
         ld       a,%01111110
         out      (c),a
         in       a,(c)
         bit      1,a
         jr       z,left
         bit      2,a
         jr       z,right
         bit      3,a
         jr       z,up
         bit      0,a
         jr       z,down
cont:    pop      af
         djnz     waste_o
         jp       level_play
left:    bit      0,(ix+14)
         jr       nz,cont
         ld       (ix+2),-1
         ld       (ix+3),0
         jr       cont
right:   bit      0,(ix+14)
         jr       nz,cont
         ld       (ix+2),1
         ld       (ix+3),0
         jr       cont
up:      bit      0,(ix+15)
         jr       nz,cont
         ld       (ix+2),0
         ld       (ix+3),-1
         jr       cont
down:    bit      0,(ix+15)
         jr       nz,cont
         ld       (ix+2),0
         ld       (ix+3),1
         jr       cont
bye:     inc      sp
         inc      sp
         ret  
 ; ------ WORM IS MOVING, SO ERASE THE TAIL ---
moving:  ld       hl,xcoords
         ld       c,(ix+11)
         inc      (ix+11)
         ld       b,0
         add      hl,bc
         ld       d,(hl)
         inc      h
         ld       e,(hl)
         ld       hl,map
         ld       c,e
         bit      3,c
         jr       z,nope2
         inc      h
nope2:   sla      c
         sla      c
         sla      c
         sla      c
         sla      c
         add      hl,bc
         ld       c,d
         add      hl,bc
         ld       (hl),b
         ld       a,e
         ld       hl,$fc00        
         srl      a
         srl      a
         or       h
         ld       h,a
         ld       a,e
         and      3
         sla      a
         sla      a
         sla      a
         sla      a
         sla      a
         sla      a
         ld       l,a
         ld       a,d
         srl      a
         or       l
         ld       l,a
         bit      0,d
         ld       bc,16
         jr       z,right_erase
         ld       a,240
         and      (hl)
         ld       (hl),a
         add      hl,bc
         ld       a,240
         and      (hl)
         ld       (hl),a
         add      hl,bc
         ld       a,240
         and      (hl)
         ld       (hl),a
         add      hl,bc
         ld       a,240
         and      (hl)
         ld       (hl),a
         jp       continue
right_erase:
         ld       a,15
         and      (hl)
         ld       (hl),a
         add      hl,bc
         ld       a,15
         and      (hl)
         ld       (hl),a
         add      hl,bc
         ld       a,15
         and      (hl)
         ld       (hl),a
         add      hl,bc
         ld       a,15
         and      (hl)
         ld       (hl),a
         jp       continue
 ; -------- DRAW A SECTION OF THE WORM --------
putwrmr: ld       a,(hl)
         or       %00001111
         ld       (hl),a
         add      hl,de
         ld       a,(hl)
         or       %00001001
         and      %11111001
         ld       (hl),a
         add      hl,de
         ld       (hl),a
         add      hl,de
         ld       a,(hl)
         or       %00001111
         ld       (hl),a
         jp       wrmput
putwrml: ld       a,(hl)
         or       %11110000
         ld       (hl),a
         add      hl,de
         ld       a,(hl)
         or       %10010000
         and      %10011111
         ld       (hl),a
         add      hl,de
         ld       (hl),a
         add      hl,de
         ld       a,(hl)
         or       %11110000
         ld       (hl),a
         jp       wrmput
 ; --------- LOAD A LEVEL INTO MEMORY ----------
loadlevel:                    ; find current level
         ld       ix,map
         ld       hl,level
         ld       b,(hl)
         ld       hl,level_data
         ld       de,64
         ld       a,0
         cp       b
         jr       z,firstlev
sll:     add      hl,de
         djnz     sll
firstlev:ld       a,(hl)
         cp       255
         jr       z,win
         ld       b,64                  ; decrunch level map
loop:    ld       a,(hl)
         push     bc
         ld       b,8
loop_decrunch:
         rlc      a
         bit      0,a
         ld       (ix),0
         jr       z,noblk
         ld       (ix),1
noblk:   inc      ix
         djnz     loop_decrunch
         pop      bc
         inc      hl
         djnz     loop
         call     wipe       ; draw level map
         ld       hl,map
         ld       ix,$fc00
         ld       b,16
draw_outer:
         push     bc
         ld       b,16
draw_inner:
         ld       a,(hl)
         or       a
         jr       z,no__left
         ld       (ix),240
         ld       (ix+16),240
         ld       (ix+32),240
         ld       (ix+48),240
no__left:inc      hl
         ld       a,(hl)
         or       a
         jr       z,no__right
         ld       a,(ix)
         or       15
         ld       (ix),a
         ld       (ix+16),a
         ld       (ix+32),a
         ld       (ix+48),a
no__right:
         inc      hl
         inc      ix
         djnz     draw_inner
         pop      bc
         ld       de,48
         add      ix,de
         djnz     draw_outer
         ret
win:
         call     wipe
         ld       ix,$800c
         ld       (ix),0
         ld       (ix+1),0
         ld       hl,str_you_win
         call     _puts
         call     wait_key
         inc      sp
         inc      sp
         call     wipe
         ret
 ; ------------ WAIT FOR A KEYPRESS -------------
wait_key:call     GET_KEY
wait_key_i:
         call     GET_KEY
         or       a
         ret      nz
         jr       wait_key_i
 ; ------------------ STRINGS -------------------
initmsg:
         .db      "--> N I B B L E S <--"
         .db      "   Copyright 1997    "
         .db      " by Patrick Davidson "
         .db      "email:ariwsi@juno.com",0
         .DB      "F1=slowest,F5=fastest"
         .db      0
str_you_lose:
         .db      "GAME OVER - YOU LOSE!",0
str_you_win:
         .db      "Wow !!!!  You won !!!",0
approach:
         .db      "---> NEXT LEVEL:",0
 ; ------------------ LEVELS ---------------------
level_data:
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000

         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%11111111,%11111111,%00000000
         .db      %00000000,%11111111,%11111111,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000

         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00001111,%11110000,%00001111,%11110000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00001111,%11110000,%00001111,%11110000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000

         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %01000010,%01111110,%01000010,%01111110
         .db      %01000010,%01000010,%01000010,%01000010
         .db      %01000010,%01000010,%01000010,%01000010
         .db      %01000010,%01000010,%01000010,%01000010
         .db      %01111110,%01011010,%01111110,%01011010
         .db      %01111110,%01011010,%01111110,%01011010
         .db      %01000010,%01000010,%01000010,%01000010
         .db      %01000010,%01000010,%01000010,%01000010
         .db      %01000010,%01000010,%01000010,%01000010
         .db      %01000010,%01000010,%01000010,%01000010
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      255
 ;----------------- MAKE A GOODIE ----------------
make_goodie:
         ld       hl,(ptr)
         inc      hl
         inc      hl
         res      7,h
         ld       (ptr),hl
         ld       e,(hl)
         inc      hl
         ld       d,(hl)
         push     de
         pop      bc
         ld       a,b
         and      1
         ld       b,a
         ld       hl,map
         add      hl,bc
         ld       a,(hl)
         or       a
         jr       nz,make_goodie
ok4:     ld       (hl),-1
         ld       hl,$fc00
         push     de
         pop      bc
         srl      c
         bit      0,b
         jr       z,ok5
         set      7,c
ok5:     ld       a,c
         and      240
         ld       b,a
         srl      b
         srl      b
         srl      b
         srl      b
         ld       c,e
         ld       de,64
         cp       0
         jr       z,toplil
add_loop:add      hl,de
         djnz     add_loop
toplil:  ld       a,c
         srl      a
         and      15
         ld       e,a
         add      hl,de
         ld       b,6
         bit      0,c
         jr       nz,skip
         ld       b,96
skip:    ld       de,16
         add      hl,de
         ld       a,(hl)
         or       b
         ld       (hl),a
         add      hl,de
         ld       (hl),a
         ret
wipe:    ld       hl,$fdf0
         ld       b,32
lw1:     ld       (hl),0
         inc      hl
         djnz     lw1
         ld       b,32
lw2:     push     bc
         ld       bc,496
         ld       hl,$fc10
         ld       de,$fc00
         ldir
         ld       de,$ffff
         ld       hl,$ffef
         ld       bc,496
         lddr
         ld       b,0
l:       push     bc
         ld       b,16
li:      djnz     li
         pop      bc
         djnz     l
         pop      bc
         djnz     lw2
         ret
         .end
