#include "ti86asm.inc" 	;include the rom calls

.org _asm_exec_ram 		;tell where program starts

	nop 				;required for shells
	jp ProgStart 		;goto the beginning of the program
	.dw 0 				;shell syntax
	.dw ShellTitle 		;shell comment

ShellTitle:
	.db "Mines86 1.03 by Sean Barnes",0 	;shell comment
strings: 									;start of strings
title: .db "Mines86",0 						;title
title2: .db "-------",0 					;underline title
author: .db "by Sean Barnes",0 				;my name
flags: .db "Flags:",0 						;flag string
time: .db "Time:",0 						;time string
loading .db "Loading...",0 					;loading string
loopn .db tflags 							;counter for level loop
tx .db 0 									;loop x
ty	.db 0 									;loop y
flagn: .db 10 								;flags
timen: .db $00,$00 							;time
currow .db 1 								;cursor y value
curcol .db 1 								;cursor x value
tflags = 10									;number of flags in a level
spsave .dw $0000 							;stack pointer
winstr .db "You Win!",0 					;win string
lose .db "GAME OVER...",0 					;lose string
fsquares .db 0 								;number of squares uncovered

cursor: 		;cursor sprite
	.db %00000000
	.db %00011000
	.db %00100100
	.db %01011010
	.db %01011010
	.db %00100100
	.db %00011000
	.db %00000000

ProgStart:
	ld (spsave),sp 			;save the stack pointer
	call _flushallmenus 	;clear menus from screen
	call _runindicoff 		;turn off the run indicator
	call titledisp 			;display the title
	call setup 				;setup variables
	call create_level 		;create random level
	call level_to_temp 		;make a copy of the level
	call setup 				;setup the variables again
	call do_right			;display statistics
	call do_screen 			;draw the grid
	ld hl,temp 				;get address of the level copy
	ld (Map),hl 			;set Map to display temp
timer:
	call do_cursor 			;draw the cursor
	call checkwin 			;check to see if you won
	ld a,(timen) 			;get first byte of time
	ld c,a 					;store it into c
	ld a,(timen+1) 			;get second byte of time
	ld b,a 					;store it into b
	inc bc 					;time=time+1
	ld a,c 					;load a with first byte of time
	ld (timen),a 			;save the byte
	ld a,b 					;load b with second byte of time
	ld (timen+1),a 			;save the byte
	call do_right 			;display new time
	ld b,$FF 				;test if time ran out
	jp tloop 				;jump to the timer loop
tloop:
	ld b,$FF 				;set initial timer
tloop1: 					;outer timer loop
	ld d,b 					;save value of b
	call _getky 			;check if a key is pressed
	cp 0 					;check for no key
	jp nz,tdone 			;if there was a key goto the end of timer
	ld b,$FF 				;set b to $FF for loop
tloop2: 
	djnz tloop2 			;loop $FF times (based on b)
	ld b,d 					;get saved value of b
	djnz tloop1 			;go to tloop1 b times
	call _getky 			;check for key
	jp nz,tdone 			;if there is one goto tdone
	jp timer 				;otherwise increment timer
titledisp: 
	call _clrLCD			;clear the screen
	ld hl,titlepic 			;get location of the title screen
	ld de,$fc00 			;save the screen location
	ld a,64 				;save screen size
	call DispRLE 			;display the screen
tlloop:
	call _getky 			;check for key
	ret nz 					;if key pressed then return
	cp K_ENTER 				;check for enter
	ret z 					;return if enter was pressed
	jp tlloop 				;otherwise start loop over
checkwin:
	ld hl,(Map) 			;get screen location
	ld b,64 				;get screen size
chloop:
	ld a,(hl) 				;get a byte
	cp 01 					;check for covered square
	ret z 					;you couldn't have won yet
	cp 03 					;check for wrong flags
	ret z 					;you couldn't have won yet
	cp 05 					;check for wrong question marks
	ret z 					;you couldn't have won yet
	inc hl 					;go to next byte
	djnz chloop 			;go back to chloop
win: 						;if you are here you won
	call _clrLCD 			;clear the screen
	ld a,3 					;set a to fourth row (first is 0)
	ld (_curRow),a 			;save the row number
	ld a,6 					;set a to seventh column (first is 0)
	ld (_curCol),a 			;save the col number
	ld hl,winstr 			;get address of win string
	call _puts 				;display the string
	call invert 			;invert the screen
wloop:
	call _getky 			;check for a keypress
	cp K_ENTER 				;is it enter
	jp z,quit 				;then quit
	cp 0 					;has a key been pressed
	jp z,wloop 				;if not goto loop
	jp quit 				;a key was pressed so quit
alpha: 						;flag and question marks
	call get_cursor 		;get the cursor location
	ld b,e 					;convert e to b
	ld c,d 					;convert d to c
	call GetTile 			;get the tile address
	ld a,(hl) 				;get the tile type
	cp $01 					;was it a blank square
	jp z,qmine1 			;goto qmine1
	cp $02 					;was it a mine
	jp z,qmine1 			;goto qmine1
	cp $03 					;was it a flag
	jp z,qmine2 			;goto qmine2
	cp $04 					;was it a flag
	jp z,qmine2 			;goto qmine2
	cp $05 					;was it a question mark
	jp z,nomine 			;goto nomine
	cp $06 					;was it a question mark
	jp z,nomine 			;goto nomine
	ret 					;square was uncovered so return
qmine1:
	push af					;save the af register
	ld a,(flagn)			;get the total number of flags left
	cp 0					;check if there are 0 flags left
	jp z,qmine11			;if so, do a question mark instead
	dec a					;subtract one from the flags
	ld (flagn),a			;save the flag value
	pop af					;restore the af register
	inc a					;increment sprite number
	inc a					;increment sprite number
	ld (hl),a				;save the new tile
	call do_right			;redisplay the flags
	call do_screen			;redraw the tilemap
	ret						;return to tdone
qmine11:
	pop af					;save af register
	inc a					;increment sprite
	inc a					;increment sprite
	inc a					;increment sprite
	inc a					;increment sprite
	ld (hl),a				;save the sprite
	call do_right			;redisplay the flag number
	call do_screen			;redraw the tilemap
	ret						;return to tdone
qmine2:
	push af					;save af register
	ld a,(flagn)			;get the number of flags left
	inc a					;add one to the flags
	ld (flagn),a			;save the new flag number
	pop af					;restore af register
	inc a					;add one to sprite
	inc a					;add one to sprite
	ld (hl),a				;save new sprite number
	call do_right			;redisplay the flags
	call do_screen			;redraw the screen
	ret						;return to tdone
nomine:
	dec a					;decrement sprite
	dec a					;decrement sprite
	dec a					;decrement sprite
	dec a					;decrement sprite
	ld (hl),a				;save new sprite number
	call do_screen			;redraw the screen
	ret						;return to tdone
quit:
	set appTextSave,(iy+appflags)	;make sure to clear screen copy
	call _clrScrn			; clear the screen
	xor a					;set a to 0
	ld (_curRow),a			;save cursor row
	ld (_curCol),a			;save cursor column
	ld sp,(spsave)			;restore the stack pointer
	ret						;exit from the program
tdone:
	cp K_EXIT				;was exit pressed
	jp z,quit				;then quit
	cp K_UP					;was up pressed
	jp z,moveup				;then move up
	cp K_DOWN				;was down pressed
	jp z,movedown			;then move down
	cp K_LEFT				;was left pressed
	jp z,moveleft			;then move left
	cp K_RIGHT				;was right pressed
	jp z,moveright			;then move right
	cp K_MORE				;was more pressed
	call z,CalcOff			;then turn off the calculator
	cp K_ALPHA				;was alpha pressed
	call z,alpha			;then change the sprites
	cp K_SECOND				;was second pressed
	call z,second			;then calculate new sprite
	jp timer				;done checking keys, go to timer
dmine:
	ld (hl),$a				;replace mine with an x
	ret						;return
dflag:
	ld (hl),$b				;replace wrong flag with a flag and line
	ret						;return
dead:
	call do_screen			;redisplay the screen
	ld hl,(Map)				;get pointer to map
	ld b,64					;set counter
dloop1:
	ld a,(hl)				;get sprite number
	cp 02					;was it a mine
	call z,dmine			;then display the mine
	cp 03					;was it a bad flag
	call z,dflag			;then display bad flag
	cp 06					;was it a question mark on a mine
	call z,dmine			;then display the mine
	inc hl					;go to next byte
	djnz dloop1				;loop to check next byte
	call do_screen			;redisplay the screen
dkey:
	call _getky				;check for a key
	cp K_ENTER				;was it enter
	jp z,ddd				;then go to ddd
	cp 0					;was a key pressed
	jp z,dkey				;no, then check again
ddd:
	call _clrLCD			;clear the screen
	ld a,3					;row = 3
	ld (_curRow),a			;save row number
	ld a,5					;col = 5
	ld (_curCol),a			;save col number
	ld hl,lose				;get lose string pointer
	call _puts				;display the string
	call invert				;invert the screen
dloop:
	call _getky				;check for a key
	jp nz,quit				;key pressed, go to quit
	cp K_ENTER				;was it enter
	jp z,quit				;yes, so quit
	jp dloop				;no key, go to dloop
second:
	call get_cursor_bc		;get the cursor value
	call GetTile			;get the current sprite
	ld a,(hl)				;put it into a
	cp $03					;if it was a flag
	jp z,timer				;then go to the timer
	cp $04					;if it was a flag
	jp z,timer				;then go to the timer
	cp $02					;if it was a mine
	jp z,dead				;then you are dead
	cp $06					;if it was a question mark and a mine
	jp z,dead				;then you are dead
	ld a,(fsquares)			;get uncovered squares
	inc a					;add one to the squares
	cp 64-tflags			;check if you have found them all
	jp z,win				;if so, you won
	ld (fsquares),a			;save the uncovered squares
	ld a,$10				;start with 0 mines near it
	ld (hl),a				;save the new sprite
sul:
	call get_cursor_bc		;get the cursor
	ld a,c					;get the row
	cp 0					;if it is row 0
	jp z,su					;go to the next spot
	ld a,b					;get the col
	cp 0					;if it is 0
	jp z,su					;go to the next spot
	dec c					;move up 1
	dec b					;move left 1
	call GetTile			;check that tile
	ld a,(hl)				;get the tile
	cp 02					;if it was a mine
	call z,incm				;then add one to the sprite
	cp 04					;if it was a correct flag
	call z,incm				;then add one to the sprite
	cp 06					;if it was a question mark and a mine
	call z,incm				;then add one to the sprite
su:
	call get_cursor_bc		;get the cursor
	ld a,c					;get the row
	cp 0					;if it is 0
	jp z,sur				;go to the next spot
	dec c					;move up 1
	call GetTile			;check that tile
	ld a,(hl)				;get the tile
	cp 02					;if it was a mine
	call z,incm				;then add one to the sprite
	cp 04					;if it was a correct flag
	call z,incm				;then add one to the sprite
	cp 06					;if it was a question mark and a mine
	call z,incm				;then add one to the sprite
sur:
	call get_cursor_bc		;get the cursor
	ld a,c					;get the row
	cp 0					;if it is 0
	jp z,sl					;go to the next spot
	ld a,b					;get the col
	cp 7					;if it is 7
	jp z,sl					;go to the next spot
	dec c					;move up 1
	inc b					;move right 1
	call GetTile			;check that tile
	ld a,(hl)				;get the tile
	cp 02					;if it was a mine
	call z,incm				;then add one to the sprite
	cp 04					;if it was a correct flag
	call z,incm				;then add one to the sprite
	cp 06					;if it was a question mark and a mine
	call z,incm				;then add one to the sprite
sl:
	call get_cursor_bc		;get the cursor
	ld a,b					;get the col
	cp 0					;if it is 0
	jp z,sr					;go to the next spot
	dec b					;move left 1
	call GetTile			;check that tile
	ld a,(hl)				;get the tile
	cp 02					;if it was a mine
	call z,incm				;then add one to the sprite
	cp 04					;if it was a correct flag
	call z,incm				;then add one to the sprite
	cp 06					;if it was a question mark and a mine
	call z,incm				;then add one to the sprite
sr:
	call get_cursor_bc		;get the cursor
	ld a,b					;get the col
	cp 7					;if it is 7
	jp z,sdl				;go to the next spot
	inc b					;move right 1
	call GetTile			;check that tile
	ld a,(hl)				;get the tile
	cp 02					;if it was a mine
	call z,incm				;then add one to the sprite
	cp 04					;if it was a correct flag
	call z,incm				;then add one to the sprite
	cp 06					;if it was a question mark and a mine
	call z,incm				;then add one to the sprite
sdl:
	call get_cursor_bc		;get the cursor
	ld a,c					;get the row
	cp 7					;if it is 7
	jp z,sd					;go to the next spot
	ld a,b					;get the col
	cp 0					;if it is 0
	jp z,sd					;go to the next spot
	inc c					;move down 1
	dec b					;move left 1
	call GetTile			;check that tile
	ld a,(hl)				;get the tile
	cp 02					;if it was a mine
	call z,incm				;then add one to the sprite
	cp 04					;if it was a correct flag
	call z,incm				;then add one to the sprite
	cp 06					;if it was a question mark and a mine
	call z,incm				;then add one to the sprite
sd:
	call get_cursor_bc		;get the cursor
	ld a,c					;get the row
	cp 7					;if it is 7
	jp z,sdr				;go to the next spot
	inc c					;move down 1
	call GetTile			;check that tile
	ld a,(hl)				;get the tile
	cp 02					;if it was a mine
	call z,incm				;then add one to the sprite
	cp 04					;if it was a correct flag
	call z,incm				;then add one to the sprite
	cp 06					;if it was a question mark and a mine
	call z,incm				;then add one to the sprite
sdr:
	call get_cursor_bc		;get the cursor
	ld a,c					;get the row
	cp 7					;if it is 7
	jp z,timer				;go to the timer
	ld a,b					;get the col
	cp 7					;if it is 7
	jp z,timer				;go to the timer
	inc c					;move down 1
	inc b					;move right 1
	call GetTile			;check that tile
	ld a,(hl)				;get the tile
	cp 02					;if it was a mine
	call z,incm				;then add one to the sprite
	cp 04					;if it was a correct flag
	call z,incm				;then add one to the sprite
	cp 06					;if it was a question mark and a mine
	call z,incm				;then add one to the sprite
	ret						;done checking for mines
incm:
	call get_cursor_bc		;get the cursor
	call GetTile			;get tile offset
	ld a,(hl)				;get the tile
	inc a					;add one to the tile
	ld (hl),a				;save the tile
	ret						;return
get_cursor_bc:
	call get_cursor			;get the cursor coordinates
	ld c,d					;c=d=row
	ld b,e					;b=e=col
	ret						;return
CalcOff: ;turn off the calculator but stay in program
	;this routine came with Assembly Studio
	ld a,1
	out (3),a
	halt
	ld a,11
	out (3),a        
	res onInterrupt,(iy+onflags)	;make sure TI-OS doesn't get the onkey
	ret						;return
moveup:
	call no_cursor			;erase the cursor
	call get_cursor			;get the cursor
	ld a,d					;get the row
	cp 0					;if it is 0
	jp z,timer				;go to the timer
	dec d					;move up one
	call put_cursor			;save the cursor
	jp timer				;go to the timer
movedown:
	call no_cursor			;erase the cursor
	call get_cursor			;get the cursor
	ld a,d					;get the row
	cp 7					;if it is 7
	jp z,timer				;go to the timer
	inc d					;move down one
	call put_cursor			;save the cursor
	jp timer				;go to the timer
moveleft:
	call no_cursor			;erase the cursor
	call get_cursor			;get the cursor
	ld a,e					;get the col
	cp 0					;if it is 0
	jp z,timer				;go to the timer
	dec e					;move left one
	call put_cursor			;save the cursor
	jp timer				;go to the timer
moveright:
	call no_cursor			;erase the cursor
	call get_cursor			;get the cursor
	ld a,e					;get the col
	cp 7					;if it is 7
	jp z,timer				;go to the timer
	inc e					;move right one
	call put_cursor			;save the cursor
	jp timer				;go to the timer
create_level:
	ld hl,title				;get the title string
	ld a,7					;col=7
	ld (_curCol),a			;save the col
	ld a,2					;row=2
	ld (_curRow),a			;save the row
	call _puts				;display the string
	ld hl,author			;get the author string
	ld a,5					;col=5
	ld (_curCol),a			;save the col
	ld a,3					;row=3
	ld (_curRow),a			;save the row
	call _puts				;display the string
	ld hl,loading			;get the loading string
	ld a,6					;col=6
	ld (_curCol),a			;save the col
	ld a,5					;row=5
	ld (_curRow),a			;save the row
	call _puts				;display the string
	ld bc,64				;set counter to 64 (map size)
	ld hl,blank				;get pointer to blank level
	ld de,level				;get pointer to level
	ldir					;copy blank level into real level
	ld a,tflags				;get number of flags
	ld (loopn),a			;set the counter
lloop:
	call Rand				;get random number
	ld (tx),a				;save rand into tx
	call Rand				;get random number
	ld (ty),a				;save rand into ty
	ld a,(tx)				;get tx
	ld b,a					;put into b
	ld a,(ty)				;get ty
	ld c,a					;put into c
	dec b					;set correct range
	dec c					;set correct range
	ld a,b					;get b
	cp 0					;if it is not 0
	jp nz,cont1				;go to cont1
	ld a,c					;get c
	cp 0					;if it is 0
	jp z,lloop				;then mine is upper-left, so go to lloop
cont1:
	call GetTile			;get the tile address there
	ld a,(hl)				;get the tile
	cp $02					;check if it is already a mine
	jp z,lloop				;if it is, go to lloop
	ld (hl),$02				;put a mine there
	ld a,(loopn)			;get loop counter
	dec a					;decrement the counter
	ret z					;finished making level
	ld (loopn),a			;save the counter
	jp lloop				;go to lloop
Rand:						;creates a random number between 1 and 8, inclusive
	call _random			;ROM routine for random number
	ld a,(_OP1M+2)			;get one of the digits
	and %00001111			;get lower 4 bits
	cp 1					;check if it is under 1
	jp c,Rand				;if it is go to rand
	cp 9					;check if it is 9 or more
	jp nc,Rand				;if it is go to rand
	ret						;return
level_to_temp: 				;creates a copy of the level
	ld bc,64				;set loop counter
	ld hl,level				;get level pointer
	ld de,temp				;get temp pointer
	ldir					;copy level
	ret						;return
setup:						;set up variables for the game
	call _clrLCD			;clear the screen
	ld a,0					;set uncovered squares to 0
	ld (fsquares),a			;save the value
	ld hl,level				;get level pointer
	ld (Map),hl				;save it to (Map)
	ld d,0					;cursor row=0
	ld e,0					;cursor col=0
	call put_cursor			;save cursor coordinates
	ld a,tflags				;get the number of mines
	ld (flagn),a			;save it
	ld a,0					;reset half of timer
	ld (timen),a			;save it
	ld a,0					;reset other half of timer
	ld (timen+1),a			;save it
	ret						;return
do_right:					;starts at 11d and goes to 21d
	ld a,12					;col=12
	ld (_curCol),a			;save the col
	ld a,0					;row=0
	ld (_curRow),a			;save the row
	ld hl,title				;get the title string
	call _puts				;display the string
	ld a,12					;col=12
	ld (_curCol),a			;save the col
	ld a,1					;row=1
	ld (_curRow),a			;save the row
	ld hl,title2			;get the title underline
	call _puts				;display the string
	ld a,12					;col=12
	ld (_curCol),a			;save the col
	ld a,2					;row=2
	ld (_curRow),a			;save the row
	ld hl,flags				;get the flags string
	call _puts				;display it
	ld a,12					;col=12
	ld (_curCol),a			;save the col
	ld a,5					;row=5
	ld (_curRow),a			;save the row
	ld hl,time				;get the time string
	call _puts				;display it
	ld a,11					;col=11
	ld (_curCol),a			;save the col
	ld a,3					;row=3
	ld (_curRow),a			;save the row
	call disp_flag			;display the flag number
	ld a,12					;col=12
	ld (_curCol),a			;save the col
	ld a,6					;row=6
	ld (_curRow),a			;save the row
	call disp_time			;display the time
	ret						;return
disp_flag: 					;displays the number of flags
	ld a,(flagn)			;get the number of flags left
	ld h,0					;clear upper byte
	ld l,a					;put number into lower byte
	ld a,0					;clear a
	call _dispAHL			;display 24bit number for flags
	ld a,6					;row=6
	ld (_curRow),a			;save the row
	ld a,20					;col=20
	ld (_curCol),a			;save the col
	ld a,$20				;get space char
	call _putc				;display it
	ret 					;return
disp_time:					;displays the time
	ld a,(timen)			;get lower byte of time
	ld l,a					;put into l
	ld a,(timen+1)			;get upper byte of time
	ld h,a					;put into h
	ld a,0					;clear a
	call _dispAHL			;display 24bit time
	ret						;return
do_screen: 					;do the map
	ld hl,(Map)				;get map pointer
	call DrawMap			;display it
	ret						;return
do_cursor: 					;draw the cursor
	call get_cursor			;get cursor coordinates
	ld hl,cursor			;get cursor sprite
	call GridPutSprite		;display the cursor
	ret						;return
put_cursor: 				;store cursor variables
	ld a,d					;get row
	ld (currow),a			;save row
	ld a,e					;get col
	ld (curcol),a			;save col
	ret						;return
get_cursor: 				;get cursor variables
	ld a,(currow)			;get row
	ld d,a					;put row into d
	ld a,(curcol)			;get col
	ld e,a					;put col into e
	ret						;return
no_cursor:					;get rid of the variables
	call do_screen			;redisplay the screen
	ret						;return
invert:						;invert the screen
	ld hl,$FC00-1			;byte before display
invert2:					;loop
	inc hl					;go to next byte
	ld a,(hl)				;get that byte
	cpl						;invert it (complement it)
	ld (hl),a				;save the byte
	ld a,l					;get lower byte of address
	cp $FF					;is it at the end of the display
	jp nz,invert2			;not yet, go to invert2
	ld a,h					;get upper byte of address
	cp $FF					;is it at the end of the display
	jp nz,invert2			;not yet, go to invert 2
	ret						;return
GetTile:
 	sla c             		;multiply row by two
 	sla c             		;multiply row by two
 	sla c             		;multiply row by two
 	ld a,c            		;get row
 	add a,b           		;add to col
 	ld l,a            		;put into lower byte
 	ld h,0            		;clear upper byte
 	ld bc,(Map)         	;point to start of the map
 	add hl,bc         		;calculate tile address
 	ret               		;return
;===========================================================
; GridPutSprite:                                  [Dan Eble]
;  Puts an aligned sprite at (E, D), where HL -> Sprite
;===========================================================
; IN : D  = y (0-7 inclusive)
;      E  = x (0-15 inclusive)
;      HL-> sprite
;
; OUT: AF, BC, DE, HL, IX modified
; Current total : 28b/567t (not counting ret)
;===========================================================
GridPutSprite:
 push bc
 push hl
 pop ix                 ; ix-> sprite
 srl d                  ; de = 128y+x (16 bytes/row, 8 rows)
 rra
 and $80
 or e                   ; add x offset (remember x <= 15)
 ld e,a
 ld hl,$fc00            ; hl-> video ram
 add hl,de              ; hl-> video ram + offset
 ld b,8                 ; initialize loop counter
 ld de,$10              ; initialize line increment
GPS_Loop:
 ld a,(ix+0)            ; get byte from sprite
 ld (hl),a              ; put byte on screen
 inc ix                 ; move to next byte in sprite
 add hl,de              ; move to next line on screen
 djnz GPS_Loop
 pop bc
 ret
;
; written by David Phillips <electrum@tfs.net>
; started: 8/19/98
; last update: 11/5/98
;
; input: HL = RLE encoded picture, DE = where to display
; output: 1024 byte decoded picture
; destroys: AF, BC, DE, HL
; current size: 32 bytes
;===========================================================
DispRLE:
 ld bc,1024			; we need to copy 
DispRLEL:
 ld a,(hl)			; get the next byte
 cp $91				; is it a run?
 jr z,DispRLERun	; then we need to decode the run
 ldi				; copy the byte, and update counters
DispRLEC:
 ld a,b				; check the low byte and
 or c				; the high byte for 0
 jr nz,DispRLEL		; if not, then we're not done either
 ret				; if it's zero, we're done
DispRLERun:
 inc hl				; move to the run value
 ld a,(hl)			; get the run value
 inc hl				; move to the run count
 push hl			; save source pointer
 ld h,(hl)			; get the run count
 ex de,hl			; swap source and destination pointers
DispRLERunL:
 ld (hl),a			; copy the byte
 inc hl				; increase destination pointer
 dec bc				; decrease byte count
 dec d				; decrease run count
 jr nz,DispRLERunL	; if we're not done, then loop
 ex de,hl			; swap pointers back
 pop hl				; recover source pointer
 inc hl				; advance the source pointer
 jr DispRLEC		; check to see if we should loop

titlepic:
 .db $91,$00,$b1,$03,$80,$00,$00,$0e,$91,$00,$0b,$07
 .db $c0,$00,$00,$1f,$91,$00,$0b,$07,$e0,$00,$00,$3f
 .db $91,$00,$0b,$07,$f0,$00,$00,$7f,$91,$00,$0b,$07
 .db $f8,$00,$00,$ff,$91,$00,$0b,$07,$fc,$00,$01,$ff
 .db $91,$00,$0b,$07,$fe,$00,$03,$ff,$91,$00,$0b,$07
 .db $ff,$00,$07,$ff,$91,$00,$0b,$07,$ff,$80,$0f,$ff
 .db $91,$00,$0b,$07,$ff,$c0,$1f,$ff,$91,$00,$0b,$07
 .db $cf,$e0,$3f,$9f,$91,$00,$0b,$07,$c7,$f0,$7f,$1f
 .db $91,$00,$0b,$07,$c3,$f8,$fe,$1f,$91,$00,$0b,$07
 .db $c1,$fd,$fc,$1f,$91,$00,$0b,$07,$c0,$ff,$f8,$1f
 .db $91,$00,$0b,$07,$c0,$7f,$f0,$1f,$91,$00,$0b,$07
 .db $c0,$3f,$e0,$1f,$91,$00,$0b,$07,$c0,$1f,$c0,$1f
 .db $00,$14,$91,$00,$09,$07,$c0,$0f,$80,$1f,$00,$08
 .db $91,$00,$09,$07,$c0,$07,$00,$1f,$00,$14,$91,$00
 .db $09,$07,$c0,$02,$00,$1f,$0f,$a0,$91,$00,$09,$07
 .db $c0,$00,$00,$1f,$1f,$c0,$91,$00,$09,$07,$c0,$00
 .db $00,$1f,$3f,$e0,$91,$00,$09,$07,$c0,$00,$00,$1f
 .db $3f,$e0,$91,$00,$09,$07,$c0,$00,$00,$1f,$3f,$e0
 .db $00,$00,$3f,$e0,$91,$00,$05,$07,$c0,$00,$00,$1f
 .db $3f,$e0,$00,$00,$7f,$f0,$91,$00,$05,$07,$c0,$00
 .db $00,$1f,$1f,$c0,$00,$01,$ff,$f0,$00,$fe,$91,$00
 .db $03,$07,$c0,$00,$00,$1f,$0f,$87,$fc,$03,$ff,$f8
 .db $03,$ff,$91,$00,$03,$07,$c0,$00,$00,$1f,$00,$0f
 .db $fe,$07,$ff,$fc,$07,$ff,$91,$00,$03,$07,$c0,$00
 .db $00,$1f,$00,$1f,$ff,$07,$e0,$3c,$07,$fe,$91,$00
 .db $03,$07,$c0,$00,$00,$1f,$07,$1f,$ff,$8f,$c0,$1c
 .db $1f,$80,$91,$00,$03,$07,$c0,$00,$00,$1f,$0f,$9f
 .db $ff,$8f,$e0,$3c,$1f,$91,$00,$04,$07,$c0,$00,$00
 .db $1f,$0f,$9f,$0f,$8f,$ff,$fc,$1f,$80,$91,$00,$03
 .db $07,$c0,$00,$00,$1f,$0f,$9f,$0f,$8f,$ff,$fc,$1f
 .db $f0,$91,$00,$03,$07,$c0,$00,$00,$1f,$0f,$9f,$0f
 .db $8f,$ff,$f8,$1f,$ff,$91,$00,$03,$07,$c0,$00,$00
 .db $1f,$0f,$9f,$0f,$8f,$ff,$f8,$07,$ff,$80,$00,$00
 .db $07,$c0,$00,$00,$1f,$0f,$9f,$0f,$8f,$ff,$e0,$01
 .db $ff,$c0,$00,$00,$07,$c0,$00,$00,$1f,$0f,$9f,$0f
 .db $8f,$c0,$00,$00,$ff,$e0,$00,$00,$07,$c0,$00,$00
 .db $1f,$0f,$9f,$0f,$8f,$80,$00,$00,$07,$e0,$00,$00
 .db $07,$c0,$00,$00,$1f,$0f,$9f,$0f,$8f,$c0,$00,$0e
 .db $03,$e0,$00,$00,$07,$c0,$00,$00,$1f,$0f,$9f,$0f
 .db $87,$ff,$f8,$1f,$c7,$e0,$00,$00,$07,$c0,$00,$00
 .db $1f,$0f,$9f,$0f,$87,$ff,$fc,$1f,$ff,$c0,$00,$00
 .db $07,$c0,$00,$00,$1f,$0f,$9f,$0f,$83,$ff,$fe,$0f
 .db $ff,$80,$00,$00,$07,$c0,$00,$00,$1f,$0f,$9f,$0f
 .db $81,$ff,$fc,$07,$ff,$91,$00,$03,$03,$80,$00,$00
 .db $0e,$07,$0e,$07,$00,$7f,$f8,$03,$fe,$91,$00,$82

;============================================================
; DrawMap -- draws an 8x16 tilemap  [Assembly Coder's Zenith]
;  input: HL = pointer to tilemap to draw
;  total: 34b/91529t (including ret and entire GridPutSprite)
;============================================================
DrawMap:
 ld de,$0000            ; start drawing at (0, 0)
DrawMapL:
 push hl                ; save map pointer
 ld l,(hl)              ; get the current tile
 ld h,0                 ; clear the upper byte
 add hl,hl              ; multiply by 8 (* 2)
 add hl,hl              ; * 4
 add hl,hl              ; * 8
 ld bc,Sprites          ; load the start of the sprites
 add hl,bc              ; add togehter to get correct sprite
 push de                ; save sprite draw location
 call GridPutSprite     ; draw the sprite
 pop de                 ; restore sprite draw location
 pop hl                 ; restore map pointer
 inc hl                 ; go to next tile
 inc e                  ; move location to the right
 bit 3,e                ; if the 5th bit (e = 16), we're done
 jr z,DrawMapL          ; only jump if the row isn't complete
 ld e,0                 ; draw at the left again
 inc d                  ; move location down a row
 bit 3,d                ; check if it's done (e = 8)
 ret nz                 ; return if we're done
 jr DrawMapL            ; jump back to the top of the loop

Map:
	.dw level

level:
	.db 0,0,0,0,0,0,0,0
	.db 0,0,0,0,0,0,0,0
	.db 0,0,0,0,0,0,0,0
	.db 0,0,0,0,0,0,0,0
	.db 0,0,0,0,0,0,0,0
	.db 0,0,0,0,0,0,0,0
	.db 0,0,0,0,0,0,0,0
	.db 0,0,0,0,0,0,0,0

temp:
	.db 0,0,0,0,0,0,0,0
	.db 0,0,0,0,0,0,0,0
	.db 0,0,0,0,0,0,0,0
	.db 0,0,0,0,0,0,0,0
	.db 0,0,0,0,0,0,0,0
	.db 0,0,0,0,0,0,0,0
	.db 0,0,0,0,0,0,0,0
	.db 0,0,0,0,0,0,0,0

blank:
	.db 01,01,01,01,01,01,01,01
	.db 01,01,01,01,01,01,01,01
	.db 01,01,01,01,01,01,01,01
	.db 01,01,01,01,01,01,01,01
	.db 01,01,01,01,01,01,01,01
	.db 01,01,01,01,01,01,01,01
	.db 01,01,01,01,01,01,01,01
	.db 01,01,01,01,01,01,01,01

Sprites:

Sprite00:
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000

Sprite01:
	.db %11111111
	.db %10000001
	.db %10000001
	.db %10000001
	.db %10000001
	.db %10000001
	.db %10000001
	.db %11111111

Sprite02:
	.db %11111111
	.db %10000001
	.db %10000001
	.db %10000001
	.db %10000001
	.db %10000001
	.db %10000001
	.db %11111111

Sprite03:
	.db %00000000
	.db %01111000
	.db %01111000
	.db %01111000
	.db %00001000
	.db %00001000
	.db %00011100
	.db %00111110

Sprite04:
	.db %00000000
	.db %01111000
	.db %01111000
	.db %01111000
	.db %00001000
	.db %00001000
	.db %00011100
	.db %00111110

Sprite05:
	.db %00000000
	.db %00111000
	.db %01000100
	.db %00000100
	.db %00001000
	.db %00010000
	.db %00000000
	.db %00010000

Sprite06:
	.db %00000000
	.db %00111000
	.db %01000100
	.db %00000100
	.db %00001000
	.db %00010000
	.db %00000000
	.db %00010000

Sprite07:
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000

Sprite08:
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000

Sprite09:
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000

Sprite0a:
	.db %11111111
	.db %10000001
	.db %10100101
	.db %10011001
	.db %10011001
	.db %10100101
	.db %10000001
	.db %11111111

Sprite0b:
	.db %00000000
	.db %01111000
	.db %01111000
	.db %01111000
	.db %00001000
	.db %11111111
	.db %00011100
	.db %00111110

Sprite0c:
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000

Sprite0d:
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000

Sprite0e:
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000

Sprite0f:
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000

Sprite10:
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000

Sprite11:
	.db %00000000
	.db %00001000
	.db %00011000
	.db %00001000
	.db %00001000
	.db %00001000
	.db %00001000
	.db %00011100

Sprite12:
	.db %00000000
	.db %00011100
	.db %00100010
	.db %00000010
	.db %00000100
	.db %00001000
	.db %00010000
	.db %00111110

Sprite13:
	.db %00000000
	.db %00111110
	.db %00000100
	.db %00001000
	.db %00000100
	.db %00000010
	.db %00100010
	.db %00011100

Sprite14:
	.db %00000000
	.db %00000100
	.db %00001100
	.db %00010100
	.db %00100100
	.db %00111110
	.db %00000100
	.db %00000100

Sprite15:
	.db %00000000
	.db %00111110
	.db %00100000
	.db %00111100
	.db %00000010
	.db %00000010
	.db %00100010
	.db %00011100

Sprite16:
	.db %00000000
	.db %00001100
	.db %00010000
	.db %00100000
	.db %00111100
	.db %00100010
	.db %00100010
	.db %00011100

Sprite17:
	.db %00000000
	.db %00111110
	.db %00000010
	.db %00000100
	.db %00001000
	.db %00010000
	.db %00010000
	.db %00010000

Sprite18:
	.db %00000000
	.db %00011100
	.db %00100010
	.db %00100010
	.db %00011100
	.db %00100010
	.db %00100010
	.db %00011100


.end
