;Megacar 1.1
;by Jonah Cohen <ComAsYuAre@aol.com>

#include "TI86.inc"

.org _asm_exec_ram

    nop
    jp start
    .dw 0
    .dw description

description:
    .db "Megacar 1.1 by Jonah Cohen",0

start:
    call _runIndicOff
    call _flushAllMenus

    ld l,0
do_rotate_table:
    ld h,rot_table/256
    ld a,l
    ld bc,$0800
do_rotate_table_loop:
    ld (hl),a
    inc h
    ld (hl),c
    inc h
    add a,a
    rl c
    djnz do_rotate_table_loop
    inc l
    jr nz,do_rotate_table

    ld hl,pane*256
    ld a,h
    ld de,pane*256+1
    ld bc,1023
    ld (hl),l
    ldir
    out (0),a


;draw bottom status area
    ld hl,$fef0
    push hl
fill_bottom:
    ld (hl),$ff
    inc hl
    bit 7,h
    jr nz,fill_bottom

    ld hl,$ff02
lines:
    ld (hl),%11111101
    ld de,7
    add hl,de
    ld (hl),%10111111
    ld e,9
    add hl,de
    jr nc,lines

    pop hl
indent:
    ld (hl),%01111111
    inc hl
    inc hl
    ld (hl),%11111000
    ld e,7
    add hl,de
    ld (hl),%00011111
    dec e
    add hl,de
    ld (hl),%11111110
    ld e,256-15
    add hl,de
    jr nc,indent

    set textInverse,(iy+textFlags)
    ld hl,race_messages
    ld b,6
race_messages_loop:
    push bc
    ld c,(hl)
    inc hl
    ld b,(hl)
    inc hl
    ld (_penCol),bc
    call _vputs
    pop bc
    djnz race_messages_loop

    ld (iy+textFlags),1<<textEraseBelow
    ld b,4
spacing_loop:
    push bc
    ld c,(hl)
    inc hl
    ld b,(hl)
    inc hl
    ld (_penCol),bc
    ld b,(hl)
    inc hl
disp_spaces:
    call _VPUTBLANK
    djnz disp_spaces
    pop bc
    djnz spacing_loop
    ld (iy+textFlags),b

    ld a,$fc
    ld (page),a
    call update_speed

    ld hl,-1
    ld de,pane*256-1
    ld bc,16*17
    lddr

    call _clrWindow

    ld hl,title_screen
    ld de,$fc53
    ld bc,author-title_screen
    ldir

    ld a,$fc
    out (0),a

    ld hl,$fdf0

do_car_anim:
    ld de,buffer1
    ld c,128
    ldir

    ld d,c          ;byte offset
    ld e,d
    ld c,128        ;bit offset
copy_car_loop:
    push bc


    ld hl,buffer1
    add hl,de
    push hl
    ld hl,author
    add hl,de
    ex de,hl
    ex (sp),hl

    ld b,8
copy_rows:
    push bc
    ld a,c
    cpl
    and (hl)
    ld (hl),a
    ex de,hl
    ld a,c
    ld bc,16
    and (hl)
    add hl,bc
    ex de,hl
    or (hl)
    ld (hl),a
    add hl,bc
    pop bc
    djnz copy_rows

    ld hl,buffer1
    ld de,buffer2
    ld c,128
    ldir

    pop de
    pop bc
    ld a,c
    rrc c
    jr nc,same_byte
    inc e
same_byte:
    push bc
    push de
    bit 4,e
    jr nz,no_car

get_bit_offset:
    inc b
    rlca
    jr nc,get_bit_offset
    ld a,b
    ld (shift_bit-1),a

    add hl,de
    ld ix,car
    ld b,8
copy_car:
    push bc
    push ix
    ld e,128
    push hl
    ld b,16
copy_car_column:
    ld a,e
    and (ix)
    ld d,a
    ld a,e
    and (ix+16)
    cpl
    push bc
    ld b,0
shift_bit:
    rrca
    rrc d
    djnz shift_bit
    pop bc    
    and (hl)
    or d
    ld (hl),a
    rrc e
    jr nc,same_sprite_byte
    inc ix
same_sprite_byte:
    rrc c
    jr nc,same_screen_byte
    inc hl
    ld a,l
    and $0f
    jr z,new_car_row
same_screen_byte:
    djnz copy_car_column
new_car_row:
    pop hl
    ld bc,16
    add hl,bc
    pop ix
    inc ix
    inc ix
    pop bc
    djnz copy_car

no_car:

    ld hl,buffer2
    ld de,$fdf0
car_row = $-2
    ld c,128
    ldir

    halt
    halt
    call _getcsc

    pop de
    pop bc


    cp K_EXIT
    jp z,quit
    or a
    jr nz,wait_got_key

    bit 4,e
    jp z,copy_car_loop

    xor a
    ld ($c001),a

    ;b=0 already
wait_for_key:
    halt
    call _getcsc
wait_got_key:
    cp K_EXIT
    jp z,quit
    or a
    jr nz,done_title
    djnz wait_for_key


done_title:
    xor a
    ld (default_search_name+2),a
    ld hl,default_search_name
    rst 20h
find_first_level:
    ld de,levelname
    call _MOVFROP1
    xor a
    call _findAlphaUp
    jr c,no_levels          ;no strings
    call check_level
    jp z,choose_level       ;valid level
    ld hl,_OP1+1
    ld de,levelname+1
    call _pstrCmp
    jr nz,find_first_level  ;keep searching if name is changing

no_levels:
    call _clrLCD
    call level_choose_rect
    ld hl,$0303
    ld (_curRow),hl
    ld hl,no_levels_found
    call _puts
    call getkey
    jp quit


check_level:
    rst 10h
    ret c
    call _DATA_SIZE_TO_DE
    call _GET_DATA_SIZE_DE_INC
    ld hl,1*256+'M'
    jp _cphlde

level_choose_rect:
    ld hl,$fcb1
    call draw_edge
    ld bc,38*256
rect_loop:
    push bc
    call level_clear_row
    pop bc
    djnz rect_loop
draw_edge:
    ld c,-1
level_clear_row:
    set 0,(hl)
    ld b,12
level_clear_loop:
    inc hl
    ld (hl),c
    djnz level_clear_loop
    inc l
    set 7,(hl)
    inc l
    inc hl
    inc l
    ret

next_level:
    ld bc,_findAlphaUp & $ff
    jr get_level

prev_level:
    ld bc,$ff00+ (_findAlphaDn & $ff)

get_level:
    ld a,b
    ld (default_search_name+2),a
    ld a,c
    ld (mode),a
get_level_loop:
    ld de,levelname
    call _MOVFROP1
    xor a
    call _findAlphaUp
mode = $-2
    ld hl,_OP1+1
    ld de,levelname+1
    call _pstrCmp
    jr z,reset_level
    call check_level
    jr nz,get_level_loop
    jr choose_level
reset_level:
    ld hl,default_search_name
    rst 20h
    jr get_level_loop


choose_level:
    ld de,levelname
    call _MOVFROP1


choose_levelname:
    ld hl,$fc00
    ld de,pane*256
    ld bc,1024
    ldir
    ld a,pane
    out (0),a

    call _getcsc

;copy level data
    call load_level
    call _SET_ABS_SRC_ADDR
    ld a,1
    ld hl,bestlap-$8000
    call _SET_ABS_DEST_ADDR
    xor a
    ld hl,width-bestlap         ;copy saved data
    call _MM_LDIR_SET_SIZE
    call _LOAD_ABS_SRC_ADDR


    ;ahl->lite86-compressed data
    ;extracts to width
    call $4633
    add a,$40
    out (6),a
    ld a,$41
    out (5),a
    ld de,width-$4000
decompress:
    ld a,(hl)
    inc hl
    bit 6,h
    call nz,inchls
    scf
    adc a,a
    .db $06
decompress_loop:
    add a,a
    jr z,decompress
    jr c,decompress_chunk
    ldi
    bit 6,h
    call nz,inchls
    jr decompress_loop
decompress_chunk:
    ld b,a
    ld c,$1f
    ld a,(hl)
    cp c
    jr z,decompress_done
    push bc 
    inc hl
    bit 6,h
    call nz,inchls
    ld b,(hl)
    inc hl
    bit 6,h
    call nz,inchls
    push hl
    ld l,b
    ld b,a
    or c
    rlca
    rlca
    rlca
    ld h,a
    ld a,b
    and c
    add a,3
    ld c,a
    ld b,0
    add hl,de
    ldir
    pop hl
    pop af
    jr decompress_loop

inchls:
    push af
    in a,(6)
    inc a
    out (6),a
    res 6,h
    pop af
    ret

decompress_done:
    ld a,$0d
    out (5),a
    call _RAM_PAGE_1

    ld hl,(height)
    ld h,0
    add hl,hl
    add hl,hl
    add hl,hl
    ld de,-8
    add hl,de
    ld (max_height),hl
    ld e,-39
    add hl,de
    ld (height_max),hl

    ld hl,(width)
    ld h,0
    ld a,l
    sub 16
    ld (row_offset),a
    ld a,l

    add hl,hl
    add hl,hl
    add hl,hl
    ld e,-8
    add hl,de
    ld (max_width),hl
    ld e,-120
    add hl,de
    ld (width_max),hl


;create multiplication routine
    ld b,8
create_row_start:
    dec b
    rla
    jr nc,create_row_start

    ld hl,mult_start
create_row:
    ld (hl),$29                 ;add hl,hl
    inc hl
    rla
    jr nc,create_row_next
    ld (hl),$19                 ;add hl,de
    inc hl
create_row_next:
    djnz create_row
    ld (hl),$c9                 ;ret


    ld hl,t_posts
    ld de,posts
    ld c,32
    ldir

    call disp_posts


    ld a,$fc
    ld (page),a
    call display_field

    ld hl,pane*256-1            ;<--could be moved outside loop
    ld de,$ffff
    ld bc,17*16
    lddr

    call disp_laps

    call level_choose_rect
    ld hl,$0302
    ld (_curRow),hl
    ld hl,browse_text
    call _puts
    ld b,4
disp_browse_text:
    ld d,(hl)
    inc hl
    ld e,(hl)
    inc hl
    ld (_penCol),de
    call _vputs
    djnz disp_browse_text

    ld hl,$0a02
    ld (_curRow),hl
    ld hl,_OP1+1
    call _putps

    ld a,$1d
    ld (_penRow),a
    ld hl,(bestrace)
    ld c,$4d
    push bc
    call disp_hl
    ld a,$58
    ld (_penCol),a
    ld hl,bestraceinit
    call _vputs

    ld a,$27
    ld (_penRow),a
    ld hl,(bestlap)
    pop bc
    call disp_hl
    ld a,$58
    ld (_penCol),a
    ld hl,bestlapinit
    call _vputs

    ld a,$fc
    out (0),a
choose_level_loop:
    call getkey
    cp K_EXIT
    jr nz,not_quit

quit:
    res 4,(iy+9)
    xor a
    ld (_asapvar+1),a
    jp _clrWindow


not_quit:
    sub K_LEFT
    jp z,prev_level
    dec a
    jp z,next_level
    cp K_SECOND-K_RIGHT
    jr z,start_level
    cp K_ENTER-K_RIGHT
    jr nz,choose_level_loop


start_level:
    ld a,pane
    ld (page),a

    ld hl,pane*256-1
    ld de,-1
    ld bc,17*16
    lddr
    call copy_status
    
    call disp_laps

    ld hl,speed
    ld b,6
    call _CLRLP         ;clear starting data
    ld hl,999
    ld (best),hl
    ld a,no_decel-disable_accel
    ld (disable_accel-1),a
    ld a,$28
    ld (skip_inc),a

;================================main loop

main_loop:
    halt
    call display_field
    call update_speed
    call copy_status

    halt
    ld hl,page
    ld a,(hl)
    out (0),a
    xor $08
    ld (hl),a

    call move_car
    call check_keys

    jr no_decel
disable_accel:

    ld a,(speed)
    or a
    jr nz,main_loop
    jp finished_race

no_decel:
    call inc_time
    call check_posts
    jr main_loop

;================================key handling

check_keys:
;   ld a,0
;turn_count = $-1
;   xor 1
;   ld (turn_count),a
;   jr z,no_turning
    ld a,%01111110
    out (1),a
    in a,(1)
    rra
    rra
    push af
    call nc,left
    pop af
    rra
    call nc,right
no_turning:
    ld a,%00111111
    out (1),a
    in a,(1)
    rla                 ;more
    jr c,no_shutdown
    push af
    call pause
    pop af
no_shutdown:
    rla                 ;exit
    pop hl
    jp nc,choose_levelname
    push hl
    ld d,a
    ld a,%01011111
    out (1),a
    in a,(1)
    rla
    ld b,-1
    jr nc,accel
    ld a,(disable_accel-1)
    or a
    ret z
;check if we're off road
    ld bc,0
car_xy = $-2
    ld hl,$0404
    add hl,bc
    ld b,h
    ld c,l
    push de
    ld a,(page)
    rra
    rra
    ld h,a
    call find_pixel
    pop de
    cpl
    rlca
    rlca
    rlca
    and 127
    ld (speed_bit),a
    ld a,(hl)
speed_bit = $+1
    bit 0,a
    jr nz,check_second      ;on road
    ld a,(speed)
    cp 30
    ld b,-1
    jr nc,accel             ;too fast
check_second:
    rl d                    ;2nd
    ret c
    ld b,2

accel:
    ld hl,speed
    ld a,b
    add a,(hl)
    cp 93
    ret nc
    ld (hl),a
    ret

left:
    ld a,-2
    jr change_angle
right:
    ld a,2
change_angle:
    ld hl,angle
    add a,(hl)
    ld (hl),a
    ret

pause:
    call getkey
    ld b,1
    sub K_PLUS
    jr z,adjust_contrast
    ld b,-1
    dec a
    ret nz
adjust_contrast:
    ld hl,_contrast
    ld a,b
    add a,(hl)
    cp 32
    jr nc,pause
    ld (hl),a
    out (2),a
    jr pause

;================================lap checking


sub_min:
    ld a,4
get_min:
    ld e,(hl)
    inc hl
    ld d,(hl)
    inc hl
    inc hl
    inc hl
    ex de,hl
    push hl
    or a
    sbc hl,bc
    pop hl
    ex de,hl
    jr nc,not_min
    ld b,d
    ld c,e
not_min:
    dec a
    jr nz,get_min

    ld a,4
subtract_min:
    dec hl
    dec hl
    dec hl
    ld d,(hl)
    dec hl
    ld e,(hl)
    ex de,hl
    or a
    sbc hl,bc
    ex de,hl
    inc hl
    ld (hl),d
    dec hl
    ld (hl),e
    dec a
    jr nz,subtract_min
    ret


check_posts:
    ld hl,posts
    ld de,x1
    ld bc,8
    ldir


    ld hl,last_x
    ld c,4
    ldir
    ld hl,car_x+1
    ldi
    ldi
    inc hl
    ldi
    ldi

    ex de,hl
    ld b,8
shift_posts:
    dec hl
    srl (hl)
    dec hl
    rr (hl)
    djnz shift_posts

    dec b               ;make it negative
    call sub_min
    
    inc hl
    inc hl
    ld b,-1             ;make it negative
    call sub_min
    
    dec hl
    ld b,8
copy_coords:
    ld a,(hl)
    or a
    ret nz              ;more than 256 pixels away
    inc hl
    inc hl
    djnz copy_coords


    ld hl,(y2)
    ld a,(x1)
    ld h,a
    call mult_s
    push hl
    ld hl,(y1)
    ld a,(x2)
    ld h,a
    call mult_s
    pop de
    or a
    sbc hl,de           ;x2 * y1 - x1 * y2
    push hl

    ld hl,(y1)
    ld a,(y2)
    sub l
    ld l,a
    ld a,(x3)
    ld h,a
    call mult_s
    push hl
    ld hl,(x2)
    ld a,(x1)
    sub l
    ld l,a
    ld a,(y3)
    ld h,a
    call mult_s
    pop de
    add hl,de
    pop de
    add hl,de           ;a1 * x3 + b1 * y3 + c1
    push hl
    push de

    ld hl,(y1)
    ld a,(y2)
    sub l
    ld l,a
    ld a,(x4)
    ld h,a
    call mult_s
    push hl
    ld hl,(x2)
    ld a,(x1)
    sub l
    ld l,a
    ld a,(y4)
    ld h,a
    call mult_s
    pop de
    add hl,de
    pop de
    add hl,de           ;a1 * x4 + b1 * y4 + c1
    pop de

    ld a,h
    or l
    jr z,skip_first_check
    ld a,d
    or e
    jr z,skip_first_check
    ld a,h
    xor d
    rla             ;check same sign
    ret nc
skip_first_check:

#if 0
    a1 = y2 - y1;  
    b1 = x1 - x2;  
    c1 = x2 * y1 - x1 * y2;  

    /* Compute r3 and r4. */  
    r3 = a1 * x3 + b1 * y3 + c1;  
    r4 = a1 * x4 + b1 * y4 + c1;  

    /* Check signs of r3 and r4.  If both point 3 and point 4 lie on  
     * same side of line 1, the line segments do not intersect.  
     */  

    if ( r3 != 0 &&  
         r4 != 0 &&  
         SAME_SIGNS( r3, r4 ))  
        return ( DONT_INTERSECT );  
#endif

    ld hl,(y4)
    ld a,(x3)
    ld h,a
    call mult_s
    push hl
    ld hl,(y3)
    ld a,(x4)
    ld h,a
    call mult_s
    pop de
    or a
    sbc hl,de           ;x4 * y3 - x3 * y4
    push hl

    ld hl,(y3)
    ld a,(y4)
    sub l
    ld l,a
    ld a,(x1)
    ld h,a
    call mult_s
    push hl
    ld hl,(x4)
    ld a,(x3)
    sub l
    ld l,a
    ld a,(y1)
    ld h,a
    call mult_s
    pop de
    add hl,de
    pop de
    add hl,de           ;a2 * x1 + b2 * y1 + c2
    push hl
    push de

    ld hl,(y3)
    ld a,(y4)
    sub l
    ld l,a
    ld a,(x2)
    ld h,a
    call mult_s
    push hl
    ld hl,(x4)
    ld a,(x3)
    sub l
    ld l,a
    ld a,(y2)
    ld h,a
    call mult_s
    pop de
    add hl,de
    pop de
    add hl,de           ;a2 * x2 + b2 * y2 + c2
    pop de

    ld a,h
    or l
    jr z,skip_second_check
    ld a,d
    or e
    jr z,skip_second_check
    ld a,h
    xor d
    rla             ;check same sign
    ret nc
skip_second_check:
#if 0
    
    /* Compute a2, b2, c2 */  

    a2 = y4 - y3;  
    b2 = x3 - x4;  
    c2 = x4 * y3 - x3 * y4;  

    /* Compute r1 and r2 */  

    r1 = a2 * x1 + b2 * y1 + c2;  
    r2 = a2 * x2 + b2 * y2 + c2;  

    /* Check signs of r1 and r2.  If both point 1 and point 2 lie  
     * on same side of second line segment, the line segments do  
     * not intersect.  
     */  

    if ( r1 != 0 &&  
         r2 != 0 &&  
         SAME_SIGNS( r1, r2 ))  
        return ( DONT_INTERSECT );  
#endif

    ld hl,(y3)
    ld a,(y4)
    sub l
    ld l,a
    ld a,(x2)
    ld h,a
    ld a,(x1)
    sub h
    ld h,a
    call mult_s
    push hl

    ld hl,(y1)
    ld a,(y2)
    sub l
    ld l,a
    ld a,(x4)
    ld h,a
    ld a,(x3)
    sub h
    ld h,a
    call mult_s
    pop de
    or a
    sbc hl,de
    ret z               ;collinear

#if 0
    /* Line segments intersect: compute intersection point.   
     */  

    denom = a1 * b2 - a2 * b1;  
    if ( denom == 0 )  
        return ( COLLINEAR );  
#endif

interception:
    ld hl,current_post
    ld a,(hl)
    inc a
    and 3
    ld (hl),a
    jr nz,not_new_lap
    ld a,pane
    out (0),a
    ld hl,laps
    dec (hl)
    push af

    ld hl,pane*256-(7*16)
    ld de,-7*16
    ld bc,5*16
    ldir

    call disp_laps

    ld de,(lap)
    ld hl,(best)
    call _cphlde
    jr c,no_best
    ex de,hl
    ld (best),hl
no_best:
    ld c,67
    call disp_hl
    pop af
    ld hl,0
    jr nz,finish_status
    xor a
    ld (disable_accel-1),a
    ld a,$18
    ld (skip_inc),a
    call inc_time
    ld hl,(lap)
finish_status:
    ld (lap),hl
    call copy_status

not_new_lap:
    ld hl,posts
    push hl
    ld de,posts+32
    ld bc,8
    ldir
    pop de
    ld c,32
    ldir

disp_posts:
    ld ix,posts
    ld bc,$0202
disp_posts_loop:
    ld d,(ix+3)
    ld e,(ix+2)
    call mult_row
    ld d,(ix+1)
    ld a,(ix+0)
    srl d
    rra
    srl d
    rr a
    srl d
    rra
    ld e,a
    add hl,de
    ld de,current_level
    add hl,de
    ld (hl),c
    ld de,4
    add ix,de
    djnz disp_posts_loop
    dec c
    ret z
    ld b,6
    jr disp_posts_loop

copy_status:
    ld hl,$fef0
    ld de,pane*256+$02f0
    ld bc,272
    ldir
    ret

disp_laps:
    ld hl,56*256+118
    ld (_penCol),hl
    ld a,(laps)
    add a,'0'
    jp _vputmap


;================================lap time

inc_time:
    ld a,0
    inc a
    and 3
    ld (inc_time+1),a
    ret nz

    ld hl,pane*256-(15*16)
    ld de,-15*16
    ld bc,5*16
    ldir

    call update_speed

    ld a,48
    ld (_penRow),a

    ld bc,(race)

    ld hl,(lap)
    ld de,999
    call _cphlde
skip_inc:
    jr z,no_inc

    inc bc
    ld (race),bc

    inc hl
    ld (lap),hl

no_inc:
    push bc
    ld c,67
    call disp_hl

    pop hl
    ld c,122
    jp disp_hl


;================================movement

move_car:
    ld hl,car_x+1
    ld de,last_x
    ldi
    ldi
    inc hl
    ldi
    ldi
    ld b,-1
    call accel              ;friction
    ld b,0
    ld a,(angle)
    push af
    call cos
    ex de,hl
    ld hl,(car_x)
    add hl,de
    ld a,(car_x+2)
    bit 7,d
    jr nz,x_neg
    adc a,b
    jr move_x
x_neg:
    ccf
    sbc a,b
move_x:
    ld d,a
    ld e,h
    ld a,l
    ld hl,0
max_width = $-2
    sbc hl,de
    jr c,no_x
    ld (car_x),a
    ld (car_x+1),de
no_x:
    pop af
    call sin
    ex de,hl
    ld hl,(car_y)
    add hl,de
    ld a,(car_y+2)
    bit 7,d
    jr nz,y_neg
    adc a,b
    jr move_y
y_neg:
    ccf
    sbc a,b
move_y:
    ld d,a
    ld e,h
    ld a,l
    ld hl,0
max_height = $-2
    sbc hl,de
    ret c
    ld (car_y),a
    ld (car_y+1),de
    ret

;================================display

update_speed:
    ld a,(speed)
    ld l,a
    ld h,0
    ld a,7
    call _divHLbyA
    inc l
    ld c,l
    ld hl,$ffe0
    ld (hl),%11111000
    inc hl
    ld (hl),%00011111
    ld de,%1111101111010000
    ld b,14

disp_speed:
    dec c
    jr nz,still_solid
    ld de,%1111100000010000
still_solid:
    push de
    ld de,-17
    add hl,de
    pop de
    ld (hl),d
    inc hl
    ld a,(hl)
    and %00001111
    or e
    ld (hl),a
    djnz disp_speed
    ret

disp_hl:            ;c=column, hl=number
    ld a,c
    sub 4
    ld c,a
    ld (_penCol),a
    push bc
    call _divHLby10
    add a,'0'
    call _vputmap
    pop bc
    ld a,h
    or l
    jr nz,disp_hl
    ret

display_field:
    ld de,0
height_max = $-2
    ld hl,(car_y+1)
    ld bc,-20
    add hl,bc
    jr c,not_min_y
    ld hl,0
not_min_y:
    call _cphlde
    jr nc,max_y
    ex de,hl
max_y:
    push de
    ld ixh,e
    call mult_row                ;multiply by row width
    push hl


    ld de,0
width_max = $-2
    ld hl,(car_x+1)
    ld c,-60
    add hl,bc
    jr c,not_min_x
    ld hl,0
not_min_x:
    call _cphlde
    jr c,max_x
    ex de,hl
max_x:
    pop de
    push hl

    ld a,l
    and 7
    add a,a
    add a,rot_table/256
    push af

    srl h
    rr l
    srl h
    rr l
    srl h
    rr l
    add hl,de                   ;offset in level
    ld de,current_level
    add hl,de
    ld de,$c100
    ld (tilemap_ptr),de
    ld a,7
    ld b,e
copy_tiles_loop:
    ld c,17
    ldir
    dec hl
    ld c,0
row_offset = $-1
    add hl,bc
    dec a
    jr nz,copy_tiles_loop


    ld bc,$fc00
page = $-1

    pop hl                  ;upper rotate byte
    ld d,h                  ;lower rotate byte
    inc h
    di
    exx

    ld a,ixh                ;vertical tile offset
    and 7
    ld b,a
    add a,tiles/256
    ld d,a                  ;de->sprites
    ld a,8
    sub b
    ld b,a                  ;how many rows in the current tile left

    ld c,47                 ;number of rows on screen

transfer_row:
    ld hl,0
tilemap_ptr = $-2
    ld e,(hl)
    inc l
    ld a,(de)
    exx
    ld e,a
    exx

#define tile ld e,(hl) \ inc l \ ld a,(de) \ exx \ ld l,a \ ld a,(de) \ or (hl) \ ld (bc),a \ ld e,l \ inc c \ exx

    tile            ;1
    tile            ;2
    tile            ;3
    tile            ;4
    tile            ;5
    tile            ;6
    tile            ;7
    tile            ;8
    tile            ;9
    tile            ;10
    tile            ;11
    tile            ;12
    tile            ;13
    tile            ;14
    tile            ;15

    ld e,(hl)
    ld a,(de)
    exx
    ld l,a
    ld a,(de)
    or (hl)
    ld (bc),a
    inc bc
    exx

    dec c
    jr z,done_tiles

    inc d           ;next sprite row
    dec b
    jp nz,transfer_row
    ld b,8
    ld d,tiles/256
    inc l
    ld (tilemap_ptr),hl
    jp transfer_row+3

done_tiles:
;display car
    ld hl,(car_x+1)
    pop de
    sbc hl,de
    ld b,l

    ld hl,(car_y+1)
    pop de
    sbc hl,de
    ld c,l

    ld (car_xy),bc

    ld ixh,car_sprites/256
    ld a,(angle)
    sub 8
    and %01110000
    scf
    rra
    ld ixl,a
    ld d,8
    ld a,(page)
    rrca
    rrca
    ld h,a

;putsprite
;bc=x,y, d=rows, h=page>>2, ix=sprite
    call find_pixel
    ld (putspritex-1),a
    ld b,d
    ld c,0
putsprite_loop:
    ex de,hl
    ld l,(ix)
    ld h,c
    inc ixl
    jr putspritex
putspritex:
    add hl,hl
    add hl,hl
    add hl,hl
    add hl,hl
    add hl,hl
    add hl,hl
    add hl,hl
    add hl,hl
    ex de,hl
    ld a,d
    xor (hl)
    ld (hl),a
    inc hl
    ld a,e
    xor (hl)
    ld (hl),a
    ld de,15
    add hl,de
    djnz putsprite_loop

    ei
    ret

find_pixel:
    ld a,c
    add a,a
    add a,a
    ld l,a
    ld a,b
    rra
    add hl,hl
    rra
    add hl,hl
    rra
    or l
    ld l,a
    ld a,b
    and 7
    ret

;================================finished race

finished_race:
    ld a,$fc
    out (0),a
    ld hl,(best)
    ld de,(bestlap)
    call _cphlde
    jr c,get_initials
    ld hl,(race)
    ld de,(bestrace)
    call _cphlde
    jp nc,choose_levelname


get_initials:
    call draw_rect

    ld hl,$0403
    ld (_curRow),hl
    ld hl,enter_initials
    call _puts

    ld hl,initials

get_string:
    push hl
get_highscore:
    call getkey
    cp K_DEL
    jr z,backspace
    cp K_ENTER
    jr z,init_done
    cp K_EXIT
    jr z,init_done
    ld hl,letters
    ld bc,26
    cpir                ;search for letter
    jr nz,get_highscore
    ld a,'A'
    add a,c
    ld c,a
    ld a,(_curCol)
    cp 17           ;3 letters for initials
    jr z,get_highscore
    pop hl
    ld (hl),c
    inc hl
    ld a,c
    call _putc
    jr get_string
backspace:
    ld hl,_curCol
    ld a,(hl)
    cp 14
    jr z,get_highscore
    dec (hl)
    ld a,' '
    call _putmap
    pop hl
    dec hl
    jr get_string
init_done:
    pop hl
    ld (hl),0               ;null terminator

    ld hl,(best)
    ld de,(bestlap)
    call _cphlde
    jr nc,not_best_lap
    ld (bestlap),hl
    ld de,bestlapinit
    call copy_initials
not_best_lap:
    ld hl,(race)
    ld de,(bestrace)
    call _cphlde
    jr nc,not_best_race
    ld (bestrace),hl
    ld de,bestraceinit
    call copy_initials
not_best_race:
    call load_level
    call _SET_ABS_DEST_ADDR
    ld a,1
    ld hl,bestlap-$8000
    call _SET_ABS_SRC_ADDR
    xor a
    ld hl,12
    call _MM_LDIR_SET_SIZE
    jp choose_levelname

draw_rect:
    ld hl,$fd52
    call draw_border
    ld bc,11*256
rectangle_loop:
    push bc
    call clear_row
    pop bc
    djnz rectangle_loop
draw_border:
    ld c,-1
clear_row:
    set 0,(hl)
    ld b,10
clear_loop:
    inc hl
    ld (hl),c
    djnz clear_loop
    inc hl
    set 7,(hl)
    ld c,5
    add hl,bc
    ret

load_level:
    ld hl,levelname
    rst 20h
    rst 10h
    ret c
    xor a
    ld hl,4
    add hl,de
    adc a,b
    ret

copy_initials:
    ld hl,initials
    ld bc,4
    ldir
    ret

getkey:
    halt
    call _getcsc
    or a
    jr z,getkey
    ret

;================================math routines

cos:
    add a,64
sin:
    ld l,a
    res 7,l
    ld h,sin_table/256
    ld l,(hl)
;   srl l
;   srl l
;   srl l
    rla
    jr nc,no_neg
    xor a
    sub l
    ld l,a
no_neg:
    ld a,(speed)
    call _SHRACC
    add a,a
    ld h,a


mult_s:         ;hl=h*l, signed
    ld a,h
    rla
    jr nc,h_pos
    xor a
    sub h
    ld h,a
h_pos:
    sbc a,a
    ld b,a
    ld a,l
    rla
    jr nc,l_pos
    xor a
    sub l
    ld l,a
l_pos:
    ld d,0
    ld a,b
    adc a,d
    push af

    ld e,l
    ld l,d

#define mul add hl,hl \ jr nc,$+3 \ add hl,de

    mul
    mul
    mul
    mul
    mul
    mul
    mul
    mul

    pop af
    ret z
    ex de,hl
    ld hl,0
    sbc hl,de
    ret

;================================data

.pad ($+255)&$ff00

sin_table:
    .db 00, 02, 03, 05, 06, 08, 09, 11, 12, 14, 16, 17, 19, 20, 22, 23
    .db 24, 26, 27, 29, 30, 32, 33, 34, 36, 37, 38, 39, 41, 42, 43, 44
    .db 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 56, 57, 58, 59
    .db 59, 60, 60, 61, 61, 62, 62, 62, 63, 63, 63, 64, 64, 64, 64, 64
    .db 64, 64, 64, 64, 64, 64, 63, 63, 63, 62, 62, 62, 61, 61, 60, 60
    .db 59, 59, 58, 57, 56, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46
    .db 45, 44, 43, 42, 41, 39, 38, 37, 36, 34, 33, 32, 30, 29, 27, 26
    .db 24, 23, 22, 20, 19, 17, 16, 14, 12, 11, 09, 08, 06, 05, 03, 02

car_sprites:
    .db %01100000
    .db %11110000
    .db %11111110
    .db %11111111
    .db %11111111
    .db %01111111
    .db %00001111
    .db %00000110

    .db %01110000
    .db %11111000
    .db %11111000
    .db %11111110
    .db %01111111
    .db %00011111
    .db %00011111
    .db %00001110

    .db %01111000
    .db %11111100
    .db %11111100
    .db %01111100
    .db %00111110
    .db %00111111
    .db %00111111
    .db %00011110

    .db %00111100
    .db %01111110
    .db %01111110
    .db %00111100
    .db %00111100
    .db %01111110
    .db %01111110
    .db %00111100

    .db %00011110
    .db %00111111
    .db %00111111
    .db %00111110
    .db %01111100
    .db %11111100
    .db %11111100
    .db %01111000

    .db %00001110
    .db %00011111
    .db %00011111
    .db %01111111
    .db %11111110
    .db %11111000
    .db %11111000
    .db %01110000

    .db %00000110
    .db %00001111
    .db %01111111
    .db %11111111
    .db %11111111
    .db %11111110
    .db %11110000
    .db %01100000

    .db %00000000
    .db %01100110
    .db %11111111
    .db %11111111
    .db %11111111
    .db %11111111
    .db %01100110
    .db %00000000



title_screen:
 .db $01,$04,$00,$04,$60,$61,$81,$00,$40,$42,$00,$10,$00
 .db $00,$00,$03,$0B,$26,$03,$07,$F3,$F3,$C3,$83,$E4,$44,$38,$F0,$00
 .db $00,$00,$43,$8F,$27,$0F,$AF,$FF,$F9,$CF,$87,$FD,$EC,$FB,$E0,$00
 .db $00,$00,$43,$CF,$FF,$9F,$FF,$FF,$FB,$FF,$E7,$FF,$FF,$FF,$C0,$00
 .db $00,$10,$63,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$E0,$00
 .db $00,$08,$63,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$F0,$00
 .db $00,$0C,$3B,$0F,$E1,$FF,$FF,$FF,$FF,$FF,$F0,$3F,$FF,$FF,$FC,$00
 .db $00,$0C,$BF,$07,$C1,$FF,$FF,$FF,$FF,$FF,$C0,$1F,$FF,$FF,$FE,$00
 .db $00,$0F,$FF,$07,$83,$FF,$FF,$FF,$FF,$FF,$80,$1F,$FF,$FF,$FE,$00
 .db $00,$07,$FF,$07,$03,$FF,$FF,$FF,$FF,$FF,$0F,$9F,$FF,$FF,$FF,$C0
 .db $00,$27,$FE,$07,$03,$C0,$7E,$00,$E0,$0E,$1F,$F8,$03,$C2,$3F,$80
 .db $00,$1F,$FE,$06,$03,$80,$38,$01,$E0,$0E,$3F,$F8,$03,$C0,$3E,$00
 .db $00,$0F,$FE,$20,$47,$1E,$38,$71,$FF,$8C,$3F,$FF,$E3,$C0,$3F,$E0
 .db $00,$0F,$FE,$20,$C6,$1E,$30,$F1,$FE,$0C,$3F,$FF,$83,$C7,$FF,$E0
 .db $00,$07,$FC,$20,$86,$00,$31,$E1,$E0,$0C,$3F,$F8,$03,$87,$FF,$00
 .db $00,$03,$FC,$71,$86,$1F,$F1,$E3,$C3,$0C,$3F,$F0,$C3,$8F,$FC,$00
 .db $03,$FF,$FC,$73,$8E,$3F,$F1,$E3,$87,$0C,$3F,$61,$C3,$8F,$FE,$00
 .db $01,$FF,$FC,$7F,$8E,$0E,$70,$03,$87,$1E,$08,$61,$C7,$8F,$FF,$C0
 .db $00,$7F,$F8,$7F,$0F,$00,$70,$03,$80,$1E,$00,$60,$07,$0F,$FF,$80
 .db $00,$3F,$F8,$FF,$0F,$80,$FC,$43,$C0,$1F,$80,$F0,$07,$1F,$FC,$00
 .db $00,$7F,$FF,$FF,$FF,$FF,$FF,$C7,$FF,$FF,$FF,$FF,$FF,$FF,$FC,$00
 .db $00,$07,$FF,$FF,$FF,$FF,$E0,$07,$FF,$FF,$FF,$FF,$FF,$FF,$FE,$00
 .db $00,$0F,$FF,$FF,$FF,$FF,$E0,$0F,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$00
 .db $03,$FF,$FF,$FF,$FF,$FF,$F8,$7F,$FF,$FF,$FF,$FF,$FF,$FF,$FD,$00
 .db $00,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FE,$00
 .db $00,$3F,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FE,$00
 .db $00,$07,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$00
 .db $00,$07,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$80
 .db $00,$3F,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FE,$C0
 .db $00,$0F,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FE,$00
 .db $00,$1F,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$00
 .db $01,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$00
 .db $07,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FC,$FF,$00
 .db $00,$7F,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FC,$71,$80
 .db $00,$3F,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FB,$FC,$70,$00
 .db $00,$FF,$FD,$FF,$FF,$EF,$FF,$FF,$FF,$FF,$FF,$FF,$F9,$E8,$20,$00
 .db $01,$FF,$F3,$FF,$FF,$CF,$FF,$FF,$FF,$FD,$FF,$FF,$D1,$C0,$00,$00
 .db $00,$3F,$C3,$FF,$FF,$8D,$FF,$FF,$3F,$3D,$FF,$F9,$91,$80,$00,$00
 .db $00,$07,$83,$CF,$C3,$08,$D3,$E3,$2E,$7C,$CF,$88,$00,$00,$00,$00
 .db $00,$00,$07,$8E,$02,$00,$81,$82,$08,$40,$8C


author:
 .db $00,$07,$FF,$FF,$9F,$FC,$7F,$FF,$E7,$F0,$FE,$7F,$FF,$FF,$FF,$00
 .db $00,$07,$FF,$FF,$6D,$BE,$67,$CC,$67,$E6,$CE,$7C,$F3,$FF,$FF,$80
 .db $00,$3F,$FF,$FF,$0D,$3E,$DB,$2F,$61,$CF,$B6,$1A,$4B,$FF,$FE,$C0
 .db $00,$0F,$FF,$FF,$6D,$7E,$9B,$6C,$6D,$CF,$36,$D0,$DB,$FF,$FE,$00
 .db $00,$1F,$FF,$FF,$6C,$FC,$92,$6B,$4B,$CD,$24,$B7,$9B,$FF,$FF,$00
 .db $01,$FF,$FF,$FE,$1C,$F1,$C6,$48,$4B,$E1,$8C,$B8,$93,$FF,$FF,$00
 .db $07,$FF,$FF,$FF,$FD,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FC,$FF,$00
 .db $00,$7F,$FF,$FF,$FB,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FC,$71,$80


car:
.db %00000111, %10000000
.db %00001000, %01000000
.db %01110000, %00111100
.db %10000000, %00000011
.db %10011000, %00011001
.db %01101111, %11101110
.db %00110100, %00110100
.db %00011000, %00011000
.db %00000111, %10000000
.db %00001111, %11000000
.db %01111111, %11111100
.db %11111111, %11111111
.db %11111111, %11111111
.db %01111111, %11111110
.db %00111100, %00111100
.db %00011000, %00011000


no_levels_found: .db "No levels found",0
browse_text:
            .db "Track:",0
            .db $1d,$14,"Best Race :",0
            .db $1d,$4f,"by",0
            .db $27,$14,"Best Lap :",0
            .db $27,$4f,"by",0


enter_initials: .db "Initials: ",0
race_messages:
            .db 15,48,"S",0
            .db 15,56,"P",0
            .db 28,48,"LTIME :",0
            .db 79,48,"RTIME :",0
            .db 28,56,"BEST :",0
            .db 79,56,"LAPS LEFT:",0
spaces:
            .db 53,48,15
            .db 53,56,15
            .db 104,48,19
            .db 116,56,7

default_search_name: .db $0c,1,0      

letters:
    .db $19,$21,$0a,$12,$1a,$22,$0b,$13,$1b,$23,$2b,$0c,$14
    .db $1c,$24,$2c,$0d,$15,$1d,$25,$2d,$0e,$16,$1e,$26,$2e


#define ONE_PLANE   ;not grayscale yet...

.pad ($+255)&$ff00
tiles:
#include "tiles.asm"


mult_row:
    srl d
    rr e
    srl d
    rr e
    srl d
    rr e
    ld h,d
    ld l,e
mult_start:


rot_table           =       $8100           ;4096
bestlap             =       rot_table+4096
bestlapinit         =       bestlap+2
bestrace            =       bestlapinit+4
bestraceinit        =       bestrace+2
width               =       bestraceinit+4
height              =       width+1
angle               =       height+1
car_x               =       angle+1
car_y               =       car_x+3
laps                =       car_y+3
t_posts             =       laps+1          ;32
current_level       =       t_posts+32

levelname           =       $+17
speed               =       levelname+11
current_post        =       speed+1
lap                 =       current_post+1
race                =       lap+2
best                =       race+2
last_x              =       best+2
last_y              =       last_x+2
initials            =       last_y+2
posts               =       initials+4          ;40

x1                  =       posts+40
y1                  =       x1+2
x2                  =       y1+2
y2                  =       x2+2
x3                  =       y2+2
y3                  =       x3+2
x4                  =       y3+2
y4                  =       x4+2

buffer1             =       (y4+2+15)&$fff0
buffer2             =       buffer1+128

pane                =       $f4                 ;uses 272 bytes below as well

.end
