;=================================================
; MAZE-3D RAYCASTING ENGINE Copyright(C)1998-1999
;-------------------------------------------------
; MazeLib.asm: part of Maze-3D source code
; Maze-3D Raycasting Engine version 0.5 beta
; Written by Clem Vasseur <darkclem@wanadoo.fr>
; Icarus Productions <http://icarus.ticalc.org>
;=================================================

#include "Maze3D.inc"

#DEFINE STRAFING
#UNDEF FULL_SCREEN
#DEFINE TEXTURE_MAP
#UNDEF SOLID_COLORS

TURN_SPEED		= 8
MAX_SCALE		= 200
SCREEN_HEIGHT	= 64
SLICE_RATIO 	= 32
MOVE_LIMIT		= 100
MOVE_VIEW		= 64

.org MazeExecRam

;=== GENERATE MASK TABLE ============================

GenMaskTable:
 ld hl,MaskTable+1
 ld a,$40
GenMaskLoop:
 ld (hl),a
 inc l
 rrca
 jr nc,GenMaskLoop

;=== CLEAR SCREENS ==================================

ClearScreens:
 ld hl,$F000
 ld de,$F001
 ld bc,4095
 ld (hl),l
 ldir

;=== RAYCASTING =====================================

RenderScreen:

 ld a,(GrayScrn)
 ld h,a

#ifndef SOLID_COLORS
 ld bc,$8000
 ld l,c
ClearLoop:
 ld (hl),c	;1
 inc l
 ld (hl),c	;2
 inc l
 ld (hl),c	;3
 inc l
 ld (hl),c	;4
 inc l
 ld (hl),c	;5
 inc l
 ld (hl),c	;6
 inc l
 ld (hl),c	;7
 inc l
 ld (hl),c	;8
 inc l
 ld (hl),c	;9
 inc l
 ld (hl),c	;10
 inc l
 ld (hl),c	;11
 inc l
 ld (hl),c	;12
 inc l
 ld (hl),c	;13
 inc l
 ld (hl),c	;14
 inc l
 ld (hl),c	;15
 inc l
 ld (hl),c	;16
 inc hl
 djnz ClearLoop

#else
 ld de,9

 ld a,(GrayScrn)
 ld h,a
#ifdef FULL_SCREEN
 ld l,0
#else
 ld l,4
#endif
 ld bc,$20FF
ClearLoop1:
 ld (hl),c	;1
 inc l
 ld (hl),c	;2
 inc l
 ld (hl),c	;3
 inc l
 ld (hl),c	;4
 inc l
 ld (hl),c	;5
 inc l
 ld (hl),c	;6
 inc l
 ld (hl),c	;7
 inc l
 ld (hl),c	;8
#ifndef FULL_SCREEN
 add hl,de
#else
 inc l
 ld (hl),c	;9
 inc l
 ld (hl),c	;10
 inc l
 ld (hl),c	;11
 inc l
 ld (hl),c	;12
 inc l
 ld (hl),c	;13
 inc l
 ld (hl),c	;14
 inc l
 ld (hl),c	;15
 inc l
 ld (hl),c	;16
 inc hl
#endif
 djnz ClearLoop1

 ld bc,$4000
ClearLoop2:
 ld (hl),c	;1
 inc l
 ld (hl),c	;2
 inc l
 ld (hl),c	;3
 inc l
 ld (hl),c	;4
 inc l
 ld (hl),c	;5
 inc l
 ld (hl),c	;6
 inc l
 ld (hl),c	;7
 inc l
 ld (hl),c	;8
#ifndef FULL_SCREEN
 add hl,de
#else
 inc l
 ld (hl),c	;9
 inc l
 ld (hl),c	;10
 inc l
 ld (hl),c	;11
 inc l
 ld (hl),c	;12
 inc l
 ld (hl),c	;13
 inc l
 ld (hl),c	;14
 inc l
 ld (hl),c	;15
 inc l
 ld (hl),c	;16
 inc hl
#endif
 djnz ClearLoop2

 ld bc,$20FF
ClearLoop3:
 ld (hl),c	;1
 inc l
 ld (hl),c	;2
 inc l
 ld (hl),c	;3
 inc l
 ld (hl),c	;4
 inc l
 ld (hl),c	;5
 inc l
 ld (hl),c	;6
 inc l
 ld (hl),c	;7
 inc l
 ld (hl),c	;8
#ifndef FULL_SCREEN
 add hl,de
#else
 inc l
 ld (hl),c	;9
 inc l
 ld (hl),c	;10
 inc l
 ld (hl),c	;11
 inc l
 ld (hl),c	;12
 inc l
 ld (hl),c	;13
 inc l
 ld (hl),c	;14
 inc l
 ld (hl),c	;15
 inc l
 ld (hl),c	;16
 inc hl
#endif
 djnz ClearLoop3
#endif

InitRaycaster:
#ifdef DRAW_OBJECTS
 xor a
 ld (OBJ_flag),a
#endif

#ifdef FULL_SCREEN
 ld a,%11000000
#else
 ld a,%10000000
#endif
 ld (ColMask),a
 ld (ColMask2),a

 xor a
 ld (Col),a
#ifndef FULL_SCREEN
 ld a,4
#endif
 ld (ScrnCol),a

 ld a,(Pov)
 add a,32

NewCol:
 call RayCast
 call DrawSlice

RenderEnd:
 ld a,(ColMask)
 rrca
#ifdef FULL_SCREEN
 rrca
#endif
 ld (ColMask),a
 ld (ColMask2),a
 jr nc,SkipIncScrnCol
 ld hl,ScrnCol
 inc (hl)
SkipIncScrnCol:
 ld a,0
Ray = $-1
 dec a
 ld hl,Col
 inc (hl)
 bit 6,(hl)
 jr z,NewCol

;=== SWAP SCREENS ==================================

WaitVBL:
 di
 exx
 ld a,b
 exx
 ei
 dec a
 jr nz,WaitVBL
 di
 ld a,(GrayScrn)
 xor 8
 ld (GrayScrn),a
 exx
 ld a,d
 xor 8
 ld d,a
 exx
 ei

;=== TEST KEYS =====================================

KeyLoop:
 halt
 ld a,%00111110
 out (1),a
 nop \ nop
 nop \ nop
 in a,(1)
 ld b,a
 ld a,$FF
 out (1),a
 xor b
 jr z,KeyLoop

TestForward:
 bit 3,b
 call z,RayMove

TestLeft:
 ld a,(Pov)
 bit 1,b
 jr nz,TestRight
#ifdef STRAFING
 bit 5,b
 jr nz,SkipStrafingLeft
StrafingLeft:
 add a,64
 ld (Pov),a
 call RayMove
 set 5,b
 ld a,(Pov)
 sub 64+TURN_SPEED
SkipStrafingLeft:
#endif
 add a,TURN_SPEED

TestRight:
 bit 2,b
 jr nz,TestBackward
#ifdef STRAFING
 bit 5,b
 jr nz,SkipStrafingRight
StrafingRight:
 sub 64
 ld (Pov),a
 call RayMove
 set 5,b
 ld a,(Pov)
 add a,64+TURN_SPEED
SkipStrafingRight:
#endif
 sub TURN_SPEED

TestBackward:
 add a,128
 ld (Pov),a
 bit 0,b
 call z,RayMove
 ld a,(Pov)
 sub 128
 ld (Pov),a

TestOther:
 bit 6,b
 ret z
 bit 5,b
 jp nz,RenderScreen

;=== OPEN A DOOR ===================================

OpenDoor:
 ld a,(ColTable)
 ld d,a
 ld a,(RowTable)
 ld e,a
 ld a,(Pov)
 cp 32
 jr nc,Sup32
 inc d
 jr DoorEnd
Sup32:
 cp 96
 jr nc,Sup96
 inc e
 jr DoorEnd
Sup96:
 cp 160
 jr nc,Sup160
 dec d
 jr DoorEnd
Sup160:
 cp 224
 jr nc,Sup224
 dec e
 jr DoorEnd
Sup224:
 inc d
DoorEnd:
 call GetMap
 bit 7,a
 jp z,RenderScreen
 ld (hl),0
 jp RenderScreen

;=== MOVE ==========================================

RayMove:
 push bc

MoveY:
 ld a,(Pov)
 call Sin64
 ld hl,(RowWorld)
 add hl,de
 push hl

 ld a,(Pov)
 and %10000000
 jr nz,MoveDown

MoveUp:
 ld bc,MOVE_LIMIT
 add hl,bc
 ld e,h

 ld a,(ColTable)
 ld d,a
 call GetMap
 jr nz,MoveBlockUpY

 ld hl,(ColWorld)
 ld bc,MOVE_VIEW
 add hl,bc
 ld d,h
 call GetMap
 jr nz,MoveBlockUpY

 ld hl,(ColWorld)
 ld bc,-MOVE_VIEW
 add hl,bc
 ld d,h
 call GetMap
 jr z,DoMoveY

MoveBlockUpY:
 pop hl
 ld a,(RowTable)
 ld h,a
 ld l,-MOVE_LIMIT
 push hl
 jr DoMoveY

MoveDown:
 ld bc,-MOVE_LIMIT
 add hl,bc
 ld e,h

 ld a,(ColTable)
 ld d,a
 call GetMap
 jr nz,MoveBlockDownY

 ld hl,(ColWorld)
 ld bc,MOVE_VIEW
 add hl,bc
 ld d,h
 call GetMap
 jr nz,MoveBlockDownY

 ld hl,(ColWorld)
 ld bc,-MOVE_VIEW
 add hl,bc
 ld d,h
 call GetMap
 jr z,DoMoveY

MoveBlockDownY:
 pop hl
 ld a,(RowTable)
 ld h,a
 ld l,MOVE_LIMIT
 push hl

DoMoveY:
 pop hl
 ld (RowWorld),hl

MoveX:
 ld a,(Pov)
 call Cos64
 ld hl,(ColWorld)
 add hl,de
 push hl

 ld a,(Pov)
 and %11000000
 cp %10000000
 jr z,MoveLeft
 cp %01000000
 jr z,MoveLeft

MoveRight:
 ld bc,MOVE_LIMIT
 add hl,bc
 ld d,h

 ld a,(RowTable)
 ld e,a
 call GetMap
 jr nz,MoveBlockRightX

 ld hl,(RowWorld)
 ld bc,MOVE_VIEW
 add hl,bc
 ld e,h
 call GetMap
 jr nz,MoveBlockRightX

 ld hl,(RowWorld)
 ld bc,-MOVE_VIEW
 add hl,bc
 ld e,h
 call GetMap
 jr z,DoMoveX

MoveBlockRightX:
 pop hl
 ld a,(ColTable)
 ld h,a
 ld l,-MOVE_LIMIT
 push hl
 jr DoMoveX

MoveLeft:
 ld bc,-MOVE_LIMIT
 add hl,bc
 ld d,h

 ld a,(RowTable)
 ld e,a
 call GetMap
 jr nz,MoveBlockLeftX

 ld hl,(RowWorld)
 ld bc,MOVE_VIEW
 add hl,bc
 ld e,h
 call GetMap
 jr nz,MoveBlockLeftX

 ld hl,(RowWorld)
 ld bc,-MOVE_VIEW
 add hl,bc
 ld e,h
 call GetMap
 jr z,DoMoveX

MoveBlockLeftX:
 pop hl
 ld a,(ColTable)
 ld h,a
 ld l,MOVE_LIMIT
 push hl

DoMoveX:
 pop hl
 ld (ColWorld),hl

 pop bc
 ret

;=== GET A TILE NUMBER FROM THE MAP ================

GetMap:			; D = col
 ld a,31		; E = row
 cp d
 ret c
 cp e
 ret c
 xor e
 ld b,a
 ld h,Level/256
 ld l,d
 ld c,0
 sra b
 rr c
 sra b
 rr c
 sra b
 rr c
 add hl,bc
 ld a,(hl)
 or a
 ret

;=== MULTIPLICATION ROUTINE ========================

Mult:		; AHL = A x DE
 ld c,0
 ld h,c
 ld l,c
 or a
 rla
 jr nc,Mult1
 ld h,d
 ld l,e
Mult1:
 add hl,hl
 rla
 jr nc,Mult2
 add hl,de
 adc a,c
Mult2:
 add hl,hl
 rla
 jr nc,Mult3
 add hl,de
 adc a,c
Mult3:
 add hl,hl
 rla
 jr nc,Mult4
 add hl,de
 adc a,c
Mult4:
 add hl,hl
 rla
 jr nc,Mult5
 add hl,de
 adc a,c
Mult5:
 add hl,hl
 rla
 jr nc,Mult6
 add hl,de
 adc a,c
Mult6:
 add hl,hl
 rla
 jr nc,Mult7
 add hl,de
 adc a,c
Mult7:
 add hl,hl
 rla
 ret nc
 add hl,de
 adc a,c
 ret

;=== INCLUDE FILES =================================

#include "MazeRay.asm"
#include "MazeDraw_tex.asm"
#include "Trigo.asm"
#include "Mapping.inc"

#if ($ > $A000)
 .error MazeLIB too big
#endif

.end
