;=============================================
;      GRAYSCALE HANDLER by CLEM VASSEUR
;            <darkclem@wanadoo.fr>
;=============================================

IntAddr		= $8080	; custom interrupt handler
IntTable	= $8100	; 257 byte vector table
TopStack	= $FC00	; top of current stack
NewStack	= $F000	; new hardware stack
GrayScrn1	= $F800	; gray screen 1
GrayScrn2	= $F000	; gray screen 2

;=============================================

OpenGray:
	di
	ld de,IntAddr
	ld hl,IntHandler
	ld bc,IntEnd-IntHandler
	ldir
	ld hl,IntTable
	ld a,h
	ld i,a
	ld de,IntTable+1
	ld (hl),IntAddr/256
	inc b
	ldir
	exx
	ld bc,$0303
	ld de,$3C04
	exx
	ld a,$F0
	ld (GrayScrn),a
	ld hl,NewStack-TopStack
	add hl,sp
	ld sp,hl
	ld hl,TopStack
	ld de,NewStack
	inc b
	lddr
	im 2
	ei
	ret

CloseGray:
	di
	im 1
	ld a,$3C
	out (0),a
	ld hl,TopStack-NewStack
	add hl,sp
	ld sp,hl
	ld hl,NewStack
	ld de,TopStack
	ld bc,256
	lddr
	ld iy,_Flags
	ei
	ret

IntHandler:
	ex af,af'
	exx
	ld a,d
	djnz IntDisp
	sub e
	ld b,c
IntDisp:
	out (0),a
	in a,(3)
	and 1
	add a,9
	out (3),a
	ld a,11
	out (3),a
	ex af,af'
	exx
	ei
	reti
IntEnd:

.end
