;=================================================
; MAZE-3D RAYCASTING ENGINE Copyright(C)1998-1999
;-------------------------------------------------
; MazeRay.asm: part of Maze-3D source code
; Maze-3D Raycasting Engine version 0.5 beta
; Written by Clem Vasseur <darkclem@wanadoo.fr>
; Icarus Productions <http://icarus.ticalc.org>
;=================================================

RayCast:
 ld (Ray),a
 and %11000000
 cp %11000000
 jp z,down_right
 cp %10000000
 jp z,down_left
 cp %01000000
 jp z,up_left


;=== UP - RIGHT ====================================

up_right:

VertIntersections0:
 ld a,(Ray)
 call Tan
 ld (RowInc0),de

 ld a,(ColWorld)
 cpl
 call Mult
 ld e,h
 ld d,a
 ld hl,(RowWorld)
 add hl,de

 ld a,(ColTable)
 ld d,a
VertInterRight0:
 inc d
 ld e,h
 push hl
 call GetMap
 pop hl
 jr c,VertInterInfinite0
 jr nz,VertInterDist0
 ld bc,0
RowInc0 = $-2
 add hl,bc
 jr nc,VertInterRight0

VertInterInfinite0:
 ld hl,$FFFF
 jr VertInterEnd0

VertInterDist0:
 ld (VertNb),a

 ld a,l
 ld (VertTexCol),a

 ld h,d
 ld l,0
 ld de,(ColWorld)
;or a
 sbc hl,de

 ld a,(Ray)
 push hl
 call CosInv
 pop hl

 call mul
 ld h,c
 ld l,d
VertInterEnd0:
 ld (VertDist),hl

HorzIntersections0:
 ld a,(Ray)
 call TanInv
 ld (ColInc0),de

 ld a,(RowWorld)
 cpl
 call Mult
 ld e,h
 ld d,a
 ld hl,(ColWorld)
 add hl,de

 ld a,(RowTable)
 ld e,a
HorzInterUp0:
 inc e
 ld d,h
 push hl
 call GetMap
 pop hl
 jr c,HorzInterInfinite0
 jr nz,HorzInterDist0
 ld bc,0
ColInc0 = $-2
 add hl,bc
 jr nc,HorzInterUp0

HorzInterInfinite0:
 ld hl,$FFFF
 ld (HorzDist),hl
 jp FindWallDist

HorzInterDist0:
 ld (HorzNb),a

 ld a,l
 ld (HorzTexCol),a

 ld h,e
 ld l,0
 ld de,(RowWorld)
;or a
 sbc hl,de

 ld a,(Ray)
 push hl
 call SinInv
 pop hl

 call mul
 ld h,c
 ld l,d
 ld (HorzDist),hl

 jp FindWallDist

;=== UP - LEFT =====================================

up_left:

VertIntersections1:
 ld a,(Ray)
 call Tan
 ld (RowInc1),de

 ld a,(ColWorld)
 call Mult
 ld e,h
 ld d,a
 ld hl,(RowWorld)
 add hl,de

 ld a,(ColTable)
 ld d,a
VertInterLeft1:
 dec d
 ld e,h
 push hl
 call GetMap
 pop hl
 jr c,VertInterInfinite1
 jr nz,VertInterDist1
 ld bc,0
RowInc1 = $-2
 add hl,bc
 jr nc,VertInterLeft1

VertInterInfinite1:
 ld hl,$FFFF
 jr VertInterEnd1

VertInterDist1:
 ld (VertNb),a

 ld a,l
 ld (VertTexCol),a

 ld hl,(ColWorld)
 ld e,$FF
;or a
 sbc hl,de
 push hl

 ld a,(Ray)
 call CosInv
 pop hl

 call mul
 ld h,c
 ld l,d
VertInterEnd1:
 ld (VertDist),hl

HorzIntersections1:
 ld a,(Ray)
 call TanInv
 ld (ColInc1),de

 ld a,(RowWorld)
 cpl
 call Mult
 ld e,h
 ld d,a
 ld hl,(ColWorld)
 or a
 sbc hl,de

 ld a,(RowTable)
 ld e,a
HorzInterUp1:
 inc e
 ld d,h
 push hl
 call GetMap
 pop hl
 jr c,HorzInterInfinite1
 jr nz,HorzInterEnd1
 ld bc,0
ColInc1 = $-2
 sbc hl,bc
 jr nc,HorzInterUp1

HorzInterInfinite1:
 ld hl,$FFFF
 ld (HorzDist),hl
 jp FindWallDist

HorzInterEnd1:
 ld (HorzNb),a

 ld a,l
 ld (HorzTexCol),a

 ld h,e
 ld l,0
 ld de,(RowWorld)
;or a
 sbc hl,de

 ld a,(Ray)
 push hl
 call SinInv
 pop hl

 call mul
 ld h,c
 ld l,d
 ld (HorzDist),hl

 jp FindWallDist

;=== DOWN - LEFT ===================================

down_left:

VertIntersections2:
 ld a,(Ray)
 call Tan
 ld (RowInc2),de

 ld a,(ColWorld)
 call Mult
 ld e,h
 ld d,a
 ld hl,(RowWorld)
 or a
 sbc hl,de

 ld a,(ColTable)
 ld d,a
VertInterLeft2:
 dec d
 ld e,h
 push hl
 call GetMap
 pop hl
 jr c,VertInterInfinite2
 jr nz,VertInterDist2
 ld bc,0
RowInc2 = $-2
 sbc hl,bc
 jr nc,VertInterLeft2

VertInterInfinite2:
 ld hl,$FFFF
 ld (VertDist),hl
 jr VertInterEnd2

VertInterDist2:
 ld (VertNb),a

 ld a,l
 ld (VertTexCol),a

 ld hl,(ColWorld)
 ld e,$FF
;or a
 sbc hl,de

 ld a,(Ray)
 push hl
 call CosInv
 pop hl

 call mul
 ld h,c
 ld l,d
VertInterEnd2:
 ld (VertDist),hl

HorzIntersections2:
 ld a,(Ray)
 call TanInv
 ld (ColInc2),de

 ld a,(RowWorld)
 call Mult
 ld e,h
 ld d,a
 ld hl,(ColWorld)
 or a
 sbc hl,de

 ld a,(RowTable)
 ld e,a
HorzInterDown2:
 dec e
 ld d,h
 push hl
 call GetMap
 pop hl
 jr c,HorzInterInfinite2
 jr nz,HorzInterDist2
 ld bc,0
ColInc2 = $-2
 sbc hl,bc
 jr nc,HorzInterDown2

HorzInterInfinite2:
 ld hl,$FFFF
 ld (HorzDist),hl
 jp FindWallDist

HorzInterDist2:
 ld (HorzNb),a

 ld a,l
 ld (HorzTexCol),a

 ld hl,(RowWorld)
 ld d,e
 ld e,$FF
;or a
 sbc hl,de
 push hl

 ld a,(Ray)
 call SinInv
 pop hl

 call mul
 ld h,c
 ld l,d
 ld (HorzDist),hl

 jp FindWallDist

;=== DOWN - RIGHT ==================================

down_right:

VertIntersections3:
 ld a,(Ray)
 call Tan
 ld (RowInc3),de

 ld a,(ColWorld)
 cpl
 call Mult
 ld e,h
 ld d,a
 ld hl,(RowWorld)
 or a
 sbc hl,de

 ld a,(ColTable)
 ld d,a
VertInterRight3:
 inc d
 ld e,h
 push hl
 call GetMap
 pop hl
 jr c,VertInterInfinite3
 jr nz,VertInterDist3
 ld bc,0
RowInc3 = $-2
 sbc hl,bc
 jr nc,VertInterRight3

VertInterInfinite3:
 ld hl,$FFFF
 jr VertInterEnd3

VertInterDist3:
 ld (VertNb),a

 ld a,l
 ld (VertTexCol),a

 ld h,d
 ld l,0
 ld de,(ColWorld)
;or a
 sbc hl,de

 ld a,(Ray)
 push hl
 call CosInv
 pop hl

 call mul
 ld h,c
 ld l,d
VertInterEnd3:
 ld (VertDist),hl

HorzIntersections3:
 ld a,(Ray)
 call TanInv
 ld (ColInc3),de

 ld a,(RowWorld)
 call Mult
 ld e,h
 ld d,a
 ld hl,(ColWorld)
 add hl,de

 ld a,(RowTable)
 ld e,a
HorzInterDown3:
 dec e
 ld d,h
 push hl
 call GetMap
 pop hl
 jr c,HorzInterInfinite3
 jr nz,HorzInterDist3
 ld bc,0
ColInc3 = $-2
 add hl,bc
 jr nc,HorzInterDown3

HorzInterInfinite3:
 ld hl,$FFFF
 ld (HorzDist),hl
 jr FindWallDist

HorzInterDist3:
 ld (HorzNb),a

 ld a,l
 ld (HorzTexCol),a

 ld hl,(RowWorld)
 ld d,e
 ld e,$FF
;or a
 sbc hl,de

 ld a,(Ray)
 push hl
 call SinInv
 pop hl

 call mul
 ld h,c
 ld l,d
 ld (HorzDist),hl

;=== FIND DISTANCE TO WALL =========================

FindWallDist:
 ld de,0
Col = $-2
 ld hl,FishbowlTable
 add hl,de
 ld a,(hl)

 ld hl,0
HorzDist = $-2
 ld de,0
VertDist = $-2
 or a
 sbc hl,de
 jr c,HorzInfVert

VertInfHorz:
 ld hl,(VertDist)
#ifdef FULL_SCREEN
 srl h
 rr l
#endif
 call DivSlice
 ld l,0
VertTexCol = $-1
 ld c,0
VertNb = $-1
 push af
 xor a
 ld (ColorFlag),a
 pop af
 ret

HorzInfVert:
 ld hl,(HorzDist)
#ifdef FULL_SCREEN
 srl h
 rr l
#endif
 call DivSlice
 ld l,0
HorzTexCol = $-1
 ld c,0
HorzNb = $-1
 push af
 ld a,1
 ld (ColorFlag),a
 pop af
 ret

; C = Tile number
; A = Slice height (even: bit 0 = 0)
; L = Column of the wall to display (0-255)

DivSlice:
 ex de,hl
 call Mult
 ld c,h
 ld b,a
 ld hl,256*SLICE_RATIO

 ld de,0
 ld a,16
DivL:
 add hl,hl
 ex de,hl
 adc hl,hl
 sbc hl,bc
 jr nc,DivS
 add hl,bc
 dec e
DivS:
 ex de,hl
 inc l
 dec a
 jr nz,DivL

 ld a,l
 res 0,a
 ret

#if 0
DivSlice:
 add hl,hl
 ex de,hl
 call Mult
 ld e,h
 ld d,a
 ld a,SLICE_RATIO
 ld c,0
DivACbyDE:
 ld h,c
 ld l,c
 ld b,16
 and a
DivLoop:
 rl c
 rla
 adc hl,hl
 sbc hl,de
 jr nc,DivSkip
 add hl,de
DivSkip:
 ccf
 djnz DivLoop
 rl c
;rla
 ld a,c
 res 0,a
 ret
#endif

mul:	; BCDE = HLxDE
 ld c,h
 ld a,l

 ld b,0
 ld h,b
 ld l,b

 add a,a
 jr nc,mul2
 add hl,de
 adc a,b
mul2:
 add hl,hl
 adc a,a
 jr nc,mul3
 add hl,de
 adc a,b
mul3:
 add hl,hl
 adc a,a
 jr nc,mul4
 add hl,de
 adc a,b
mul4:
 add hl,hl
 adc a,a
 jr nc,mul5
 add hl,de
 adc a,b
mul5:
 add hl,hl
 adc a,a
 jr nc,mul6
 add hl,de
 adc a,b
mul6:
 add hl,hl
 adc a,a
 jr nc,mul7
 add hl,de
 adc a,b
mul7:
 add hl,hl
 adc a,a
 jr nc,mul8
 add hl,de
 adc a,b
mul8:
 add hl,hl
 adc a,a
 jr nc,mul9
 add hl,de
 adc a,b

mul9:
 push hl
 ld h,b
 ld l,b
 ld b,a
 ld a,c
 ld c,h

 add a,a
 jr nc,mul20
 add hl,de
 adc a,c
mul20:
 add hl,hl
 adc a,a
 jr nc,mul21
 add hl,de
 adc a,c
mul21:
 add hl,hl
 adc a,a
 jr nc,mul22
 add hl,de
 adc a,c
mul22:
 add hl,hl
 adc a,a
 jr nc,mul23
 add hl,de
 adc a,c
mul23:
 add hl,hl
 adc a,a
 jr nc,mul24
 add hl,de
 adc a,c
mul24:
 add hl,hl
 adc a,a
 jr nc,mul25
 add hl,de
 adc a,c
mul25:
 add hl,hl
 adc a,a
 jr nc,mul26
 add hl,de
 adc a,c
mul26:
 add hl,hl
 adc a,a
 jr nc,mul27
 add hl,de
 adc a,c

mul27:
 pop de
 ld c,a
 ld a,d
 add a,l
 ld d,a
 ld a,b
 adc a,h
 ld h,a
 ld a,c
 adc a,0
 ld b,a
 ld c,h
 ret

.end
